<?php
//addons/bridge/bridges/_template.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2012 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

# Bridge Installation Type - TEMPLATE
# Use this as a starting point for creating a new bridge.  Search/replace "template" with what the file
# name is going to be.

require_once ADDON_DIR.'bridge/util.php';

class bridge_spbas extends addon_bridge_util {
	//What is shown in the admin for the bridge type
	var $name = 'SPBAS';
	
	//Settings to save, syntax is array ( setting_name => input OR checkbox
	//if input, on the settings page, it will use an input field.  If checkbox, 
	//well you get the idea.
	var $settings = array(
		'api_url' => 'input',
		'api_key' => 'input'
	);
	
	//Description & other various info about each setting.
	var $setting_desc = array (
		'api_url' => array (
				'name' => 'API URL',
				'desc' => 'The full URL to the SPBAS API, something like http://example.com/spbas/api/index.php',
			),
		'api_key' => array (
				'name' => 'API Secret Key',
				'desc' => 'The API Secret key, which will be listed in <strong>SPBAS Admin -> Settings -> Advanced</strong>',
			),
	);
	
	/**
	 * This function is called to display additional information about the bridge type.  Special instructions or caveats need to be placed here.
	 *
	 * @return string The description of this installation type.
	 */
	function getDescription(){
		$description = 'This is the SPBAS installation type.';
		return $description;
	}	
	
	/**
	 * This function is called automatically during initialization of the bridge addon.  It should
	 * be used to store settings passed, to a local var or something.
	 *
	 * @param array $settings Associative array, like array (setting_name => setting_value)
	 */
	function setSettings($settings){
		//You can use any method to keep track of settings during this session,
		//below is an example of re-using the member variable "$settings" to store
		//the settings, but you can just as easily store them in a var named config or 
		//whatever.
		if (!is_array($settings)){
			return false; //oops, settings are no good
		}
		foreach ($settings as $key => $value){
			//set each setting, checking to make sure its all good first..
			if (isset($this->settings[$key])){
				//valid setting, so set that setting.
				$this->settings[$key] = $value;
			}
		}
	}
	
	/**
	 * Optional, function to export users from the local install, to the bridge install.
	 *
	 * @return boolean True if successful, false otherwise.
	 */
	function exportUsers() {
		//get all users in the given range, return array of user data.
		geoAdmin::m('Fake export run, all users exported from local to bridge.',geoAdmin::NOTICE);
		return true;
	}
	
	/**
	 * Optional, function to log a user in.  Optional because logging in a user may not be
	 * possible in some circumstances.
	 *
	 * @param array $vars Associative array containing info about user logging in
	 */
	function session_login($vars) {
		//include_once 'api.php';
		//include_once 'functions.php';
		
		$user = geoUser::getUser($vars['userid']);
		if (!$user) {
			//could not get info
			return;
		}
		
		// from m3_configuration.php
		// ---------------------------------------------------------------------------------
		$api_home=$this->settings['api_url'];//'http://your-domain.com/spbas/api/index.php';
		$api_key=$this->settings['api_key']; // SPBAS Admin -> Settings -> Advanced
		
		// the API call
		// ---------------------------------------------------------------------------------
		$module='customer_areas';
		$task='loginshare';
		
		// Required Data
		// ---------------------------------------------------------------------------------
		$data=array();
		$data['email']=$user->email;
		//plain-text password passed in with $vars
		$data['password']=$vars['password'];
		
		// Optionial Data
		// ---------------------------------------------------------------------------------
		$data['create_user']=true; // true/false - true creates the user if not exists
		$data['first_name']=$user->firstname;
		$data['last_name']=$user->lastname;
		$data['username']=$user->username;
		$data['create_customer']=true; // true/false - true creates the customer record too
		$data['company_name']=$user->company_name? $user->company_name : $user->firstname.' '.$user->lastname;
		$data['include_address']=false; // true/false - true returns the primary customer address
		
		$result=spbasApi::query($api_home, $api_key, $module, $task, $data, false);
		
		// Something didn't go right! Die here and print the errors.
		if (!$result['session_id']) {
			//pr($result['errors']);
		}
		
		// Start the session! SPBAS must be on the same server for this to work.
		setcookie('customer_session', $result['session_id'], time()+2538000);
		
		// The full response. Note that the password is simply md5('plain text password').
		//pr($result);
	}
	
	function user_edit($user_info){
		//make sure any username / email changes go into effect
		$this->_updateUsername($user_info['old_username'],$user_info['username'],$user_info['email']);
		
		if ($user_info['password'] && $user_info['old_password']!==$user_info['password']) {
			//update the password
			if (!$this->_updatePassword($user_info['old_username'], $user_info['password'])) {
				//could not update the password?
				return false;
			}
		}
		
		$password = ($user_info['password'])? $user_info['password'] : $user_info['old_password'];
		$this->session_login(array('userid'=>$user_info['user_id'], 'password'=>$password));
		
		return true;
	}
	
	private function _updateUsername ($old_user, $new_user, $email)
	{
		// from m3_configuration.php
		// ---------------------------------------------------------------------------------
		$api_home=$this->settings['api_url'];//'http://your-domain.com/spbas/api/index.php';
		$api_key=$this->settings['api_key']; // SPBAS Admin -> Settings -> Advanced
	
		// the API call
		// ---------------------------------------------------------------------------------
		$module='customer_areas';
		$task='custom_update_user';
	
		// Required Data
		// ---------------------------------------------------------------------------------
		$data=array();
		$data['old_username']=$old_user;
		//plain-text password passed in with $vars
		$data['username']=$new_user;
		$data['email'] = $email;
	
		$result=spbasApi::query($api_home, $api_key, $module, $task, $data, false);
		//see what happened...
		if ($result['errors']) {
			//pr($result['errors']);
			return false;
		}
		return true;
	}
	
	private function _updatePassword ($email, $oldPass, $newPass)
	{
		$session_id = $this->_getSessionId($email, $oldPass);
		if (!$session_id) {
			//can't get session
			return false;
		}
		
		// from m3_configuration.php
		// ---------------------------------------------------------------------------------
		$api_home=$this->settings['api_url'];//'http://your-domain.com/spbas/api/index.php';
		$api_key=$this->settings['api_key']; // SPBAS Admin -> Settings -> Advanced
		
		// the API call
		// ---------------------------------------------------------------------------------
		$module='customer_areas';
		$task='change_password';
		
		// Required Data
		// ---------------------------------------------------------------------------------
		$data=array();
		$data['session_id']=$session_id;
		//plain-text password passed in with $vars
		$data['current_password']=$oldPass;
		$data['new_password'] = $newPass;
		
		$result=spbasApi::query($api_home, $api_key, $module, $task, $data, false);
		//see what happened...
		if ($result['errors']) {
			//pr($result['errors']);
			return false;
		}
		return true;
	}
	
	private function _getSessionId ($email, $pass)
	{
		// from m3_configuration.php
		// ---------------------------------------------------------------------------------
		$api_home=$this->settings['api_url'];//'http://your-domain.com/spbas/api/index.php';
		$api_key=$this->settings['api_key']; // SPBAS Admin -> Settings -> Advanced
		
		// the API call
		// ---------------------------------------------------------------------------------
		$module='customer_areas';
		$task='login';
		
		// Required Data
		// ---------------------------------------------------------------------------------
		$data=array();
		$data['email']=$email;
		//plain-text password passed in with $vars
		$data['password']=$pass;
		
		$result=spbasApi::query($api_home, $api_key, $module, $task, $data, false);
		
		// Something didn't go right! Die here and print the errors.
		if (!$result['session_id']) {
			//pr($result['errors']);
			return false;
		}
		
		return $result['session_id'];
	}
}


/**
 * Remote API handler
*/
class spbasApi
{
	/**
	 * Fetch data from the API
	 *
	 * @param array $request
	 * @param boolean $debug
	 * @param boolean $clean_response
	 * @return string
	 */
	function fetch($request, $debug=false, $clean_response=false)
	{
		if (defined('USE_LOCAL_API')&&USE_LOCAL_API)
		{
			include API_PATH.'configuration.php';

			// load the localization
			$conf['localization']=localization::get_group((x('language')?x('language'):'en-us'), 'api', 'api');

			// validate the module
			if (!$request['mod']) {
				return 'invalid';
			}
			if (!in_array($request['mod'], $valid_mods)) {
				return 'invalid';
			}

			// load the module dependencies
			mod::dependencies($request['mod'], false, ADMIN_PATH);

			// validate the task
			if (!$request['task']) {
				die('invalid');
			}
			if (!in_array($request['task'], $valid_tasks)) {
				return w('task_not_found');
			}

			// validate the API key
			if (!$request['api_key']&&!in_array($request['task'], $no_api_key_required)) {
				return 'invalid';
			}

			// Route the request
			$bypass_api_record_state=$_POST;
			$_POST=$request;
			if (file_exists($m3=API_PATH."modules/{$request['mod']}/{$request['task']}.php"))
			{
				$errors=$buffer=array();
				include $m3;

				$_POST=$bypass_api_record_state;

				// deliver the data
				return spbasApi::wrap_package($buffer, count($errors));
			}

			$_POST=$bypass_api_record_state;
		}

		if (!function_exists('curl_init'))
		{
			return spbasApi::fetch_fsockopen($request, $debug, $clean_response);
		}

		$api_handler=$request['api_handler'];
		unset($request['api_handler']);
		$request=spbasApi::commands_to_string($request);

		$link=curl_init();
		curl_setopt($link, CURLOPT_URL, $api_handler);
		curl_setopt($link, CURLOPT_POSTFIELDS, $request);
		curl_setopt($link, CURLOPT_VERBOSE, 0);
		curl_setopt($link, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($link, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($link, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($link, CURLOPT_MAXREDIRS, 6);
		curl_setopt($link, CURLOPT_CONNECTTIMEOUT, 30);
		curl_setopt($link, CURLOPT_TIMEOUT, 15); // 60
		$results=curl_exec($link);

		if ($results=='invalid'&&strlen($results)==7) {
			die('Invalid Access');
		}

		if ($debug)
		{
			curl_close($link);
			spbasApi::pr($results);
		}

		if ($clean_response)
		{
			curl_close($link);
			return $results;
		}

		if (curl_errno($link)>0)
		{
			curl_close($link);
			return false;
		}
		curl_close($link);

		return $results;
	}

	/**
	 * Fetch data from the API
	 *
	 * @param array $request
	 * @param boolean $debug
	 * @param boolean $clean_response
	 * @return string
	 */
	function fetch_fsockopen($request, $debug=false, $clean_response=false)
	{
		$parts=parse_url($request['api_handler']);

		$fp=@fsockopen($parts['host'], 80, $errno, $errstr, 10); // was 5
		if (!$fp) {
			return '';
		}

		$request=spbasApi::commands_to_string($request);

		$header="POST {$parts['path']} HTTP/1.0\r\n";
		$header.="Host: {$parts['host']}\r\n";
		$header.="Content-type: application/x-www-form-urlencoded\r\n";
		$header.="User-Agent: SPBAS (http://www.spbas.com)\r\n";
		$header.="Content-length: ".@strlen($request)."\r\n";
		$header.="Connection: close\r\n\r\n";
		$header.=$request;

		$results='';
		@fputs($fp, $header);
		while (!@feof($fp)) {
			$results.=@fgets($fp, 1024);
		}
		@fclose ($fp);

		$results=explode("\r\n\r\n", $results);

		return $results[1];
	}

	/**
	 * Debug helper - prints a formatted array
	 *
	 * @param array $stack The array to display
	 * @param boolean $stop_execution
	 * @return string
	 */
	function pr($stack, $stop_execution=true)
	{
		$formatted='<pre>'.var_export((array)$stack, 1).'</pre>';

		if ($stop_execution) {
			die($formatted);
		}

		return $formatted;
	}

	/**
	 * Grab the IP address of the end user
	 *
	 * @param array $_SERVER
	 * @return mixed
	 */
	function capture_remote()
	{
		if ($_SERVER["HTTP_X_FORWARDED_FOR"]) {
			return $_SERVER["HTTP_X_FORWARDED_FOR"];
		}

		if ($_SERVER["HTTP_CLIENT_IP"]) {
			return $_SERVER["HTTP_CLIENT_IP"];
		}

		return $_SERVER["REMOTE_ADDR"];
	}

	/**
	 * Turn an array into a string suitable for fetching data.
	 *
	 * @param array $commands
	 * @return string
	 */
	function commands_to_string($commands)
	{
		if (!is_array($commands)) {
			return false;
		}

		$string='';
		foreach ($commands as $key => $value)
		{
			if ($string) {
				$string.='&';
			}
			$value=urlencode($value); // added v1.9.1

			$string.="{$key}={$value}";
		}

		return $string;
	}

	/**
	 * Parse XML using eval() to compile the resulting array
	 *
	 * @param string XML to parse
	 * @return array parsed XML
	 */
	function parse_xml_by_eval($xml)
	{
		$parser=@xml_parser_create('');
		@xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		@xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		@xml_parse_into_struct($parser, $xml, $values, $tags);
		@xml_parser_free($parser);

		$hash_stack=array();

		foreach($values as $key => $val)
		{
			switch ($val['type'])
			{
				case "open":
					array_push($hash_stack, $val['tag']);
					break;

				case "close":
					array_pop($hash_stack);
					break;

				case "complete":
					array_push($hash_stack, $val['tag']);

					# uncomment to see what this function is doing
					# echo("\$ret[" . implode($hash_stack, "][") . "] = '{$val[value]}';\n");

					eval("\$ret[".implode($hash_stack, "][")."]='{$val[value]}';");
					array_pop($hash_stack);
					break;
			}
		}

		return $ret;
	}

	/**
	 * Base64 decode the data and unserialize it back to an array.
	 *
	 * @param array $package
	 * @return array
	 */
	function unwrap_package($xml)
	{
		$xml=@spbasApi::parse_xml_by_eval($xml);
		// if ($xml['response']['error_count']>0) { return array(); }

		return unserialize(base64_decode($xml['response']['data']));
	}

	/**
	 * Serialize an array, wrap it in base64 and XML for delivery.
	 *
	 * @param array $message
	 * @param integer $error_count
	 * @return string XML
	 */
	function wrap_package($array, $error_count)
	{
		$package=base64_encode(serialize($array));

		return "<response><error_count>{$error_count}</error_count>\n<data>{$package}</data></response>\n";
	}

	/**
	 * Ensure the template is not ran out of scope
	 *
	 * @return boolean|string boolean on success; string on failure
	 */
	function ran_directly()
	{
		return (!class_exists('template'))?die('This file cannot be ran directly'):true;
	}

	/**
	 * Issue a command via the API
	 *
	 * @param string $api_home
	 * @param string $api_key
	 * @param string $mod
	 * @param string $task
	 * @param array $extras
	 * @param boolean $debug
	 * @return array
	 */
	function query($api_home, $api_key, $mod, $task, $extras=array(), $debug=false)
	{
		$request=array();
		$request['api_handler']=$api_home;
		$request['api_key']=$api_key;
		$request['mod']=$mod;
		$request['task']=$task;
		if ($_COOKIE['change_language']) {
			$request['language']=$_COOKIE['change_language'];
		}
		$request=array_merge($request, (array)$extras);

		$xml=spbasApi::fetch($request, $debug);
		return spbasApi::unwrap_package($xml); // pr($request);
	}
}
