<?php
//addons/featured_slider/admin.php

/**************************************************************************
Featured Slider (Version: 1.1.0)
Addon Created by BluFyre Media
Copyright (c) 2011 BluFyre Media
All rights reserved
http://www.blufyremedia.com
See license attached to distribution or at http://www.blufyremedia.com/legal/product-license
The most recent of which, at the time of purchase and install, will be deemed the valid and binding license agreement.
**************************************************************************/


class addon_featured_slider_admin extends addon_featured_slider_info
{

	public function init_pages ()
	{

		menu_page::addonAddPage('addon_featured_slider_settings','','General Settings','featured_slider');
		menu_page::addonAddPage('addon_featured_slider_availabledata','','Available Data Tags','featured_slider');

	}
	
	var $default_addon_text = array
	(
		'title_text' => array (
			'name' => 'Title Text',
			'desc' => 'This is the title text that is displayed for the featured listings box.', 			
			'type' => 'input',
			'default' => 'Featured Listings'
		),
		'closing_text' => array (
			'name' => 'Closing Text',
			'desc' => 'This is the text before the time left.',
			'type' => 'input',
			'default' => 'Closing in'
		),
		'listed_text' => array (
			'name' => 'Start Date Text',
			'desc' => 'This is the text for the listing start time.',
			'type' => 'input',
			'default' => 'Listed on'
		),
		'end_text' => array (
			'name' => 'End Date Text',
			'desc' => 'This is the text for the listing end time.',
			'type' => 'input',
			'default' => 'Listing Ends'
		),
		'price_text' => array (
			'name' => 'Price Text',
			'desc' => 'This is the text displayed before the current price.',
			'type' => 'input',
			'default' => 'Price:'
		),
		'buyprice_text' => array (
			'name' => 'Buy Now Price Text',
			'desc' => 'This is the text displayed before the buy now price.',
			'type' => 'input',
			'default' => 'Buy Now Price:'
		),		
		'bids_text' => array (
			'name' => 'Bids Text',
			'desc' => 'This is the text displayed after the number of bids.',
			'type' => 'input',
			'default' => 'Bids'
		),
		'seconds_text' => array (
			'name' => 'Seconds Text',
			'desc' => 'This is the text displayed for seconds remaining.',
			'type' => 'input',
			'default' => 'sec'
		),
		'minutes_text' => array (
			'name' => 'Minutes Text',
			'desc' => 'This is the text displayed for minutes remaining.',
			'type' => 'input',
			'default' => 'mins'
		),
		'hours_text' => array (
			'name' => 'Hours Text',
			'desc' => 'This is the text displayed for hours remaining.',
			'type' => 'input',
			'default' => 'hrs'
		),
		'days_text' => array (
			'name' => 'Days Text',
			'desc' => 'This is the text displayed for days remaining.',
			'type' => 'input',
			'default' => 'days'
		),
		'weeks_text' => array (
			'name' => 'Weeks Text',
			'desc' => 'This is the text displayed for weeks remaining.',
			'type' => 'input',
			'default' => 'weeks'
		),
		'closed' => array (
			'name' => 'Closed Text',
			'desc' => 'This is the text displayed for expired listings.',
			'type' => 'input',
			'default' => 'Closed'
		),
		'no_results' => array (
			'name' => 'No Results Text',
			'desc' => 'This is the text that is displayed when no results are found.',
			'type' => 'input',
			'default' => 'We\'re sorry. No items were Found.'
		)
	);

	public function init_text($language_id)
	{
		return $this->default_addon_text;
	}
	

	public function display_addon_featured_slider_settings ()
	{

		$reg = geoAddon::getRegistry($this->name);
		$tpl_vars = array();
		$tpl_vars['adminMsgs'] = geoAdmin::m();
		$tpl_vars['include_css'] = $reg->get('include_css','');
		$tpl_vars['include_js'] = $reg->get('include_js','');
		$tpl_vars['title_type'] = $reg->get('title_type','');
		$tpl_vars['listing_type'] = $reg->get('listing_type','');
		$tpl_vars['listing_status'] = $reg->get('listing_status','');		
		$tpl_vars['per_frame'] = $reg->get('per_frame','');
		$tpl_vars['num_frames'] = $reg->get('num_frames','');
		$tpl_vars['thumb_width'] = $reg->get('thumb_width','');
		$tpl_vars['title_length'] = $reg->get('title_length','');
		$tpl_vars['block_height'] = $reg->get('block_height','');
		$tpl_vars['transition_effect'] = $reg->get('transition_effect','');
		$tpl_vars['transition_speed'] = $reg->get('transition_speed','');
		$tpl_vars['transition_auto'] = $reg->get('transition_auto','');
		$tpl_vars['transition_delay'] = $reg->get('transition_delay','');
		$tpl_vars['transition_loop'] = $reg->get('transition_loop','');

		geoView::getInstance()->setBodyVar($tpl_vars)->setBodyTpl('admin/general_settings.tpl','featured_slider');
	}
	

	public function update_addon_featured_slider_settings()
	{		
		
		//get an instance of the admin object, so we can add a message to display to the user.
		$admin = geoAdmin::getInstance();
		
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$reg = geoAddon::getRegistry($this->name);
		$reg->include_css = $_POST['include_css'];
		$reg->include_js = $_POST['include_js'];
		$reg->title_type = $_POST['title_type'];
		$reg->listing_type = $_POST['listing_type'];
		$reg->listing_status = $_POST['listing_status'];
		$reg->per_frame = $_POST['per_frame'];
		$reg->num_frames = $_POST['num_frames'];
		$reg->thumb_width = $_POST['thumb_width'];
		$reg->title_length = $_POST['title_length'];
		$reg->block_height = $_POST['block_height'];
		$reg->transition_effect = $_POST['transition_effect'];
		$reg->transition_speed = $_POST['transition_speed'];
		$reg->transition_auto = $_POST['transition_auto'];
		$reg->transition_delay = $_POST['transition_delay'];
		$reg->transition_loop = $_POST['transition_loop'];
		$reg->save();

		//lets add a message that will be displayed to the user.
		$admin->message("Settings successfully saved.");
		
		//return true, since settings were saved.
		return true;
	}

	public function display_addon_featured_slider_availabledata ()
	{
		geoView::getInstance()->setBodyVar($tpl_vars)->setBodyTpl('admin/available_data_tags.tpl','featured_slider');
	}
	
}