<?php
//addons/featured_slider/tags.php

/**************************************************************************
Featured Slider (Version: 1.1.0)
Addon Created by BluFyre Media
Copyright (c) 2011 BluFyre Media
All rights reserved
http://www.blufyremedia.com
See license attached to distribution or at http://www.blufyremedia.com/legal/product-license
The most recent of which, at the time of purchase and install, will be deemed the valid and binding license agreement.
**************************************************************************/

require_once ADDON_DIR . 'featured_slider/info.php';

class addon_featured_slider_tags extends addon_featured_slider_info
{


	public function listings_auto_add_head ()
	{

		$reg = geoAddon::getRegistry('featured_slider');
		$view = geoView::getInstance();
		
		if ($reg->include_css == '1') {
			$view->addCssFile(geoTemplate::getURL('css','addon/featured_slider/featured_slider_styles.css'));
		}

		if ($reg->include_js == '1') {
			$view->addJScript('addons/featured_slider/js/core.js');
		}

		return '';

	}


	public function listings ()
	{

		$db = DataAccess::getInstance();
		$site = Singleton::getInstance('geoSite');
		include GEO_BASE_DIR . 'get_common_vars.php';
		$messages = $db->get_text(true);
		$no_image_url = ($messages[500795])? geoTemplate::getUrl('',$messages[500795]) : '';

		$seo = geoAddon::getUtil('SEO');

		$msgs = geoAddon::getText('blufyre','featured_slider');
		$reg = geoAddon::getRegistry('featured_slider');

		$tpl = new geoTemplate('addon','featured_slider');


		$tpl->assign('title',$msgs['title_text']);
		$tpl->assign('page_note',$msgs['page_note']);
		$tpl->assign('no_results_msg',$msgs['no_results']);
		$tpl->assign('closing',$msgs['closing_text']);
		$tpl->assign('price_text',$msgs['price_text']);			
		$tpl->assign('buyprice_text',$msgs['buyprice_text']);
			
		$tpl->assign('title_length',$reg->title_length);
		$tpl->assign('block_height',$reg->block_height.'px');	
		$tpl->assign('thumb_height',$reg->thumb_width.'px');

		$tpl->assign('block_width',100 / $reg->per_frame.'%');
		$tpl->assign('container_width',100 * $reg->num_frames.'%');
		$tpl->assign('frame_width',100 / $reg->num_frames.'%');
		$tpl->assign('per_frame',$reg->per_frame);

		if ($reg->num_frames > '1') {
			$tpl->assign('use_controls',true);
		}	

		$tpl->assign('transition_speed',$reg->transition_speed);
		$tpl->assign('transition_delay',$reg->transition_delay);

		if ($reg->transition_effect == '1') {
			$tpl->assign('transition_effect','scroll');
		} elseif ($reg->transition_effect == '2') {
			$tpl->assign('transition_effect','fade');
		}

		if ($reg->transition_auto == '1') {
			$tpl->assign('transition_auto',true);
		} elseif ($reg->transition_auto == '2') {
			$tpl->assign('transition_auto',false);
		}

		if ($reg->transition_loop == '1') {
			$tpl->assign('transition_loop',true);
			$num_frames = $reg->num_frames + 1;
			$tpl->assign('container_width',100 * $num_frames.'%');
			$tpl->assign('frame_width',100 / $num_frames.'%');
		} elseif ($reg->transition_loop == '2') {
			$tpl->assign('transition_loop',false);
		}

		$limit = $reg->per_frame * $reg->num_frames;
		



		// BUILD QUERY & SQL
		

		$classTable = geoTables::classifieds_table;

		$query = $db->getTableSelect(DataAccess::SELECT_BROWSE, true);
		$query->where("$classTable.`live` = 1",'live');
	
		if ($reg->listing_type == '1') {
			$query->where("$classTable.`item_type` != 1");
		} elseif ($reg->listing_type == '2') {
			$query->where("$classTable.`item_type` = 1");
		}
	

		// GET CATEGORY IDs IF BROWSING CATEGORY OR LISTING


		$catID = (int)geoView::getInstance()->category_id;
		$listingID = (int)geoView::getInstance()->classified_id;

		if (is_int($listingID) && $listingID != '0') {
			$listing  = geoListing::getListing($listingID);
			$catID = $listing->category;
		}

		if ($catID != '0') {
			$catInStmt = $db->get_sql_in_statement($catID);
			$query->where("$classTable.`category` $catInStmt");

		}



		if ($reg->listing_status == '0') {
			$query->where("($classTable.`featured_ad` = '1' OR $classTable.`featured_ad_2` = '1' OR $classTable.`featured_ad_3` = '1' OR $classTable.`featured_ad_4` = '1' OR $classTable.`featured_ad_5` = '1')");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '1') {
			$query->where("$classTable.`featured_ad` = 1");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '2') {
			$query->where("$classTable.`featured_ad_2` = 1");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '3') {
			$query->where("$classTable.`featured_ad_3` = 1");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '4') {
			$query->where("$classTable.`featured_ad_4` = 1");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '5') {
			$query->where("$classTable.`featured_ad_5` = 1");
			$query->order("RAND()");
		} elseif ($reg->listing_status == '6') {
			$query->order("$classTable.`viewed` DESC");
		}

		$query->limit($limit);

		$browse_result = $db->Execute(''.$query);

		unset($query,$classTable);


		// BUILD TITLE MATCH RESULTS

			if ($browse_result->RecordCount() < 1) {

				$tpl->assign('is_results',false);

			} else {

				$tpl->assign('is_results',true);
				

				$l = 0;

				while ($show_listings = $browse_result->FetchRow()) {


					foreach ($show_listings as $key => $value) {
						$listings[$l][$key] = geoString::fromDB($show_listings[$key]);
					}

					$listings[$l]['description'] = strip_tags(geoString::fromDB($show_listings['description']));

					$listing_link = $site->configuration_data['classifieds_file_name'] . "?a=2&amp;b=".$show_listings['id'];
					if ($seo) {
						$listings[$l]['url'] = $seo->rewriteUrl($listing_link);
					} else {
						$listings[$l]['url'] = $listing_link;
					}

					$listings[$l]['bid_url'] = $site->configuration_data['classifieds_file_name'] . "?a=1029&amp;b=".$show_listings['id'];
					$listings[$l]['buy_url'] = $site->configuration_data['classifieds_file_name'] . "?a=1029&amp;b=".$show_listings['id']."&amp;d=1";

					if ($show_listings[image] > 0) {
						$listings[$l]['thumb'] = geoImage::display_thumbnail($show_listings[id],$reg->thumb_width,$reg->thumb_width,1);
					} else {
						$listings[$l]['thumb'] = "<img src='$no_image_url' alt='' />";
					}


					if ($show_listings['current_bid'] > 0) {
						$listings[$l]['current_bid'] = geoString::displayPrice($show_listings[current_bid],$show_listings[precurrency],$show_listings[postcurrency]);
					} else {
						unset($listings[$l]['current_bid']);
					}

					$listings[$l]['minimum_bid'] = geoString::displayPrice($show_listings[minimum_bid],$show_listings[precurrency],$show_listings[postcurrency]);
					$listings[$l]['starting_bid'] = geoString::displayPrice($show_listings[starting_bid],$show_listings[precurrency],$show_listings[postcurrency]);
					$listings[$l]['reserve_price'] = geoString::displayPrice($show_listings[reserve_price],$show_listings[precurrency],$show_listings[postcurrency]);

					$listings[$l]['price'] = geoString::displayPrice($show_listings[price],$show_listings[precurrency],$show_listings[postcurrency]);

					if ($show_listings['buy_now'] > 0) {
						$listings[$l]['buy_now'] = geoString::displayPrice($show_listings[buy_now],$show_listings[precurrency],$show_listings[postcurrency]);
					} else {
						unset($listings[$l]['buy_now']);
					}
			
					if ($show_listings['item_type'] == 2 || $show_listings['item_type'] == 4) {
						$listings[$l]['bids'] = "".$site->get_number_of_bids(0,$show_listings['id'])." ".$msgs['bids_text']."";
						if (empty($listings[$l]['bids'])) {
							$listings[$l]['bids']  = "0 ".$msgs['bids_text']."";
						}
					}

					if($show_listings['item_type'] == 2) {
						$number_of_bids = $site->get_number_of_bids(0,$show_listings['id']);
						if (($show_listings['buy_now']!= 0) && (($show_listings['current_bid'] == 0) || ($db->get_site_setting('buy_now_reserve') && $show_listings['current_bid'] < $show_listings['reserve_price']))) {
							$listings[$l]['buy_now_img'] = "<img src='".geoTemplate::getUrl('',$messages[500799])."' alt='' />";
						}								
						if ($show_listings['reserve_price'] != 0) {
							if ($show_listings['current_bid'] >= $show_listings['reserve_price']) {
								$listings[$l]['reserve_img'] = "<img src='".geoTemplate::getUrl('',$messages[500800])."' alt='' />";
							}
						}				
						if ($show_listings['reserve_price'] == 0.00) {
								$listings[$l]['reserve_img'] = "<img src='".geoTemplate::getUrl('',$messages[500802])."' alt='' />";
						}
					}

						$weeks = $site->DateDifference('w',geoUtil::time(),$show_listings['ends']);
						$remaining_weeks = ($weeks * 604800);
		
						// Find days left
						$days = $site->DateDifference('d',(geoUtil::time()+$remaining_weeks),$show_listings['ends']);
						$remaining_days = ($days * 86400);
		
						// Find hours left
						$hours = $site->DateDifference('h',(geoUtil::time()+$remaining_days),$show_listings['ends']);
						$remaining_hours = ($hours * 3600);
		
						// Find minutes left
						$minutes = $site->DateDifference('m',(geoUtil::time()+$remaining_hours),$show_listings['ends']);
						$remaining_minutes = ($minutes * 60);
		
						// Find seconds left
						$seconds = $site->DateDifference('s',(geoUtil::time()+$remaining_minutes),$show_listings['ends']);
						if ($weeks > 0) {
							$listings[$l]['time_left']  = $msgs[closing_text]." ".$weeks." ".$msgs[weeks_text].", ".$days." ".$msgs[days_text];
						} else if ($days > 0) {
							$listings[$l]['time_left'] = $msgs[closing_text]." ".$days." ".$msgs[days_text].", ".$hours." ".$msgs[hours_text];
						} else if ($hours > 0) {
							$listings[$l]['time_left'] = $msgs[closing_text]." ".$hours." ".$msgs[hours_text].", ".$minutes." ".$msgs[minutes_text];
						} else if ($minutes > 0) {
							$listings[$l]['time_left'] = $msgs[closing_text]." ".$minutes." ".$msgs[minutes_text].", ".$seconds." ".$msgs[seconds_text];
						} else if ($seconds > 0) {
							$listings[$l]['time_left'] = $msgs[closing_text]." ".$seconds." ".$msgs[seconds_text];
						} else {
							// If closed we want to display closed text
							$listings[$l]['time_left'] = "<span class='auction_closed'>".$msgs[closed]."</span>";
						}


						$listings[$l]['start_time'] = $msgs[listed_text]." ".date(trim($site->configuration_data['entry_date_configuration']), $show_listings['start_time']);
						$listings[$l]['end_time'] = $msgs[end_text]." ".date(trim($site->configuration_data['entry_date_configuration']), $show_listings['end_time']);

					$l++;

				}

				if ($l <= $reg->per_frame) {
					$tpl->assign('use_controls',false);
				}


			}		

		if ($l <= '1') {
			$tpl->assign('use_controls',false);
		}
		

		$tpl->assign('listings',$listings);
		$html = $tpl->fetch('items.tpl');
		return $html;

	}


}