{* $Rev: 19297 $ *}
{if $print}
<html>
<head>
<title>Invoice {$invoice_id} Attached to Order #{$order_id}</title>
<link rel='stylesheet' type='text/css' href='css/body_html.css' />
{/if}
<style type="text/css" media="">
{literal}
.row_color1, .row_color2, td
{
	font-size: 8pt;
}
.invoiceBox
{
	border: 1px solid #88AACC;
	margin: 10px !important;
	padding: 15px;
	height: auto;
	width: 600px;
}

.invoiceBox table
{
	width: 100%;
}
.floatingMiniBoxContainer
{
	float: right;
	width: 275px;
}
.miniBox
{
	border: 1px solid #88AACC;
	margin: 10px;
	margin-right: 5px;
	padding: 15px;
	height: auto;
	font-size: 10pt;
}
.miniBox div.miniSub
{
	position: relative;
}
.miniBox .value
{
	position: absolute;
	text-align: right;
	right: 10px;
	font-weight: bold;
}
.printBox
{
	position: absolute;
	right: 20px;
	top: 15px;
	width: 50px;
}
.addressBox
{
	width: 250px;
	height:auto;
	border: 1px solid #88aacc;
	margin: 5px;
	padding: 5px;
}
textarea.addressBox
{
	height: 150px;
}
.due
{
	color: red;
}
.payment
{
	color: green;
}
.pending
{
	color: #aaaaaa;
	text-decoration: line-through;
}
.price
{
	text-align: right;
}
{/literal}
</style>
<style type="text/css" media="print">
{literal}
.printBox
{
	display:none;
}
.clearColumn
{
	clear: both;
}
{/literal}
</style>
{if $print}
</head>
<body onload="window.print();">
{/if}

<div class="printBox">
	{if !$print}
		<a href="javascript:void(0);" class="mini_button" onclick="lightUpBox.closeBox();">
			Close
		</a>
	{/if}
	
	<a href="javascript:void(0);" class="mini_button" onclick="{if $print}window.print();{else}window.open('{$printUrl}');{/if}">
		Print
	</a>
</div>

<div class="invoiceBox">
	<div class="floatingMiniBoxContainer">
		<div class="miniBox">
			<div class="miniSub">
				<div class="value">
					#{$invoice_id}<br />
					#{$order_id}
				</div>
				Invoice<br />
				Attached to Order
			</div>
		</div>
		<div class="miniBox">
			<div class="miniSub">
				<div class="value">
					{$invoice_date|date_format}<br />
					{$invoice_due_date|date_format}
				</div>
				Created:<br />
				Due on:
			</div>
		</div>
		<div class="miniBox">
			<div class="miniSub">
				<div class="value">
					{$pay_amount|displayPrice}
				</div>
				Amount Due:
			</div>
		</div>
	</div>
	Our Address:<br />
	<div class="addressBox medium_font">{$companyAddress}</div>
	<br /><br />
	Client Address:<br />
	<div class="addressBox">
	{if $client.firstname OR $client.lastname}
		{$client.firstname} {$client.lastname}<br />
	{/if}
	{if $client.address OR $client.address_2}
		{$client.address} {$client.address_2}<br />
	{/if}
	{if $client.city OR $client.state OR $client.zip OR $client.country}
		{$client.city}, {$client.state}, {$client.country} {$client.zip}
	{/if}
	<br /><br />
	{if $client.phone}
		Phone: {$client.phone}<br />
	{/if}
	{if $client.phone2}
		Phone 2: {$client.phone2}<br />
	{/if}
	{if $client.email}
		E-mail: {$client.email}<br />
	{/if}
	{if $client.email2}
		E-mail 2: {$client.email2}<br />
	{/if}
	{if $client.company_name}
		Company: {$client.company_name}
	{/if}
	</div>
	<div class="clearColumn"></div>
</div>

<div class="invoiceBox">
	Invoice Transactions
	<br />
	<table>
		<thead>
			<tr>
				<th class="col_hdr_left">Description</th>
				<th class="col_hdr_left">Date</th>
				<th class="col_hdr_left">Type</th>
				<th class="col_hdr_left">Status</th>
				<th class="col_hdr_left">Amount</th>
			</tr>
		</thead>
		<tbody>
{foreach from=$transactions item="transaction" key="transaction_id"}
	{cycle values="row_color1,row_color2" assign="row_color"}
			<tr>
				<td class="{$row_color}">
					{$transaction.desc}
				</td>
				<td class="{$row_color}">
					{$transaction.date|date_format}
				</td>
				<td class="{$row_color}">
					{$transaction.type}{if $transaction.amount < 0} (Due){elseif $transaction.amount >0} (Payment){/if}
				</td>
				<td class="{$row_color}">
					{if $transaction.status}Approved{else}Not Received{/if}
				</td>
				<td class="{$row_color} price">
					<span class="{$transaction.amount_class}">{$transaction.amount|displayPrice}</span>
				</td>
			</tr>
{foreachelse}
			<tr>
				<td colspan="5">
					No transactions found for this invoice.
				</td>
			</tr>
{/foreach}
			<tr>
				<td colspan="4" style="text-align:right; font-weight: bold;">Invoice Total:</td>
				<td style="font-weight: bold;" class="price"><span class="{if $invoice_amount > 0}payment{elseif $invoice_amount < 0}due{else}zero{/if}">{$invoice_amount|displayPrice}</span></td>
			</tr>
		</tbody>
	</table>
</div>
<div class="invoiceBox" style="text-align: right;">
	END OF INVOICE
</div>

</body>
</html>