<?php
//app_top.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

defined('GEO_BASE_DIR') OR die('NO_ACCESS');


if (defined('IN_ADMIN')) {
	//don't run
	return;
}
if (geoPC::is_print() && DataAccess::getInstance()->get_site_setting('disableAllBrowsing')) {
	//browsing disabled, that includes geographic navigation
	return;
}

$region_id = 0;

$geoNavReg = geoAddon::getRegistry('geographic_navigation');

if ($geoNavReg->subdomains == 'on') {
	//check sub-domain
	$pc = geoPC::getInstance();
	
	$util = geoAddon::getUtil('geographic_navigation');
	
	//figure out the main part minus subdomain
	$host = geoPC::cleanHostName($_SERVER['HTTP_HOST']);
	//remove www if at start, to allow silly stuff like www.region.example.com
	$host = preg_replace('/^www\./','',$host);
	
	//get "main part" of domain name, minus "not attached to license" part of subdomain
	$mainHost = $pc->validateMainDomain($host);
	
	//now figure out what subdomain is
	$subdomain = ($host != $mainHost)? substr($host, 0,strpos($host, $mainHost)) : '';
	
	//clean it up
	$subdomain = $util->subdomainClean($subdomain);
	
	if (strlen($subdomain)) {
		//now find what region, country, or state matches that subdomain
		$row = $db->GetRow("SELECT `id` FROM ".addon_geographic_navigation_info::REGION_TABLE." WHERE `subdomain`=?", array ($subdomain));
		if ($row && $row['id']) {
			$region_id = 'region'.(int)$row['id'];
		}
		
		if (!$region_id) {
			//check country
			$row = $db->GetRow("SELECT `country_id` FROM ".geoTables::countries_table." WHERE `subdomain`=? AND `addon_geographic_navigation_used`=1", array ($subdomain));
			if ($row && $row['country_id']) {
				$region_id = 'country'.(int)$row['country_id'];
			}
		}
		
		if (!$region_id) {
			//check state
			$row = $db->GetRow("SELECT `state_id` FROM ".geoTables::states_table." WHERE `subdomain`=? AND `addon_geographic_navigation_used`=1", array ($subdomain));
			if ($row && $row['state_id']) {
				$region_id = 'state'.(int)$row['state_id'];
			}
		}
		if ($region_id) {
			//let view know about subdomain
			geoView::getInstance()->geographic_navigation_subdomain = $subdomain;
		}
	}
	//unset stuff since this is at global level, stop global var polution!
	unset ($pc, $util, $host, $mainHost, $subdomain, $row);
}
$set_region_cookie = false;
if (!$region_id) {
	//region ID not specified by subdomain, so use cookie or GET var
	$util = geoAddon::getUtil('geographic_navigation');
	if (isset($_GET['region'])) {
		//Set the cookie according to what they clicked on
		$expires = time()+60*60*24*7*20;//5 months
		if ($_GET['region'] && $util->checkRegionId(trim($_GET['region']))) {
			$region_id = trim($_GET['region']);
			setcookie("region",$region_id,$expires,"/");
		} else {
			//set to 0 most likely, so clearing the region selected
			setcookie("region",'',0,'/');
		}
	} else if (isset($_COOKIE['region'])) {
		//They have cookie set for region, so filter according to their cookie
		
		if ($_COOKIE['region'] && $util->checkRegionId(trim($_COOKIE['region']))) {
			$region_id = trim($_COOKIE['region']);
		}
	}
}

//make sure other parts know what it is
$_COOKIE['region'] = $region_id;

if ($region_id) {
	//add the filter
	
	//let view know about region
	geoView::getInstance()->geographic_navigation_region = $region_id;
	if (geoAddon::getRegistry('geographic_navigation')->combineTree) {
		$tpl = new geoTemplate(geoTemplate::ADDON, 'geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		$tpl->breadcrumb = $util->getBreadcrumbFor($region_id);
		$tpl->base_url = $util->getBaseUrl();
		$tpl->skipUl = true;
		$tpl->msgs = geoAddon::getText('geo_addons','geographic_navigation');
		geoView::getInstance()->category_tree_pre = $tpl->fetch('breadcrumb.tpl');
		unset ($tpl);
	}
	$sql = $tables = array();
	if (strpos($region_id,'region') !== false) {
		//this one is fancy smancey!
		$regionId = (int)str_replace('region','',$region_id);
		if ($regionId) {
			$rtable = addon_geographic_navigation_info::LISTING_TABLE;
			$tables[] = $rtable;
			
			$sql[] = "$rtable.`listing`=".geoTables::classifieds_table.".`id`";
			
			$sql[] = "$rtable.`region_id`=$regionId";
		}
	} else if (strpos($region_id, 'state') !== false) {
		$stateId = (int)str_replace('state','',$region_id);
		if ($stateId) {
			$region = geoRegion::getInstance();
			//get the main region
			$countryId = (int)$db->GetOne("SELECT `parent_id` FROM ".geoTables::states_table." WHERE `state_id`=$stateId");
			if ($countryId) {
				$abreviation = $region->getSubRegionAbbreviationById($stateId,$countryId);
				$statename = $region->getSubRegionNameById($stateId, $countryId);
		 		$subSql = array();
		 		if ($abreviation) {
		 			$subregion = $db->qstr(geoString::toDB($abreviation));
		 			$subSql [] = "`location_state`=$subregion";
		 		}
				if ($statename) {
					$regionname = $db->qstr(geoString::toDB($statename));
					$subSql[] = "`location_state`=$regionname";
				}
				if ($subSql) {
					$sql[] = '('.implode(' OR ',$subSql).')';
				}
			}
		}
		
	} else if (strpos($region_id, 'country') !== false) {
		$countryId = (int)str_replace('country','',$region_id);
		if ($countryId) {
			$region = geoRegion::getInstance();
			$regionname = $db->qstr(geoString::toDB($region->getRegionNameById($countryId)));
			if ($regionname) {
				//echo "region name: $regionname";
				$sql[] = "`location_country`=$regionname";
			}
		}
	}
	
	
	if ($sql) {
		$tables = ($tables)? implode(', ',$tables): null;
		$db->addBrowsingWhereClause('addon_geographic_navigation',implode(' AND ',$sql), null, $tables);
	}
}
