<?php
//addons/geographic_navigation/info.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

class addon_geographic_navigation_info{
	#### Required Vars ####

	public $name = 'geographic_navigation';
	public $version = '3.2.3';
	public $core_version_minimum = '5.2.0';
	public $title = 'Geographic Navigation';
	public $author = "Geodesic Solutions LLC.";
	public $description = 'This is a Geographic Navigation addon, it uses the 
	geographic regions and "filters" the listings displayed on the site by the 
	selected region or sub-region.';
	
	var $auth_tag = 'geo_addons';
	var $icon_image = 'menu_geo_navigation.gif';
	var $author_url = 'http://geodesicsolutions.com';
	var $info_url = 'http://geodesicsolutions.com/component/content/article/50-browsing-enhancements/76-geographic-navigation.html?directory=64';
	
	var $tags = array (
	'navigation',
	'breadcrumb',
	'listing_regions'
	);
	var $core_events = array (
	'registration_add_field_display',
	'registration_add_field_update',
	'registration_add_variable',
	'registration_check_info',
	'Search_classifieds_search_form',
	'Search_classifieds_Search_filterWhereClause',
	'geoFields_getDefaultFields',
	'Browse_ads_display_browse_result_addHeader',
	'Browse_ads_display_browse_result_addRow',
	'Browse_tag_display_browse_result_addHeader',
	'Browse_tag_display_browse_result_addRow',
	'Search_classifieds_BuildResults_addHeader',
	'Search_classifieds_BuildResults_addRow',
	'module_search_box_add_search_fields',
	'module_title_prepend_text',
	);
	
	//Used internally
	const COLUMN_NAME = 'addon_geographic_navigation_used';
	
	const REGION_TABLE = "`geodesic_addon_geographic_regions`";
	const LISTING_TABLE = "`geodesic_addon_geographic_listings`";
	const USER_TABLE = "`geodesic_addon_geographic_users`";
}

/**
 * Geographic Navigation Addon Changelog
 * 
 * v3.2.3 - Geo 5.2.1
 *  - Made the "require full location depth" able to work on countries with no
 *    state/providences attached.
 *  - Fixed minor issue where it didn't properly list ALL the domains in the system
 *    under the sub-domains page.
 *  
 * v3.2.2 - Geo 5.2.0
 *  - Made it turn off display if browsing is turned off (Print only setting)
 *  - Fixed sorting issues caused by countries with same ID
 *  - Fixed problem where un-checked states would still display in navigation
 *  - Changes to allow it to be usable in cart in admin
 *  - Added checks to make sure region exists and is enabled before adding
 *    filter for the page in app_top.
 *  - Improved install/uninstall script to be little smarter
 *  
 * v3.2.1 - Geo 5.1.4
 *  - Made the autoset feature for subdomains go other direction
 *  - Fixed issue with not showing classifieds counts
 *  
 * v3.2.0 - Geo 5.1.2
 *  - Made it able to display geographic navigation fields in search box module.
 *  - Made it able to add text to title module.
 *  
 * v3.1.1 - Geo 5.1.1
 *  - Fixed a bug that could cause the addon to not install properly
 * 
 * v3.1.0 - Geo 5.1.0
 *  - Updated navigation view to match 5.0 category navigation design
 *  - Replaced the old "display_regions" tag with new "navigation" tag, which is
 *    much more intuitive what the tag is used for.
 *  - It now uses new fields to use system instead of saving fields to use settings
 *    in planItem settings.
 *  - Now able to display geographic navigation column when browsing listings,
 *    according to fields to use settings set.
 *  - Requires 5.1 now for changes to fields to use (using on_off for type data)
 *  - Added breadcrumb tag
 *  - Added way to combine geo nav breadcrumb with cat nav breadcrumb
 *  - Can now show "no sub-region" message in geographic navigation
 *  
 * v3.0.0 - Geo 5.0.3/5.1.0
 *  - Added sub-domain abilities, licensing changes require 5.0.3
 *  - Changes for updated license system
 *  - In search, make it work to not select sub-region and still filter by top region selected.
 *  
 * v2.2.1 - Geo 5.0.3
 *  - Fixed issue where it was escaping "too much" when editing region value,
 *    resulting in certain text to appear "scrambled".
 *  
 * v2.2.0 - Geo 5.0.2
 *  - Added tag for current_location that displays current location.
 *  
 * v2.1.0 - Geo 5.0.0
 *  - Changes for new Geo admin design
 *  
 * v2.0.4 - Geo 4.1.3
 *  - Added ability to search by location in advanced search
 *  - Fixed the registration requirement checks to actually block from continuing
 *    if requirements were not met.
 *  
 * v2.0.3 - Geo 4.1.3
 *  - Removed debug output on the page.
 *  - Fixed fatal error on registration confirm.
 *  - Converted the listing_regions tag to use smarty template.
 *  - Fixed problem with links when arrays are in the vars in the link.
 *  - Fixed it to properly force the state and country fields on the listing
 * 
 * v2.0.2 - Geo 4.1.2
 *  - Made it so that when user edits user data, and selects the "apply to all listings"
 *    then it applies to all the user's listings.
 *  - Now requires 4.1.2 because of change to order item behavior.
 *  - Fixed issue when region is set for user but that region does not exist.
 * 
 * v2.0.1 - Geo 4.1.2
 *  - Fixed problem causing region data to not save when using country/state info
 *  
 * v2.0.0 - Geo 4.1.0
 *  - Added unlimited sub-regions
 * 
 * v1.0.5 - Geo 4.0.7
 *  - Fix applied for addon license checks
 *  
 * v1.0.4 - Geo 4.0.6
 *  - Fixed problem with naming of column changed, fix requires changes in base
 *    code for 4.0.6.
 *  - Added license checks.
 *  - Made the columns default to 1 for if to use that region or not, in the DB
 *  
 * v1.0.3 - Geo 4.0.5
 *  - Re-named to Geographic Navigation Addon (used to be regions filter)
 * 
 * v1.0.2 - Geo 4.0.4
 *  - Changed how general settings were saved, to use the addon registry.
 *  - Made the main settings use "normal" save instead of ajax save.  (Ajax save
 *    is nice, but not needed in this case, the AJAX part of it just makes
 *    maintenence a huge pain for adding new settings)
 *  - Changed it so that if there is only 1 main region, it has that region
 *    auto-selected.
 *  - Converted text in template into "addon text" that can be set in the admin
 *    panel.
 *    
 * v1.0.1 - Geo 4.0.0RC11
 *  - First version using changelog block
 *  - In admin settings, display the tags on that page to make it more clear they need to
 *    insert a tag somewhere for it to display.
 *  - On fresh install, made number of columns default to 1
 *  - On fresh install, made "display full tree" default to on.
 *  - Fixed template to not set a:link style globally, overriding the preferred styles on the page.
 * 
 */

