<?php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

/**
 * This attaches regions to the listing.
 */
class geographicNavRegionsOrderItem extends geoOrderItem
{
	protected $type = "geographicNavRegions";
	const type = 'geographicNavRegions';
	protected $defaultProcessOrder = 15;
	const defaultProcessOrder = 15;
	
	//internal use:
	private static $_userError;
	
	//required by system
	public function displayInAdmin()
	{
		return false;
	}
 
	//required by system, doesn't have to do anything though
	public static function geoCart_initSteps()
	{
		
	}
	
	public static function Admin_site_display_user_data ($userId)
	{
		$util = geoAddon::getUtil('geographic_navigation');
		
		$regions = $util->getRegionsForDisplay(0,(int)$userId);
		$regions = ($regions)? implode(' &gt; ',$regions): 'N/A';
		
		return geoHTML::addOption('Location (Geographic Navigation)', $regions);
	}
	
	public static function Admin_user_management_edit_user_form ($userId)
	{
		//re-use code!
		$display = self::user_information_edit_form_display(array('user_id'=>$userId));
		if ($display) {
			return geoHTML::addOption('Location (Geographic Navigation)',$display['value']);
		}
		return '';
	}
	
	public static function Admin_user_management_update_user_info ($user_id)
	{
		$regions = (isset($_POST['c']['geographic_navigation_addon']))? $_POST['c']['geographic_navigation_addon'] : false;
		
		if (!$regions) {
			//nothing to do
			return;
		}
		$util = geoAddon::getUtil('geographic_navigation');
		$util->setRegionsForUser($user_id, $regions);
	}
	
	public static function User_management_information_display_user_data ()
	{
		$reg = geoAddon::getRegistry('geographic_navigation');
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		$session = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$userId = $session->getUserId();
		
		$util = geoAddon::getUtil('geographic_navigation');
		
		$regions = $util->getRegionsForDisplay(0, $userId);
		if ($regions) {
			$msgs = self::_getText();
			return array ('label' => $msgs['userInfoLocationLabel'], 'value' => implode(' &gt; ',$regions));
		}
		
		return false;
	}
	public static function user_information_edit_form_display ($vars)
	{
		$reg = geoAddon::getRegistry('geographic_navigation');
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$info = $vars['info'];
		$userClass = $vars['this'];
		
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		$view = geoView::getInstance();
		//we use this same method to display in admin as well
		$pre = (defined('IN_ADMIN'))? '../': '';
		$view->addJScript($pre.'addons/geographic_navigation/regions.js');
		
		$regionId = $countryId = $stateId = $highestLevel = 0;
		if (isset($info['geographic_navigation_addon'])) {
			$alreadyRegions = $info['geographic_navigation_addon'];
			
			foreach ($alreadyRegions as $level => $val) {
				if (strpos($val, 'country') !== false) {
					//an alternate selected country
					$countryId = (int)str_replace('country','',$val);
				} else if (strpos($val, 'state') !== false) {
					$stateId = (int)str_replace('state','',$val);
				} else if (strpos($val, 'region') !== false && $level > $highestLevel) {
					$highestLevel = $level;
					$regionId = str_replace('region','',$val);
				}
			}
		} else {
			//figure out the highest region selected
			
			//figure out country selected
			
			$user = geoUser::getUser($vars['user_id']);
			if (!$user) {
				//can't do nothin
				return false;
			}
			
			//OK first get the highest region
			$sql = "SELECT `region_id`,`level` FROM ".addon_geographic_navigation_info::USER_TABLE." 
				WHERE `user`=? ORDER BY `level` DESC LIMIT 1";
			$row = $db->GetRow($sql, array((int)$vars['user_id']));
			if ($row) {
				$regionId = (int)$row['region_id'];
			}
			
			$region = geoRegion::getInstance();
			
			if (!$regionId && $user->country) {
				//get the ID
				$country = trim($user->country);
				$sql = "SELECT `country_id` FROM ".geoTables::countries_table." WHERE (`name`=? OR `abbreviation`=?) AND ".addon_geographic_navigation_info::COLUMN_NAME."=1 LIMIT 1";
				$row = $db->GetRow($sql, array($country, $country));
				if ($row){
					$countryId = (int)$row['country_id'];
				}
			}
			
			if (!$countryId && !$regionId) {
				//see if there is a lone country
				if ($region->getRegionCount(addon_geographic_navigation_info::COLUMN_NAME) == 1) {
					//there's only one main region, select it!
					$sql = "SELECT `country_id` FROM ".geoTables::countries_table." WHERE ".addon_geographic_navigation_info::COLUMN_NAME."=1";
					$row = $db->GetRow($sql);
					if ($row) {
						$countryId = (int)$row['country_id'];
					}
				}
			}
			
			//figure out state selected
			if ($countryId) {
				//can only get state if country selected
				if ($user->state) {
					//get the ID
					$state = trim($user->state);
					$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE (`name`=? OR `abbreviation`=?) AND ".addon_geographic_navigation_info::COLUMN_NAME."=1 LIMIT 1";
					$row = $db->GetRow($sql, array($state, $state));
					if ($row){
						$stateId = (int)$row['state_id'];
					}
				}
				
				if (!$stateId) {
					//see if there is a lone state
					if ($region->getSubRegionCount($countryId, addon_geographic_navigation_info::COLUMN_NAME) == 1) {
						//there's only one main region, select it!
						$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE ".addon_geographic_navigation_info::COLUMN_NAME."=1";
						$row = $db->GetRow($sql);
						if ($row) {
							$stateId = (int)$row['state_id'];
						}
					}
				}
			}
		}
		
		//get regions in texas.  I mean for this location.
		$tpl->levels = $util->getLevelsFor($regionId, $stateId, $countryId);
		$tpl->pre = 'c';
		$msgs = self::_getText();
		
		$return = array('label' => $msgs['userInfoEditLocationLabel'], 'value' => $tpl->fetch('listing_region_select/box.tpl'));
		if (self::$_userError) {
			$return['error'] = self::$_userError;
		}
		return $return;
	}
	
	public static function user_information_edit_form_check_info ($vars)
	{
		$info = $vars['info'];
		$userClass = $vars['this'];
		
		$reg = geoAddon::getRegistry('geographic_navigation');
		if (!$reg->userUse) {
			//not used
			return;
		}
		$use = (isset($info['geographic_navigation_addon'][1]) && $info['geographic_navigation_addon'][1]);
		if ($reg->userRequire && !$use) {
			//oops!  it's required!
			$msgs = self::_getText();
			self::$_userError = $msgs['errorUserRequired'];
			$userClass->error_found++;
			return;
		}
		if ($reg->userEndRequire && $use) {
			//check to make sure selected region is a terminating one.
			
			$util = geoAddon::getUtil('geographic_navigation');
			if (!$util->checkTerminatingRegions($info['geographic_navigation_addon'])) {
				$msgs = self::_getText();
				self::$_userError = $msgs['errorUserEndRequired'];
				$userClass->error_found++;
			}
		}
	}
	
	public static function user_information_edit_form_update ($vars)
	{
		$reg = geoAddon::getRegistry('geographic_navigation');
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		$util = geoAddon::getUtil('geographic_navigation');
		
		$util->setRegionsForUser($vars['user_id'], $vars['geographic_navigation_addon']);
		if (isset($vars['apply_to_all_listings']) && $vars['apply_to_all_listings']) {
			//apply it to all of user's listings
			$db = 1;
			include GEO_BASE_DIR . 'get_common_vars.php';
			$userManage = $vars['this'];
			
			$rows = $db->GetAll("SELECT `id` FROM ".geoTables::classifieds_table." WHERE `seller`=".(int)$vars['user_id']." AND `live`=1");
			
			foreach ($rows as $row) {
				$listingId = (int)$row['id'];
				$util->setRegionsForListing($listingId, $vars['geographic_navigation_addon']);
			}
			$geoRegion= geoRegion::getInstance();
			foreach ($vars['geographic_navigation_addon'] as $level => $region) {
				if (!$region) {
					//not set to anything for this level
					continue;
				}
				if (strpos($region,'country') !== false) {
					//country
					
					$countryId = (int)str_replace('country','',$region);
					if (!$countryId) {
						//not set to anything useful
						continue;
					}
					
					$name = $geoRegion->getRegionNameById($countryId);
					if (!$name) {
						continue;
					}
					//Set country for listing/user
					$userManage->updatedInfo['country'] = $name;
				} else if (strpos($region, 'state') !== false) {
					//state
					$stateId = (int)str_replace('state','',$region);
					if (!$stateId) {
						//not set to anything useful
						continue;
					}
					
					$name = $geoRegion->getSubRegionAbbreviationById($stateId);
					if (!$name) {
						continue;
					}
					//Set country for listing/user
					$userManage->updatedInfo['state'] = $name;
				} else {
					break;
				}
			}
		}
	}
	
	public static function detailsCheckVars_getMoreDetails ()
	{
		$cart = geoCart::getInstance();
		
		$use = (isset($cart->site->session_variables['geographic_navigation_addon'][1]) && $cart->site->session_variables['geographic_navigation_addon'][1]);
		
		
		//If regions are required to be selected, make sure they are selected.
		if (!$cart->site->fields->addon_geographic_navigation_location->is_enabled) {
			//not used
			return;
		}
		if ($cart->site->fields->addon_geographic_navigation_location->is_required && !$use) {
			//oops!  it's required!
			
			$msgs = self::_getText();
			$cart->addError()
				->addErrorMsg('geographic_navigation_addon',$msgs['errorListingRequired']);
			return;
		}
		if ($cart->site->fields->addon_geographic_navigation_location->type_data && $use) {
			//check to make sure selected region is a terminating one.
			$util = geoAddon::getUtil('geographic_navigation');
			if (!$util->checkTerminatingRegions($cart->site->session_variables['geographic_navigation_addon'])) {
				$msgs = self::_getText();
				$cart->addError()
					->addErrorMsg('geographic_navigation_addon',$msgs['errorListingEndRequired']);
			}
		}
		//die ('session vars: <pre>'.print_r($cart->site->session_variables,1));
	}
	
	public static function detailsProcess_getMoreDetails ()
	{
		$cart = geoCart::getInstance();
		
		$use = (isset($cart->site->session_variables['geographic_navigation_addon'][1]) && $cart->site->session_variables['geographic_navigation_addon'][1]);
		
		$cart->setPricePlan($cart->item->getPricePlan(),$cart->item->getCategory());
		//get current attached bolding, if exists..
		$item = $cart->getChildItem(self::type);
		
		$util = geoAddon::getUtil('geographic_navigation');
		
		//If regions are required to be selected, make sure they are selected.
		if (!$cart->site->fields->addon_geographic_navigation_location->is_enabled) {
			//not used
			return;
		}
		
		if (!$use){
			if ($item){
				//remove it
				$id = $item->getId();
				geoOrderItem::remove($id);
				$cart->order->detachItem($id);
			}
		} else {
			if (!$item){
				$item = geoOrderItem::getOrderItem(self::type);
				$item->setType(self::type);
				$item->setParent($cart->item);//this is a child of the parent
				$item->setOrder($cart->order);
				
				$already_attached = false;
				$item->save();//make sure it's serialized
				$cart->order->addItem($item);
				trigger_error('DEBUG CART: Adding bolding: <pre>'.print_r($item,1).'</pre>');
			} else {
				trigger_error('DEBUG CART: Bolding already attached: <pre>'.print_r($item,1).'</pre>');
				$cart->order->addItem($item);
				$already_attached = true;
			}
			//get the price...
			
			//wait there is none!
			//$item->setCost($cost);
			
			//set details specific to geographic item
			//Set country and state for listing if set
			$regions = $cart->site->session_variables['geographic_navigation_addon'];
			$region = geoRegion::getInstance();
			if (isset($regions[1]) && strpos($regions[1], 'country') !== false) {
				$countryId = (int)str_replace('country','',$regions[1]);
				if ($countryId) {
					$cart->site->session_variables['country'] = $region->getRegionNameById($countryId);
				
					if (isset($regions[2]) && strpos($regions[2], 'state') !== false) {
						//set state in session vars
						$stateId = (int)str_replace('state','',$regions[2]);
						if ($stateId) {
							$cart->site->session_variables['state'] = $region->getSubRegionAbbreviationById($stateId, $countryId);
						}
					}
				}
			}
		}
	}
	public static function detailsDisplay_getMoreDetails ()
	{
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		$view = geoView::getInstance();
		$cart = geoCart::getInstance();
		$pre = (defined('IN_ADMIN'))? '../': '';
		$view->addJScript($pre.'addons/geographic_navigation/regions.js');
		
		//If regions are required to be selected, make sure they are selected.
		if (!$cart->site->fields->addon_geographic_navigation_location->is_enabled) {
			//not used
			return;
		}
		
		$regionId = $countryId = $stateId = $highestLevel = 0;
		
		//figure out the highest region selected
		if (isset($cart->site->session_variables['geographic_navigation_addon'])) {
			$alreadyRegions = $cart->site->session_variables['geographic_navigation_addon'];
			
			foreach ($alreadyRegions as $level => $val) {
				if (strpos($val, 'country') !== false) {
					//an alternate selected country
					$countryId = (int)str_replace('country','',$val);
				} else if (strpos($val, 'state') !== false) {
					$stateId = (int)str_replace('state','',$val);
				} else if (strpos($val, 'region') !== false && $level > $highestLevel) {
					$highestLevel = $level;
					$regionId = str_replace('region','',$val);
				}
			}
		} else {
			//figure out country selected
			
			$region = geoRegion::getInstance();
			
			if ($cart->user_data['id']) {
				$sql = "SELECT `region_id`,`level` FROM ".addon_geographic_navigation_info::USER_TABLE." 
					WHERE `user`=? ORDER BY `level` DESC LIMIT 1";
				$row = $cart->db->GetRow($sql, array((int)$cart->user_data['id']));
				if ($row) {
					$regionId = (int)$row['region_id'];
				}
			}
			
			if (!$regionId && $cart->user_data['country']) {
				//get the ID
				$country = $cart->user_data['country'];
				$sql = "SELECT `country_id` FROM ".geoTables::countries_table." WHERE (`name`=? OR `abbreviation`=?) AND ".addon_geographic_navigation_info::COLUMN_NAME."=1 LIMIT 1";
				$row = $cart->db->GetRow($sql, array($country, $country));
				if ($row){
					$countryId = $row['country_id'];
				}
			}
			
			if (!$regionId && !$countryId) {
				//see if there is a lone country
				if ($region->getRegionCount(addon_geographic_navigation_info::COLUMN_NAME) == 1) {
					//there's only one main region, select it!
					$sql = "SELECT `country_id` FROM ".geoTables::countries_table." WHERE ".addon_geographic_navigation_info::COLUMN_NAME."=1";
					$row = $cart->db->GetRow($sql);
					if ($row) {
						$countryId = $row['country_id'];
					}
				}
			}
			
			//figure out state selected
			if ($countryId) {
				//can only get state if country selected
				if ($cart->user_data['state']) {
					//get the ID
					$state = $cart->user_data['state'];
					$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE (`name`=? OR `abbreviation`=?) AND ".addon_geographic_navigation_info::COLUMN_NAME."=1 LIMIT 1";
					$row = $cart->db->GetRow($sql, array($state, $state));
					if ($row){
						$stateId = $row['state_id'];
					}
				}
				
				if (!$stateId) {
					//see if there is a lone state
					if ($region->getSubRegionCount($countryId, addon_geographic_navigation_info::COLUMN_NAME) == 1) {
						//there's only one main region, select it!
						$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE ".addon_geographic_navigation_info::COLUMN_NAME."=1";
						$row = $cart->db->GetRow($sql);
						if ($row) {
							$stateId = $row['state_id'];
						}
					}
				}
			}
		}
		
		//OK we can only have the highest level selected to get levels..
		if ($regionId) {
			$stateId = $countryId = 0;
		} else if ($stateId) {
			$countryId = 0;
		}
		
		//get regions in texas
		$tpl->levels = $util->getLevelsFor($regionId, $stateId, $countryId);
		$tpl->pre = 'b';
		$msgs = self::_getText();
		$label = $msgs['detailsLocationLabel'];
		$err = $cart->getErrorMsg('geographic_navigation_addon');
		if ($err) {
			$label .= "<br /><span class='error_message'>$err</span>";
		}
		
		return array('label' => $label, 'value' => $tpl->fetch('listing_region_select/box.tpl'));
	}
	
	public function processStatusChange ($newStatus, $sendEmailNotices = true, $updateCategoryCount = false)
	{
		if ($newStatus == $this->getStatus()){
			//the status hasn't actually changed, so nothing to do
			
			return;
		}
		$activate = ($newStatus == 'active')? true: false;
		
		$already_active = ($this->getStatus() == 'active')? true: false; 
		
		//allow parent to do common things, like set the status and
		//call children items
		parent::processStatusChange($newStatus, $sendEmailNotices, $updateCategoryCount);
		
		$parent = $this->getParent();
		if (!$parent) {
			//Doh!  this should not happen.
			trigger_error('ERROR CART: Count not get parent, this should not happen!');
			return;
		}
		$util = geoAddon::getUtil('geographic_navigation');
		
		if ($parent->getType() == 'listing_edit') {
			//do things special for editing
			
			$force = ($activate)? true : false;
			$session_variables = listing_editOrderItem::getSessionVars($parent, $force);
			
			$util->setRegionsFor($parent->get('listing_id'), $session_variables['geographic_navigation_addon']);
		} else {
			//either totally add them or totally remove them since we are activating
			//or deactivating a listing
			if ($activate) {
				//do activate actions here, such as setting listing to live
				$session_variables = $parent->get('session_variables');
				
				$util->setRegionsFor($parent->get('listing_id'), $session_variables['geographic_navigation_addon']);
			} else if (!$activate && $already_active) {
				//do de-activate actions here, such as setting listing to not be live any more.
				//This is what would happen if an admin changes their mind
				//and later decides to change an item from being active to being pending.
				
				$util->removeRegionsFor($parent->get('listing_id'));
			}
		}
		//NOTE: do not need to call children, parent does that for us :)
	}
	
 
	//required by system
	public static function geoCart_initItem_forceOutsideCart()
	{
		return false;
	}
 
	//required by system
	public static function getParentTypes()
	{
		return array('classified','auction','reverse_auctions');
	}
	
	public function getTypeTitle ()
	{
		return 'Geographic Navigation Location';
	}
 
	//required by system
	public function getDisplayDetails ($inCart)
	{
		//don't actually display a thingy just for this, since it doesn't add cost or anything,
		//it's just holding data
		return false;
		
		return array (
			'css_class' => '',//empty string to use default CSS class in the HTML, otherwise a string containing the css class name.
			'title' => 'Geo Navigation',//text that is displayed for this item in list of items purchased.
			'canEdit' => true, //show edit button for item, if displaying in cart?
			'canDelete' => true, //show delete button for item, if displaying in cart?
			'canPreview' => true, //show preview button for item, if displaying in cart?
			'priceDisplay' => '$5.23USD', //Price as it is displayed
			'cost' => $this->getCost(), //amount this adds to the total, what getCost returns
			'total' => $this->getCost(), //amount this AND all children adds to the total (will add to it as we parse the children)
			'children' => array() 	//should be array of child items, with the index
	 								//being the item's ID, and the contents being associative array like
	 								//this one.  If no children, it should be an empty array.  (Careful 
									//not to get into any infinite recursion)
		);
	}
 
	//required by system
	public static function geoCart_initSteps_addOtherDetails()
	{
		return false;
	}
	
	private static function _getText ()
	{
		return geoAddon::getText('geo_addons', 'geographic_navigation');
	}
}