<?php
//addons/google_maps/info.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 12774              $ ##
## File last change date:       ##
##  $Date:: 2008-05-22 16:12:#$ ##
##                              ##
##################################

# Google maps Addon

class addon_google_maps_info
{
	var $name = 'google_maps';
	var $version = '1.0.7';
	var $core_version_minimum = '5.0.0';
	var $title = 'Google Maps';
	var $author = "Geodesic Solutions LLC.";
	var $description = 'The Google maps addons allows you the ability to use maps on your pages powered by maps.google.com.';
	var $auth_tag = 'geo_addons';
	var $icon_image = 'menu_google.gif';
	var $upgrade_url = 'http://geodesicsolutions.com/component/content/article/50-browsing-enhancements/78-google-maps.html?directory=64';
	var $author_url = 'http://geodesicsolutions.com';
	var $info_url = 'http://geodesicsolutions.com/component/content/article/50-browsing-enhancements/78-google-maps.html?directory=64';
	var $tags = array (
		'user_map',
		'listing_map'
	);
	
	var $core_events = array (
		'notify_display_page'
	);
	
	public function __construct ()
	{
		if (defined('IN_ADMIN')) {
			//The tag was originally named user_map which isn't a very good name...
			//make tags only have listing_map in it if in admin, but on client side
			//still allow user_map to work.
			
			$this->tags = array ('listing_map');
		}
	}

	
	public function enableCheck ()
	{
		return true;//DO NOT EDIT: will be changed for trial demo addons
	}
	
}
/**
 * Changelog for Google Maps
 * 
 * v1.0.7 - Geo 5.1.2
 *  - Fixed a bug that could cause the pointer to appear in the wrong location if an address contained an apostrophe
 *  
 * v1.0.6 - Geo 5.1.0
 *  - Changed template to use escape_js which should be safe to use in trial demos
 *  - Upped the min version to 5.0 since that is version escape_js was added.
 *  
 * v1.0.5 - Geo 5.0.0
 *  - Made it attempt to utf8-encode location to get the coords for it.
 * 
 * v1.0.4 - Geo 4.1.3
 *  - Changes to JS used "inline" to use Event.observe() instead of window.onload
 *    to make it more compatible with other onload events.
 *    
 * v1.0.3 - Geo 4.1.2
 *  - Made change to get proper encoding from google maps (utf-8), so it works
 *    better with international addresses.
 *  
 * v1.0.2 - Geo 4.1.1
 *  - Fixed location generation to omit country and/or state if either is set
 *    to "none"
 *  
 * v1.0.1 - Geo 4.0.9
 *  - Addon code cleaned up, removed stuff not used.
 *  - Changed to use addon registry instead of it's own table to save settings.
 *  
 * v 1.0.0 - Geo 4.0.0
 *  - Addon created.
 * 
 */




