<?php
//addons/google_maps/util.php

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 13459              $ ##
## File last change date:       ##
##  $Date:: 2008-07-17 16:38:#$ ##
##                              ##
##################################

# google_maps Addon
require_once ADDON_DIR . 'google_maps/info.php';

class addon_google_maps_util extends addon_google_maps_info
{
	public $coordinates, $location, $locationLong;
	
	public function core_notify_display_page ()
	{
		//insert stuff into head
		$this->initHead();
	}
	
	public function initHead ()
	{
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->apikey || (!defined('IN_ADMIN') && $reg->off)) {
			return;
		}
		$view = geoView::getInstance();
		if (!defined('IN_ADMIN') && !$view->classified_id) {
			//id NOT set
			return;
		}
		
		$pre = (defined('IN_ADMIN'))? '../':'';
		$urls[] = 'http://maps.google.com/maps?file=api&amp;v=2&amp;key='.$reg->apikey;
		$urls[] = $pre.'addons/google_maps/maps.js';
		
		$view->addJScript($urls);
		//must have utf8 charset, I think...  Remove this if it's not needed.
		if (!defined('IN_ADMIN')) $view->addTop('<meta http-equiv="content-type" content="text/html; charset=utf-8" />');
	}
	
	private function _getCoodinates()
	{
		if (isset($this->coordinates)) {
			return $this->coordinates;
		}
		$location = $this->_getLocation();
		
		if (!$location) {
			return;
		}
		if (!geoString::isUtf8($location)) {
			//attempt to convert location to UTF-8 or it won't work with google maps
			$location = utf8_encode($location);
		}
		
		$reg = geoAddon::getRegistry($this->name);
		$apikey = $reg->apikey;
		if (!$apikey || ($reg->off && !defined('IN_ADMIN'))) {
			//api key not set and not in admin, or turned off
			return;
		}
		if (!function_exists('curl_init')) {
			//not able to do anything w/o curl_init
			return;
		}
		
		$location = urlencode($location);
		$url = "http://maps.google.com/maps/geo?q=$location&output=xml&key=$apikey";
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//hack to get google to return utf-8 encoded string
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
		curl_setopt($ch, CURLOPT_URL, $url);
		$response = curl_exec($ch);
		curl_close($ch);
		
		$info = simplexml_load_string($response);
		if (!isset($info->Response->Placemark->Point->coordinates)) {
			//couldn't get the coords
			return;
		}
		$points = $info->Response->Placemark->Point->coordinates;
		
		if(!$points) {
			return;
		}
		//there's an extra number from the coords so get rid of it
		$coords = explode(',',$points);
		$longitude = $coords[0];
		$latitude = $coords[1];
		$this->coordinates = $latitude.','.$longitude;
		
		return $this->coordinates;
	}
	
	private function _getLocation()
	{
		if (defined('IN_ADMIN')) {
			$this->location = '3333 California St San Francisco CA 94118';
			$this->locationLong = "<strong>Admin Map Preview Listing Title</strong><br />
			3333 California St<br />
			San Francisco CA 94118<br />
			United States of America";
		}
		if (isset($this->location)) {
			//already got it
			return $this->location;
		}
		
		$reg = geoAddon::getRegistry($this->name);
		if(!$reg->apikey) {
			return;
		}
		$listingId = (int)geoView::getInstance()->classified_id;
		if (!$listingId){
			return;
		}
		
		$listing  = geoListing::getListing($listingId);
		if(!$listing) {
			return;
		}
		
		$zip = (trim($listing->mapping_zip))? ', '.$listing->mapping_zip : '';
		$state = ($listing->mapping_state != 'none')? $listing->mapping_state: '';
		$country = ($listing->mapping_country != 'none')? $listing->mapping_country: '';
		$loc = "{$listing->mapping_address} {$listing->mapping_city} {$state}$zip {$country}";
		
		$loc = $this->_quoteFilter($loc);
		$this->location = $loc;
		
		$this->locationLong = "<strong>".$this->_quoteFilter($listing->title)."</strong><br />
			".$this->_quoteFilter($listing->mapping_address)."<br />".$this->_quoteFilter($listing->mapping_city)
			." ".$this->_quoteFilter($listing->mapping_state)." ".$this->_quoteFilter($listing->mapping_zip)
			."<br />".$this->_quoteFilter($listing->mapping_country);
		
		return $loc; 	
	}
	
	/**
	 * allows use of quotes in a string without opening the whole thing up to HTML injection
	 * @param unknown_type $str
	 * @return unknown_type
	 */
	private function _quoteFilter($str)
	{
		$str = geoString::fromDB($str);
		$str = geoString::specialCharsDecode($str); //undo filtering of quotes
		$str = str_replace('<','&lt;',$str); //but re-do filtering for < to prevent HTML-injection (addresses shouldn't have <, anyway)
		return $str;
	}
	
	/**
	 * Gets the HTML necessary for displaying google map for a listing.
	 * 
	 * @return string
	 */
	public function getMap()
	{
		$reg = geoAddon::getRegistry($this->name);
		if(!defined('IN_ADMIN') && $reg->off) {
			return false;
		}
		$this->_getCoodinates();
		if (!$this->coordinates) {
			//something went wrong when getting coords
			return '';
		}
		
		$tpl = new geoTemplate('addon',$this->name);
		$tpl->msgs = geoAddon::getText('geo_addons','google_maps');
		$tpl->location = ($this->locationLong)? $this->locationLong : $this->location;
		$tpl->coords = $this->coordinates;
		$tpl->width = (int)$reg->get('width',600);
		$tpl->height = (int)$reg->get('height',400);
		
		return $tpl->fetch('map.tpl');
	}
}