<?php
//addons/storefront/tags.php
/**
 * Optional file.  Used for addon tags on the client side.
 * 
 * Remember to rename the class name, replacing "storefront" with
 * the folder name for your addon.
 * 
 * Also see the file php5_files/tags.php (in the package storefront_addon_php5)
 * 
 * @author Geodesic Solutions, LLC
 * @package storefront_addon
 */

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20482              $ ##
## File last change date:       ##
##  $Date:: 2010-10-18 15:42:#$ ##
##                              ##
##################################

# storefront Addon

//Tag replacement file, for storefront module. 
//This file needs to contain class: addon_ADDON_NAME_tags
//ADDON_NAME is the same as the folder name for the addon.

/**
 * Expects one function for each tag.  Function name should be the same as 
 * the tag name.  Can also have a constructor if anything needs to be constructed.
 * 
 * @author Geodesic Solutions, LLC
 * @version $Rev: 20482 $
 * @copyright Copyright (c) 2001-2009 Geodesic Solutions, LLC
 * @package storefront_addon
 */
class addon_storefront_tags extends addon_storefront_info {
	
	function client_menu ()
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$link = $db->get_site_setting('classifieds_file_name')."?a=ap&amp;addon=storefront&amp;page=home&amp;store=".geoSession::getInstance()->getUserId();
		$images = "addons/storefront/images/menu_storefront.gif";
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		$alt_text = $text = $msgs['my_storefront_label'];
		return '<div><a href="'.$link.'"><img src="'.$images.'" alt="'.$alt_text.'" style="vertical-align: middle;"></a><a href="'.$link.'"><span class="user_links">'.$text.'</span></a></div>';
	}
	
	function control_panel_link()
	{
		$db = DataAccess::getInstance();
		
		$link = $db->get_site_setting('classifieds_file_name')."?a=ap&amp;addon=storefront&amp;page=control_panel";
		$images = "addons/storefront/images/menu_storefront.gif";
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		$alt_text = $text = $msgs['cp_link_text'];
		return '<div><a href="'.$link.'"><img src="'.$images.'" alt="'.$alt_text.'" style="vertical-align: middle;"></a><a href="'.$link.'"><span class="user_links">'.$text.'</span></a></div>';
	}
	
	function storefront_name()
	{
		if($_REQUEST['a'] != 'ap' || $_REQUEST['addon'] != 'storefront' || $_REQUEST['page'] != 'home' || !$_REQUEST['store']) {
			//not a valid storefront page -- nothing to do here
			return '';
		}
		
		$db = DataAccess::getInstance();
		
		$store = $_REQUEST['store'];
		$util = geoAddon::getUtil('storefront');
		$store = $util->storeIdFromString($store);
				
		$sql = "SELECT `storefront_name` FROM `geodesic_addon_storefront_user_settings` WHERE `owner` = ?";
		$name = $db->GetOne($sql, array($store));
		
		if(!$name) {
			//storefront name not set -- default to username
			$name = geoUser::userName($store);
		}
		
		return $name;
	}
	
	function list_stores_link()
	{
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		$tpl = new geoTemplate('addon','storefront');
		$tpl->tab_name = $msgs['store_tab_name'];
		$html = $tpl->fetch('list_stores_link.tpl');
		return $html;
	}
}