<?php
//PaymentGateways.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 12372              $ ##
## File last change date:       ##
##  $Date:: 2008-03-31 15:26:#$ ##
##                              ##
##################################

if(class_exists( 'admin_AJAX' ) or die());

class ADMIN_AJAXController_PaymentGateways extends admin_AJAX {
	public function payment() {
		if (!$this->isAllowed('payment_gateways','update')) die('NO_INCOMING_CALLS');
		$cjax = geoCJAX::getInstance();
		$do = $cjax->get('method');
		$group = intval($cjax->get('group'));
		
		geoPaymentGateway::setGroup($group);
		
		switch($do){
			case 'save':
				$this->save();
				break;
			case 'cancel':
				$this->cancel();
				break;
			case 'configure':
				$this->configure();
				break;
			case 'position';
				$this->position();
				break;
			case 'table':
				$this->getTable();
				break;
		}
		// admin/AJAX.php?controller=PaymentGateways&action=showGateway&data=blah
	}
	
	public function position()
	{
		$this->_ajax_movePosition();
		//re-load the entire table
		$tpl = new geoTemplate('admin');
		$tpl->assign('gateways',$this->getGatewayTable());
		$CJAX = geoCJAX::getInstance();
		$CJAX->update('table_settings',$tpl->fetch('payment_gateways/gateway_table.tpl'));
		
		//require GEO_BASE_DIR . 'app_bottom.php';
	}
	
	public function getTable()
	{
		//re-load the entire table
		$tpl = new geoTemplate('admin');
		$tpl->assign('gateways',$this->getGatewayTable());
		$CJAX = geoCJAX::getInstance();
		$CJAX->update('table_settings',$tpl->fetch('payment_gateways/gateway_table.tpl'));
	
	}

	public function getGatewayTable(){
		$CJAX = geoCJAX::getInstance();
		//get ALL payment gateways, including ones that are not enabled.
		$responses = geoPaymentGateway::callDisplay('admin_display_payment_gateways',null,'array','',false);
		$array_keys = array_keys($responses);
		
		$use_autosave = (count($array_keys) > 10)? 0:1;
		$count_keys = count($array_keys);
		$this->header_html = '';
		//include cjax to allow to get stuff
		$return = array();
		$counting = 0;
		$i = 0;
		$group = intval($CJAX->get('group'));
		
		geoPaymentGateway::setGroup($group);
		foreach ($array_keys as $key){
			$counting ++;
			$row = ($row == 'row_color1')? 'row_color2': 'row_color1';
			$return[$i]['name'] = $item = $responses[$key]['name'];
			$return[$i]['title'] = $responses[$key]['title'];
			$this->header_html .= (isset($responses[$key]['header_html']))? $responses[$key]['header_html']: '';
			
			$gateway = geoPaymentGateway::getPaymentGateway($item);
			
			if (!is_object($gateway)){
				continue;
			}
			$return[$i]['enabled'] = $enabled = $gateway->getEnabled();
			$return[$i]['default'] = $default = $gateway->getDefault();
			
			$return[$i]['display_order'] = $display_order = $gateway->getDisplayOrder();			
			
			$return[$i]['show_config'] = $show_config = (method_exists($gateway, 'admin_custom_config'));

			$CJAX->link = true;
			$return[$i]['response'] = 	$response = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=configure&group={$group}&item=$item");
			if($show_config) {
				$return[$i]['config'] = "
			<div id='update_config_$item'>
			<a id='configure' href='javascript:void(0);' onclick=\"configureGateway({$group},'$item', ".geoUtil::time().")\" class='mini_button'>Configure</a>
			</div>";
			}
			
			/*$visibility = ($enabled)? '': "style='display: none;' ";
			$enabled_select = ($enabled)? "checked='checked'": '';
			$default_select = ($enabled && $default)? "checked='checked'": '';
			$return[$i]['default'] = "<input type='radio' id='ena_radio_$item' name='default_gateway' value='$item' $default_select $visibility/>";
			
			$checkbox_js = "onclick=\"if (this.checked) {\$('ena_radio_$item').show();} else { \$('ena_radio_$item').hide();}\"";//" if(this.checked) {   _elem.style.visibility='visible'; } else { _elem.style.visibility='hidden'; _elem.checked=''; }\"";
			$return[$i]['enabled'] = "
						<input type='checkbox' id='enabled_gateways_$item' name='enabled_gateways[$item]' value='1' $enabled_select $checkbox_js/>
						";*/
			
			if ($counting ==1) {
				$CJAX->link = true;
				$down = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=position&move=down&id=$display_order&item=$item&order=$display_order&group={$group}","row_for{$item}");
				$return[$i]['order'] = "<span style='position:relative;margin-left:33px'><a href=$down class='mini_button' alt='move down' title='move down'>&nbsp;&or;&nbsp;</a></span>";
			} else if ($counting == $count_keys) {
				//index.php?mc=payments&page=payment_gateways&position=up&id=$display_order&item=$item&order=$display_order&auto_save_cjax=1&group={$group}
				$CJAX->link = true;
				$up = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=position&move=up&id=$display_order&item=$item&order=$display_order&group={$group}","row_for{$item}");
				$return[$i]['order'] = "<span style='position:relative;margin-right:32px'><a href=$up class='mini_button' alt='move up' title='move up'>&nbsp;&and;&nbsp;</a></span>";
			} else {
				$CJAX->link = true;
				///$up = $CJAX->call("index.php?mc=payments&page=payment_gateways&position=up&id=$display_order&item=$item&order=$display_order&auto_save_cjax=1&group={$group}","div{$display_order}");
				$up = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=position&move=up&id=$display_order&item=$item&order=$display_order&group={$group}","row_for{$item}");
				
				$CJAX->link = true;
				//$down = $CJAX->call("index.php?mc=payments&page=payment_gateways&position=down&id=$display_order&item=$item&order=$display_order&auto_save_cjax=1&group={$group}","div{$display_order}");
				$down = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=position&move=down&id=$display_order&item=$item&order=$display_order&group={$group}","row_for{$item}");
				
				
				$return[$i]['order'] = "
				<a href=$up class='mini_button' alt='move up' title='move up'>&nbsp;&and;&nbsp;</a> 
				<a href=$down class='mini_button' alt='move down' title='move down'>&nbsp;&or;&nbsp;</a>
				";
			}
			
			$i++;
		}
		return $return;
	}

	public function cancel()
	{
		$CJAX = geoCJAX::getInstance();
		$item =  $CJAX->get('item');
		$group = $CJAX->get('group');
		
		
		$CJAX->link = true;
		//$response = $CJAX->call("AJAX.php?controller=PaymentGateways&action=payment&method=configure&group=$group&item=$item");
		$config = "<div id='update_config_$item'>
			<a id='configure' href='javascript:void(0);' onclick=\"configureGateway({$group},'$item', ".geoUtil::time().")\" class='mini_button'>Configure</a>
			</div>";
		
		$CJAX->update('update_config_'.$item,$config);
		$CJAX->update("container_$item");
		//$CJAX->show("order_$item");
	}
	
	public function configure()
	{
		$CJAX = geoCJAX::getInstance();
		$item =  $CJAX->get('item');
		$group = intval($CJAX->get('group'));
		
		//this is an ajax call, not a normal page load.  Process ajax call.
		$gateway = geoPaymentGateway::getPaymentGateway($item);
		if (!is_object($gateway)) {
			$CJAX->alert('Error: Gateway not found!');
			return false;
		}
		$config = $gateway->admin_custom_config();
		
		//replace config button with save and cancel buttons
		$save_cancel = "<a id='save_$item' href='javascript:void(0)' onclick=\"saveGateway($group,'$item',".geoUtil::time().")\" class='mini_button'>Save</a> 
		<a id='cancel_$item' href='javascript:void(0)' onclick=\"cancelGateway($group,'$item')\" class='mini_cancel'>Cancel</a>";
		
		$CJAX->update('update_config_'.$item,$save_cancel);
		
		$html = "
		<div style='position:relative;' id='form_$item'>
			<div class='configBox'>$config</div>
		</div>";
		$CJAX->update("container_$item",$html);
		
		//$CJAX->hide("order_$item");
	}
	
	public function save()
	{
		$CJAX = geoCJAX::getInstance();
		//make it like they are used to
		if (!count($_POST)) {
			$_POST = $_GET;
		}
		$item = $CJAX->get('item');
		$group = intval($CJAX->get('group'));
		$admin = geoAdmin::getInstance();
		
		$gateway = geoPaymentGateway::getPaymentGateway($item);
		if (method_exists($gateway,'admin_update_payment_gateways')) {
			if (!$gateway->admin_update_payment_gateways()) {
				if ($admin->getMessageCount() == 0) {
					geoAdmin::m('An error occurred, please try again.',geoAdmin::ERROR,1);
					return;
				}
			} else {
				$gateway->serialize();
			}
		}
		
		$CJAX->link = true;
		$config = "<div id='update_config_$item'>
			<a id='configure' href='javascript:void(0);' onclick=\"configureGateway({$group},'$item',".geoUtil::time().", ".geoUtil::time().")\" class='mini_button'>Configure</a>
			</div>";
		if ($admin->getMessageCount() == 0) {
			//display message
			geoAdmin::m('Settings Saved.',geoAdmin::SUCCESS, 1);
		}
		$CJAX->update('update_config_'.$item,$config);
		//$CJAX->update("container_$item");
		
		$CJAX->update("container_$item");
	}
	
	public function update_payment_gateways ()
	{
		if (!count($_POST)) {
			$_POST = $_GET;
		}
		$cjax = geoCJAX::getInstance();
		
		$group = intval($cjax->get('group'));
		geoPaymentGateway::setGroup($group);
		
		geoPaymentGateway::callUpdate('admin_update_payment_gateways_custom');//allow gateways to save any custom stuff
		
		if ((isset($_POST['enabled_gateways']) && is_array($_POST['enabled_gateways']))){

			//save enabled and default settings.
			
			$types = array();
			$typeAlert = $default = false;
			$default_gateway = $cjax->get('default_gateway');
			foreach ($_POST['enabled_gateways'] as $name => $val){
				$enabled = ($val)? 1: 0;
				$gateway = geoPaymentGateway::getPaymentGateway($name);
				if (!is_object($gateway)) continue;
				
				if (method_exists($gateway,'admin_update_payment_gateways')){
					$result = $gateway->admin_update_payment_gateways();
					if (!$result) continue;
				}

				//check for multiples of this gateway type
				$type = $gateway->getType();
				if ($enabled) {
					if (in_array($type, $types) && !$typeAlert) {
						//we've already read an enabled gateway of this type
						//inform user, but do not block
							
						$cjax->alert('Warning: You have two or more gateways of type "'.$type.'" enabled. This may cause undesired and/or anomalous behavior. We recommend enabling only a single "'.$type.'" gateway.');
						//only want to show one alert...
						$typeAlert = true;
					}
					//add to array of enabled types
					$types[] = $type;
				}
				
				//set enabled
				$gateway->setEnabled($enabled);
				
				if ($enabled && $default_gateway == $name){
					$gateway->setDefault(1);
					$default = 1;
				} else {
					$gateway->setDefault(0);
				}
				$gateway->serialize();
			}
			if (!$default && count($types)) {
				//auto select a default, use first one
				$gateway = geoPaymentGateway::getPaymentGateway($types[0]);
				if (is_object($gateway) && $gateway->getType() == $types[0]) {
					//set this to default
					$gateway->setDefault(1);
					$gateway->serialize();
				}
			}
		}
		
		$admin = geoAdmin::getInstance();
		$admin->message('Setting Saved.');
		geoCJAX::getInstance()->message($admin->message(),4);
		return true;
	}
	
	private function _ajax_movePosition()
	{
		$CJAX = geoCJAX::getInstance();
		$position = $CJAX->get('move');
		$item = $CJAX->get('item');
		
		$gateway = geoPaymentGateway::getPaymentGateway($item);
		if (!is_object($gateway)){
			$CJAX->alert('Error: Invalid gateway for '.$item);
			return false;
		}
		$current_display_order = $gateway->getDisplayOrder();
		
		//go through existing gateways, and figure out what gateway is one up or
		//down from current one.
		$sorted_gateways =& geoPaymentGateway::getPaymentGateway('sorted');
		
		$new_order = $current_display_order + (($position == 'up')? -1: 1);
		$flop = true;
		$keys = array_keys($sorted_gateways[$new_order]);
		$max = geoPaymentGateway::getMaxDisplayOrder();
		while ($new_order > 1 && $new_order < $max && 
		!(isset($sorted_gateways[$new_order]) && is_object($sorted_gateways[$new_order][$keys[0]]) && method_exists($sorted_gateways[$new_order][$keys[0]],'admin_display_payment_gateways'))){
			//keep incrementing until we get to a display order that:
			//1.  has a gateway associated with that display order.
			//2.  The gateway has the function defined so we know it will be showing up in the list.
			
			$new_order = $new_order + (($position == 'up')? -1: 1);
			//get keys for new order...
			$keys = array_keys($sorted_gateways[$new_order]);
		}
		if (!isset($sorted_gateways[$new_order])){
			//could not find one to flop with, so just increment or decrement by one,
			//and set it to not flop, only flip...
			$new_order = $current_display_order + (($position == 'up')? -1: 1);
			$flop = false;
		}
		
		$gateway->setDisplayOrder($new_order);
		$gateway->save();
		if ($flop){
			$keys = array_keys($sorted_gateways[$new_order]);
			$gateway2 =& $sorted_gateways[$new_order][$keys[0]];
			
			//$CJAX->alert('rowname:'.$gateway2->getName());
			if (!is_object($gateway2)){
				//oops!
				$CJAX->alert('Error, replacement gateway is not valid!  name: '.geoString::specialChars(print_r($sorted_gateways[$new_order],1)));
				return false;
			}
			//now set the order for both
			$gateway2->setDisplayOrder($current_display_order);
			$gateway2->save();
		} else {
			$CJAX->alert('no flop!');
		}
		
		return true;
	}
	
}