<?php
//homeLicense.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20976              $ ##
## File last change date:       ##
##  $Date:: 2011-01-21 14:50:#$ ##
##                              ##
##################################

// DON'T FORGET THIS
if(class_exists( 'admin_AJAX' ) or die());

class ADMIN_AJAXController_homeLicense extends admin_AJAX {
	
	public function getNews ()
	{
		//get news from RSS
		require_once ADMIN_DIR.'rss_news_reader.php';
		//$reader = new rss_reader('http://www.geodesicsolutions.com/coblog/feed/');
		$reader = new rss_reader('http://geodesicsolutions.com/latest-software-news-blog.feed?type=rss');
		$reader->setTitle('Geodesic Solutions News');
		$reader->setMaxEntries(4);
		
		$html = $reader->get_feed_html();
		
		//see if addons want to add to it
		$html .= geoAddon::triggerDisplay('admin_home_display_news');
		
		echo $html;
	}
	
	public function getLicenseData ()
	{
		$tpl = new geoTemplate('admin');
		$db = DataAccess::getInstance();
		if (defined('DEMO_MODE')) {
			$key = 'DEMO';
		} else if (defined('DEMO_MODE_TEXT')) {
			$key = DEMO_MODE_TEXT;
		} else {
			$key = $db->get_site_setting('license');
		}
		$settings['licenseKey'] = $key;
		$settings['version'] = $version = geoPC::getVersion();
		$settings['latestVersion'] = $latest = geoPC::getLatestVersion();
		
		if (!$latest) {
			$settings['versionNote'] = "<strong style='color: red;'>Error retrieving latest version.</strong>";
		} else if (version_compare($version, $latest, '<')) {
			$settings['versionNote'] = "<strong style='color: red;'>There is a new version available!</strong>";
			$updateUrl = 'http://geodesicsolutions.com/support/updates/?';
			if (geoPC::is_class_auctions()) {
				$updateUrl .= 'product=GeoClassAuctions&amp;';
			} else if (geoPC::is_classifieds()) {
				$updateUrl .= 'product=Geo+Classifieds&amp;';
			} else {
				$updateUrl .= 'product=Geo+Auctions&amp;';
			}
			
			if (geoPC::is_ent()) {
				$updateUrl .= 'edition=Enterprise&amp;';
			} else if (geoPC::is_premier()) {
				$updateUrl .= 'edition=Premier&amp;';
			} else if (geoPC::is_basic()) {
				$updateUrl .= 'edition=Basic&amp;';
			} else {
				$updateUrl .= 'edition=Lite&amp;';
			}
			
			$updateUrl .= 'version='.urlencode($version).'&amp;method=wizard';
			
			$settings['updateInstructionsUrl'] = $updateUrl;
		} else {
			$settings['versionNote'] = "<strong style='color: green;'>Software is up to date.</strong>";
		}
		
		$exp = geoPC::getLocalLicenseExpire();
		if (!defined('DEMO_MODE_TEXT') && $exp != 'never' && $exp != 'pending...' && $exp > 0) {
			$exp = date ('F j, Y', $exp);
		}
		$settings['localLicenseExp'] = (defined('DEMO_MODE'))? 'DEMO': $exp;
		
		$exp = geoPC::getLicenseExpire();
		if (!defined('DEMO_MODE_TEXT') && $exp != 'never' && $exp != 'pending...' && $exp > 0) {
			$exp = date ('F j, Y', $exp);
		}
		$settings['licenseExp'] = (defined('DEMO_MODE'))? 'DEMO': $exp;
		
		$exp = geoPC::getSupportExpire();
		$settings['updatesExpired'] = false;
		if ($exp === false) {
			$exp = 'Unknown (Error checking geodesicsolutions.com site)';
		} else if (!$exp) {
			$exp = '<span style="color: red; font-weight: bold;">None Found!</span>';
		} else if (!defined('DEMO_MODE_TEXT') && $exp!='never') {
			$currentTime = geoUtil::time();
			
			$expTime = $exp;
			$exp = date ('F j, Y', $exp);
			
			if ($expTime > $currentTime) {
				$left = $expTime - $currentTime;
				$left = floor($left / (60*60*24));
				$exp .= " (<strong style='color: ".(($left < 30)? 'red;': 'green').";'>$left days left</strong>)";
			} else {
				$settings['updatesExpired'] = true;
				$exp .= " (<strong style='color: red;'>Expired!</strong>)";
			}
		}
		
		$settings['supportExp'] = $exp;
		if (!defined('DEMO_MODE_TEXT')) {
			$settings['packageId'] = $packageId = geoPC::getPackageId();
			if ($packageId) {
				$settings['downloadLink'] = 'https://geodesicsolutions.com/geo_store/customers/index.php?task=my_package_details&package_id='.$packageId.'&tab=downloads';
			}
		}
		$settings['support_updates_moreInfo_link'] = 'http://geodesicsolutions.com/software-services/61-software-support-update-service/211-software-support-update-service.html';
		$settings['contactLink'] = 'mailto:sales@geodesicsolutions.com';
		
		$settings['maxSeats'] = geoPC::maxSeats();
		if ($settings['maxSeats']==-1) $settings['maxSeats']='Unlimited';
		$settings['currentSeats'] = geoSession::currentAdminSeats();
		
		$settings['show_upgrade_pricing'] = (geoPC::is_ent()) ? false : true;
		
		$tpl->assign($settings);
		echo $tpl->fetch('home_license_ajax.tpl');
	}
}