<?php
//admin_messaging_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 18386              $ ##
## File last change date:       ##
##  $Date:: 2009-12-09 18:46:#$ ##
##                              ##
##################################

class Admin_messaging extends Admin_site {

	var $debug_messaging = 0;
	var $do_not_email = 0;  //0 sends the emails, 1 does not send the email
	//var $limit = 50; //number of emails to send with each iteration before script resets form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Admin_messaging($db=0, $product_configuration=0)
	{
		$this->Admin_site($db, $product_configuration);
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function admin_messaging_form($db = 0,$list_info=0,$message_id=0)
	{
		if (!$this->admin_demo())$this->body .= "
<form action='index.php?page=admin_messaging_send' method='post'>
<fieldset id='SendMessage'>
	<legend>Send a Message</legend>
	<table cellpadding='3' cellspacing='0' border='0' align='center' width=\"100%\">
		<tr>
			<td width='22%' valign='top' rowspan='2'>
				<table cellpadding='1' cellspacing='1' border='0' align='center' width='100%'>
					<tr>
						<td colspan='2' class='col_hdr_left' valign='top'>
							List of Recipients
						</td>
					</tr>";
		$this->row_count = 0;

		$this->row_count++;
		$users_only = false;
		if ((is_array($list_info) && count($list_info) > 0) )
		{
			reset($list_info);
			while (list($key,$value) = each($list_info))
			{
				if ($key != "all" && strpos($key,'group')===0)
				{
					//it's a group yo
					//get the group name..
					$sql = 'SELECT name FROM '.geoTables::classified_groups_table.' WHERE group_id = '.$value;
					$result_gname = $this->db->Execute($sql);
					if (!$result_gname){
						$name = 'Unknown';
					} else {
						$row = $result_gname->FetchRow();
						$name = $row['name'];
					}

					$html .= "
					<tr class='".$this->get_row_color()."'>
						<td align='right' class='small_font'>
							$name
						</td>
						<td>
							<input type='checkbox' name='b[".$key."]' value=\"$value\" />
						</td>
					</tr>";
					$this->row_count++;
				}
				elseif ($key != 'all')
				{
					$users_only = true;
					//it's a user yo
					/*
					 * Default to be checked - LEAVE IT THIS WAY
					 * it defaults to checked because you get to this page from the
					 * search users page, and there can be tons and tons of users found.  It would
					 * neglect any benifit this feature might add if they have to go through and
					 * check Every Single User, insted it should stay so that it defaults
					 * to be checked for all the users found in the search.
					 * 
					 * We might consider adding a JS check/uncheck all, but do NOT make it
					 * default to un-checked as a solution.
					 */
					$html .= "
					<tr class=".$this->get_row_color().">
						<td align=right class=small_font>
							$value
						</td>
						<td>
							<input type=\"checkbox\" checked='checked' name=\"b[$key]\" value=\"$value\" />
						</td>
					</tr>";
					$this->row_count++;
				}
			}
		}
		
		
		
		if (geoPC::is_ent() || geoPC::is_premier() || geoPC::is_basic())
		{
			$non_lite = true;
		}
		else
		{
			//if is lite, making sure that only the default group is set
			$html .= "<input type='hidden' name=b[group0] value='1'>";
			$html .= "<tr class=".$this->get_row_color().">
						<td align=right valign=top class=medium_font>
							<b>General group</b>
						</td>
						<td>
						</td>
					</tr>
				</table>";
		}
		
		
		if (!$users_only && $non_lite){
			$this->body .= "
					<tr class=".$this->get_row_color().">
						<td align=right valign=top class=medium_font>
							<b>All Groups</b>
						</td>
						<td>
							<input type=checkbox name=b[all] value=1".(($list_info["all"] == 1)? ' checked="checked"': '')." />
						</td>
					</tr>
					$html
					<tr>
						<td colspan=2 class=col_hdr_left>
							Groups 
						</td>
					</tr>\n\t";
			$sql = "select name, group_id from ".$this->classified_groups_table." order by group_id";
			$result = $this->db->Execute($sql);
			if(!$result)
			{
				trigger_error('ERROR SQL MESSAGE: Query error, sql: '.$sql.' error: '.$this->db->ErrorMsg());
				//close tags to be nice
				$this->body .= "
				</table>
			</td>
		</tr>
	</table>
</fieldset>
</form>";
				
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			else
				$group_number = 0;
			while($group = $result->FetchRow())
			{
				$this->body .= "
					<tr class=".$this->get_row_color().">
						<td align=right valign=top class=medium_font>
							<b>".$group["name"]."</b> 
						</td>
						<td>
							<input type=checkbox name=b[group".$group_number."] value=".$group["group_id"].">
						</td>
					</tr>";
				$group_number++;
			}

		} else {
			$this->body .= $html;
		}


		$this->body .= "
				</table>
			</td>
			<td width=78% valign=top>
				<table cellpadding=1 cellspacing=1 border=0 align=center width=100%>";
		
		if ($message_id) {
			if (($message_id["message_type"] == "Select Form Message") && $message_id["message_id_form"])
				$this->message_sql_query = "select * from ".$this->form_messages_table." where message_id = ".$message_id["message_id_form"];
			elseif ($message_id["message_id_past"])
				$this->message_sql_query = "select * from ".$this->past_messages_table." where message_id = ".$message_id["message_id_past"];
			
			$result = $this->db->Execute($this->message_sql_query);
			if (!$result) {
				trigger_error('ERROR SQL: sql: '.$this->message_sql_query.' Error msg: '.$this->db->ErrorMsg());
				return false;
			}
			if ($result->RecordCount() == 1) {
				//get message
				$show_message = $result->FetchRow();
				$message = geoString::fromDB($show_message["message"]);
				$subject = $show_message["subject"];
				$name_of_message = $show_message["message_name"];
				$content_type = $show_message['content_type'];
			}
			$select_plain = ($content_type == 'text/html')? '':' selected="selected"';
			$select_html = ($content_type == 'text/html')? ' selected="selected"':'';

			$this->body .= "
					<tr>
						<td class=col_hdr>
							<b>Message to Send</b>
						</td>
					</tr>
					<tr>
						<td class=medium_font>
							Confirm the message and subject by reviewing and editing the form
							below.  Also confirm the list of users to the left.
						</td>
					</tr>
					<tr>
						<td class=\"medium_font\"><strong>Content Type: </strong>
							<select name=\"d[content_type]\">
								<option value=\"text/plain\"$select_plain>Plain Text</option>
								<option value=\"text/html\"$select_html>HTML</option>
							</select>
						</td>
					</tr>
					<tr>
						<td class=medium_font>
							<strong>Message name:</strong><br>
							<input type=input size=50 maxsize=100 name=d[message_name] value='{$name_of_message}'>
						</td>
					</tr>
					<tr>
						<td class=medium_font>
							<strong>Subject:</strong><br>
							<input type=input size=50 maxsize=100 name=d[subject] value='{$subject}'>
						</td>
					</tr>
					<tr>
						<td class=medium_font>
							<strong>Message:</strong><br><textarea name=d[message] cols=50 rows=20>".geoString::specialChars($message)."</textarea>
						</td>
					</tr>";
		} else {
			$this->body .= "
				<tr>
					<td class=col_hdr>
						<b>Message to Send</b>
					</td>
				</tr>
				<tr>
					<td class=page_note>
						Select either a \"Recent Message\", a \"Form Message\", or create a new message using the form below. When selecting a \"Recent\" or \"Form\" message,
						you will have the opportunity to \"edit\" the message prior to sending it out.
					</td>
				</tr>";
			//display the past messages list
			$this->get_last_ten_messages_list($db);

			//display the form messages list
			$this->get_form_messages_list($db);
			$select_plain = ($content_type == 'text/html')? '':' selected="selected"';
			$select_html = ($content_type == 'text/html')? ' selected="selected"':'';
			$this->body .= "
				<tr>
					<td class=\"medium_font\"><strong>Content Type: </strong>
						<select name=\"d[content_type]\">
							<option value=\"text/plain\"$select_plain>Plain Text</option>
							<option value=\"text/html\"$select_html>HTML</option>
						</select>
					</td>
				</tr>
				<tr>
					<td class=medium_font>
						<strong>Message name: </strong><br>
						<input type=input size=50 maxsize=100 name=d[message_name] value='{$name_of_message}'>
					</td>
				</tr>
				<tr>
					<td class=medium_font>
						<strong>Subject: </strong><br>
						<input type=input size=50 maxsize=100 name=d[subject] value='{$subject}'>
					</td>
				</tr>
				<tr>
					<td class=medium_font>
						<strong>Message: </strong><br>
						<textarea name=d[message] cols=50 rows=20>".geoString::specialChars($message)."</textarea>
					</td>
				</tr>";
		}
		if (!$this->admin_demo()) $this->body .= "<tr>\n\t<td align=center valign=top>\n\t<input type=submit name='auto_save' value=\"Send\">\n\t</td>\n</tr>\n";
		$this->body .= "</table>\n\t</td>\n</tr>\n";
		$this->body .= "</table></fieldset>\n</form>";
		return true;
	} //end of function admin_message_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_last_ten_messages_list($db)
	{
		//get the last ten messages
		$sql = "select `message_id`,`subject`,`date_sent` from ".$this->past_messages_table." order by date_sent desc limit 0,10";
		$past_messages_result = $this->db->Execute($sql);
		if (!$past_messages_result)
		{
			$this->site_error($this->db->ErrorMsg());
			return false;
		}
		elseif ($past_messages_result->RecordCount() > 0)
		{
			$this->body .= "<tr>\n\t\t<td>\n\t\t<select name=c[message_id_past]>\n\t\t\t";
			while ($show = $past_messages_result->FetchRow())
			{
				$this->body .= "<option value=".$show["message_id"].">".$show["subject"]." - ".date($this->configuration_data['entry_date_configuration'],$show["date_sent"])."</option>\n\t\t\t";
			}
			$this->body .= "</select>\n\t\t";
			if (!$this->admin_demo()) $this->body .= "<input type=submit name=c[message_type] value=\"Select Recent Message\">\n\t\t";
			$this->body .= "</td>\n\t</tr>\n\t";
		}

	} //end of function get_last_ten_messages_list

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_form_messages_list($db)
	{
		//get the form messages list
		$sql = "select `message_id`,`message_name` from ".$this->form_messages_table." order by message_name";
		$form_messages_result = $this->db->Execute($sql);
		if (!$form_messages_result)
		{
			$this->site_error($this->db->ErrorMsg());
			return false;
		}
		elseif ($form_messages_result->RecordCount() > 0)
		{
			$this->body .= "<tr>\n\t\t<td>\n\t\t<select name=c[message_id_form]>\n\t\t\t";
			while ($show = $form_messages_result->FetchRow())
			{
				$this->body .= "<option value=".$show["message_id"].">".$show["message_name"]."</option>\n\t\t\t";
			}
			$this->body .= "</select>\n\t\t";
			if (!$this->admin_demo()) $this->body .= "<input type=submit name=c[message_type] value=\"Select Form Message\">\n\t\t";
		}
		else
		{
			$this->body .= "<tr>\n\t\t<td class=medium_font align=center>\n\t<div class=page_note_error>There are currently no form messages to display.</div> \n\t\t";
		}
		//echo "<br><a href=index.php?a =26><span class=medium_font>click to add or edit form messages</span></a>";
		$this->body .= "</td>\n\t</tr>\n\t";

	} //end of function get_form_messages_list

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_form_messages_list($db)
	{
		//get the form messages list
		if (!$this->admin_demo())$this->body .= "<form action=index.php?mc=admin_messaging&page=admin_messaging_form method=post>\n\t";
		$this->body .= "<table cellpadding=2 cellspacing=0 border=0 align=center width=100%>\n\t";
		//$this->title = "Messaging > Form Messages";
		$sql = "select `message_name`,`message_id`,`content_type` from ".$this->form_messages_table." order by message_name";
		$form_messages_result = $this->db->Execute($sql);
		if (!$form_messages_result)
		{
			$this->site_error($this->db->ErrorMsg());
			return false;
		}
		elseif ($form_messages_result->RecordCount() > 0)
		{
			$this->row_count = 0;
			$this->body .= "<tr>\n\t<td colspan=2 align=center>\n\t<fieldset id='FormMessages'><legend>Form Messages</legend><table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n\t";
			$this->body .= "<tr>\n\t\t<td class=col_hdr_left>\n\t<b>Message Name</b> \n\t\t</td>\n\t\t";
			$this->body .= "<td class=\"col_hdr_left\"><strong>Content Type</strong></td>\n";
			$this->body .= "<td colspan=2 class=col_hdr>\n\t&nbsp;\n\t\t</td>\n\t</tr>\n\t";
			while ($show = $form_messages_result->FetchRow())
			{
				$this->body .= "<tr class=".$this->get_row_color().">\n\t\t<td class=medium_font>".$show["message_name"]." \n\t\t</td>\n\t\t";
				$this->body .= "<td class=\"medium_font\">{$show['content_type']}</td>";
				$this->body .= "<td width=100 align=center>\n\t\t".geoHTML::addButton('edit', "index.php?mc=admin_messaging&page=admin_messaging_form&b=".$show["message_id"])."\n\t\t</td>\n\t\t";
				$this->body .= "<td width=100 align=center>\n\t\t".geoHTML::addButton('delete', "index.php?mc=admin_messaging&page=admin_messaging_form&c=".$show["message_id"]."&auto_save=1", false, '', 'lightUpLink mini_cancel')."\n\t\t</td>\n\t</tr>\n\t";
				$this->row_count++;
			}
			$this->body .= "</table></fieldset>\n\t</td>\n</tr>\n";
		}
		else
		{
			$this->body .= "<tr>\n\t\t<td colspan=2 class=medium_font align=center>\n\t<div class=page_note_error>There are currently no form messages to display.</div> \n\t\t";
		}

		//display the form to add a new form message
		$this->body .= "<tr>\n\t<td colspan=2 align=center>\n\t<fieldset id='NewMessage'><legend>Create a New Form Message</legend><table cellpadding=2 cellspacing=0 border=0 width=\"100%\">\n\t";
    	$this->body .= "
				<tr>
					<td class=\"medium_font\" width=\"50%\" align=\"right\"><strong>Content Type:</strong></td><td class=\"medium_font\" width=\"50%\">
						<select name=\"d[content_type]\">
							<option value=\"text/plain\">Plain Text</option>
							<option value=\"text/html\">HTML</option>
						</select>
					</td>
				</tr>";
		$this->body .= "<tr>\n\t<td align=right width=50% class=medium_font>\n\t<b>Form Message Name:</b> \n\t</td>\n\t";
		$this->body .= "<td width=50% class=medium_font>\n\t<input type=text name=d[form_name] size=30 maxsize=50> \n\t</td>\n</tr>\n";
		$this->body .= "<tr>\n\t<td align=right class=medium_font>\n\t<b>Form Subject:</b> \n\t</td>\n\t";
		$this->body .= "<td class=medium_font>\n\t<input type=text name=d[form_subject] size=30 maxsize=50> \n\t</td>\n</tr>\n";
		$this->body .= "<tr>\n\t<td colspan=2 align=center valign=top class=medium_font>\n\t<b>Form Message:</b><br>
			<textarea name=d[form_message] cols=50 rows=20></textarea> \n\t</td>\n</tr>\n";
		if (!$this->admin_demo())
		{
			$this->body .= "<tr>\n\t<td colspan=2 class=medium_font align=center>\n\t<input type=submit name=submit value=\"Save\">
				 \n\t</td>\n</tr>\n";
		}
		$this->body .= "</table></fieldset>\n\t</td>\n</tr>\n</table>\n</form>\n";
		return true;
	} //end of function get_form_messages_list

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function form_message_edit($db,$message_id=0)
	{
		if ($message_id)
		{
			//get the form messages list
			$sql = "select * from ".$this->form_messages_table." where message_id = ".$message_id;
			$form_messages_result = $this->db->Execute($sql);
			if (!$form_messages_result)
			{
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			elseif ($form_messages_result->RecordCount() == 1)
			{
				$show = $form_messages_result->FetchRow();
				if (!$this->admin_demo())$this->body .= "<form action=index.php?mc=admin_messaging&page=admin_messaging_form&b=".$message_id." method=post>\n\t";
				$this->body .= "<fieldset id='EditFormMessage'><legend>Edit a Form Message</legend><table cellpadding=2 cellspacing=0 border=0 align=center width=\"100%\">\n\t";
				//$this->title = "Messaging > Edit Form Message";
				$this->description = "Edit the chosen form message below.  When you are through click the \"save\" button.";
				$select_plain = ($show['content_type']=='text/html')? '':' selected="selected"';
				$select_html = ($show['content_type']=='text/html')? ' selected="selected"':'';
				$message_name = geoString::specialChars($show['message_name']);
				$subject=geoString::specialChars($show['subject']);
				$message = geoString::specialChars(geoString::fromDB($show['message']));
				$this->body .= "
				<tr class=row_color1>
					<td class=\"medium_font\" align=\"right\"><strong>Content Type:</strong></td><td class=\"medium_font\">
						<select name=\"e[content_type]\">
							<option value=\"text/plain\"$select_plain>Plain Text</option>
							<option value=\"text/html\"$select_html>HTML</option>
						</select>
					</td>
				</tr>";
				$this->body .= "<tr class=row_color2>\n\t<td align=right class=medium_font>\n\t<b>Form Message Name:</b> \n\t</td>\n\t";
				$this->body .= "<td class=medium_font>\n\t
					<input type=text name=e[form_name] size=30 maxsize=50 value=\"".$message_name."\"> \n\t</td>\n</tr>\n";
				$this->body .= "<tr class=row_color1>\n\t<td align=right class=medium_font>\n\t<b>Form Subject:</b> \n\t</td>\n\t";
				$this->body .= "<td class=medium_font>\n\t
					<input type=text name=e[form_subject] size=30 maxsize=50 value=\"".$subject."\"> \n\t</td>\n</tr>\n";
				$this->body .= "<tr class=row_color2>\n\t<td colspan=2 align=center class=medium_font>\n\t<b>Form Message:</b><br>
					<textarea name=e[form_message] cols=65 rows=20>".$message."</textarea> \n\t</td>\n</tr>\n";
				if (!$this->admin_demo())
				{
					$this->body .= "<tr>\n\t<td colspan=2 class=medium_font align=center>\n\t<input type=submit name=submit value=\"Save\">
					 \n\t</td>\n</tr>\n";
				}
				$this->body .= "</table></fieldset>\n</form>\n";
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	} //end of function form_message_edit

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_new_message($db,$message_info=0)
	{
		if ($message_info)
		{
			if ((strlen(trim($message_info["form_name"])) > 0) &&
				(strlen(trim($message_info["form_subject"])) > 0) &&
				(strlen(trim($message_info["form_message"])) > 0))
			{
				//insert the new info
				$sql = "insert into ".$this->form_messages_table."
					(message_name,subject,message, content_type)
					values
					(?, ?, ?, ?)";
				$query_data = array ($message_info["form_name"],$message_info["form_subject"],geoString::toDB($message_info["form_message"]), $message_info['content_type']);
				if ($this->debug_messaging) echo $sql."<bR>\n";
				$result = $this->db->Execute($sql, $query_data);
				if (!$result)
				{
					echo 'Error:'.__line__.$sql.$this->db->ErrorMsg();
					if ($this->debug_messaging) echo $sql."<bR>\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				return true;
			}
			else
			{
				echo 'message data length wrong.';
				return false;
			}
		}
		else
		{
			echo 'message data not passed.';
			return false;

		}

	} //end of function insert_new_message

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_form_message($db,$message_id=0)
	{
		if ($message_id)
		{
			//insert the new info
			$sql = "delete from ".$this->form_messages_table."
				where message_id = ".$message_id;
			if ($this->debug_messaging) echo $sql."<bR>\n";
			$result = $this->db->Execute($sql);
			if (!$result)
			{
				if ($this->debug_messaging) echo $sql."<bR>\n";
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			return true;
		}
		else
		{
			return false;
		}

	} //end of function delete_form_message

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_message_form($db,$message_id=0,$message_info=0)
	{
		if (($message_id) && ($message_info))
		{
			if ((strlen(trim($message_info["form_name"])) > 0) &&
				(strlen(trim($message_info["form_subject"])) > 0) &&
				(strlen(trim($message_info["form_message"])) > 0))
			{
				//insert the new info
				$sql = "update ".$this->form_messages_table." set
					message_name = ?,
					subject = ?,
					message = ?,
					content_type = ?
					where message_id = ".$message_id;
				$query_data = array ($message_info["form_name"],$message_info["form_subject"],geoString::toDB($message_info["form_message"]), $message_info['content_type']);
				$result = $this->db->Execute($sql, $query_data);
				if (!$result)
				{
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;

		}

	} //end of function update_message_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function send_admin_message($db,$list_info=0,$message_info=0,$start_from=0,$message_id=0)
	{
		$mail = geoEmail::getInstance();
		
		if ($list_info && ($message_info || $message_id))
		{
			$limit = $this->db->get_site_setting('admin_messaging_send_limit');//$this->limit;
			$limit = ($limit)? $limit : 50; //set default value
			if (!$start_from)
				$start_from = 0;

			$todays_date = geoUtil::time();
			if (!$message_id)
			{
				if (count($list_info) > 0)
				{
					reset($list_info);
					while (list($key,$value) = each($list_info))
					{
						if ($key == "all")
						{
							$send_to_all = 1;
						}
						elseif(substr_count($key,"group") > 0)
						{
							$send_to_groups = 1;
							$groups[] = $value;
						}
					}
				}
				if(!$send_to_all)
					$send_to_all = 0;
				if(!$send_to_groups)
					$send_to_groups = 0;

				if ((strlen(trim($message_info["subject"])) > 0) &&
					(strlen(trim($message_info["message"])) > 0))
				{
					//insert the new info

					$sql = "insert into ".$this->past_messages_table."
						(date_sent,all_sent,message_name,subject,message, content_type)
						values (?, ?, ?, ?, ?, ?)";
					$query_data = array($todays_date, $send_to_all, $message_info["message_name"], $message_info["subject"], geoString::toDB($message_info["message"]), $message_info['content_type']);
					$result = $this->db->Execute($sql, $query_data);
					if ($this->debug_messaging) echo $sql."<bR>\n";
					if (!$result)
					{
						if ($this->debug_messaging) echo $sql."<bR>\n";
						$this->site_error($this->db->ErrorMsg());
						return false;
					}
					$message_id = $this->db->Insert_ID();
				}
			}
			else
			{
				if ($list_info == 1)
					$send_to_all = 1;
				else{
					$send_to_all = 0;
					$send_to_groups = 1;
					$groups = $list_info;
				}

				$sql = "select * from ".$this->past_messages_table."
					where message_id = ".$message_id;
				$result = $this->db->Execute($sql);
				if ($this->debug_messaging) echo $sql."<bR>\n";
				if (!$result)
				{
					if ($this->debug_messaging) echo $sql."<bR>\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					$show_message = $result->FetchRow();
					$message_info["subject"] = $show_message["subject"];
					$message_info["message"] = geoString::fromDB($show_message["message"]);
					$message_info["message_name"] = $show_message["message_name"];
					$message_info['content_type'] = $show_message['content_type'];
				}
				else
				{
					return false;
				}
			}

			$subject = $message_info["subject"];
			$message = $message_info["message"];
			$content_type = (isset($message_info['content_type']))? $message_info['content_type'] : 0;

			if ($send_to_all || $send_to_groups)
			{
				if ($send_to_all){
					$group_query = '';
				} else {
					//sending to groups
					$group_query = 'and groups.group_id in ( '.implode(', ',$groups).' )';
				}
				
				$anon = geoAddon::getRegistry('anonymous_listing');
				$anon_query = '';
				if($anon) {
					$anon_user_id = $anon->get('anon_user_id',false);
					if($anon_user_id) {
						$anon_query = " and groups.id <> '".$anon_user_id."' ";
					}
				}
				
				//$sql = "select count(*) as total_receivers from ".$this->userdata_table." where id != 1";
				$sql = "select count(*) as total_receivers from ".$this->user_groups_price_plans_table." as groups where groups.id != 1 ".$anon_query.$group_query;

				$total_result = $this->db->Execute($sql);
				if ($this->debug_messaging) echo $sql."<bR>\n";
				if (!$total_result)
				{
					if ($this->debug_messaging) echo $sql."<bR>\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				//$sql = "select username,email from ".$this->userdata_table." where id != 1 limit ".$start_from.",".$limit;
				$sql = "select user.id as id, username, email from ".$this->userdata_table." as user, ".$this->user_groups_price_plans_table." as groups where user.id = groups.id and user.id != 1 ".$anon_query.$group_query. " limit $start_from, $limit";

				$result = $this->db->Execute($sql);
				if ($this->debug_messaging) echo $sql."<bR>\n";
				if (!$result)
				{
					if ($this->debug_messaging) echo $sql."<bR>\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				elseif (($result->RecordCount() > 0) && ($total_result))
				{
					$show_total = $total_result->FetchRow();
					if ($show_total["total_receivers"] > $limit)
					{
						//loop through the emails using the limit as the max number per invocation
						$this->body .= "<html><head><title>sent to ".$start_from." of ".$show_total["total_receivers"]." so far</title>";
						if (!$send_to_all && $send_to_groups){
							$count = 1;
							foreach ($groups as $group){
								$b []='b['.$count.']='.$group;
								$count++;
							}
							$b = implode('&',$b);
						} else {
							$b = 'b=1';
						}
						$all = ($send_to_all)? '&all=1':'&all=0';
						$delay = $this->db->get_site_setting('admin_messaging_refresh_delay');
						$delay = ($delay)? $delay : 10;
						$this->body .= "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"$delay;URL=".$_SERVER['PHP_SELF']."?mc=admin_messaging&page=admin_messaging_send&e={$message_id}&{$b}&start_from=".($start_from + $limit)."\">";
						$this->body .= "</head><body><table width=\"100%\">";
						$this->body .= "<tr class=row_color_black><td class=medium_font_light>Emails have just been sent to:</td></tr>";
						while ($show = $result->FetchRow())
						{
							@set_time_limit(300);
							if (!$this->do_not_email)
							{
								//send e-mail
								$mail->addQueue($show["email"],$subject,$message,0,0,0,$content_type);
							}
							$this->body .= "<tr class=".$this->get_row_color().">\n\t
								<td class=medium_font>\n\t".$show["username"]." - ".$show["email"]." \n\t</td>\n</tr>\n";
							if (!$send_to_all){
								$sql = "insert into ".$this->past_messages_recipients_table."
									(user_id,message_id)
									values
									(".$show['id'].",".$message_id.")";
								$user_record_result = $this->db->Execute($sql);
							}
							$this->row_count++;
						}
						//save the queue
						$mail->saveQueue();
						$this->body .= "<tr class=row_color_black><td class=medium_font_light>sent to ";
						if (($start_from + $limit) > $show_total["total_receivers"])
							$this->body .= "all chosen recipients";
						else
							$this->body .= ($start_from + $limit)." of ".$show_total["total_receivers"]." so far</td></tr>";
						$this->body .= "</table></body></html>";

					}
					else
					{
						$subject_output = geoString::specialChars($subject);
						$message_output = ($content_type == 'text/html')? $message : nl2br(geoString::specialChars($message));

						$this->body .= "<fieldset id='MessageSent'><legend>Message Sent</legend><table cellpadding=3 cellspacing=1 border=0 align=center width=\"100%\">\n";
						//$this->title .= "Admin Messaging";
						$this->description .= "The following message has been sent.";
						$this->body .= "<tr>\n\t<td valign=top align=left class=medium_font width=\"20%\">\n\t<b>Subject:</b> \n\t</td>\n\t";
						$this->body .= "<td class=medium_font>\n\t".$subject_output." \n\t</td>\n</tr>\n";
						$this->body .= "<tr><td class='medium_font'>Content Type:</td><td style='medium_font'>$content_type</td></tr>";
						$this->body .= "<tr>\n\t<td valign=top align=left class=medium_font>\n\t<b>Message:</b> \n\t</td>\n\t";
						$this->body .= "<td class=medium_font>\n\t$message_output\n\t</td>\n</tr>\n";
						$this->body .= "<tr>\n\t<td colspan=2 class=medium_font_btop><strong>Message Sent to the Following Recipients:</strong></td>\n</tr>\n";
						$this->row_count = 0;

						while ($show = $result->FetchRow())
						{
							@set_time_limit(300);
							if (!$this->do_not_email)
							{
								//send e-mail
								$mail->addQueue($show["email"],$subject,$message,0,0,0,$content_type);
							}
							$this->body .= "<tr class=".$this->get_row_color().">\n\t
								<td colspan=2 class=medium_font>\n\t".$show["username"]." - ".$show["email"]." \n\t</td>\n</tr>\n";
							if (!$send_to_all){
								$sql = "insert into ".$this->past_messages_recipients_table."
									(user_id,message_id)
									values
									(".$show['id'].",".$message_id.")";
								$user_record_result = $this->db->Execute($sql);
							}
							$this->row_count++;
						}
						$mail->saveQueue();
						$this->body .= "</table></fieldset>\n";
					}
				}
				else
				{
					$this->body .= "<table width=\"100%\">";
					$this->body .= "<tr><td align=center class=medium_font><br><br><strong>Your message was sent to complete list.</strong><br><br></td></tr>\n";
					$this->body .= "</table>";
				}
			} else {
				//send to just the ones on the list
				$subject_output = geoString::specialChars($subject);
				$message_output = ($content_type == 'text/html')? $message : nl2br(geoString::specialChars($message));

				$this->body .= "<table cellpadding=0 cellspacing=1 border=0 align=center>\n";
				$this->body .= "<tr class=row_color_black>\n\t<td align=center colspan=2 class=large_font_light>The following
					message has been sent \n\t</td>\n</tr>\n";
				$this->body .= "<tr class=row_color_black>\n\t<td valign=top align=right class=medium_font_light>\n\tsubject: \n\t</td>\n\t";
				$this->body .= "<td class=medium_font_light>\n\t".$subject_output." \n\t</td>\n</tr>\n";
				$this->body .= "<tr><td class='medium_font'>Content Type:</td><td style='medium_font'>$content_type</td></tr>";
				$this->body .= "<tr class=row_color_black>\n\t<td valign=top align=right class=medium_font_light>\n\tmessage: \n\t</td>\n\t";
				$this->body .= "<td class=medium_font_light>\n\t$message_output\n\t</td>\n</tr>\n";
				$this->row_count = 0;
				reset($list_info);
				while (list($key,$value) = each($list_info))
				{
					@set_time_limit(300);
					$sql = "select email from ".$this->userdata_table." where id = ".$key;
					$result = $this->db->Execute($sql);
					if ($this->debug_messaging) echo $sql."<bR>\n";
					if (!$result)
					{
						if ($this->debug_messaging) echo $sql."<bR>\n";
						$this->site_error($this->db->ErrorMsg());
						return false;
					}
					$show_email = $result->FetchRow();
					if ($this->debug_messaging)
					{
						echo $this->db->get_site_setting("email_configuration")." is email config<Br>\n";
						echo $this->db->get_site_setting("email_header_break")." is EMAIL_HEADER_BREAK<br>\n";
					}
					if (!$this->do_not_email)
					{
						//send e-mail
						$mail->addQueue($show_email["email"],$subject,$message, 0, 0, 0, $content_type);
					}
					$this->body .= "<tr class=".$this->get_row_color().">\n\t
						<td colspan=2 class=medium_font>\n\t".$value."- ".$show_email["email"]." \n\t</td>\n</tr>\n";
					$sql = "insert into ".$this->past_messages_recipients_table."
						(user_id,message_id)
						values
						(".$key.",".$message_id.")";
					$result = $this->db->Execute($sql);
					if (!$result)
					{
						if ($this->debug_messaging) echo $sql."<bR>\n";
						$this->site_error($this->db->ErrorMsg());
						return false;
					}
					$this->row_count++;
				} //end of while
				$mail->saveQueue();
				$this->body .= "</table>\n";
			}
			return true;
		}
		else
		{
			//echo "no message info";
			return false;

		}

	} //end of function send_admin_message

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_message_history($db)
	{
		//get the message history list
		$this->body .= "<fieldset id='MessageHistory'><legend>Message History</legend><table cellpadding=2 cellspacing=0 border=0 align=center width=\"100%\">\n\t";
		//$this->title .= "Messaging > Messages Sent";
		$this->description .= "The list below is the list of messages that
			have been sent to registrants in the past.  View details of a specific message by clicking the \"details\" link next to the appropriate
			message.  Delete a message from the history by clicking the \"delete\" link next to the appropriate message.";
		$sql = "select * from ".$this->past_messages_table." order by date_sent desc";
		$form_messages_result = $this->db->Execute($sql);
		if (!$form_messages_result)
		{
			$this->site_error($this->db->ErrorMsg());
			return false;
		}
		elseif ($form_messages_result->RecordCount() > 0)
		{
			$this->row_count = 0;
			$this->body .= '<tr><td colspan="2" style="text-align: center;"><a href="index.php?mc=admin_messaging&page=admin_messaging_history&c=ALL" onclick="return confirm(\'This will permanently erase all saved messages. Are you sure?\');">Clear Message History</a></td></tr>';
			$this->body .= "<tr>\n\t<td colspan=2>\n\t<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n\t";
			$this->body .= "<tr class=row_color_black>\n\t\t<td class=col_hdr_left>\n\tMessage Name\n\t\t</td>\n\t\t";
			$this->body .= "<td class=col_hdr_left>\n\t<b>Date Sent</b> \n\t\t</td>\n\t\t";
			$this->body .= "<td class=col_hdr_left>\n\t<b>Subject</b> \n\t\t</td>\n\t\t";
			$this->body .= "<td class=col_hdr_left>Content Type</td>";
			$this->body .= "<td colspan=2 class=col_hdr_left>\n\t&nbsp; \n\t\t</td>\n\t</tr>\n\t";
			while ($show = $form_messages_result->FetchRow())
			{
				$subject = geoString::specialChars($show['subject']);
				$this->body .= "<tr class=".$this->get_row_color().">\n\t<td valign=top class=medium_font>\n\t".$show["message_name"]." \n\t</td>\n\t";
				$this->body .= "<td valign=top class=medium_font>\n\t".date($this->configuration_data['entry_date_configuration'],$show["date_sent"])." \n\t</td>\n\t";
				$this->body .= "<td valign=top class=medium_font>\n\t".$subject." \n\t</td>\n\t";
				$this->body .= "<td valign=\"top\" class=\"medium_font\">{$show['content_type']}</td>";
				$this->body .= "<td valign=top width=100 align=center>\n\t".geoHTML::addButton('view', "index.php?mc=admin_messaging&page=admin_messaging_history&b=".$show["message_id"])."\n\t</td>\n\t";
				$this->body .= "<td valign=top width=100 align=center>\n\t".geoHTML::addButton('delete', "index.php?mc=admin_messaging&page=admin_messaging_history&c=".$show["message_id"]."&auto_save=1", false, '', 'lightUpLink mini_cancel')."\n\t</td>\n</tr>\n";
				$this->row_count++;
			}
			$this->body .= "</table>\n\t</td>\n</tr>\n";
		}
		else
		{
			$this->body .= "<tr>\n\t\t<td colspan=2 align=center>\n\t<div class=page_note_error>There are currently no messages to display.</div> </td></tr>\n\t\t";
		}
		$this->body .= "</table></fieldset>\n";
		return true;
	} //end of function display_message_history

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_from_message_history($db,$message_id=0)
	{
		//$message_id is either the numerical ID of the message to delete, or 'ALL' to delete all messages
		if ($message_id)
		{
			//insert the new info
			$sql = "delete from ".$this->past_messages_table;
			if($message_id !== 'ALL') {
				$sql .=" where message_id = ".$message_id;
			}
			$result = $this->db->Execute($sql);
			if (!$result)
			{
				$this->site_error($this->db->ErrorMsg());
				return false;
			}

			$sql = "delete from ".$this->past_messages_recipients_table;
			if($message_id !== 'ALL') {
				$sql .=" where message_id = ".$message_id;
			}
			$result = $this->db->Execute($sql);
			if (!$result)
			{
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			return true;
		}
		else
		{
			return false;
		}

	} //end of function delete_form_message

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_message_history_detail($db,$message_id)
	{
		if ($message_id)
		{
			$sql = "select * from ".$this->past_messages_table." where message_id = ".$message_id;
			if ($this->debug_messaging) echo $sql."<bR>\n";
			$result = $this->db->Execute($sql);
			if (!$result)
			{
				if ($this->debug_messaging) echo $sql."<bR>\n";
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchRow();
				$message_name = geoString::specialChars($show['message_name']);
				$subject=geoString::specialChars($show['subject']);
				$message = ($show['content_type']=='text/html')? geoString::fromDB($show['message']):nl2br(geoString::specialChars(geoString::fromDB($show['message'])));

				//get the message details
				$this->body .= "<fieldset id='MessageHistory'><legend>Message Details</legend><table cellpadding=2 cellspacing=0 border=0 align=center width=100%>\n\t";
				//$this->title = "Message History Details";
				$this->description = "Below is the details of the message that was sent.";
				$this->body .= '<tr class=row_color2><td width=50% align="right" class="medium_font"><strong>Content Type: </strong></td>';
				$this->body .= '<td class="medium_font">'.$show['content_type'].'</td>';
				$this->body .= "<tr>\n\t<td align=right class=medium_font>\n\t<b>Message Name: </b> \n\t</td>\n\t";
				$this->body .= "<td class=medium_font>\n\t".$message_name." \n\t</td>\n</tr>\n";
				$this->body .= "<tr class=row_color2>\n\t<td align=right class=medium_font>\n\t<b>Date Sent: </b> \n\t</td>\n\t";
				$this->body .= "<td class=medium_font>\n\t".date($this->configuration_data['entry_date_configuration'],$show["date_sent"])." \n\t</td>\n</tr>\n";
				$this->body .= "<tr>\n\t<td align=right class=medium_font>\n\t<b>Subject: </b> \n\t</td>\n\t";
				$this->body .= "<td class=medium_font>\n\t".$subject." \n\t</td>\n</tr>\n";
				$this->body .= "<tr class=row_color2>\n\t<td colspan=2 class=medium_font>\n\t<b>Message:</b> <br>";
				$this->body .= "\n\t".$message."\n\t</td>\n</tr>\n";

				//display list of registrants that received this message
				$this->body .= "<tr>\n\t<td colspan=2 class=medium_font>\n\t<b>List of Users that Received this Message:</b> \n\t</td>\n</tr>\n";
				if ($show["all_sent"])
				{
					$this->body .= "<tr>\n\t<td align=center colspan=2 class=medium_font>\n\t<div class=page_note_error>This message was sent to all current registrants at the time.</div> \n\t</td>\n</tr>\n";
				}
				else
				{
					$this->body .= "<tr>\n\t<td colspan=2>\n\t<table cellpadding=1 cellspacing=1 border=0 width=\"100%\">\n\t";
					$sql = "select * from ".$this->past_messages_recipients_table." where message_id = ".$message_id;
					$message_result = $this->db->Execute($sql);
					if ($this->debug_messaging) echo $sql."<bR>\n";
					if (!$message_result)
					{
						if ($this->debug_messaging) echo $sql."<bR>\n";
						$this->site_error($this->db->ErrorMsg());
						return false;
					}
					elseif ($message_result->RecordCount() > 0)
					{
						while ($show_message_recipient = $message_result->FetchRow())
						{
							$sql = "select username,email from ".$this->userdata_table." where id = ".$show_message_recipient["user_id"];
							$user_result = $this->db->Execute($sql);
							if ($this->debug_messaging) echo $sql."<bR>\n";
							if (!$user_result)
							{
								if ($this->debug_messaging) echo $sql."<bR>\n";
								$this->site_error($this->db->ErrorMsg());
								return false;
							}
							elseif ($user_result->RecordCount() == 1)
							{
								$show_user = $user_result->FetchRow();
								$this->body .= "<tr>\n\t\t<td align=center class=small_font>\n\t".$show_user["username"]." - ".$show_user["email"]." \n\t\t</td>\n\t</tr>\n\t";
							}
						}
					}
					else
					{
						$this->body .= "<tr>\n\t\t<td class=medium_font>\n\tno recipients \n\t\t</td>\n\t</tr>\n\t";
					}
					$this->body .= "</table>\n\t</td>\n</tr>\n";
				}
				$this->body .= "</table></fieldset>\n";
				$this->body .= "<table valign=center cellspacing=0 cellpadding=3 width=\"100%\">\n";
				$this->body .= "<tr>\n\t<td colspan=2 class=medium_font>\n\t
					<strong><br>Back to: </strong><a href=index.php?mc=admin_messaging&page=admin_messaging_history><span class=medium_font><strong>Message History</strong></span></a>\n\t</td>\n</tr>\n";
				$this->body .= "</table>\n";
				return true;
			}
			else
			{
				$this->body .= "<tr>\n\t\t<td colspan=2 class=medium_font align=center>\n\t<br><br><strong>There are no messages to display.</strong><br><br> \n\t\t";
			}
				$this->body .= "<tr>\n\t<td colspan=2 class=medium_font>\n\t
					<strong><br>Back to: </strong><a href=index.php?mc=admin_messaging&page=admin_messaging_history><span class=medium_font><strong>Message History</strong></span></a>\n\t</td>\n</tr>\n";
			$this->body .= "</table>\n";
			return true;
		}
		else
		{
			return false;
		}
	} //end of function display_message_history_detail

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function messaging_home()
	{
		$this->body .= "<table cellpadding=3 cellspacing=0 width=100% border=0 align=center>\n";
		//$this->title = "Admin Message Administration configuration";
		$this->description = "Communicate with your registered users through
			this administration tool.  If you want to only send messages to a few users find the users within the \"search users\" section of the
			administration.  At the bottom of the search result there will be a \"send a message\" button.  Click that button and you will be shown the
			form allowing you to send those users a message.";
		$this->body .= "<tr>\n\t\t<td align=right valign=top><a href=index.php?mc=admin_messaging&page=admin_messaging_send><span class=medium_font><b>send message</b></span></a>\n\t\t</td>\n\t\t
			<td class=medium_font>send a message to all users </a>\n\t\t</td>\n\t</tr>\n\t";
		$this->body .= "<tr class=row_color2>\n\t\t<td align=right valign=top><a href=index.php?mc=admin_messaging&page=admin_messaging_form><span class=medium_font><b>form messages</b></span></a>\n\t\t</td>\n\t\t
			<td class=medium_font>edit the form messages you can send to your registered users through this form administration tool </a>\n\t\t</td></tr>\n\t";
		$this->body .= "<tr>\n\t\t<td align=right valign=top><a href=index.php?mc=admin_messaging&page=admin_messaging_history><span class=medium_font><b>message history</b></span></a>\n\t\t</td>\n\t\t
			<td class=medium_font>view the messages you have sent to users in the past </a>\n\t\t</td></tr>\n\t";
		$this->body .= "</table>\n";
		return true;
	} //end of function messaging_home

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_admin_messaging_send()
	{
		//send a message to a list
		$start_from = (isset($_REQUEST['start_from']))? $_REQUEST['start_from']:false;
		if ($start_from > 0 && !isset($_POST['auto_save'])){
			$this->update_admin_messaging_send();
		} else if ((($_POST["d"]) || ($_REQUEST["e"])) && ($_REQUEST["b"]) && (($_REQUEST["z"]) || ($start_from))) {
			//send the text message to the list
			$this->admin_messaging_form($this->db,$_REQUEST["b"],$_REQUEST["c"]);
		} else if ($_REQUEST["c"]) {
			//display of prechosen message to edit
			$this->admin_messaging_form($this->db,$_REQUEST["b"],$_REQUEST["c"]);
		} else {
			//display the text management homepage
			$this->admin_messaging_form($this->db,$_REQUEST["b"]);
		}
		$this->display_page();
	}
	function update_admin_messaging_send()
	{
		$start_from = (isset($_REQUEST['start_from']))? $_REQUEST['start_from']:false;
		return $this->send_admin_message($this->db,$_REQUEST["b"],$_POST["d"],$start_from,$_REQUEST["e"]);
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_admin_messaging_form()
	{
		//administer form messages
		if ($_POST["d"])
		{
			//add new form message
			if (!$this->insert_new_message($this->db,$_POST["d"]))
				return false;
			else
				if (!$this->display_form_messages_list($this->db))
					return false;
		}
		elseif ($_REQUEST["c"])
		{
			//delete the form message
			if (!$this->delete_form_message($this->db,$_REQUEST["c"]))
				return false;
			else
				if (!$this->display_form_messages_list($this->db))
					return false;
		}
		elseif (($_REQUEST["b"]) && ($_REQUEST["e"]))
		{
			//update the form message
			if (!$this->update_message_form($this->db,$_REQUEST["b"],$_REQUEST["e"]))
				return false;
			else
				if (!$this->display_form_messages_list($this->db))
					return false;
		}
		elseif ($_REQUEST["b"])
		{
			//edit the form message
			if (!$this->form_message_edit($this->db,$_REQUEST["b"]))
				return false;
		}
		else
		{
			//display the text management homepage
			if (!$this->display_form_messages_list($this->db))
				return false;
		}
		$this->display_page();
	}
	function update_admin_messaging_form()
	{

	}

	function display_admin_messaging_history()
	{
		if ($_REQUEST["c"]){
			//remove message from history
			if (!$this->delete_from_message_history($this->db,$_REQUEST["c"]))
				return false;
			elseif (!$this->display_message_history($this->db))
				return false;
		}elseif ($_REQUEST["b"]){
			//display this messages data
			if (!$this->display_message_history_detail($this->db,$_REQUEST["b"]))
				return false;
		}else{
			//display all past messages
			if (!$this->display_message_history($this->db))
				return false;
		}
		$this->display_page();
	}

	function update_admin_messaging_history(){}
}

