<?php
//admin_pages_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

class Admin_pages extends Admin_site{

	var $debug_pages = 0;
	var $modules_debug = 0;
	var $modules_not_in_statement = "";

	//module and page id definitions
	var $main_cat_nav_mods = array(114);
	var $filter_dropdown_mods = array(91,101);
	var $display_username_mods = array(53);
	var $cat_tree_display_mods = array(97,98,99);
	var $reg_login_link_mods = array(54,66,67,68,78,79,80,88);
	var $cat_nav_mods = array(94,95,96,100,10199);
	var $featured_pics_mods = array(89,90,102,117,118,119,120,121,122,123,124);
	var $logged_in_out_HTML_mods = array(75,76,77,165,166,167,185,186,187,188,189,190,191,192,193,194,195,196,197,198);
	var $PHP_mods = array(103,104,105,110,111,112,10185,10186,10187,10188,10189,10190,10191,10192,10193,10194,10195,10196,10197,10198);
	var $search_mods = array(106);
	var $zip_browse_mods = array(133);
	var $state_browse_mods = array(134);
	var $extra_pages = array(135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154);
	var $featured_listings_mods = array(155,156);
	var $fixed_cat_nav_mods = array(158,159,160,161,162,163,164);
	var $title_mods = array(171);
	var $featured_and_newest_mods = array(125,126,127,128,129,130,131,132,46,47,48,49,50,60,61);
	var $newest_mods = array(60,61);
	var $hottest = array(172);
	var $users = array(169,170);
	var $cat_browse_options = array(10200);
	var $my_account_links = array(10208);
	var $sectionTitle = "";

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function Admin_pages($db, $product_configuration=0)
	{
		$this->Admin_site($db, $product_configuration);
	} //end of function Admin_pages

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function home ()
	{
		$this->body .= "<table valign=center cellspacing=0 cellpadding=0 width=\"100%\">\n";
		$this->body .= "<tr>\n\t<td><a href=index.php?mc=categories&page=categories_setup>browse and edit categories</a>\n\t</td>\n</tr>\n";
		$this->body .= "</table>\n";
	} //end of function home

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_current_page($db,$page_id=0, $section_index)
	{
		if (!$page_id || !$this->isPageEditable($page_id)) {
			//oops, not a valid page!
			return false;
		}
		
		$sql = "select * from ".$this->pages_table." where page_id = ".$page_id;
		$page_result = $this->db->Execute($sql);
		if ($this->debug_pages) echo $sql."<br>\n";
		if (!$page_result)
		{
			if ($this->debug_pages) echo $sql."<br>\n";
			return false;
		}
		elseif ($page_result->RecordCount() == 1)
			$show = $page_result->FetchRow();
		else
			return false;
		if ($show['module']) {
			//this is a module
			$this->edit_module_specifics_form($db,$page_id);
			return true;
		}
	 	
		$section = $this->get_section($db,$show["section_id"]);
		$page = $this->get_page($db,$page_id);

		// Find number of languages so we can fix the colspan
		$sql = "select count(language_id) as count from ".$this->pages_languages_table." where active = 1";
		$result = $this->db->Execute($sql);
		if ($this->debug_pages) echo $sql."<br>\n";
		$languages = $result->FetchRow();
		$num_languages = $languages["count"];

		//$this->title = "Pages Management > Section: ".$section["name"]." > Page: ".$show["name"];
		$this->title = " ({$show["name"]})";
		
		$this->body .= geoAdmin::m();
		
		if (!$this->admin_demo())
			$this->body .= "<form action=\"\" method=post>\n";
		$this->body .= "<fieldset><legend>Page Details</legend><table valign=center cellspacing=0 cellpadding=0 width=\"100%\">\n";
		
		$this->input_admin_label_and_tag_name($page,1,1);
		if ($page_id>=135 && $page_id<=154)
		{
			$sql = "select * from ".$this->site_configuration_table;
			$configuration_result = $this->db->Execute($sql);
			if (!$configuration_result)
			{
				$this->site_error($this->db->ErrorMsg());
				return false;
			}
			elseif ($configuration_result->RecordCount() == 1)
			{
				$this->configuration_data = $configuration_result->FetchRow();
			}
			else
				return false;				
			$this->body .= "<tr>
								<td class=\"medium_font\" align=\"right\"><br /><strong>Page URL:</strong>&nbsp;&nbsp; </td> 
								<td class=\"medium_font\"><br /><a href=".$this->configuration_data["classifieds_url"]."?a=28&b=".$page_id."><span class=medium_font><font color=000000>".$this->configuration_data["classifieds_url"]."?a=28&b=".$page_id."</font></a><br /><br /></td>
							</tr>";
		}
		
		if ($show['section_id'] != 12) {
			//not extra page, show text links
			$sql = "select * from ".$this->pages_languages_table;
			$language_result = $this->db->Execute($sql);
			if ($this->debug_pages) echo $sql."<br>\n";
			if (!$language_result) {
				if ($this->debug_pages) echo $sql."<br>\n";
				return false;
			} elseif ($language_result->RecordCount() > 0) {
				$this->row_count = 0;
				$this->body .= "
								<tr>
									<td colspan=100% class=page_details_hdr>
										Text Fields Appearing on this Page:
									</td>
								</tr>
								<tr><td colspan=\"100%\"><table width=\"100%\">";
				while ($show_language = $language_result->FetchRow()) {
					//show edit text button for each language
					$this->body .= "
									<tr class=".$this->get_row_color().">
										<td align=right width=50% class=medium_font>
										<strong>".$this->get_language_name($db,$show_language["language_id"])."&nbsp;&nbsp; </strong>
										</td>
										<td colspan=100% width=50% align=left class=medium_font>
											".geoHTML::addButton('edit text', "index.php?page=sections".$section_index."_edit_text&b=".$page_id."&l=".$show_language["language_id"])."
										</td>
									</tr>";
					$this->row_count++;
					if($this->row_count % $language_result->RecordCount() != 0)
						$this->body .= "<tr><td colspan=\"100%\"></td></tr>";
					
				}
				$this->body .= "</table></td></tr>";
			}
		}
		$this->body .= "</table></fieldset>";
		require_once ADMIN_DIR.'design.php';
		$design = Singleton::getInstance('DesignManage');
		
		$templatePagesData = $design->getPagesData();
		
		$needsTags = array (1, 43, 69, 73, 74, 84);
		
		if (isset($templatePagesData[$page_id]) || $page_id == 69) {
			//Filter out what pages we want
			$tpl_vars = $pages = array ();
			$view = geoView::getInstance();
			if (isset($templatePagesData[$page_id])) {
				$pages[$page_id] = $templatePagesData[$page_id];
				$pages[$page_id]['name'] = 'Overall Template Used';
			}
			if ($page_id == 69) {
				//special case, there is no direct attachment for page 69
				//but there is for 69_classified and/or 69_auction
				if (geoPC::is_classifieds()) {
					$pages['69_classified'] = $templatePagesData['69_classified'];
				}
				if (geoPC::is_auctions()) {
					$pages['69_auction'] = $templatePagesData['69_auction'];
				}
			}
			if ($page_id == 1) {
				//special case, get the sub-template attachments
				if (geoPC::is_classifieds()) {
					$pages['1_classified'] = $templatePagesData['1_classified'];
				}
				if (geoPC::is_auctions()) {
					$pages['1_auction'] = $templatePagesData['1_auction'];
				}
			} else if ($page_id == 43) {
				$pages['43_home'] = $templatePagesData['43_home'];
			} else if ($page_id == 84) {
				$pages['84_detail'] = $templatePagesData['84_detail'];
			}
			if ($show['section_id'] == 12) {
				//extra page...  template main body
				$tpl_vars['extraPage'] = 1;
			}
			$sql = "SELECT `language_id`, `language` FROM ".geoTables::pages_languages_table." ORDER BY `language_id` ASC";
			$languages = $this->db->GetAll($sql);
			$tpl_vars['languages'] = array();
			foreach ($languages as $row) {
				$tpl_vars['languages'][$row['language_id']] = $row['language'];
			}
			
			if (in_array($page_id, $needsTags)) $templates = array();
			
			foreach ($pages as $pageId => $data) {
				$pages[$pageId]['t_set'] = geoTemplate::whichTemplateSet('main_page', 'attachments', "templates_to_page/{$pageId}.php");
				$pages[$pageId]['attachments'] = $attachments = $view->getTemplateAttachments($pageId, false);
				if (in_array($page_id, $needsTags)) {
					//remember each of the templates
					foreach ($attachments as $lanId => $attached) {
						if (isset($attached[0]) && !isset($templates[$attached[0]])) {
							$path = geoTemplate::getFilePath('main_page','',$attached[0], $false, $true);
							
							if ($path) {
								//this data will get used later down
								$templates[$attached[0]]['path'] = $path;
								$templates[$attached[0]]['t_set'] = geoTemplate::whichTemplateSet('main_page','',$attached[0]);
							}
						}
					}
				}
			}
			
			$tpl_vars['categoryId'] = 0;
			
			$tpl_vars['pages'] = $pages;
			$tpl = new geoTemplate(geoTemplate::ADMIN);
			$tpl->assign($tpl_vars);
			$this->body .=$tpl->fetch('pages/attachedTemplates.tpl');
		}
		if (in_array($page_id, $needsTags)) {
			//show attachments for templates
			$tpl = new geoTemplate(geoTemplate::ADMIN);
			if ($page_id == 1 || $page_id == 69) {
				//listing details tags
				$tags = $this->getListingDetailsTags();
			} else if ($page_id == 43) {
				$tags = $this->getOldUserManagementTags();
			} else if ($page_id == 73 || $page_id == 74) { 
				$tags = $this->getSignFlyerTags();
			} else if ($page_id == 84) {
				//full size image display page
				$tags = $this->getFullSizeImageTags();
			}
			$tpl->tags = $tags;
			if ($templates) {
				//go through each template and figure out what tags are in it...
				//this data will get used later down
				
				foreach ($templates as $localFile => $templateData) {
					$fileContents = file_get_contents($templateData['path']);
					foreach ($tags as $tagTypes) {
						$tagsSearch = array_keys($tagTypes);
						foreach ($tagsSearch as $tag) {
							if (strpos($fileContents, '{$'.$tag.'}') !== false) {
								$templates[$localFile]['tags'][$tag] = 1;
							}
						}
					}
				}
			}
			$tpl->templates = $templates;
			$this->body .= $tpl->fetch('pages/listingTagsFound.tpl');
		}
		
		$parent_name = $this->get_page($db,$page_id);
		
		//if (strlen($show["special_instructions"]) > 0)
			//$this->body .= "<tr class=row_color_black>\n\t<td colspan=".(2+$num_languages)." class=medium_font_light>".$show["special_instructions"]." </a>\n\t</td>\n</tr>\n";
		if (($page_id == 70) || ($page_id == 71)) {
			//this is the sign or flyer page, show simple fields to use settings
			//TODO: Convert this to use new fields to use
			if ($page_id == 70) {
				$page_large_name = "Flyer";
				$page_name = "flyer";
			} else {
				$page_large_name = "Sign";
				$page_name = "sign";
			}
			$this->body .= "
<fieldset>
<legend>".$page_large_name." Form Fields to Use</legend>
";
			
			$this->body .= "<table width=100% cellpadding=3 cellspacing=1>";

			$this->input_radio_yes_no($show,'module_use_image','Display Image:');
			$this->input_sign_flyer_width_height($db,$page_id,$page);
			//$this->input_module_display_title($page,1);
			$this->input_radio_yes_no($show,'module_display_title','Hide Title:');
			$this->input_radio_yes_no($show,'module_display_price','Display Price of Listing:');
			$this->input_radio_yes_no($show,'module_display_phone1','Display Phone 1 Field:');
			$this->input_radio_yes_no($show,'module_display_phone2','Display Phone 2 Field:');
			$this->input_radio_yes_no($show,'module_display_contact','Display Contact Info:');
			$this->input_module_display_location($page,1);
			$this->input_radio_yes_no($show,'module_display_ad_description','Display Description:');
			$this->input_radio_yes_no($show,'module_display_classified_id','Display Listing ID:');
			if ( geoPC::is_ent() )
				$this->input_module_display_optional_fields($page);
			if (!$this->admin_demo()) $this->body .= "
					<tr class=row_color2 align=center>
						<td colspan=2>
							<input type=submit name='auto_save' value=\"Save\">
						</td>
					</tr>";
			$this->body .= "</table></fieldset>";
		}
		elseif ($page_id==113)
		{
			//browse seller listings settings & fields to use
			//TODO: Convert this to use new fields to use
			$this->body .= "<SCRIPT language=\"JavaScript1.2\">";
			// Set title and text for tooltip
			$this->body .= "Text[1] = [\"number of sellers to display on a page\", \"Set the number of sellers to display on any result page while browsing the sellers.\"]\n
				Text[2] = [\"number of category columns to display on a page\", \"Set the columns the categories will display so the user can browse.\"]\n
				Text[3] = [\"display sub-category sellers\", \"Choosing \\\"\\\"yes\\\"\\\" will display the sellers of a current category\'s sub-categories while browsing the seller listing.\"]\n
				Text[4] = [\"display sellers category count\", \"Choosing \\\"yes\\\" will display the number of unique sellers of the categories listed.\"]\n
				Text[5] = [\"display category description\", \"Choosing \\\"yes\\\" will display the category description.\"]\n
				Text[6] = [\"display category image\", \"Choosing \\\"yes\\\" will display the category image next to the category name.\"]\n";

			//".$this->show_tooltip(6,1)."

			// Set style for tooltip
			//echo "Style[0] = [\"white\",\"\",\"\",\"\",\"\",,\"black\",\"#ffffcc\",\"\",\"\",\"\",,,,2,\"#b22222\",2,24,0.5,0,2,\"gray\",,2,,13]\n";
			$this->body .= "</script>";
			$this->body .= "
<fieldset>
<legend>Browse Seller Settings</legend>
<table valign=center cellspacing=0 cellpadding=3 width=\"100%\">";

			$this->input_option_dropdown($show,'module_number_of_ads_to_display','Number of Sellers to Display on a Page:'.$this->show_tooltip(1,1));
			$this->input_option_dropdown($show,'module_number_of_columns','Number of Category Columns to Display:'.$this->show_tooltip(2,1),6);
			$this->body.='<tr class="'.$this->get_row_color().'">
							<td align="right" width="50%" class="medium_font">
								<strong>Arrange Categories Alphabetically:</strong>
							</td><td class="medium_font">
								<input name="c[alpha_across_columns]" value="1"'.(($page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Across the Column<br />
								<input name="c[alpha_across_columns]" value="0"'.((!$page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Down the Column 
							</td>
						  </tr>'; 
			$this->row_count++;
			$this->input_radio_yes_no($show,'display_no_subcategory_message','Display Subcategory Sellers:'.$this->show_tooltip(3,1));
			$this->input_radio_yes_no($show,'display_category_count','Display Sellers Category Count:'.$this->show_tooltip(4,1));
			$this->input_radio_yes_no($show,'display_category_description','Display Category Description:'.$this->show_tooltip(5,1));
			$this->input_radio_yes_no($show,'display_category_image','Display Category Image:'.$this->show_tooltip(6,1));

			$this->input_radio_yes_no($show,'module_display_username','Display Username Column:');
			$this->input_radio_yes_no($show,'module_display_business_type','Display Business Type Column:');
			$this->input_radio_yes_no($show,'module_display_company_name','Display Company Name Column:');

			$this->input_radio_yes_no($show,'module_display_name','Display Name Column:');
			$this->input_radio_yes_no($show,'module_display_phone1','Display Phone Column:');
			$this->input_radio_yes_no($show,'module_display_phone2','Display Phone 2 Column:');
			$this->input_module_display_location($page,1);
			if ( geoPC::is_ent() )
				$this->input_module_display_optional_fields($show);
			if (!$this->admin_demo()) $this->body .= "
					<tr class=row_color2 align=center>
						<td colspan=\"100%\">
							<input type=submit name=\"auto_save\" value=\"Save\">
						</td>
					</tr>";
			$this->body .= "
				</table>
				</fieldset>";
		}
		
		$this->body .= "</form>";
		

		return true;
	} //end of function display_current_page

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function browse_sections($db,$section=0, $section_index = '')
	{
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();
		$this->body .= $menu_loader->getUserMessages();
		
		$this->body .= "<fieldset id='Page Management'><legend>Pages Management</legend><table cellpadding=2 cellspacing=1 border=0 width=100%>\n";
		//browse the listings in this category that are open

		if ($section)
		{
			$sql = "select * from ".$this->pages_sections_table." where section_id = ".$section;
			if(!geoPC::is_class_auctions())
			{
				if(geoPC::is_auctions())
					$sql .= " and (applies_to = 0 or applies_to = 2)";
				else
					$sql .= " and (applies_to = 0 or applies_to = 1)";
			}
			$section_result = $this->db->Execute($sql);
			//echo $sql." is the query<br>\n";
			if (!$section_result){
				return false;
			}elseif ($section_result->RecordCount() == 1){
				$show_section_data = $section_result->FetchRow();
				$section_name = $show_section_data["name"];
				$section_description = $show_section_data["description"];
				$parent_section = $show_section_data["parent_section"];
			}else{
				//category does not exist
				$this->error_message = "Category Does Not Exist";
				//echo $sql . "<br>";
				//echo "<pre>" . printf(var_dump($section_result->FetchRow()));
				return false;
			}
		}
		else
		{
			$section_name = "Pages Home";
			$section_description = "";
			$parent_section = 0;
		}

		$sql = "select * from ".$this->pages_sections_table." where parent_section = ".$section;
		if(geoPC::is_auctions()&& !geoPC::is_classifieds())
			$sql .= " and (applies_to = 0 or applies_to = 2)";
		elseif(geoPC::is_classifieds() && !geoPC::is_auctions())
			$sql .= " and (applies_to = 0 or applies_to = 1)";
		$sql .= " order by display_order";
		
		$sub_section_result = $this->db->Execute($sql);
		//echo $sql." is the query<br>\n";
		if (!$sub_section_result)
		{
			//echo $sql." is the query<br>\n";
			$this->error_message = $this->messages[5501];
			return false;
		}
		else
		{
			if ($parent_section)
			{
				$parent_section_data = $this->get_section($db,$parent_section);
				$this->body .= "<tr>\n\t<td class=col_hdr_top colspan=4>\n\t
					back to: <a href=index.php?mc=pages_sections&page=sections{$section_index}_show&b=".$parent_section." class=col_hdr_top>".$parent_section_data["name"]."</a>\n\t</td>\n</tr>\n";
			}
			elseif ($section != 0)
			{
				$this->body .= "<tr>\n\t<td class=col_hdr_top colspan=4>\n\t
					back to: <a href=index.php?mc=pages_sections&page=sections_home class=col_hdr_top>Pages Home</a>\n\t</td>\n</tr>\n";
			}
			if ($sub_section_result->RecordCount() > 0)
			{
				//display subsections to this section
				$this->body .= "<tr>\n\t<td colspan=4 class=group_price_hdr align=center>\n\t <b>Subsections of: ".$section_name."</b> </a>\n\t</td>\n</tr>\n";
				$this->body .= "<tr>\n\t<td align=center width=45% class=col_hdr_left><b>Section Name and Description</b>\n\t</td>\n\t";
				$this->body .= "<td align=center width=25% class=col_hdr>\n\t<b>Subsections</b>\n\t</td>\n\t";
				$this->body .= "<td align=center width=25% class=col_hdr>\n\t<b>Pages</b>\n\t</td>\n";
				$this->body .= "<td align=center width=5% class=col_hdr>\n\t&nbsp;\n\t</td>\n</tr>";
				$this->row_count = 0;
				while ($show_sub_sections = $sub_section_result->FetchRow())
				{
					$this->body .= "<tr class=".$this->get_row_color().">\n\t<td valign=top>\n\t<a href=index.php?mc=pages_sections".$section_index."&page=sections".$section_index."_show&b=".$show_sub_sections["section_id"]."><span class=medium_font><font color=000000>".$show_sub_sections["name"]."</font></span></a><br><span class=small_font>";
					//$this->body .= $show_sub_sections["description"];
					$this->body .= "</span></td>\n\t";
					$this->body .= "<td align=center valign=top class=small_font>\n\t";

					$sql = "select * from ".$this->pages_sections_table." where parent_section = ".$show_sub_sections["section_id"];
					if(!geoPC::is_class_auctions())
					{
						if(geoPC::is_auctions())
							$sql .= " and (applies_to = 0 or applies_to = 2)";
						else
							$sql .= " and (applies_to = 0 or applies_to = 1)";
					}
					$sql .= " order by display_order";
					$sub_section_sections_result = $this->db->Execute($sql);
					//echo $sql." is the query<br>\n";
					if (!$sub_section_sections_result)
					{
						//echo $sql." is the query<br>\n";
						$this->error_message = $this->messages[5501];
						return false;
					}
					elseif ($sub_section_sections_result->RecordCount() > 0)
					{
						while ($show_this_sub_section = $sub_section_sections_result->FetchRow())
						{
							$this->body .= $show_this_sub_section["name"]."<br>\n";
						}
					}
					else
					{
						$this->body .= "none";
					}
					$this->body .= " \n\t</td>\n\t";

					$this->body .= "<td align=center valign=top class=small_font>\n\t";
					//$sql = "select * from ".$this->pages_table." where section_id = ".$show_sub_sections["section_id"]." order by display_order";
					$sql = "select * from ".$this->pages_table." where section_id = ".$show_sub_sections["section_id"]." and module = 0";
					$sql .= " and (applies_to = 0";
					if(geoPC::is_auctions())
						$sql .= " or applies_to = 2";
					if(geoPC::is_classifieds())
						$sql .= " or applies_to = 1";
					if (geoPC::is_class_auctions())
						$sql .= " or applies_to = 4";
					$sql .= ") order by page_id";
					$sub_pages_result = $this->db->Execute($sql);
					//echo $sql." is the query<br>\n";
					if (!$sub_pages_result)
					{
						//echo $sql." is the query<br>\n";
						$this->error_message = $this->messages[5501];
						return false;
					}
					elseif ($sub_pages_result->RecordCount() > 0)
					{
						while ($show_sub_pages = $sub_pages_result->FetchRow())
						{
							$this->body .= (($this->isPageEditable($show_sub_pages['page_id']))? $show_sub_pages["name"]."<br>\n": '');
						}
					}
					else
					{
						$this->body .= "none";
					}
					$this->body .= " \n\t</td>\n\t";
					$enter_button = geoHTML::addButton('Enter','index.php?mc=pages_sections'.$section_index.'&page=sections'.$section_index.'_show&b='.$show_sub_sections["section_id"]);
					$this->body .= "<td align=center valign=top>".$enter_button."</td>\n\t";
					$this->body .= "</tr>\n";
					$this->row_count++;
				}
			}

			$sql = "select * from ".$this->pages_table." where section_id = ".$section." and module = 0";
			if(!geoPC::is_ent()) {
				$sql .= ' and page_id not in (62, 63)';
			}
			if(!geoPC::is_class_auctions())
			{
				if(geoPC::is_auctions())
					$sql .= " and (applies_to = 0 or applies_to = 2)";
				else
					$sql .= " and (applies_to = 0 or applies_to = 1)";
			}
			$sql .= " order by page_id, name";
			$sub_pages_result = $this->db->Execute($sql);
			if (!$sub_pages_result)
			{
				return false;
			}
			elseif ($sub_pages_result->RecordCount() > 0)
			{
				//display subpages to this section
				$this->body .= "
					<tr>
						<td colspan=\"100%\">
							<table width=\"100%\">
								<tr>
									<td align=left class=col_hdr_left>
										Page Name
									</td>
									<td align=left width=50% class=col_hdr_left>
										Admin Note
									</td>
									<td width=\"20%\" class=col_hdr_left>&nbsp;</td>
								</tr>";
				$this->row_count = 0;
				while ($show_sub_pages = $sub_pages_result->FetchRow())
				{
					if (!$this->isPageEditable($show_sub_pages["page_id"])){ continue; }
					$edit_button = geoHTML::addButton('Edit','index.php?mc=pages_sections&page=sections'.$section_index.'_page&b='.$show_sub_pages["page_id"]);
					$this->body .= "
								<tr class=".$this->get_row_color().">
									<td valign=top>
										<a href=index.php?mc=pages_sections&page=sections".$section_index."_page&b=".$show_sub_pages["page_id"].">
											<span class=medium_font>
												<font color=000000>".$show_sub_pages['name']."</font>
											</span>
										</a>
									</td>
									<td class=medium_font align=left>
										".$show_sub_pages['admin_label']."<br>
									</td>
									<td align=center valign=top>".$edit_button."
									</td>
								</tr>\n";
					$this->row_count++;
				}
				$this->body .= "
							</table>
						</td>
					</tr>";
			}
		}
		$this->body .= "</table>
</fieldset>
";
		
		return true;
	} //end of function browse_sections
	function isSectionEditable($sectionId){
		//sections no longer used
		if (in_array($sectionId, array (4,5))) {
			//HTML or PHP module, invalid module since that can be done in smarty templates now
			return false;
		}
		
		static $arr = array();
		
		if (count($arr)==0){
			$arr = array(13, 14, 15, 16);
		}
		return (!in_array($sectionId, $arr) || geoPC::is_ent());
	}
	function isPageEditable($pageId){
		static $arr = array();
		
		if (count($arr)==0){
				
			$arr = array(47, 48, 49, 50, 61, 62, 63, 67, 68, 90, 91, 92, 94, 95, 96, 101, 102, 103, 104, 105, 110, 111, 112, 114, 115, 116, 117, 134, 155, 156, 173, 174, 175, 178, 179, 180, 181, 182, 184);
			$arr = array_merge($arr, range(158, 164));
			$arr = array_merge($arr, range(188, 197));
			if (!geoPC::is_premier()){ $arr = array_merge($arr, array(19));}
			if (!geoAddon::getUtil('signs_flyers')) {$arr = array_merge($arr, range(70,74));}
		}
		return (!in_array($pageId, $arr) || geoPC::is_ent());
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	public function getOldUserManagementTags ()
	{
		$tags = array();
		$tags['normal'] = array(
			'section_title' => 'Title for this section.',
			'page_title' => 'The title of the page.',
			'description' => 'Description for this page.',
			'active_ads' => 'Link to the users currently active listings.',
			'expired_ads' => 'Link to the users recently expired listings.',
			'current_info' => 'Link to the users information.',
			'place_ad' => 'Link to List an Item.',
			'favorites' => 'Link to users favorite listings.',
			'communications' => 'Link to user\'s communications.',
			'communications_config' => 'Link to user\'s communication configuration.',
			'signs_and_flyers' => 'Link to signs and flyers page.',
			'renew_extend_subscription' => 'Link to renew/extend subscription.<br /><strong>Will only appear if user is a member of a subscription-based price plan.</strong>',
			'add_money_with_balance' => 'Link to add money to your account. <b>This will also display the account balance beside it.</b>',
			'add_money' => 'Link to add money to your account.',
			'balance_transactions' => 'Link to display all balance transactions that have happened to the clients site balance.',
		);
		if (geoPC::is_auctions()) {
			//auction only tags
			$tags['auctions'] = array (
				'feedback' => 'Link to the Feedback Management system.',
				'current_bids' => 'Link to the user\'s current bids.',
				'blacklist_buyers' => 'Link to the user\'s blacklist.',
				'invited_buyers' => 'Link to the user\'s invited list.',
			);
		}
		return $tags;
	}
	
	public function getSignFlyerTags ()
	{
		$tags = array();
		$tags['normal'] = array (
			'title' => 'Title of the listing.',
			'image' => 'Lead image of auction.',
			'address' => 'Address of the seller.',
			'city' => 'City of the seller.',
			'state' => 'State of the seller.',
			'zip' => 'Zip code of the seller.',
			'price' => 'Price for the listing.',
			'classified_id' => 'Classified ID of the listing.',
			'description' => 'Description of the listing.',
			'phone_1' => 'Phone number 1 for the listing.',
			'phone_2' => 'Phone number 2 for the listing.',
			'contact' => 'Contact information for the listing.',
			'buy_now_price' => 'Buy Now Price for the listing.',
			'starting_bid' => 'Starting Bid for the listing.',
		);
		for ($i = 1; $i < 21; $i++) {
			$tags['normal']['module_display_optional_field_'.$i] = 'Optional Field '.$i.' for the listing.';
		}
		return $tags;
	}
	
	public function getFullSizeImageTags ()
	{
		$tags = array ();
		$tags['full_size_image'] = array(
			"full_size_image" => "The full size image.",
			"ful_size_text" => "The text attached to the full size image."
		);
		return $tags;
	}
	
	public function getListingDetailsTags ()
	{
		$data = array ();
		
		$data['general'] = array(
			'category_tree' => "The current category as well as links to parent categories this listing is in.",
			'title' => "The title of the listing.",
			'classified_id_label' => "Label text for the listing id.",
			'classified_id' => "The listing id data.",
			'viewed_count_label' => "Label text for the count of the number of times the listing has been viewed.",
			'viewed_count' => "The data for the number of times the listing has been viewed.",
			'seller_label' => "Label text for the sellers username field.",
			'seller' => "Sellers username data.",
			'member_since' => "This is the date the seller first registered.",
			'date_started_label' => "Label text for the date the listing was started.",
			'date_started' => "Data for the date the listing was started.",
			'address_label' => "Label text for the address.",
			'address_data' => "Address data for this listing",
			'city_label' => "Label text for the city.",
			'city_data' => "City data for this listing.",
			'state_label' => "Label text for the state.",
			'state_data' => "State data for this listing.",
			'country_label' => "Label text for the country.",
			'country_data' => "Country data for this listing.",
			'zip_label' => "Label text for the zip.",
			'zip_data' => "Zip data for this listing.",
			'payment_options_label' => "This is the label for the payment options the seller will accept for this listing.",
			'payment_options' => "This is the list of payment options the seller will accept for this listing.",
			'price_label' => "Label text for the price.",
			'price' => "Price and currency information for this listing.",
			'public_email_label' => "Label text for the publically exposed email (if shown).",
			'public_email' => "Publically exposed email data for this listing (if shown).",
			'phone_label' => "Label text for the phone (if shown).",
			'phone_data' => "Phone data for this listing (if shown).",
			'phone2_label' => "Label text for the phone 2 (if shown).",
			'phone2_data' => "Phone 2 data for this listing (if shown).",
			'fax_label' => "Label text for the fax label (if shown).",
			'fax_data' => "Fax data for this ad (if shown).",
			'url_link_1' => "This is the link text allowing the user to link to the url within the data field.  The text (html,image) of the link is determined within the listing display page text administration.  The link the client inserts into the field while placing the listing will determine where the link goes to.",
			'url_link_1_href' => "This is URL used for the URL link 1, without the extra HTML or the link text.  It is just the URL itself.",
			'url_link_2' => "This is the link text allowing the user to link to the url within the data field.  The text (html,image) of the link is determined within the listing display page text administration.  The link the client inserts into the field while placing the listing will determine where the link goes to.",
			'url_link_2_href' => "This is URL used for the URL link 2, without the extra HTML or the link text.  It is just the URL itself.",
			'url_link_3' => "This is the link text allowing the user to link to the url within the data field.  The text (html,image) of the link is determined within the listing display page text administration.  The link the client inserts into the field while placing the listing will determine where the link goes to.",
			'url_link_3_href' => "This is URL used for the URL link 3, without the extra HTML or the link text.  It is just the URL itself.",
			'description_label' => "Label text for the description.",
			'description' => "Description data for this listing.",
			'listing_tags_links' => 'A list of all "listing tags", each one links to page showing listings that have that tag.',
			'listing_tags_list' => 'A list of all "listing tags", without links.  This is suitable for use in META tags if desired.',
			'image_block' => "The images for this listing.  This is the block of all images attached to this listing.  You can configure the number of columns the images should be and the size of the images through the admin tool in <b>listing configuration &gt; images configure</b>.",
			'image_block_large' => "The full-sized images block for this listing.  Designed to be used in combination with the {\$image_block_large_link} tag that you would place near the top of the template, then put this tag near the bottom.",
			'image_block_large_link' => "This will display a link that looks similar to \"See all ## Photos\" where ## is automatically replaced with the number of images for the listing.  This is designed to be used right below the lead picture, then use the large photo block lower in the template somewhere.",
			'lead_picture' => "Placing this tag will display the first image attached to the listing by itself within the listing display template.",
			'offsite_videos_title' => 'Text message that can be used for the video section title.',
			'offsite_videos_block' => 'The Youtube videos for this listing.  This is the block of all the offsite (Youtube) videos attached to this listing.',
			'notify_friend_link' => "This is the link allowing the client to send a notification to a friend about the current listing.",
			'message_to_seller_link' => "This is the link allowing the client to send a message to the seller of the listing.",
			'favorites_link' => "This is the link text allowing the user to add the current listing to their favorites list in their user home page.",
			'sellers_other_ads_link' => "This is the link text allowing the user to view the current sellers other listings.",
			'full_images_link' => "This is the link text allowing the user to view all images at their full size on the same page.",
			'print_friendly_link' => "This is the link text allowing the user to view the listing details page in a page that is more	print friendly.",
			'image_slideshow_link' => 'This is the link to view image slideshow for the listing, starting from image 1.',
			'sponsored_by' => "This is where the sponsored by html is placed within sellers listings where that sellers group has \"sponsered by\" html has been placed.  If none of your groups use the sponsored by html fields this tag does not need to be placed within the listing display template.",
			'previous_ad_link' => "Link that will display in the listing allowing the user to see the previous listing within the category.",
			'next_ad_link' => "Link that will display in the listing allowing the user to see the next listing within the category.",
			//Tag is still used, but not "documented" as affiliate pages are phased out.
			//'return_to_list_link' => "Return user to affiliated listing list - <br><b>only used on affiliate side</b>",
			'mapping_link' => "Mapquest link to create a map to the location entered for this listing.",
			'mapping_address' => "Address used in Mapquest link to create a map to the location entered for this listing.",
			'mapping_zip' => "Zip used in Mapquest link to create a map to the location entered for this listing.",
			'mapping_state' => "State used in Mapquest link to create a map to the location entered for this listing.",
			'mapping_city' => "City used in Mapquest link to create a map to the location entered for this listing.",
			'mapping_country' => "Country used in Mapquest link to create a map to the location entered for this listing.",
			'storefront_link' => "Link that will display in the listing linking to the seller\'s storefront if the seller has one. REQUIRES THE STOREFRONT MODULE",
			'additional_text_1' => "Additional text used to display information on your details templates.",
			'additional_text_2' => "Additional text used to display information on your details templates.",
			'additional_text_3' => "Additional text used to display information on your details templates.",
			'additional_text_4' => "Additional text used to display information on your details templates.",
			'additional_text_5' => "Additional text used to display information on your details templates.",
			'additional_text_6' => "Additional text used to display information on your details templates.",
			'additional_text_7' => "Additional text used to display information on your details templates.",
			'additional_text_8' => "Additional text used to display information on your details templates.",
			'additional_text_9' => "Additional text used to display information on your details templates.",
			'additional_text_10' => "Additional text used to display information on your details templates.",
			'additional_text_11' => "Additional text used to display information on your details templates.",
			'additional_text_12' => "Additional text used to display information on your details templates.",
			'additional_text_13' => "Additional text used to display information on your details templates.",
			'additional_text_14' => "Additional text used to display information on your details templates.",
			'additional_text_15' => "Additional text used to display information on your details templates.",
			'additional_text_16' => "Additional text used to display information on your details templates.",
			'additional_text_17' => "Additional text used to display information on your details templates.",
			'additional_text_18' => "Additional text used to display information on your details templates.",
			'additional_text_19' => "Additional text used to display information on your details templates.",
			'additional_text_20' => "Additional text used to display information on your details templates.",
		);
		
		if (geoPC::is_ent()) {
			$data['general'] += array(
				"vote_on_ad_link"	=>	"This is the link text allowing the user to vote and leave comments about the current listing.",
				"show_ad_vote_comments_link"	=>	"This is the link text allowing the user to view the votes and comments attached to the current listing."
			);
			for($i = 1; $i < 21; $i++) {
				$data['general']["optional_field_".$i."_label"] = "";
				$data['general']["optional_field_".$i] = "";
			}
			$data['general'] += array(
				'voteSummary.votes' => "Number of votes in the leading vote category for this listing",
				'voteSummary.total' => "Total number of votes in all vote categories for this listing",
				'voteSummary.percent' => "Number of votes in the leading vote category, expressed as a percentage of the total number of votes",
				'voteSummary.text' => "Text (by default, a \"thumbs up\" or \"thumbs down\" image) used on the show votes page to describe the leading vote category",
			);
		}
		
		if(geoPC::is_auctions()) {
			$data ['auctions'] = array(
				'bid_history_link' => "This is the link text allowing the user to view the bid history of the current auction.  You can turn off and on the visibility of this link while the auction is live within the admin.  The link will be visible when the auction ends",
				'reserve' => "<span class=medium_font>This is the reserve price of the item. </span>",
				'high_bidder_label' => "<span class=medium_font>Label text for the high bidder.</span>",
				'high_bidder' => "<span class=medium_font>This is the high bidder's user id.</span>",
				'winning_dutch_bidders_label' => "<span class=medium_font>Label text for the winning bidder on a dutch auction.</span>",
				'winning_dutch_bidders' => "This is the winning bidder's user id on a dutch auction.",
				'num_bids' => "This is the number of bids on the item.",
				'num_bids_label' => "Label text for the number of bids.",
				'quantity_label' => "Label for the item quantity.",
				'quantity' => "This is the quantity of items.",
				'auction_type_label' => "Label text for the auction type.",
				'auction_type_data' => "This is the auction type.",
				'auction_type_help' => "Help link for the auction types.",
				'buy_now_label' => "Label text for buy now.",
				'buy_now_data' => "This is the buy now data.",
				'buy_now_link' => "This is the link to buy now.",
				'date_ended_label' => "Label text for date ended.",
				'date_ended' => "This is the date ended and appears after the auction has been closed.",
				'stats_remaining_label' => "Label text for time left.",
				'stats_remaining' => "This is the time left in the current auction.",
				'minimum_label' => "Label text for minimum bid.",
				'minimum_bid' => "This is the minimum bid.",
				'starting_label' => "Label text for the starting bid.",
				'starting_bid' => "This is the starting bid.",
				'seller_rating_label' => "Label text for the seller rating.",
				'seller_rating' => "This is the seller rating.",
				'feedback_link' => "This is the link to the feedback page.",
				'seller_number_rates_label' => "Label text for the seller's feedback score.",
				'seller_number_rates' => "This is the seller's feedback score.",
				'seller_rating_scale_explanation' => "Explanations of seller rating scale.",
				'bid_start_date_label' => "This displays label for the date the auction will start if there is a date set for this auction.",
				'bid_start_date' => "This displays the date the auction will start if there is a date set for this auction.",
				'make_bid_link' => "This displays the link to make a bid on the auction.  It is only displayed when the auction is live.",
			);
		}

		//REGISTRATION TAGS
		$data['seller'] = array(
			'seller_id' => "Seller's user ID # (or 0 if placed anonymously)",
			'seller_first_name' => "Seller's first name pulled from sellers registration data.",
			'seller_last_name' => "Seller's last name pulled from sellers registration data.",
			'seller_url' => "Seller's url pulled from sellers registration data.",
			'seller_address' => "Seller's address (line 1 and 2) pulled from sellers registration data.",
			'seller_city' => "Seller's city pulled from sellers registration data.",
			'seller_state' => "Seller's state pulled from sellers registration data.",
			'seller_country' => "Seller's country pulled from sellers registration data.",
			'seller_zip' => "Seller's zip pulled from sellers registration data.",
			'seller_phone' => "Seller's phone pulled from sellers registration data.",
			'seller_phone2' => "Seller's phone2 pulled from sellers registration data.",
			'seller_fax' => "Seller's fax pulled from sellers registration data.",
			'seller_company_name' => "Seller's company name pulled from sellers registration data.",
		);
		
		for($i = 1; $i < 11; $i++) {
			$data ['seller']["seller_optional_".$i] = "Sellers optional ".$i." pulled from sellers registration data.";
		}
		$data ['questions'] = array(
			"extra_question_name"	=>	"The name attached to the data field.",
			"extra_question_value"	=>	"The data value saved in this data field."
		);
		
		$data ['checkboxes'] = array(
			"extra_checkbox_name"	=>	"The name attached to the data field."
		);
		
		return $data;
	}
	
	function edit_module_specifics_form(& $db,$page_id=0)
	{
		if (!$page_id)
			return false;
		$these_pages = array(91,101,134);
		if(in_array($page_id,$these_pages) && !geoPC::is_ent()) {
			return false;
		}
		$page =& $this->get_page($db,$page_id);
		if (!$this->admin_demo()) {
			//javascript to change hidden field
			$this->body.= '<SCRIPT language="JavaScript1.2" type="text/javascript">
	function updateSurroundField(){
		var surround_field = document.getElementById("surround_hidden");
		var pre_field = document.getElementById("surround_pre");
		var post_field = document.getElementById("surround_post");
		var pre_value = " ";
		if (pre_field.value){
			pre_value = pre_field.value;
		}
		var post_value = " ";
		if (post_field.value){
			post_value=post_field.value
		}
		surround_field.value = pre_value+"sub|cat|list"+post_value;
		//alert (surround_field.value);
		return true;
	}
</SCRIPT>';
			$this->body .= "
			<form action=index.php?mc=view_modules&page=modules_page&b=".$page_id." method=post onSubmit=\"return (updateSurroundField());\">\n";
		}

		$this->row_count=0;
		$this->body .= "
			<fieldset id='ModuleDetails'><legend>Module Details</legend><table cellpadding=3 cellspacing=1 border=0>";

		$this->input_admin_label_and_tag_name($page);

		if (in_array($page_id,$this->cat_nav_mods))
		{
			//sub categories section
				//get pre and post.
				$surrounds = explode ('sub|cat|list',$page['module_sub_category_nav_surrounding']);
			if ($page['module_display_sub_category_nav_links']==1){
				$no_check = '';
				$yes_check = ' checked="checked"';
				$sub_class = ' class="enabled_text"';
				$sub_disabled = '';
			} else {
				$no_check = ' checked="checked"';
				$yes_check = '';
				$sub_class = ' class="disabled_text"';
				$sub_disabled=' disabled';
			}
			
			
			//category navigation module
			//$this->title = "Category Navigation Form Module Admin";
			$this->description = "Choose how to display this module from the choices below.
				<br><Br>PLEASE NOTE:  This module will not display on \"non-browsing\" pages.  Non-browsing	page are pages that do not
				display listings within the category display pages.   This includes pages like extra blank, registration, login/logout,
				user management and List an Item pages.";
			
			if ($page_id == 10199)
			{
				$this->body.='<tr class="'.$this->get_row_color().'"><td align="right" width="50%" class="medium_font">display subcategories</td><td class="medium_font"><input name="c[module_display_sub_category_nav_links]" value="1"'.$yes_check.' type="radio" id="sub_cat_on"> yes<br />' .
		   					 '<input name="c[module_display_sub_category_nav_links]" value="0"'.$no_check.' type="radio"> no</td></tr>';	
		   		$this->row_count++;
				$this->input_option_dropdown($page,'number_of_browsing_columns','number of subcategories to display',6);

				//$this->body.='<tr class="'.$this->get_row_color().'"><td align="right" width="50%" class="medium_font">Dropdown Title</td><td class="medium_font"><input type="text" name="c[module_text_type]" value="'.$page['module_text_type'].'"></td></tr>';
				//$this->row_count++;
			} else {
				$this->input_option_dropdown($page,'number_of_browsing_columns','Display this number of Category Columns:',6);
				$this->body.='<tr class="'.$this->get_row_color().'">
								<td align="right" width="50%" class="medium_font">
									<strong>Arrange Categories Alphabetically:</strong>
								</td><td class="medium_font">
									<input name="c[alpha_across_columns]" value="1"'.(($page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Across the Column<br />
									<input name="c[alpha_across_columns]" value="0"'.((!$page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Down the Column 
								</td>
							  </tr>'; 
				$this->row_count++;
				$this->input_radio_yes_no($page,'display_category_count','Display Category Count:');
				if($this->is_class_auctions($page))
				{
					$this->input_browsing_count_format($page);
				}
				
				$this->input_radio_yes_no($page,'display_category_image','Display Category Image:');
				$this->input_radio_yes_no($page,'display_category_description','Display Category Description below the Category Name:');
				$this->input_radio_yes_no($page,'display_no_subcategory_message','Display the "no subcategory" Message:');
				$this->input_radio_yes_no($page,'module_display_ad_description','Display the "back to Parent Category" link in Listing:');
				$message = "Display \"new listing\" icon (within this module):".$this->show_tooltip(8,1);
			
				$this->input_radio_yes_no($page,'module_display_new_ad_icon',$message);
					
				$this->body.='<tr class="'.$this->get_row_color().'"><td align="right" width="50%" class="medium_font"><strong>Display Subcategories (as links):</strong>'.$this->show_tooltip(1,1).'</td><td class="medium_font"><input name="c[module_display_sub_category_nav_links]" value="1"'.$yes_check.' type="radio" id="sub_cat_on"> yes<br />' .
						'<input name="c[module_display_sub_category_nav_links]" value="0"'.$no_check.' type="radio"> no</td></tr>';
				
			}
		}
		elseif (in_array($page_id,$this->main_cat_nav_mods))
		{
			//category navigation module
			//$this->title = "Category Navigation Level Form Module Admin";
			$this->description = "This module is just like a normal category navigation module except that it will only display one of
				the top two levels of categories no matter where it is displayed.  It will display the main categories or the categories
				beneath the main categories (level 2 - and not the main categories).  Choose how to display this module from the choices below.";

			$this->input_module_category_level_to_display($page);
			$this->input_option_dropdown($page,'number_of_browsing_columns','Display this Number of Category Columns:',6);
			$this->body.='<tr class="'.$this->get_row_color().'">
								<td align="right" width="50%" class="medium_font">
									<strong>Arrange Categories Alphabetically:</strong>
								</td><td class="medium_font">
									<input name="c[alpha_across_columns]" value="1"'.(($page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Across the Column<br />
									<input name="c[alpha_across_columns]" value="0"'.((!$page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Down the Column 
								</td>
							  </tr>'; 
			$this->row_count++;
			$this->input_radio_yes_no($page,'display_category_count','Display Category Count:');
			if($this->is_class_auctions($page))
			{
				$this->input_browsing_count_format($page);
			}
			$this->input_radio_yes_no($page,'display_category_image','Display Category Image:');
			$this->input_radio_yes_no($page,'display_category_description','Display Category Description below the Category Name:');
			$this->input_radio_yes_no($page,'display_no_subcategory_message','Display the "no subcategory" Message:');
			$this->input_radio_yes_no($page,'module_display_ad_description','Display the "back to Parent Category" link in Listing:');
			//sub categories section
			//get pre and post.
			$surrounds = explode ('sub|cat|list',$page['module_sub_category_nav_surrounding']);
			if ($page['module_display_sub_category_nav_links']==1){
				$no_check = '';
				$yes_check = ' checked="checked"';
				$sub_class = ' class="enabled_text"';
				$sub_disabled = '';
			} else {
				$no_check = ' checked="checked"';
				$yes_check = '';
				$sub_class = ' class="disabled_text"';
				$sub_disabled=' disabled';
			}
			$this->body.='<tr class="'.$this->get_row_color().'"><td align="right" width="50%" class="medium_font"><strong>Display Subcategories (as links):</strong>'.$this->show_tooltip(1,1).'</td><td class="medium_font"><input name="c[module_display_sub_category_nav_links]" value="1"'.$yes_check.' type="radio" id="sub_cat_on"> yes<br />' .
					'<input name="c[module_display_sub_category_nav_links]" value="0"'.$no_check.' type="radio"> no</td></tr>';
		}
		elseif (in_array($page_id,$this->filter_dropdown_mods))
		{
			//filters dropdown
			//$this->title = "Filter Dropdown Form Module Admin";
			$this->description = "Choose how to display this module from the choice below.";
			$this->input_module_display_filter_in_row($page);
		}
		elseif (in_array($page_id,$this->display_username_mods))
		{
			//display username module
			//$this->title = "Edit the Display User Data Module Form";
			$this->description = "Choose what personal information you wish to display when you use this module.";
			$this->input_module_display_username($db,$page);
		}
		elseif (in_array($page_id,$this->cat_tree_display_mods))
		{
			//$this->title = "Edit the Category Tree Display Module Form";
			$this->description = "Set the text of the links to be displayed and the style they
				are displayed with through the appropriate links below.<br><Br>
				PLEASE NOTE:  This module will not display on \"non-browsing\" pages.  Non-browsing pages are pages that do not display
				listings within the category display pages.  This includes pages like extra blank pages, registration, login/logout, and
				client side management.";
		}
		elseif (in_array($page_id,$this->cat_browse_options))
		{
			$this->description = "";
			$this->category_browsing_options_form();
		}
		elseif (in_array($page_id,$this->reg_login_link_mods))
		{
			//display register/login link module
			//$this->title = "Edit the Display Register/Login/My Account Link Module Form";
			$this->description = "Set the text of the links to be displayed and the style they are displayed with through the appropriate
				links below.";
		}
		elseif (in_array($page_id,$this->featured_pics_mods))
		{
			//display featured pic module
			//$this->title = "Featured Picture Module 1";
			$this->description = "This displays the featured listings by picture only with the number of columns and rows that you specify below.";
			if($this->is_class_auctions())
			{
				$this->input_module_display_type_listing($page);
			}
			$this->input_radio_yes_no($page,'module_display_header_row','Display Header Row:');
			$this->input_option_dropdown($page,'module_number_of_ads_to_display','Number of Featured Pic Rows to Display:',1000);
			$this->input_option_dropdown($page,'module_number_of_columns','Number of Featured Pic Columns to Display:',11);
			$this->input_module_thumb_width_height($page);
			$this->input_module_display_title($page);
			$message = "
				<strong>Max Characters of Title to Display:</strong><br>
				<span class=small_font>
					Choose the maximum number of characters of the title to display.
				</span>";
			$this->input_option_dropdown($page,'length_of_description',$message);
			$this->input_radio_yes_no($page,'module_display_price','Display Price below Title/Thumbnail:');
			if($this->is_class_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_type_text','Display Listing Type below Title(Classified/Auction):');
			}
		}
		elseif (in_array($page_id,$this->search_mods))
		{
			//display search box module
			//$this->title = "Search Box Module";
			//$this->description = "Make the necessary changes to display the search module the way you need.";
			$this->input_radio_yes_no($page,'display_category_description','Display Title/Description Choice Dropdown:');
		}
		elseif (in_array($page_id,$this->zip_browse_mods))
		{
			//display zip browsing module
			//$this->title = "Zip Browsing Module";
			$this->description = "Make the necessary changes to display the zip browsing module the way you need.  This module allows
				the user to set a zip code and radius around that zip code.  Any listings that fall into this zip/radius will be
				displayed while browsing.  Make sure to place this module on all \"browsing\" pages to make sure the user can change
				the zip code and distance data within the filter at any time thus expanding/limiting their results while browsing.";
		}
		elseif (in_array($page_id,$this->state_browse_mods))
		{
			//display state filter module
			//$this->title = "State Browsing Module";
			$this->description = "Make the necessary changes to display the	state browsing module the way you need.  This module allows the
				user to choose a state.  Any listings that fall	into this state will be displayed while browsing.  Make sure to place this
				module on all \"browsing\" pages to make sure the user can change the state data within the	filter at any time thus changing
				their results while browsing.";
		}
		elseif (in_array($page_id,$this->featured_listings_mods))
		{
			//featured listings module that displays a specific category
			//$this->title = "Featured Listings from a Specific Category Module";
			$this->description = "Make the necessary changes to display the
				category specific browsing module the way you need.  This module allows the admin to choose a category that they
				wish to display featured listings from within this module.  The featured listings from the specific category are chosen at
				random. Choose the category you wish to display the featured from below.";
			if($this->is_class_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_listing_column','Display Listing Type');
				$this->input_module_display_type_listing($page);
			}
			$this->input_option_dropdown($page,'module_number_of_ads_to_display','Number of Listings to Display',1000);
			$this->input_category_dropdown($db,$page);
			$this->input_radio_yes_no($page,'module_display_header_row','Display Header Row');
			$this->input_radio_yes_no($page,'module_display_photo_icon','Display Photo/Icon');

			$this->input_photo_or_icon($page);
			$this->input_module_thumb_width_height($page);
			$this->input_radio_yes_no($page,'module_display_ad_description','Display Listing Description');
			$this->input_radio_yes_no($page,'display_all_of_description','Display All of Description');
			$message = "
				<strong>Max Characters of Description to Display</strong><br>
				<span class=small_font>
				Choose the maximum number of characters of the description to display.
				</span>";
			$this->input_option_dropdown($page,'length_of_description',$message);
			$this->input_module_display_ad_description_where($page);
			$this->input_module_display_location($page);
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_number_bids','Display Number of Bids');
			}
			$this->input_radio_yes_no($page,'module_display_price','Display Price Column');
			$this->input_radio_yes_no($page,'module_display_entry_date','Display Entry Date Column');
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_time_left','Display Time Left');
			}
			$attention = geoAddon::getUtil('attention_getters');
			if ($attention)
				$this->input_radio_yes_no($page,'module_display_attention_getter','Display Attention Getters within module');
			if ( geoPC::is_ent() )
				$this->input_module_display_optional_fields($page);
		}
		elseif (in_array($page_id,$this->fixed_cat_nav_mods))
		{
			//$this->title = "Fixed Category Navigation Form Module Admin";
			$this->description = "Choose how to display this module from the choices below.  Also choose the category from which you wish
				to display the subcategories of.  This module will display the immediate subcategories of the category you choose below.";
			$this->input_category_dropdown($db,$page);
			$this->input_option_dropdown($page,'number_of_browsing_columns','Display this Number of Category Columns:',6);
			$this->body.='<tr class="'.$this->get_row_color().'">
								<td align="right" width="50%" class="medium_font">
									<strong>Arrange Categories Alphabetically:</strong>
								</td><td class="medium_font">
									<input name="c[alpha_across_columns]" value="1"'.(($page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Across the Column<br />
									<input name="c[alpha_across_columns]" value="0"'.((!$page['alpha_across_columns'])?'checked="checked"':"").' type="radio" />Down the Column 
								</td>
							  </tr>'; 
			$this->row_count++;
			$this->input_radio_yes_no($page,'display_category_count','Display Category Count:');
			// Choose how to display the category counts
			if($this->is_class_auctions())
			{
				$this->input_browsing_count_format($page);
			}
			$this->input_radio_yes_no($page,'display_category_image','Display Category Image:');
			$this->input_radio_yes_no($page,'display_category_description','Display Category Description below Category Name:');
			$this->input_radio_yes_no($page,'display_no_subcategory_message','Display the "no subcategory" Message:');
			$this->input_radio_yes_no($page,'module_display_ad_description','Display the "back to Parent Category" link in Listing:');
			$message = "Display \"new listing\" Icon".$this->show_tooltip(8,1);
			$this->input_radio_yes_no($page,'module_display_new_ad_icon',$message);
			//sub categories section
			//get pre and post.
			$surrounds = explode ('sub|cat|list',$page['module_sub_category_nav_surrounding']);
			if ($page['module_display_sub_category_nav_links']==1){
				$no_check = '';
				$yes_check = ' checked="checked"';
				$sub_class = ' class="enabled_text"';
				$sub_disabled = '';
			} else {
				$no_check = ' checked="checked"';
				$yes_check = '';
				$sub_class = ' class="disabled_text"';
				$sub_disabled=' disabled';
			}
			$this->body.='<tr class="'.$this->get_row_color().'"><td align="right" width="50%" class="medium_font"><strong>Display Subcategories (as links):</strong>:'.$this->show_tooltip(1,1).'</td><td class="medium_font"><input name="c[module_display_sub_category_nav_links]" value="1"'.$yes_check.' type="radio" id="sub_cat_on"> yes<br />' .
					'<input name="c[module_display_sub_category_nav_links]" value="0"'.$no_check.' type="radio"> no</td></tr>';
			
		}
		elseif(in_array($page_id,$this->title_mods))
		{
			// Title module
			//$this->title = "Fixed Category Navigation Form Module Admin";
			$this->description = "Choose how to display this module from the choices below.  Also choose the category from which you wish
				to display the subcategories of.  This module will display the immediate subcategories of the category you choose below.";
			if (!$this->input_title_module_text($db,$page_id,$page))
				return false;
		}
		elseif (in_array($page_id,$this->hottest))
		{
			//$this->title = "Hottest Listings Module > Edit Properties";
			$this->description = "Edit the specific fields to display with this	module.  Turn off and on the display of a column by
				checking it on or off.";
			if($this->is_class_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_listing_column','Display Listing Type:');
				$this->input_module_display_type_listing($page);
			}
			$this->input_option_dropdown($page,'module_number_of_ads_to_display','Maximum Number of Listings to Display:',1000);
			$this->input_module_display_title($page,1);
			$this->input_radio_yes_no($page,'module_display_header_row','Display Header Row:');
			$this->input_radio_yes_no($page,'module_display_photo_icon','Display Photo/Icon:');
			$this->input_photo_or_icon($page);
			$this->input_module_thumb_width_height($page);
			$this->input_radio_yes_no($page,'module_display_ad_description','Display the Listing Description:');
			$this->input_radio_yes_no($page,'display_all_of_description','Display All of Description:');
			$message = "
				<strong>Max Characters of Description to Display:</strong><br>
				<span class=small_font>
				Choose the maximum number of characters of the description to display.
				</span>";
			$this->input_option_dropdown($page,'length_of_description',$message);
			$this->input_module_display_ad_description_where($page);

			$this->input_module_display_location($page);
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_number_bids','Display Number of Bids:');;
			}
			$this->input_radio_yes_no($page,'module_display_price','Display Price Column:');
			$this->input_radio_yes_no($page,'module_display_entry_date','Display Entry Date Column:');
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_time_left','Display Time Left:');
			}
			$attention = geoAddon::getUtil('attention_getters');
			if ($attention)
				$this->input_radio_yes_no($page,'module_display_attention_getter','Display Attention Getters within Module:');
			if ( geoPC::is_ent() )
				$this->input_module_display_optional_fields($page);
		}
		elseif (in_array($page_id,$this->users))
		{
			//$this->title = "Users Module > Edit Properties";
			$this->description = "Edit the specific fields to display with this	module.";
		}
		elseif(in_array($page_id, $this->my_account_links))
		{
			//nothing to do here (yet?)
		}
		else
		{
			//$this->title = "Edit a Module Form";
			$this->description = "Edit the specific fields to display with this
				module.  Turn off and on the display of a column by checking it on or off.";
			if($this->is_class_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_listing_column','Display Listing Type:');
				$this->input_module_display_type_listing($page);
			}
			if (in_array($page_id,$this->newest_mods)) {
				$yes_selected = ($page['alt_order_by'])? ' checked="checked"': '';
				$no_selected = ($yes_selected)? '': ' checked="checked"';
				$this->body .= "<tr class='{$this->get_row_color()}'><td style='text-align: right; font-weight: bold;' class='medium_font'>Order By</td><td class='medium_font'><label><input type='radio' name='c[alt_order_by]' value='0'$no_selected /> Newest</label>
				<br /><label><input type='radio' name='c[alt_order_by]' value='1'$yes_selected /> Ending Soonest</label></td></tr>";
				$this->row_count ++;
			}			
			$this->input_option_dropdown($page,'module_number_of_ads_to_display','Display this Number of Listings:',1000);
			$this->input_module_display_title($page,1);
			$this->input_radio_yes_no($page,'module_display_header_row','Display Header Row:');
			$this->input_radio_yes_no($page,'module_display_photo_icon','Display Photo/Icon:');
			// Photo or Icon for featured listings modules and newest modules
			if(in_array($page_id,$this->featured_and_newest_mods))
			{
				$this->input_photo_or_icon($page);
			}
			$this->input_module_thumb_width_height($page);
			$this->input_radio_yes_no($page,'module_display_ad_description','Display Listing Description:');
			$this->input_radio_yes_no($page,'display_all_of_description','Display All of Description:');
			$message = "
				<strong>Max characters of Description to Display:</strong><br>
				<span class=small_font>
				Choose the maximum number of characters of the description to display.
				</span>";
			$this->input_option_dropdown($page,'length_of_description',$message);
			$this->input_module_display_ad_description_where($page);
			$this->input_module_display_location($page);
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_number_bids','Display Number of Bids:');
			}
			$this->input_radio_yes_no($page,'module_display_price','Display Price Column:');
			$this->input_radio_yes_no($page,'module_display_entry_date','Display Entry Date Column:');
			if(geoPC::is_auctions())
			{
				$this->input_radio_yes_no($page,'module_display_time_left','Display Time Left:');
			}
			$attention = geoAddon::getUtil('attention_getters');
			if ($attention)
				$this->input_radio_yes_no($page,'module_display_attention_getter','Display Attention Getters:');
			if ( geoPC::is_ent() )
				$this->input_module_display_optional_fields($page);
		}
		if (!$this->admin_demo())
		{
			$this->body .= "
				<tr class=".$this->get_row_color().">
					<td colspan=2 align=center class=medium_font>
						<input type=submit name='auto_save' value=\"Save\">
					</td>
				</tr>";
		}

		$this->body .= "<tr>\n\t<td colspan=3 class=col_hdr>Edit Text appearing within this Module
			</td>\n</tr>\n";
		$sql = "select * from ".$this->pages_languages_table;
		$language_result = $this->db->Execute($sql);
		 if (!$language_result)
		 {
			//$this->body .= $sql." is the query<br>\n";
			$this->error_message = $this->messages[3501];
			return false;
		 }
		 elseif ($language_result->RecordCount() > 0)
		 {
			$this->row_count = 0;
			while ($show_language = $language_result->FetchRow())
			{
				$edit_text_button = geoHTML::addButton('Edit Text','index.php?mc=view_modules&page=modules_edit_text&b='.$page_id."&l=".$show_language["language_id"]);
				$this->body .= "
				<tr class=".$this->get_row_color().">
					<td align=right width=\"50%\">
						<span class=medium_font>
							".$this->get_language_name($db,$show_language["language_id"])."
						</span>
					</td>
					<td colspan=2 width=40%>".$edit_text_button."</td>
				</tr>";$this->row_count++;
			}
		 }
		$this->body .= "</table></fieldset>";
		
		$tpl = new geoTemplate(geoTemplate::ADMIN);
		
		$file = geoFile::getInstance(geoFile::TEMPLATES);
		require_once ADMIN_DIR . 'design.php';
		$design = new DesignManage;
		$design->init(true);
		
		$tList = array_diff($design->getAllTemplateSets(true), geoTemplate::getInvalidSetNames());
		$attachments = array();
		foreach ($tList as $tset) {
			$attachmentsDir = "$tset/main_page/attachments/modules_to_template/";
			$attachmentFiles = $file->scandir($attachmentsDir);
			foreach ($attachmentFiles as $fileName) {
				$tplName = preg_replace('/\.php$/','',$fileName);
				$moduleAttachments = $design->getModulesToTemplate($attachmentsDir.$fileName);
				if (isset($moduleAttachments['modules'][$page_id])) {
					$attachments[$tset][$tplName] = file_exists ($file->absolutize("$tset/main_page/$tplName"));
				}
			}
		}
		$tpl->attachments = $attachments;
		
		$this->body .= $tpl->fetch('pages/moduleAttachments.tpl');
		
		$this->body .= "<table valign=center cellspacing=0 cellpadding=3 width=\"100%\">";
		
		
		$this->body .= "
				<tr>
					<td colspan=2>
<div style='padding: 5px;'><a href=index.php?mc=pages_sections&page=sections{$section_index}_home class='back_to'>
<img src='admin_images/design/icon_back.gif' alt='' class='back_to'>Back to Pages Home</a></div>
					</td>
				</tr>
				<tr>
					<td colspan=2>
<div style='padding: 5px;'><a href=index.php?mc=view_modules&page=modules_home class='back_to'>
<img src='admin_images/design/icon_back.gif' alt='' class='back_to'>Back to Modules Home</a></div>
					</td>
				</tr>
			</table>
			</form>";
				/*<tr>
					<td colspan=2>
						<a href=index.php?mc=view_modules&page=modules_home>
							<span class=medium_font>
								<b>View Complete Modules List</b>
							</span>
						</a>
					</td>
				</tr>*/
			
		return true;
	} //end of function edit_module_specifics_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	/**
	 * Updates stuff about a module.
	 *
	 * @param unused $db
	 * @param int $page_id
	 * @param array $module_info Un-modified user inputed data of settings for the module.
	 * @param int $section_index
	 * @return boolean
	 */
	function update_module_specifics($db,$page_id=0,$module_info=0, $section_index)
	{
		$page_id = intval($page_id);
		if(!$this->isPageEditable($page_id) || !$page_id) {
			return false;
		}
		//clear cache
		geoCache::clearCache('modules');
		//clear page cache
		geoCache::clearCache('pages');
		if (in_array($page_id,$this->extra_pages))
		{
			//this is an extra page, not a module
			$sql = "UPDATE ".geoTables::pages_table." SET `admin_label` = ? WHERE `page_id` = $page_id";
			
			$result = $this->db->Execute($sql, array($module_info["admin_label"]));
			if (!$result) {
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}
			$sql = "SELECT * FROM ".geoTables::pages_languages_table;
			$languages = $this->db->GetAll($sql);
			if ($languages === false) {
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}
			foreach ($languages as $lang) {
				$reg = new geoRegistry('extra_pages', "$page_id:{$lang['language_id']}");
				//do not encode when inserting to db, registry does it for us
				$extra_page_txt = trim($module_info['extra_page_text'.$lang['language_id']]);
				if ($reg->get('body_code') !== $extra_page_txt){
					//keep from re-saving if the text has not changed.
					$reg->set( 'body_code', $extra_page_txt);
					$reg->save();
				}
			}
			return true; 
		} else if (in_array($page_id,$this->title_mods)) {
			//this is a title module
			$sql = "UPDATE ".geoTables::ad_configuration_table." SET `title_module_text` = ?";
			$result = $this->db->Execute($sql, array(geoString::toDB($module_info["title_module_text"])));
			if (!$result) {
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}

			$sql = "UPDATE ".geoTables::pages_text_languages_table." SET text = ? WHERE `text_id` = 2462";
			if ($this->debug_pages) echo $sql."<br>\n";
			$result = $this->db->Execute($sql, array(geoString::toDB($module_info["title_module_home_text"])));
			if (!$result) {
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}
			//this is a page, not a module
			$sql = "UPDATE ".geoTables::pages_table." SET `admin_label` = ? WHERE `page_id` = $page_id";
			
			$result = $this->db->Execute($sql, array($module_info["admin_label"]));
			if (!$result) {
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}

			return true;
			
		} else if (in_array($page_id,$this->cat_browse_options)) {
			return $this->update_category_browse_options($page_id, $module_info);
			
		} else if ($page_id && $module_info) {
			//NOTE: logged in/out html specific stuff removed already.
			
			
			//lets dynamically generate the sql query.
			$params = array();
			$set_vars = array();
			//list of fields not in the geodesic_pages database table.
			$skip_list = array ('flyer_maximum_image_width','flyer_maximum_image_height','sign_maximum_image_width','sign_maximum_image_height');
			//for fields where HTML is allowed, don't trim()
			$html_allowed = array('module_sub_category_nav_surrounding', 'module_sub_category_nav_prefix', 'module_sub_category_nav_separator');
			foreach ($module_info as $key => $value){
				if (!in_array($key, $skip_list)){
					
					if(!in_array($key, $html_allowed)) {
						$value = trim($value);
					}
					$params[]=$value;
					$set_vars[]="`$key` = ?";
				}
			}
			//use the format 'update table_name set var_name1 = ?, var_name2 = ? where var_namex = ?' for the query, and then
			//pass execute an array of values.  This way, we let sdo do input checking for us, and it might even
			//speed things up a bit.  See sdo documentation for more info on using ? in queries.
			$sql = 'UPDATE '.geoTables::pages_table.' SET '.implode(',',$set_vars).' WHERE `page_id` = ?';
			$params[]=$page_id;
			
			if ($this->debug_pages){
				echo $sql."<br>\n params: <pre>";
				var_dump($params);
				echo '</pre>';
			} 
			//$params is the array we generated earlier that has all the values for the ?'s in the sql query.
			$result = $this->db->Execute($sql,$params);
			if (!$result)
			{
				trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
				return false;
			}
			
			if ($page_id == 70) {
				$sql = "update ".$this->ad_configuration_table." set
					flyer_maximum_image_width = ".intval($module_info["flyer_maximum_image_width"]).",
					flyer_maximum_image_height = ".intval($module_info["flyer_maximum_image_height"]);
				$result = $this->db->Execute($sql);
				if ($this->debug_pages) echo $sql."<br>\n";
				if (!$result)
				{
					trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
					return false;
				}
			} elseif ($page_id == 71) {
				$sql = "update ".$this->ad_configuration_table." set
					sign_maximum_image_width = ".intval($module_info["sign_maximum_image_width"]).",
					sign_maximum_image_height = ".intval($module_info["sign_maximum_image_height"]);
				$result = $this->db->Execute($sql);
				if (!$result) {
					trigger_error('ERROR SQL: Sql: '.$sql.' error: '.$this->db->ErrorMsg());
					return false;
				}

			}
			
			return true;
		} else {
			$this->error_message = $this->internal_error_message;
			//echo "whatever";
			return false;
		}
	} //end of function update_module_specifics

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function category_browsing_options_form()
	//admin options for category_browsing_options module
	{
		$this->body .= "<tr><td class=\"col_hdr\" colspan=\"2\" style=\"width: 100%; font-weight: bold; text-align: center;\">Options selected below will be applied to the Category Browsing Options Module</td></tr>";
		$show_options = array (
			'cat_browse_opts_as_ddl' => $this->db->get_site_setting('cat_browse_opts_as_ddl'),
			'cat_browse_all_listings' => $this->db->get_site_setting('cat_browse_all_listings'),
			'cat_browse_end_today' => $this->db->get_site_setting('cat_browse_end_today'),
			'cat_browse_has_pics' => $this->db->get_site_setting('cat_browse_has_pics'),
			'cat_browse_has_pics' => $this->db->get_site_setting('cat_browse_has_pics'),
			'cat_browse_class_only' => $this->db->get_site_setting('cat_browse_class_only'),
			'cat_browse_auc_only' => $this->db->get_site_setting('cat_browse_auc_only'),
			'cat_browse_buy_now' => $this->db->get_site_setting('cat_browse_buy_now'),
			'cat_browse_buy_now_only' => $this->db->get_site_setting('cat_browse_buy_now_only'),
			'cat_browse_auc_bids' => $this->db->get_site_setting('cat_browse_auc_bids'),
			'cat_browse_auc_no_bids' => $this->db->get_site_setting('cat_browse_auc_no_bids')
			
		);
		$ddlTooltip = geoHTML::showTooltip('Show as Dropdown', 'Choose yes to display the module\'s options in a dropdown list, or no to show them as a text-based, delimeter-separated list.');
		$this->input_radio_yes_no($show_options,"cat_browse_opts_as_ddl","Show as Dropdown $ddlTooltip");
		$this->input_radio_yes_no($show_options,"cat_browse_all_listings","All listings");
		$this->input_radio_yes_no($show_options,"cat_browse_end_today","Listings Ending within 24 hours");
		$this->input_radio_yes_no($show_options,"cat_browse_has_pics","Listings with Photos");
		
		if(geoPC::is_class_auctions())
		{
			$this->input_radio_yes_no($show_options,"cat_browse_class_only","Classifieds only");
			$this->input_radio_yes_no($show_options,"cat_browse_auc_only","Auctions only");
		}
		if(geoPC::is_auctions())
		{
			$this->input_radio_yes_no($show_options,"cat_browse_buy_now","Auctions using Buy Now");
			$this->input_radio_yes_no($show_options,"cat_browse_buy_now_only","Auctions using Buy Now Only");
			$this->input_radio_yes_no($show_options,"cat_browse_auc_bids","Auctions with Bids");
			$this->input_radio_yes_no($show_options,"cat_browse_auc_no_bids","Auctions without Bids");
		}
		
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function update_category_browse_options($page_id, $data)
	{
		//set admin note
		$sql = "update ".$this->pages_table." set admin_label='".$data['admin_label']."' where page_id=".$page_id;
		$result = $this->db->Execute($sql);
		//clear cache
		geoCache::clearCache('modules');
		//clear page cache
		geoCache::clearCache('pages');
		
		if(!$result)
		{
			if($this->debug_pages) echo $this->db->ErrorMsg() . "<br />";
			return false;
		}
		$this->db->set_site_setting('cat_browse_opts_as_ddl',$data['cat_browse_opts_as_ddl']);
		$this->db->set_site_setting('cat_browse_all_listings',$data['cat_browse_all_listings']);
		$this->db->set_site_setting('cat_browse_end_today',$data['cat_browse_end_today']);
		$this->db->set_site_setting('cat_browse_has_pics',$data['cat_browse_has_pics']);
		
		if(geoPC::is_class_auctions())
		{
			$this->db->set_site_setting('cat_browse_class_only',$data['cat_browse_class_only']);
			$this->db->set_site_setting('cat_browse_auc_only',$data['cat_browse_auc_only']);
		}
		
		if(geoPC::is_auctions())
		{
			$this->db->set_site_setting('cat_browse_buy_now',$data['cat_browse_buy_now']);
			$this->db->set_site_setting('cat_browse_buy_now_only',$data['cat_browse_buy_now_only']);
			$this->db->set_site_setting('cat_browse_auc_bids',$data['cat_browse_auc_bids']);
			$this->db->set_site_setting('cat_browse_auc_no_bids',$data['cat_browse_auc_no_bids']);
		}
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function show_modules()
	{
		//Wow, this function is old...  wonder how long it's been since it has
		//been used.  Might as well keep it around, it might come in handy one day
		$this->function_name = "show_modules";

		$sql = "select * from ".$this->pages_table." where module = 1 order by name";
		$module_result = $this->db->Execute($sql);
		//echo $sql." is the query<br>\n";
		if (!$module_result)
		{
			//echo $sql." is the query<br>\n";
			$this->error_message = $this->messages[5501];
			return false;
		}
		elseif ($module_result->RecordCount() > 0)
		{
			//display subsections to this section
			$this->body .= "<table cellpadding=3 cellspacing=1 border=0>\n";
			$this->body .= "<tr bgcolor=000066>\n\t<td colspan=4 class=medium_font_light align=center>\n\t <b>Complete Page Modules List</b> </a>\n\t</td>\n</tr>\n";
			$this->body .= "<tr class=row_color_black>\n\t<td align=center colspan=2 class=medium_font_light><b>Module Name</b>\n\t</td>\n\t";
			$this->body .= "<td align=center colspan=2 class=medium_font_light>\n\t\n\t</td>\n</tr>";
			$this->row_count = 0;
			while ($show_module = $module_result->FetchRow())
			{
				if (!$this->isPageEditable($show_module['page_id']) || !$this->isSectionEditable($show_module['module_type'])) continue;
				
				$tag = '{module tag=\''.$show_module["module_replace_tag"].'\'}';
				$this->body .= "<tr class=".$this->get_row_color().">\n\t<td valign=top colspan=2>\n\t<a href='index.php?mc=view_modules&page=modules_page&amp;b=".$show_module["page_id"]."'><span class=medium_font>".$show_module["name"]."</span></a><br><span class=small_font>".$tag."<br>".$show_module["description"]."</span></td>\n\t";
				$this->body .= "<td align=center valign=top colspan=2>".geoHTML::addButton('edit', "index.php?mc=view_modules&page=modules_page&b=".$show_module["page_id"])."</td>\n\t";
				$this->body .= "</tr>\n";
				$this->row_count++;
			}
			$this->body .= "</table>";
		}
		return true;
	} // end of functio show_modules
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function browse_module_sections($db,$section=0)
	{
		if(!$this->isSectionEditable($section)) {
			return false;
		}
		
		//$this->title = "Page Modules";
		$this->description = "Page Modules allow you to display each module's feature / functionality on the pages that you specify. Each module has its own distinct \"tag\" which you insert within your Templates. Wherever you insert the
		tag into the html of your template is where that Module's functionality will be displayed. So, to use a module, determine that module's \"tag name\", insert that tag into your template, refresh that template through the Pages
		Management section (to ensure the system \"attaches\" the module to the page) and then edit the module's properties to display as you wish. Each module has it's own distinct display properties.";
		if ($section)
			$this->body .= "
				<table cellpadding=4 cellspacing=0 border=0 width=100%>
					<tr>
						<td colspan=\"100%\" class=pages_manage_nav>back to 
							<a href=index.php?mc=view_modules&page=modules_home class=pages_manage_nav>Modules Home</a>
						</td>
					</tr>
				</table>";
		$this->body .= "<fieldset id='AvailableModules'><legend>Available Modules</legend><table cellpadding=2 cellspacing=1 border=0 width=100%>\n";
		if (!$section)
		{
			$this->function_name = "browse_module_sections";

			$sql = "select * from ".$this->pages_modules_sections_table." where parent_section = 0";
			//echo $sql. "is the query<br>";
			$section_result = $this->db->Execute($sql);
			//if($this->configuration_data["debug_admin"])
			//{
			//	$this->debug_display($db, $this->filename, $this->function_name, "pages_sections_modules_table", "get page sections data");
			//}
			if (!$section_result)
			{
				//echo $sql." is the query<br>\n";
				//$this->error_message = $this->messages[5501];
				return false;
			}
			elseif ($section_result->RecordCount() > 0)
			{
				$this->row_count = 0;
				while ($show_sections = $section_result->FetchRow())
				{
					if (!$this->isSectionEditable($show_sections['section_id'])) continue;
					$this->body .= "<tr class=".$this->get_row_color().">\n\t<td valign=top>\n\t<a href=index.php?mc=view_modules&page=modules_show&b=".$show_sections["section_id"]."><span class=medium_font><font color=000000>".$show_sections["name"]."</font></span></a><span class=small_font>";
					//$this->body .= $show_sections["description"];
					$this->body .= "</span></td>\n\t";
					$enter_button = geoHTML::addButton('Enter','index.php?mc=view_modules&page=modules_show&b='.$show_sections["section_id"]);
					$this->body .= "<td align=center valign=top width=100>".$enter_button."</td>\n\t";
					$this->body .= "</tr>\n";
					$this->row_count++;
				}
				$this->body .= "<tr class=".$this->get_row_color().">\n\t<td colspan='2' style='text-align: center;'>
					<a href='index.php?page=modules_page' class='mini_button'>View All Modules</a>
				</td></tr>";
			}
			else
			{
				//category does not exist
				$this->error_message = $this->messages["5500"];
				return false;
			}
		}
		else
		{
			//does this section have subsections
			$sql = "select * from ".$this->pages_modules_sections_table." where parent_section = ".$section;
			
			//echo $sql. "is the query<br>";
			$parent_section_result = $this->db->Execute($sql);
			if (!$parent_section_result)
			{
				trigger_error('ERROR SQL: '.$this->db->ErrorMsg());
				$this->error_message = $this->messages[5501];
			//	return false;
			}

			//if it does display these sections in a list like above

			elseif ($parent_section_result->RecordCount() > 0)
			{
				$this->row_count = 0;
				while ($show_sections = $parent_section_result->FetchRow())
				{	
					if (!$this->isSectionEditable($show_sections['section_id'])) continue;
						$enter_button = geoHTML::addButton('Enter','index.php?mc=view_modules&page=modules_show&b='.$show_sections["section_id"]);
						$this->body .= "
							<tr class=".$this->get_row_color().">
								<td valign=top>
									<a href=index.php?mc=view_modules&page=modules_show&b=".$show_sections["section_id"].">
										<span class=medium_font><font color=000000>".$show_sections["name"]."</font></span></a>
								</td>
								<td align=center valign=top>".$enter_button."</td>
							</tr>";
						$this->row_count++;
				}
			}
			else
			{
				// it it does not have subsections then call the module list function
				//and pass it the subsection to display modules specific to that section

				$sql = "SELECT name,admin_label,page_id,module_replace_tag FROM ".$this->pages_table."
					WHERE module = 1 AND module_type=".$section;
				if(9 == $section && !geoPC::is_ent()) {
					$sql .= ' and page_id = 100';
				}
				
				if (!$this->isSectionEditable($section)) return false;
			
				$parent_section_result = $this->db->Execute($sql);
				if (!$parent_section_result)
					return false;
				$unsorted_modules = array();
				while ($show_module = $parent_section_result->FetchRow()){
					if ($this->isPageEditable($show_module['page_id'])) array_push($unsorted_modules,$show_module);
				}
				
				//leave the other types of modules alone
				$modules = $unsorted_modules;
				$this->body .= "
						<tr>
							<td colspan=\"100%\">
								<tr>
									<td class=col_hdr_left>
										Module Name
									</td>
									<td width=50% class=col_hdr_left>
										Admin Note
									</td>
									<td width=\"20%\" class=col_hdr_left>&nbsp;</td>
								</tr>
							</td>
						</tr>";
				$this->row_count = 0;
				foreach ($modules as $module)
				{
					$tag = "{module tag='{$module['module_replace_tag']}'}";
					$edit_button = geoHTML::addButton('Edit','index.php?mc=view_modules&page=modules_page&b='.$module['page_id']);
					$this->body .= "
						<tr class=".$this->get_row_color().">
							<td valign=top>
								<a href=index.php?mc=view_modules&page=modules_page&b=".$module['page_id'].">
									<span class=medium_font>
										<font color=000000>".$module['name']."</font>
									</span>
								</a><br>
								<span class=small_font>$tag</span>
							</td>
							<td class=medium_font align=left>
								".$module['admin_label']."<br>
							</td>
							<td align=center valign=top>".$edit_button."</td>
						</tr>\n";
					$this->row_count++;
				}
			}
		}
		$this->body .= "</table></fieldset>\n";
		return true;
	} //end of function browse_module_sections

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_admin_label_and_tag_name($page,$is_page=0,$show_submit=0)
	{
		$type = ($is_page) ? 'page' : 'module';
			
		$this->body .= "
			<tr class=".$this->get_row_color().">

				<td align=right width=50% class=medium_font>"; 
		//attach the tooltips.
		$this->body .= "<script language='JavaScript1.2' src='js/admin_pages_class_tooltips.js'></script>";
		
		$this->body .= "
					<b>Admin Note:</b>".$this->show_tooltip(6,1)."
				</td>
				<td class=medium_font width=\"50%\">
					<nobr>
					<input type=text size=50 name=c[admin_label] value=\"".$page["admin_label"]."\">";
		if ($show_submit)
			$this->body .= "&nbsp;<input type=submit name=auto_save value=\"Save\">";
		$this->body .= "</nobr>
				</td>
			</tr>";
			$this->row_count++;
		if (!$is_page)
		{
			//this is a module, not a page so lets show its tag
			$show_tag = "{module tag='{$page['module_replace_tag']}'}";
			$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right width=50% class=medium_font>
					<strong>Template Tag:</strong> ".$this->show_tooltip(7,1)."</td>
				<td class=medium_font>
					$show_tag
				</td>
			</tr>";
			$this->row_count++;
		}
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_browsing_count_format(& $page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right valign=top width=50% class=medium_font>
					<strong>Choose how to Display Category Counts:</strong>
				</td>
				<td width=50% valign=top class=medium_font>
					<select name=c[browsing_count_format]>
						<option ".(($page["browsing_count_format"] == 1) ? "selected" : "")." value=1>
							Display Auction Count Only
						</option>
						<option ".(($page["browsing_count_format"] == 2) ? "selected" : "")." value=2>
							Display Classified Count Only
						</option>
						<option ".(($page["browsing_count_format"] == 3) ? "selected" : "")." value=3>
							Display Auction then Classified Count
						</option>
						<option ".(($page["browsing_count_format"] == 4) ? "selected" : "")." value=4>
							Display Classified then Auction Count
						</option>
						<option ".(($page["browsing_count_format"] == 5) ? "selected" : "")." value=5>
							Combined Count
						</option>
					</select>
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>browsing_count_format</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_category_level_to_display($page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right class=medium_font>
					<strong>Display Category Count:</strong>
				</td>
				<td>
					<span class=medium_font>
						<input type=radio name='c[module_category_level_to_display]' value=0 ".
						(($page["module_category_level_to_display"] == 0) ? "checked" : "").">
						main categories<br>
						<input type=radio name='c[module_category_level_to_display]' value=1 ".
						(($page["module_category_level_to_display"] == 1) ? "checked" : "").">
						second level (all subcategories of the main categories only -- not main categories)
					</span>
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_category_level_to_display</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_filter_in_row($page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right class=medium_font>
					<strong>Display of Dropdowns:</strong>
				</td>
				<td>
					<span class=medium_font>
						<input type=radio name='c[module_display_filter_in_row]' value=1 ".
						(($page["module_display_filter_in_row"] == 1) ? "checked" : "").">
						display dropdowns in a single row<br>
						<input type=radio name='c[module_display_filter_in_row]' value=0 ".
						(($page["module_display_filter_in_row"] == 0) ? "checked" : "").">
						display dropdowns in a single column
					</span>
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_display_filter_in_row</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_username($db,$page)
	{
		$sql = "select * from ".$this->choices_table." where type_of_choice = 12";
		$choices_result = $this->db->Execute($sql);
		if (!$choices_result)
			return false;
		elseif ($choices_result->RecordCount() > 0)
		{
			$options = "";
			while ($show = $choices_result->FetchRow())
			{
				$options .= "
					<option value=".$show["value"].(($page["module_display_username"] == $show["value"]) ? " selected" : "").">
						".$show["display_value"]."
					</option>";
			}
		}
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right width=50% class=medium_font>
					<strong>Display Options:</strong>
				</td>
				<td class=medium_font>
					<select name=c[module_display_username]>
						$options
					</select>
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_display_username</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_type_listing($page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right width=50% class=medium_font>
					<strong>Display these Listing Types:</strong>
				</td>
				<td class=medium_font>
					<input type=radio name='c[module_display_type_listing]' value=1 ".
					(($page["module_display_type_listing"] == 1) ? "checked" : "").">
					classifieds only<Br>
					<input type=radio name='c[module_display_type_listing]' value=2 ".
					(($page["module_display_type_listing"] == 2) ? "checked" : "").">
					auctions only<Br>";
			//$this->body .= $this->product_configuration->path_translated()." is path translated<Br>\n";
			//$this->body .= $page["module_display_type_listing"]." is module_display_type_listing<Br>\n";
			if (file_exists($this->product_configuration->path_translated()."/classes/order_items/reverse_auctions.php"))	{
			$this->body .= "			<input type=radio name='c[module_display_type_listing]' value=2 ".
					(($page["module_display_type_listing"] == 4) ? "checked" : "").">
					reverse auctions only<Br>";
		}
		
		$this->body .= "				
					<input type=radio name='c[module_display_type_listing]' value=0 ".
					(($page["module_display_type_listing"] == 0) ? "checked" : "").">
					classifieds & auctions
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_display_type_listing</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_thumb_width_height($page)
	{
		//width of thumbnail
		$message = "
			<strong>Max Width of Thumbnail:</strong><br>
			<span class=small_font>
				If set to 0 the thumb width size will default to the thumb width set in site setup > browsing
			</span>";
		$this->input_option_dropdown($page,'module_thumb_width',$message,1000, 0);

		//height of thumbnail
		$message = "
			<strong>Max Height of Thumbnail:<br>
			<span class=small_font>
				If set to 0 the thumb height size will default to the thumb height set in site setup > browsing
			</span>";
		$this->input_option_dropdown($page,'module_thumb_height',$message,1000, 0);
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_sign_flyer_width_height($db,$page_id,$page)
	{
		$sql_query = "select * from ".$this->ad_configuration_table;
		$ad_result = $this->db->Execute($sql_query);
		if (!$ad_result)
			return false;
		elseif ($ad_result->RecordCount() == 1)
			$show_ad_configuration = $ad_result->FetchRow();

		$type = ($page_id == 70) ? 'flyer' : 'sign';
		//width of sign/flyer
		$message = "Max Width to Display User Image (pixels):";
		$this->input_option_dropdown($show_ad_configuration,$type.'_maximum_image_width',$message,1000);

		//height of sign/flyer
		$message = "Max Height to Display User Image (pixels):";
		$this->input_option_dropdown($show_ad_configuration,$type.'_maximum_image_height',$message,1000);
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_title($page,$title_only=0)
	{
		// Display text below thumbnail
		$message = ($title_only) ? 'Hide Title:' : 'Hide Title below Thumbnail:';
		$this->input_radio_yes_no($page,'module_display_title',$message);
		if (!$title_only)
		{
			$this->row_count++;
			// Text Type below thumbnail
			// List for text types in dropdown
			$text_types = array('Title' => "title", 'Description' => "description", 'City' => "location_city", 'State' => "location_state",
								'Country' => "location_country", 'Zip' => "location_zip");
			for($i = 1; $i < 21; $i++)
				$text_types[$this->configuration_data['optional_field_'.$i.'_name']] = "optional_field_".$i;
			$this->body .= "
				<tr class=".$this->get_row_color().">
					<td align=right width=50% class=medium_font>
						<strong>Type of Text for Title to Display below Thumbnail:</strong><br>
						<span class=small_font>
							This is only enabled if you selected 'no' above.
						</span>
					</td>
					<td class=medium_font>
						<select name=c[module_text_type]>";
			foreach($text_types as $key => $value)
			{
				$this->body .= "<option value=".$value.(($page["module_text_type"] == $value) ? " selected" : "").">".$key."</option>";
			}
			$this->body .= "
						</select>
					</td>
				</tr>";
			if ($this->modules_debug)
				$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_text_type</td></tr>";
			$this->row_count++;
		}
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_category_dropdown(& $db,& $page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right width=50% class=medium_font>
					<strong>Category:</strong><br>
					<span class=small_font>
						Choose the category that you wish to display featured listings from within this module.  The only listings that
						will be displayed by this module will be the featured listings within this category.
					</span>
				</td>
				<td class=medium_font>";
		$this->get_category_dropdown("c[module_category]",$page["module_category"],1,$this->configuration_data["levels_of_categories_displayed_admin"]);
		$this->body .= $this->dropdown_body;
		$this->body .= "
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_category</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_location($page,$show_address=0)
	{
		if ($show_address)
			$this->input_radio_yes_no($page,'module_display_address','Display Address:');
		$this->input_radio_yes_no($page,'module_display_city','Display City:');
		$this->input_radio_yes_no($page,'module_display_state','Display State:');
		$this->input_radio_yes_no($page,'module_display_country','Display Country:');
		$this->input_radio_yes_no($page,'module_display_zip','Display Zip:');
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_optional_fields($page)
	{
		for ($i=1;$i<21;$i++)
		{
			$message = "Display <strong>".$this->configuration_data['optional_field_'.$i.'_name']."</strong>:";
			$this->input_radio_yes_no($page,'module_display_optional_field_'.$i,$message);
		}
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_title_module_text($db,$page_id,$page)
	{
		// Get text for the home page text
		$this->get_text($page_id);

		$sql = "select title_module_text from ".$this->ad_configuration_table;
		$result = $this->db->Execute($sql);
		if(!$result)
			return false;
		else
			$title_result = $result->FetchRow();
		// Default text
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right valign=top width=50% class=medium_font>
					<strong>Default Text to Display on Non-Listing Pages:</strong>
				</td>
				<td width=50% valign=top class=medium_font>
					<input type=text name=c[title_module_text] size=50 value=\"
					".stripslashes(urldecode($title_result["title_module_text"]))."\">
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>title_module_text</td></tr>";
		$this->row_count++;
		// Home page text
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right valign=top width=50% class=medium_font>
					<strong>Text to Display on Home Page:</strong>
				</td>
				<td width=50% valign=top class=medium_font>
					<input type=text name=c[title_module_home_text] size=50 value=\"
					".stripslashes(urldecode($this->messages[2462]))."\">
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>title_module_home_text</td></tr>";
		$this->row_count++;
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_photo_or_icon($page)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align=right width=50% class=medium_font>
					<strong>Display Photo / Icon / Site Default:
				</td>
				<td class=medium_font>
					<input type=radio name=c[photo_or_icon] value=1 ".
					(($page["photo_or_icon"]==1) ? "checked" : "").">
					photo<Br>
					<input type=radio name=c[photo_or_icon] value=3 ".
					(($page["photo_or_icon"]==3) ? "checked" : "").">
					icon<br>
					<input type=radio name=c[photo_or_icon] value=2 ".
					(($page["photo_or_icon"]==2 || !$page["photo_or_icon"]) ? "checked" : "").">
					site default
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>photo_or_icon</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_radio_yes_no($key,$variable,$message)
	{
	  //need to invert the logic level for title since default is '1'
	  	$logic_level_1 = 1;
	  	$logic_level_2 = 0;
	
	  	$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align='right' width='50%' class='medium_font'><strong>
					$message</strong>
				</td>
				<td class=medium_font>
					<input type='radio' name='c[$variable]' value='$logic_level_1' ".
					(($key[$variable] == $logic_level_1) ? "checked" : "").">
					yes<Br>
					<input type='radio' name='c[$variable]' value='".$logic_level_2."' ".
					(($key[$variable] == $logic_level_2) ? "checked" : "").">
					no
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>$variable</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_module_display_ad_description_where($page)
	{
	  $this->body .= "
			<tr class=".$this->get_row_color().">
				<td align='right' width='50%' class='medium_font'>
					<strong>Location of Listing Description:</strong>
				</td>
				<td class=medium_font>
					<input type='radio' name='c[module_display_ad_description_where]' value='1' ".
					(($page['module_display_ad_description_where'] == 1) ? "checked" : "").">
					below title<Br>
					<input type='radio' name='c[module_display_ad_description_where]' value='0' ".
					(($page['module_display_ad_description_where'] == 0) ? "checked" : "").">
					own column
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>module_display_ad_description_where</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function input_option_dropdown($key,$variable,$message,$MAX=100, $start=1)
	{
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td align='right' width='50%' class='medium_font'><strong>
					$message</strong>
				</td>
				<td class=medium_font>
					<select name='c[$variable]'>";
		for ($i=$start;$i<$MAX;$i++)
		{
			$this->body .= "<option ".(($i == $key[$variable]) ? 'selected' : '').">$i</option>";
		}
		$this->body .= "
					</select>
				</td>
			</tr>";
		if ($this->modules_debug)
			$this->body .= "<tr class=".$this->get_row_color()."><td align=center colspan=2 class=medium_error_font>$variable</td></tr>";
		$this->row_count++;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function sortModules($moduleArray)
	{
		if(!is_array($moduleArray)) {
			return false;
		}
		$returnArray = array();
		//visit every recordset row
		//for($i=0;$i<count($moduleArray);$i++)
		foreach ($moduleArray as $i => $module) {
			//visit every module tier
			foreach ($module as $k => $val) {
				$prevNode = str_replace('tier','',$k)-1;
				if($prevNode >= 0 && array_key_exists($module['tier'.$prevNode],$returnArray)&&!in_array($val,$returnArray[$module['pier'.$prevNode]])) {
					//if parent node exists, push this id into it's array
					$returnArray[$module['tier'.$prevNode]][] = $moduleArray[$i][$k];
				}
				if(!isset($returnArray[$val])) {
					//start new parent node
					$returnArray[$val] = array();
				}
			}
		}
		return $returnArray;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_home($section_index='') 
	{	
		$this->browse_sections($this->db,0, $section_index);
			
		$this->display_page();
	}
	function update_sections_home() 
	{

	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_browsing() 
	{		
		$this->browse_sections($this->db,1,'_browsing');
		$this->display_page();		
	}
	function update_sections_browsing() 
	{

	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_listing_process()
	{		
		$this->browse_sections($this->db,2, '_listing_process');
		$this->display_page();
	}
	function update_sections_listing_process()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_registration()
	{		
		$this->browse_sections($this->db,3, '_registration');
		$this->display_page();
	}
	function update_sections_registration()
	{
	
	}	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_user_mgmt()
	{		
		$this->browse_sections($this->db,4, '_user_mgmt');
		$this->display_page();
	}
	function update_sections_user_mgmt()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_login_languages()
	{		
		$this->browse_sections($this->db,5, '_login_languages');
		$this->display_page();
	}
	function update_sections_login_languages()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_extra_pages()
	{		
		$this->browse_sections($this->db,12, '_extra_pages');
		$this->display_page();
	}
	function update_sections_extra_pages()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_bidding()
	{		
		$this->browse_sections($this->db,14, '_bidding');
		$this->display_page();
	}
	function update_sections_bidding()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_show($section_index='')
	{ 
		// Catch all function for sections_home links
		$url = "index.php";
		switch( $_REQUEST['b'] )
		{
			case 1:
				$params = 'mc=pages_sections&page=sections_browsing';
				break;
			case 2:
				$params = 'mc=pages_sections&page=sections_listing_process';
				break;
			case 3:
				$params = 'mc=pages_sections&page=sections_registration';
				break;
			case 4:
				$params = 'mc=pages_sections&page=sections_user_mgmt';
				break;
			case 5:
				$params = 'mc=pages_sections&page=sections_login_languages';
				break;
			case 12:
				$params = 'mc=pages_sections&page=sections_extra_pages';
				break;
			case 14:
				$params = 'mc=pages_sections&page=sections_bidding';
				break;
			default: 
				$params = '';
				$this->browse_sections($this->db,$_REQUEST["b"],$section_index);
				$this->display_page();
				return true;
				break;
		}
		header("location: " . $url . "?" . $params );		
	}
	function update_sections_show()
	{
	
	}	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_text_search()
	{		
		if (!$this->browse_sections($this->db,$_REQUEST["b"]))
			return false;			
		$this->display_page();
	}
	function update_sections_text_search()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_sections_page($section_index = '')
	{		
		if (!$this->display_current_page($this->db,$_REQUEST["b"], $section_index))
			return false;		
		
		$this->display_page();
	}
	function update_sections_page($section_index = '')
	{		
		return $this->update_module_specifics($this->db,$_REQUEST["b"],$_REQUEST["c"], $section_index);
	}
	function display_modules_home()
	{		
		$this->showModule();
		$this->display_page();
	}
	function update_modules_home()
	{
		return ;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_browse()
	{		
		if( !$this->showModule(1) )
			return false;
		$this->display_page();
	}
	function update_modules_browse()
	{
		return ;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_featured()
	{		
		if( !$this->showModule(2) )
			return false;
		$this->display_page();
	}
	function update_modules_featured()
	{
		return ;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_newest()
	{		
		if( !$this->showModule(3) )
			return false;
		$this->display_page();
	}
	function update_modules_newest()
	{
		return ;
	}
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_misc()
	{		
		if( !$this->showModule(6) )
			return false;
		$this->display_page();
	}
	function update_modules_misc()
	{
		return ;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_misc_display()
	{		
		if( !$this->showModule(7) )
			return false;
		$this->display_page();
	}
	function update_modules_misc_display()
	{
		return ;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_page()
	{
		if ($_REQUEST["b"] && $_REQUEST["c"]){
			if (!$this->display_current_page($this->db,$_REQUEST["b"])){
				return false;
			}
		}elseif ($_REQUEST["b"]){
			if (!$this->display_current_page($this->db,$_REQUEST["b"]))
				return false;
		}else{
			$this->show_modules();
		}
				
		$this->display_page();
	}
	function update_modules_page()
	{
		return $this->update_module_specifics($this->db,$_REQUEST["b"],$_REQUEST["c"]);
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_modules_show()
	{ 
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();
		$this->body .= $menu_loader->getUserMessages();
		
		// Catch all function for modules_home links
		$url = "index.php";
		switch( $_REQUEST['b'] )
		{
			case 1:
				$params = 'mc=view_modules&page=modules_browse';
				break;
			case 2:
				$params = 'mc=view_modules&page=modules_featured';
				break;
			case 3:
				$params = 'mc=view_modules&page=modules_newest';
				break;
			case 4:
				$params = 'mc=view_modules&page=modules_html';
				break;
			case 5:
				$params = 'mc=view_modules&page=modules_php';
				break;
			case 6:
				$params = 'mc=view_modules&page=modules_misc';
				break;
			case 7:
				$params = 'mc=view_modules&page=modules_misc_display';
				break;
			default: 
				$params = '';
				
				$this->browse_module_sections($this->db,$_REQUEST["b"]);
				$this->display_page();
				return true;
				break;
		}				
		header("location: " . $url . "?" . $params );		
	}
	function update_modules_show()
	{
	
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function showModule($id = 0)
	{
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();
		$this->body .= $menu_loader->getUserMessages();
		
		if($id)
			return $this->browse_module_sections($this->db, $id);
		else
			return $this->browse_module_sections($this->db);
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	
	//browsing duplicates
	function display_sections_browsing_page(){
		return $this->display_sections_page('_browsing');
	}
	function update_sections_browsing_page(){
		return $this->update_sections_page('_browsing');
	}
	function display_sections_browsing_show(){
		return $this->display_sections_show('_browsing');
	}
	
	//listing duplicates
	function display_sections_listing_process_page(){
		return $this->display_sections_page('_listing_process');
	}
	function update_sections_listing_process_page(){
		return $this->update_sections_page('_listing_process');
	}
	
	function display_sections_listing_process_show(){
		return $this->display_sections_show('_listing_process');
	}
	
	//registration duplicates
	function display_sections_registration_page(){
		return $this->display_sections_page('_registration');
	}
	function update_sections_registration_page(){
		return $this->update_sections_page('_registration');
	}
	
	function display_sections_registration_show(){
		return $this->display_sections_show('_registration');
	}
	
	//user_mgmt duplicates
	function display_sections_user_mgmt_page(){
		return $this->display_sections_page('_user_mgmt');
	}
	function update_sections_user_mgmt_page(){
		return $this->update_sections_page('_user_mgmt');
	}
	
	function display_sections_user_mgmt_show(){
		return $this->display_sections_show('_user_mgmt');
	}
	
	//login_languages duplicates
	function display_sections_login_languages_page(){
		return $this->display_sections_page('_login_languages');
	}
	function update_sections_login_languages_page(){
		return $this->update_sections_page('_login_languages');
	}
	
	function display_sections_login_languages_show(){
		return $this->display_sections_show('_login_languages');
	}
	
	//extra_pages duplicates
	function display_sections_extra_pages_page(){
		return $this->display_sections_page('_extra_pages');
	}
	function update_sections_extra_pages_page(){
		return $this->update_sections_page('_extra_pages');
	}
	
	function display_sections_extra_pages_show(){
		return $this->display_sections_show('_extra_pages');
	}
	
	//bidding duplicates
	function display_sections_bidding_page(){
		return $this->display_sections_page('_bidding');
	}
	function update_sections_bidding_page(){
		return $this->update_sections_page('_bidding');
	}
	
	function display_sections_bidding_show(){
		return $this->display_sections_show('_bidding');
	}
	
	
	function display_pages_management(){
		header("location: index.php?mc=pages_management&page=sections_home");
	}
} // end of class Admin_pages

