<?php
// admin_payment_management_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 18824              $ ##
## File last change date:       ##
##  $Date:: 2010-01-18 16:59:#$ ##
##                              ##
##################################

class Payment_management extends Admin_site {

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Payment_management($db, $product_configuration=0)
	{
		$this->Admin_site($db, $product_configuration);
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function free_or_pay_ads_form($db)
	{
		if (!(geoPC::is_ent() || geoPC::is_premier() || geoPC::is_basic())){
			//return false;
		}
		
		$all_ads_are_free = $this->db->get_site_setting('all_ads_are_free');

		if (!$this->admin_demo())$this->body .= "<form action=index.php?mc=payments&page=payments_charge_for_listings method=post>\n";
		$this->body .= "<fieldset id='ChargeList'><legend>Charge for Listings</legend><table cellpadding=3 cellspacing=0 border=0 align=center width=100% class=row_color1>\n";
		//$this->title = "Payments > Charge for Listings?";
		$this->description = "Choose whether or not you wish to charge sellers to place listings on your site.
			If you select \"yes\" you must also specify which \"payment types\" you will accept by using the \"Payment
			Types\" menu to the left.";

		$this->body .= "<tr>\n\t<td width=50% valign=middle align=right class=medium_font><strong>Charge for Listings?:</strong> </td>\n\t";
		$this->body .= "<td width=50% class=medium_font>\n\t<input type=radio name=c value=yes ";
		if ($all_ads_are_free == 0)
			$this->body .= "checked";
		$this->body .= ">yes<br><input type=radio name=c value=no ";
		if ($all_ads_are_free == 1)
			$this->body .= "checked";
		$this->body .= ">no \n\t</td>\n</tr>\n";
		if (!$this->admin_demo()) $this->body .= "<tr>\n\t<td colspan=2 class=medium_font align=center>\n\t<input type=submit name='auto_save' value=\"Save\">\n\t</td>\n</tr>\n";
		$this->body .= "</table></fieldset>\n";
		$this->body .= "</form>";
		return true;
	
	} //end of function free_or_pay_ads_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_free_or_pay_ads($db,$free_or_not_info=0)
	{
		if ($free_or_not_info)
		{
			if ($free_or_not_info == "no")
				$charge_for_ads = 1;
			elseif ($free_or_not_info == "yes")
				$charge_for_ads = 0;
				
			$this->db->set_site_setting('all_ads_are_free',$charge_for_ads);
			return true;
		}
		else
		{
			$this->error_message = $this->internal_error_message;
			return false;
		}
	} //end of function update_free_or_pay_ads
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function currency_designation_form($db)
	{
		$this->sql_query = "select precurrency,postcurrency from ".$this->site_configuration_table;
		$result = $db->Execute($this->sql_query);
		if (!$result)
		{
			//echo $this->sql_query."<br>\n";
			$this->error_message = $this->internal_error_message;
			return false;
		}
		else
		{

			$show=$result->FetchRow();
			if (!$this->admin_demo())$this->body .= "<form action=index.php?mc=payments&page=payments_currency_designation method=post>\n";
			$this->body .= "<fieldset id='CurrencyDesig'><legend>Currency Type You Accept from Sellers</legend><table cellpadding=3 cellspacing=0 border=0 align=center width=100%>\n";
			//$this->title = "Payment Management > Currency Designation";
			$this->description = "Edit the currency symbol that comes before and currency type that comes after any price within your site.";

			$this->body .= "<tr class=row_color1>\n\t<td align=right width=50% class=medium_font>\n\t<b>Symbol \"before\"</b> ($): \n\t
				</td>\n\t";
			$this->body .= "<td width=\"50%\">\n\t<input type=text name=h[precurrency] value=\"".$show["precurrency"]."\"></td>\n\t</tr>\n";

			$this->body .= "<tr class=row_color2>\n\t<td align=right width=50% class=medium_font>\n\t<b>Currency Type \"after\"</b> (USD,DM,...): \n\t
				</td>\n\t";
			$this->body .= "<td width=\"50%\">\n\t<input type=text name=h[postcurrency] value=\"".$show["postcurrency"]."\"></td>\n\t</tr>\n";

			if (!$this->admin_demo()) $this->body .= "<tr>\n\t<td colspan=2 class=medium_font align=center><input type=submit name='auto_save' value=\"Save\"></td>\n</tr>\n";
			$this->body .= "</table></fieldset>\n";
			$this->body .= "<div class='page_note'><strong>Note:</strong> Currency symbols must be specified in their ASCII code format in order to be
			displayed properly.  Please reference the ASCII codes below for your desired currency symbol. There is no special ASCII code to enter for the dollar ($) symbol.\n\t
			<div style='padding-top:20px;'><strong>Common Currency ASCII Codes:</strong>
			<ul>
			<li>&pound; British Pounds - ASCII CODE: <strong>&amp;pound;</strong></li>
			<li>&euro; European Euro - ASCII CODE: <strong>&amp;euro;</strong></li>
			<li>&yen; Japanese Yen - ASCII CODE: <strong>&amp;yen;</strong></li>
			</ul
			</div>
			</div>\n\t";
			return true;
		}

	} //end of function currency_designation_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_currency_designation($db,$currency_type_info=0)
	{
		if ($currency_type_info)
		{
			$this->sql_query = "update ".$this->site_configuration_table." set
				precurrency = \"".$currency_type_info["precurrency"]."\",
				postcurrency = \"".$currency_type_info["postcurrency"]."\"";
			//echo $this->sql_query."<br>\n";
			$result = $db->Execute($this->sql_query);
			//clear the settings cache
			geoCacheSetting::expire('configuration_data');
			if (!$result)
			{
				//echo $this->sql_query."<br>\n";
				$this->error_message = $this->internal_error_message;
				return false;
			}
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	} //end of function update_currency_designation

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_payments_charge_for_listings()
	{
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		$this->body .= $menu_loader->getUserMessages();
		
		if (!$this->free_or_pay_ads_form($this->db))
			return false;
		$this->display_page();
	}
	function update_payments_charge_for_listings()
	{
		return $this->update_free_or_pay_ads($this->db,$_REQUEST["c"]);
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_payments_currency_designation()
	{
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		$this->body .= $menu_loader->getUserMessages();
		
		if (!$this->currency_designation_form($this->db))
			return false;
		$this->display_page();
	}
	function update_payments_currency_designation()
	{
		return $this->update_currency_designation($this->db,$_REQUEST["h"]);
	}
} //end of class Payment_management
