<?php
// admin_wysiwyg_config.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 9670               $ ##
## File last change date:       ##
##  $Date:: 2007-01-23 14:26:#$ ##
##                              ##
##################################

class wysiwyg_configuration {
	
	function wysiwyg_configuration() {
		if (Singleton::isInstance('Admin_site')){
			if (strlen(PHP5_DIR)>0){
				$this->admin_site = Singleton::getInstance('Admin_site');
			} else {
				$this->admin_site =& Singleton::getInstance('Admin_site');
			}
		}
		else {
			return false;
		}				
	}
	
	function display_wysiwyg_general_config() {
		//get the instance of the db.
		if (strlen(PHP5_DIR)>0){
			$db = DataAccess::getInstance();
		} else {
			$db =& DataAccess::getInstance();
		}
		
		$this->admin_site->body = "<script type=\"text/javascript\" src='js/admin_tinymce_config_tooltips.js'></script>";
		
		$this->admin_site->body .= "<form action='index.php?mc={$_GET['mc']}&page={$_GET['page']}' method=post onSubmit=\"if(document.getElementById('tmce').checked)return confirm('WARNING!\\nThe editor attempts to correct HTML that is invalid. This could cause problems with your templates depending on your design. Contact support for details.\\n\\nDo you want to activate the editor?');\"><fieldset id='WYSIWYGSetting'><legend>Admin Panel WYSIWYG Settings</legend><table align='center' border='0' cellpadding='3' cellspacing='0' width='100%'>";
	
		$this->admin_site->row_count++;
		$this->admin_site->body .= "<tr class=".$this->admin_site->get_row_color().">\n\t<td align=right valign=top width=50% class=medium_font>\n\t<b>Admin textareas:</b>".$this->admin_site->show_tooltip(1,1)."</td>\n\t";
		$this->admin_site->body .= "<td width=50% valign=top class=medium_font>\n\t" .
				"<label><input type=\"radio\" name=\"use_admin_wysiwyg\" value=\"0\" ".((!$db->get_site_setting("use_admin_wysiwyg")) ? 'checked' : '' )."/> None</label><br />
				 <label><input type=\"radio\" name=\"use_admin_wysiwyg\" value=\"TinyMCE\" ".(($db->get_site_setting("use_admin_wysiwyg")=="TinyMCE") ? 'checked' : '' )."/ id='tmce'> TinyMCE</label></td></tr>";
		
		$this->admin_site->row_count++;
		$this->admin_site->body .= "<tr class=".$this->admin_site->get_row_color().">\n\t<td align=right valign=top width=50% class=medium_font>\n\t<b>CSS stylesheets:".$this->admin_site->show_tooltip(2,1)."</br>(comma separated)</b></td>\n\t";
		$this->admin_site->body .= "<td width=50% valign=top class=medium_font>\n\t" .
				"<textarea name=\"wysiwyg_css_uri\" cols=50>".$db->get_site_setting("wysiwyg_css_uri",true)."</textarea></td></tr>";
		//compressor setting
		$this->admin_site->row_count++;
		$this->admin_site->body .= "<tr class=".$this->admin_site->get_row_color().">\n\t<td align=right valign=top width=50% class=medium_font>\n\t<b>Use GZip Compression:".$this->admin_site->show_tooltip(3,1)."</td>\n\t";
		$this->admin_site->body .= "<td width=50% valign=top class=medium_font>\n\t" .
				"<label><input type=\"radio\" name=\"use_wysiwyg_compression\" value=\"1\" ".(($db->get_site_setting("use_wysiwyg_compression")) ? 'checked' : '' )."/> On</label><br />
				 <label><input type=\"radio\" name=\"use_wysiwyg_compression\" value=\"0\" ".(($db->get_site_setting("use_wysiwyg_compression")) ? '' : 'checked' )."/> Off</label></td></tr>";
				
		//fix blank screen
		$this->admin_site->row_count++;
		$this->admin_site->body .= "<tr class=".$this->admin_site->get_row_color().">\n\t<td align=right valign=top width=50% class=medium_font><strong>IE Blank Screen Fix:</strong></td>\n\t";
		$this->admin_site->body .= "<td width=50% valign=top class=medium_font>\n\t" .
				"<input type=\"checkbox\" name=\"wysiwyg_blank_screen_fix\" value=\"1\" ".(($db->get_site_setting("wysiwyg_blank_screen_fix")) ? 'checked="checked"' : '' )." /> On</td></tr>";
				
		
		$this->admin_site->body .= "<tr>\n\t<td colspan=2 align=center class=medium_font>\n\t<input type=submit value=\"Save\" name=\"auto_save\"><br /></td>\n</tr>\n";
		
		$this->admin_site->body .= "</table></fieldset>";
		
		$this->admin_site->display_page();
		return false;
	}
	
	function update_wysiwyg_general_config() {
		//get the instance of the db.
		if (strlen(PHP5_DIR)>0){
			$db = DataAccess::getInstance();
		} else {
			$db =& DataAccess::getInstance();
		}
		//if set to 0, set it to PHP false
		$wysiwyg = ($_POST['use_admin_wysiwyg'])? $_POST['use_admin_wysiwyg'] : false;
		$compress = ($_POST['use_wysiwyg_compression'])? 1:false;
		$blankScreen = ($_POST['wysiwyg_blank_screen_fix'])? 1: false;
		$db->set_site_setting('use_admin_wysiwyg', $wysiwyg);
		$db->set_site_setting('wysiwyg_css_uri', trim($_POST['wysiwyg_css_uri']));
		$db->set_site_setting('use_wysiwyg_compression',$compress);
		$db->set_site_setting('wysiwyg_blank_screen_fix',$blankScreen);
		return true;
	}
	/**
	 * Gets header javascript text for given type.
	 *
	 * @param String $type either textManager, htmlModules, or templateCode
	 * @return String The text to be inserted into header for the given textarea type.
	 */
	public static function getHeaderText($type, $fullpage = false, $fileBased = false, $restoreDefault = false){
		$db = DataAccess::getInstance();
		$text = '';
		$view = geoView::getInstance();
		//load prototype first
		
		
		if ($db->get_site_setting('use_admin_wysiwyg') == 'TinyMCE') {
			//let view class know to add stuff for WYSIWYG editor
			$view->editor = true;
			
			$tpl = new geoTemplate('admin');
			$tpl->doc_base_url = dirname($db->get_site_setting('classifieds_url')).'/';
			
			$tpl->use_gzip = $db->get_site_setting('use_wysiwyg_compression');
			$tpl->blank_screen_fix = $db->get_site_setting('wysiwyg_blank_screen_fix');
			
			$tpl->type = $type;
			$tpl->fullpage = ($fullpage)? 1: 0;
			$content_css_parts = explode(',',$db->get_site_setting("wysiwyg_css_uri",true));
			$content_css = array();
			foreach ($content_css_parts as $filename) {
				$content_css[] = geoTemplate::getUrl('',$filename);
			}
			
			$tpl->content_css = implode(',',$content_css);
			$tpl->fileBased = $fileBased;
			$tpl->restoreDefault = $restoreDefault;
			return $tpl->fetch('tinymce.tpl');
		}
		return '';
	}
}

