<?php
//cart.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

//File used for admin-side cart sessions

class AdminCart
{
	private $cart, $db, $userId;
	
	public function __construct ()
	{
		$this->cart = geoCart::getInstance();
		$this->db = DataAccess::getInstance();
		
		$this->userId = null;
		
		if (isset($_GET['userId'])) {
			$this->userId = (int)$_GET['userId'];
			if ($this->userId) {
				//validate user
				$user = geoUser::getUser($this->userId);
				if (!$user) {
					//not valid user ID
					geoAdmin::m('Could not start an order, the user ('.$this->userId.') is not valid.',geoAdmin::ERROR);
					$this->userId = null;
				}
			}
		}
	}
	
	public function display_admin_cart ()
	{
		if ($this->userId===null) {
			//User ID not known, need to redirect to page to select user
			header ("Location: index.php?page=admin_cart_select_user");
			return;
		}
		
		if ($this->userid) {
			$user = geoUser::getUser($this->userId);
			if (!$user->status) {
				//User is suspended!  can't do anything for this user
				header ("Location: index.php?page=admin_cart_select_user&invalid_user=1");
				return;
			}
		}
		
		$this->cart->init(false, $this->userId);
		
		$tpl_vars = $this->cart->getCommonTemplateVars();
		
		//what would normally be used to display the body?
		$view = geoView::getInstance();
		$view_vars = $view->getAllAssignedVars();
		
		$tpl_vars['cart_tpl_files'] = (isset($view_vars['geo_inc_files']))? $view_vars['geo_inc_files']: array();
		$tpl_vars['cart_body'] = (isset($view_vars['body_html']))? $view_vars['body_html'] : '';
		if (isset($view_vars['body_html'])) {
			//reset body html so it isn't displayed twice
			$view->body_html = '';
		}
		$tpl_vars['cartUserId'] = $this->userId;
		$tpl_vars['cartUsername'] = $this->cart->user_data['username'];
		
		/*
		 * CART Setup
		 * 
		 */
		
		//get text for my account links since a lot of the text will be in there
		$this->cart->site->messages = $this->db->get_text(true,10208);
		
		//don't display add to cart buttons since they are displayed by us
		define('GEO_MINI_CART_DISPLAYED',1);
		
		$cartNumItems = 0;
		if ($this->cart->order) {
			foreach($this->cart->order->getItem('parent') as $item) {
				//get the number of "main" order items (no parent, processOrder < 1000)
				$processOrder = $item->getProcessOrder();
				if($processOrder < 1000) {
					//anything with process order less than 1000 is considered "normal"
					$cartNumItems++;
				}
			}
		}
		//cart data/link display
		$tpl_vars['cartItemCount'] = $cartNumItems;
		$tpl_vars['cartTotal'] = ($this->cart->order) ? $this->cart->getCartTotal() : 0;
		
		//cart "action"
		
		$cartLinks = array();
		
		$cartActionIndex = $tpl_vars['cartActionIndex'] = $this->cart->getAction();
		$tpl_vars['cartStepIndex'] = $this->cart->current_step;
		
		if ($this->cart->isInMiddleOfSomething()) {
			//In middle of something
			//get the text that will have actions
			$vars = array('action' => '', 'step' => 'my_account_links');
			//use getType as that will work even if in "stand alone" cart.
			$itemType = $this->cart->item->getType();
			$currentAction = $tpl_vars['cartAction'] = geoOrderItem::callDisplay('getActionName',$vars,'',$itemType);
			//let the template know whether it is a stand-alone cart or not.
			$tpl_vars['isStandalone'] = $this->cart->isStandaloneCart();
		} else {
			//not adding normal item to cart, so must be on main cart page (or checking out)
			//so show all buttons
			$cartLinks = geoOrderItem::callDisplay('my_account_links_newButton',null,'array');
			foreach ($cartLinks as $a_name => $ldata) {
				if (!isset($ldata['link'])) {
					//automatically set all the links so order items don't have to bother with
					//that part, but if they do, don't set it here.
					$cartLinks[$a_name]['link'] = $tpl_vars['cart_url']."&amp;action=new&amp;main_type=$a_name";
				}
			}
		}
		
		$tpl_vars['cartLinks'] = $cartLinks;
		
		
		geoView::getInstance()->addCssFile('css/cart.css')
			->setBodyVar($tpl_vars)
			->setBodyTpl('cart/index.tpl');
	}
	
	public function display_admin_cart_select_user ()
	{
		$admin = geoAdmin::getInstance();
		
		$tpl_vars = array();
		
		if (isset($_GET['invalid_user'])) {
			//invalid user was specified, that is why they are showing this page
			geoAdmin::m('Invalid user specified for order, please select a valid user.', geoAdmin::ERROR);
		}
		
		$tpl_vars['adminMsgs'] = geoAdmin::m();
		
		//figure out if should show anon button or not
		$tpl_vars['allow_anon'] = geoOrderItem::callDisplay('anonymousAllowed',null,'bool_true');
		
		$admin->setBodyTpl('cart/select_user.tpl')
			->v()->setBodyVar($tpl_vars);
	}
	
	public function update_admin_cart_select_user ()
	{
		if (!geoAjax::isAjax()) {
			if (isset($_POST['userId'])) {
				//user ID retrieved
				header ("Location: index.php?page=admin_cart&userId=".(int)$_POST['userId']);
				geoAdmin::getInstance()->setRendered(true);
				return;
			}
		}
		geoAdmin::getInstance()->setRendered(true);
		
		$userSearch = $origSearch = ''.$_POST['userSearch'];
		
		if (!strlen(trim($userSearch))) {
			return;
		}
		
		$userSearch = $this->db->qstr($userSearch.'%');
		
		
		$where = array();
		if (''.(int)$origSearch==$origSearch) {
			$where [] = "ud.`id` LIKE $userSearch";
		}
		$where [] = "ud.`username` LIKE $userSearch";
		$where[] = "ud.`email` LIKE $userSearch";
		$where[] = "ud.`email2` LIKE $userSearch";
		$where[] = "ud.`company_name` LIKE $userSearch";
		$where[] = "ud.`firstname` LIKE $userSearch";
		$where[] = "ud.`lastname` LIKE $userSearch";
		$where[] = "ud.`address` LIKE $userSearch";
		$where[] = "ud.`phone` LIKE $userSearch";
		
		$all = $this->db->Execute("SELECT ud.*, l.status FROM ".geoTables::logins_table." as l, ".geoTables::userdata_table." as ud 
			WHERE ud.id=l.id AND ud.`id`!=1 AND l.status > 0 AND (".implode(' OR ',$where).") ORDER BY username LIMIT 10");
		
		$tpl = new geoTemplate (geoTemplate::ADMIN);
		$tpl->users = $all;
		echo $tpl->fetch('cart/select_user_ajax.tpl');
		
		//<li>searched: ".htmlspecialchars($userSearch)."</li></ul>";
		
		return true;
		
	}
}
