// $Rev:$


var geoSearch = {
	init : function () {
		$('text_search_form').observe('submit', geoSearch.searchFormSubmit);
		
		$('textTab').observe('click', geoSearch.textTabClicked);
		$('filenameTab').observe('click', geoSearch.filenameTabClicked);
		$('contentTab').observe('click', geoSearch.contentTabClicked);
		$('addonTab').observe('click', geoSearch.addonTabClicked);
		
		var cookieQuery = geoUtil.getCookie('admin_last_text_search');
		if (!$('text_query').getValue() && cookieQuery) {
			$('text_query').setValue(cookieQuery);
		}
		
		if ($('text_query').getValue()) {
			//something filled in for the query, so automatically show it
			geoSearch.textTabClicked();
			geoSearch.updateQueryLink();
			$('searchResultsBox').show();
		}
		$('text_search_form').getElements().each (function (elem) {
			elem.observe('change', geoSearch.updateQueryLink);
		});
	},
	
	updateQueryLink : function () {
		var params = $('text_search_form').serialize().replace('&auto_save=1','');
		var url = location.protocol+'//'+location.hostname+location.pathname+'?page=text_search&'+params;
		
		$('permaLink').update(url);
		$('permaLinkBox')[$('text_query').getValue() ? 'show' : 'hide']();
	},
	
	searchFormSubmit : function (action) {
		action.stop();
		
		if ($('filenameTab').hasClassName('activeTab')) {
			//filename tab active
			geoSearch.filenameTabClicked();
		} else if ($('contentTab').hasClassName('activeTab')) {
			//content tab active
			geoSearch.contentTabClicked();
		} else {
			//default to text tab active
			geoSearch.textTabClicked();
		}
		
		//save search in a cookie
		if ($('text_query').getValue()) {
			document.cookie = "admin_last_text_search=" + escape($('text_query').getValue()) + "; path=/";
		}
		
		$('searchResultsBox').show();
	},
	
	textTabClicked : function () {
		$('searchType').setValue('text');
		var params = $('text_search_form').serialize(true);
		
		$('textTab').addClassName('activeTab');
		$('filenameTab').removeClassName('activeTab');
		$('contentTab').removeClassName('activeTab');
		$('addonTab').removeClassName('activeTab');
		
		$('textTabContents').show();
		$('filenameTabContents').hide();
		$('contentTabContents').hide();
		$('addonTabContents').hide();
		
		$('loadingBox').show();
		//run an ajax request
		new Ajax.Updater('textTabContents', 'index.php?page=text_search', {
			parameters : params,
			onComplete : function () {
				if ($('textTabContents').visible()) {
					//hide the loading thingy
					$('loadingBox').hide();
				}
			}
		});
	},
	
	addonTabClicked : function () {
		$('searchType').setValue('addon');
		var params = $('text_search_form').serialize(true);
		
		$('addonTab').addClassName('activeTab');
		$('filenameTab').removeClassName('activeTab');
		$('contentTab').removeClassName('activeTab');
		$('textTab').removeClassName('activeTab');
		
		$('addonTabContents').show();
		$('filenameTabContents').hide();
		$('contentTabContents').hide();
		$('textTabContents').hide();
		
		$('loadingBox').show();
		//run an ajax request
		new Ajax.Updater('addonTabContents', 'index.php?page=text_search', {
			parameters : params,
			onComplete : function () {
				if ($('addonTabContents').visible()) {
					//hide the loading thingy
					$('loadingBox').hide();
				}
			}
		});
	},
	
	filenameTabClicked : function () {
		$('searchType').setValue('filename');
		var params = $('text_search_form').serialize(true);
		
		$('filenameTab').addClassName('activeTab');
		$('textTab').removeClassName('activeTab');
		$('contentTab').removeClassName('activeTab');
		$('addonTab').removeClassName('activeTab');
		
		$('filenameTabContents').show();
		$('textTabContents').hide();
		$('contentTabContents').hide();
		$('addonTabContents').hide();
		
		$('loadingBox').show();
		
		//run an ajax request
		new Ajax.Updater('filenameTabContents', 'index.php?page=text_search', {
			parameters : params,
			onComplete : function () {
				if ($('filenameTabContents').visible()) {
					//hide the loading thingy
					$('loadingBox').hide();
				}
			}
		});
	},
	
	contentTabClicked : function () {
		$('searchType').setValue('content');
		var params = $('text_search_form').serialize(true);
		
		$('contentTab').addClassName('activeTab');
		$('textTab').removeClassName('activeTab');
		$('filenameTab').removeClassName('activeTab');
		$('addonTab').removeClassName('activeTab');
		
		$('contentTabContents').show();
		$('textTabContents').hide();
		$('filenameTabContents').hide();
		$('addonTabContents').hide();
		
		$('loadingBox').show();
		
		//run an ajax request
		new Ajax.Updater('contentTabContents', 'index.php?page=text_search', {
			parameters : params,
			onComplete : function () {
				if ($('contentTabContents').visible()) {
					//hide the loading thingy
					$('loadingBox').hide();
				}
			}
		});
	}
};

Event.observe(window, 'load', function () {
	geoSearch.init();
});
