<?php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19733              $ ##
## File last change date:       ##
##  $Date:: 2010-05-28 10:55:#$ ##
##                              ##
##################################

require_once 'app_top.ajax.php';

class ajax {
	var $db;
	var $debug_ajax = 0;
	var $ad_configuration_data;
	var $configuration_data;

	public function __construct ()
	{
		$this->db = DataAccess::getInstance();
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function getCategoryQuestions($category_id=0)
	{
		//sanitize input.
		$category_id = intval($category_id);
		if ($this->debug_ajax)
		{
			$this->body .= "<BR>TOP OF GETCATEGORYQUESTIONS<BR>\n";
		}
		while ($category_id != 0)
		{
			//get the questions for this category
			$query = "select lang.name,lang.choices,lang.question_id, cat.other_input from geodesic_classifieds_sell_questions as cat, geodesic_classifieds_sell_questions_languages as lang
			 where cat.category_id = '$category_id' AND cat.question_id=lang.question_id AND lang.language_id = ".$this->db->getLanguage()." order by display_order";
			if ($this->debug_ajax) $this->body .= $query."<Br>\n";
			$result = $this->db->Execute($query) or die("An error has occurred".__LINE__);
			if (!$result)
				return false;
			elseif ($result->RecordCount() > 0)
			{
				while ($get_questions = $result->FetchRow())
				{
					$category["questions"][$get_questions['question_id']] = $get_questions['name'];
					$category["choices"][$get_questions['question_id']] = $get_questions['choices'];
					$category['other_input'][$get_questions['question_id']] = $get_questions['other_input'];
				}
			}

			//get this_cat_id parent category
			$query = "SELECT parent_id FROM geodesic_categories WHERE category_id = ".$category_id;
			$result = $this->db->Execute($query) or die("An error has occurred".__LINE__);
			if (!$result)
				return false;
			elseif ($result->RecordCount() == 1)
			{
				$show_category = $result->FetchRow();
				$category_id = $show_category['parent_id'];
			}
			else
				break;
		}
		return $category;
	} //end of function get_category_questions

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_category_configuration($category_id=0)
	{
		//Get Category Configuration
		if($category_id != 0)
		{
			$sql = "select * from geodesic_categories where category_id = ?";
			$result = $this->db->Execute($sql, array($category_id));
			if (!$result)
				return false;
			elseif($result->RecordCount() == 1)
				$this->category_configuration = $result->FetchNextObject();
		}

		if($this->category_configuration->USE_SITE_DEFAULT==0||$category_id==0 || !geoPC::is_ent())
		{
			$sql = "SELECT * FROM geodesic_classifieds_configuration";
			$result = $this->db->Execute($sql);
			if (!$result)
				return false;
			elseif($result->RecordCount() == 1)
				$this->category_configuration = $result->FetchNextObject();
		}
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_ad_configuration()
	{
		$sql = "select * from geodesic_classifieds_ad_configuration";
		$result = $this->db->Execute($sql);
		if (!$result)
			return false;
		elseif ($result->RecordCount() == 1)
		{
			$this->ad_configuration_data = $result->FetchNextObject();
			return true;
		}

	} //function get_ad_configuration

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_site_configuration()
	{
		$this->configuration_data = $this->db->get_site_settings(true);
		return true;
	} //function get_ad_configuration

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function CountOptionalFields()
	{
		$count = 0;
		$config = $this->db->get_site_settings(true);
		for($i = 1; array_key_exists('use_optional_field_'.$i,$config); $i++){
			$count++;
		}
		$this->optional_fields = $count;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_text()
	{
		$db = DataAccess::getInstance();
		$sql = "select text_id,text from geodesic_pages_messages_languages where page_id = ? AND language_id = ?";
		//echo $sql."<br>\n";
		$result = $db->Execute($sql, array($this->page_id, $db->getLanguage()));
		if (!$result)  return false;
		
		if ($result->RecordCount() > 0) {
			//take the database message result and push the contents into an array
			while ($show = $result->FetchNextObject()) {
				$this->messages[$show->TEXT_ID] = $show->TEXT;
				//echo $show->TEXT_ID." - ".$show->TEXT."<br>\n";
			}
		}
	} // end of function get_text

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function displaySearchQuestions($categoryID)
	{
		$category = $this->getCategoryQuestions($categoryID);
		$to_display = 0;
		
		// Display all optional fields
		$this->page_id = 44;
		$this->get_category_configuration($categoryID);
		$this->get_site_configuration();
		$this->get_ad_configuration();

		$field_vars = get_object_vars($this->category_configuration);
		$ad_vars = get_object_vars($this->ad_configuration_data);
		
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true, $this->page_id);
		
		$tpl = new geoTemplate('system','other');
		
		$session = geoSession::getInstance();
		$session->initSession();
		$groupId = (int)$session->getUserId();
		
		$category_fields = geoFields::getInstance($groupId, $categoryID);
		

		if(geoPC::is_ent() && $category_fields->getCategoryId()) {
			//if fields->getCategoryId returns other than 0, there are category-specific settings for this category (or one of its parents)

			$showCat = $category_fields->getDisplayLocationFields('search_fields');
			$site_fields = geoFields::getInstance($groupId, 0);
			$showSite = $site_fields->getDisplayLocationFields('search_fields');
			//if there are any site-wide fields in use here but not in default
			//we need to show them
						
			$categorySiteWides = array();
			for($i = 1; $i <= 20; $i++) {
				$fieldName = 'optional_field_'.$i;
				if($showCat[$fieldName] && !$showSite[$fieldName]) {
					//not using this field site-wide, so show it here
					$categorySiteWides[$i] = $i;
				}
			}
			
			reset($categorySiteWides);
			$optionals = array();
			
			$use_filters = $db->get_site_setting('use_filters');
			
			foreach($categorySiteWides as $i) {
				if($use_filters && $db->get_site_setting("optional_".$i."_filter_association")) {
						continue;
				}
				$fieldName = 'optional_field_'.$i;
				if($i == 1) {
					$optionals[$i]['label'] = $msgs[1457];
				} elseif($i <= 10) {
					$optionals[$i]['label'] = $msgs[(1458+($i-1))];
				} elseif($i <= 20) {
					$optionals[$i]['label'] = $msgs[(1933+($i-11))];
				} elseif($i <= 35) {
					$optionals[$i]['label'] = $msgs[(2778+($i-21))];
				}
					
				if ($category_fields->$fieldName->field_type == 'number' || $category_fields->$fieldName->field_type == 'cost') {
					//if numbers only - produce a upper and lower limit
					$optionals[$i]['type'] = 'numbers';
					
				} elseif ($category_fields->$fieldName->field_type != 'dropdown') {
					$optionals[$i]['type'] = 'text';
				} else {
					$optionals[$i]['type'] = 'select';
					$query = "select * from geodesic_classifieds_sell_question_choices where type_id = ".((int)$category_fields->$fieldName->type_data)." order by display_order,value";
					$type_result = $this->db->Execute($query);
					if(!$type_result) {
						die();
					}
					if ($type_result->RecordCount() > 0) {
						$dropdownOptions = array();
						$dropdownOptions[0]['value'] = "";
						$matched = 0;
						for($o = 1; $show_dropdown = $type_result->FetchRow(); $o++) {
							$dropdownOptions[$o]['value'] = $show_dropdown['value'];
							if ($this->classified_variables["optional_field_".$i] == $show_dropdown['value']) {
								$dropdownOptions[$o]['selected'] = true;
								$matched = 1;
							}
						}
						$optionals[$i]['dropdown'] = $dropdownOptions;
					} else {
						//blank text box
						$optionals[$i]['type'] = 'text';
					}
				}
				if (strpos($category_fields->$fieldName->type_data, ':use_other')!== false && intval($category_fields->$fieldName->type_data)) {
					$optionals[$i]['other_box'] = true;
				}
				$to_display++;
			}
			$tpl->optionals = $optionals;			
		}
		
		//spit out the questions
		if(is_array($category)) {
			$questions = array();
			$q = 0;
			foreach ($category["questions"] as $key => $value) {
				//get the list of choices for this question
				$questions[$q]['label'] = $value;
				$questions[$q]['key'] = $key;
				if ($category["choices"][$key] == "check") {
					$questions[$q]['type'] = 'check';
				} elseif ($category["choices"][$key] == "none") {
					$questions[$q]['type'] = 'text';
				} elseif ($category["choices"][$key] == "url") {
					$questions[$q]['type'] = 'text';
				} elseif ($category["choices"][$key] == "textarea") {
					//just searching, so use inputs instead of textareas
					$questions[$q]['type'] = 'text';
				} else {
					$query = "select * from geodesic_classifieds_sell_question_choices where type_id = '{$category["choices"][$key]}' order by display_order,value";
					$result = $this->db->Execute($query) or die("An error has occurred ".__LINE__);
					if ($result->RecordCount() > 0) {
						$questions[$q]['type'] = 'select';
						$opts = array();
						//no leading, blank option here
						//we will only add if there is not already one.
						$blankInserted = false;
						while ($row = $result->FetchRow()) {
							if (strlen(trim($row['value'])) == 0) {
								$blankInserted = true;
							} else if (!$blankInserted) {
								//automatically add blank option as first option, but ONLY if there
								//is not already another blank option at the top of the list.
								//If there is NO blank option, then user is forced to always search
								//for a specific thing.
								$blankInserted = true;
								$opts[] = "";
							}
							$opts[] = $row['value'];
						}
						$questions[$q]['options'] = $opts;
						if($category['other_input'][$key] == 1) {
							$questions[$q]['other'] = true;
						}
					}
				}
				$to_display++;
				$q++;
			}
		}
		$tpl->questions = $questions;
		
		$criteria = $tpl->fetch('ajax_searchQuestions.tpl');
		
		echo ($to_display == 0) ? "&nbsp;~~|~~catQuestions" : "$criteria~~|~~catQuestions";
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	/**
	 * @deprecated Not used any more!  Should be removed probably.
	 */
	function update_precurrency($type_id) {
		$query = "SELECT `precurrency` FROM `geodesic_currency_types` WHERE type_id = ? LIMIT 1";
		$precurrency_result = $this->db->Execute($query, array($type_id)) or die($this->db->ErrorMsg());
		if ($precurrency_result->RecordCount()>0) {
			$precurrency = $precurrency_result->FetchRow();
			//setting the value first followed by the id names of the fields to be replaced
			echo $precurrency['precurrency']."~~|~~precurrency~~|~~auction_minimum_precurrency~~|~~auction_reserve_precurrency~~|~~auction_buy_now_precurrency";
		}
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	/**
	 * @deprecated Not used, call cron.php directly now
	 *
	 */
	function close() {
		require_once (GEO_BASE_DIR.'cron.php');
		$cron = geoCron::getInstance();
		$cron->heartbeat();
		require_once (GEO_BASE_DIR.'app_bottom.php');
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

}

//filter inputs.
if (isset($_GET['action'])){
	//allowed functions - if the action is not in this array, it is not going to be run.
	$functions = array('close', 'update_precurrency', 'displaySearchQuestions','get_text','CountOptionalFields','getCategoryQuestions');
	
	//now make sure action is one of those.  Otherwise, set it to null.
	$_GET['action'] = (in_array($_GET['action'],$functions)) ? $_GET['action'] : null;
}
if (isset($_GET["action"]) && $_GET['action']!=null)
{
	$ajax = new ajax($db,$product_configuration);
	$action = $_GET['action'];
	if ($ajax->debug_ajax) {
		echo "initiating ajax class<bR>\n";
		echo "$action is action<bR>\n";
		echo $_GET["b"]." is b<bR>\n";
	}
	if (isset($_GET['b'])) {
		//it's ok to send b un-filtered, each function does it's own error checking if needed.
		echo $ajax->$action($_GET["b"]);
	} else {
		echo $ajax->$action();
	}
}
function initAjax() {
	//this is going away, will be kept around for a version or 2 for custom code have time to update
	
}
