<?php
//getListing.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20309              $ ##
## File last change date:       ##
##  $Date:: 2010-09-07 14:21:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}
//get a list of all categories (optionally starting from a given top-level category (the 'parent')) 

if (isset($args['parent']) && !is_numeric($args['parent'])){
	return $this->return_error_with_delay('Error:  not a valid category parameter.', 0);
}
require_once(CLASSES_DIR.'site_class.php');
$site = Singleton::getInstance('geoSite');
//return_type = 3 makes this spit back just the options array (no dropdown html)
$categories = $site->get_category_dropdown('xml',$args['parent'],1,0,'',3);

/*
 * $categories = array(
 * 		'value' => category id#
 * 		'label' => category name
 * );
 */

foreach($categories as $key => $cat) {
	
	//figure out how many parents this category has
	//prepend a '-' to its name for each one
	$parents = '';
	$parentCheck = $cat['value'];
	do {
		$parentCheck = geoCategory::getParent($parentCheck);
		if($parentCheck != 0) {
			$parents .= '-';
		}
	} while($parentCheck != 0);
	
	//iphone can't handle &nbsp;s
	$name = $parents.trim(geoString::specialCharsDecode(str_replace("&nbsp;","",$cat['label'])));
	$categories[$key]['label'] = $name;
}
return $categories;