<?php
//get.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19862              $ ##
## File last change date:       ##
##  $Date:: 2010-06-25 10:00:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}

if (!isset($args['username']) && !isset($args['email'])){
	//username or email not specified?
	return $this->return_error_with_delay('Error:  No username or email specified.  Please provide either a username or an e-mail address to get user details.');
}

if (isset($args['username']) && strlen(trim($args['username'])) == 0){
	//string length 0
	return $this->return_error_with_delay('Invalid username.');
} elseif (isset($args['email']) && strlen(trim($args['email'])) == 0){
	return $this->return_error_with_delay('Invalid email.');
}

$field_name = (isset($args['username']))? 'username': 'email';

if (isset($args['password'])) {
	//validate password while we're at it...
	if (!$this->product_configuration->verify_credentials($args[$field_name], $args['password'])) {
		//invalid password
		return new IXR_Error(1001, "Invalid $field_name/pass.");
	}
}

$sql = 'SELECT id FROM `geodesic_userdata` WHERE `'.$field_name.'` = ? AND `id` != 1 LIMIT 1';
$row = $this->db->GetRow($sql, array(trim($args[$field_name])));

if (!$row || !$row['id']){
	//db error:
	return $this->return_error_with_delay('Could not find user.');
}
$user = geoUser::getUser($row['id']);
if (!$user) {
	return $this->return_error_with_delay('Could not find user.');
}
$data = $user->toArray();

if ($args['login_data']) {
	$sql = "SELECT * FROM ".geoTables::logins_table." WHERE `id`=?";
	$logins = $this->db->GetRow($sql, array($row['id']));
	if ($logins) {
		$data = array_merge ($data, $logins);
	}
}

return $data;
