<?php
//edit.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20651              $ ##
## File last change date:       ##
##  $Date:: 2010-12-08 12:39:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}
require_once(CLASSES_DIR.'register_class.php');

$generic_error = 'Registration failed.';


if (strlen(PHP5_DIR) > 0) {
	$register = Singleton::getInstance('Register');
} else {
	$register =& Singleton::getInstance('Register');
}

$register->language_id = $language_id;

//First, handle registration code, if set
if (isset($args['registration_code']) && strlen(trim($args['registration_code'])) > 0){
	$registration_code = $args['registration_code'];
	if (!$register->check_registration_code($registration_code, true)){
		//error returned.
		return new IXR_Error(1000, 'Registration code not valid.');
	}
	//returned true, registration code must be good
} else if (isset($args['force_user_group_id']) && (int)$args['force_user_group_id']) {
	$force_user_group_id = (int)$args['force_user_group_id'];
	//make sure it is valid
	$count = $this->db->GetOne("SELECT count(*) FROM ".geoTables::groups_table." WHERE `group_id`=?", array($force_user_group_id));
	if ($count == 1) {
		//valid group, use it
		$register->update_registration_group($force_user_group_id, true);
	} else {
		//not valid group, use default
		$register->set_default_group(true);
	}
} else {
	$register->set_default_group(true);
}

//TODO:  Validate filters, if specified.
// Filters not currently possible with API, may be added in future if there is a need

if (!isset($args['password_confirm'])){
	$args['password_confirm'] = $args['password'];
}
if (!isset($args['email_verifier'])){
	$args['email_verifier'] = $args['email'];
}
if(isset($args['zipcode']) && !empty($args['zipcode'] ))
{
	$args['zip'] = $args['zipcode'];
}

$register->check_info($args, true);

if ($register->error_found > 0){
	//errors when registering!
	$msgs = "Error when registering new user({$register->api_error}): ";
	if (isset($register->error['username']) && $register->error['username'] == 'error1'){
		return new IXR_Error(1000, $msgs.'Username not valid.  Check username string length, and that there are no illegal charecters in the username.');
	}
	if (isset($register->error['username']) && $register->error['username'] == 'error2'){
		return new IXR_Error(1001, $msgs.'Duplicate username.');
	}
	if ($register->error2['password'] || $register->error3['password']){
		return new IXR_Error(1002, 'Password not valid.');
	}
	
	if($register->api_error)
	{
		return new IXR_Error (1004, "Error registering new user.  Debug: <pre>".print_r($msgs,1)."</pre>");
	}
	//Not a common error.
	return new IXR_Error (1004, "Error registering new user.  Debug: {$msgs}<pre>".print_r($register,1)."</pre>");
}
//no errors found, so insert the new user!
$skip_addon = (isset($args['skip_addon_call']))? $args['skip_addon_call']: false;
$register->insert_user(1, $skip_addon);

if ($register->error) {
	$msg = (is_array($register->error))? implode(' ',$register->error) : $register->error;
	return new IXR_Error (1004, "Error registering new user.  Debug: {$msg}");
}

return 'Registration is awsome!';