<?php
//auction_bid_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21321              $ ##
## File last change date:       ##
##  $Date:: 2011-04-28 15:06:#$ ##
##                              ##
##################################

class Auction_bid extends geoSite {

	var $auction_id;
	var $classified_user_id;
	var $bid_error = 0;
	var $bid_success = 0;
	var $auction;
	var $bidder;
	var $dutch_bidders;
	var $winning_dutch_bidder = 0;
	var $dutch_bidder_quantity = 0;
	var $DEBUG_BID = 0;
	var $filename = "auction_bid_class.php";
	var $function_name;
	var $separator;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Auction_bid (&$db,$language_id,$classified_user_id,$auction_id,$product_configuration=0)
	{
		parent::__construct();
		$this->auction_id = $auction_id;
		$this->auction = $this->get_classified_data($this->auction_id);
		if ($this->DEBUG_BID) {
			trigger_error("DEBUG STATS: userid".$this->userid." auction id:".$this->auction_id);
		}

		$this->separator = "\n";
	} // end of function Auction_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_setup($db=0,$buy_now=0,$bid_amount=0,$aff_id=0)
	{
		$this->page_id = 10163;
		$this->get_text();
		
		$view = geoView::getInstance();
		$db = DataAccess::getInstance();
		
		$verification_check = $_REQUEST["e"];

		//show the form to bid on this auction
		if (!$this->userid || !$this->auction_id) {
			return false;
		}
		
		//get auction information
		$this->bidder = $this->get_user_data($this->userid);
		$this->auction = $this->get_classified_data($this->auction_id);

		// Find out if buy now auction only
		$buy_now_only = $this->auction->BUY_NOW_ONLY;

		if (($this->db->get_site_setting('black_list_of_buyers')) && ($this->db->get_site_setting('invited_list_of_buyers'))) {
			$invited = $this->check_invitedlist($this->db,$this->auction->SELLER,$this->userid);
			$banned = $this->check_blacklist($this->db,$this->auction->SELLER,$this->userid);
			if ($invited == 1) {
				$can_bid = 1;
			} else {
				if ($banned) {
					$can_bid = 0;
				} elseif ($invited == 2) {	
					$can_bid = 1;
				}
			}
		} elseif ($this->db->get_site_setting('black_list_of_buyers')) {
			//check black list only
			if ($this->check_blacklist($this->db,$this->auction->SELLER,$this->userid)) {
				$can_bid = 0;
			} else {
				$can_bid = 1;
			}
		} elseif ($this->db->get_site_setting('invited_list_of_buyers')) {
			//check invited only
			if ($this->check_invitedlist($this->db,$this->auction->SELLER,$this->userid)) {
				//this user is on the invited list
				$can_bid = 1;
			}
		} else {
			//no checks on who the bidder is, is needed, so they can probably bid.
			$can_bid = 1;
		}
		
		if($buy_now_only && !$buy_now) {
			// If not buying now and auction is buy now only dont allow to bid
			$can_bid = 0;
		}
		
		$bid_amount['bid_amount'] = geoNumber::deformat($bid_amount['bid_amount']);
		if (!$can_bid) {
			return false;
		}
		
		if($this->auction->START_STATS > geoUtil::time()) {
			$this->bid_error = 8;
			return false;
		}
		if ($this->auction->AUCTION_TYPE == 2) {
			// Dutch Auctions
			$sql = "select * from ".$this->bid_table." where auction_id=? order by bid desc,time_of_bid asc";
			$bid_result = $this->db->Execute($sql, array($this->auction->ID));
			if (!$bid_result) {
				return false;
			} elseif ($bid_result->RecordCount() > 0) {
				$total_quantity = $show_final_fee->QUANTITY;
				$final_dutch_bid = 0;
				$total_quantity_sold = 0;
				$show_bidder = $bid_result->FetchNextObject();
				if ($bid_result->RecordCount() > 0) {
					$total_quantity = $show_final_fee->QUANTITY;
					$final_dutch_bid = 0;
					$total_quantity_sold = 0;
					$show_bidder = $bid_result->FetchNextObject();
					do {
						$quantity_bidder_receiving = 0;
						if ( $show_bidder->QUANTITY <= $total_quantity ) {
							$quantity_bidder_receiving = $show_bidder->QUANTITY ;
							if ( $show_bidder->QUANTITY == $total_quantity ) {
								$final_dutch_bid = $show_bidder->BID;
							}
							$total_quantity = $total_quantity - $quantity_bidder_receiving;
						} else {
							$quantity_bidder_receiving = $total_quantity;
							$total_quantity = 0;
							$final_dutch_bid = $show_bidder->BID;
						}
						if ($quantity_bidder_receiving) {
							$dutch_bidder_bid = $show_bidder->BID;
						}
						$total_quantity_sold = $total_quantity_sold + $quantity_bidder_receiving;
					} while (($show_bidder = $bid_result->FetchNextObject()) && ($total_quantity != 0) && ($final_dutch_bid == 0));
					if ($final_dutch_bid == 0) {
						$bid_to_show = $dutch_bidder_bid;
					} else {
						$bid_to_show = $final_dutch_bid;
					}
				} else {
					$bid_to_show = $this->get_minimum_bid($db);
				}
			} elseif ($bid_amount != 0) {
				$bid_to_show = $bid_amount;
			} else {
				$bid_to_show = $this->get_minimum_bid($db);
			}
		}

		if (!$this->auction || !$this->bidder || !$this->auction->LIVE == 1) {
			return false;
		}
		
		if ($this->auction->SELLER == $this->bidder->ID) {
			$this->bid_error = 4;
			return false;
		}
		
		$view->verify = ($verification_check == "verify") ? true : false;
		$verify = ($verification_check == "verify") ? 'verified' : 'verify';
		$aff = ($aff_id) ? '&amp;aff='.$aff_id : '';
		$view->formTarget = $this->db->get_site_setting('classifieds_file_name')."?a=1029&b=".$this->auction_id."&e=".$verify.$aff;
		$view->title = geoString::fromDB($this->auction->TITLE);
		
		if (($buy_now) && ($this->auction->BUY_NOW)) {
			$view->auction_type = 'buy_now';
			$price = $this->auction->BUY_NOW;
		} elseif ($this->auction->AUCTION_TYPE == 2) {
			$view->auction_type = 'dutch';
			$price = $bid_amount['bid_amount'];
			$view->quantity = $bid_amount['bid_quantity'];
			$view->bid_to_show = geoNumber::format($bid_to_show);
		} else {
			$view->auction_type = 'standard';
			$price = $bid_amount['bid_amount'];
			$view->bid_to_show = geoNumber::format($this->get_minimum_bid($db));
		}
		$view->hidden_price = geoNumber::format($price);
		$view->price = $this->show_money($price,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY,1);
		
		$view->auctionLink = $db->get_site_setting('classifieds_file_name')."?a=2&amp;b=".$this->auction_id;
		
		$view->precurrency = geoString::fromDB($this->auction->PRECURRENCY);
		$view->postcurrency = geoString::fromDB($this->auction->POSTCURRENCY);
		
		$view->setBodyTpl('bidding/bid_setup.tpl','','auctions');
		
		$this->display_page();
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_error($db=0,$aff_id=0)
	{
		$this->page_id = 10164;
		$this->get_text();
		
		$view = geoView::getInstance();
		$db = DataAccess::getInstance();

		//not enough information to bid
		switch ($this->bid_error) {
			case 1: //current bidder is the high bidder
				$error = $this->messages[102458];
				break;
			case 2: //raise bid
				$error = $this->messages[102459];
				break;
			case 3: //unrecognizable data for bid amount
				$error = $this->messages[102460];
				break;
			case 4: //seller cannot make a bid on their own auction
				$error = $this->messages[102462];
				break;
			case 5: //dutch bid quantity error
				$error = $this->messages[102463];
				break;
			case 6: //raise dutch bid amount...you are not in the money
				$error = $this->messages[102464];
				break;
			case 7: //you cannont lower your dutch bid amount or dutch bid quantity
				$error = $this->messages[102465];
				break;
			case 8: //cannot bid before start time
				$error = $this->messages[102817];
				break;
			default: //internal bidding error
				$error = $this->messages[102461];
				break;
		}
		$view->bid_error = $error;
		$view->categoryLink = $db->get_site_setting('classifieds_file_name')."?a=5&b=".$this->auction->CATEGORY;
		$view->auctionLink = $db->get_site_setting('classifieds_file_name')."?a=2&b=".$this->auction_id;

		$view->setBodyTpl('bidding/bid_error.tpl','','auctions');
		$this->display_page();
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_successful($db=0,$aff_id=0)
	{
		$this->page_id = 10165;
		$this->get_text();

		$view = geoView::getInstance();
		$db = DataAccess::getInstance();

		//refresh auction data
		$this->auction = $this->get_classified_data($this->auction_id);
		$view->title = geoString::fromDB($this->auction->TITLE);		

		if ($this->auction->AUCTION_TYPE == 2) {
			$view->is_dutch = true;
			//first check to see if the bid could possibly win
			//dutch auction
			$sql = "select * from ".geoTables::bid_table." where auction_id = ? and bidder = ? order by time_of_bid desc limit 1";
			$dutch_bid_result = $db->Execute($sql, array($this->auction_id, $this->userid));
			
			if (!$dutch_bid_result || $dutch_bid_result->RecordCount() != 1) {
				$this->error_message = urldecode($this->messages[81]);
				return false;
			} elseif ($dutch_bid_result->RecordCount() == 1) {
				$show_dutch_bid = $dutch_bid_result->FetchNextObject();
			}
			$view->quantity = $show_dutch_bid->QUANTITY;
			$view->price = $this->show_money($show_dutch_bid->BID,$this->db->get_site_setting('precurrency'),$this->db->get_site_setting('postcurrency'));
		} else {
			switch ($this->bid_success) {
				case 1: //you are current high bidder,  your high bid is saved
					$text = $this->messages[102448];
					break;
				case 3: //bid received but you have been outbid
					$text = $this->messages[102449];
					break;
				case 4: //buy now bid accepted
					$text = $this->messages[102456];
					//on-site payment text
					if (geoPC::is_ent()) {
						//seller/buyer
						$vars = array (
							'listing_id' => $this->auction_id,
							'winning_bidder_id' => $this->userid,
							'listing_details' => $this->auction,
							'final_price' => $this->auction->BUY_NOW
						);
						$text .= geoSellerBuyer::callDisplay('displayPaymentLinkBuyNowSuccess', $vars);
					}
				default: //internal bidding error
			}
			$view->successText = $text;
			
			if ($this->bid_success != 4) {
			   $money_source = $this->auction->CURRENT_BID;
			} else {
				$money_source = $this->auction->BUY_NOW;
			}
			$view->price = $this->show_money($money_source,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		}
		if ($this->bid_success == 3) {
			//click here to rebid
			$view->rebidLink = $this->db->get_site_setting('classifieds_file_name')."?a=1029&b=".$this->auction_id;
		}
		$view->categoryLink = $db->get_site_setting('classifieds_file_name')."?a=5&b=".$this->auction->CATEGORY;
		$view->auctionLink = $db->get_site_setting('classifieds_file_name')."?a=2&b=".$this->auction_id;
		
		$this->insert_favorite($this->db, $this->auction_id);

		$view->setBodyTpl('bidding/bid_successful.tpl','','auctions');
		$this->display_page($db);
	} // end of function bid_successful

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function process_bid($db,$bid_info=0,$aff_id=0)
	{
		$function_name = "process_bid";

		if($this->DEBUG_BID)
		{
			//$this->userid
			trigger_error("TOP OF PROCESS BID
			{$bid_info[bid_amount]} is bid amount at top<br/>
			 $this->auction_id is the auction id <br/>
			 $this->auction->SELLER is the seller<br/>
			 ".$this->userid." is the bidder <br/>
			 {$this->db->get_site_setting('number_format')} is NUMBER_FORMAT<br/>\n
			"
			);
			 
		}

		$bid_info['bid_quantity'] = trim($bid_info['bid_quantity']);
		$bid_info['bid_amount'] = trim($bid_info['bid_amount']);

		$bid_amount = geoNumber::deformat($bid_info['bid_amount']);

		if (!ereg("^[0-9]{1,10}.?[0-9]{0,2}$", $bid_amount))
		{
			$this->bid_error = 3;
			if ($this->DEBUG_BID)
				echo $this->bid_error." 3 - is error<br/>\n";
			return false;
		}

		if ($this->DEBUG_BID)
		{
			echo $bid_amount." is bid amount after formatting change<br/>\n";
		}

		settype($bid_amount, "float");

		if ($this->DEBUG_BID)
		{
			echo $bid_amount." is bid amount after formatting change2<br/>\n";
		}

		$this->auction = $this->get_classified_data($this->auction_id);

		$seller = $this->get_user_data($this->auction->SELLER);
		$this->bidder = $this->get_user_data($this->userid);

		
		trigger_error("
		{$bid_amount} is \$bid_amount at top<br/>\n
		{$this->auction_id} is the auction id<br/>
		{$this->auction->SELLER} is the auction->SELLER<br/>
		".$this->userid." is the bidder(classified_user_id)<br/>
		{$this->db->get_site_setting('number_format')} is NUMBER_FORMAT<br/>\n
		");
		

		if (($bid_amount) && ($this->auction) && ($this->bidder) && ($seller) && ($this->auction->LIVE == 1)
		&& (($this->auction->ENDS > geoUtil::time()) || ($this->auction->DELAYED_START == 1)))
		{
			if ($seller->ID == $this->bidder->ID)
			{
				$this->bid_error = 4;
				if ($this->db->get_site_setting('debug_bid'))
					echo $this->bid_error." 4 - is error<br/>\n";
				return false;
			}
			$quantity = 1;
			if($this->DEBUG_BID) echo "quantity is set to 1<BR>\n";
			if ($this->auction->AUCTION_TYPE == 2)
			{
				if ($this->DEBUG_BID)
				{
					echo "<br/>THIS IS A DUTCH AUCTION<br/>\n";
				}
				//dutch auction
				//no autobidding on dutch auctions
				//no reserve price ?
				//save the quantity and the bid amount
				//all the hard work is at the close of a dutch auction
				$bid_info['bid_quantity'] = trim($bid_info['bid_quantity']);

				//$bid_quantity = $this->show_money($bid_info[bid_quantity],0,0,1);
				$bid_quantity = $bid_info['bid_quantity'];

				if (!ereg("^[0-9]{1,10}$", $bid_quantity))
				{
					$this->bid_error = 5;
					if ($this->db->get_site_setting('debug_bid'))
						echo $this->bid_error." 5 - is error<br/>\n";
					return false;
				}

				if ($bid_quantity > $this->auction->QUANTITY)
					$bid_quantity = $this->auction->QUANTITY;
				//check to see if above the minimum bid
				if ($bid_amount < $this->auction->STARTING_BID)
				{
					$this->bid_error = 2;
					if ($this->db->get_site_setting('debug_bid'))
						echo $this->bid_error." 2 - is error<br/>\n";
					return false;
				}

				if ($this->DEBUG_BID)
				{
					echo $bid_amount." is the amount of the bid entered for this dutch auction<br/>\n";
					echo $bid_quantity." is the quantity entered for this dutch auction<br/>\n";
				}

				$sql = "select * from ".$this->bid_table." where auction_id = ? and bidder = ?";
				$get_bid_result = $this->db->Execute($sql, array($this->auction_id, $this->bidder->ID));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "get data from bid table by auction and bidder id");
				}
				if (!$get_bid_result)
				{
					//No record was found
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				elseif ($get_bid_result->RecordCount() == 1)
				{
					//update the bid
					$show_current_dutch_bid = $get_bid_result->FetchNextObject();
					if (($show_current_dutch_bid->BID < $bid_amount) && ($show_current_dutch_bid->QUANTITY <= $bid_quantity ))
					{
						//Bid amount and quantity are greater
						$sql = "update ".$this->bid_table." set bid = ?, time_of_bid = ?, quantity = ? where auction_id = ? and bidder = ?";
						$query_data = array($bid_amount, geoUtil::time(), $bid_quantity, $this->auction_id, $this->bidder->ID);
						$insert_bid_result = $this->db->Execute($sql, $query_data);
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						if($this->db->get_site_setting('debug_bid'))
						{
							$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "update data in bid table with auction and bidder id");
						}
						if (!$insert_bid_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
					}
					else
					{
						//cannot lower your bid amount or quantity
						$this->bid_error = 7;
						if ($this->db->get_site_setting('debug_bid'))
							echo $this->bid_error." 7 - is error<br/>\n";
						return false;
					}
				}
				elseif ($get_bid_result->RecordCount() == 0)
				{

					//insert the bid
					$insert_bid_result = $this->insert_into_bid_table($bid_amount,geoUtil::time(),$bid_quantity);
					if (!$insert_bid_result)
					{
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						return false;
					}
				}
				else
				{
					return false;
				}

				if ($this->DEBUG_BID)
				{
					echo "checking to reset the current bid<br/>\n";
					echo $this->auction->CURRENT_BID." is current bid<br/>\n";
					echo $this->auction->RESERVE_PRICE."  is reserve<br/>\n";
					echo $bid_amount." is the bid_amount<br/>\n";
					if (($this->auction->CURRENT_BID < $this->auction->RESERVE_PRICE) && ($bid_amount >= $this->auction->RESERVE_PRICE))
						echo "the current bid is below the auction reserve and the bid is above the reserve so the current bid should be reset<br/>\n";
				}

				//check to see if this dutch bid is in the money
				$sql = "select * from ".$this->bid_table." where auction_id=? order by bid desc,time_of_bid asc";
				$bid_result = $this->db->Execute($sql, array($this->auction_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "get data from bid table by auction");
				}
				if (!$bid_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				elseif ($bid_result->RecordCount() > 0)
				{

					$total_quantity = $this->auction->QUANTITY;
					$final_dutch_bid = 0;
					$bid_count = 0;
					$show_bidder = $bid_result->FetchNextObject();
					do
					{
						$quantity_bidder_receiving = 0;
						if ( $show_bidder->QUANTITY <= $total_quantity )
						{
							//Show bidder quantity is less than total quantity
							$quantity_bidder_receiving = $show_bidder->QUANTITY ;
							if ( $show_bidder->QUANTITY == $total_quantity )
							{
								$final_dutch_bid = $show_bidder->BID;
							}
							$total_quantity = $total_quantity - $quantity_bidder_receiving;
						}
						else
						{
							//Show bidder quantity is not less than total quantity
							$quantity_bidder_receiving = $total_quantity;
							$total_quantity = 0;
							$final_dutch_bid = $show_bidder->BID;
						}
						if ($quantity_bidder_receiving)
						{
							//save this bidder as an in the money bidder
							//send an email
							$this->dutch_bidders[$bid_count]["bidder"] = $show_bidder->BIDDER;
							$this->dutch_bidders[$bid_count]["quantity"] = $quantity_bidder_receiving;
							$this->dutch_bidders[$bid_count]["bid"] =  $show_bidder->BID;
							if ($this->DEBUG_BID){ echo 'setting bidder info ['.$bid_count.']:<pre>';var_dump($this->dutch_bidders[$bid_count]);echo '</pre>';}
							//$bid_count++;
							if ($show_bidder->BIDDER == $this->bidder->ID)
							{
								//this bidder is in the money
								$this->winning_dutch_bidder = 1;
								$this->dutch_bidder_quantity = $quantity_bidder_receiving;
								$this->winning_dutch_bidder_count = $bid_count;
							}
							$bid_count++;
						}
					} while (($show_bidder = $bid_result->FetchNextObject()) && ($total_quantity != 0));
					if ($final_dutch_bid == 0)
						$final_dutch_bid = $this->dutch_bidders[$bid_count-1]["bid"];
					if (($bid_result->RecordCount() > $bid_count) && ($this->winning_dutch_bidder))
					{
						$this->email_dutch_bidders_new_bid($db, $bid_count, $aff_id);

					}

					if ($this->winning_dutch_bidder == 1)
					{
						//update auction info
						$this->page_id = 10168;
						$this->get_text();
						
						if ($total_quantity == 0)
						{
							//all dutch items are bid on...set current/minimum bid to the final dutch bid
							//value as the minimum bid to win an item
							$bid_result = $this->update_minimum_current_and_price($final_dutch_bid,$final_dutch_bid,$final_dutch_bid);
							if (!$bid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}							
						}
						else
						{
							//all dutch items have not been bid on...leave the current/minimum alone
						}
						$this->auction_extension_check(geoUtil::time());
						$this->email_dutch_bidder_successful_bid($db, $bid_amount, $aff_id);
						$this->start_delayed_auction();
						return true;
					}
					else
					{
						$this->email_dutch_bidder_not_successful_bid($db,$bid_amount,$aff_id);
						$this->start_delayed_auction();
						return false;
					}
				}
				else
				{
					$this->auction_extension_check(geoUtil::time());
					$this->email_only_dutch_bidder($db,$bid_amount,$aff_id,$bid_quantity);
					$this->start_delayed_auction();
					return true;
				}
			}
			else
			{
				//regular auction
				//EXTENDED STATS ON BIDS?
				$current_time = geoUtil::time();
				if (isset($bid_info["buy_now_bid"]) && $bid_info["buy_now_bid"])
				{
					$this->page_id = 10167;
					$this->get_text();
					//this user is closing the auction by choosing the buy now option
					$sql = "update ".$this->classifieds_table."
						set live = 0,
						delayed_start = 0,
						current_bid = ?,
						price = ?,
						minimum_bid = ?,
						final_price = ?,
						ends = ?
						where id = ?";
					$query_data = array($this->auction->BUY_NOW, $this->auction->BUY_NOW,$this->auction->BUY_NOW, $this->auction->BUY_NOW, geoUtil::time(), $this->auction_id );
					$this->auction->FINAL_PRICE = $this->auction->BUY_NOW;
					$update_result = $this->db->Execute($sql, $query_data);
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					if($this->db->get_site_setting('debug_bid'))
					{
						$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auctions table by auction id");
					}
					if (!$update_result)
					{
						$this->error_message = urldecode($this->messages[81]);
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						return false;
					}
					//insert buy now bid
					$insert_bid_result = $this->insert_into_bid_table($this->auction->BUY_NOW,$current_time,$this->auction->QUANTITY,1);
					if (!$insert_bid_result)
					{
						//put things back
						$reset_current_price_result = $this->set_current_and_price_to_zero();
						return false;
					}

					$sql = "insert into ".$this->auctions_feedbacks_table."
						(rated_user_id,rater_user_id,date,auction_id)
						values (?, ?, ?, ?)";
					$query_data = array	($this->auction->SELLER,$this->bidder->ID,geoUtil::time(),$this->auction_id);
					$insert_feedback_result = $this->db->Execute($sql, $query_data);
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					if($this->db->get_site_setting('debug_bid'))
					{
						$this->debug_display($sql, $db, $this->filename, $function_name, "auctions_feedbacks_table", "insert data into feedback table by auction, bidder, and seller id");
					}
					if (!$insert_feedback_result)
					{
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						$this->error_message = urldecode($this->messages[81]);
						return false;
					}

					$sql = "insert into ".$this->auctions_feedbacks_table."
						(rated_user_id,rater_user_id,date,auction_id)
						values (?, ?, ?, ?)";
					$query_data = array	($this->bidder->ID,$this->auction->SELLER,geoUtil::time(),$this->auction_id);
					$insert_feedback_result = $this->db->Execute($sql, $query_data);
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					if($this->db->get_site_setting('debug_bid'))
					{
						$this->debug_display($sql, $db, $this->filename, $function_name, "auctions_feedbacks_table", "insert data into feedback table by auction, bidder, and seller id");
					}
					if (!$insert_feedback_result)
					{
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						$this->error_message = urldecode($this->messages[81]);
						return false;
					}
					$vars = array (
						'listing' => geoListing::getListing($this->auction_id)
					);
					geoOrderItem::callUpdate('buy_now_close',$vars);
					
					//send emails to seller and buy now bidder
				    //to buy now bidder
				    $this->email_buy_now_bidder_and_seller($aff_id,$seller);

					$this->update_category_count($db,$this->auction->CATEGORY);
					$this->bid_success = 4;
					$this->auction_extension_check(geoUtil::time());
					return true;
				}

				//get minimum bid
				$minimum_bid = $this->get_minimum_bid($db);
				if (!$minimum_bid)
				{
					return false;
				}
				if ($bid_amount >= $minimum_bid)
				{
					//check to make sure the current bidder is not winning already
					$auction_ends = date($this->db->get_site_setting('entry_date_configuration'),$this->auction->ENDS);

					//get the information on the current high bid
					$sql = "select * from ".$this->bid_table." where auction_id=? order by bid desc,time_of_bid asc limit 1";
					$high_bid_result = $this->db->Execute($sql, array($this->auction_id));
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					if($this->db->get_site_setting('debug_bid'))
					{
						$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "get data from bid table by auction id");
					}
					if (!$high_bid_result)
					{
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						return false;
					}
					elseif ($high_bid_result->RecordCount() == 1)
					{
						//there is a current high bid
						$show_high_bidder = $high_bid_result->FetchNextObject();
						if ($show_high_bidder->BIDDER == $this->bidder->ID)
						{
							//check to see if the current high bidder can update their bid
							$allow_bidding_against_self = $this->db->get_site_setting('allow_bidding_against_self');
				
							if ($allow_bidding_against_self)
							{
								//this will allow the client to add to their bid...
								//add a proxy bid if they do not have one or...
								//add to their current proxy bid if they have on on this auction
								
								//check to see if there is a current proxy bid
								$sql = "select * from ".$this->autobid_table." where auction_id = ?";
								$get_autobid_result = $this->db->Execute($sql, array($this->auction_id));
								if ($this->DEBUG_BID) 
								{
									echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									echo $this->auction_id." is auction_id<bR>\n";
								};
		
						  		if (!$get_autobid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								elseif ($get_autobid_result->RecordCount() == 0)
								{			
									//there is no current proxy bid
									//enter this bid as the current proxy bid for this bidder	
									//need to check against the reserve price	
									if ($this->auction->RESERVE_PRICE != 0)	
									{
										//there is a reserve...check that it has been met
										if ($minimum_bid > $this->auction->RESERVE_PRICE)
										{
											//the reserve has been met...insert this bid
											//as the proxy for this bidder on this auction
											//no need to update the auction as none of that will change
											//only the proxy will be added

											$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
											if (!$insert_autobid_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
												return false;
											}
											$this->auction_extension_check(geoUtil::time());
											$this->send_current_high_bidder_email($db,$this->bidder->ID);
											$this->bid_success = 1;
											$this->start_delayed_auction();
											return true;
										}
										else
										{
											//the reserve has not been met
											//check that the bid_amount beats the reserve or not
											if ($bid_amount > $this->auction->RESERVE_PRICE)
											{
												//enter the current bid to the reserve prise
												//enter any amount above the reserve price as the proxy bid for this bidder
												$set_minimum_result = $this->update_minimum_current_and_price(($this->auction->RESERVE_PRICE+ $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
												if (!$set_minimum_result)
												{
													if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
													return false;
												}
												else
												{
													$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
													if (!$insert_bid_result)
													{
														//put things back
														$reset_current_price_result = $this->set_current_and_price_to_zero();
														return false;
													}
													else
													{
														$a_bid = $this->auction->RESERVE_PRICE;
														//insert bid into the autobid table because it was greater then minimum_bid
														//minimum_bid is the current minimum because there were no previous bids
														$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
														if (!$insert_autobid_result)
														{
															if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
															return false;
														}
														$this->auction_extension_check(geoUtil::time());
														$this->send_current_high_bidder_email($db,$this->bidder->ID);
														$this->bid_success = 1;
														$this->start_delayed_auction();
														return true;
													}
												}												
											}
											else
											{
												//$bid_amount <= $this->auction->RESERVE_PRICE
												//enter the bid_amount as the current bid only
												$set_minimum_result = $this->update_minimum_current_and_price(($bid_amount+ $increment),$bid_amount,$bid_amount);
												if (!$set_minimum_result)
												{
													if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
													return false;
												}
												else
												{
													$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
													if (!$insert_bid_result)
													{
														//put things back
														$reset_current_price_result = $this->set_current_and_price_to_zero();
														return false;
													}
												}				
												$this->auction_extension_check(geoUtil::time());
												$this->send_current_high_bidder_email($db,$this->bidder->ID);
												$this->bid_success = 1;
												$this->start_delayed_auction();
												return true;
											}
										}
									}
									else
									{
										//there is no current proxy and 
										//there is no reserve so insert the bid_amount
										//as a proxy bid for this bidder on this auction
										$a_bid = $bid_amount;
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
										$this->auction_extension_check(geoUtil::time());
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->bid_success = 1;
										$this->start_delayed_auction();
										return true;
									}
								}
								elseif ($get_autobid_result->RecordCount() == 1)
								{
									//this bidder has a current proxy bid
									//check to see current proxy bid is higher than amount just bid or not
									$show_autobid = $get_autobid_result->FetchNextObject();
									if ($bid_amount > $show_autobid->MAXBID)
									{
										//update the current proxy bid with the current bid
										$a_bid = $bid_amount;
										$sql = "update ".$this->autobid_table." set
											time_of_bid = ? ,
											quantity = ?,
											maxbid = ?
											where auction_id = ? and
											bidder = ?";
										$query_data = array	($current_time, $quantity, $bid_amount, $this->auction_id, $this->bidder->ID);
										$insert_autobid_result = $this->db->Execute($sql, $query_data);
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										if($this->db->get_site_setting('debug_bid'))
										{
											$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into auctions table");
										}
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
										$this->auction_extension_check(geoUtil::time());
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->bid_success = 1;
										$this->start_delayed_auction();
										return true;										
									}
									else
									{
										//the bid_amount was equal to or lesser than the current proxy bid
										//so do nothing
										$this->auction_extension_check(geoUtil::time());
										return true;
									}
								}
								else
								{
									//there is more than one proxy bid...big error
									$this->bid_error = 1;
									if ($this->DEBUG_BID)
										echo $this->bid_error." 1 - is error because more than one proxy bid in database for this auction<br/>\n";
									return false;									
										
								}
							}
							else
							{
								$this->bid_error = 1;
								if ($this->DEBUG_BID)
									echo $this->bid_error." 1 - is error - not allowed to edit own bid<br/>\n";
								return false;
							}
						}
						else
						{
							//there is nothing to do here.  there is a bid on this auction but the 
							//current high bidder does NOT match the current bidder
						}
					}
					else
					{
						//there is no current high bid
					}

					$less_than_reserve_straight_bid = $this->db->get_site_setting('less_than_reserve_straight_bid');

					if ($this->auction->CURRENT_BID == 0)
					{
						//got here because there are no bids yet on this item
						//set current bid as the minimum bid in auction table

						if (($this->auction->RESERVE_PRICE > 0) && ($bid_amount >= $this->auction->RESERVE_PRICE))
						{
							//no current bid...this is first bid
							//there is a reserve and the bid amount is above or equal to the reserve
							//insert current bid as reserve price
							//insert amount above reserve price as proxy
							//get the minimum bid
							//get increment first
							$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);

							$set_minimum_result = $this->update_minimum_current_and_price(($this->auction->RESERVE_PRICE+ $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
							if (!$set_minimum_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							else
							{
								$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									//put things back
									$reset_current_price_result = $this->set_current_and_price_to_zero();
									return false;
								}
								else
								{
									$a_bid = $this->auction->RESERVE_PRICE;
									if ($bid_amount > $this->auction->RESERVE_PRICE)
									{
										//insert bid into the autobid table because it was greater then minimum_bid
										//minimum_bid is the current minimum because there were no previous bids
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
									}
									$this->auction_extension_check(geoUtil::time());
									$this->send_current_high_bidder_email($db,$this->bidder->ID);
									$this->bid_success = 1;
									$this->start_delayed_auction();
									return true;
								}
							}
						}
						elseif (($this->auction->RESERVE_PRICE > 0) && ($bid_amount < $this->auction->RESERVE_PRICE) && $less_than_reserve_straight_bid)
						{
							//no current bid...this is first bid
							//there is a reserve
							//amount bid is less than reserve
							//amount bid is greater than minimum bid
							//and the admin wants this bid entered directly as a full bid...no proxy bid
							$increment = $this->get_increment($db,$bid_amount);
							$set_minimum_result = $this->update_minimum_current_and_price(($bid_amount + $increment),$bid_amount,$bid_amount);
							if (!$set_minimum_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							else
							{
								$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									//put things back
									$reset_current_price_result = $this->set_current_and_price_to_zero();
									return false;
								}
								$this->auction_extension_check(geoUtil::time());
								$this->send_current_high_bidder_email($db,$this->bidder->ID);
								$this->bid_success = 1;
								$this->start_delayed_auction();
								return true;
							}							
						}
						else
						{
							//no current bid...this is first bid
							//set current bid to starting bid
							//set minimum bid to starting bid plus increment
							//get the minimum bid
							//get increment first
							$increment = $this->get_increment($db,$this->auction->STARTING_BID);

							$set_minimum_result = $this->update_minimum_current_and_price(($this->auction->STARTING_BID + $increment),$this->auction->STARTING_BID,$this->auction->STARTING_BID);
							if (!$set_minimum_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							else
							{
								$insert_bid_result = $this->insert_into_bid_table($this->auction->STARTING_BID,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									//put things back
									$reset_current_price_result = $this->set_current_and_price_to_zero();
									return false;
								}
								else
								{
									$a_bid = $minimum_bid;
									if ($bid_amount > $minimum_bid)
									{
										//insert bid into the autobid table because it was greater then minimum_bid
										//minimum_bid is the current minimum because there were no previous bids
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
									}
									$this->auction_extension_check(geoUtil::time());
									$this->send_current_high_bidder_email($db,$this->bidder->ID);
									$this->bid_success = 1;
									$this->start_delayed_auction();
									return true;
								}
							}
						}
		  			} // end of if ($this->auction->CURRENT_BID == 0)
		  			else
		  			{
		  				//got here because this auction already has a bid on it
		  				//this bid is above the minimum bid so at least some bid activity will take place.
						//check to see if there is a current autobid
						
						$sql = "select * from ".$this->autobid_table." where auction_id = ?";
						$get_autobid_result = $this->db->Execute($sql, array($this->auction_id));
						if ($this->DEBUG_BID) 
						{
							echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							echo $this->auction_id." is auction_id<bR>\n";
						};

				  		if (!$get_autobid_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
						elseif ($get_autobid_result->RecordCount() == 0)
						{
							//there is no proxy bid for this auction
							//this bid is above the minimum
							//this bid is the highest bid so far

							//check to see if reserve is above current minimum bid
							if (($bid_amount >= $this->auction->RESERVE_PRICE) && ($this->auction->RESERVE_PRICE !=0 )
								&& ($minimum_bid <= $this->auction->RESERVE_PRICE))
							{
								//a reserve exists
								//the bid amount is above the reserve but the current minimum bid was below the reserve price.
								//the reserve price becomes the new current bid
								//the new minimum bid for this auction is the reserve plus the increment
								$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);
								$set_minimum_result = $this->update_minimum_current_and_price(($this->auction->RESERVE_PRICE+ $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
								if (!$set_minimum_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{
									$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										//put things back
										$set_minimum_result = $this->update_minimum_current_and_price($this->auction->MINIMUM_BID,$this->auction->CURRENT_BID,$this->auction->CURRENT_BID);
										return false;
									}
									else
									{
										if ($bid_amount > $this->auction->RESERVE_PRICE)
										{
											//insert bid into the autobid table because it was greater then minimum_bid
											//minimum_bid is the current minimum because there were no previous bids
											$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
											if (!$insert_autobid_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
												return false;
											}
										}
										$this->auction_extension_check(geoUtil::time());
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->send_outbid_email($db,$show_high_bidder->BIDDER);
										$this->bid_success = 1;
										return true;
									}
								}
							}
							elseif (($bid_amount < $this->auction->RESERVE_PRICE) && ($this->auction->RESERVE_PRICE !=0 ))	
							{
								//there is no proxy bid for this auction
								//bid amount is less than reserve
								//the reserve exists
								//the minimum is less that the reserve
								//the bid amount is at least the minimum bid
								
								if ($less_than_reserve_straight_bid)
		  						{
		  							//this bid will be entered directly as a bid...no proxy
		  							$increment = $this->get_increment($db,$bid_amount);
		  							$update_current_bid_result = $this->update_minimum_current_and_price(($bid_amount + $increment),$bid_amount,$bid_amount);
									if (!$update_current_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									else
									{
										if (isset($quantity)){
											$quantity_to_use = $quantity;
										} elseif (isset($quantity_bidder_receiving)){
											$quantity_to_use = $quantity_bidder_receiving;
										} else {
											//what do we use as quantity?
											trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
											$quantity_to_use = 1;
										}										
										$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity_to_use);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}		
									}  							
		  						}
		  						else
		  						{
		  							$increment = $this->get_increment($db,$minimum_bid);
		  							//this bid is equal to the minimum bid
		  							$update_current_bid_result = $this->update_minimum_current_and_price(($minimum_bid + $increment),$minimum_bid,$minimum_bid);
									if (!$update_current_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									else
									{		  							
			  							if ($bid_amount > $minimum_bid)
			  							{
			  								//if this bid greater than minimum...enter the minimum bid and the proxy	
			  								//enter the proxy
											//got here because no bid in the autobid and bid is large enough to insert into the autobid table
											$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
											if (!$insert_autobid_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$query_data[0]." - ".$query_data[1]." - ".$query_data[2]." - ".$query_data[3]." - ".$query_data[4]." - "."<br/>\n";
												return false;
											}
			  							}
			  							else
			  							{
			  								//just enter the bid (above)...there is no proxy to enter
			  							}
									}
		  							//enter the bid
									if (isset($quantity)){
										$quantity_to_use = $quantity;
									} elseif (isset($quantity_bidder_receiving)){
										$quantity_to_use = $quantity_bidder_receiving;
									} else {
										//what do we use as quantity?
										trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
										$quantity_to_use = 1;
									}
									$insert_bid_result = $this->insert_into_bid_table($minimum_bid,$current_time,$quantity_to_use);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}		  							
		  						}
								$this->auction_extension_check(geoUtil::time());
		  						$this->bid_success = 1;
								$this->send_current_high_bidder_email($db,$this->bidder->ID);
								$this->send_outbid_email($db,$show_high_bidder->BIDDER);
								return true;		  						
												
							}
							else
							{
								//there is no proxy bid for this auction
								//the reserve has already been met or is 0
								//the current bid becomes the minimum bid
								//the minimum bid becomes the current minimum bid plus increment
								$increment = $this->get_increment($db,$minimum_bid);
								$update_current_bid_result = $this->update_minimum_current_and_price(($minimum_bid + $increment),$minimum_bid,$minimum_bid);
								if (!$update_current_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{
									if (isset($quantity)){
										$quantity_to_use = $quantity;
									} elseif (isset($quantity_bidder_receiving)){
										$quantity_to_use = $quantity_bidder_receiving;
									} else {
										//what do we use as quantity?
										trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
										$quantity_to_use = 1;
									}
									$insert_bid_result = $this->insert_into_bid_table($minimum_bid,$current_time,$quantity_to_use);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									else
									{
										if ($bid_amount > $minimum_bid)
										{
											//got here because no bid in the autobid and bid is large enough to insert into the autobid table
											$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity_to_use);
											if (!$insert_autobid_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$query_data[0]." - ".$query_data[1]." - ".$query_data[2]." - ".$query_data[3]." - ".$query_data[4]." - "."<br/>\n";
												return false;
											}
										}
										$this->auction_extension_check(geoUtil::time());
										$this->bid_success = 1;
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->send_outbid_email($db,$show_high_bidder->BIDDER);
										return true;
									}
								}
							}
						}
	  					else
	  					{
							//there is proxy bid for this auction
							//there already is a price in the autobid table higher than the current price
							//pull the price from the autobid table and test it against this bid

							$show_autobid = $get_autobid_result->FetchNextObject();

							//get increment for the maxbid range
							$increment = $this->get_increment($db,$show_autobid->MAXBID);
	          				$maxbid_increment = $show_autobid->MAXBID + $increment;
							if ($bid_amount > $show_autobid->MAXBID)
							{
								//current bid is greater than maxbid of other user
								//we have a new high bid
								if (($show_autobid->MAXBID >= $this->auction->RESERVE_PRICE) ||
									($this->auction->RESERVE_PRICE == 0) ||
									($bid_amount < $this->auction->RESERVE_PRICE) )
								{
									//Max bid set is equal to the reserve price or bid amount is less than reserve price
									//current bid is less than the reserve but greater than proxy bid
									if ($bid_amount > $maxbid_increment)
									{
										$increment = $this->get_increment($db,$maxbid_increment);
										//Maxbid_increment becomes the new current bid for this bidder
										//enter maxbid_increment into bid table as the current bid of the current bidder
										//update autobid enter bid as the maxbid for this table
										//update auctions table set maxbid_increment as the current bid
										$update_result = $this->update_minimum_current_and_price(($increment + $maxbid_increment),$maxbid_increment,$maxbid_increment);
										if (!$update_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($maxbid_increment,$current_time,$quantity);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$sql = "update ".$this->autobid_table."  set
											maxbid = ?,
											bidder = ?
											where auction_id = ?";
										$update_autobid_result = $this->db->Execute($sql, array($bid_amount, $this->bidder->ID, $this->auction_id));
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										if($this->db->get_site_setting('debug_bid'))
										{
											$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "update max bid and bidder in auctions table by auction id");
										}
										if (!$update_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$a_bid = $maxbid_increment;
										//bidder is current high bidder
										$this->bid_success = 1;
										$this->auction_extension_check(geoUtil::time());
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->send_outbid_email($db,$show_high_bidder->BIDDER);
										return true;
									} //end of if ($bid > $maxbid_increment)
				  					elseif ($bid_amount == $maxbid_increment)
									{
										//maxbid_increment becomes the new current bid
										//enter maxbid_increment into the bid table as the current bid for this bidder
										//update auctions table set maxbid_increment as the current bid
										//delete this auction from the autobid table

										$increment = $this->get_increment($db,$maxbid_increment);
										$update_result = $this->update_minimum_current_and_price(($increment + $maxbid_increment),$maxbid_increment,$maxbid_increment);
										if (!$update_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($maxbid_increment,$current_time,$quantity);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$delete_autobid_result = $this->delete_from_autobid_table();
										if (!$delete_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
										$this->auction_extension_check(geoUtil::time());
										$this->bid_success = 1; //bid made but not high bid
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->send_outbid_email($db,$show_high_bidder->BIDDER);
										return true;
									} //end of elseif ($bid == $maxbid_increment)
				  					else
									{
										//bid is greater than the current maxbid in the autobid table
										//but not bigger than the incremented autobid value
										//enter bid into the bid table as the bid for this bidder
										//update auctions table current bid equals bid
										//delete this auction from the autobid table

										$increment = $this->get_increment($db,$maxbid_increment);
										$update_result = $this->update_minimum_current_and_price(($bid_amount + $increment),$bid_amount,$bid_amount);
										if (!$update_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}

										$delete_autobid_result = $this->delete_from_autobid_table();
										if (!$delete_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
										$this->auction_extension_check(geoUtil::time());
										$this->send_current_high_bidder_email($db,$this->bidder->ID);
										$this->send_outbid_email($db,$show_high_bidder->BIDDER);
										$this->bid_success = 1;
										return true;
									}// end of else
								}
								else
								{
									//bid amount is equal to or greater than reserve price
									//got here because the max proxy bid was less than reserve
									//and there is a reserve price
									//and the current bid is greater than the reserve price

									//set the new minimum bid = reserve price
									//set proxy bid amount if necessary
									//remove old proxy bid
									$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);
									$set_minimum_result = $this->update_minimum_current_and_price(($this->auction->RESERVE_PRICE + $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
									if (!$set_minimum_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									else
									{
										$delete_autobid_result = $this->delete_from_autobid_table();
										if (!$delete_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}										
										
										$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
										if (!$insert_bid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											//put things back
											$reset_current_price_result = $this->set_current_and_price_to_zero();
											return false;
										}
										else
										{
											if ($bid_amount > $this->auction->RESERVE_PRICE)
											{
												//insert bid into the autobid table because it was greater then minimum_bid
												//minimum_bid is the current minimum because there were no previous bids
												$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
												if (!$insert_autobid_result)
												{
													if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
													return false;
												}
											}
											$this->send_outbid_email($db,$show_high_bidder->BIDDER);
											$this->send_current_high_bidder_email($db,$this->bidder->ID);
											$this->bid_success = 1;

										}
										$this->auction_extension_check(geoUtil::time());
										return true;
									}
								}// bid amount is equal to or greater than reserve price
		  					} //end of if ($bid_amount > $show_autobid->MAXBID)
		  					elseif ($bid_amount == $show_autobid->MAXBID)
		  					{
								//Bid amount is equal to the max bid by another user
								//the old bid stands as the new current bid
								//show_autobid[maxbid] is entered into the bid table as a bid for the old bidder
								//remove this auction from the autobid table

								$increment = $this->get_increment($db,$bid_amount);
								$update_result = $this->update_minimum_current_and_price(($increment + $bid_amount),$bid_amount,$bid_amount);
								if (!$update_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$insert_bid_result = $this->insert_into_bid_table($bid_amount,($current_time+1),$quantity);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$delete_autobid_result = $this->delete_from_autobid_table();
								if (!$delete_autobid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$this->bid_success = 3;
								$this->send_outbid_email($db,$this->bidder->ID);
								$this->auction_extension_check(geoUtil::time());
								return true;

		  					} //end of elseif ($bid_amount == $show_autobid->MAXBID)
		  					else
		  					{
		  						//Bid is less than the max bid
								$increment = $this->get_increment($db,$bid_amount);
								$incremented_bid = $increment + $bid_amount;
								if ($show_autobid->MAXBID > $incremented_bid)
								{
									//show_autobid["maxbid"] remains the same in the autobid table
									//bid is entered into the bid table as a bid for the current bidder
									//incremented bid becomes the new bid for the autobid bidder in the bid table at the same time
									//incremented_bid becomes the current bid in the auction table

									$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($incremented_bid,$current_time,$quantity,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$increment = $this->get_increment($db,$incremented_bid);
									$update_result = $this->update_minimum_current_and_price(($increment + $incremented_bid),$incremented_bid,$incremented_bid);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->auction_extension_check(geoUtil::time());
									$this->bid_success = 3;
									$this->send_outbid_email($db,$this->bidder->ID);
									return true;
			  					} //if ($show_autobid->MAXBID > $incremented_bid)
				  				elseif ($show_autobid->MAXBID == $incremented_bid)
				  				{
									// the autobid and the incremented bid are equal
									//the old show_autobid[maxbid] is the new current bid in the auction table
									//show_autobid[maxbid] is entered into bid table as the current bid for the show_autobid[bidder]
									//this auction is removed from the autobid table
									//current bid is entered into the bid table for the current bidder first the old bid is entered

				  					$insert_bid_result = $this->insert_into_bid_table($incremented_bid,$current_time,$quantity,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$increment = $this->get_increment($db,$incremented_bid);
									$update_result = $this->update_minimum_current_and_price(($incremented_bid + $increment),$incremented_bid,$incremented_bid);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$delete_autobid_result = $this->delete_from_autobid_table();
									if (!$delete_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->auction_extension_check(geoUtil::time());
									$this->bid_success = 3;
									$this->send_outbid_email($db,$this->bidder->ID);
									return true;

				  				} //end of elseif ($show_autobid->MAXBID == $incremented_bid)
								else
								{
									//show_autobid[maxbid] is greater than bid but not bigger than incremented bid
									//show_autobid[maxbid] becomes the current bid in the auction table
									//bid is entered into the bid table as a bid for the current bidder
									//show_autobid[maxbid] is entered into the bid table as a bid for the autobid bidder
									//this auction is removed from the autobid table

									$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$quantity,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$increment = $this->get_increment($db,$show_autobid->MAXBID);
									$update_result = $this->update_minimum_current_and_price(($increment + $show_autobid->MAXBID),$show_autobid->MAXBID,$show_autobid->MAXBID);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$delete_autobid_result = $this->delete_from_autobid_table();
									if (!$delete_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->auction_extension_check(geoUtil::time());
									$this->bid_success = 3;
									$this->send_outbid_email($db,$this->bidder->ID);
									return true;

				  				} //endof else elseif ($show_autobid->MAXBID == $incremented_bid)
							} //end of else
		  				} //end of else of if (!result)
	  				} //end of else of if(current_bid == 0)
	  			//Sunit
				}
				else
				{
				//bid_amount not enough
					//raise your bid
					$this->bid_error = 2;
					if ($this->db->get_site_setting('debug_bid'))
						echo $this->bid_error."2 - is error<br/>\n";
					return false;
				}
			}
		}
		else
		{
			return false;
		}
	} //end of function process_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_minimum_bid($db)
	{
		if (floatval($this->auction->CURRENT_BID) < 0.01 && floatval($this->auction->STARTING_BID) >= 0.01)
		{
			//echo floatval($this->auction->CURRENT_BID) . ' <= 0 AND ' . floatval($this->auction->STARTING_BID) . ' > 0';
			return $this->auction->STARTING_BID;
		}
		elseif (floatval($this->auction->CURRENT_BID) <= 0.00 && floatval($this->auction->STARTING_BID) <= 0.00)
		{
			//check minimum bid in case a value was placed there but not
			//in the starting bid
			if (floatval($this->auction->MINIMUM_BID) > 0)
			{
				return $this->auction->MINIMUM_BID;
			}
			else
			{
				return 0.01;
			}
		}
		else
		{
			//get bid increment
			$increment = $this->get_increment($db,$this->auction->CURRENT_BID);
			if ($increment)
				return $this->auction->CURRENT_BID + $increment;
			else
			{
				return false;
			}
		}
	} // end of function get_minimum_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_increment($db,$amount)
	{
		$function_name = "get_increment";
		

		$sql = "select `increment` from ".geoTables::increments_table." where
			`low` <= ? ORDER BY `low` DESC limit 1";
        $increment_result = $this->db->Execute($sql, array($amount));
        if ($this->DEBUG_BID)
        {
        	echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
        	echo $amount." is \$amount<BR>\n";
        }

		if (!$increment_result)
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			$this->error_message = urldecode($this->messages[100081]);
			return 1;
		}
		elseif  ($increment_result->RecordCount() == 1)
		{
			$show_increment = $increment_result->FetchNextObject();
			 if ($this->DEBUG_BID) echo $show_increment->INCREMENT." is \$show_increment->INCREMENT<Br>\n";
			 if ($show_increment->INCREMENT == 0){
			 	//it messes things up if the increment is 0, so make it $1 instead.
			 	return 1;
			 }
			 return $show_increment->INCREMENT;
		}
		else
		{
			return 1;
		}
	} //end of function get_increment

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function send_current_high_bidder_email($db,$bidder_id)
	{
		//echo "Inside send_current_high_bidder_email in auction_bid_class<br/>";
		$this->page_id = 10168;
		$this->get_text();
		$bidder_info = $this->get_user_data($bidder_id);

		if (($bidder_info) && ($this->auction))
		{
			$message_data["subject"] = urldecode($this->messages[102480]);
			$message_data['message'] = $this->get_salutation($bidder_info);

			$message_data["message"] .= urldecode($this->messages[102481]);
			$message_data["message"] .= $this->show_email_auction_specs($db,$bidder_id);
			$this->sendMail($bidder_info->EMAIL, $message_data['subject'],$message_data['message']);

			return true;
		}
		else
		{
			return false;
		}
	} //end of function send_current_high_bidder_email

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function send_outbid_email(& $db,$bidder_id)
	{
		$this->page_id = 10169;
		$this->get_text();
		$bidder_info = $this->get_user_data($bidder_id);

		if (($bidder_info) && ($this->auction))
		{
			$message_data['message'] = $this->get_salutation($bidder_info);

			$message_data["message"] .= urldecode($this->messages[102474])."\n";
			$message_data["message"] .= $this->show_email_auction_specs($db);
			$message_data["subject"] = urldecode($this->messages[102473]);
			$this->sendMail($bidder_info->EMAIL, $message_data["subject"], $message_data["message"]);

			return true;
		}
		else
		{
			return false;
		}
	} //end of send_outbid_email


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function show_email_auction_specs($db,$bidder_id=0)
	{
		$this->page_id = 10170;
		$this->get_text();
		$function_name = "show_email_auction_specs";

		if ($this->auction)
		{
			$email_auction_data = "\r\n".urldecode($this->messages[102475]).urldecode($this->auction->TITLE);
			//$email_auction_data .= "$this->separator".urldecode($this->messages[102476]).urldecode($this->auction->DESCRIPTION);

			//get current bid
			$sql = "select current_bid from ".$this->classifieds_table."
				where id = ?";
			$get_current_result = $this->db->Execute($sql, array($this->auction_id));
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "get current bid from auctions table by auction id");
			}
			if (!$get_current_result)
			{
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				return false;
			}
			elseif ($get_current_result->RecordCount() == 1)
			{
				$show_current_bid = $get_current_result->FetchNextObject();
				$display_amount = $this->show_money($show_current_bid->CURRENT_BID,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
				$email_auction_data .= "\r\n".urldecode($this->messages[102482])." ".$display_amount."\n\n";
			}

			if ($bidder_id)
			{
				$sql = "select * from ".$this->autobid_table." where auction_id = ? and bidder = ?";
				$get_autobid_result = $this->db->Execute($sql, array($this->auction_id, $bidder_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "get data from autobid table by auction and bidder id");
				}
				if (!$get_autobid_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				elseif ($get_autobid_result->RecordCount() == 1)
				{
					$show_autobid = $get_autobid_result->FetchNextObject();
					$display_amount = $this->show_money($show_autobid->MAXBID,$this->db->get_site_setting('precurrency'),$this->db->get_site_setting('postcurrency'));
					$email_auction_data .= "\r\n".urldecode($this->messages[102483])." ".$display_amount."\n\n";
				}
			}
			$email_auction_data .= "\r\n".urldecode($this->messages[102478]).date($this->db->get_site_setting('entry_date_configuration'),$this->auction->ENDS);
			$email_auction_data .= "\r\n".urldecode($this->messages[102479])."\r\n".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
			return $email_auction_data;
		}
	} //function show_email_auction_specs

//##############################################################################

	function get_bid_history($db,$auction_id,$aff_id=0)
	{
		$this->page_id = 10171;
		$this->get_text();

		$view = geoView::getInstance();
		$db = DataAccess::getInstance();
		
		if (!$auction_id) {
			return false;
		}

		$listing = geoListing::getListing($auction_id);
		if($listing->item_type == 2) {
			$orderBy = 'bid DESC, time_of_bid DESC';
		} elseif($listing->item_type == 4) {
			$orderBy = 'bid ASC, time_of_bid DESC';
		}
				
		$sql = "select * from ".geoTables::bid_table." where auction_id = ? order by ".$orderBy;
		$bid_history_result = $db->Execute($sql, array($auction_id));

		if (!$bid_history_result) {
			return false;
		} elseif ($bid_history_result->RecordCount() > 0) {
			$current_auction = $this->get_classified_data($auction_id);
			//there are bids on this auction and show them
			
			if($current_auction->AUCTION_TYPE == 2) {
				$view->is_dutch = true;
			}
			
			$view->show_bidder_email = ($this->db->get_site_setting('view_email_after_auction') && ($this->userid == $current_auction->SELLER)) ? true : false;
			
			$bids = array();
			for($i=0; $show_bid = $bid_history_result->FetchNextObject(); $i++) {
				$bids[$i]['time_of_bid'] = date($this->db->get_site_setting('entry_date_configuration'),$show_bid->TIME_OF_BID);
				$bids[$i]['bid_amount'] = $this->show_money($show_bid->BID,$current_auction->PRECURRENCY,$current_auction->POSTCURRENCY);
				if($current_auction->AUCTION_TYPE == 2) {
					// If dutch auctions show quantity
					$bids[$i]['quantity'] = $show_bid->QUANTITY;
				}
				$user = geoUser::getUser($show_bid->BIDDER);
				$bids[$i]['bidder_name'] = $user->username;
				$bids[$i]['bidder_email'] = $user->email;
				$bids[$i]['bidder_feedback_link'] = $db->get_site_setting('classifieds_file_name') . '?a=1030&amp;b='.$auction_id.'&amp;d='.$user->id;
			}
			$view->bids = $bids;
		} else {
			//there were no bids for this auction
			$view->no_bids = true;
		}
		$view->auctionLink = $db->get_site_setting('classifieds_file_name')."?a=2&b=".$auction_id;
		$view->setBodyTpl('bidding/bid_history.tpl','','auctions');
		$this->display_page();
		return true;
	}

//##############################################################################
	/**
	 * Emails all the dutch bidders that have just lost a bid
	 */
	function email_dutch_bidders_new_bid(& $db, & $bid_count, & $aff_id){
		$this->page_id = 10166;
		$this->get_text();
		$this->page_id = 10169;
		$this->get_text();
		if ($this->DEBUG_BID) echo "email_dutch_bidders_new_bid function<br />\n";
		for ($i = $this->winning_dutch_bidder_count ; $i < $bid_count ; $i++)
		{
			$current_bidder = $this->get_user_data($this->dutch_bidders[$i]["bidder"]);
			//gets salutation.
			$message_data['message'] = $this->get_salutation($current_bidder);

			$message_data["message"] .= urldecode($this->messages[102491])."\n\n";
			$message_data["message"] .= urldecode($this->messages[102489]).$this->dutch_bidders[$i]["quantity"]."\n";
			if ($this->DEBUG_BID){ echo 'emailing info for bidder['.$i.']<pre>';var_dump($this->dutch_bidders[$i]); echo '</pre>';}
			$display_amount = $this->show_money($this->dutch_bidders[$i]["bid"],$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
			$message_data["message"] .= urldecode($this->messages[102490]).$display_amount."\n\n";
			$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
 			$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
			$message_data["subject"] = urldecode($this->messages[102488]);
			$this->sendMail($current_bidder->EMAIL, $message_data['subject'],$message_data['message']);
			if ($this->DEBUG_BID){
				echo '<pre>'; var_dump($message_data["message"]); echo "</pre><br />\n";
			}
		}
	}#end email_dutch_bidders_new_bid
	//##############################################################################
	/**
	 * Emails the dutch bidder if they made a successful bid
	 */
	function email_dutch_bidder_successful_bid(& $db,& $bid_amount,& $aff_id){
		if ($this->DEBUG_BID)echo "Entering dutch bidder successful bid function<br />\n";
		$this->page_id = 10166;
		$this->get_text();
		//this dutch bid is a successful one
		$message_data['message'] = $this->get_salutation($this->bidder);

		$message_data["message"] .= urldecode($this->messages[102484])."\n\n";
		$message_data["message"] .= urldecode($this->messages[102455]).$this->dutch_bidder_quantity."\n";
		$display_amount = $this->show_money($bid_amount,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$message_data["message"] .= urldecode($this->messages[102482]).$display_amount."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";

		$message_data["subject"] = urldecode($this->messages[102485]);
		$this->sendMail($this->bidder->EMAIL, $message_data["subject"], $message_data["message"]);
		if ($this->DEBUG_BID){ echo 'Emailing dutch bidder because of successful bid:<pre>';var_dump($message_data);echo "<br />\n"; }

	}#end email_dutch_bidder_successful_bid
	//##############################################################################

	/**
	 * Emails the dutch bidder if they made an unsuccessful bid
	 */
	function email_dutch_bidder_not_successful_bid(& $db,& $bid_amount,& $aff_id){
		$this->page_id = 10166;
		$this->get_text();
		//this dutch bid is not a successful one
		$message_data['message'] = $this->get_salutation($this->bidder);

		$message_data["message"] .= urldecode($this->messages[102487])."\n\n";
		$display_amount = $this->show_money($bid_amount,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$message_data["message"] .= urldecode($this->messages[102482]).$display_amount."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
		$message_data["subject"] = urldecode($this->messages[102486]);
		
		$this->sendMail($this->bidder->EMAIL, $message_data["subject"], $message_data["message"]);
		if ($this->DEBUG_BID){ echo 'Emailing: not successful dutch bidder: <pre>'; var_dump($message_data); echo "</pre><br />\n"; }
		$this->bid_error = 6;
		if ($this->db->get_site_setting('debug_bid'))
			echo $this->bid_error." - is error<br/>\n";
	}#end email_dutch_bidder_not_successful_bid
	//##############################################################################

	/**
	 * Emails if they are the only dutch bidder
	 */
	function email_only_dutch_bidder(& $db,& $bid_amount,& $aff_id,& $bid_quantity){
		$this->page_id = 10168;
		$this->get_text();
		//this bidder is the only bidder at the moment
		$message_data['message'] = $this->get_salutation($this->bidder);

		$message_data["message"] .= urldecode($this->messages[102484])."\n\n";
		$message_data["message"] .= urldecode($this->messages[102455]).$bid_quantity."\n";
		$display_amount = $this->show_money($bid_amount,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$message_data["message"] .= urldecode($this->messages[102482]).$display_amount."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
		
		$message_data["subject"] = urldecode($this->messages[102485]);
		$this->sendMail($this->bidder->EMAIL, $message_data["subject"], $message_data["message"]);
		if ($this->DEBUG_BID) { echo 'E-Mail, only bidder: <pre>'; var_dump ($message_data); echo "</pre><br />\n"; }

	}

	//##############################################################################

	/**
	 * generates text for additional fees
	 */
	function get_additional_fee_text(){
		//display any optional fields that add to the cost.
		$additional_costs = array ( 'total' => 0);
		$message_data = '';
		$userId = $this->auction->SELLER;
		$groupId = ($userId)? geoUser::getUser($userId)->group_id : 0;
		
		$fields = geoFields::getInstance($groupId, $this->auction->CATEGORY);
		for ($i = 1; $i < 21; $i++){
			//go through all the optional fields, see if they add cost, and if they do,
			//see if the value actually adds any cost (not 0 or blank field)
			$option = 'OPTIONAL_FIELD_'.$i;
			$fieldName = 'optional_field_'.$i;
			
			if ($fields->$fieldName->field_type=='cost' && $this->auction->$option>0){
				//this optional field needs to be displayed.
				$additional_costs[$i] = $this->show_money($this->auction->$option,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
				$additional_costs['total'] += $this->auction->$option;
			}
		}
		if ($additional_costs['total']>0){
			//there are additional costs to display!
			$message_data.= urldecode($this->messages[500033])."\n";
			foreach ($additional_costs as $key => $cost){
				//go through all the additional costs and display them
				if ($key != 'total')//don't display the total twice!
					$message_data.=$cost."\n";
			}
			//display the additional fee total.
			$message_data.=urldecode($this->messages[500035]).$this->show_money($additional_costs['total'],$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY)."\n\n";
			//display the grand total
			$grand_total = $this->auction->BUY_NOW+$additional_costs['total'];
			$grand_total = $this->show_money($grand_total,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
			$message_data.=urldecode($this->messages[500036]).$grand_total."\n\n";
			//display the additional fee disclaimer
			$message_data.=urldecode($this->messages[500034])."\n\n";
		}
		return $message_data;
	}
	//##############################################################################

	/**
	 * Emails buy-now bidder and seller
	 */
	function email_buy_now_bidder_and_seller(& $aff_id,& $seller){
		//send emails to seller and buy now bidder
	    //to buy now bidder
	    $message_data['message'] = $this->get_salutation($this->bidder);

		$message_data["message"] .= urldecode($this->messages[102493])."\n\n";
		$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		//if ($this->DEBUG_BID) { echo 'Auction Info: <pre>'; var_dump($this->auction); var_dump($this->configuration_data); echo "</pre><br />\n"; }
		$message_data["message"] .= urldecode($this->messages[102494]).$display_amount."\n\n";
		//add additional fees text
		$additional_fees = $this->get_additional_fee_text();
		$message_data["message"] .= $additional_fees;
		$message_data["message"] .= $seller->FIRSTNAME." ".$seller->LASTNAME."\n".$seller->EMAIL."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
			
		if (geoPC::is_ent()){
			//see if there should be seller to buyer text
			$vars = array(
				'listing_id' => $this->auction->ID,
				'winning_bidder_id' => $this->bidder->ID,
				'listing_details' => $this->auction,
				'final_price' => $this->auction->BUY_NOW
			);
			$sb_links = geoSellerBuyer::callDisplay('displayPaymentLinkBuyNowEmail', $vars);
			if (strlen($sb_links) > 0){
				$message_data['message'].="\n".$sb_links;
			}
		}
		$message_data["subject"] = urldecode($this->messages[102492]);

		if ($this->DEBUG_BID)
		{
			echo $message_data["message"]." is the message sent to the high bidder<br/>\n";
		}


		if ($this->DEBUG_BID){
			echo 'E-mailing buy now bidder:<pre>';
			var_dump($message_data);
			echo "</pre><br />\n";
		}
		$this->sendMail($this->bidder->EMAIL, $message_data["subject"], $message_data["message"]);

		//to seller
		$message_data['message'] = $this->get_salutation($seller);

		$message_data["message"] .= urldecode($this->messages[102496])."\n\n";
		$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$message_data["message"] .= urldecode($this->messages[102494])." ".$display_amount."\n\n";
		//add additional fees text
		$message_data["message"] .= $additional_fees;
		$message_data["message"] .= $this->bidder->FIRSTNAME." ".$this->bidder->LASTNAME."\n".$this->bidder->EMAIL."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
		$message_data["subject"] = urldecode($this->messages[102495]);
		if ($this->DEBUG_BID){ echo 'E-mailing buy now seller:  <pre>'; var_dump($message_data); echo "</pre><br />\n"; }
		$this->sendMail($seller->EMAIL, $message_data["subject"], $message_data["message"]);

	} //end of function email_buy_now_bidder_and_seller
	
//##############################################################################

	function start_delayed_auction() {
		if ($this->auction->DELAYED_START == 1)
		{
			//set the start time to now
			//set the end time to the current start time plus the duration
			//set delayed_start to 0 
			
			$start_time = geoUtil::time();
			$auction_length = $this->auction->DURATION * 86400;
			$end_time = geoUtil::time() + $auction_length;
			$sql = "update ".$this->db->geoTables->classifieds_table." set 
				date = ? ,
				ends = ? ,
				delayed_start = 0
				where id = ? ";
			$start_auction_result = $this->db->Execute($sql, array($start_time, $end_time, $this->auction_id));
			if (!$start_auction_result)
			{
				echo $this->db->ErrorMsg()." is the errormsg<br>\n";
				echo $sql." is the sql<br>\n";
				echo $start_time." is the \$start_time<br>\n";
				echo $end_time." is the \$start_time<br>\n";
				echo $this->auction_id." is the \$this->auction_id<br>\n";
				return false;
			}
			else
			{
				//successfully started auction from delayed start state
				return true;
			}
		}
		else
		{
			//this is not a delayed start auction
			return true;
		}
	} //end of function start_delayed_auction
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_into_bid_table($bid=0,$current_time=0,$quantity=0,$buy_now_bid=0,$bidder=0)
	{
		if ($bidder == 0)
		{
			//use the current bidder logged in
			$bidder = $this->bidder->ID;
		}
		else
		{
			//use the bidder passed in...could be from proxy	
		}
		if ($bid && $current_time && $quantity)
		{
			$sql = "insert into ".$this->bid_table."
				(auction_id,bidder,bid,time_of_bid,quantity,buy_now_bid)
				values (?, ?, ?, ?, ?, ?)";
			$query_data = array	($this->auction_id, $bidder, $bid,$current_time,$quantity,$buy_now_bid);
			$insert_bid_result = $this->db->Execute($sql, $query_data);
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into bid table");
			}
			if ($insert_bid_result)
				return true;
			else
			{
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
				return false;
			}
		}
		else
		{
			return false;
		}
		
	} //end of function insert_into_bid_table
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_into_autobid_table($bid=0,$current_time=0,$quantity=0)
	{
		if ($bid && $current_time && $quantity)
		{
			$sql = "insert into ".$this->autobid_table."
				(auction_id,bidder,maxbid,time_of_bid,quantity)
				values (?, ?, ?, ?, ?)";
			$query_data = array	($this->auction_id, $this->bidder->ID, $bid, $current_time, $quantity);
			$insert_autobid_result = $this->db->Execute($sql, $query_data);
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into auctions table");
			}
			if ($insert_autobid_result)
				return true;
			else
			{
				if ($this->DEBUG_BID) 
				{
					echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
					echo $this->auction_id." is \$this->auction_id<br>\n";
					echo $this->bidder->ID." is \$this->bidder->ID<br>\n";
					echo $bid." is \$bid<br>\n";
					echo $current_time." is \$current_time<br>\n";
					echo $quantity." is \$quantity<br>\n";
				}
				return false;
			}
		}
		else
		{
			return false;
		}
		
	} //end of function insert_into_autobid_table	
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	
	
	function delete_from_autobid_table()
	{
		$sql = "delete from ".$this->autobid_table."  where auction_id = ?";
		$delete_autobid_result = $this->db->Execute($sql, array($this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "delete data in bid table by auction id");
		}
		if ($delete_autobid_result)
		{
			return true;
		}
		else
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
	} //end of function insert_into_bid_table		
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function update_minimum_current_and_price($minimum,$current,$price)
	{
		$sql = "update ".$this->classifieds_table." set
			minimum_bid = ?,
			current_bid = ?,
			price = ?
			where id=?";
		$bid_result = $this->db->Execute($sql, array( $minimum, $current, $price, $this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auctions table by auction id");
		}		
		if ($bid_result)
		{
			return true;
		}
		else
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
	} //end of function update_current_price_minimum
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function set_current_and_price_to_zero()
	{
		$sql = "update ".$this->classifieds_table."
			set current_bid = 0,
			set price = 0
			where id = ?";
		$set_minimum_result = $this->db->Execute($sql, array($this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
		if (!$set_minimum_result)
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auction table by auction id");
		}		
		return true;
	}
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function auction_extension_check($current_time)
	{
		if($this->db->get_site_setting('auction_extension_check') > 0)
		{
			//Fetch the time of the current bid
			//Check current_bid time is greater than auction_ends - auction_extension_check and less than
			// auction_ends
			//if true, add auction_extension to auction_ends and update the data
			//else do nothing
			if(($current_time >=($this->auction->ENDS-$this->db->get_site_setting('auction_extension_check')*60))
				&& ($current_time <= $this->auction->ENDS))
			{
				$this->auction->ENDS = $this->auction->ENDS+$this->db->get_site_setting('auction_extension')*60;
				//echo $this->auction->ENDS." is the new end time <br/>";
				$sql = "update ".$this->classifieds_table."
					set ends = ?
					where id = ?";
				$update_result = $this->db->Execute($sql, array($this->auction->ENDS, $this->auction_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update ends attribute in auction table by auction id");
				}
				else
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				}
			}
			else
			{
				//echo "Time is not in auction extension check range<br/>";
			}
		}		
	}
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

} //end of class Auction_bid
