<?php 
//authenticate_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21198              $ ##
## File last change date:       ##
##  $Date:: 2011-03-18 13:03:#$ ##
##                              ##
##################################

class Auth extends geoSite {

	   var $error;
	   var $login_cookie_time;
	   var $classified_user_id;
	   var $username;
	   var $classified_level;
	   var $auth_messages;
	   var $error_messages;
	   var $error_found;

	   var $messages = array();

	   var $notify_data;

	   var $debug_auth = 0;

//#############################################################################

	function login_form($db,$username=0,$password=0,$encode=0,$must_login=0)
	{
		$this->page_id = 39;
		$this->get_text();
		$tpl_vars = array();
		
		if ($encode){
			$session_timeout = false;
			//check to see if stopped in middle of something
			if (isset($_GET['set_type']) || isset($_GET['set_cat']) || isset($_GET['set_details']) || isset($_GET['set_images']) || isset($_GET['set_trans_details'])){
				//on one of the first steps when forced to log in
				$session_timeout = true;
			}
			if (isset($_GET['b'])){
				if ($_GET['b']=='ad_accepted' || $_GET['b']=='edit_category'||$_GET['b']=='edit_details'||$_GET['b']=='edit_image'||$_GET['b']=='billing_accepted'){
					//clicked edit button when forced to log in
					$session_timeout=true;
				}
			}
			
			if (!isset($this->error_messages['cookie']) && $session_timeout){
				//show timeout message
				$tpl_vars['error'] = $this->messages[500158];
			}
		}
		if ($this->error_messages['cookie']){
			$tpl_vars['error'] .= urldecode($this->error_messages['cookie']);
			$session = true;
			include(GEO_BASE_DIR.'get_common_vars.php');
			if ($session->getStatus() == 'changed'){
				//only display the error message, nothing else.
				$tpl_vars['only_show_error'] = true;
			}
		}
		
		if ($this->db->get_site_setting('use_ssl_in_login')) {
			$tpl_vars['form_target'] = $this->db->get_site_setting('classifieds_ssl_url')."?a=10";
		} else {
			$tpl_vars['form_target'] = $this->db->get_site_setting('classifieds_file_name')."?a=10";
		}
		
		if ($encode) {
			$tpl_vars['encode'] = $encode;
		}
		
		$tpl_vars['auth_messages'] = $this->auth_messages;
		$tpl_vars['error_messages'] = $this->error_messages;
		
		if($must_login == 1) {
			//contact seller
			$must_login = $this->messages[2343];
		} elseif ($must_login == 2) {
			//message friend
			$must_login = $this->messages[2344];
		} elseif ($must_login == 3) {
			//view listings
			$must_login = $this->messages[3266];
		} else {
			$must_login = '';
		}
		$tpl_vars['must_login'] = $must_login;
		
		if($username) {
			$tpl_vars['username'] = geoString::specialChars($username);
		}
		//TODO: Move this to a generic addon hook!
		$secure = geoAddon::getUtil('security_image');
		if($secure && $secure->check_setting('login'))
		{
			$security_text =& geoAddon::getText('geo_addons','security_image');
			$error = $this->error_messages['securityCode'];
			$section = "login";
			$tpl_vars['securityImageHTML'] = $secure->getHTML($error, $security_text, $section, false);
			$this->header_font_stuff .= $secure->getJs();		
		}
		
		if ($this->db->get_site_setting('forgot_password')){
			//only show forgot password link if the feature is turned on.
			$tpl_vars['forgotPasswordLink'] = $this->db->get_site_setting('classifieds_file_name')."?a=18";
		}

		$tpl_vars['registrationLink'] = ($this->db->get_site_setting('use_ssl_in_registration')) ? $this->db->get_site_setting('registration_ssl_url') : $this->db->get_site_setting('registration_url');  
		
		$this->auth_messages["login"] = 0;
		$this->error_messages["username"] = 0;
		$this->error_messages["password"] = 0;
		$this->error_messages["securityCode"] = 0;

		//make sure the javascript needed for the cookie validate step is cached
		$view = geoView::getInstance();
		$view->allowEmail = 1;
		$view->addTop("
<script type=\"text/javascript\">
	//<![CDATA[
	geoUtil.autoSubmitForm ('validate_login', '?a=10&back=no');
	//]]>
</script>
");
		$view->setBodyTpl('login_form.tpl','','authentication')->setBodyVar($tpl_vars);
		
		$this->display_page();
		return true;

	} //end of function login_form

//#############################################################################
	function validate_login_form($info, $encode){
		$session = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		
		$username = (isset($info['username']))? geoString::specialCharsDecode($info['username']): '';
		$password = (isset($info['password']))? geoString::specialCharsDecode($info['password']): '';
		
		$this->page_id = 39;
		$this->get_text();
		$this->body .=  "<form action=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10\" method=\"post\" id=\"validate_login\">\n";
		if ($encode)
			$this->body .=  "<input type=\"hidden\" name=\"c\" value=\"".urlencode($encode)."\" />\n";
		$this->body .=  "<input type=\"hidden\" name=\"b[username]\" value=\"".geoString::specialChars($username)."\" />\n";
		$this->body .=  "<input type=\"hidden\" name=\"b[pvalidate]\" value=\"".geoString::specialChars($password)."\" />\n";
		
		$secure = geoAddon::getUtil('security_image');
		
		if($secure && $secure->check_setting('login') && (isset($info['securityCode']) || isset($_POST['recaptcha_challenge_field']))) {
			if (isset($_POST['recaptcha_challenge_field'])) {
	   			//silly recaptcha isn't able to change field names...
	   			$this->body .= "<input type='hidden' name='recaptcha_challenge_field' value=\"".geoString::specialChars($_POST['recaptcha_challenge_field'])."\" />\n";
	   			$this->body .= "<input type='hidden' name='recaptcha_response_field' value=\"".geoString::specialChars($_POST['recaptcha_response_field'])."\" />\n";
	   		} else {
				$this->body .=  "<input type=\"hidden\" name=\"b[securityCode]\" value=\"".geoString::specialChars($info['securityCode'])."\" />\n";
	   		}
		}
		$this->body .= "<input type=\"hidden\" name=\"b[sessionId]\" value=\"".$session->getSessionId()."\" />";
		$this->body .=  urldecode($this->messages[500151])."</form>\n"; //text is inside form...
		
		$view = geoView::getInstance();
		$view->allowEmail = 1;
		$view->addTop(
			"
<script type=\"text/javascript\">
	//<![CDATA[
	//2 seconds after page is done loading, auto submit the form.
	geoUtil.autoSubmitForm ('validate_login', '?a=10&back=no');
	//]]>
</script>
");
		
		$this->display_page();
		return true;
	}
	
	/**
	 * Log the user in and update the user's session in the database.
	 *
	 * @param array $info Associative array: 
	 *  array('username'=>'user','pvalidate'=>'plaintext_pass','sessionId'=>'session_id') (sessionId optional)
	 * @param boolean $ignore_detected_cookie_problems If true, will still allow login even if there are potential cookie problems. (mostly for use
	 *  by custom login routines)
	 * @return int|boolean The user's id if login was successful, false otherwise.  If false, the reason should be stored
	 *  in associative array in $auth->auth_messages and/or $auth->error_messages
	 */
	function login ($info, $ignore_detected_cookie_problems = false)
	{
		$session = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		
		$status = $session->getStatus();
		$username = (isset($info['username']))? geoString::specialCharsDecode($info['username']): '';
		$password = (isset($info['pvalidate']))? geoString::specialCharsDecode($info['pvalidate']): '';
		$passedSessionId = (isset($info['sessionId']))? $info['sessionId']: false;
		$sessionId = $session->getSessionId();
		
		trigger_error('DEBUG AUTH STATS: Top of login function.');
		
		//make sure the product configuration is loaded.
		//and the db connection.
		if (!isset($this->db) || !is_object($this->db)){
			$this->db = DataAccess::getInstance();
		}
		
		//make sure authorization is loaded.
		if (!isset($this->product_configuration) || !is_object($this->product_configuration)){
			$this->product_configuration = geoPC::getInstance();
		}
		
		$this->page_id = 39;
		$this->get_text();
		if (!$sessionId) {
			trigger_error('DEBUG AUTH STATS: Login failed, problem with session id.');
			return false;
		}
		$this->error_found = 0;
		$this->auth_messages["login"] = 0;
		$this->error_messages["username"] =0;
		$this->error_messages["password"] = 0;
		$this->error_messages["securityCode"] = 0;
		$this->error_messages["cookie"] = 0;

		$cookie_status = $session->getStatus();
		if ($cookie_status != 'confirmed' || strlen(trim($sessionId)) == 0) {
			//something wrong with cookie??
			if ($cookie_status == 'new') {
				$this->error_messages['cookie'] = $this->messages[500149]; //seems to be no cookies
			} else {
				//must be that cookie could not be updated...
				$this->error_messages['cookie'] = $this->messages[500150]; //error updating message
			}
			if (!$ignore_detected_cookie_problems) {
				//Allow outside to force login even if there are potential cookie problems.
				$this->error_found ++;
			}
		}
		
		if (strlen(trim($username)) == 0)
		{
			$this->error_messages["username"] = $this->messages[337];
			$this->error_found++;
		}

		if (strlen(trim($password)) == 0 )
		{
	        $this->error_messages["password"] = $this->messages[338];
	        $this->error_found++;
		}
		
		$secure_image = geoAddon::getUtil('security_image');
		if ($secure_image && $secure_image->check_setting('login'))
		{
			if (!$secure_image->check_security_code($_POST["b"]["securityCode"]))
			{
				$this->error_messages['securityCode'] ="error";
				$this->error_found++;
			}
		}

		
		if ($this->error_found > 0)
		{
			$this->auth_messages["login"] = $this->messages[341];
			return false;
		}

		

		if ($this->debug_auth)
			echo $this->error_found." is the error_found<br />\n";

		
		$login_data = $this->product_configuration->verify_credentials($username, $password, false, true, true);
		if ($login_data === false){
			//username and password do not match!
			$this->auth_messages["login"] = $this->messages[341];
	        return false;
		}
		//To fix str case of username
		$username = $login_data['username'];
		if ($login_data['status'] == 1)
		{
			$sql = "select level,email,firstname,lastname from ".$this->db->geoTables->userdata_table." where id = ?";
			if ($this->debug_auth)
				echo $sql."<br />\n";
			$level_result = $this->db->Execute($sql, array($login_data['id']));
			if (!$level_result)
			{
				//$this->body .=  $sql." is the query<br />\n";
				$this->auth_messages["login"] = $this->messages[341];
				return false;
			}
			elseif (($level_result->RecordCount() == 0) || ($level_result->RecordCount() > 1))
			{
				//$this->body .=  $sql." is the query<br />\n";
				$this->auth_messages["login"] = $this->messages[341];
				return false;
			}
			else
			{
				$show_level = $level_result->FetchNextObject();
				$ip_field = $session->getIpField();
				$sql = "update geodesic_sessions set
					user_id = ?,
					level = ?
					where `classified_session` = ? and `$ip_field` = ? AND `admin_session`='No'";
				//get ip
				$ip = $session->getUniqueUserInfo($sessionId);
				$session_result = $this->db->Execute($sql, array($login_data['id'], $show_level->LEVEL, $sessionId, $ip));
				if ($this->debug_auth)
					echo $sql."<br />\n";
				if (!$session_result)
				{
					$this->body .=  $sql." is the query<br />\n";
					$this->auth_messages["login"] = $this->messages[341];
					return false;
				}

				$this->userid = $login_data['id'];
				$this->level = $show_level->LEVEL;
				$this->email_address = $show_level->EMAIL;
				$this->firstname = $show_level->FIRSTNAME;
				$this->lastname = $show_level->LASTNAME;
				
				//grab ip and time
				$sql = "UPDATE ".geoTables::userdata_table." SET last_login_time = NOW(), last_login_ip = ? WHERE id=?";
				$this->db->Execute($sql, array(getenv('REMOTE_ADDR'), $login_data['id']));
					
				geoAddon::triggerUpdate('session_login',array('userid' => $login_data['id'], 'username'=> $username,	'password' => $password	));
				
				if($_COOKIE['jit_suspend']) {
					
					//restore suspended cart / switch it to this user
					$cart_id = intval($_COOKIE['jit_suspend']);
										
					/*
					 after logging in, the 'jit' step won't exist anymore.
					 set `step` to 'other_details' so the cart resumes where it left off				
					 but first: check to make sure 'other_details' is in use at all, and go to checkout if not (otherwise listing process will start over)
					*/
					$otherDetails = geoOrderItem::callDisplay('geoCart_other_detailsDisplay',null,'not_null','',true);
					//setting return type of not_null means that $otherDetails will contain some string if at least one other details returns something
					//(specifically, the html of the first active other_detail it finds, but we don't care about that right now)  
					$new_step = strlen($otherDetails) > 0 ? 'other_details' : 'cart';
					
					//see if this user is eligible to list under multiple price plans
					//if yes, roll back the step to pp selection
					$userObj = geoUser::getUser($login_data['id']);
					$group = $userObj->group_id;
					$sql = "SELECT `main_type` FROM ".geoTables::cart." WHERE `id`=?";
					$item_type = $this->db->GetOne($sql, array($cart_id));
					$applies_to = ($item_type == 'classified') ? 1 : 2;
					$sql = "SELECT `price_plan_id` FROM ".geoTables::attached_price_plans." WHERE `group_id` = ? AND `applies_to` = ?";
					$result = $this->db->Execute($sql, array($group, $applies_to));
					if($result->RecordCount() > 1) {
						//secondary price plans exist
						//go to pp selection screen
						$new_step = 'choose_plan';
					}
					 
					
					$sql = "UPDATE ".geoTables::cart." SET `session` = 0, `user_id` = ?, `step` = ? WHERE `id` = ?";
					$result = $this->db->Execute($sql, array($login_data['id'], $new_step, $cart_id));
					
					//delete any "extra" cart sessions this user has
					//such as if he started a cart, logged out, then started a JIT cart
					//in that case, he's prolly forgotten about the old one, so supercede it with this
					$sql = "DELETE FROM ".geoTables::cart." WHERE `user_id` = ? AND `id` <> ?";
					$result = $this->db->Execute($sql, array($login_data['id'], $cart_id));
					

					
				}
				
				return $login_data['id'];
			}
		} else {
			$this->auth_messages["login"] = $this->messages[345];
			return false;
		}
	} //end of function login

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function lostpassword ($db,$info=0)
	{
		//make sure the product configuration is loaded.
		//and the db connection.
		if (!isset($this->db) || !is_object($this->db)){
			if(strlen(PHP5_DIR)>0){
				$this->db = DataAccess::getInstance();
			} else {
				$this->db =& DataAccess::getInstance();
			}
		}
		if (!$this->db->get_site_setting('forgot_password')){
			//this feature disabled.
			return true;
		}
		//make sure authorization is loaded.
		if (!isset($this->product_configuration) || !is_object($this->product_configuration)){
			if(strlen(PHP5_DIR)>0){
				$this->product_configuration = geoPC::getInstance();
			} else {
				$this->product_configuration =& geoPC::getInstance();
			}
		}
		if (isset($info) && is_array($info))
		{
			$this->page_id = 40;
			$this->get_text();
			$this->page_id = 41;
			$this->get_text();
			$sql = "select id from ".$this->db->geoTables->userdata_table." where email = ? AND id != 1";
			$result = $this->db->Execute($sql, array($info["email"]));
			//$this->body .=  $sql." is the query<br />\n";
			if (!$result)
			{
				trigger_error('ERROR SQL AUTH: Could not get user info.  sql:'.$sql.' db reported:'.$this->db->ErrorMsg());
				$this->error_message = urldecode($this->messages[832]);
				return false;
			}
			//elseif ($result->RecordCount() == 1)
			elseif ($result->RecordCount() >0)
			{
				$show_id = $result->FetchNextObject();
				if ($show_id->ID == 1){
					//do not send the admin's lost pass.
					trigger_error('DEBUG AUTH: User just tried to send the admin password, and it was blocked.');
					$this->error_message = urldecode($this->messages[351]);
					$this->lostpassword_form($db);
					exit;
					return false;
				}
				$sql = "select username,password from ".$this->db->geoTables->logins_table." where id = ?";
				$result = $this->db->Execute($sql, array($show_id->ID));
				//$this->body .=  $sql." is the query<br />\n";
				if (!$result)
				{
					$this->body .=  $sql." is the query<br />\n";
					$this->error_message = urldecode($this->messages[832]);
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					$show = $result->FetchNextObject();
					if ($this->db->get_site_setting('client_pass_hash') == 0 || strlen($show->PASSWORD) == 40){
						//replace the password with a generated password.
						$pass = $this->product_configuration->generate_new_pass(8);
						$hashed_pass = $this->product_configuration->get_hashed_password($show->USERNAME, $pass,$this->db->get_site_setting('client_pass_hash'));
						$sql = 'UPDATE '.$this->db->geoTables->logins_table.' SET password = ? WHERE username = ? AND id != 1 LIMIT 1';
						trigger_error('DEBUG SQL: Query: '.$sql.' username:'.$show->USERNAME);
						$pass_update_result = $this->db->Execute($sql, array($hashed_pass, $show->USERNAME));
						if (!$pass_update_result){
							//if this happens, we are in trouble!
							return false;
						}
						//changing user info...
						
						geoAddon::triggerUpdate('user_edit',array('old_username' => $show->USERNAME, 'username' => $show->USERNAME, 'old_password' => $show->PASSWORD, 'password' => $pass));
						
					} else {
						//it seems the password is in plaintext, so just send the password.
						$pass = $show->PASSWORD;
					}
					$mailto = $info["email"];
					//$this->body .=  $mailto." is the mailto<br />\n";
					$subject = urldecode($this->messages[707]);
					$message = urldecode($this->messages[708])."\n".urldecode($this->messages[709]).": ".$show->USERNAME."\n";
					$message .= urldecode($this->messages[710]).": ".$pass."\n";
					$this->sendMail($mailto,$subject,$message);
					//API replaced with the Bridge Addon, 9/13/2007
					/*
					if ($this->db->get_site_setting('use_api')){
						$info = array_merge($info, $this->db->getDbInfo());
						
						//this is 2.0.x beta series, which gets its own install type.
						$info['installation_type'] = 16;
						$info['username'] = $show->USERNAME;
						$info['old_username'] = $show->USERNAME;
						$info['old_password'] = $show->PASSWORD;
						$info['password'] = $pass;
						include_once(CLASSES_DIR."api_update_user.php");
						$update_user = new API_update_user($info);
						$update_user->api_update_user_info(true);
						$this->db->close(true);
					}
					*/
					return true;
					
				}
				else
				{
					$this->error_message = urldecode($this->messages[351]);
					$this->lostpassword_form($db);
					exit;
					return false;
				}
			}
			else
			{
				//no account exist by that email address
				$this->error_message = urldecode($this->messages[351]);
				$this->lostpassword_form($db);
				exit;
				return false;
			}
		}
		else
		{
			//no email to send to
			$this->error_message = urldecode($this->messages[351]);
			$this->lostpassword_form($db);
			exit;
			return false;
		}
	} //end of function lostpassword

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function lostpassword_form ($db,$display_success=0)
	{
		$db = DataAccess::getInstance();
		
		$this->page_id = 40;
		$this->get_text();
		
		$view = geoView::getInstance();
		
		$tpl_vars = array();
		
		if (!$this->db->get_site_setting('forgot_password')){
			//password recovery tool turned off
			$tpl_vars['no_recovery'] = $this->messages[500105];
		} else {
			$tpl_vars['formTarget'] = $db->get_site_setting('classifieds_file_name')."?a=18";
			if (strlen($this->error_message) > 0) {
				$tpl_vars['error_message'] = $this->error_message;	
			}
			$tpl_vars['display_success'] = $display_success;
		}
		
		$view->setBodyTpl('lost_password.tpl','','authentication')->setBodyVar($tpl_vars);
		$this->display_page();

	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


	function already_logged_in($db, $user_id = 0)
	{
		$this->page_id = 39;
		$this->get_text();
		$tpl = new geoTemplate('system','authentication');

		$tpl->title = $this->messages[343];
		$tpl->css = 'page_description';
		$tpl->link = $this->db->get_site_setting('classifieds_url')."?a=17";
		$tpl->error = $this->messages[344];
		
		$this->body .=  $tpl->fetch('error.tpl');
		$this->userid = $user_id;
		$this->display_page();
	} //end of function auth_error

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function reset_language($db,$language_id=0)
	{
		if ($language_id) {
			$this->language_id = $language_id;
		} else {
			$this->language_id = 1;
		}
	}
	
	/**
	 * Handy little method that takes an array and converts it into a string
	 * expected by {@link Auth::login_form} 4th parameter (the URL to return to)
	 * 
	 * Note that this does NOT do any cleanup.
	 * 
	 * @param array $vars Array to convert, if not specified, will use $_GET
	 * @return string
	 */
	public static function generateEncodedVars($vars = null)
	{
		if ($vars === null) {
			$vars = $_GET;
		}
		if (count($vars) == 0) {
			return '';
		}
		return implode ('*and*',self::_encodeRecursive($vars));
	}
	
	/**
	 * Used by {@link Auth::urlEncodeVars()}
	 * 
	 * @param array $vars Assoc. array of vars
	 * @param string $parentKey the parents key
	 * @param array $parts the parts already encoded so far.
	 * @return array
	 */
	private static function _encodeRecursive ($vars, $parentKey = null, $parts = array())
	{
		foreach ($vars as $key => $value) {
			if ($parentKey) {
				$key = "{$parentKey}[$key]";
			}
			if (is_array($value)) {
				$parts = self::_encodeRecursive($value, $key, $parts);
			} else if (strlen($value.'')) {
				$parts[$key] = "$key*is*$value";
			}
		}
		return $parts;
	}

} //end of class Auth