<?php
//browse_display_ad.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21179              $ ##
## File last change date:       ##
##  $Date:: 2011-03-09 11:47:#$ ##
##                              ##
##################################

class Display_ad extends geoBrowse {
	var $subcategory_array = array();
	var $notify_data = array();
	
	var $ad_id;
	var $offsite_videos = null;
	var $offsite_videos_from_db = true;

	var $debug_ad_display = 0;
	var $debug_ad_display_time = 0;
	var $query_link = null;

//########################################################################

	public function __construct ($page=0, $classified_id=0)
	{
		$db = $this->db = DataAccess::getInstance();
		
		$classified_id = (int)$classified_id;
		if ($classified_id) {
			$listing = geoListing::getListing($classified_id);
			if ($listing && $listing->category) {
				$this->site_category = $listing->category;
			}
		} else {
			$this->site_category = 0;
		}
		
		$this->get_ad_configuration();
		if ($page) {
			$this->page_result = (int)$page;
		} else {
			$this->page_result = 1;
		}

		$this->ad_id = $this->classified_id = $classified_id;
		parent::__construct();
	} //end of function Display_ad

//###########################################################

	public function display_classified($id=0,$return=false,$preview = false, $autoDisplay = true, $session_vars = null, $printFriendly = false)
	{
		$db = DataAccess::getInstance();		
		$view = geoView::getInstance();
		if ($printFriendly) {
			//if print friendly, use page 69 and will also have to use
			//text specific to that page.
			$this->page_id = 69;
		} else {
			$this->page_id = 1;
		}
		
		if ($this->query_link === null) {
			//set query link, basically the URL that would go before query values
			if ($view->isAffiliatePage && $view->affiliate_id) {
				$this->query_link = $db->get_site_setting('affiliate_url').'?aff='.$view->affiliate_id.'&amp;';
			} else {
				$this->query_link = $db->get_site_setting('classifieds_file_name').'?';
			}
		}
		
		$this->get_text();
		$id = intval($id);
		$listing = geoListing::getListing($id);
		
		if (!$id || !$listing) {
			$this->browse_error();
			return true;
		}
		$must_have_subscription_to_view_ad_detail = $this->db->get_site_setting('must_have_subscription_to_view_ad_detail');
		
		if(($this->configuration_data['subscription_to_view_or_bid_ads'] || $must_have_subscription_to_view_ad_detail) && !geoSession::getInstance()->getUserID()) {
			//user not logged in!
			include_once("authenticate_class.php");
			$auth = new Auth($db,$this->language_id);
  			$auth->login_form($db, "", "", "a*is*2*and*b*is*".$id, 3);
			return true;
		}
		
		if ($must_have_subscription_to_view_ad_detail) {
			if (!$this->check_user_subscription()) {
				//user logged in, but doesn't have subscription, when using the setting
				//that user must have subscription to view listings.  Take them to subscription purchase page.
				header('Location: '.geoFilter::getBaseHref() . $this->db->get_site_setting('classifieds_file_name').'?a=cart&action=new&main_type=subscription');
				include GEO_BASE_DIR . 'app_bottom.php';
				exit;
			}
		}
		
		$show = $listing->toArray();
		$isPreview = false;
		if ($preview == 'preview_only') {
			$view->preview_text = $preview_text = $this->messages[500402];
			//let custom whatever's know this is a preview of a listing
			$view->preview_listing = $isPreview = 1;
			if ($session_vars) {
				//merge session vars onto show, by emulating what is done
				//at the time the listing is inserted into the DB
				require_once CLASSES_DIR . 'order_items/_listing_placement_common.php';
				$session_to_listing_key_map = _listing_placement_commonOrderItem::getSessionToListingKeyMap();
				$listing_vars_to_update = _listing_placement_commonOrderItem::getListingVarsToUpdate();
				
				foreach ($session_vars as $i => $val) {
					$keys = (isset($session_to_listing_key_map[$i]))? $session_to_listing_key_map[$i]: $i;
					$keys = (is_array($keys))? $keys : array($keys);
					//loop through each translation and set it, this allows one session var to be assigned to multiple
					//listing rows.
					foreach ($keys as $key) {
						if (isset($listing_vars_to_update[$key])) {
							
							//encode value according to what type it is
							switch($listing_vars_to_update[$key]){
								case 'toDB':
									if (is_array($val) && $key == 'seller_buyer_data' && geoPC::is_ent()) {
										//special case
										$val = serialize($val);
									}
									$show[$key] = trim(geoString::toDB($val));
									break;
								case 'int':
									$show[$key] = intval($val);
									break;
								case 'float':
									$show[$key] = floatval($val);
									break;
								case 'bool':
									$show[$key] = (($val)? 1: 0);
									break;
								default:
									//not altered, for fields like "date"
									
									$show[$key] = $val;
									break;
							}
						}
					}
					//fun hack: pretend the listing vars for the rest of the
					//page load are the real values, now anything that uses
					//geoListing will use the preview values...
					geoListing::addDataSet(array($show));
				}
			}
		} else if (geoPC::is_print() && $db->get_site_setting('disableAllBrowsing')) {
			//not supposed to show listing details on front side (but do allow
			//if previewing)
			$this->display_page();
			return true;
		}
		//lets clean up a few common vars so we don't do it over and over
		$precurrency = $show['precurrency'];
		$postcurrency = $show['postcurrency'];
		
		if ($this->debug_ad_display) {
			echo "data has been retrieved<br>";
			echo $listing->item_type." is the item_type<br>\n";	
		}
			
		if(geoPC::is_auctions()) {
			if ($show['start_time']) {
				$bid_start_date = date(trim($this->configuration_data['entry_date_configuration']),$show['start_time']);
				$time = $show['start_time'];
			} else {
				$bid_start_date = date(trim($this->configuration_data['entry_date_configuration']),$show['date']);
				$time = $show['date'];
			}
		}
		if (!(($show['live']==1 && $show['item_type']==1) || ($show['item_type']==2 || $show['item_type']==4) || $preview === 'preview_only')) {
			$this->browse_error();
			return true;
		}
		
		if ($this->debug_ad_display) {
			echo "listing is live<br>";
		}
		
		//get the next ad id within this category
		if ($this->configuration_data['display_sub_category_ads']) {
			$this->get_sql_in_statement($db,$show["category"]);
		} else {
			$this->in_statement = " in (".$show["category"].") ";
		}
		$filter_sql = $tables = '';
		$query_data = array();
      	if ($this->db->isBrowsingWhereClause()) {
      		$filters = $this->db->getBrowsingWhereClause();
			$filter_sql .= " AND ".$filters['sql'];
			foreach ($filters['data'] as $d) {
				$query_data[] = $d;
			}
			foreach ($filters['tables'] as $table) {
				$tables .= ', '.$table;
			}
		}
		$mainCheck = "`category` ".$this->in_statement;
      	if ($view->isAffiliatePage && $view->affiliate_id) {
      		//affiliate pages, get based on seller
      		$mainCheck = "`seller` = {$view->affiliate_id}";
      	}
      	
		$sql = "SELECT `id` FROM ".geoTables::classifieds_table."$tables WHERE
			$mainCheck AND `live` = 1 $filter_sql ORDER BY `better_placement` desc,date desc";
      	
		if ($this->debug_ad_display) echo $sql."<br/>\n";
		$next_id_result = $this->db->Execute($sql, $query_data);
		if (!$next_id_result) {
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			$this->error_message = $this->messages[81];
			return false;
		} else if ($next_id_result->RecordCount() > 1) {
			while ($next_id = $next_id_result->FetchNextObject()) {
				if ($next_id->ID == $id) {
					$next_id = $next_id_result->FetchNextObject();
					$next_classified_id = $next_id->ID;
					break;
				}
				$last_classified_id = $next_id->ID;
			}
		}
		if ($this->debug_ad_display) {
			echo $last_classified_id." is last<br/>\n";
			echo $next_classified_id." is next<br/>\n";
		}
		
		if(!$this->site_category) {
			//if category not set, might be in storefront or something
			//try to pull category from listing data
			$this->site_category = $show["category"];
		}
		
		if ($this->get_category_configuration($db,$this->site_category,0)) {
			if (!$this->category_configuration->USE_SITE_DEFAULT || !geoPC::is_ent())
			{
				$this->browsing_configuration = $this->ad_configuration_data;
			} else {
				$this->browsing_configuration = $this->category_configuration;
			}
		} else {
			//echo "no category<br/>\n";
			$this->browsing_configuration = $this->ad_configuration_data;
		}
		
		$category_tree = $this->category_tree_array = geoCategory::getTree($show["category"]);
		
		if ($category_tree) {
			//category tree
			if ($printFriendly) {
				$category_tree_fields = $this->messages[1101]." ".$this->messages[1100]." &gt; ";
			} else {
				$category_tree_fields = "".$this->messages[2]." <a href=\"{$this->query_link}a=5\" class=\"display_ad_category_tree\">".$this->messages[5]."</a> &gt; ";
			}
			if (is_array($this->category_tree_array)) {
				$i = 0;
				//$categories = array_reverse($this->category_tree_array);
				$i = count($this->category_tree_array);
				while ($i > 0 ) {
					//display all the categories
					$i--;
					if (!$printFriendly) {
						$category_tree_fields .= "<a href=\"{$this->query_link}a=5&amp;b=".$this->category_tree_array[$i]["category_id"]."&amp;page=".$this->page_result."\" class=\"display_ad_category_tree\">";
					}
					$category_tree_fields .= $this->category_tree_array[$i]["category_name"];
					if (!$printFriendly) {
						$category_tree_fields .= "</a>";
					}
					if ($i == 0) {
						//let view class know what the main cat name is
						$view->category_name = $category_tree[0]['category_name'];
					} else {
						$category_tree_fields .= " &gt; ";
					}
				}
			} else {
				$category_tree_fields = $category_tree;
			}
		}
		
		if ($this->debug_ad_display_time) echo $this->get_end_time()." after template gotten<br/>\n";
		
		if (($show["live"]) && ($show["start_time"] < geoUtil::time())) {
			if (geoSession::getInstance()->getUserID()) {
				//set single $can_bid variable here instead of checking invited and blacklist several times in function
				if ($this->debug_ad_display) {
					echo $this->configuration_data['black_list_of_buyers']." is to check blacklist<br/>\n";
					echo $this->configuration_data['invited_list_of_buyers']." is to check invited<br/>\n";
				}

				if ($this->configuration_data['invited_list_of_buyers']) {
					//check invited only
					if ($this->check_invitedlist($db,$show["seller"],geoSession::getInstance()->getUserID())) {
						if ($this->debug_ad_display)
							echo "this buyer is on the invited list 2<br/>";
						//this user is on the invited list
						$can_bid = 1;
					} else {
						if ($this->debug_ad_display)
							echo "not on the invited list so cannot bid<br/>\n";
						$error_msg = $this->messages[102862];
						$can_bid = 0;
					}
				} elseif ($this->configuration_data['black_list_of_buyers']) {
					//check black list only
					if ($this->debug_ad_display)
						echo "checking only black list of buyers<br/>\n";
					if ($this->check_blacklist($db,$show["seller"],geoSession::getInstance()->getUserID())) {
						if ($this->debug_ad_display)
							echo "this buyer is on the blacklist 2<br/>";
						$error_msg = $this->messages[102861];
						$can_bid = 0;
					} else {
						if ($this->debug_ad_display)
							echo "not on the blacklist so can bid<br/>\n";
						$can_bid = 1;
					}
				} else {
					//there are no restrictions on
					if ($this->debug_ad_display)
						echo "there are no lists to check<br/>";
					if ($show["start_time"] > geoUtil::time())
						$can_bid = 0;
					else
						$can_bid = 1;
				}
				if ($show["live"] && geoSession::getInstance()->getUserID() &&	$time!=0 && $time<geoUtil::time())
				{
					//set single $can_bid variable here instead of checking invited and blacklist several times in function
					if ($this->debug_display_auction)
					{
						echo $this->configuration_data['black_list_of_buyers']." is to check blacklist<br/>\n";
						echo $this->configuration_data['invited_list_of_buyers']." is to check invited<br/>\n";
					}
					if($this->configuration_data['black_list_of_buyers'] && $this->configuration_data['invited_list_of_buyers'])
					{
						//check blacklist and invited list
						$invited = $this->check_invitedlist($db,$show["seller"],geoSession::getInstance()->getUserID());
						$banned = $this->check_blacklist($db,$show["seller"],geoSession::getInstance()->getUserID());
						if ($this->debug_display_auction)
						{
							echo $banned." is banned<br/>\n";
							echo $invited." is invited<br/>\n";
						}
						if ($invited == 1)
						{
							if ($this->debug_display_auction)
								echo "this buyer is on the invited list<br/>";
							//this user is on the invited list
							$can_bid = 1;
						}
						else
						{
							if ($this->debug_display_auction)
								echo "this user is not on the invitedlist<br/>";
							if ($banned)
							{
								if ($this->debug_display_auction)
									echo "this buyer is on the blacklist<br/>";
								$error_msg = $this->messages[102861];
								$can_bid = 0;
							}
							else
							{
								//this user is not on the invited or
								if ($this->debug_display_auction)
								{
									echo "this user is not on the blacklist<br/>\n";
									echo "this buyer can bid -1<br/>\n";
								}
								if ($invited == 2)
									$can_bid = 1;
							}
						}
					}
					elseif ($this->configuration_data['invited_list_of_buyers'])
					{
						//check invited only
						if ($this->check_invitedlist($db,$show["seller"],geoSession::getInstance()->getUserID()))
						{
							if ($this->debug_display_auction)
								echo "this buyer is on the invited list 2<br/>";
							//this user is on the invited list
							$can_bid = 1;
						}
						else
						{
							if ($this->debug_ad_display)
								echo "not on the invited list so cannot bid<br/>\n";
							$error_msg = $this->messages[102862];
							$can_bid = 0;
						}
					}
					elseif ($this->configuration_data['black_list_of_buyers'])
					{
						//check black list only
						if ($this->debug_display_auction)
							echo "checking only black list of buyers<br/>\n";
						if ($this->check_blacklist($db,$show["seller"],geoSession::getInstance()->getUserID()))
						{
							if ($this->debug_display_auction)
								echo "this buyer is on the blacklist 2<br/>";
							$error_msg = $this->messages[102861];
							$can_bid = 0;
						}
						else
						{
							if ($this->debug_display_auction)
								echo "not on the blacklist so can bid<br/>\n";
							$can_bid = 1;
						}
					}
					else
					{
						//there are no restrictions on
						if ($this->debug_display_auction)
							echo "there are no lists to check<br/>";
						$can_bid = 1;
					}
				}
			}
			else
			{
				if ($this->debug_ad_display)
				{
					echo "false for checking blacklist and invited list<br/>";
					echo "---".$show["live"]." is live<br/>\n";
					echo "---".geoSession::getInstance()->getUserID()." is classified_user_id<br/>\n";
				}
				//we do not have the user id to check against so cannot say whether can bid or not
				$can_bid = 1;
			}
		}
		else
		{
			//this auction is not open so cannot be bid upon
			$can_bid = 0;
		}

		if ($this->debug_ad_display_time) echo $this->get_end_time()." after live check<br/>\n";

		//if auctions start is delayed till first bid then no start and end date is displayed.
		if ($show["delayed_start"] == 0)
		{
			$end_date = date(trim($this->configuration_data['entry_date_configuration']), $show["ends"]);
			$start_date = date(trim($this->configuration_data['entry_date_configuration']), $show["date"]);
		}
		else
		{
			$end_date = $this->messages[500225];//TODO: print text
			$start_date = $this->messages[500225];
		}
		$seller_data = $this->get_user_data($show["seller"]);

		if (($seller_data) && ($show["seller"]) && geoPC::is_ent() )
		{
			$sql = "select * from ".$this->user_groups_price_plans_table." where id = ".$show["seller"];
			$seller_group_result = $this->db->Execute($sql);
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			if (!$seller_group_result) {
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				return false;
			} elseif ($seller_group_result->RecordCount() ==1) {
				$show_group = $seller_group_result->FetchNextObject();
				$sql = "select sponsored_by_code from ".$this->groups_table." where group_id = ".$show_group->GROUP_ID;
				$sponsored_by_result = $this->db->Execute($sql);
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				if (!$sponsored_by_result) {
					if ($this->debug_ad_display) echo $sql."<br/>\n";
					return false;
				} elseif ($sponsored_by_result->RecordCount() ==1) {
					$sponsored_by_html = $sponsored_by_result->FetchNextObject();
					if (strlen(trim($sponsored_by_html->SPONSORED_BY_CODE)) > 0 ) {
						$view->sponsored_by = geoString::fromDB($sponsored_by_html->SPONSORED_BY_CODE);
					}
				}
			} else {
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				return false;
			}
		}
		
		if ($this->debug_ad_display_time) echo $this->get_end_time()." before image block created<br/>\n";
		$image_block = $this->display_ad_images($id);
		if ($this->debug_ad_display_time) echo $this->get_end_time()." after image block created and before lead image placed<br/>\n";
		
		foreach ($this->images_to_display as $imgData) {
			//find first image that is normal and would display in slideshow
			if (!strlen($imgData['icon']) && $imgData['id']) {
				//found it!
				$view->image_slideshow_link = "<a href='get_image.php?id=".(int)$imgData['id']."' class='lightUpLink autoStartSlideshow'>".$this->messages[500883]."</a>";
				break;
			}
		}
		
		
		if (($this->ad_configuration_data->LEAD_PICTURE_WIDTH) && ($this->ad_configuration_data->LEAD_PICTURE_HEIGHT))
		{
			if ($this->debug_ad_display) echo "<br/>TOP OF SECTION TO PLACE LEAD IMAGE TAG<br/>\n";
			if ($this->images_to_display[1]["type"])
			{
				//an image is within the first (lead) image slot
				if ($this->debug_ad_display)
				{
					echo $this->ad_configuration_data->LEAD_PICTURE_WIDTH." is the lead image width - LEAD_PICTURE_WIDTH<br/>\n";
					echo $this->ad_configuration_data->LEAD_PICTURE_HEIGHT." is the lead image height - LEAD_PICTURE_HEIGHT<br/>\n";
					echo $this->images_to_display[1]["type"]." is the lead image type[type]<br/>\n";
					echo $this->images_to_display[1]["thumb_url"]." is the thumb url[thumb_url]<br/>\n";
					echo $this->images_to_display[1]["url"]." is the url[url]<br/>\n";
					echo $this->images_to_display[1]["original_image_width"]." is original_image_width[original_image_width]<br/>\n";
					echo $this->images_to_display[1]["original_image_height"]." is original_image_height[original_image_height]<br/>\n";
					echo $this->images_to_display[1]["image_width"]." is image_width[image_width]<br/>\n";
					echo $this->images_to_display[1]["image_height"]." is image_height[image_height]<br/>\n";
					echo $this->images_to_display[1]["mime_type"]." is the mime_type<br/>\n";
				}
				$lead_image_tag = (isset($lead_image_tag))? $lead_image_tag: '';
				if ($this->debug_ad_display) echo $lead_image_tag." is the image tag at the top----------------------------<br/>\n";
				if (strlen(trim($this->images_to_display[1]["icon"])) > 0)
				{
					if ($this->debug_ad_display) echo " displaying the icon for the lead image<br/>\n";
					//$lead_image_tag = "<a href=\"".$this->images_to_display[1]["url"]."\">";
					$lead_image_tag .=  "<img src=\"".geoTemplate::getUrl('',$this->images_to_display[1]["icon"])."\" alt=\"\" />";
					//$lead_image_tag .= "</a>";
				}
				else
				{
					$lead_image = '';
					$dims = array();
					if($this->images_to_display[1]["type"] == 2) {
						$lead_image = "get_image.php?image=".$this->images_to_display[1]["id"];
						$dims = array('width' => $this->ad_configuration_data->LEAD_PICTURE_WIDTH, 'height' => $this->ad_configuration_data->LEAD_PICTURE_WIDTH);
					} elseif(strlen($this->images_to_display[1]["url"]) > 0) {
						//full image exists -- use it
						$lead_image = $this->images_to_display[1]["url"];
						$dims = geoImage::getScaledSize($this->images_to_display[1]["original_image_width"], $this->images_to_display[1]["original_image_height"], $this->ad_configuration_data->LEAD_PICTURE_WIDTH, $this->ad_configuration_data->LEAD_PICTURE_HEIGHT);
					} elseif(strlen($this->images_to_display[1]["thumb_url"]) > 0) {
						//no full image, but thumbnail is here for some reason, so try to fall back on it
						$lead_image = $this->images_to_display[1]["thumb_url"];
						$dims = geoImage::getScaledSize($this->images_to_display[1]["image_width"], $this->images_to_display[1]["image_height"], $this->ad_configuration_data->LEAD_PICTURE_WIDTH, $this->ad_configuration_data->LEAD_PICTURE_HEIGHT);
					}

					$lead_image_tag = geoImage::display_image( $lead_image, $dims['width'], $dims['height'], $this->images_to_display[1]["mime_type"]);
				}
				//$lead_image_tag .= "</a>";
				if ($this->debug_ad_display) echo $lead_image_tag." is the lead image tag<br/><br/>\n";
				if(geoPC::is_ent() || $printFriendly) {
					//show image for all versions if this is the print-friendly page
					$view->lead_picture = $lead_image_tag;
				}
			}
		} //end of if lead picture

		if ($this->debug_ad_display_time) echo $this->get_end_time()." after lead picture placed<br/>\n";
		$extra_question_block = $this->get_ads_extra_values($db,$id, $session_vars);
		
		$view->extra_question_name = $extra_question_block["names"];
		$view->extra_question_value = $extra_question_block["values"];
		//let them access the entire block if they want
		$view->extra_questions = $extra_question_block;
		
		$extra_checkbox_block = $this->get_ads_extra_checkboxes($db,$id, $session_vars);
		$view->extra_checkbox_name = $extra_checkbox_block;
		
		if ($this->debug_ad_display_time) echo $this->get_end_time()." after category specific built<br/>\n";

		if (strlen($this->messages[500798]) >0) {
			if ($show["sold_displayed"]) {
				$title = '<img src="'.geoTemplate::getUrl('',$this->messages[500798]).'" alt="" /> '.geoString::fromDB($show["title"]);
			} else {
				$title = geoString::fromDB($show["title"]);
			}
		} else {
			$title = geoString::fromDB($show["title"]);
		}

		//make sure auction is not a delayed start as "ends" = 0, not expired and is an auction
		// before displaying the closed message...classifieds do not need a closed message 
		if($preview != 'preview_only' && ($show["item_type"] == 2 || $show["item_type"] == 4) && ($show["ends"] <= geoUtil::time()) && ($show["delayed_start"] == 0)) {
			$title .= "&nbsp;<span class=\"closed_label\">{$this->messages[103369]}</span>";//TODO: print text
		}
		$view->title = $title;

		if (!$printFriendly && ((($this->fields->mapping_address->is_enabled) && (strlen(trim($show["mapping_address"])) > 0))
			|| (($this->fields->mapping_zip->is_enabled) && (strlen(trim($show["mapping_zip"])) > 0)))
			|| ($this->fields->mapping_state->is_enabled) && (strlen(trim($show["mapping_state"])) > 0)
			|| ($this->fields->mapping_city->is_enabled) && (strlen(trim($show["mapping_city"])) > 0))

		{
			//build mapquest link
			$mapquest_link = "<a href=\"javascript:winimage('http://www.mapquest.com/maps/map.adp?homesubmit=Get+Map";
			if($this->fields->mapping_address->is_enabled && strlen(trim($show["mapping_address"]))) {
				$mapquest_link .= "&amp;address=".urlencode(trim($show["mapping_address"]));
			}
			if($this->fields->mapping_city->is_enabled && strlen(trim($show["mapping_city"]))) {
				$mapquest_link .= "&amp;city=".urlencode(trim($show["mapping_city"]));
			}
			if($this->fields->mapping_state->is_enabled && strlen(trim($show["mapping_state"]))) {
				$mapquest_link .= "&amp;state=".urlencode(trim($show["mapping_state"]));
			}
			if (($this->fields->mapping_country->is_enabled) && (strlen(trim($show["mapping_country"])) > 0) && (trim($show["mapping_country"]) != "none"))
			{
				$sql = "select abbreviation from ".$this->countries_table." where name = \"".trim($show["mapping_country"])."\" or
					name = \"".trim(urldecode($show["mapping_country"]))."\"";
				$country_abbreviation_result = $this->db->Execute($sql);
				if (!$country_abbreviation_result)
				{
					$mapquest_link .= "&amp;country=".urlencode(trim($show["mapping_country"]));
				}
				elseif ($country_abbreviation_result->RecordCount() == 1)
				{
					$show_abbreviation = $country_abbreviation_result->FetchRow();
					$mapquest_link .= "&amp;country=".urlencode(trim($show_abbreviation["abbreviation"]));
				}
				else
				{
					$mapquest_link .= "&amp;country=".urlencode(trim($show["mapping_country"]));
				}
			}
			if (($this->fields->mapping_zip->is_enabled) && (strlen(trim($show["mapping_zip"])) > 0)) {
				$mapquest_link .= "&amp;zipcode=".urlencode(trim($show["mapping_zip"]));
			}
			$mapquest_link .= "','800','800')\" class=\"mapping_link\">".$this->messages[1624]."</a>";
			$view->mapping_link = $mapquest_link;
		}
		
		if ($this->fields->tags->is_enabled) {
			if ($isPreview && isset($session_vars['tags'])) {
				//loaded from session vars since it is preview
				$tags = explode(', ', $session_vars['tags']);
			} else {
				//get tags from db
				
				$tags = geoListing::getTags($id);
			}
			//Add the array of tags for template designers to play with
			$view->listing_tags_array = $tags;
			
			if (count($tags) > 0) {
				$tpl = new geoTemplate ('system','listing_details');
				$tpl->listing_tags_array = $tags;
				$view->listing_tags_links = $tpl->fetch('listing_tags_links.tpl');
				$view->listing_tags_list = $tpl->fetch('listing_tags_list.tpl');
				$view->listing_tags_label = $this->messages[500869];
			} else {
				$view->listing_tags_label = $view->listing_tags_links = $view->listing_tags_list = '';
			}
		}
		
		if ($this->fields->mapping_address->is_enabled && $show["mapping_address"]) {
			$view->mapping_address = geoString::fromDB($show["mapping_address"]);
		}

		if ($this->fields->mapping_zip->is_enabled && $show["mapping_zip"]) {
			$view->mapping_zip = geoString::fromDB($show["mapping_zip"]);
		}

		if ($this->fields->mapping_state->is_enabled && $show["mapping_state"]) {
			$view->mapping_state = geoString::fromDB($show["mapping_state"]);
		}

		if ($this->fields->mapping_city->is_enabled && $show["mapping_city"]) {
			$view->mapping_city = geoString::fromDB($show["mapping_city"]);
		}

		if ($this->fields->mapping_country->is_enabled && $show["mapping_country"]) {
			$view->mapping_country = geoString::fromDB($show["mapping_country"]);
		}


		$view->stats_remaining_label = ($printFriendly)? $this->messages[103325]: $this->messages[102705];
		$view->time_remaining_label = ($printFriendly)? $this->messages[103325]: $this->messages[102705];
		if ($show["delayed_start"] == 0)
		{
			//only need to display the time remaining if the auction has started or is normal
			// Time remaining
			// Find weeks left
			$weeks = $this->DateDifference('w',geoUtil::time(),$show["ends"]);
			$remaining_weeks = ($weeks * 604800);
	
			// Find days left
			$days = $this->DateDifference('d',(geoUtil::time()+$remaining_weeks),$show["ends"]);
			$remaining_days = ($days * 86400);
	
			// Find hours left
			$hours = $this->DateDifference('h',(geoUtil::time()+$remaining_days),$show["ends"]);
			$remaining_hours = ($hours * 3600);
	
			// Find minutes left
			$minutes = $this->DateDifference('m',(geoUtil::time()+$remaining_hours),$show["ends"]);
			$remaining_minutes = ($minutes * 60);
	
			// Find seconds left
			$seconds = $this->DateDifference('s',(geoUtil::time()+$remaining_minutes),$show["ends"]);
			
			$weeks_label = ($printFriendly)? $this->messages[103327]: $this->messages[103191];
			$days_label = ($printFriendly)? $this->messages[103328]: $this->messages[103192];
			$hours_label = ($printFriendly)? $this->messages[103329]: $this->messages[103193];
			$minutes_label = ($printFriendly)? $this->messages[103323]: $this->messages[103194];
			$seconds_label = ($printFriendly)? $this->messages[103324]: $this->messages[103195];
			
			$time_left = '';
			
			if ($weeks > 0) {
				$time_left .= "$weeks $weeks_label, $days $days_label";
			} elseif ($days > 0) {
				$time_left .= "$days $days_label, $hours $hours_label";
			} elseif ($hours > 0) {
				$time_left .= "$hours $hours_label, $minutes $minutes_label";
			} elseif ($minutes > 0) {
				$time_left .= "$minutes $minutes_label, $seconds $seconds_label";
			} elseif ($seconds > 0) {
				$time_left .= "$seconds $seconds_label";
			}			
			$view->stats_remaining = "<div style=\"white-space: nowrap; \">".$time_left."</div>";
			$view->time_remaining = "<div style=\"white-space: nowrap; \">".$time_left."</div>";
		} else {
			//TODO: print friendly text
			$view->stats_remaining = "<div style=\"white-space: nowrap; \">".$this->messages[500225]."</div>";
			$view->time_remaining = "<div style=\"white-space: nowrap; \">".$this->messages[500225]."</div>";			
		}
		$view->date_ended = $end_date;
		$view->date_ended_label = ($printFriendly)? $this->messages[103088]: $this->messages[102701];
		
		if ( geoPC::is_ent() ) {
			$txt_id = ($printFriendly)? 1090: 912;
			for ($i = 1; $i <= 20; $i++) {
				$v_item = "optional_field_{$i}";
				
				$val = geoString::fromDB($show[$v_item]);
				if ($this->fields->$v_item->is_enabled && trim($val)) {
					if ($this->fields->$v_item->field_type=='cost') {
						//adds cost
						$val = geoString::displayPrice($val,$precurrency, $postcurrency);
					}
					$label = "optional_field_{$i}_label";
					$view->$label = $this->messages[$txt_id];
					$view->$v_item = $val;
				}
				$txt_id++;
				if (($printFriendly && $txt_id == 1100) || $txt_id == 922) {
					$txt_id = ($printFriendly)? 1706: 1726;
				}
			}
		}
		if ($this->fields->address->is_enabled && $show["location_address"]) {
			$view->address_label = $this->messages[500163];//TODO: Print friendly text
			$view->address_data = ucwords(geoString::fromDB($show["location_address"]));
		}
		if ($this->fields->city->is_enabled && $show["location_city"]) {
			$view->city_label = ($printFriendly)? $this->messages[1468]: $this->messages[1213];
			$view->city_data = ucwords(geoString::fromDB($show["location_city"]));
		}
		if ($this->fields->state->is_enabled && $show["location_state"]) {
			$view->state_label = ($printFriendly)? $this->messages[1478]: $this->messages[1214];
			$view->state_data = geoString::fromDB($show["location_state"]);
		}
		if ($this->fields->country->is_enabled && $show["location_country"]) {
			$view->country_label = ($printFriendly)? $this->messages[1080]: $this->messages[1215];
			$view->country_data = geoString::fromDB($show["location_country"]);
		}
		if ($this->fields->zip->is_enabled && $show["location_zip"]) {
			$view->zip_label = ($printFriendly)? $this->messages[1479]: $this->messages[1216];
			$view->zip_data = geoString::fromDB($show["location_zip"]);
		}
		
		//if($show["item_type"]==1)
		$view->classified_id_label = ($printFriendly)? $this->messages[1082]: $this->messages[8];
		//if($show["item_type"]==1)
		$view->classified_id = $show["id"];
		$view->viewed_count_label = ($printFriendly)? $this->messages[1084]: $this->messages[10];
		$view->viewed_count = $show["viewed"] + 1;
		
		
		
		if ($show["seller"] != 0) {			
			$view->seller_label = ($printFriendly)? $this->messages[1078]: $this->messages[3];
			$view->seller = "<a href=\"{$this->query_link}a=13&amp;b=".$id."\" class=\"display_ad_value\">".$seller_data->USERNAME."</a>";
		}
		
		if(geoPC::is_auctions()) {
			$view->bid_start_date_label = ($printFriendly)? $this->messages[103326]: $this->messages[102819];
			$view->bid_start_date = $bid_start_date;
			if ($time==0 || $time>geoUtil::time()) {
				$can_bid = 0;
			} else if ($can_bid && !$show["delayed_start"] && $show["ends"] <= geoUtil::time()) {
				//it's live and all that, but the end date was in the past, and this isn't a delayed start auction
				$can_bid = 0;
			}
		}
		$view->date_started_label = ($printFriendly)? $this->messages[1079]: $this->messages[4];
		$view->date_started = $start_date;
		
		$view->description_label = ($printFriendly)? $this->messages[1081]: $this->messages[7];
		$view->description = geoString::fromDB($show["description"]);

		if ($this->debug_ad_display_time) echo $this->get_end_time()." after most fields placed<br/>\n";

		//classauctions details
		if ($show["item_type"]==1) {
			if ($this->fields->price->is_enabled) {
				$view->price_label = ($printFriendly)? $this->messages[1085]: $this->messages[15];
				$display_amount = geoString::displayPrice($show["price"],$precurrency,$postcurrency);
				$view->price = $display_amount;
			}
		}

		if ((geoPC::is_auctions())) {
			// Feedback
			// Will display on both the auctions and classifieds
			$view->seller_rating_label = ($printFriendly)? $this->messages[103092]: $this->messages[102704];
			

			if ($this->debug_ad_display) {
				echo $seller_data->FEEDBACK_COUNT." is the FEEDBACK_COUNT<br/>\n";
				echo $seller_data->FEEDBACK_SCORE." is FEEDBACK_SCORE<br/>\n";
			}
			$scoreLink = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=1030&amp;b=".$id."&amp;d=".$show["seller"]."\" class=\"display_auction_value\">".$seller_data->FEEDBACK_SCORE."</a>";
			$countLink = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=1030&amp;b=".$id."&amp;d=".$show["seller"]."\" class=\"display_auction_value\">".$seller_data->FEEDBACK_COUNT."</a>";
			if (($seller_data->FEEDBACK_SCORE > 0) && ($seller_data->FEEDBACK_COUNT != 0)) {
				$sql = "select filename from ".$this->auctions_feedback_icons_table." where begin <= ".$seller_data->FEEDBACK_SCORE." AND end >= ".$seller_data->FEEDBACK_SCORE;
				$result = $this->db->Execute($sql);
				if(!$result)
					$image = "";
				else
				{
					$result_img = $result->FetchNextObject();
					$image = "<img src=\"".geoTemplate::getUrl('',$result_img->FILENAME)."\" style=\"vertical-align: text-bottom;\" alt=\"feedback icon\" />";
				}
				if ($this->debug_ad_display)
				{
					echo $result->RecordCount()." is the record count<br/>\n";
				}
				$view->seller_rating = $scoreLink.$image;
			} else if (($seller_data->FEEDBACK_SCORE == 0) || ($seller_data->FEEDBACK_COUNT == 0)) {
				$sql = "select filename from ".$this->auctions_feedback_icons_table." where begin = 0";
				$result = $this->db->Execute($sql);
				if(!$result) {
					$image = "";
				} else {
					$result_img = $result->FetchNextObject();
					$image = "<img style=\"vertical-align: text-bottom;\" src=\"".geoTemplate::getUrl('',$result_img->FILENAME)."\"  alt=\"feedback icon\" />";
				}
				$view->seller_rating = $scoreLink.$image;
			} else if ($seller_data->FEEDBACK_SCORE < 0) {
				$sql = "select filename from ".$this->auctions_feedback_icons_table." where begin = -1";
				$result = $this->db->Execute($sql);
				if(!$result) {
					$image = "";
				} else {
					$result_img = $result->FetchNextObject();
					$image = "<img style=\"vertical-align: text-bottom;\" src=\"".geoTemplate::getUrl('',$result_img->FILENAME)."\"  alt=\"feedback icon\" />";
				}
				$view->seller_rating = $scoreLink.$image;
			} else {
				$view->seller_rating = ($printFriendly)? $this->messages[103110]: $this->messages[102716];
			}
			if (!$printFriendly) {
				$view->feedback_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1030&amp;b=".$id."&amp;d=".$show["seller"]."\" class=\"display_auction_value\">{$this->messages[102717]}</a>";
			}
			$view->seller_number_rates_label = ($printFriendly)? $this->messages[103093]: $this->messages[102714];
			$view->seller_number_rates = $countLink;
		
			if (!$printFriendly) $view->seller_rating_scale_explanation = $this->display_help_link(102826);
		}

		//auctions details
		if ($show["item_type"] == 2) {
			if ($show["minimum_bid"] < $show["starting_bid"]) {
				$minimum_bid = $show["starting_bid"];
			} else {
				$minimum_bid = $show["minimum_bid"];
			}

			//check reserve price
			if ($show["reserve_price"] != 0.00) {
				if ($show["current_bid"] >= $show["reserve_price"]) {
					//reserve met
					$reserve = ($printFriendly)? $this->messages[103072]: $this->messages[102694];
				} else {
					//reserve not yer met
					$reserve = ($printFriendly)? $this->messages[103073]: $this->messages[102695];
				}
			} else {
				$reserve = "";
			}

			if(!$show["buy_now_only"]) {
				$view->reserve = $reserve;
			}
		
			$view->auction_type_help = $this->display_help_link(103056);

			if ($show["auction_type"] == 1)
				$type_of_auction = ($printFriendly)? $this->messages[200130]: $this->messages[102707];
			else
				$type_of_auction = ($printFriendly)? $this->messages[200131]: $this->messages[102708];

			if(!$show["buy_now_only"]) {
				$view->num_bids_label = ($printFriendly)? $this->messages[103083]: $this->messages[102696];
				$view->high_bidder_label = ($printFriendly)? $this->messages[103112]: $this->messages[102697];

				if ($show["current_bid"] == 0 && $show["auction_type"] != 2)
				{
					//no bids recieved
					$view->num_bids = ($printFriendly)? $this->messages[103113]: $this->messages[103002];
					//no high bidder
					$view->high_bidder = ($printFriendly)? $this->messages[103113]: $this->messages[103002];
				}
				else
				{
					$number_of_bids = $this->get_number_of_bids($db,$id);
					$view->num_bids = $number_of_bids;
					$high_bidder = $this->get_high_bidder_username($db,$id);
					$view->high_bidder = $high_bidder;
				}
			}
			if ($this->debug_ad_display) {
				echo $show["buy_now"]." is \$show[\"buy_now\"]<br>\n";
				echo $show["buy_now_only"]." is buy_now_only<br>\n";
				echo $show["current_bid"]." is \$show[\"current_bid\"]<bR>\n";
				echo $show["auction_type"]." is \$show[\"auction_type\"]<br>\n";
			}
			$buy_now_link_txt = ($printFriendly)? $this->messages[103078]: $this->messages[102718];
			$buy_now_label_txt = ($printFriendly)? $this->messages[200133]: $this->messages[102698];
			if ($show["auction_type"] == 1) {
				if (($show["current_bid"] != 0) && (!$show["buy_now_only"])) {
					if ($show["buy_now"] != 0) {
						if(($this->configuration_data['buy_now_reserve'] != 0) && ($show["current_bid"] < $show["reserve_price"])) {
							//Check for black list and invited list of buyers
							//Show only when not in blacklist but in invited list
							$view->buy_now_label = $buy_now_label_txt;
							$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
							$view->buy_now_data = $display_amount;
							if($can_bid && $show["live"]) {
								if (geoSession::getInstance()->getUserID()) {
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								} else {								
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								}
							}
						} else if(($this->configuration_data['buy_now_reserve'] == 0) && ($show["current_bid"] == 0.00)) {
							//Check for black list and invited list of buyers
							//Show only when not in blacklist but in invited list
							$view->buy_now_label = $buy_now_label_txt;
							$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
							$view->buy_now_data = $display_amount;
							if($can_bid && $show["live"]) {
								if (geoSession::getInstance()->getUserID()) {
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								} else {								
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								}
							}
						}
					}
				} else {
					//display buy now if not 0
					if (($show["buy_now"] != 0) && ($show["auction_type"] == 1) && ($show["live"] == 1)) {
						//sunit
						//Check for black list and invited list of buyers
						//Show only when not in blacklist but in invited list
						$view->buy_now_label = $buy_now_label_txt;
						$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
						$view->buy_now_data = $display_amount;
						if($can_bid) {
							if (geoSession::getInstance()->getUserID()) {
								$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
							} else {								
								$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
							}
						}
					}
				}
			} else {
				if ($show["buy_now_only"])
					return false;

				 //Get dutch winners
				$sql = "select * from ".$this->bid_table." where auction_id=".$show["id"]." order by bid desc,time_of_bid asc";
				$bid_result = $this->db->Execute($sql);
				if (!$bid_result){
					echo $sql;
					return false;
				} elseif ($bid_result->RecordCount() > 0) {
					$total_quantity = $show["quantity"];
					//echo "total items sold - ".$total_quantity."<br/>\n";
					$final_dutch_bid = 0;
					$seller_report = "";
					$show_bidder = $bid_result->FetchNextObject();
					$quantity_bidder_receiving = 0;
					do {
						if ( $show_bidder->QUANTITY <= $total_quantity )
						{
							$quantity_bidder_receiving = $show_bidder->QUANTITY ;
							if ( $show_bidder->QUANTITY == $total_quantity )
							{
								$final_dutch_bid = $show_bidder->BID;
								//echo $final_dutch_bid." is final bid after total = bid quantity<br/>\n";
							}
							$total_quantity = $total_quantity - $quantity_bidder_receiving;
						}
						else
						{
							$quantity_bidder_receiving = $total_quantity;
							$total_quantity = 0;
							$final_dutch_bid = $show_bidder->BID;
							//echo $final_dutch_bid." is final bid after total < bid quantity<br/>\n";
						}

						$local_key = count($this->dutch_bidders);
						$this->dutch_bidders[$local_key]["bidder"] = $show_bidder->BIDDER;
						$this->dutch_bidders[$local_key]["quantity"] = $quantity_bidder_receiving;
						$this->dutch_bidders[$local_key]["bid"] = $show_bidder->BID;
						$bidder_info = $this->get_user_data($show_bidder->BIDDER);
					} while (($show_bidder = $bid_result->FetchNextObject()) && ($total_quantity != 0) && ($final_dutch_bid == 0));
				}

				if (count($this->dutch_bidders) > 0) {
					//display the current winning bidders
					
					foreach ($this->dutch_bidders as $key => $value) {
						//set the user info for each one, that is not typically gotten
						$user = geoUser::getUser($value['bidder']);
						if ($user) {
							//let the template have access to all user data, to allow more
							//customization options
							$this->dutch_bidders[$key]['bidder_info'] = $user->toArray();
						}
						$this->dutch_bidders[$key]['bid_display'] = geoString::displayPrice($value['bid'], $precurrency,$postcurrency);
					}
					$dutch_tpl = new geoTemplate('system','browsing');
					$dutch_tpl->dutchBidders = $this->dutch_bidders;
					$dutch_tpl->printFriendly = $printFriendly;
					$txt = array(
						'userColumn' => (($printFriendly)? $this->messages[103366] : $this->messages[102711]),
						'priceColumn' => (($printFriendly)? $this->messages[103079] : $this->messages[102712]),
						'quantityColumn' => (($printFriendly)? $this->messages[103080] : $this->messages[102713]),
					);
					$dutch_tpl->col_txt = $txt;
					
					$view->winning_dutch_bidders = $dutch_tpl->fetch('listing_details/winning_dutch_bidders.tpl');
					$view->winning_dutch_bidders_label = ($printFriendly)? $this->messages[103081]: $this->messages[102709];
				} else {
					$view->winning_dutch_bidders = ($printFriendly)? $this->messages[103366]: $this->messages[102710];
					$view->winning_dutch_bidders_label = ($printFriendly)? $this->messages[103082]: $this->messages[102709];
				}
			}
		}
		
		if ($show["item_type"] == 4) {
			//reverse auctions
			if ($show["minimum_bid"] > $show["starting_bid"]) {
				$minimum_bid = $show["starting_bid"];
			} else {
				$minimum_bid = $show["minimum_bid"];
			}

			//check reserve price
			if ($show["reserve_price"] != 0.00) {
				if (($show["current_bid"] <= $show["reserve_price"]) && ($show["current_bid"] != 0.00)){
					//reserve met
					$reserve = ($printFriendly)? $this->messages[103072]: $this->messages[102694];
				} else {
					//reserve not yer met
					$reserve = ($printFriendly)? $this->messages[103073]: $this->messages[102695];
				}
			} else {
				$reserve = "";
			}
			
			if(!$show["buy_now_only"]) {
				$view->reserve = $reserve;
			}			
			
			//use the "standard" auction type label until text is completely added for reverse auctions
			$type_of_auction = ($printFriendly)? $this->messages[200130]: $this->messages[102707];
			
			if (!$printFriendly) {
				$view->auction_type_help = $this->display_help_link(103056);
			}
			if ($this->debug_ad_display) {
				echo $show["buy_now"]." is \$show[\"buy_now\"]<br>\n";
				echo $show["buy_now_only"]." is buy_now_only<br>\n";
				echo $show["current_bid"]." is \$show[\"current_bid\"]<bR>\n";
				echo $show["auction_type"]." is \$show[\"auction_type\"]<br>\n";
				echo $show["reserve_price"]." is \$show[\"reserve_price\"]<br>";
			}
			
			if (($show["current_bid"] != 0) && ($show["buy_now_only"] != 0)) {
				if ($show["buy_now"] != 0) {
					if(($this->configuration_data['buy_now_reserve'] != 0) && ($show["current_bid"] < $show["reserve_price"])) {
						//Check for black list and invited list of buyers
						//Show only when not in blacklist but in invited list
						$view->buy_now_label = $buy_now_label_txt;
						if (geoSession::getInstance()->getUserID()) {
							if($can_bid) {
							  $display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
								$view->buy_now_data = $display_amount;
								if ($show["live"]) {
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								}
							} else {
								$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
								$view->buy_now_data = $display_amount;
							}
						} else {
							$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
							$view->buy_now_data = $display_amount;
							if ($show["live"]){
								$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
							}
						}
					} else if(($this->configuration_data['buy_now_reserve'] == 0) && ($show["current_bid"] == 0.00)) {
						//Check for black list and invited list of buyers
						//Show only when not in blacklist but in invited list
						$view->buy_now_label = $buy_now_label_txt;
						if (geoSession::getInstance()->getUserID()) {
							if($can_bid) {
								$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
								$view->buy_now_data = $display_amount;
								if ($show["live"])
								{
									$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
								}
							} else {
								$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
								$view->buy_now_data = $display_amount;
							}
						} else {
							$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
							$view->buy_now_data = $display_amount;
							if ($show["live"]){
								$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
							}
						}
					}
				}
			} else {
				//display buy now if not 0
				if (($show["buy_now"] != 0) && ($show["live"] == 1)) {
					//sunit
					//Check for black list and invited list of buyers
					//Show only when not in blacklist but in invited list
					$view->buy_now_label = $buy_now_label_txt;
					$display_amount = geoString::displayPrice($show["buy_now"],$precurrency,$postcurrency);
					$view->buy_now_data = $display_amount;

					if (geoSession::getInstance()->getUserID()) {
						if($can_bid) {
							$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$show["id"]."&amp;d=1\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
						} else {
						}
					} else {
						$view->buy_now_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$show["id"]."*and*d*is*1")."\" class=\"button buy_now_link\">".$buy_now_link_txt."</a>";
					}
				}
			}
		}
		if ($show["item_type"] == 4 || $show["item_type"] == 2) {
			if ($this->debug_ad_display_time) echo $this->get_end_time()." after bidding info placed<br/>\n";
			$view->quantity_label = ($printFriendly)? $this->messages[103084]: $this->messages[102699];
			$view->quantity = $show["quantity"];
			
			if($this->configuration_data['bid_history_link_live'] == 1 && !$printFriendly && $show['buy_now_only'] != 1) {
				if ($this->debug_ad_display) echo "BID_HISTORY_LINK replace 1<br/>\n";
				$view->bid_history_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1031&amp;b=$id\" class=\"bid_history_link\">".$this->messages[102706]."</a>";
			} else {
				if ($this->debug_ad_display) echo "BID_HISTORY_LINK replace 2<br/>\n";
				$view->bid_history_link = "&nbsp;";
			}
			
			//on-site payment link
			$on_site_purchase_link = '';
			if (!$printFriendly && geoPC::is_ent() && !$show["live"] && $show["item_type"] == 2 && (!$show["start_time"] || $show["start_time"] < geoUtil::time())
				 && $this->dutch_bidders == 0 &&  ($show['reserve_price'] <= $show['final_price'])){
				//check to see if current bidder is high bidder
				$bidder_info = $this->get_high_bidder(0,$id);
				if ($bidder_info['bidder'] == geoSession::getInstance()->getUserID() || geoSession::getInstance()->getUserID() == 1){
					//current bidder
					$payment_link_vars = array (
						'listing_id' => $show["id"],
						'winning_bidder_id' => $bidder_info['bidder'],
						'listing_details' => $show,
						'final_price' => $bidder_info['bid'],
						'current_user' => geoSession::getInstance()->getUserID()
					);
					$on_site_purchase_link = geoSellerBuyer::callDisplay('displayPaymentLinkListing',$payment_link_vars);
				}
			}
			$view->on_site_purchase_link = $on_site_purchase_link;
			$view->auction_type_label = ($printFriendly)? $this->messages[103087]: $this->messages[102700];
			$view->auction_type_data = $type_of_auction;
			
			if(!$show['buy_now_only']) {
				$view->minimum_label = ($printFriendly)? $this->messages[103089]: $this->messages[102702];
				$display_amount = geoString::displayPrice($minimum_bid,$precurrency,$postcurrency);
				$view->minimum_bid = $display_amount;
				
				$view->starting_label = ($printFriendly)? $this->messages[103091]: $this->messages[102703];
				$display_amount = geoString::displayPrice($show["starting_bid"],$precurrency,$postcurrency);
				$view->starting_bid = $display_amount;
			}

			if(geoSession::getInstance()->getUserID() == $show["seller"]) {
				$view->reserve_label = ($printFriendly)? $this->messages[103090]: $this->messages[102966];
				$display_amount = geoString::displayPrice($show["reserve_price"],$precurrency,$postcurrency);
				$view->reserve_bid = $display_amount;
			}
			
			
			if ($this->debug_ad_display_time) echo $this->get_end_time()." after pricing placed<br/>\n";

			if ($show["live"] == 1) {
			// && (($show["ends"] == 0 && $show["delayed_start"] == 1) || $show["ends"] >= geoUtil::time())) 
				if ($this->debug_ad_display) {
					echo "checking live to display bid and history links<br/>";
					echo "---".$show["live"]." is live<br/>\n";
					echo "---".geoSession::getInstance()->getUserID()." is classified_user_id<br/>\n";
				}
				//Check for black list and invited list of buyers
				if ($printFriendly) {
					if (!$show['live']) {
						//don't do make bid link if not live and print friendly view
					} else if ($show['buy_now_only']) {
						$view->make_bid_link = $this->messages[200133];
					} else {
						$view->make_bid_link = $this->messages[103095];
					}
				} else if (geoSession::getInstance()->getUserID()) {
					if($can_bid) {
						if ($show["buy_now_only"]) {
							//only the buy now button should appear
							$make_bid_link = "";
						} else {
							$make_bid_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1029&amp;b=".$id."\" class=\"button make_bid_link\">".$this->messages[102719]."</a>";
						}
						$view->make_bid_link = $make_bid_link;
					} else {
						$view->make_bid_link = $error_msg."&nbsp;".$this->messages[102863];
					}
				} else {
					if (($show["live"]) && ($show["start_time"] < geoUtil::time()) && !$show["buy_now_only"]) {
						$make_bid_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=10&amp;c=".urlencode("a*is*1029*and*b*is*".$id)."\" class=\"button make_bid_link\">".$this->messages[102719]."</a>";
					} else {
						$make_bid_link = "";
					}
					$view->make_bid_link = $make_bid_link;
				}
				if (!$printFriendly) {
					if($this->configuration_data['bid_history_link_live'] == 1 && !$show["buy_now_only"]) {
						if ($this->debug_ad_display) echo "BID_HISTORY_LINK replace 3<br/>\n";
						$view->bid_history_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1031&amp;b=".$id."\" class=\"bid_history_link\">".$this->messages[102706]."</a>";
					} else {
						if ($this->debug_ad_display) echo "BID_HISTORY_LINK replace 4<br/>\n";
						$view->bid_history_link = "&nbsp;";
					}
				}
			} else {
				if ($this->debug_ad_display) {
					echo "not live for checking to display bid and history links<br/>";
					echo "---".$show["live"]." is live<br/>\n";
					echo "---".geoSession::getInstance()->getUserID()." is classified_user_id<br/>\n";
				}
				$view->favorites_link = "&nbsp;";
				$view->notify_friend_link = "&nbsp;";
				
				if (!$printFriendly) {
					$view->bid_history_link = "<a href=\"".$this->db->get_site_setting('classifieds_file_name')."?a=1031&amp;b=".$id."\" class=\"bid_history_link\">".$this->messages[102706]."</a>";
				}
			}
		}
		
		//payment_types
		if($this->fields->payment_types->is_enabled) {
			//payment_types - both on and off-site combined (for now)
			//in future may seperate them if there is a demand, for now they
			//are displayed in the same list.
			$payment_options = array();
			if (($show["item_type"] == 4 || $show["item_type"] == 2) && geoPC::is_ent()){
				//on-site payment options
				$vars = array (
					'listing_id' => $id,
				);
				$this_payment_options = geoSellerBuyer::callDisplay('displayPaymentTypesListing', $vars, ', ');
				if (strlen($this_payment_options) > 0){
					$payment_options[0] = $this_payment_options;
				}
			}
			
			
			//off-site payment options
			$show["payment_options"] = geoString::fromDB($show["payment_options"]);
			$this_payment_options = str_replace("||",", ",$show["payment_options"]);
			if (strlen($this_payment_options) > 0){
				$payment_options[1] = $this_payment_options;
			}
			if (trim(implode(' ',$payment_options))) {
				$view->payment_options_label = ($printFriendly)? $this->messages[103086]: $this->messages[102853];
				$view->payment_options = implode(', ',$payment_options);
			}
		}
		
		$member_since = date(trim($this->configuration_data['member_since_date_configuration']), $seller_data->DATE_JOINED);
		$view->member_since = $member_since;
		$view->image_block = $image_block;
		
		$view->image_block_large = geoImage::displayImageBlockLarge($show['id']);
		$view->image_block_large_link = geoImage::displayImageBlockLargeLink($show['id']);
		
		$view->category_tree = $category_tree_fields;
		
		if ($this->fields->email->display_locations && ($show["expose_email"]) && $show["email"]) {
			$view->public_email_label = ($printFriendly)? $this->messages[1474]: $this->messages[1344];
			$view->public_email = geoString::fromDB($show["email"]);
		}

		if ($this->fields->phone_1->is_enabled && $show["phone"]) {
			$view->phone_label = ($printFriendly)? $this->messages[1475]: $this->messages[1347];
			$formatted_phone_number = $this->format_phone_data(geoString::fromDB($show["phone"]));
			$view->phone_data = $formatted_phone_number;
		}

		if ($this->fields->phone_2->is_enabled && $show["phone2"]) {
			$view->phone2_label = ($printFriendly)? $this->messages[1476]: $this->messages[1348];
			$formatted_phone_number = $this->format_phone_data(geoString::fromDB($show["phone2"]));
			$view->phone2_data = $formatted_phone_number;
		}

		if ($this->fields->fax->is_enabled && $show["fax"]) {
			$view->fax_label = ($printFriendly)? $this->messages[1477]: $this->messages[1349];
			$formatted_phone_number = $this->format_phone_data(geoString::fromDB($show["fax"]));
			$view->fax_data = $formatted_phone_number;
		}

		if ($this->fields->url_link_1->is_enabled) {
			if (strlen(trim($show["url_link_1"])) > 0) {
				$url = trim(geoString::fromDB($show['url_link_1']));
				
				if (stripos($url, 'http://') !== 0 && stripos($url, 'https://') !== 0) {
					$url = 'http://'.$url;
				}
				
				$view->url_link_1 = "<a class=\"url_link_1\" href=\"$url\" onclick=\"window.open(this.href,'mywindow','toolbar=yes,location=yes,menubar=yes,scrollbars=yes,resizable=yes'); return false;\">".$this->messages[2440]."</a>";
				$view->url_link_1_href = $url;
			}
		}

		if ($this->fields->url_link_2->is_enabled) {
			if (strlen(trim($show["url_link_2"])) > 0) {
				$url = trim(geoString::fromDB($show['url_link_2']));
				
				if (stripos($url, 'http://') !== 0 && stripos($url, 'https://') !== 0) {
					$url = 'http://'.$url;
				}
				
				$view->url_link_2 = "<a class=\"url_link_2\" href=\"$url\" onclick=\"window.open(this.href,'mywindow','toolbar=yes,location=yes,menubar=yes,scrollbars=yes,resizable=yes'); return false;\">".$this->messages[2441]."</a>";
				$view->url_link_2_href = $url;
			}
		}

		if ($this->fields->url_link_3->is_enabled) {
			if (strlen(trim($show["url_link_3"])) > 0) {
				$url = trim(geoString::fromDB($show['url_link_3']));
				
				if (stripos($url, 'http://') !== 0 && stripos($url, 'https://') !== 0) {
					$url = 'http://'.$url;
				}
				
				$view->url_link_3 = "<a class=\"url_link_3\" href=\"$url\" onclick=\"window.open(this.href,'mywindow','toolbar=yes,location=yes,menubar=yes,scrollbars=yes,resizable=yes'); return false;\">".$this->messages[2442]."</a>";
				$view->url_link_3_href = $url;
			}
		}

		if (($seller_data) && ($show["seller"])) {
			$view->seller_first_name = geoString::fromDB($seller_data->FIRSTNAME);
			$view->seller_last_name = geoString::fromDB($seller_data->LASTNAME);
			if($seller_data->URL) {
				if (stristr(stripslashes($seller_data->URL), urldecode("http://"))) {
					$url_current_line = "<a href=\"".geoString::fromDB($seller_data->URL)."\" onclick=\"window.open(this.href); return false;\">".geoString::fromDB($seller_data->URL)."</a>";
				} else {
					$url_current_line = "<a href=\"http://".geoString::fromDB($seller_data->URL)."\" onclick=\"window.open(this.href); return false;\">".geoString::fromDB($seller_data->URL)."</a>";
				}
				$view->seller_url = $url_current_line;
			}
			$view->seller_address = $seller_data->ADDRESS." ".$seller_data->ADDRESS_2;
			$view->seller_city = $seller_data->CITY;
			$view->seller_state =$seller_data->STATE;
			$view->seller_country = $seller_data->COUNTRY;
			$view->seller_zip = $seller_data->ZIP;
			$view->seller_phone = $seller_data->PHONE;
			$view->seller_phone2 = $seller_data->PHONE2;
			$view->seller_fax = $seller_data->FAX;
			$view->seller_company_name = $seller_data->COMPANY_NAME;
			$view->seller_optional_1 = $seller_data->OPTIONAL_FIELD_1;
			$view->seller_optional_2 = $seller_data->OPTIONAL_FIELD_2;
			$view->seller_optional_3 = $seller_data->OPTIONAL_FIELD_3;
			$view->seller_optional_4 = $seller_data->OPTIONAL_FIELD_4;
			$view->seller_optional_5 = $seller_data->OPTIONAL_FIELD_5;
			$view->seller_optional_6 = $seller_data->OPTIONAL_FIELD_6;
			$view->seller_optional_7 = $seller_data->OPTIONAL_FIELD_7;
			$view->seller_optional_8 = $seller_data->OPTIONAL_FIELD_8;
			$view->seller_optional_9 = $seller_data->OPTIONAL_FIELD_9;
			$view->seller_optional_10 = $seller_data->OPTIONAL_FIELD_10;
		}

		if ($this->debug_ad_display_time) echo $this->get_end_time()." after seller info placed<br/>\n";

		// Do PayPal buy it now link if the seller has entered a paypal id and the ad hasn't been sold
		if ($show["paypal_id"] != "" && $show["sold_displayed"] != 1 && $this->browsing_configuration->USE_BUY_NOW) {
		  $buy_it_now_link = "<a href=" .$this->configuration_data['classifieds_file_name']. "?a=31&amp;b=" .$id. "><img src='images/btn_buyitnow.gif' alt='Buy this item now through PayPal' border='0'></a>";
		  $view->buy_it_now_link = $buy_it_now_link;
		}

		if (!$printFriendly && $last_classified_id) {
			$previous_ad_link = "<a href=\"{$this->query_link}a=2&amp;b=".$last_classified_id."\" class=\"button previous_ad_link\">".$this->messages[787]."</a>";
		} else {
			$previous_ad_link = "";
		}
		$view->previous_ad_link = $previous_ad_link;
		$view->previous_auction_link = $previous_ad_link;

		if (!$printFriendly && $next_classified_id) {
			$next_ad_link = "<a href=\"{$this->query_link}a=2&amp;b=".$next_classified_id."\" class=\"button next_ad_link\">".$this->messages[786]."</a>";
		} else {
			$next_ad_link = "";
		}
		$view->next_ad_link = $view->next_auction_link = $next_ad_link;
		
		if (!$printFriendly) {
			$print_friendly_link = "<a href=\"{$this->query_link}a=14&amp;b=".$id."\" class=\"print_friendly_link\">".$this->messages[1473]."</a>";
			$view->print_friendly_link = $print_friendly_link;
			
			$add_to_favorite_link = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=20&amp;b=".$id."\" class=\"favorites_link\">".$this->messages[11]."</a>";
			$view->favorites_link = $add_to_favorite_link;
	
			$notify_friend_link = "<a href=\"{$this->query_link}a=12&amp;b=".$id."\" class=\"notify_friend_link\">".$this->messages[13]."</a>";
			$view->notify_friend_link = $notify_friend_link;
			
			if(geoPC::is_ent()) {
				$vote_on_ad_link = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=26&amp;b=".$show["id"]."\" class=\"vote_on_ad_link\">".$this->messages[2289]."</a>";
				$show_ad_vote_comments_link = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=27&amp;b=".$show["id"]."\" class=\"show_votes_on_ad_link\">".$this->messages[2290]."</a>";
			} else {
				$vote_on_ad_link = '';
				$show_ad_vote_comments_link = '';
			}
			$view->vote_on_ad_link = $vote_on_ad_link;
			$view->show_ad_vote_comments_link = $show_ad_vote_comments_link;
			
			$message_to_seller_link = "<a href=\"{$this->query_link}a=13&amp;b=".$id."\" class=\"notify_seller_link\">".$this->messages[14]."</a>";
			$view->message_to_seller_link = $message_to_seller_link;
			
			if (($seller_data) && ($show["seller"])) {
				if ($view->isAffiliatePage) {
					//affiliate, just link to main affiliate page
					$sellers_other_ads_link = "<a href=\"{$this->query_link}\" class=\"sellers_other_ads_link\">".$this->messages[750]."</a>";
				} else {
					$sellers_other_ads_link = "<a href=\"".$this->configuration_data['classifieds_file_name']."?a=6&amp;b=".$show["seller"]."\" class=\"sellers_other_ads_link\">".$this->messages[750]."</a>";
				}
				if($show["item_type"]==1) {
					$view->sellers_other_ads_link = $sellers_other_ads_link;
				}
				if($show["item_type"]==2) {
					$view->sellers_other_auctions_link = $sellers_other_ads_link;
				}
			} else {
				if($show["item_type"]==1) {
					$view->sellers_other_ads_link = $sellers_other_ads_link;
				}
				if($show["item_type"]==2) {
					$view->sellers_other_auctions_link = $sellers_other_ads_link;
				}
			}
			
			if ($show["image"] && geoPC::is_ent()) {
				$full_images_link = "<a href=\"{$this->query_link}a=15&amp;b=".$id."\" class=\"full_images_link\">".$this->messages[1369]."</a>";
				$view->full_images_link = $full_images_link;
			}
			
			if ($this->debug_ad_display_time) echo $this->get_end_time()." after images and info placed<br/>\n";
			for ($i = 1; ($i <= 20 && !$printFriendly); $i++) {
				//Set additional text 1-20
				$view_var = "additional_text_{$i}";
				$txt = $this->messages[(500052 + $i)];
				$view->$view_var = $txt;
			}
		}
		
		//offsite video data
		if ($isPreview && !$this->offsite_videos_from_db) {
			$offsite_videos = $this->offsite_videos;
			if ($offsite_videos) {
				//data from order item, not from database, so must add in vars
				//that are in the DB data
				foreach ($offsite_videos as $key => $video) {
					//slot is the key
					$offsite_videos[$key]['slot'] = $key;
					//so far, every video is going to be youtube
					$offsite_videos[$key]['video_type'] = 'youtube';
				}
			}
		} else {
			$offsite_videos = $this->db->GetAll("SELECT * FROM ".geoTables::offsite_videos." WHERE `listing_id`=$id ORDER BY `slot`");
		}
		
		if ($offsite_videos) {
			//give em access to the "raw data" if they want to do something fancy
			$view->offsite_videos_raw = $offsite_videos;
			
			$tpl = new geoTemplate(geoTemplate::SYSTEM, 'listing_details');
			$tpl->offsite_videos = $offsite_videos;
			$view->offsite_videos_block = $tpl->fetch('offsite_videos_block.tpl');
			unset ($tpl);
		}
		$view->offsite_videos_title = $this->messages[500935];
		
		//seller ID
		$view->seller_id = (int)$show['seller'];
		
		//whether or not to show edit and delete buttons
		$user_id = (int)geoSession::getInstance()->getUserID();
		
		//can edit if user logged in and seller = user, or user is admin user, or
		//user permitted because of addon authorization (such as multi-admin)
		$view->can_edit = !$isPreview && (($user_id && $user_id == $show['seller']) || $user_id == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL));
		
		//can delete if user is admin user, or user permitted because of addon 
		//authorization (such as multi-admin)
		$view->can_delete = !$isPreview && ($user_id == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL));
		
		//get action buttons from addons
		$view->addonActionButtons = geoAddon::triggerDisplay('listing_display_add_action_button',array('listingId' => $id, 'isPreview' => $isPreview));
		
		//Make all listing "raw" data available
		$view->listing_data_raw = $show;
		
		$anon = geoAddon::getRegistry('anonymous_listing');
		if($anon) {
			$anon_user_id = $anon->get('anon_user_id',false);
			$anon_user_name = $anon->get('anon_user_name','Anonymous');
		} else {
			$anon_user_id = false;
		}
		if ($anon && ($show["seller"] == $anon_user_id)) {
			//this is anonymous -- don't show seller-specific stuff
			//$view->seller_label = '';
			$view->seller = $anon_user_name; //pull name from addon setting
			if (!$show['email']) {
				//if e-mail isn't set, don't link to contact seller!
				$view->message_to_seller_link = '';
			}
			$view->sellers_other_ads_link = '';
			$view->sellers_other_auctions_link = '';
			$view->member_since = '';
			$view->additional_text_17 = ''; //member_since label
		}

		//increase view count
		$sql = "update ".$this->classifieds_table." set
			viewed = ".($show["viewed"] + 1)." where id = ".$id;
		$viewed_result = $this->db->Execute($sql);
		if ($this->debug_ad_display) echo $sql."<br/>\n";
		if (!$viewed_result) {
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			$this->error_message = $this->messages[81];
			return false;
		}
		$view->item_type = $show['item_type'];
		
		if (!geoSession::getInstance()->getUserID() && geoPC::is_ent()) {
			//user not logged in, see if there is any fields to "hide"
			$regHidden = geoAddon::getRegistry('_core',true);
			$hiddenFields = $regHidden->hiddenFields;
			if ($hiddenFields) {
				$hiddenFields = array_keys($hiddenFields);
				foreach ($hiddenFields as $hideField) {
					if (isset($view->$hideField)) {
						//unset that field so it is not displayed.
						unset($view->$hideField);
					}
				}
			}
		}
		
		$publicQuestionLimit = $db->get_site_setting('public_questions_to_show');
		if($publicQuestionLimit > 0) {
			$publicQuestions = array();
			//get all questions for this listing, most recent first
			$sql = "SELECT * FROM ".geoTables::user_communications_table." WHERE `regarding_ad` = ? and `public_question` = 1 ORDER BY `date_sent` DESC";
			$pq_result = $db->Execute($sql, array($id));
			while($pq_result && $message = $pq_result->FetchRow()) {
				$publicQuestions[$message['message_id']] = array(
					'question' => geoString::fromDB($message['body_text']),
					'asker' => geoUser::userName($message['message_from']),
					'asker_id' => $message['message_from'],
					'time' => date($db->get_site_setting('entry_date_configuration'),$message['date_sent']),
					'answer' => false //populate this below
				);
			}
			//get answers for those questions, stopping if we reach the admin-set limit of questions to show
			$numAnswers = 0;
			foreach($publicQuestions as $question_id => $question) {
				$sql = "SELECT `body_text` FROM ".geoTables::user_communications_table." WHERE `replied_to_this_message` = ? AND `public_answer` = 1 order by `date_sent` DESC";
				$answer = geoString::fromDB($db->GetOne($sql, array($question_id)));
				if($answer) {
					$publicQuestions[$question_id]['answer'] = $answer;
					if(++$numAnswers >= $publicQuestionLimit) {
						//don't add any more
						break; 
					}
				}
			}
			$view->publicQuestionsLabel = $this->messages[500894];
			$view->publicQuestions = ($numAnswers > 0) ? $publicQuestions : false;
			$view->noPublicQuestions = $this->messages[500901];
			$view->askAQuestionText = $this->messages[500902];
		}
		
		if(geoPC::is_ent()) {
			//pull in some meta-data about votes on this listing, and make it available to show
			$voteText = $db->get_text(true, 115);
			$voteSummary = array();
			$totalVotes = $show['one_votes'] + $show['two_votes'] + $show['three_votes'];
			if($totalVotes == 0) {
				//no votes yet!
				$voteSummary = array(
					'votes' => 0,
					'percent' => 0, 
					'text' => $voteText[500903]
				);
			} else {
				//figure out which vote category has the most votes
				if($show['two_votes'] >= $show['three_votes'] && $show['two_votes'] > $show['one_votes']) {
					//plurality of votes are neutral. 
					//use >= to prefer this over level 3 in a tie, and > to prefer level 1 over this in a tie
					$voteSummary = array(
						'votes' => $show['two_votes'],
						'percent' => round($show['two_votes'] / $totalVotes * 100),
						'text' => $voteText[2010]
					);
				} elseif($show['three_votes'] > $show['two_votes'] && $show['three_votes'] > $show['one_votes']) {
					//plurality of votes are negative
					$voteSummary = array(
						'votes' => $show['three_votes'],
						'percent' => round($show['three_votes'] / $totalVotes * 100),
						'text' => $voteText[2011]
					);
				} else {
					//plurality of votes are positive
					$voteSummary = array(
						'votes' => $show['one_votes'],
						'percent' => round($show['one_votes'] / $totalVotes * 100),
						'text' => $voteText[2009]
					);
				}
			}
			$voteSummary['total'] = $totalVotes;
			$view->voteSummary = $voteSummary;
		}
		
		
		geoAddon::triggerUpdate('notify_Display_ad_display_classified_after_vars_set',array('id'=> $id,'return'=>$return,'preview'=>$preview, 'autoDisplay'=>$autoDisplay));
		if($view->getListingVarsOnly) {
			//easy way for addons to short-circuit the template code
			//so they can display a listing in their own template without duplicating all that code above
			return true;
		}
		
		//Use new Smarty templates
		if (!isset($view->geo_inc_files['body_html_addon']) && !isset($view->geo_inc_files['body_html_system'])) {
			$view->setLanguage($this->db->getLanguage());
			$view->setCategory($show["category"]);
			if ($printFriendly) {
				$page_id = '69';
			} else {
				$page_id = '1';
			}
			if ($show["item_type"] == 1) {
				$page_id .= '_classified';
			} else {
				$page_id .= '_auction';
			}
			
			$tpl_file = $view->getTemplateAttachment($page_id);
			$view->setPage($this);
			$view->loadModules($page_id);
			
			if ($printFriendly) {
				$view->forceTemplateAttachment($tpl_file);
			} else {
				$view->setBodyTpl($tpl_file);
			}
		}
		if ($return) {
			return $view->render($page_id,true);
		}
		
		if ($autoDisplay) {
			$this->display_page($preview);
		}
		return true;
	} //end of function display_classifed
	
	function get_ads_extra_values($db,$classified_id, $session_variables = null) {
		if(!$classified_id) return false;
		
		$name = "\n<ul class='extraQuestionName' id='extraQuestionName'>\n";
		$value = "\n<ul class='extraQuestionValue' id='extraQuestionValue'>\n";
		
		if (isset($session_variables['question_value'])) {
			//use passed in array
			$values = $session_variables['question_value'];
			$other = $session_variables['question_value_other'];
			$sql = $this->db->Prepare("SELECT `name`, `choices` FROM ".geoTables::questions_languages." WHERE `question_id`=? AND `language_id` = ?");
			
			foreach ($values as $key => $val) {
				if (strlen(trim($val)) == 0 && !(isset($other[$key]) && strlen(trim($other[$key])))) {
					continue;
				}
				$show_special = $this->db->GetRow($sql, array($key, $this->language_id));
				if ($show_special['choices'] == 'check') {
					//this is a checkbox
					continue; 
				}
				
				$name .= "\t<li>".geoString::fromDB($show_special["name"])."</li>\n";
				if (strlen(trim($other[$key]))) {
					$val = $other[$key];
				}
				if($show_special['choices'] == 'url') {
					$href = $link = geoString::fromDB($val); //decode before looking for protocol
					if(strpos($link, "://") === false && strpos($link, "mailto:") === false) {
						//add http:// if there's no protocol given
						$href = 'http://' . $link;
					}
					$value .= '<li><a href="'.$href.'">'.$link.'</a></li>';
				} else {
					$value .= "\t<li>".geoString::fromDB($val)."</li>\n";
				}
			}
			$name .= "</ul>\n";
			$value .= "</ul>\n";
		} else {
			$sql = "select langs.name as name, langs.choices as choices, vals.value as value from ".$this->classified_extra_table." as vals, `geodesic_classifieds_sell_questions_languages` as langs where vals.classified_id = ".$classified_id." and vals.question_id = langs.question_id and langs.language_id = ".$this->language_id." and checkbox !=1 order by vals.display_order asc";
			$result = $this->db->Execute($sql);
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			if (!$result)
			{
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				$this->error_message = $this->messages[81];
				return false;
			} else if ($result->RecordCount() <= 0 ) {
				return false;
			}
			
			while ($show_special = $result->FetchRow()) {
				$name .= "\t<li>".geoString::fromDB($show_special["name"])."</li>\n";

				if($show_special['choices'] == 'url') {
					$href = $link = geoString::fromDB($show_special["value"]); //decode before looking for protocol
					if(strpos($link, "://") === false && strpos($link["value"], "mailto:") === false) {
						//add http:// if there's no protocol given
						$href = 'http://' . $link;
					}
					$value .= '<li><a href="'.$href.'">'.$link.'</a></li>';
				} else {
					$value .= "\t<li>".geoString::fromDB($show_special["value"])."</li>\n";
				}
			}
		}
		$name .= "</ul>\n";
		$value .= "</ul>\n";
		$question_block["names"] = $name;
		$question_block["values"] = $value;
		return $question_block;
	}

//#################################################################################

	function get_ads_extra_checkboxes($db,$classified_id, $session_variables) {
		if(!$classified_id) return false;
		
		$columns = array();
		$start = '';
		if ($this->configuration_data['checkbox_columns']>0) {
			$width = (100/$this->configuration_data['checkbox_columns']);
			for($i=0;$i<$this->configuration_data['checkbox_columns'];$i++) {
				$start = "\n<ul style='width:$width%;' class='extraCheckboxes'>\n";
			}
		} else {
			$start = "\n<ul style='width:100%;' class='extraCheckboxes'>\n";
		}
		$counter = 0;
		
		if (isset($session_variables['question_value'])) {
			//use passed in array
			$values = $session_variables['question_value'];
			$sql = $this->db->Prepare("SELECT `name`, `choices` FROM ".geoTables::questions_languages." WHERE `question_id`=? AND `language_id` = ?");
			
			foreach ($values as $key => $val) {
				if (strlen(trim($val)) == 0) {
					continue;
				}
				$show_special = $this->db->GetRow($sql, array($key, $this->language_id));
				if ($show_special['choices'] != 'check') {
					//this is a checkbox
					continue; 
				}
				$key = ($this->configuration_data['checkbox_columns']) ? ($counter%$this->configuration_data['checkbox_columns']) : 0;
				$columns[$key] .= "\t<li>".$val."</li>\n";
				$counter++;
			}
		} else {
		
			$sql = "select langs.name from ".$this->classified_extra_table." as vals, `geodesic_classifieds_sell_questions_languages` as langs where vals.classified_id = ".$classified_id." and vals.question_id = langs.question_id and langs.language_id = ".$this->language_id." and checkbox = 1 order by vals.display_order asc";
			$result = $this->db->Execute($sql);
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			if (!$result) {
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				$this->error_message = geoString::fromDB($this->messages[81]);
				return false;
			}
			elseif ($result->RecordCount() <= 0 ) return false;
			
			while ($showResult = $result->FetchRow())
			{
				$key = ($this->configuration_data['checkbox_columns']) ? ($counter%$this->configuration_data['checkbox_columns']) : 0;
				$columns[$key] .= "\t<li>".geoString::fromDB($showResult["name"])."</li>\n";
				$counter++;
			}
		}
		if (!$counter) return '';
		$question_block = '';
		foreach ($columns as $col) {
			if ($col) {
				$question_block .= $start.$col."</ul>\n";
			}
		}
		return $question_block;
	}

//#################################################################################

	function get_filter_value($db,$association=0)
	{
		if ($association)
		{
			//association is the filter level this value is associated with
			$sql = "select count(distinct(filter_level)) as level_count from ".$this->filters_table;
			$level_count_result = $this->db->Execute($sql);
			if ($this->debug_ad_display) echo $sql."<br/>\n";
			if (!$level_count_result)
			{
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				$this->error_message = $this->messages[5501];
				return false;
			}
			elseif ($level_count_result->RecordCount() == 1)
			{
				$level_count = $level_count_result->FetchNextObject();
				if ($level_count->LEVEL_COUNT == $association)
				{
					//get current filter id filter name
					$sql = "select ".$this->filters_languages_table.".filter_name
						from ".$this->filters_languages_table."
						where ".$this->filters_languages_table.".language_id = ".$this->language_id."
						and ".$this->filters_languages_table.".filter_id = ".$this->filter_id;
					$filter_result =  $this->db->Execute($sql);
					if ($this->debug_ad_display) echo $sql."<br/>\n";
					if (!$filter_result)
					{
						if ($this->debug_ad_display) echo $sql."<br/>\n";
						$this->error_message = $this->messages[3501];
						return false;
					}
					elseif ($filter_result->RecordCount() == 1)
					{
						$show_filter_name = $filter_result->FetchNextObject();
						return $show_filter_name->FILTER_NAME;
					}
					else
					{
						if ($this->debug_ad_display) echo $sql."<br/>\n";
						return false;
					}

				}
				else
				{
					$filter_name = $this->get_filter_level($db,$this->filter_id,$association);
					return $filter_name;
				}
			}
			else
			{
				return false;
			}
		}
		else
			return false;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_filter_level($db,$filter=0,$level_result=0)
	{
		if ($filter)
		{
			$i = 0;
			$filter_next = $filter;
			do
			{
				$sql = "select ".$this->filters_table.".filter_id,".$this->filters_table.".parent_id,
					".$this->filters_languages_table.".filter_name, ".$this->filters_table.".filter_level
					from ".$this->filters_table.",".$this->filters_languages_table."
					where ".$this->filters_table.".filter_id = ".$this->filters_languages_table.".filter_id
					and ".$this->filters_languages_table.".language_id = ".$this->language_id."
					and ".$this->filters_table.".filter_id = ".$filter_next;
				$filter_result =  $this->db->Execute($sql);
				if ($this->debug_ad_display) echo $sql."<br/>\n";
				if (!$filter_result)
				{
					if ($this->debug_ad_display) echo $sql."<br/>\n";
					$this->error_message = $this->messages[3501];
					return false;
				}
				elseif ($filter_result->RecordCount() == 1)
				{
					$show_filter = $filter_result->FetchNextObject();
					$this->filter_level_array[$i]["parent_id"]  = $show_filter->PARENT_ID;
					$this->filter_level_array[$i]["filter_name"] = $show_filter->FILTER_NAME;
					$this->filter_level_array[$i]["filter_id"]   = $show_filter->FILTER_ID;
					$this->filter_level_array[$i]["filter_level"]   = $show_filter->FILTER_LEVEL;
					if (($level_result) && ($level_result == $show_filter->FILTER_LEVEL))
						return $show_filter->FILTER_NAME;
					$i++;
					$filter_next = $show_filter->PARENT_ID;
				}
				else
				{
					//echo "wrong return<br/>\n";
					return false;
				}

			} while ( $show_filter->PARENT_ID != 0 );

			return $i;
		}
		else
			return false;

	} // end of function get_filter_level

//########################################################################

	function format_phone_data($phone_number=0)
	{
		return geoNumber::phoneFormat($phone_number);
	} //end of function format_phone_data

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

} // end of class Display_ad

