<?php
//archive_listings.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

if (!defined('GEO_CRON_RUN')){
	die('NO ACCESS');
}
$current_time = $this->time();
$util = archive_listings_util::getInstance();

$delay_time = $this->db->get_site_setting('archive_listing_delay');
if (!$delay_time) {
	//set default
	$delay_time = 2592000;
	$this->db->set_site_setting('archive_listing_delay',$delay_time);
}

$removal_date = intval($current_time - $delay_time);

//$removal_date is clean since intval is done on it above.
$sql = "select * from ".$this->db->geoTables->classifieds_table." where ends < $removal_date and live = 0";
$this->log($sql,__line__);
$this->log("Delay time before moving closed listings to expired listing table: <strong>$delay_time seconds</strong>. (set in Admin -> Listing Setup -> General Settings -> Archive Listing )",__line__);

$select_result = $this->db->Execute($sql);
if (!$select_result)
{
	$this->log("Error in ".$sql."\n".$this->db->ErrorMsg(),__line__);
	return false;
}

//move expired ads to expired table
while ($show = $select_result->FetchRow()) {
	//check to see if there is a renewal that is pending admin approval
	$sql = "SELECT count(oi.id) as count FROM ".geoTables::order_item." as oi, ".geoTables::order." as o,
			".geoTables::order_item_registry." as oir
			WHERE 
			oi.status = 'pending' AND oi.type = 'listing_renew_upgrade'
			AND o.id = oi.`order` AND (o.status IN ('active', 'pending_admin', 'pending') )
			AND u.id = o.buyer AND oir.order_item = oi.id
			AND oir.index_key = 'listing_id' AND oir.val_string = '{$show['id']}'";
	$row = $this->db->GetRow($sql);
	
	if (isset($row['count']) && $row['count'] > 0) {
		//there is a pending renewal/upgrade for this listing, so
		//don't archive.
		continue;
	}
	
		$this->log($show['duration']." is show[duration]",__line__);
		if ((strlen(trim($show['duration'])) == 0) || (is_null($show['duration'])))
		{
			$this->log("show[duration] is null or empty",__line__);
			$show['duration'] = 0;
		}
		$this->log($show['duration']." is show[duration] 2",__line__);
		$category_string = $util->get_category_string($show['category']);
		$sql = "INSERT INTO ".$this->db->geoTables->classifieds_expired_table."
			(id,seller,title,date,description,category,
			duration,location_state,location_zip,location_country,ends,search_text,ad_ended,reason_ad_ended,viewed,
			bolding,better_placement,featured_ad,precurrency,price,postcurrency,
			sold_displayed,business_type,optional_field_1,optional_field_2,optional_field_3,optional_field_4,optional_field_5,
			optional_field_6,optional_field_7,optional_field_8,optional_field_9,optional_field_10,
			optional_field_11,optional_field_12,optional_field_13,optional_field_14,optional_field_15,
			optional_field_16,optional_field_17,optional_field_18,optional_field_19,optional_field_20,phone,phone2,fax,email,auction_type,
			final_fee,final_price,item_type,hide, order_item_id)
			VALUES
			( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
			?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
			?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; //52 values
		
		$query_data = array($show['id'],
			$show['seller'],
			$show['title'],
			$show['date'],
			$show['description'],
			$category_string,
			$show['duration'],
			$show['location_state'],
			$show['location_zip'],
			$show['location_country'],
			$show['ends'],
			$show['search_text'],
			$show['ends'], //this listing expired naturally, so its ad_ended time is the same as the 'ends' field
			"expired",
			$show['viewed'],
			$show['bolding'],
			$show['better_placement'],
			$show['featured_ad'],
			$show['precurrency'],
			$show['price'],
			$show['postcurrency'],
			$show['sold_displayed'],
			$show['business_type'],
			$show['optional_field_1'],
			$show['optional_field_2'],
			$show['optional_field_3'],
			$show['optional_field_4'],
			$show['optional_field_5'],
			$show['optional_field_6'],
			$show['optional_field_7'],
			$show['optional_field_8'],
			$show['optional_field_9'],
			$show['optional_field_10'],
			$show['optional_field_11'],
			$show['optional_field_12'],
			$show['optional_field_13'],
			$show['optional_field_14'],
			$show['optional_field_15'],
			$show['optional_field_16'],
			$show['optional_field_17'],
			$show['optional_field_18'],
			$show['optional_field_19'],
			$show['optional_field_20'],
			$show['phone'],
			$show['phone2'],
			$show['fax'],
			$show['email'],
			$show['auction_type'],
			$show['final_fee'],
			$show['final_price'],
			$show["item_type"],
			$show["hide"],
			$show['order_item_id']);
		$insert_expired_result = $this->db->Execute($sql, $query_data);
		unset($query_data);
		$this->log($sql,__line__);
		if (!$insert_expired_result)
		{
			//probably another id that matches, so remove that entry and try
			//to insert again.
			$this->log($this->db->ErrorMsg()." is the error message$sql",__line__);
			$sql = "delete from ".$this->db->geoTables->classifieds_expired_table." where id = ?";
			$delete_bad_result = $this->db->Execute($sql, array($show['id']));
			$this->log($sql,__line__);
			if (!$delete_bad_result)
			{
				$this->log($this->db->ErrorMsg()." is the error message".$sql,__line__);
				return false;
			}
			$sql = "INSERT INTO ".$this->db->geoTables->classifieds_expired_table."
				(id,seller,title,date,description,category,
				duration,location_state,location_zip,location_country,ends,search_text,ad_ended,reason_ad_ended,viewed,
				bolding,better_placement,featured_ad,precurrency,price,postcurrency,
				sold_displayed,business_type,optional_field_1,optional_field_2,optional_field_3,optional_field_4,optional_field_5,
				optional_field_6,optional_field_7,optional_field_8,optional_field_9,optional_field_10,
				optional_field_11,optional_field_12,optional_field_13,optional_field_14,optional_field_15,
				optional_field_16,optional_field_17,optional_field_18,optional_field_19,optional_field_20,phone,phone2,fax,email,auction_type,
				final_fee,final_price,item_type,hide)
				VALUES
				( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
				?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 
				?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )"; //52 values
			
			$query_data = array($show['id'],
				$show['seller'],
				$show['title'],
				$show['date'],
				$show['description'],
				$category_string,
				$show['duration'],
				$show['location_state'],
				$show['location_zip'],
				$show['location_country'],
				$show['ends'],
				$show['search_text'],
				$show['ends'], //this listing expired naturally, so its ad_ended time is the same as the 'ends' field
				"expired",
				$show['viewed'],
				$show['bolding'],
				$show['better_placement'],
				$show['featured_ad'],
				$show['precurrency'],
				$show['price'],
				$show['postcurrency'],
				$show['sold_displayed'],
				$show['business_type'],
				$show['optional_field_1'],
				$show['optional_field_2'],
				$show['optional_field_3'],
				$show['optional_field_4'],
				$show['optional_field_5'],
				$show['optional_field_6'],
				$show['optional_field_7'],
				$show['optional_field_8'],
				$show['optional_field_9'],
				$show['optional_field_10'],
				$show['optional_field_11'],
				$show['optional_field_12'],
				$show['optional_field_13'],
				$show['optional_field_14'],
				$show['optional_field_15'],
				$show['optional_field_16'],
				$show['optional_field_17'],
				$show['optional_field_18'],
				$show['optional_field_19'],
				$show['optional_field_20'],
				$show['phone'],
				$show['phone2'],
				$show['fax'],
				$show['email'],
				$show['auction_type'],
				$show['final_fee'],
				$show['final_price'],
				$show["item_type"],
				$show["hide"]);
			$insert_expired_result = $this->db->Execute($sql, $query_data);
			unset($query_data);
			$this->log($sql,__line__);
			if (!$insert_expired_result)
			{
				$this->log($this->db->ErrorMsg()." is the error message".$sql,__line__);
				return false;
			}
		}
		
		if ($show["item_type"] == 2) {
			//get high bidder for auction
			if (isset($show['high_bidder'])){
				//if the high bidder is already set, get the already defined high bidder.
				$high_bidder = $show['high_bidder'];
			} else {
				//otherwise get the high bidder from the auction table.
				$high_bidder = $util->get_high_bidder($show["id"]);
				$high_bidder = $high_bidder['bidder'];
			}
			$sql = "update ".$this->db->geoTables->classifieds_expired_table." set
				high_bidder = ?
				where id = ?";
			$update_bidder_result = $this->db->Execute($sql, array($high_bidder, $show['id']));
			$this->log($sql,__line__);
			if (!$update_bidder_result)
			{
				//add high_bidder to expired table and try again
				$sql = "ALTER TABLE ".$this->db->geoTables->classifieds_expired_table." ADD high_bidder INT NOT NULL";
				$alter_expired_result = $this->db->Execute($sql);
				$this->log($sql,__line__);
				$sql = "update ".$this->db->geoTables->classifieds_expired_table." set
					high_bidder = ?
					where id = ?";
				$update_bidder_result = $this->db->Execute($sql, array($high_bidder["bidder"], $show["id"]));
				$this->log($sql,__line__);
			}
		}
		//let geoListing do rest of work for us, but let it know it is archived
		//so that feedback isn't also removed.
		$removeResult = geoListing::remove($show['id'], true);
		if (!$removeResult) {
			$this->log('Removal of listing failed in geoListing::remove() for listing ID '.$show['id'], __line__);
			return false;
		}
	
} //end of while

//NOTE:  we return true AFTER the class declaration, otherwise on some servers
//the class is never parsed

class archive_listings_util extends geoCron {
	var $category_tree_array;
	var $messages;
	var $db;
	var $verbose;
	private static $_instance;
	/**
	 * Get an instance of the cron task.
	 *
	 * @return archive_listings_util
	 */
	public static function getInstance ()
	{
		if (!isset(self::$_instance)) {
			$c = __class__;
			self::$_instance = new $c;
		}
		return self::$_instance;
	}
	
	protected function __construct ()
	{
		$cron = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		foreach ($cron as $setting => $val) {
			$this->$setting = $val;
		}
	}
	
	/**
	 * Needed by archive_listings()
	 *
	 * @param unknown_type $category
	 */
	function get_category_string($category)
	{
		$category_tree = geoCategory::getTree($category);
		
		if ($category_tree) {
			//category tree
			
			$category_string = "";
			if (is_array($category_tree)) {
				$i = 0;
				//$categories = array_reverse($category_tree);
				$i = count($category_tree);
				while ($i > 0 ) {
					//display all the categories
					$i--;
					$category_string .= $category_tree[$i]["category_name"];
					if ($i > 0)
						$category_string .= " > ";
				}
			} else {
				$category_string .= 'Unknown';
			}
		}
		return $category_string;
	}
	
	
	/**
	 * Needed by archive_listings()
	 */
	function get_high_bidder($auction_id=0)
	{
		$this->log('Top of get_high_bidder',__line__);
		$sql = "select * from ".$this->db->geoTables->bid_table." where auction_id=".$auction_id." order by bid desc,time_of_bid asc limit 1";
		$high_bid_result = $this->db->Execute($sql);
		$this->log($sql,__line__);
		if (!$high_bid_result)
		{
			$this->log(__line__.'DB Error, sql: '.$sql." Error: ".$this->db->ErrorMsg(),__line__);
			return false;
		}
		elseif ($high_bid_result->RecordCount() == 1)
		{
			$show_high_bidder = $high_bid_result->FetchRow();
			return $show_high_bidder;
		}
		else
		{
			return 0;
		}
	}
}

return true; //finished task all the way through.
