<?php
//order_items/auction.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21316              $ ##
## File last change date:       ##
##  $Date:: 2011-04-27 17:23:#$ ##
##                              ##
##################################

require_once CLASSES_DIR . PHP5_DIR . 'OrderItem.class.php';
require_once CLASSES_DIR . 'order_items/_listing_placement_common.php';


class auctionOrderItem extends _listing_placement_commonOrderItem {
	var $defaultProcessOrder = 5;
	protected $type = 'auction';
	const type = 'auction';
	public function displayInAdmin() {
		if (!geoPC::is_auctions()) { return false; }
		return true;
	}
	
	/**
	 * Optional.
	 * Used: In admin, during ajax call to display config settings for a particular
	 * price plan item.
	 * 
	 * If this method exists, a config button will be displayed beside the item, and when
	 * the config button is pressed, whatever this function returns will be displayed
	 * below the item using an ajax call.
	 *
	 * @param geoPlanItem $planItem
	 * @return string
	 */
	public function adminPlanItemConfigDisplay ($planItem)
	{
		$admin = geoAdmin::getInstance();
		$cjax = geoCJAX::getInstance();
		$db = DataAccess::getInstance();
		$html = "";
		
		$allow_buy_now = $planItem->get('allow_buy_now',1);
		$clickScript = (geoPC::is_ent()) ? "if(this.checked) $('hide_allow_bno_switch').style.display='block'; else $('hide_allow_bno_switch').style.display='none';" : '';
		$html .= geoHTML::addOption('Allow "Buy Now" Auctions','<input type="checkbox" onclick="'.$clickScript.'" name="auction[allow_buy_now]" id="auction_allow_bn" '.(($allow_buy_now)?'checked="checked"':'').' value="1" />');
		
		//buy now only is ENT-only 
		$allow_buy_now_only = $planItem->get('allow_buy_now_only',1);
		$html .= '<div id="hide_allow_bno_switch" style="display: '.(($allow_buy_now && geoPC::is_ent())?'block':'none').';">';
		$html .= geoHTML::addOption('Allow "Buy Now Only" Auctions', '<input type="checkbox" name="auction[allow_buy_now_only]" id="auction_allow_bno" '.(($allow_buy_now_only)?'checked="checked"':'').' value="1" />');
		$html .= '</div>';		
		
		return $html;
	}
	
	/**
	 * Optional.
	 * Used: In admin, during ajax call to update config settings for a particular
	 * price plan item.
	 * 
	 * This is only used if adminPlanItemConfigDisplay() is used.
	 *
	 * @param geoPlanItem $planItem
	 * @return bool If return true, message "settings saved" will be displayed, if return
	 *  false, message "settings not saved" will be displayed.
	 */
	public function adminPlanItemConfigUpdate ($planItem)
	{
		$cjax = geoCJAX::getInstance();
		$settings = $_POST['auction'];
		
		if (is_array($settings)) {
			$allow_buy_now = $settings['allow_buy_now'];
			$allow_buy_now_only = ($allow_buy_now) ? $settings['allow_buy_now_only'] : 0; // if allow_buy_now not on, force to be false
			$planItem->set('allow_buy_now',$allow_buy_now);
			$planItem->set('allow_buy_now_only',$allow_buy_now_only);
		}
		
		return true;
	}
	
	public function adminDetails ()
	{
		if (!geoPC::is_auctions()) { return; }
		return parent::adminDetails();
	}
	public static function geoCart_initSteps(){
		if (!geoPC::is_auctions()) { return; }
		parent::$_type = self::type;
		parent::geoCart_initSteps(2);
		if (self::isAnonymous() && DataAccess::getInstance()->get_site_setting('jit_registration')) {
			geoCart::getInstance()->addStep(self::type.':jit');
		}
	}
	
	public static function geoCart_initSteps_addOtherDetails(){
		$children = geoOrderItem::getChildrenTypes(self::type);
		//can call directly, since this function is required.
		if (geoOrderItem::callDisplay('geoCart_initSteps_addOtherDetails',null,'bool_true',$children)){
			//one of the children want to display it, so return true.
			return true;
		}
		
		return false; //nothing to show here. return false
	}
		
	public static function choose_planCheckVars ($applies_to=null)
	{
		if (!geoPC::is_auctions()) { return; }
		parent::choose_planCheckVars(2);
	}
	
	public static function choose_planDisplay ($applies_to=null)
	{
		if (!geoPC::is_auctions()) { return; }
		parent::$_type = self::type;
		parent::choose_planDisplay(2);
	}
	
	public function getDisplayDetails ($inCart)
	{
		if (!geoPC::is_auctions()) { return false; }
		$price = $this->getCost(); //people expect numbers to be positive...
		$msgs = DataAccess::getInstance()->get_text(true, 10202);
		$return = array (
			'css_class' => '',
			'title' => $msgs[500317],
			'canEdit' => true, //whether can edit it or not
			'canDelete' => true, //whether can remove from cart or not
			'canPreview' => true, //whether can preview the item or not
			'priceDisplay' => geoString::displayPrice($price), //price to display
			'cost' => $price, //amount this adds to the total, what getCost returns
			'total' => $price, //amount this and all children adds to the total
			'children' => false
		);
		$session_variables = $this->get('session_variables');
		$title = $session_variables['classified_title'];
		
		//shorten the title to...  15 chars
		if (strlen(trim($title)) > 20) {
			$title = geoString::substr($title,0,20) . "...";
		}
		
		//TODO: Do we need more info displayed here?
		$return['title'] .= " - $title";
		
		//go through children...
		$order = $this->getOrder();
		$items = $order->getItem();
		$children = array();
		foreach ($items as $i => $val){
			if (is_object($val) && is_object($val->getParent())){
				$p = $val->getParent();
				if ($p->getId() == $this->getId()){
					//This is a child of mine...
					$displayResult = $val->getDisplayDetails($inCart);
					if ($displayResult !== false) {
						//only add if they do not return bool false
						$children[$val->getId()] = $displayResult;
						$return['total'] += $children[$val->getId()]['total']; //add to total we are returning.
					}
				}
			}
		}
		if (count($children)){
			$return['children'] = $children;
		}
		return $return;
	}
	
	public function geoCart_initItem_new ($item_type=null)
	{
		if (!geoPC::is_auctions()) { return false; }
		parent::$_type = self::type;
		self::_initAuctionPricePlan();
		return parent::geoCart_initItem_new(2);
	}
	public static function geoCart_initSession_new ($call_children = true, $item_type=null)
	{
		if (!geoPC::is_auctions()) { return; }
		parent::$_type = self::type;
		self::_initAuctionPricePlan();
		parent::geoCart_initSession_new($call_children,2);
	}
	public static function geoCart_initSession_update(){
		if (!geoPC::is_auctions()) { return false; }
		self::geoCart_initSession_new(false);
		$children = geoOrderItem::getChildrenTypes(self::type);
		geoOrderItem::callUpdate('geoCart_initSession_update',null,$children);
		
		return;
	}
	
	
	public static function categoryCheckVars ($listing_types_allowed=null, $cat_id = 0)
	{
		if (!geoPC::is_auctions()) { return; }
		return parent::categoryCheckVars(2);
	}
	
	
	public static function categoryDisplay ($listing_types_allowed=null)
	{
		if (!geoPC::is_auctions()) { return; }
		$tpl_vars = parent::categoryDisplay(2);
		
		$cart = geoCart::getInstance();
		$view = geoView::getInstance();
		
		//set text that is specific to auctions
		//500354 = "Place an Auction"
		$tpl_vars['title1'] = $cart->site->messages[500354];
		//Cancel link text
		$tpl_vars['cancel_txt'] = $cart->site->messages[500355];
		
		$view->setBodyTpl('auction/category_choose.tpl','','order_items')
			->setBodyVar($tpl_vars);
		
		$cart->site->display_page();
	}
	
	public static function detailsDisplay()
	{
		if (!geoPC::is_auctions()) { return; }
		$cart = geoCart::getInstance();
		$cart->site->sell_type = 2;
		$view = geoView::getInstance();
		
		$tpl_vars = parent::detailsDisplay();
		
		$category = $cart->item->getCategory();
		$price_plan = $cart->item->getPricePlan();
		$planItem = geoPlanItem::getPlanItem(self::type,$price_plan,$category);
		if($planItem) {
			$tpl_vars['allow_buy_now'] = $planItem->get('allow_buy_now',1);
			$tpl_vars['allow_buy_now_only'] = $planItem->get('allow_buy_now_only',1);
		}
		
		//500360 = Place an Auction
		$tpl_vars['txt1'] = $cart->site->messages[500360];
		//108 = "Auction Details"
		$tpl_vars['title1'] = $cart->site->messages[500361];
		//500362 = ""
		$tpl_vars['desc1'] = $cart->site->messages[500362];
		//500364 = "Next Step >>"
		$tpl_vars['submit_button_txt'] = $cart->site->messages[500364];
		//500363 = Cancel & Remove image
		$tpl_vars['cancel_txt'] = $cart->site->messages[500363];
		
		$view->setBodyTpl('auction/listing_collect_details.tpl','','order_items')
			->setBodyVar($tpl_vars);
		
		$cart->site->display_page();
	}
	
	public static function detailsCheckVars ($save_session_vars = null)
	{
		parent::detailsCheckVars();
		
		$cart = geoCart::getInstance();
		$category = $cart->item->getCategory();
		$price_plan = $cart->item->getPricePlan();
		$planItem = geoPlanItem::getPlanItem(self::type,$price_plan,$category);
		
		if($planItem) {
			
			//shouldn't have to do anything here, since these settings modify the detailsDisplay form directly
			//but put sanity checks here for anticrackability
			$allow_buy_now = $planItem->get('allow_buy_now',1);
			$allow_buy_now_only = $planItem->get('allow_buy_now_only',1);
			if($cart->site->session_variables['buy_now'] > 0 && !$allow_buy_now) {
				$cart->site->session_variables['buy_now'] = 0;
			}
			if($cart->site->session_variables['buy_now_only'] == 1 && !$allow_buy_now_only) {
				$cart->site->session_variables['buy_now_only'] = 0;
			}
		}
		self::saveFormVariables();
	}
	
	public static function mediaCheckVars ()
	{
		parent::$_type = self::type;
		parent::mediaCheckVars();
	}
	
	public static function mediaProcess()
	{
		parent::$_type = self::type;
		parent::mediaProcess();
	}
	
	public static function mediaDisplay ()
	{
		$cart = geoCart::getInstance();
		
		$cart->site->page_id = 10;
		$cart->site->get_text();
		
		$tpl_vars = $cart->getCommonTemplateVars();
		$tpl_vars['title1'] = $cart->site->messages[500379];
		$tpl_vars['title2'] = $cart->site->messages[500380];
		$tpl_vars['page_description'] = $cart->site->messages[500905];
		$tpl_vars['cancel_txt'] = $cart->site->messages[500385];
		
		geoView::getInstance()->setBodyVar($tpl_vars);
		
		parent::$_type = self::type;
		
		parent::mediaDisplay();
	}
	
	/**
	 * Returns data to be displayed on listing cost and features section
	 *
	 * @return array of data that is processed and used to display the listing cost box
	 */
	public static function geoCart_other_detailsDisplay () {
		$cart = geoCart::getInstance();
		if (!$cart->item || $cart->item->getType() != self::type) {
			return '';
		}
		parent::$_type = self::type;
		$return = parent::geoCart_other_detailsDisplay();
		if (!$return) {
			//probably not supposed to show this item
			//but still need to set title and stuff if there
			//are others to display
			$return = array('entire_box' => ' ');
		}
		
		$return ['page_title1'] = $cart->site->messages[500419];
		$return ['page_title2'] = $cart->site->messages[500420];
		$return ['page_desc'] = $cart->site->messages[500421];
		$return ['submit_button_text'] = $cart->site->messages[500422];
		$return ['cancel_text'] = $cart->site->messages[500423];
		
		return $return;
	}
	
	public static function geoCart_other_detailsCheckVars(){
		parent::$_type = self::type;
		return parent::geoCart_other_detailsCheckVars();
	}
	
	public static function geoCart_other_detailsProcess(){
		parent::$_type = self::type;
		return parent::geoCart_other_detailsProcess();
	}
	/**
	 * Optional.  Required if in getDisplayDetails() you returned true for the array index of canPreview
	 *
	 */
	public function geoCart_previewDisplay ($sell_type=null)
	{
		return parent::geoCart_previewDisplay(2);
	}
	
	public static function geoCart_payment_choicesProcess ($sell_type=null)
	{
		parent::$_type = self::type;
		parent::geoCart_payment_choicesProcess(2);
	}
	
	public static function splashLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500494];
	}
	
	public static function choose_planLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500496];
	}
	
	public static function categoryLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500498];
	}
	
	public static function detailsLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500500];
	}
	
	public static function geoCart_other_detailsLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500506];
	}
	
	function getTransactionDescription(){
		if (!geoPC::is_auctions()) { return; }
		return 'Auction Listing';
	}
	
	
	public static function getParentTypes(){
		//this is main order item, no parent types
		return array();
	}	
	
	/**
	 * Optional.
	 * Used: in geoCart::cartDisplay()
	 * 
	 * Used only for "parent" items, this should return the text to use for the new button displayed
	 * in the cart view, for instance something like "Add New Classified".
	 *
	 */	
	public static function geoCart_cartDisplay_newButton($inModule = false)
	{
		if (!geoPC::is_auctions() || (self::isAnonymous() && !DataAccess::getInstance()->get_site_setting('jit_registration'))) return '';
		
		if (geoPC::is_classifieds()) {
			$db = DataAccess::getInstance();
			$listing_type_allowed = $db->get_site_setting('listing_type_allowed');
			if ($listing_type_allowed != 2 && $listing_type_allowed != 0) {
				//classified listings only, do not show auctions button
				return '';
			}
		}
		
		//see if allowed to by check
		$cart = geoCart::getInstance();
		if (!($cart->user_data['restrictions_bitmask'] & 1)) {
			//listing placement not allowed
			return '';
		}
		//see if max ads allowed is 0
		$maxAllowed = $cart->db->GetOne("SELECT `max_ads_allowed` FROM ".geoTables::price_plans_table." WHERE `price_plan_id`=".(int)$cart->user_data['auction_price_plan_id']);
		if ($cart->user_data['auction_price_plan_id'] && $maxAllowed == 0) {
			//max number of listings is 0, don't display add button
			return '';
		}
		$msgs = DataAccess::getInstance()->get_text(true);
		if ($inModule) {
			//really being called by my_account_links_newButton - same logic, different return value
			return array (
				'icon' => $msgs[500634],
				'label' => $msgs[500635]
			);
		} else {
			if(!$msgs) {
				//haven't gotten text for this page yet -- get it explicitly from cart main
				$msgs = DataAccess::getInstance()->get_text(true, 10202);
			}
			return $msgs[500251];
		}
	}
	
	public static function my_account_links_newButton ()
	{
		return self::geoCart_cartDisplay_newButton(true);
	}
	
	public static function adminItemDisplay ($item_id)
	{
		if (!$item_id){
			return '';
		}
		$item = geoOrderItem::getOrderItem($item_id);
		if (!is_object($item) || $item->getType() != self::type) {
			return '';
		}
		
		$info = '';
		$info .= geoHTML::addOption('Item Type','Auction Listing');
		parent::$_type = self::type;
		$info .= parent::adminItemDisplay($item_id);
		return $info;
	}
	
	public static function _initAuctionPricePlan(){
		$cart = geoCart::getInstance();
		
		if ($cart->price_plan['applies_to'] == 2){
			//nothing to do, price plan already is auction price plan.
			return;
		}
		if (!is_object($cart->item) || $cart->item->getType() !== self::type){
			//don't do anything if the item is not set
			return;
		}
		$cat = (is_object($cart->item))? $cart->item->getCategory(): 0;
		$plan = (is_object($cart->item))? $cart->item->getPricePlan(): 0;
		if (!$plan){
			$plan = $cart->user_data['auction_price_plan_id'];
		}
		$cart->setPricePlan($plan, $cat);
	}
	/**
	 * Optional.
	 * Used: in geoCart
	 * 
	 * This is used to display what the action is if this order item is the main type.  It should return
	 * something like "adding new listing" or "editing images".
	 * 
	 * @return string
	 */
	public static function getActionName ($vars)
	{
		$msgs = DataAccess::getInstance()->get_text(true);
		if ($vars['step'] == 'my_account_links') {
			//short version
			return $msgs[500636];
		} else {
			//action interupted text
			//text "placing new auction"
			return $msgs[500391];
		}
	}
	/**
	 * Optional.
	 * Used: in file classes/cron/close_listings.php
	 * 
	 * This is called for each listing that is being closed.  Note that the following things are
	 * automatically done: the "live" column is set to 0, and user favorites for the listing
	 * are removed.  Anything beyond that is up to being done in this function.
	 *
	 * @param array $vars Associative array, array('listing_details' => array(), 'cron_util' => close_listings_util object)
	 */
	public static function cron_close_listings($vars)
	{
		$listing = $vars['listing']; //a geoListing item.  see that class for more details.
		$cron = geoCron::getInstance();
		
		if ($listing->item_type != 2) {
			//not an auction
			return;
		}
		$db = DataAccess::getInstance();
		$cron->log('Top of auction cron close listings.',__line__ . ' - '.__file__);
		$current_time = geoUtil::time();
		$dutch_bidders = null;
		//Do anything specific to this type of item here.
		if ($cron->verbose) {
			echo __line__ . ' - '.__file__.' - '.$listing->current_bid." is the current_bid<br/>\n";
			echo $listing->id." is the id<br/>\n";
			echo $listing->title." is the title<br/>\n";
			echo $listing->seller." is the seller<br/>\n";
			echo $listing->auction_type." is auction_type<br/>\n";
			echo $listing->reserve_price." is reserver price<br/>\n";
			echo $current_time." is current time and ".$listing->ends." is auction ends<br/>\n";
		}

		if ($listing->auction_type == 1) {
			//standard auction single winner
			$high_bidder = self::_getHighBidder($listing->id);
			$cron->log('Hi bidder: '.print_r($high_bidder,1),__line__ . ' - '.__file__);
			$set_bidder = (isset($high_bidder['bidder']) && $high_bidder['bidder'])? ", `high_bidder` = ".$high_bidder['bidder']: '';
			$sql = "UPDATE ".geoTables::classifieds_table."
					SET `live` = 0,
					`final_price` = {$listing->current_bid} $set_bidder
					WHERE `id` = {$listing->id}";
			
		} else {
			$sql = "UPDATE ".geoTables::classifieds_table."
				SET `live` = 0,
				`final_price` = {$listing->current_bid}
				where id = {$listing->id}";
		}
		$update_result = $db->Execute($sql);
		$cron->log('running: '.$sql,__line__ . ' - '.__file__);
		if (!$update_result) {
			$cron->log('DB Error, sql: '.$sql."Error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
			return false;
		}
		
		if (($listing->current_bid >= $listing->reserve_price) && $listing->auction_type == 1 && $high_bidder) {
			//insert into feedback table
			$sql = "SELECT * FROM ".geoTables::auctions_feedbacks_table."
				where rated_user_id = ".$listing->seller."
				and rater_user_id = ".$high_bidder['bidder']."
				and auction_id = ".$listing->id;
			$check_feedback_result = $db->Execute($sql);
			$cron->log($sql,__line__ . ' - '.__file__);
			if (!$check_feedback_result) {
				$cron->log('DB Error, SQL: '.$sql." Error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
				return false;
			} else if ($check_feedback_result->RecordCount() == 0) {
				$sql = "insert into ".geoTables::auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values
					(".$listing->seller.",".$high_bidder['bidder'].",".$current_time.",".$listing->id.")";
				$insert_feedback_result = $db->Execute($sql);
				$cron->log($sql,__line__ . ' - '.__file__);
				if (!$insert_feedback_result) {
					$cron->log('DB Error, SQL: '.$sql." Error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
					return false;
				}
			}

			$sql = "select * from ".geoTables::auctions_feedbacks_table."
				where rated_user_id = ".$high_bidder['bidder']."
				and rater_user_id = ".$listing->seller."
 				and auction_id = ".$listing->id;
			$check_feedback_result = $db->Execute($sql);
			$cron->log($sql,__line__ . ' - '.__file__);
			if (!$check_feedback_result) {
				$cron->log('DB Error, sql: '.$sql.", error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
				return false;
			} else if ($check_feedback_result->RecordCount() == 0) {
				$sql = "insert into ".geoTables::auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values
					(".$high_bidder['bidder'].",".$listing->seller.",".$current_time.",".$listing->id.")";
				$insert_feedback_result = $db->Execute($sql);
				$cron->log($sql,__line__ . ' - '.__file__);
				if (!$insert_feedback_result) {
					$cron->log('DB Error, sql: '.$sql.", error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
					return false;
				}
			}
		}

		$seller_info = self::_getUserData($listing->seller);
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		if ($listing->auction_type == 1) {
			$msgs = $db->get_text(true, 10172);
			
			//standard single item auction
			if ($high_bidder){
				$high_bidder_info = self::_getUserData($high_bidder['bidder']);
				if (geoPC::is_ent() && ($listing->current_bid >= $listing->reserve_price)) {
					//hook for seller/buyer transactions, in case anything need be done here.
					$sb = geoSellerBuyer::getInstance();
					
					$vars = array (
						'listing_id' => $listing->id,
						'winning_bidder_id' => $high_bidder['bidder'],
						'listing' => $listing,
						'final_price' => $high_bidder['bid']
					);
					//TODO: Change the name, this name doesn't make sense, it should be something like listingClosed
					geoSellerBuyer::callUpdate('generatePaymentLink',$vars);
				}
			} else {
				$high_bidder_info = false;
			}
			
			//send email to seller and winner
			//send to seller
			self::_emailBuyerAndSeller($listing,$high_bidder, $high_bidder_info,$seller_info);
		} else {
			$msgs = $db->get_text(true, 10166);
			
			//dutch auction
			//get all bids starting with highest first
			$sql = "select * from ".geoTables::bid_table." where auction_id=".$listing->id." order by bid desc,time_of_bid asc";
			$bid_result = $db->Execute($sql);
			$cron->log($sql."<br/>\n",__line__ . ' - '.__file__);
			if (!$bid_result) {
				$cron->log($sql."<br/>\n",__line__ . ' - '.__file__);
				return false;
			} else if ($bid_result->RecordCount() > 0) {
				$total_quantity = $listing->quantity;
				//echo "total items sold - ".$total_quantity."<br/>\n";
				$final_dutch_bid = 0;
				$seller_report = "";
				$dutch_bidders = array();
				
				$msgs = $db->get_text(true, 10172);
				
				$dutch_quantities = array();
				while(($show_bidder = $bid_result->FetchRow()) && ($total_quantity > 0)) {
					if($show_bidder['bid'] < $listing->reserve_price) {
						//this bid didn't beat the reserve price -- skip it
						continue;
					}
					$bidder = $show_bidder['bidder'];
					$quantity_bidder_receiving = 0;
					if($show_bidder['quantity'] < $total_quantity) {
						$dutch_quantities[$bidder] = $show_bidder['quantity'];
						$total_quantity -= $show_bidder['quantity'];
					} else {
						$dutch_quantities[$bidder] = $total_quantity;
						$total_quantity = 0;
					}
					$final_dutch_bid = $show_bidder['bid'];
				}
				$cron->log($final_dutch_bid." is final_dutch_bid<br/>\n",__line__ . ' - '.__file__);
				$dutch_bidders = array();
				$display_final_bid = geoString::displayPrice($final_dutch_bid, $pre, $post);
				$seller_report = '';
				$quantity_sold = 0;
				foreach($dutch_quantities as $bidder => $quantity) {
					$cron->log($bidder." is bidder and ".$quantity." is the quantity received<br/>\n",__line__ . ' - '.__file__);
					$quantity_sold += $quantity;
					$local_key = count($dutch_bidders);
					$dutch_bidders[$local_key]["bidder"] = $bidder;
					$dutch_bidders[$local_key]["quantity"] = $quantity;
					$dutch_bidders[$local_key]["bid"] = $final_dutch_bid;
					$bidder_info = self::_getUserData($bidder);
					$seller_report .= $msgs[102769].$bidder_info['username']." ( ".$bidder_info['email']." )\n";
					$seller_report .= $msgs[500049].$quantity." @ ".$display_final_bid."\n";
					$bid_total = $quantity * $final_dutch_bid;
					$seller_report .= $msgs[102779].geoString::displayPrice($bid_total, $pre, $post)."\n";
					$seller_report .= self::_getAdditionalFeeTextDutch($listing, $dutch_bidders[$local_key])."\n";
					$seller_report .= $msgs[500050]."\n";
				}
				$seller_report = "\n\n".$msgs[102779].geoString::displayPrice(($quantity_sold * $final_dutch_bid),$pre,$post)."\n\n".$seller_report;
			
				//save final dutch bid as final_price and the winning bidders.
				$dutch_bidder_users = array();
				foreach ($dutch_bidders as $key => $value) {
					if ($listing->reserve_price <= $dutch_bidders[$key]["bid"]) {
						$dutch_bidder_users[]=$dutch_bidders[$key]['bidder'];
					}
				}
				$sql = "update ".geoTables::classifieds_table."
					set final_price = ".$final_dutch_bid;
				if (count($dutch_bidder_users)>0) {
					$sql .= ', high_bidder = \''.implode('|',$dutch_bidder_users).'\' ';
				}
				$sql .= "
					where id = ".$listing->id;
				$update_dutch_bid_result = $db->Execute($sql);
				$cron->log($sql."<br/>\n",__line__ . ' - '.__file__);
				if (!$update_dutch_bid_result) {
					$cron->log('Error running query: '.$sql." error: ".$db->ErrorMsg(),__line__ . ' - '.__file__);
					return false;
				}
				//send email to winning dutch bidder(s)
				self::_emailWinningDutchBidders($listing,$final_dutch_bid,$seller_info,$dutch_bidders);
				//send email to seller
				self::_emailDutchAuctionSeller($listing,$seller_report,$seller_info);
				
			} else {
				//no bids for this dutch auction
				//send email to seller
				self::_emailDutchAuctionSellerNoBidders($listing);
			}
		}
		return true;
	}
	
	/**
	 * Needed by archive_listings()
	 */
	private static function _getHighBidder($auction_id=0)
	{
		$db = DataAccess::getInstance();
		$auction_id = intval($auction_id);
		$sql = "select * from ".geoTables::bid_table." where auction_id=$auction_id order by bid desc,time_of_bid asc limit 1";
		return $db->GetRow($sql);
	}
	
	private static function _getUserData($user_id=0)
	{
		return geoUser::getUser($user_id)->toArray();
	}
	
	/**
	 * Function to e-mail the buyer and seller.
	 */
	private static function _emailBuyerAndSeller($listing, $high_bidder, $high_bidder_info, $seller_info)
	{
		//send email to seller and winner
		//send to seller
		$message_data["message"] = geoUser::getUser($seller_info['id'])->getSalutation();
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true);
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		if (($listing->reserve_price <= $listing->current_bid) && ($high_bidder) && ($listing->current_bid != 0)) {
			//successful body
			$message_data["message"] .= $msgs[102764]."\n\n";
			$message_data["message"] .= $high_bidder_info['firstname']." ".$high_bidder_info['lastname']."\n".$high_bidder_info['email']."\n";
			$message_data["message"] .= geoString::fromDB($listing->title)."\n\n";
			$display_amount = geoString::displayPrice($listing->current_bid, $pre, $post);
			$message_data["message"] .= "{$msgs[102779]} {$display_amount}\n\n";
			$message_data["message"] .= self::_getAdditionalFeeTextSeller($listing);
		} else {
			//auction unsuccessful -- check to see if we want to skip sending this email
			if(!$db->get_site_setting('notify_seller_unsuccessful_auction')) {
				return true;
			}
			$message_data["message"] .= $msgs[102765]."\n\n";
		}
		$message_data["message"] .= $db->get_site_setting('classifieds_url')."?a=2&amp;b=".$listing->id."\n\n";
		$message_data["subject"] = $msgs[102766];
		$cron = geoCron::getInstance();
		if ($cron->verbose) {
			echo "SENDING SELLER CLOSE EMAIL REG - ".$listing->id." - ".$listing->seller." - <br/><br/><pre>";
			var_dump($message_data);
			echo "</pre>\n";
		}
		$db->sendMail($seller_info['email'],$message_data["subject"],$message_data["message"]);
		$msgs = $db->get_text(true, 10174);
		
		if (($listing->reserve_price <= $listing->current_bid) && ($high_bidder) && ($listing->current_bid != 0)) {
			//send to winning bidder
			$message_data["message"] = ($high_bidder_info)? geoUser::getUser($high_bidder_info['id'])->getSalutation():'';
			// Body of message
			$message_data["message"] .= $msgs[102767]."\n\n";
			$message_data["message"] .= $seller_info['firstname']." ".$seller_info['lastname']."\n".$seller_info['email']."\n\n";
			$message_data["message"] .= geoString::fromDB($listing->title)."\n\n";
			$message_data["message"] .= $db->get_site_setting('classifieds_url')."?a=2&amp;b=".$listing->id."\n\n";
			$display_amount = geoString::displayPrice($listing->current_bid, $pre, $post);
			$message_data["message"] .= "$msgs[102770] $display_amount\n\n";
			$message_data['message'] .= self::_getAdditionalFeeTextBidder($listing);
			
			if (geoPC::is_ent()) {
				//see if there should be seller to buyer text
				$vars = array(
					'listing_id' => $listing->id,
					'winning_bidder_id' => $high_bidder['bidder'],
					'listing' => $listing,
					'final_price' => $listing->current_bid
				);
				$sb_links = geoSellerBuyer::callDisplay('displayPaymentLinkWinningBidderEmail', $vars);
				if (strlen($sb_links) > 0) {
					$message_data['message'].="\n".$sb_links;
				}
			}
			
			$message_data["subject"] = $msgs[102768];
			
			$db->sendMail($high_bidder_info['email'],$message_data["subject"],$message_data["message"]);
		}
	}
	
	/**
	 * Function to get additional fee text for seller.
	 */
	private static function _getAdditionalFeeTextSeller($listing)
	{
		//display any optional fields that add to the cost.
		$additional_costs = array ( 'total' => 0);
		$message_data = '';
		$db = DataAccess::getInstance();
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		if (geoPC::is_ent()) {
			$userId = $listing->seller;
			$groupId = ($userId)? geoUser::getUser($userId)->group_id : 0;
			
			$fields = geoFields::getInstance($groupId, $listing->category);
			for ($i = 1; $i < 21; $i++) {
				//go through all the optional fields, see if they add cost, and if they do,
				//see if the value actually adds any cost (not 0 or blank field)
				$option = 'optional_field_'.$i;
				
				if ($fields->$option->field_type == 'cost' && $listing->$option > 0) {
					//this optional field needs to be displayed.
					$additional_costs[$i] = geoString::displayPrice($listing->$option, $pre, $post);
					$additional_costs['total'] += $listing->$option;
				}
			}
		}
		if ($additional_costs['total']>0) {
			$msgs = $db->get_text(true);
			//there are additional costs to display!
			$message_data.= $msgs[500037]."\n";
			foreach ($additional_costs as $key => $cost) {
				//go through all the additional costs and display them
				if ($key != 'total') {
					//don't display the total twice!
					$message_data.=$cost."\n";
				}
			}
			//display the additional fee total.
			$message_data.= $msgs[500040].geoString::displayPrice($additional_costs['total'], $pre, $post)."\n\n";
			//display the grand total
			$grand_total = $listing->current_bid+$additional_costs['total'];
			$grand_total = geoString::displayPrice($grand_total, $pre, $post);
			$message_data .= $msgs[500038].$grand_total."\n\n";
			//display the additional fee disclaimer
			$message_data .= $msgs[500039]."\n\n";
		}
		return $message_data;
	}



	/**
	 * Function to get additional fee text for bidder.
	 */
	private static function _getAdditionalFeeTextBidder($listing)
	{
		//display any optional fields that add to the cost.
		$additional_costs = array ( 'total' => 0);
		$message_data = '';
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true);
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		for ($i = 1; $i < 21; $i++) {
			//go through all the optional fields, see if they add cost, and if they do,
			//see if the value actually adds any cost (not 0 or blank field)
			$option = 'optional_field_'.$i;
			$userId = $listing->seller;
			$groupId = ($userId)? geoUser::getUser($userId)->group_id : 0;
			
			$fields = geoFields::getInstance($groupId, $listing->category);
			if ($fields->$option->field_type == 'cost' && $listing->$option>0) {
				//this optional field needs to be displayed.
				$additional_costs[$i] = geoString::displayPrice($listing->$option, $pre, $post);
				$additional_costs['total'] += $listing->$option;
			}
		}
		if ($additional_costs['total']>0) {
			//there are additional costs to display!
			$message_data.= $msgs[500041]."\n";
			foreach ($additional_costs as $key => $cost) {
				//go through all the additional costs and display them
				if ($key != 'total'){
					//don't display the total twice!
					$message_data.=$cost."\n";
				}
			}
			//display the additional fee total.
			$message_data.=$msgs[500042].geoString::displayPrice($additional_costs['total'], $pre, $post)."\n\n";
			//display the grand total
			$grand_total = $listing->current_bid+$additional_costs['total'];
			$grand_total = geoString::displayPrice($grand_total, $pre, $post);
			$message_data.=$msgs[500043].$grand_total."\n\n";
			//display the additional fee disclaimer
			$message_data.=$msgs[500044]."\n\n";
		}
		return $message_data;
	}
	
	/**
	 * Function to get additional fee text for dutch end auction
	 */
	private static function _getAdditionalFeeTextDutch ($listing, $value)
	{
		//display any optional fields that add to the cost.
		$additional_costs = array ( 'total' => 0);
		$message_data = '';
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true);
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		for ($i = 1; $i < 21; $i++) {
			//go through all the optional fields, see if they add cost, and if they do,
			//see if the value actually adds any cost (not 0 or blank field)
			$option = 'optional_field_'.$i;
			$userId = $listing->seller;
			$groupId = ($userId)? geoUser::getUser($userId)->group_id : 0;
			
			$fields = geoFields::getInstance($groupId, $listing->category);
			if ($fields->$option->field_type == 'cost' && $listing->$option>0) {
				//this optional field needs to be displayed.
				$additional_costs[$i] = geoString::displayPrice($listing->$option, $pre, $post);
				$additional_costs['total'] += $listing->$option;
			}
		}
		if ($additional_costs['total']>0) {
			//there are additional costs to display!
			$message_data.= $msgs[500045]."\n";
			foreach ($additional_costs as $key => $cost) {
				//go through all the additional costs and display them
				if ($key != 'total'){
					//don't display the total twice!
					$message_data.=$cost."\n";
				}
			}
			//display the additional fee total.
			$message_data.=$msgs[500046].geoString::displayPrice($additional_costs['total'], $pre, $post)."\n";
			//display the grand total
			$total_per_item = $value["bid"]+$additional_costs['total'];
			$grand_total = $total_per_item * $value["quantity"];
			$total_per_item = geoString::displayPrice($total_per_item, $pre, $post);
			$grand_total = geoString::displayPrice($grand_total, $pre, $post);
			$message_data.=$msgs[500052].$total_per_item."\n\n";
			$message_data.=$msgs[500047].$grand_total."\n\n";
			//display the additional fee disclaimer
			$message_data.=$msgs[500048]."\n\n";
		}
		return $message_data;
	}
	
	/**
	 * Function to e-mail the winning dutch bidders, and also sets up feedback so they can do feedback
	 */
	private static function _emailWinningDutchBidders($listing, $final_dutch_bid, $seller_info, $dutch_bidders)
	{
		if (!is_array($dutch_bidders) || !count($dutch_bidders)) {
			return;
		}
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true);
		$pre = $listing->precurrency;
		$post = $listing->postcurrency;
		$display_final_bid = geoString::displayPrice($final_dutch_bid, $pre, $post);
		foreach ($dutch_bidders as $key => $value) {
			if ($listing->reserve_price > $dutch_bidders[$key]['bid']) {
				//this one doesnt get an e-mail for winning
				continue;
			}
			
			$bidder_info = self::_getUserData($dutch_bidders[$key]["bidder"]);
			$subject = $msgs[102771].geoString::fromDB($listing->title);

			$message = geoUser::getUser($bidder_info['id'])->getSalutation();
			$message .= $msgs[102772]."\n\n";
			$message .= $msgs[102773].$value["quantity"]." @ ".$display_final_bid."\n";
			$bid_total = $value['quantity'] * $final_dutch_bid;
			$message .= $msgs[102774].geoString::displayPrice($bid_total, $pre, $post)."\n\n";
			
			$message .= self::_getAdditionalFeeTextDutch($listing,$value);
			
			$message .= $msgs[102775]."\n".$seller_info['firstname']." ".$seller_info['lastname']."\n".$seller_info['username']." ( ".$seller_info['email']." )\n\n";
			$message .= $db->get_site_setting('classifieds_url')."?a=2&amp;b=".$listing->id."\n\n";
			$message .= "\n\n".$msgs[102776]."\n\n";
			
			$db->sendMail($bidder_info['email'],$subject,$message);
			
			
			//enter ability to make feedback

			$sql = "select * from ".geoTables::auctions_feedbacks_table."
				where rated_user_id = ".$dutch_bidders[$key]["bidder"]."
				and rater_user_id = ".$listing->seller."
				and auction_id = ".$listing->id;
			$check_feedback_result = $db->Execute($sql);
			
			if (!$check_feedback_result) {
				trigger_error('ERROR SQL: DB Error, sql: '.$sql." Error: ".$db->ErrorMsg());
				return false;
			}
			if ($check_feedback_result->RecordCount() == 0) {
				$sql = "insert into ".geoTables::auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values
					(".$dutch_bidders[$key]["bidder"].",".$listing->seller.",".geoUtil::time().",".$listing->id.")";
				$insert_feedback_result = $db->Execute($sql);
				
				if (!$insert_feedback_result) {
					trigger_error('ERROR SQL: DB Error, sql: '.$sql." Error: ".$db->ErrorMsg());
					return false;
				}
			}

			$sql = "select * from ".geoTables::auctions_feedbacks_table."
				where rated_user_id = ".$listing->seller."
				and rater_user_id = ".$dutch_bidders[$key]["bidder"]."
				and auction_id = ".$listing->id;
			$check_feedback_result = $db->Execute($sql);
			
			if (!$check_feedback_result) {
				trigger_error('ERROR SQL: DB Error, sql: '.$sql." Error: ".$db->ErrorMsg());
				return false;
			}
			if ($check_feedback_result->RecordCount() == 0) {
				$sql = "insert into ".geoTables::auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values
					(".$listing->seller.",".$dutch_bidders[$key]["bidder"].",".geoUtil::time().",".$listing->id.")";
				$insert_feedback_result = $db->Execute($sql);
				
				if (!$insert_feedback_result) {
					trigger_error('ERROR SQL: DB Error, sql: '.$sql." Error: ".$db->ErrorMsg());
					return false;
				}
			}
		}
	}
	


	/**
	 * Function to e-mail the dutch auction seller when there are winning bidders.
	 */
	private static function _emailDutchAuctionSeller($listing,$seller_report, $seller_info)
	{
		$db = DataAccess::getInstance();
		$msgs = $db->get_text(true, 10172);
		$subject = $msgs[102777].geoString::fromDB($listing->title);
		$message = geoUser::getUser($seller_info['id'])->getSalutation();
		$message .= $msgs[102778]."\n\n";
		//$message .= $msgs[102779].$final_dutch_bid."\n\n";
		$message .= $msgs[500050]."\n";
		$message .= $seller_report."\n\n";
		$message .= $db->get_site_setting('classifieds_url')."?a=2&amp;b=".$listing->id."\n\n";
		$message .= "\n\n".$msgs[102780]."\n\n";
		$db->sendMail($seller_info['email'],$subject,$message);
	}
	
	/**
	 * Function to e-mail the winning dutch bidders.
	 */
	private static function _emailDutchAuctionSellerNoBidders($listing)
	{
		//no bids for this dutch auction
		//send email to seller
		$db = DataAccess::getInstance();
		if(!$db->get_site_setting('notify_seller_unsuccessful_auction')) {
			//don't inform seller of unsuccessful auction
			return true;
		}
		$msgs = $db->get_text(true, 10172);
		$subject = $msgs[102777].geoString::fromDB($listing->title);
		$message = geoUser::getUser($listing->seller)->getSalutation();
		$message .= $msgs[102781]."\n\n";
		$message .= geoString::fromDB($listing->title)."\n\n";
		$message .= $db->get_site_setting('classifieds_url')."?a=2&amp;b=".$listing->id;
		
		$db->sendMail($seller_info['email'],$subject,$message);
	}

	/**
	 * Easy way to identify items that are Listing parent items
	 * (i.e. classified and auction items)
	 * 
	 * superclass returns false, so only items that directly represent listings need this function
	 */
	public function isListingItem()
	{
		return true;
	}
	
	protected static function anonymousAllowed ()
	{
		if (!geoPC::is_auctions()) { return false; }
		
		$db = DataAccess::getInstance();
			
		if($db->get_site_setting('jit_registration')) {
			return true;
		}
		
		return false;
	}
}