<?php
//bidpay.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 13110              $ ##
## File last change date:       ##
##  $Date:: 2008-06-24 15:42:#$ ##
##                              ##
##################################

class bidpaySellerBuyerGateway {
	var $apiUrl = 'sandbox.api.bidpay.com';
	//var $apiUrl = 'api.bidpay.com';
	
	var $sellerTokenUrl = 'https://sandbox.bidpay.com/SellerToken.aspx';
	//var $sellerTokenUrl = 'https://bidpay.com/SellerToken.aspx'; //is this correct "live" url?
	
	function adminUpdateSettings(){
		$db = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		
		//BIDPAY - save settings
		$go_ahead = (isset($_POST['bidpay_allow']) && $_POST['bidpay_allow'])? 1: false;
		$sb = geoSellerBuyer::getInstance();
		
		
		
		//check inputs
		
		if (!isset($_POST['bidpay_site_username']) || strlen(trim($_POST['bidpay_site_username'])) == 0){
			$menu_loader->userError('BidPay Username Required.');
			$go_ahead = false;
		}
		if (!isset($_POST['bidpay_site_pass']) || strlen(trim($_POST['bidpay_site_pass'])) == 0){
			$menu_loader->userError('Generated API Password Required for BidPay.');
			$go_ahead = false;
		} elseif (strlen($_POST['bidpay_site_pass']) != 512){
			$menu_loader->userError('Generated API Password does not seem to be valid (wrong length) for BidPay.  Note that this needs to be the API password generated by BidPay under "Bidpay Management" when you log into the Bidpay website, it is NOT the password you use to log into the BidPay website.');
			$go_ahead = false;
		}
		if (!isset($_POST['bidpay_site']) || strlen(trim($_POST['bidpay_site'])) == 0){
			$menu_loader->userError('Site Name required for BidPay.  This should be the "name" of your site, for instance "Joe\'s Auctions".  The setting will be shown when an auction buyer is checking out in BidPay.');
			$go_ahead = false;
		}
		if (!isset($_POST['bidpay_connection_library']) || strlen(trim($_POST['bidpay_connection_library'])) == 0){
			$menu_loader->userError('Connection library is required to use BidPay.  If your server does not meet any of the requirements, contact your host to see if the missing requirements can be added or enabled on your site.');
			$go_ahead = false;
		}
		if (!isset($_POST['bidpay_site_url']) || strlen(trim($_POST['bidpay_site_url'])) == 0){
			$menu_loader->userError('Secure SSL Site URL required for BidPay.  Bidpay requires a secure "return URL" for security reasons, so you will need to have a SSL certificate set up and working on your site.');
			$go_ahead = false;
		} elseif (strpos($_POST['bidpay_site_url'],'https') === false){
			$menu_loader->userError('Secure SSL Site URL for BidPay requires an "SSL" URL, which means it starts with <em>https://</em> (compared to normal URLs that use <em>http://</em>)');
			$go_ahead = false;
		}
		
		if ($go_ahead && !$db->get_site_setting('bidpay_allow')){
			$sb->initTableStructure();//make sure table structure is initialized.
			//turn on bidpay for all price plans
			$plans = $this->_getAuctionPricePlans();
			foreach ($plans as $plan_id){
				//set main price plan default settings
				$sb->setDefaultPlanSettings($plan_id,0,array('bidpay_allow'=>true));
				
				//get any cat price plans for this price plan, and set default settings
				$cat_plans = $this->_getAuctionPricePlans($plan_id);
				foreach ($cat_plans as $cat_plan_id){
					//set cat price plan default settings
					$sb->setDefaultPlanSettings(0,$cat_plan_id,array('bidpay_allow'=>true));
				}
			}
		}
		$db->set_site_setting('bidpay_allow',$go_ahead);
		$user = (isset($_POST['bidpay_site_username']))? $_POST['bidpay_site_username'] : '';
		$pass = (isset($_POST['bidpay_site_pass']))? $_POST['bidpay_site_pass'] : '';
		$site = (isset($_POST['bidpay_site']))? $_POST['bidpay_site'] : '';
		$library = (isset($_POST['bidpay_connection_library']))? $_POST['bidpay_connection_library']: 'PEAR';
		$site_url = (isset($_POST['bidpay_site_url']))? $_POST['bidpay_site_url']: '';
		
		$db->set_site_setting('bidpay_site_username', $user);
		$db->set_site_setting('bidpay_site_pass', $pass,true);
		$db->set_site_setting('bidpay_site',$site);
		$db->set_site_setting('bidpay_connection_library',$library);
		$db->set_site_setting('bidpay_site_url',$site_url);
		return true;
	}
	
	function adminUpdatePricePlanSettings($vars){
		$db = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		
		$price_plan_id = $vars['price_plan_id'];
		$category = $vars['category'];
		
		if (!$db->get_site_setting('bidpay_allow')){
			return true; //main setting turned off, nothing to save...
		}
		
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		
		$sb = geoSellerBuyer::getInstance();
		
		//BIDPAY - save settings
		if (isset($_POST['bidpay_allow']) && $_POST['bidpay_allow']){
			$sb->setPlanSetting($price_plan_id, $category,'bidpay_allow',true);
			
			return true;
		}
		//un-checked, turn off
		$sb->setPlanSetting($price_plan_id, $category,'bidpay_allow',false);
		return true;
	}
	
	function adminDisplaySettings(){
		$db = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		
		//include needed soap libraries
		geoUtil::includePEAR('SOAP/Client.php');
		geoUtil::includePEAR('SOAP/Type/dateTime.php');
		
		$allow_bidpay_check = ($db->get_site_setting('bidpay_allow'))? 'checked="checked" ': '';
		$bidpay_username = $db->get_site_setting('bidpay_site_username');
		$bidpay_pass = $db->get_site_setting('bidpay_site_pass',true);
		$bidpay_site = $db->get_site_setting('bidpay_site');
		$bidpay_site_url = $db->get_site_setting('bidpay_site_url');
		
		if (strlen($bidpay_site_url) == 0){
			$bidpay_site_url = $db->get_site_setting('classifieds_ssl_url');
			if (strlen($bidpay_site_url) == 0){
				$bidpay_site_url = str_replace('http:','https:',$db->get_site_setting('classifieds_url'));
			}
		}
		
		$installed = '<span style="color: green;">INSTALLED</span>';
		$not_installed = '<span style="color: red;">NOT INSTALLED</span>';
		
		$pear_test = '
		- SOAP_Client - '.((class_exists('SOAP_Client'))? $installed: $not_installed).'<br />
		- SOAP_Type_dateTime - '.((class_exists('SOAP_Type_dateTime'))? $installed: $not_installed).'<br />
		';
		
		$curl_test = (extension_loaded('curl'))? $installed: $not_installed;
		
		$pear_checked = '';
		$supported_library = false;
		if (class_exists('SOAP_Client') && class_exists('SOAP_Type_dateTime')){
			//for now, it's always checked because it's the only option.
			
			//Once other connection libraries are added, make this only
			// selected if it's the one selected.
			
			$pear_checked = ' checked="checked"';
			$supported_library = true;
		} else {
			$pear_checked = ' disabled="disabled"';
		}
		
		if (!$supported_library || !extension_loaded('curl')){
			//none of the libraries requirements are met, so can't use bidpay!
			$allow_bidpay_check = 'disabled="disabled"';
		}
		$bidpay_images = "<div class=\"row_color2\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/120x90-ClickHeretoPay.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/120x90-ClickHeretoPay.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/120x90-PayNow.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/120x90-PayNow.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/120x60-Checkout.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/120x60-Checkout.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/120x60-ClickHeretoPay.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/120x60-ClickHeretoPay.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/120x60-PayNow.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/120x60-PayNow.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/88x31-Checkout.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/88x31-Checkout.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/88x31-ClickHeretoPay.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/88x31-ClickHeretoPay.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/Images/PaymentButton/88x31-PayNow.jpg' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/Images/PaymentButton/88x31-PayNow.jpg</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\"><img src='https://www.bidpay.com/images/PaymentButton/PaymentButton3.gif' /></div>
		<div class=\"rightColumn\">https://www.bidpay.com/images/PaymentButton/PaymentButton3.gif</div>
		<div class=\"clearColumn\"></div>
	</div>";
		
		$html = "
<script type=\"text/javascript\">
//writeConsole();
function writeConsole() {
 top.consoleRef=window.open('','myconsole',
  'width=450,height=250'
   +',menubar=0'
   +',toolbar=1'
   +',status=0'
   +',scrollbars=1'
   +',resizable=1')
 top.consoleRef.document.writeln(
  '<html><head><title>BidPay Images and Logos</title></head>'
   +'<body bgcolor=white onLoad=\"self.focus()\">'
   +'<h1>Official Bidpay Images</h1>'
   +'These images below can be used in templates and site text.  Just use the URL specified.<br /><br />'
   +'".addslashes(str_replace("\n",'',$bidpay_images))."'
   +'</body></html>'
 )
 top.consoleRef.document.close()
}
</script>
	<div class=\"col_hdr\"><div style=\"float:right;\"><img src=\"https://www.bidpay.com/images/PaymentButton/PaymentButton3.gif\" alt=\"\" /></div>BidPay for Auction Winning Bidder to pay Seller</div>
	<div class=\"clearColumn\"></div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\">Enable BidPay</div>
		<div class=\"rightColumn\">
			<input type=\"checkbox\" name=\"bidpay_allow\" value=\"1\" $allow_bidpay_check/>
		</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\">Requirements: </div>
		<div class=\"rightColumn\">
			- <a href=\"http://www.php.net/manual/en/ref.curl.php\" target=\"_blank\">Curl</a> Extension - $curl_test<br />
			- Requirements for selected <em>Connection Library</em> met<br />
			- Secure SSL Site URL configured &amp; working
		</div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\">BidPay Username</div>
		<div class=\"rightColumn\"><input type=\"text\" name=\"bidpay_site_username\" value=\"{$bidpay_username}\" /></div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\">Generated API Password</div>
		<div class=\"rightColumn\"><input type=\"text\" name=\"bidpay_site_pass\" value=\"{$bidpay_pass}\" /></div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\">Generate an API Password: </div>
		<div class=\"rightColumn\"><a href=\"https://{$this->apiUrl}\">Login/Register at Bidpay</a></div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\">Connection Library: </div>
		<div class=\"rightColumn\">
			<label><input type=\"radio\" name=\"bidpay_connection_library\" value=\"PEAR\"$pear_checked /> PEAR Libraries<br />
				<div style=\"margin-left: 25px;\">
					<strong>Requires <a href=\"http://pear.php.net/package/SOAP\" target=\"_blank\">SOAP Package</a> (and Dependencies):</strong><br />
					$pear_test
				</div>
		</div>
		<div class=\"clearColumn\"></div>
	</div>
	<br />
	<div class=\"row_color1\">
		<div class=\"leftColumn\">Secure SSL Site URL</div>
		<div class=\"rightColumn\"><input type=\"text\" name=\"bidpay_site_url\" value=\"{$bidpay_site_url}\" /></div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color2\">
		<div class=\"leftColumn\">Site Name (shown when paying on BidPay)</div>
		<div class=\"rightColumn\"><input type=\"text\" name=\"bidpay_site\" value=\"{$bidpay_site}\" /></div>
		<div class=\"clearColumn\"></div>
	</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\">Official BidPay Images (use in templates or text)</div>
		<div class=\"rightColumn\"><a href=\"javascript:void(0)\" onclick=\"writeConsole()\">Click to view Images</a></div>
		<div class=\"clearColumn\"></div>
	</div>
";
		return $html;
	}
	
	function adminDisplayPricePlanSettings($vars){
		if (PHP5_DIR) $menu_loader = geoAdmin::getInstance();
		else $menu_loader =& geoAdmin::getInstance();
		
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return '';
		}
		$price_plan_id = $vars['price_plan_id'];
		$category = $vars['category'];
		
		$sb = geoSellerBuyer::getInstance();
		$allow_bidpay_check = ($sb->getPlanSetting($price_plan_id, $category, 'bidpay_allow'))? 'checked="checked" ': '';
		$html = "
	<div class=\"col_hdr\"><img src=\"https://www.bidpay.com/images/PaymentButton/PaymentButton3.gif\" alt=\"\" /> BidPay for Auction Winning Bidder to pay Seller</div>
	<div class=\"row_color1\">
		<div class=\"leftColumn\">Enable BidPay</div>
		<div class=\"rightColumn\">
			<input type=\"checkbox\" name=\"bidpay_allow\" value=\"1\" $allow_bidpay_check/>
		</div>
		<div class=\"clearColumn\"></div>
	</div>
";
		return $html;
	}
	
	function displayUserDetails($vars){
		//see if we already have user token
		$sb = geoSellerBuyer::getInstance();
		
		$user_id = intval($vars['user_id']);
		$price_plan_id = intval($vars['price_plan_id']);
		
		if (!$user_id || !$price_plan_id){
			return '';
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return ;
		}
		$this->_saveUserToken($user_id);
		
		
		
		$token = $sb->getUserSetting($user_id, 'bidpay_token');
		$field_tpl = "
	<tr>
		<td class=\"field_labels\">
			(!LABEL!)
		</td>
		<td class=\"data_values\">
			(!VALUE!)
		</td>
	</tr>";
		$search_array = array('(!LABEL!)','(!VALUE!)');
		$messages = $this->_getText(37);
		$label = geoString::fromDB($messages[500204]);
		$val = '';
		if (!$token){
			//if not, display login/register to BidPay to turn on linky
			$val = $this->_getTokenLink($user_id);
		} else {
			//if so, show "token cool" button
			//$val = $token;
			$val = geoString::fromDB($messages[500205]).$this->_getTokenLink($user_id,1);
		}
		if (strlen($val) == 0){
			return '';
		}
		$html = str_replace($search_array,array($label, $val),$field_tpl);
		
		return $html;
	}
	
	function displayPaymentTypesDetails ($vars){
		//check inputs
		$user_id = intval($vars['user_id']);
		$category = intval($vars['category']);
		$price_plan_id = intval($vars['price_plan_id']);
		$session_id = $vars['sell_session_id'];
		
		if (!$user_id || !$price_plan_id) {
			//invalid input
			return '';
		}
		
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return ;
		}
		
		$sb = geoSellerBuyer::getInstance();
		
		//make sure bidpay is turned on for price plan
		if (!$sb->getPlanSetting($price_plan_id, $category, 'bidpay_allow')){
			return '';
		}
		
		//make sure user has bidpay token
		if (strlen(trim($sb->getUserSetting($user_id,'bidpay_token'))) == 0 ){
			return '';
		}
		
		if (strlen($session_id) > 0){
			//see if setting is set in session already
			$bidpay_allow = $sb->getCartItemSetting('bidpay_allow');
			//Possible future feature: 
			//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
			$bidpay_force = $sb->getCartItemSetting('bidpay_force');
			
			$allow_checked = ($bidpay_allow)? 'checked="checked" ': '';
			
			$messages = $this->_getText(9);
			$html = "
			<input type=\"hidden\" name=\"bidpay_allow\" value=\"0\" />
			<label><input type=\"checkbox\" name=\"bidpay_allow\" value=\"1\" $allow_checked/>&nbsp;".geoString::fromDB($messages[500185])."</label>";
			
			return $html;
			
			//return "info passed: <pre>".print_r($vars,1)."</pre>";
		}
		
		//sell session not known?
		return '';
	}
	
	function displayPaymentTypesDetailsEdit ($vars){
		//check inputs
		$user_id = intval($vars['user_id']);
		$category = intval($vars['category']);
		$price_plan_id = intval($vars['price_plan_id']);
		$listing_id = intval($vars['listing_id']);
		$session_id = $vars['sell_session_id'];
		
		if (!$user_id || !$price_plan_id || !$listing_id){
			//invalid input
			return '';
		}
		
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return ;
		}
		
		$sb = geoSellerBuyer::getInstance();
		
		//make sure bidpay is turned on for price plan
		if (!$sb->getPlanSetting($price_plan_id, $category, 'bidpay_allow')){
			return '';
		}
		
		//make sure user has bidpay token
		if (strlen(trim($sb->getUserSetting($user_id,'bidpay_token'))) == 0 ){
			return '';
		}
		
		
		//see if setting is set in session already
		$bidpay_allow = $sb->getListingSetting($listing_id,'bidpay_allow');
		//Possible future feature: 
		//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
		$bidpay_force = $sb->getListingSetting($listing_id,'bidpay_force');
		
		$allow_checked = ($bidpay_allow)? 'checked="checked" ': '';
		
		$messages = $this->_getText(32);
		$html = "
		<input type=\"hidden\" name=\"bidpay_allow\" value=\"0\" />
		<label><input type=\"checkbox\" name=\"bidpay_allow\" value=\"1\" $allow_checked/>&nbsp;".geoString::fromDB($messages[500186])."</label>
		";
		
		return $html;
	}
	
	function displayPaymentTypesApprove ($vars){
		//check inputs
		$session_id = $vars['sell_session_id'];
		
		if (!$listing_id && strlen($session_id) != 32){
			//neither is set!
			return '';
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return '';
		}
		$sb = geoSellerBuyer::getInstance();
		
		//if listing id is set, see if there are current settings already set for the listing
		
		if (strlen($session_id) > 0){
			//see if setting is set in session already
			$bidpay_allow = $sb->getCartItemSetting('bidpay_allow');
			//Possible future feature: 
			//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
			$bidpay_force = $sb->getCartItemSetting('bidpay_force');
			$html = '';
			if ($bidpay_allow){
				$messages = $this->_getText(11);
				$html = geoString::fromDB($messages[500187]);
			}
			
			
			return $html;
			
			//return "info passed: <pre>".print_r($vars,1)."</pre>";
		}
		
		//sell session not known?
		return '';
	}
	
	function displayPaymentTypesEdit ($vars){
		//check inputs
		$listing_id = intval($vars['listing_id']);
		
		if (!$listing_id){
			//neither is set!
			return '';
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return '';
		}
		$sb = geoSellerBuyer::getInstance();
		
		//if listing id is set, see if there are current settings already set for the listing
		
		//see if setting is set in session already
		$bidpay_allow = $sb->getListingSetting($listing_id,'bidpay_allow');
		//Possible future feature: 
		//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
		$bidpay_force = $sb->getListingSetting($listing_id,'bidpay_force');
		$html = '';
		if ($bidpay_allow){
			$messages = $this->_getText(31);
			$html = geoString::fromDB($messages[500189]);
		}
		
		return $html;
	}
	
	function displayPaymentTypesListing($vars){
		//check inputs
		$listing_id = intval($vars['listing_id']);
		
		if (!$listing_id){
			//neither is set!
			return '';
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return '';
		}
		$sb = geoSellerBuyer::getInstance();
		
		//see if setting is set in session already
		$bidpay_allow = $sb->getListingSetting($listing_id,'bidpay_allow');
		//Possible future feature: 
		//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
		$bidpay_force = $sb->getListingSetting($listing_id,'bidpay_force');
		$html = '';
		if ($bidpay_allow){
			$messages = $this->_getText(1);
			$html = geoString::fromDB($messages[500190]);
		}
		
		return $html;
		
		
		//sell session not known?
		return '';
	}
	
	
	function displayPaymentLinkBuyNowSuccess ($vars){
		$messages = $this->_getText(10165);
		$payment_text = array(
			'payment_link' => geoString::fromDB($messages[500191]),
			'already_paid' => geoString::fromDB($messages[500196])
		);
		return $this->_getPaymentLink($vars, $payment_text);
	}
	function displayPaymentLinkListing ($vars){
		$messages = $this->_getText(1);
		$payment_text = array(
			'payment_link' => geoString::fromDB($messages[500192]),
			'already_paid' => geoString::fromDB($messages[500197])
		);
		return $this->_getPaymentLink($vars, $payment_text);
	}
	function displayPaymentLinkCurrentBids($vars){
		$messages = $this->_getText(10175);
		$payment_text = array(
			'payment_link' => geoString::fromDB($messages[500193]),
			'already_paid' => geoString::fromDB($messages[500198])
		);
		return $this->_getPaymentLink($vars, $payment_text);
	}
	
	function displayPaymentLinkBuyNowEmail($vars){
		$messages = $this->_getText(10167);
		$payment_text = array(
			'email_text' => geoString::fromDB($messages[500206])
		);
		return $this->_getPaymentLink($vars, $payment_text);
	}
	function displayPaymentLinkWinningBidderEmail($vars){
		$messages = $this->_getText(10174);
		$payment_text = array(
			'email_text' => geoString::fromDB($messages[500207])
		);
		return $this->_getPaymentLink($vars, $payment_text);
	}
	
	function generatePaymentLink_no_use($vars){
		//no longer need to do this...
		//check inputs
		$listing_id = intval($vars['listing_id']);
		$winning_bidder_id = intval($vars['winning_bidder_id']);
		$listing_details = $vars['listing_details'];
		$final_price = $vars['final_price'];
		
		$timeout = 30; //this is called as a cron job, so can set timeout to be long
		
		if (!$listing_id || !$winning_bidder_id){
			//neither is set!
			return ;
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return ;
		}
		$sb = geoSellerBuyer::getInstance();
		
		//see if setting is set in session already
		$bidpay_allow = $sb->getListingSetting($listing_id,'bidpay_allow');
		//Possible future feature: 
		//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
		$bidpay_force = $sb->getListingSetting($listing_id,'bidpay_force');
		if ($bidpay_allow){
			
			$this->_getPaymentUrl($listing_id, $winning_bidder_id, $listing_details, $final_price, $timeout);
		}
	}
	
	
	
	function saveFormVars($vars){
		//check inputs
		$user_id = intval($vars['user_id']);
		$category = intval($vars['category']);
		$price_plan_id = intval($vars['price_plan_id']);
		$listing_id = intval($vars['listing_id']);
		$session_id = $vars['sell_session_id'];
		
		if (!$user_id || !$price_plan_id){
			//invalid input
			return '';
		}
		
		if (strlen($session_id) != 32 && !$listing_id){
			return ;//something wrong with session id or listing id
		}
		if (isset($_POST['bidpay_allow'])){
			$sb = geoSellerBuyer::getInstance();
			
			if (!$this->_bidpayAllowed()){
				//bidpay system turned off.
				return ;
			}
			
			//make sure bidpay is turned on for price plan
			if (!$sb->getPlanSetting($price_plan_id, $category, 'bidpay_allow')){
				return ;
			}
			
			//make sure user has bidpay token
			if (strlen(trim($sb->getUserSetting($user_id,'bidpay_token'))) == 0 ){
				//user token not set
				return ;
			}
			
			$bidpay_allow = (isset($_POST['bidpay_allow']) && $_POST['bidpay_allow'])? 1: 0;
			
			if ($listing_id > 0){
				//listing id given, so update the listing data as well
				$sb->setListingSetting($listing_id, 'bidpay_allow', $bidpay_allow);
			} 
			
			if (strlen($session_id) == 32){
				//update session info
				$sb->setCartItemSetting('bidpay_allow', $bidpay_allow);
			}
		}
	}
	
	function insertNewListing($vars){
		//check inputs
		$listing_id = intval($vars['listing_id']);
		$session_id = $vars['sell_session_id'];
		
		if (!$listing_id || strlen(trim($session_id)) == 0){
			return ;
		}
		
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return ;
		}
		//just copy whats in the session, to be whats in the listing.  We've already checked all the settings
		//when we saved (or didn't save) settings in the session.
		
		$sb = geoSellerBuyer::getInstance();
		
		$bidpay_allow = $sb->getCartItemSetting('bidpay_allow');
		
		if ($bidpay_allow){
			//save setting for listing
			$sb->setListingSetting($listing_id,'bidpay_allow',$bidpay_allow);
		}
	}
	
	function sellerBuyerPage ($vars){
		//vars is not used.
		//called when a=sb_transaction is used.
		if (!isset($_GET['action']) || substr($_GET['action'],0,6) != 'bidpay'){
			//this is not meant for us.
			return '';
		}
		
		if ($_GET['action'] == 'bidpay_payment'){
			return $this->_actionBidpayPayment();
			
		} elseif ($_GET['action'] == 'bidpay_p_result') {
			return $this->_actionPResult();
		} else {
			//not a valid thingy
			
			return 'Site Error.  Please try again.';
		}
	}
	
	function _actionBidpayPayment (){
		//re-direct them to bidpay to pay for something
		//validation!!!
		$listing_id = isset($_GET['listing_id'])? intval($_GET['listing_id']): 0;
		
		
		if (!$listing_id){
			//invalid input
			return '';
		}
		
		$sb = geoSellerBuyer::getInstance();
		
		$winning_bidder_id = intval($sb->getListingSetting($listing_id,'winning_bidder_id'));
		if (!$winning_bidder_id){
			//winning bidder not known.
			return '';
		}
		
		//check to make sure current logged in user is valid.
		$db = true;
		$session = true;
		include GEO_BASE_DIR.'get_common_vars.php';
		
		$current_session_id = $session->getUserID();
		
		if ($current_session_id == 0){
			//Should not get to this, in the index it should send them to login screen.
			//this is just a double-security precaution...
			return 'You must be logged in to do this.';
		}
		
		if ($session->getUserID() != $winning_bidder_id){
			if ($session->getUserID() == 1){
				//admin user
				//Hard-coded:  Only the admin user will ever see this text!
				return '<h2>Payment Disabled for Admin User</h2>
				The BidPay Payment link was shown on the previous page so that you as the <strong>site admin</strong>
				can more easily design the templates for that page.  <strong>Only the winning bidder</strong> is allowed to actually
				go through the payment process, however.';
			}
			//not valid, winning bidder does not match.
			return '';
		}
		
		
		//get listing details.
		$sql = 'SELECT * FROM '.$db->geoTables->classifieds_table.' WHERE `id`='.$listing_id.' LIMIT 1';
		
		$result = $db->Execute($sql);
		if (!$result){
			trigger_error('ERROR SQL: Sql: '.$sql.' Error: '.$db->ErrorMsg());
			return '';
		}
		
		$listing_details = $result->FetchRow();
		if (!is_array($listing_details) || count($listing_details) == 0){
			//something is wrong..
			return '';
		}
		
		$final_price = $sb->getListingSetting($listing_id,'final_price');
		
		if (!$final_price){
			trigger_error('DEBUG BIDPAY: Final price not attached to listing id, have to get it manually!');
			return '';
		}
		
		
		$timeout = 10;
		$messages = $this->_getText(10201);
		if ($sb->getListingSetting($listing_id,'bidpay_listing_paid')){
			return '<div class="bidpay_listing_paid_text">'.geoString::fromDB($messages[500199]).'</div>';
		}
		
		$link = $this->_getPaymentUrl($listing_id, $winning_bidder_id, $listing_details, $final_price, $timeout);
		if (strlen($link) > 0){
			//cool, looks like we got the link good.  Re-direct to bidpay.
			header('Location: '.$link);
			//the end user should never see the below message unless the re-direct above didn't work.
			return '
			<div class="bidpay_start_payment_text">
				'.geoString::fromDB($messages[500200]).'
				<a href="'.$link.'" class="bidpay_start_payment_text_link">'.geoString::fromDB($messages[500201]).'</a>
			</div>';
		} else {
			//there was an error with bidpay, either timeout, or some error returned from BidPay.
			return '
			<div class="bidpay_start_payment_error">
				'.geoString::fromDB($messages[500202]).'
			</div>';
		}
	}
	
	function _actionPResult(){
		//validate it
		$listing_id = (isset($_GET['l_id']))? intval($_GET['l_id']): 0;
		
		if (!$listing_id){
			return 'Site Error';
		}
		$session = true;
		include GEO_BASE_DIR.'get_common_vars.php';
		$this_user_id = $session->getUserId();
		
		$sb = geoSellerBuyer::getInstance();
		
		//make sure stuff is all valid
		$is_valid = true;
		$winning_bidder_id = intval($sb->getListingSetting($listing_id,'winning_bidder_id'));
		if (!$winning_bidder_id){
			//winning bidder not known.
			$is_valid = false;
		}
		
		if ($winning_bidder_id != $this_user_id){
			//user id does not match!
			$is_valid = false;
		}
		
		//see if listing is currently in progress of a transaction:
		$bidpay_transaction = $sb->getListingSetting($listing_id, 'bidpay_TransactionID');
		
		if (!is_array($bidpay_transaction) && count($bidpay_transaction) == 0){
			//listing is not currently in midle of transaction!
			$is_valid = false;
		}
		
		if ($is_valid){
			//bidder matches, listing is in middle of transaction, etc. so it looks like this is valid.
			//go ahead and save that the listing has been paid for.  This is only for quickness sake when
			//displaying the purchase button to the user, for the seller we are going to make an API call
			//to get the status of the transaction, just in case.
			$sb->setListingSetting($listing_id,'bidpay_listing_paid',1);
		}
		
		//Always show the "payment finished" message, just in case so the user doesn't try to pay for it again
		//for instances like if the session for the user has expired...
		$messages = $this->_getText(10201);
		return '<div class="bidpay_payment_success_text">'.geoString::fromDB($messages[500203]).'</div>';
	}
	
	function _getTokenLink($user_id, $reset = false){
		$db = true;
		include GEO_BASE_DIR.'get_common_vars.php';
		
		$sb = geoSellerBuyer::getInstance();
		if (!$db->get_site_setting('bidpay_allow')){
			return '';
		}
		
		$return_url = $db->get_site_setting('bidpay_site_url').'?a=4&b=3';
		
		if ($reset){
			$messages = $this->_getText(37);
			return ' (<a href="'.$return_url.'&bp_clear=1">'.geoString::fromDB($messages[500194]).'</a>)';
		}
		$api_username = $db->get_site_setting('bidpay_site_username');
		$api_pass = $db->get_site_setting('bidpay_site_pass',true);
		
		
		if (strlen($api_username) == 0 || strlen($api_pass) == 0){
			return ''; //username or pass not set
		}
		
		//get a reference number and keep track of it.
		$ref_num = $sb->getUserSetting($user_id, 'bidpay_tok_ref_num');
		if (strlen($ref_num) != 40){
			$ref_num = sha1('a ref num randomly generated.'.$user_id.time().rand());
			
			//save the setting
			$sb->setUserSetting($user_id, 'bidpay_tok_ref_num',$ref_num);
		}
		
		$url_parts['ApiUsername'] = $api_username;
		$url_parts['ReferenceNumber'] = $ref_num;
		$url_parts['ReturnURLAccept'] = urlencode($return_url.'&bp_accept=1');
		$url_parts['ReturnURLReject'] = urlencode($return_url.'&bp_accept=0');
		$parts = array();
		foreach ($url_parts as $key=>$value)
			$parts[] = $key.'='.$value;
		$messages = $this->_getText(37);
		$link_txt = geoString::fromDB($messages[500195]);
		return '<a href="'.$this->sellerTokenUrl.'?'.implode('&amp;',$parts).'">'.$link_txt.'</a>';
	}
	
	function _getPaymentLink($vars, $link_text){
		//check inputs
		$listing_id = intval($vars['listing_id']);
		$winning_bidder_id = intval($vars['winning_bidder_id']);
		$listing_details = $vars['listing_details'];
		$final_price = $vars['final_price'];
		
		
		$timeout = 10; //this is called as part of a page load, so set timeout to be not so long
		
		if (!$listing_id || !$winning_bidder_id || strlen($link_text) == 0){
			//input vars not good!
			return '';
		}
		if (!$this->_bidpayAllowed()){
			//bidpay system turned off.
			return '';
		}
		
		if (!$final_price){
			trigger_error('DEBUG BIDPAY: Final price 0 or not specified, so can\'t be processed by bidpay...');
			return '';
		}
		
		$sb = geoSellerBuyer::getInstance();
		
		//see if setting is set in session already
		$bidpay_allow = $sb->getListingSetting($listing_id,'bidpay_allow');
		
		//make sure the seller token is still good
		$seller=(is_object($listing_details))? $listing_details->SELLER: $listing_details['seller'];
		$seller_token = $sb->getUserSetting($seller, 'bidpay_token');
		
		//Possible future feature: 
		//expand on ability to force user to be set up in bidpay before allowed to bid or buy now
		$bidpay_force = $sb->getListingSetting($listing_id,'bidpay_force');
		$html = '';
		if ($bidpay_allow && $seller_token){
			$db = true;
			include GEO_BASE_DIR.'get_common_vars.php';
			
			//see if already paid for
			if ($sb->getListingSetting($listing_id,'bidpay_listing_paid')){
				return $link_text['already_paid'];
			}
			//create link to local install
			
			$link = $db->get_site_setting('bidpay_site_url');
			if (strlen($link) == 0){
				return '';
			}
			$link .= "?a=sb_transaction&amp;action=bidpay_payment&amp;listing_id={$listing_id}";
			
			//save the rest as details of the listing, do NOT pass it as part of the url, that would be crazy!
			$sb->setListingSetting($listing_id,'winning_bidder_id',$winning_bidder_id);
			$sb->setListingSetting($listing_id,'final_price',$final_price);
			
			if (strlen($link)>0){
				if (isset($link_text['payment_link'])){
					$html = "<a href=\"{$link}\">{$link_text['payment_link']}</a>";
				} else {
					//must be e-mail
					$html = "{$link_text['email_text']}\n".str_replace('&amp;','&',$link);
				}
			}
		}
		
		return $html;
		
		
		//sell session not known?
		return '';
	}
	
	
	function _getPaymentUrl($listing_id, $seller_id, $winning_bidder_id, $listing_details, $final_price, $timeout){
		$sb = geoSellerBuyer::getInstance();
		$db = true;
		include(GEO_BASE_DIR.'get_common_vars.php');
		
		$linky = '';//$sb->getListingSetting($listing_id,'bidpay_PaymentURL');
		if (strlen($linky) > 0){
			//link already clicked once..
			return $linky;
		}
		//allow for different implementations of the bidpay connection, to allow for things like
		//connecting using PEAR soap, or PHP5 soap, or nuSoap, or whatever.
		
		//(Initially, only PEAR Soap is implemented, but more implementations are planned if needed.)
		require_once(CLASSES_DIR.'payment_gateways/seller_buyer/_bidpay_client_'.$db->get_site_setting('bidpay_connection_library').'.php');
		
		
		$client = new bidpayClient ();
		return $client->_getPaymentUrl($listing_id, $seller_id, $winning_bidder_id, $listing_details, $timeout);
	}
	
	function _saveUserToken($user_id){
		if (!isset($_GET['bp_accept']) && !isset($_GET['bp_clear']))
			return;
		
		if (isset($_GET['bp_clear']) && $_GET['bp_clear']){
			$sb = geoSellerBuyer::getInstance();
			
			//clear current token.
			$sb->setUserSetting($user_id,'bidpay_token','');
			//clear ref num just in case it's still set
			$sb->setUserSetting($user_id, 'bidpay_tok_ref_num', '');
		}
		elseif ($_GET['bp_accept'] && isset($_GET['CustomerToken']) && strlen($_GET['CustomerToken']) == 36){
			$sb = geoSellerBuyer::getInstance();
			//make sure transaction reference matches up
			$local_ref_num = $sb->getUserSetting($user_id,'bidpay_tok_ref_num');
			
			if ($_GET['ReferenceNumber'] != $local_ref_num){
				//echo 'Error: reference number invalid.  Settings passed back: <pre>'.print_r($_GET,1).'</pre><br />';
				return ;
			}
			
			//echo '<h2>debug: returned: $_POST:</h2><pre>'.print_r($_POST,1),'</pre><h2>$_GET:</h2><pre>'.print_r($_GET,1).'</pre><br />';
			
			$sb->setUserSetting($user_id, 'bidpay_token', $_GET['CustomerToken']);
			//also reset the ref num
			$sb->setUserSetting($user_id, 'bidpay_tok_ref_num','');
		}
	}
	
	function _getAuctionPricePlans($vars){
		$db = true;
		include (GEO_BASE_DIR.'get_common_vars.php');
		
		if ($vars == null){
			$for = 0;
		}
		$for = intval($for);
		
		$sql = "SELECT `price_plan_id` as `id` FROM `geodesic_classifieds_price_plans` WHERE `applies_to` = 2";
		if ($for > 0){
			//$for is cleaned at this point, by intval()
			$sql = "SELECT `category_price_plan_id` as `id` FROM `geodesic_classifieds_price_plans_categories` WHERE `price_plan_id` = $for";
		}
		
		$result = $db->Execute($sql);
		if (!$result){
			return array();//empty array, query failed
		}
		$plans = array();
		while ($row=$result->FetchRow()){
			$plans[] = $row['id'];
		}
		return $plans;
	}
	
	function _bidpayAllowed(){
		$db = true;
		include GEO_BASE_DIR.'get_common_vars.php';
		return $db->get_site_setting('bidpay_allow');
	}
	function _getText($page_id){
		$db = 1;
		include GEO_BASE_DIR.'get_common_vars.php';
		return $db->get_text(true, $page_id);
	}
}