<?php
//search_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21035              $ ##
## File last change date:       ##
##  $Date:: 2011-02-08 12:08:#$ ##
##                              ##
##################################

class Search_classifieds extends geoSite
{
	var $category_name;
	var $criteria;
	var $search_criteria;
	var $started;
	var $where_clause;
	var $search_sql_query;
	var $search_page_results;
	var $optional_fields;
	var $browse_type;
	var $original_search_term;

	var $debug = 0;
	var $debug_search = 0;
	var $debug_display_results = 0;
	var $testing = 0;
	var $test_name = "";
	var $canadian_zip = 0;
	var $total_returned = 0;
	var $search_text;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Search_classifieds ($db,$language_id,$auth,$category_id=0,$filter_id=0,$state_filter=0,$zip_filter=0,$zip_filter_distance=0,$product_configuration=0)
	{
		$this->site_category = $category_id;
		parent::__construct();
		
		$this->filter_id = $filter_id;
		$this->state_filter = $state_filter;
		$this->zip_filter = $zip_filter;
		$this->zip_filter_distance = $zip_filter_distance;

	} //end of function Search

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function search_form ($db,$search=0)
	{
		$this->page_id = 44;
		$this->get_text();
		$this->category_name = geoCategory::getName($this->site_category);
		$this->get_ad_configuration($db);
		$this->get_category_configuration($db,$this->site_category,0);
		//use site-wide settings
		$groupId = 0;
		if ($this->userid) {
			$user = geoUser::getUser($this->userid);
			if ($user) {
				$groupId = (int)$user->group_id;
			}
		}
		//Need to use site-wide settings, category specific fields will be loaded
		//dynamically by call to get cat thingies.
		$fields = $this->fields->getDisplayLocationFields('search_fields');
		
		if ($this->configuration_data['use_search_form']) {
			$this->display_page($db);
			return true;
		}

		$this->CountOptionalFields();

		if (!$this->category_configuration->USE_SITE_DEFAULT || !geoPC::is_ent())
		{
			$this->field_configuration_data = $this->ad_configuration_data;
		}
		else
		{
			$this->field_configuration_data = $this->category_configuration;
		}
		$tpl_vars = array();
		
		if ((strlen(trim($this->search_sql_query)) > 0))
		{
			$tpl_vars['search_sql_query'] = 1;
		}
		//get category dropdown and checkbox
		$this->withAjax=false;

		if ($this->site_category)$this->onload_cat_id = $this->site_category;

		$name =(($this->category_name)? "c\" onchange=\"geoOldAjax.sendReq('displaySearchQuestions', this.value);":"c\"");

		$category_dropdown = $this->get_category_dropdown($name,(($this->category_name && $this->site_category)?$this->site_category:0), 0,"search_data_values",$this->messages[500106],2);

		// Special case for joe edwards
		$tpl_vars['je_search_setting'] =  $this->db->get_site_setting('je_search_setting');

		if ($this->is_class_auctions()&&$this->configuration_data['listing_type_allowed']=='0')
		{
			$tpl_vars['is_auction'] = 1;
			$tpl_vars['listing_type_allowed'] = '';
		} else {
			$tpl_vars['is_auction'] = 0;
			$tpl_vars['listing_type_allowed'] = $this->configuration_data['listing_type_allowed'];
			//if auctions or classified listings are turned off, then insert a hidden field to filter by the admin settings.
		}
		$tpl_vars['addonCriteria'] = geoAddon::triggerDisplay('Search_classifieds_search_form', array ('this'=> $this, 'search_fields'=>$fields), geoAddon::ARRAY_ARRAY);
		
		//TODO: finish moving to zipsearch addon files 
		$zipSettings = geoAddon::getRegistry('zipsearch');
		
		if ($zipSettings && $zipSettings->enabled == 1)
		{
			$tpl_vars['use_zip_distance_calculator'] = 1;
			$zipText = geoAddon::getText('geo_addons','zipsearch');
			$tpl_vars['default_distance_text'] = ($zipSettings->units == 'M') ? $zipText['default_distance_mi'] : $zipText['default_distance_km'];
			
			if($db->get_site_setting('zipsearch_by_location_name') == 1) {
				//beta setting: replace zipcode with city name
				$tpl_vars['zipsearch_by_location'] = true;
				$tpl_vars['zipsearchByLocation_html'] = geoSearchUtils::zipsearchByLocation();
			}
			
			$tpl_vars['zip_filter'] = ($this->zip_filter) ? $this->zip_filter : false; 
			
			$basic_distances = array(5,10,15,20,25,30,40,50,75,100,200,300,400,500);
			$tpl_vars['basic_distances'] = $basic_distances;
			$tpl_vars['zip_filter_distance'] = $this->zip_filter_distance;
		}
		
		
		if ($fields['state']) {
			$sql = "SELECT distinct(location_state) as `abbreviation_encoded` FROM ".geoTables::classifieds_table." where live = 1 and location_state != \"\" order by location_state";
			if ($this->db->get_site_setting('alt_state_search_dropdown')) {
				//use ALL states, not just ones already used in live listings
				$sql = "SELECT `abbreviation`, `name` FROM ".geoTables::states_table." ORDER BY `display_order`, `name`";
			}
			
			$allStates = $this->db->GetAll($sql);
			if (count($allStates) > 0) {
				$states = array();
			
				$states[0]['value'] = '0';
				$states[0]['label'] = '';
				foreach ($allStates as $state) {
					if (isset($state['abbreviation'])) {
						//first encode abbreviation if using that one way of getting the countries
						$state['abbreviation_encoded'] = geoString::toDB(trim($state['abbreviation']));
					}
					if (!isset($state['name'])) {
						$state['name'] = geoString::fromDB($this->get_state_name($db,$state['abbreviation_encoded']));
					}
					$selected = ($this->state_filter && ($this->state_filter == $state['abbreviation_encoded']))? true: false;
					
					$states[] = array (
						'value' => $state['abbreviation_encoded'],
						'label' => $state['name'],
						'selected' => $selected
					);
				}
				
				$tpl_vars['states'] =  $states;
			}
		}

		if ($fields['country']) {
			$sql = "select distinct(location_country) as name_encoded from ".$this->db->geoTables->classifieds_table." where location_country != '' AND live=1";
			
			if ($this->db->get_site_setting('use_alt_country_search')) {
				//search by ALL countries, not just ones found in active listings
				$sql = "SELECT `name` FROM ".geoTables::countries_table." ORDER BY `display_order`, `name`";
			}
			
			$allCountries = $this->db->GetAll($sql);
			if (count($allCountries) > 0) {
				$countries = array();
				
				$countries[0]['value'] = '0';
				$countries[0]['label'] = '';
				foreach ($allCountries as $country) {
					if (isset($country['name_encoded'])) {
						//first decode it if using that one way of getting the countries
						$country['name'] = geoString::fromDB($country['name_encoded']);
					}
					$countries[] = array (
						//need to encode value, that's how it's expected.
						'value' => geoString::toDB($country['name']),
						'label' => $country['name']
					);
				}
				
				$tooltip[5] = $this->display_help_link(587);
				$tpl_vars['countries'] = $countries;
			}
		}
		
		if(!$this->max_optional_fields)
		{
			$this->CountOptionalFields();
		}
		$use_filters = $db->get_site_setting('use_filters');
		
		if ( geoPC::is_ent() && $this->max_optional_fields > 0 )
		{
			$show_header = true;
			$optionals = array();
			//Need to use site-wide settings, fields only enabled by category will be loaded
			//dynamically by call to get cat thingies.
			$siteFields = geoFields::getInstance($groupId, 0)->getDisplayLocationFields('search_fields');
			for($i = 1; $i <= $this->max_optional_fields; $i++)
			{
				$fieldName = 'optional_field_'.$i;
				if ($fields[$fieldName] && $siteFields[$fieldName])
				{
					if($use_filters && $this->configuration_data["optional_".$i."_filter_association"]) {
						continue;
					}
					$optionals[$i]['field_number'] = $i;
					if($i == 1) {
						$optionals[$i]['label'] = geoString::fromDB($this->messages[1457]);
					} elseif($i <= 10) {
						$optionals[$i]['label'] = geoString::fromDB($this->messages[(1458+($i-1))]);
					} elseif($i <= 20) {
						$optionals[$i]['label'] = geoString::fromDB($this->messages[(1933+($i-11))]);
					} elseif($i <= 35) {
						$optionals[$i]['label'] = geoString::fromDB($this->messages[(2778+($i-21))]);
					}

					if ($this->fields->$fieldName->field_type == 'number' || $this->fields->$fieldName->field_type == 'cost') {
						//if numbers only - produce a upper and lower limit
						$optionals[$i]['type'] = 'numbers';
					} elseif ($this->fields->$fieldName->field_type != 'dropdown') {
							//default to text input 
							$optionals[$i]['type'] = 'text';
					} else {
						$sql = "select * from ".$this->sell_choices_table." where type_id = ".intval($this->fields->$fieldName->type_data)." order by display_order,value";
						$type_result = $db->Execute($sql);
						
						if ($type_result && $type_result->RecordCount() > 0) {
							$optionals[$i]['type'] = 'select';
							
							$optionals[$i]['dropdown'][0]['value'] = '0';
							$optionals[$i]['dropdown'][0]['label'] = '';

							for($d = 1; $show_dropdown = $type_result->FetchNextObject(); $d++)
							{
								$optionals[$i]['dropdown'][$d]['value'] = $show_dropdown->VALUE;
								$optionals[$i]['dropdown'][$d]['label'] = $show_dropdown->VALUE;
								if ($this->classified_variables["optional_field_".$i] == $show_dropdown->VALUE)
								{
									$optionals[$i]['dropdown'][$d]['selected'] = true;
								}
							}
						} else {
							//no options available -- fallback to text box
							$optionals[$i]['type'] = 'text';
						}
					}
					if (strpos($this->fields->$fieldName->type_data, ':use_other')!== false && intval($this->fields->$fieldName->type_data) && (!$this->configuration_data["optional_".$i."_filter_association"])) {
						$optionals[$i]['other_box'] = true;
					}
				}
			}
			if(count($optionals) > 0) {
				$tpl_vars['show_optionals'] = true;
				$tpl_vars['optionals'] =  $optionals;
			}
		}
		
		
		
		
		if(isset($_REQUEST['template_id']) && is_numeric($_REQUEST['template_id']) && $_REQUEST['template_id']) {
			//use custom template for search page according to URL parameter
			//add hidden field to pass chosen template to results page
			$tpl_vars['custom_template_id'] = $_REQUEST['template_id'];
		}
		
		$tooltip[1] = $this->display_help_link(585);
		$tooltip[2] = $this->display_help_link(574);
		$tooltip[3] = $this->display_help_link(1951);
		$tooltip[4] = $this->display_help_link(586);
		$tpl_vars['tooltip'] = $tooltip;
		$tpl_vars['category_dropdown'] = $category_dropdown;
		$tpl_vars['queryFields'] = $fields;
		
		
		//body for errors because any error messages from a failed Search()
 		//will already be held in $this->body.
 		//(probably need to rework that, but quickhack to make it work for now)
		$tpl_vars['errors'] = $this->body;
		$this->body = '';
		
		
		geoView::getInstance()->setBodyTpl('details_form.tpl','','search_class')
			->setBodyVar($tpl_vars);
		
		$this->display_page();
		return true;

	}


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Search($db, $search_criteria = 0, $change = 0, $browse_type=0)
	{
		if ($this->debug_search)
		{
			echo "<br />TOP OF SEARCH<br />\n";
			echo $search_criteria." is search_criteria<br />\n";
			echo $search_criteria["whole_word"]." is search_criteria[whole_word]<br />\n";
			echo $search_criteria["search_text"]." is the search text<br />\n";
			echo count($search_criteria["question_value"])." is the count of search_criteria[question_value]<br />\n";

		}
		$this->page_id = 44;
		$this->get_text();

		$this->search_text = $search_criteria["search_text"];
		//remove extra white space
		$this->search_text = preg_replace('/\s+/', ' ', $this->search_text);
		//escape exclamation
		$this->search_text = preg_replace('/!/', '\%21', $this->search_text);

		// Check if user changed category
		if($change == 1)
		{
			if ($this->debug_search) echo "category changed ...displaying form<br />\n";
			return false;
		}
		if ($this->debug_search) {
			highlight_string(print_r($search_criteria,1));
		}
		
					
		if($search_criteria)
		{
			if ($this->debug_search)
			{
				echo "inside of if (search_criteria)<br />\n";
				echo $this->search_criteria["page"]." is the b[page] value<br />\n";
			}
			$this->original_search_term = $search_criteria["search_text"];
			$this->search_criteria = $search_criteria;
			$this->get_ad_configuration($db);
			$this->site_category = $_REQUEST['c'];
			if (strlen(trim($this->site_category)) == 0)
				$this->site_category = 0;
			if ($this->debug_search) echo "this->site_category set to ".$this->site_category."<br />\n";

			$encode_search_terms = $this->db->get_site_setting('encode_search_terms');
			if ($encode_search_terms)
			{
				$this->search_text = urlencode(trim($this->search_criteria["search_text"]));
				$this->search_criteria["search_text"] = urlencode(trim($this->search_criteria["search_text"]));
			}
			else
			{
				$this->search_text = trim($this->search_criteria["search_text"]);
			}

			if ($this->debug_search)
			{
				echo $this->search_criteria["search_text"]." is search_criteria[search_text]<br />\n";
				echo $this->search_text." is search_text<br />\n";
			}

			$this->get_category_configuration($db,$this->site_category,0);
			$this->get_category_questions($db, $this->site_category);

			if (!$this->category_configuration->USE_SITE_DEFAULT || !geoPC::is_ent())
			{
				if ($this->debug_search) echo "using site settings<br />\n";
				$this->field_configuration_data = $this->ad_configuration_data;
			} else {
				if ($this->debug_search) echo "using category settings<br />\n";
				$this->field_configuration_data = $this->category_configuration;
			}

			// Start out query
			$sql = "SELECT * FROM ".$this->classifieds_table." WHERE ";

			// Search ID only and exit if only searching for ad id
			if($this->search_criteria["whole_word"] == 2)
			{
				if($this->debug_search)
				{
					echo "searching as if search term were an ad id<br />\n";
					echo "Searching for id ".$this->search_criteria["search_text"]."<br />";
				}
				if ((strlen(trim($this->search_criteria["search_text"])) > 0) && (is_numeric($this->search_criteria["search_text"])))
					$this->where_clause = " id = ".$this->search_criteria["search_text"]." and live = 1 ";
				else
					$this->where_clause = " id = 0 ";

				// Build the query to run
				$sql .= $this->where_clause;

				if($this->testing && $this->test_name == "TestIDSearch")
				{
					// TestIDSearch()
					return $sql;
				}
				// Get actual results
				$result = $db->Execute($sql);
				if(!$result)
				{
					if($this->debug_search)
					{
						echo $db->ErrorMsg()." is the error<br />\n";
						echo $sql.'<br />';
					}
					return false;
				}
				else
				{
					// Send user to correct ad
					if($result->RecordCount() == 1)
					{
						if($this->testing == 1)
						{
							return $result;
						}

						// Send user to correct ad
						$returned_result = $result->FetchNextObject();
						if ($this->debug_search) echo "redirecting to id ".$returned_result->ID." in the id search<br />\n";
						header("Location: ".$this->configuration_data['classifieds_url']."?a=2&amp;b=".$returned_result->ID);
						exit;
					}
					else
					{
						// No results returned
						if ($this->debug_search) echo "no id results from search of id ".$returned_result->ID." in the id search<br />\n";
						$this->body .="<table width='100%' cellpadding='2' cellspacing='0'><tr class='search_page_instructions'>
				<td colspan='4'>
					\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
						return false;
					}
					return true;
				}
			}

			// Generate whole or partial word match
			if(strlen(trim($this->search_criteria["search_text"])) > 0)
			{
				if ($this->debug_search)
				{
					echo "<br />TOP OF SEARCH_TEXT > 0<br />\n";
					echo " search_text contained text<br />\n";
					echo "about to search for this search_text - ".$this->search_criteria["search_text"]."<br />\n";
				}
				// Notes:
				// 0 is partial
				// 1 is whole
				/*
				if($this->search_criteria["whole_word"] == 0)
				{
					// Partial word match
					$this->search_criteria["search_text"] = "%".$this->search_criteria["search_text"]."%";
				}
				elseif ($this->search_criteria["whole_word"] == 1)
				{
					$this->search_criteria["search_text"] = "%+".$this->search_criteria["search_text"]."+%";
				}
				elseif($this->search_criteria["whole_word"] == 2)
				{
					// Shouldnt get here so error out
					// if whole_word is 2 then it should have been caught above
					if ($this->debug_search) echo "whole word did not match<br />\n";
					return false;
				}

				if($this->testing && ($this->test_name == "TestWholeWordMatch" || $this->test_name == "TestPartialWordMatch"))
				{
					// Test*WordMatch()
					return $this->search_criteria["search_text"];
				}
				if($this->debug_search)
				{
					echo $this->search_criteria["search_text"]." is the search text to be placed in search queries<br />";
				}
				*/

				// Search Title
				if(strlen($this->where_clause) > 0)
				{
					$this->where_clause .= " OR ";
					if ($this->debug_search) echo "added OR because where clause already populated - ".$this->where_clause."<br />\n";
				}

				//check to see if search term can be broken into pieces
				// check for ',' - ' or ' - ' and '
				//comma is %2C
				if (stristr($this->search_criteria["search_text"],"%2C"))
				{
					$and_or_condition = 0;
					$all_search_terms = explode("%2C",$this->search_criteria["search_text"]);
				}
				elseif (stristr($this->search_criteria["search_text"],"+or+"))
				{
					$and_or_condition = 0;
					$all_search_terms = explode("+or+",$this->search_criteria["search_text"]);
				}
				elseif (stristr($this->search_criteria["search_text"],"+and+"))
				{
					$and_or_condition = 1;
					$all_search_terms = explode("+and+",$this->search_criteria["search_text"]);
				}
				elseif (stristr($this->search_criteria["search_text"],'+'))
				{
					$and_or_condition = 1;
					$all_search_terms = explode('+',$this->search_criteria["search_text"]);
				}
				else
				{
					$and_or_condition = 0;
					$all_search_terms = array();
					$all_search_terms[0] = $this->search_criteria["search_text"];
				}

				if ($this->debug_search)
				{
					echo $and_or_condition." is the and_or_condition<br />ALL KEY TERMS TO SEARCH<br />\n";
					foreach ($all_search_terms as $key => $value)
					{
						echo $value."<br />\n";
					}
					echo "END OF SEARCH TERMS<br />\n";
				}

				//set up title/description restrictions to play nicely with both search forms
				if($this->search_criteria['search_by_field'] == 'title_only')
				{
					$this->search_criteria['search_titles'] = 1;
					$this->search_criteria['search_descriptions'] = 0;
				}
				else if ($this->search_criteria['search_by_field'] == 'description_only')
				{
					$this->search_criteria['search_titles'] = 0;
					$this->search_criteria['search_descriptions'] = 1;
				}


				$this->where_clause .= " (";

				if($this->search_criteria["whole_word"] == 1)
				{
					if ($this->debug_search) echo "searching whole word = 1<br />\n";
					// word only
					reset($all_search_terms);
					$started_through_all_search_terms = 0;
					$this->where_clause .= "(";
					foreach ($all_search_terms as $key => $value)
					{
						//remove any spaces
						$value = urlencode(trim(geoString::fromDB($value)));
						
						//escape mysql's search characters
						$value = str_replace(array('%','_'), array('\%','\_'), $value);
						
						if ($started_through_all_search_terms)
						{
							//add the or,and
							if ($and_or_condition)
							{
								$this->where_clause .= " AND ";
							}
							else
							{
								$this->where_clause .= " OR ";
							}
						}

						$this->where_clause .= "(";
						if (($this->search_criteria['search_titles'] == 1) || (!$this->search_criteria['search_descriptions'])) {
							//word only thing in title
							$this->where_clause .= "(`title` LIKE '$value')";
							$this->where_clause .= " OR ";

							// Word at beginning of phrase
							$this->where_clause .= "(`title` LIKE '$value+%')";
							$this->where_clause .= " OR ";

							// Word at end of phrase
							$this->where_clause .= "(`title` LIKE '%+$value')";
							$this->where_clause .= " OR ";

							// Word in of phrase
							$this->where_clause .= "(`title` LIKE '%+$value+%')";
							$this->where_clause .= " OR ";

							//check punctuation
							$this->where_clause .= "(`title` LIKE '%+$value.%')";
							$this->where_clause .= " OR ";

							$this->where_clause .= "(`title` LIKE '%+$value\%2C%')";
							if (($this->search_criteria['search_descriptions'] == 1) || (!$this->search_criteria['search_titles']))
								$this->where_clause .= " OR ";
						}

						if (($this->search_criteria['search_descriptions'] == 1) || (!$this->search_criteria['search_titles'])) {
							// word the only thing in the description
							$this->where_clause .= "(`description` LIKE '$value')";
							$this->where_clause .= " OR ";

							// Word at beginning of phrase
							$this->where_clause .= "(`description` LIKE '$value+%')";
							$this->where_clause .= " OR ";

							// Word at end of phrase
							$this->where_clause .= "(`description` LIKE '%+$value')";
							$this->where_clause .= " OR ";

							// Word in of phrase
							$this->where_clause .= "(`description` LIKE '%+$value+%')";
							$this->where_clause .= " OR ";

							//check puntuation
							$this->where_clause .= "(`description` LIKE '%+$value.%')";
							$this->where_clause .= " OR ";

							$this->where_clause .= "(`description` LIKE '%+$value\%2C%')";
						}

						if((!$this->search_criteria['search_titles'] && !$this->search_criteria['search_descriptions']) || ($this->search_criteria['search_descriptions']))
						 {
							$this->where_clause .= " OR ";

							$this->where_clause .= "(search_text LIKE '$value')";
							$this->where_clause .= " OR ";

							// Word at beginning of phrase
							$this->where_clause .= "(search_text LIKE '$value+%')";
							$this->where_clause .= " OR ";

							// Word at end of phrase
							$this->where_clause .= "(search_text LIKE '%+$value')";
							$this->where_clause .= " OR ";

							// Word in of phrase
							$this->where_clause .= "(search_text LIKE '%+$value+%')";
						 }

						$this->where_clause .= ")";
						$started_through_all_search_terms = 1;
					}
					$this->where_clause .= ")";
				}
				else
				{
					if ($this->debug_search) echo "not searching whole word not equal 1<br />\n";
					reset($all_search_terms);
					$started_through_all_search_terms = 0;
					$this->where_clause .= "(";
					foreach ($all_search_terms as $key => $value)
					{
						//remove any spaces
						$value = urlencode(trim(geoString::fromDB($value)));
						
						//escape mysql's search characters
						$value = str_replace(array('%','_'), array('\%','\_'), $value);
						
						if ($started_through_all_search_terms)
						{
							//add the or,and
							if ($and_or_condition)
							{
								$this->where_clause .= " AND ";
							}
							else
							{
								$this->where_clause .= " OR ";
							}
						}
						$this->where_clause .= "(";
						if (($this->search_criteria['search_titles'] == 1) || (!$this->search_criteria['search_descriptions']))
						{
							$this->where_clause .= "(`title` LIKE '%$value%')";
							
							if (($this->search_criteria['search_descriptions'] == 1) || (!$this->search_criteria['search_titles']))
								$this->where_clause .= " OR ";
						}

						if (($this->search_criteria['search_descriptions'] == 1) || (!$this->search_criteria['search_titles']))
						{
							$this->where_clause .= "(`description` LIKE '%$value%')";
							
						}
						if((!$this->search_criteria['search_titles'] && !$this->search_criteria['search_descriptions']) || ($this->search_criteria['search_descriptions'])) {
							$this->where_clause .= " OR ";

							$this->where_clause .= "(search_text LIKE '%$value%')";
						 }

						$this->where_clause .= ")";

						$started_through_all_search_terms = 1;
					}
					$this->where_clause .= ")";
				}

				if ($this->debug_search)
				{
					echo $this->where_clause." <br />is the where clause after adding title,description and search_text clause<br />\n";
				}

				// Find all optional fields
				if((!$this->max_optional_fields) && ((!$this->search_criteria['search_descriptions']) && (!$this->search_criteria['search_titles'])))
				{
					$this->CountOptionalFields();
				}

				if($this->max_optional_fields > 0)
				{
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause .= " OR ";
					}

					$this->where_clause .= "(";

					// Search all optional fields
					for($i = 1; $i <= $this->max_optional_fields; $i++)
					{
						// Put ORs in the right place
						if(($i != 1) && ($i != $this->max_optional_fields+1))
						{
							$this->where_clause .= " OR ";
						}
						reset($all_search_terms);
						$started_through_all_search_terms = 0;
						$this->where_clause .= "(";
						foreach ($all_search_terms as $key => $value)
						{
							if ($started_through_all_search_terms)
							{
								//add the or,and
								if ($and_or_condition)
								{
									$this->where_clause .= " AND ";
								}
								else
								{
									$this->where_clause .= " OR ";
								}
							}
							$this->where_clause .= "(`optional_field_$i` LIKE '%$value%')";
							$started_through_all_search_terms = 1;
						}
						$this->where_clause .= ")";
					}

					$this->where_clause .= ")";

					if($this->testing && $this->test_name == "TestGlobalOptionalFields")
					{
						// TestGlobalOptionalFields
						return $sql.$this->where_clause;
					}
				}
				$this->where_clause .= ") ";
			}

			if ($this->search_criteria["classified_auction_search"] && $this->is_class_auctions())
			{
				//default is to search both....if classified_auction_search is empty do not limit the search to a type

				if ($this->search_criteria["classified_auction_search"] == 1)
				{
					//search only classifieds
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause .= " AND ";
					}
					$this->where_clause .= "(item_type = 1)";
				}
				elseif ($this->search_criteria["classified_auction_search"] == 2)
				{
					//search only auctions
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause .= " AND ";
					}
					$this->where_clause .= "(item_type = 2 or item_type = 4)";
				}
				else if ($this->search_criteria["classified_auction_search"] == 3)
				{
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause = " AND ";
					}
					$this->where_clause = "(item_type = 2 or item_type = 4) AND (buy_now > 0) AND ((current_bid < starting_bid) OR (current_bid = 0))";
				}
			}

			if ($this->debug_search)
			{
				echo $this->where_clause."<br />is where_clause after search_text > 0<br />\n";
				echo "<br />ABOUT TO DO CATEGORY SPECIFIC<br />\n";
				echo $this->site_category." is site_category before category specific<br />";
				if (is_array($search_criteria["question_value"]))
				{
					reset ($search_criteria["question_value"]);
					foreach($search_criteria["question_value"] as $key => $value)
					{
						echo $key." is key to ".$value."<br />";
					}
				}
				else
					echo $search_criteria["question_value"].' is $search_criteria[\'question_value\']<br />';
			}

			// Search specific category-specific questions based on input values
			if(($this->site_category > 0 && isset($search_criteria["question_value"]))
				&& (($this->search_criteria['search_by_field'] != "description_only") && ($this->search_criteria['search_by_field'] != "title_only")))
			{
				if ($this->debug_search) echo "going through question_value<br />\n";

				$category_question_list = array();
				reset ($search_criteria["question_value"]);
				$category_specific_term_entered = 0;
				foreach($search_criteria["question_value"] as $key => $value)
				{
					if (isset($search_criteria['question_value_other'][$key]) && strlen(trim($search_criteria['question_value_other'][$key]))>0) {
						//use other box
						$value = $search_criteria['question_value_other'][$key];
					}
					//$single_key = $key;
					if (strlen(trim($value)) > 0)
					{
						$category_specific_term_entered = 1;
						$single_key = $key;
						$value_where_clause = "";
						if ($this->debug_search) echo "just before running query<br />\n";
						if (stristr($value,' ')) {
							if ($this->debug_search) echo "breaking up search category specific search term: ".$value."<br />\n";
							$all_search_terms = explode(' ',$value);
							$search_term = "";
							foreach ($all_search_terms as $word)
								$search_term .= " AND ".$this->like_clause('value',$word);
							$value_where_clause = substr($search_term,4);
						} else
						{
							if ($this->debug_search) echo "search category specific search term whole: ".$value."<br />\n";
							$value_where_clause = $this->like_clause('value',$value);
						}

						$sql = "select distinct(classified_id) from ".$this->classified_extra_table." where question_id = ".$key." and ".$value_where_clause;
						$result = $db->Execute($sql);
						if ($this->debug_search) echo $sql." <br />\n";
						if(!$result)
						{
							if ($this->debug_search) echo $sql." <br />\n";
							return false;
						}

						//if($result->RecordCount() == 0)
						//{
						//	if ($this->debug_search) echo "nothing returned in query of ".$key." and ".$value."<br />\n";
						//	continue;
						//}
						//else
						//{

							if ($this->debug_search) echo "single_key set to: ".$single_key."<br />\n";
							$category_question_list[$key] = array();
							if ($this->debug_search) echo $result->RecordCount()." is the count of distinct ids returned<br />\n";
							// If a value exists lets put it in the array
							if ( $result->RecordCount() > 0)
							{
								if ($this->debug_search) echo "result set returned for: ".$key."<br />\n";
								while ($show_id = $result->FetchNextObject())
								{
									array_push($category_question_list[$key], $show_id->CLASSIFIED_ID);
									if ($this->debug_search)
									{
										echo "pushing ".$show_id->CLASSIFIED_ID." onto key - ".$key."<br />\n";
									}
								}
							}
							else
							{
								if ($this->debug_search) echo "result set returned nothing for: ".$key."<br />\n";
								array_push($category_question_list[$key], "0");

								//this search is an "and" condition.
								//if no results from one of the searches then
								//no results will return from the whole search
								$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
								return false;
							}
							//	$id = $result->FetchNextObject();
							//	$category_question_list[] = $id->CLASSIFIED_ID;
						//}
					}
				}
				if (count($category_question_list) > 1)
				{
					if ($this->debug_search)
					{
						reset($category_question_list);
						foreach ($category_question_list as $key => $value)
						{
							if (is_array($value))
								echo $key."- is an array<br />\n";
							else
								echo $key." - is not an array<br />\n";
							//echo count($value)." is the count of key - ".$key."<br />\n";

						}
						//var_dump($category_question_list);
					}
					$field_items = call_user_func_array('array_intersect', $category_question_list);
					if (!$field_items)
					{
						if ($this->debug_search)
						{
							echo "there were no intersecting ad ids for category specific questions<br />\n";
						}
						$field_items = array();
						$field_items[$single_key] = "0";
					}
				}
				elseif (count($category_question_list) == 1)
				{
					if ($this->debug_search)
					{
						echo "category_question_list has only one value - ".$single_key."<br />\n";
						echo count($category_question_list[$single_key])." is the number of id within the single key<br />\n";
					}
					$field_items = $category_question_list[$single_key];
				}
				elseif ($category_specific_term_entered == 1)
				{
					//this is an and condition
					//if no results from one condition then there are no results
					//from the search
					if ($this->debug_search)
					{
						echo "pushing 0 onto optional_field[".$i."]<br />\n";
					}
					$category_question_list = array();
					//echo $single_key." is single_key<br />\n";
					//array_push($category_question_list[$single_key],"0");
					$category_question_list[$single_key] = "0";

					$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
					return false;
				}

				if ($this->debug_search)
				{
					echo "<br /><br />".count($field_items)." is the count of field_items<br />\n";
					echo count($category_question_list)." is the count of \$category_question_list<br />\n";
					echo $single_key." is single_key<br />\n";
					//var_dump($field_items);
					echo "<br /><br />";
				}

				// Append the search category questions onto the entire query
				if(sizeof($field_items) > 0)
				{
					reset($field_items);
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause .= " AND ";
					}

					if ($this->debug_search)
					{
						echo $this->where_clause." is the where_clause before field_items build where statement<br />\n";
					}

					$this->where_clause .= "( id in (";
					$category_specific_where_started = 0;
					foreach($field_items as $key => $value)
					{
						if ($category_specific_where_started)
							$this->where_clause .= ", ";
						$this->where_clause .= $value;
						$category_specific_where_started = 1;
					}
					$this->where_clause .= ")";
					$this->where_clause .= ")";
				}
				if($this->testing && $this->test_name == "TestGlobalCategorySpecificQuestions")
				{
					// TestGlobalCategorySpecificQuestion
					return $sql.$this->where_clause;
				}

				if ($this->debug_search)
				{
					echo $this->where_clause." is the where_clause after field_items build where statement<br />\n";
				}

				// Append it back onto the where clause
				if($where_statement)
					$this->where_clause .= $where_statement;

				if($this->debug_search)
					echo $this->where_clause.'<br />';

				if($this->testing && $this->test_name == "TestSpecificCategoryQuestions")
				{
					return $sql.$this->where_clause;
				}

			}

			if($this->debug_search)
			{
				echo $this->where_clause.' is the where_clause at the end of category specific<br />';
				echo "<br />ABOUT TO SEARCH SITE WIDE OPTIONAL FIELDS<br />\n";
			}

			// Search for specific optional field data
			// Build array to hold items for optional fields
			$field_items = array();

			// Query strings for optional fields
			$opt_sql_query = "select id from ".$this->classifieds_table." where ";
			$opt_where_clause = "";

			// Find all optional fields
			if ((!$this->max_optional_fields) &&  (($this->search_criteria['search_by_field'] != "description_only") && ($this->search_criteria['search_by_field'] != "title_only")))
			{
				$this->CountOptionalFields();
			}

			if($this->max_optional_fields > 0)
			{
				if ($this->debug_search)
				{
					echo "<Br>ABOUT TO CREATE WHERE FOR OPTIONAL FIELDS<br>\n";
				}
				$optional_field = array();

				for($i = 1; $i <= $this->max_optional_fields; $i++)
				{
					$opt_where_clause = "";

					if ($this->debug_search)
					{
						echo "for optional field ".$i."<br />\n";
						echo $this->search_criteria["by_optional_".$i."_lower"]." is \$this->search_criteria[by_optional_".$i."_lower]<br />\n";
						echo $this->search_criteria["by_optional_".$i."_higher"]." is \$this->search_criteria[by_optional_".$i."_higher]<br />\n";
						echo $this->search_criteria["optional_field_".$i]." is \$this->search_criteria[optional_field_".$i."]<br />\n";
					}

					if($this->search_criteria["by_optional_".$i."_lower"] != "")
					{
						// If no upper limit set to "infinity"
						if(!$this->search_criteria["by_optional_".$i."_higher"])
						{
							$this->search_criteria["by_optional_".$i."_higher"] = 99999999;
						}

						if(strlen($opt_where_clause) > 1)
						{
							$opt_where_clause .= " AND ";
						}

						$opt_where_clause .= "(optional_field_".$i." <= ".$this->search_criteria["by_optional_".$i."_higher"]." AND optional_field_".$i." >= ".$this->search_criteria["by_optional_".$i."_lower"].")";
					}
					elseif($this->search_criteria["by_optional_".$i."_higher"] != "")
					{
						// If no lower limit set to zero
						if($this->search_criteria["by_optional_".$i."_lower"] == "")
						{
							$this->search_criteria["by_optional_".$i."_lower"] = 0;
						}

						if(strlen($opt_where_clause) > 1)
						{
							$opt_where_clause .= " AND ";
						}

						$opt_where_clause .= "(optional_field_".$i." <= ".$this->search_criteria["by_optional_".$i."_higher"]." AND optional_field_".$i." >= ".$this->search_criteria["by_optional_".$i."_lower"].")";
					}
					elseif($this->search_criteria["optional_field_".$i])
					{
						// Text field or dropdown
						if(strlen($opt_where_clause) > 1)
						{
							$opt_where_clause .= " AND ";
						}

						$opt_where_clause .= "(optional_field_".$i." like \"%".str_replace(array('%','_'), array('\%','\_'),urlencode($this->search_criteria["optional_field_".$i]))."%\")";
					}
					elseif($this->search_criteria["optional_field_".$i."_other"])
					{
						// Text field or dropdown
						if(strlen($opt_where_clause) > 1)
						{
							$opt_where_clause .= " AND ";
						}

						$opt_where_clause .= "(optional_field_".$i." like \"%".str_replace(array('%','_'), array('\%','\_'),urlencode($this->search_criteria["optional_field_".$i."_other"]))."%\")";
					}
					
					else
					{
						// This optional field wasnt used so skip it
						continue;
					}

					// Find all ids that match
					$result = $db->Execute($opt_sql_query.$opt_where_clause);
					if($this->debug_search)
					{
						echo $opt_sql_query.$opt_where_clause.' is the optional site wide query<br />';
						echo  $result->RecordCount()." is recordcount<br />\n";
					}
					if(!$result)
					{
						$this->error_message = "Error in optional fields query";
						return false;
					}
					elseif ($result->RecordCount() > 0)
					{
						$optional_field[$i] = array();
						$single_key = $i;
						while($record = $result->FetchNextObject())
						{
							array_push($optional_field[$i],$record->ID);
							//$optional_field[] = $record->ID;
						}
					}
					else
					{
						//this is an and condition
						//if no results from one condition then there are no results
						//from the search
						if ($this->debug_search)
						{
							echo "pushing 0 onto optional_field[".$i."]<br />\n";
						}
						$optional_field[$i] = array();
						array_push($optional_field[$i],"0");
						$single_key = $i;
					}

					// Put this array into main one only if it exists
					if(sizeof($optional_field) > 0)
					{
						$field_items[] = $optional_field;
						if ($this->debug_search)
						{
							echo count($field_items)." is the count of field_items for optional fields<br />\n";
						}
					}


				}

				// Build where statement for this segment
				$where_statement = "";
				if(sizeof($optional_field) > 1)
				{
					// Now we want to intersect all fields and get a list of ids
					if ($this->debug_search)
					{
						echo "more than one optional question filled out<br />\n";
						echo is_array($optional_field)." is field_items is_array<br />\n";
						echo count($optional_field)." is count of field_items<br />\n";
						//var_dump($optional_field);
						reset($optional_field);
						foreach($optional_field as $key => $value)
						{
							echo "<br />displaying: ".$key."<br />\n";
							if (is_array($value))
							{
								reset($value);
								foreach ($value as $key2 => $value2)
								{
									echo "&nbsp;&nbsp;&nbsp;&nbsp;".$key2." is the key to ".$value2."<br />\n";
								}
							}
						}
					}
					$where_items = call_user_func_array('array_intersect', $optional_field);
				}
				elseif(sizeof($optional_field) == 1)
				{
					// If only 1 array in list then we got our list
					if ($this->debug_search)
					{
						echo "only one optional question filled out<br />\n";
						echo $single_key." is single_key<br />\n";

					}
					$where_items = $optional_field[$single_key];

					if($this->debug_search)
					{
						echo $where_items." is where_items<br />\n";
						//var_dump($field_items);
						echo ' is a var dump of the field_items array<br />';
					}
				}

				if (is_array($where_items))
				{
					if (count($where_items) > 0)
					{
						reset($where_items);
						$where_statement = "(id in (";
						foreach($where_items as $key => $value)
						{
							$where_statement .= $value.", ";
						}
						$where_statement = rtrim($where_statement, ", ");
						$where_statement .= "))";

						if($this->debug_search)
							echo $where_statement.' is the where statement segment for optional fields<br />';

						if((strlen($this->where_clause) > 0) && (strlen($where_statement) > 0))
						{
							$this->where_clause .= " AND ";
						}

						// Append it back onto the where clause
						if($where_statement)
							$this->where_clause .= $where_statement;

						if($this->testing && $this->test_name == "TestSpecificOptionalFields")
						{
							return $sql.$this->where_clause;
						}
					}
					else
					{
						$where_statement = "(id in (0))";
						if((strlen($this->where_clause) > 0) && (strlen($where_statement) > 0))
						{
							$this->where_clause .= " AND ";
						}
						if($where_statement)
							$this->where_clause .= $where_statement;
					}
				}
			}

			if ($this->debug_search)
			{
				echo $this->where_clause."<br /> is the where_clause after site wide optional fields<br />";
			}

			//ending today
			if($this->search_criteria["ending_today"])
			{
				$timeToLookAhead = (60 * 60 * 24) + geoUtil::time(); // only option is 24 hours for now
				if(strlen($this->where_clause) > 0) {
					$this->where_clause .= " AND ";
				}
				$this->where_clause .= "(ends < $timeToLookAhead) ";
			}

			// Do price range checking
			if($this->search_criteria["by_price_lower"] || $this->search_criteria["by_price_higher"]) {
				$parts = array();
				
				if($this->search_criteria["by_price_lower"]) {
					$lowPrice = geoNumber::deformat($this->search_criteria['by_price_lower']);
					$str = "((item_type = 1 AND `price` >= $lowPrice) OR ((item_type = 2 or item_type = 4) AND (`minimum_bid` >= $lowPrice OR (`buy_now_only` = 1 AND `buy_now` >= $lowPrice))))";
					$parts[] = $str;
				}
				if($this->search_criteria["by_price_higher"]) {
					$highPrice = geoNumber::deformat($this->search_criteria['by_price_higher']);
					$str = "((item_type = 1 AND `price` <= $highPrice) OR ((item_type = 2 or item_type = 4) AND (`minimum_bid` <= $highPrice OR (`buy_now_only` = 1 AND `buy_now` <= $highPrice))))";
					$parts[] = $str;
				}

				if(strlen($this->where_clause) > 0) {
					$this->where_clause .= " AND ";
				}

				$this->where_clause .= ' ( '.implode(' AND ', $parts).' ) ';
			}
			
			if ($db->get_site_setting('zipsearch_by_location_name') && strlen(trim($this->search_criteria['ziploc_state_select']))) {
					//if using the ziploc thingy, need to be sure to default to all results when nothing given
					if(!strlen(trim($this->search_criteria['by_zip_code']))) {
						//searching by all cities within this state
						$state = $this->search_criteria['ziploc_state_select'];
						$sql = "select zipcode from `geodesic_zip_codes` where `state` = ?";
						$result = $db->Execute($sql, array($state));
						$zipcodes = array();
						while($city = $result->FetchRow()) {
							//NOTE: this only works for US-style zipcodes for now...
							$zipcode_sql[] = "`location_zip` = '{$city['zipcode']}'";
						}
						if(count($zipcode_sql)) {
							$this->where_clause .= ' AND (' . implode(' OR ',$zipcode_sql) . ') ';
							
							//zero-out zipcode search criteria to avoid triggering normal zip-radius code, since we've just done it manually
							$this->search_criteria['by_zip_code'] = $this->search_criteria['by_zip_code_distance'] = false;
							
						}
					} else {
						//searching for a specific city(zipcode) in this state, so continue as normal
					}
					
			}

			//*****Zipcode Searching*****
			//TODO: move this all into the zipsearch addon's files?

			//if zip/distance specified for this search, use them
			//otherwise fall back on any active filters
			$originZip = ($this->search_criteria["by_zip_code"]) ? $this->search_criteria["by_zip_code"] : $this->zip_filter;
			$distance = ($this->search_criteria["by_zip_code_distance"]) ? $this->search_criteria["by_zip_code_distance"] : $this->zip_filter_distance;
			if($originZip) {
				$zipUtil = geoAddon::getUtil('zipsearch');
				if($zipUtil) {
					$zip_sql = $zipUtil->getSearchSql($originZip, $distance);
				} else {
					//zipsearch addon not active -- do a brute-force search for listings using the specified zipcode
					$zip_sql = "`location_zip` LIKE '%".$originZip."%'";
				}
				if($zip_sql) {
					if(strlen($this->where_clause) > 0) {
						$this->where_clause = '('.$this->where_clause.') AND ('.$zip_sql.')';
					} else {
						$this->where_clause = '('.$zip_sql.')';
					}
				}
			}
			//*****End Zipcode Searching*****

			if (($this->search_criteria["by_country"]) && ($this->search_criteria["by_country"] != "none"))
			{
				if(strlen($this->where_clause) > 0)
				{
					$this->where_clause = "(".$this->where_clause.") AND ( location_country LIKE \"".$this->search_criteria["by_country"]."\")";
				}
				else
				{
					$this->where_clause = "( location_country LIKE \"".$this->search_criteria["by_country"]."\")";
				}

				if($this->testing && $this->test_name == "TestByCountry")
				{
					$sql = "SELECT * FROM ".$this->classifieds_table." WHERE ";
					if ($this->debug_search) echo $this->where_clause." is the where clause<br />";
					return $sql.$this->where_clause;
				}
			}

			if ($this->debug_search)
			{
				echo $this->search_criteria["by_state"]." is by_state<br />\n";
			}
			if (($this->state_filter) && ((!$this->search_criteria["by_state"]) || ($this->search_criteria["by_state"] == "none")))
			{
				if ($this->debug_search)
				{
					echo "adding state filter<br />\n";
				}
				//add state to end of sql_query
				if(strlen($this->where_clause) > 0)
				{
					$this->where_clause .= " AND ";
				}
				$this->where_clause .= " ( location_state LIKE \"%".trim($this->state_filter)."%\" ) ";

				if ($this->debug_search)
				{
					echo $this->where_clause." is where clause after adding state filter<br /><br />";
				}

			} elseif (($this->search_criteria["by_state"]) && ($this->search_criteria["by_state"] != "none")) {
				if ($this->debug_search) {
					echo "adding by_state<br />\n";
				}

				if (strlen($this->where_clause) > 0) {
					$this->where_clause = "(".$this->where_clause.") AND ( location_state LIKE \"%".$this->search_criteria["by_state"]."%\")";
				} else {
					$this->where_clause = "( location_state LIKE \"%".$this->search_criteria["by_state"]."%\")";
				}

				if($this->testing && $this->test_name == "TestByState") {
					$sql = "SELECT * FROM ".$this->classifieds_table." WHERE ";
					if ($this->debug_search) echo $this->where_clause." is the where clause<br />";
					return $sql.$this->where_clause;
				}
				if ($this->debug_search) {
					echo $this->where_clause." is the where_clause after adding by_state<br />\n";
				}
			}
			if (($this->search_criteria["by_city"]) && ($this->search_criteria["by_city"] != "none")) {
				if (strlen($this->where_clause) > 0)
				{
					$this->where_clause = "(".$this->where_clause.") AND (( location_city LIKE \"%".str_replace(array('%','_'), array('\%','\_'),urlencode($this->search_criteria["by_city"]))."%\") or (location_city LIKE \"%".$this->search_criteria["by_city"]."%\"))";
				}
				else
				{
					$this->where_clause = "(( location_city LIKE \"".str_replace(array('%','_'), array('\%','\_'),urlencode($this->search_criteria["by_city"]))."\") or ( location_city LIKE \"%".$this->search_criteria["by_city"]."%\"))";
				}

				if($this->testing && $this->test_name == "TestByCity")
				{
					$sql = "SELECT * FROM ".$this->classifieds_table." WHERE ";
					if ($this->debug_search) echo $this->where_clause." is the where clause<br />";
					return $sql.$this->where_clause;
				}
			}

			// Do check for business type
			if($this->search_criteria["by_business_type"])
			{
				if(strlen($this->where_clause) > 0)
				{
					if($this->search_criteria["by_business_type"] == 1)
					{
						// Individual
						$this->where_clause = "(".$this->where_clause." AND (business_type = 1))";
					}
					else
					{
						// Business
						$this->where_clause = "(".$this->where_clause." AND (business_type = 2))";
					}
				}
				else
				{
					if($this->search_criteria["by_business_type"] == 1)
					{
						// Individual
						$this->where_clause = "(business_type = 1)";
					}
					else
					{
						// Business
						$this->where_clause = "(business_type = 2)";
					}
				}
			}

			// Put in category selecting
			if($this->site_category != 0)
			{
				if($this->search_criteria["subcategories_also"])
				{
					$sql = "select in_statement from ".$this->categories_table." where category_id = ".$this->site_category;
					$result = $db->Execute($sql);
					if(!$result)
					{
						//no results
						$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
						return false;
					}
					else
					{
						$in_statement = $result->FetchNextObject();

						if(strlen($this->where_clause) > 0)
						{
							$this->where_clause = "(".$this->where_clause.") AND category ".$in_statement->IN_STATEMENT;
						}
						else
						{
							$this->where_clause = "category ".$in_statement->IN_STATEMENT;
						}

						if($this->debug_search) echo $sql.$this->where_clause.'<br />';

						if($this->testing && $this->test_name == "TestCategoryWithSubs")
						{
							return $sql.$this->where_clause;
						}
					}
				}
				else
				{
					if(strlen($this->where_clause) > 0)
					{
						$this->where_clause = "(".$this->where_clause.") AND category = ".$this->site_category;
					}
					else
					{
						$this->where_clause = "category = ".$this->site_category;
					}

					if($this->testing && $this->test_name == "TestCategory")
					{
						return $sql.$this->where_clause;
					}
				}
			}
			$order_by = $this->get_order_by($browse_type);
			$this->browse_type = $browse_type;
			// Perform actual search
			// If query was changed put it back to original state
			$sql = "SELECT * FROM ".$this->classifieds_table." WHERE ";
			
			//allow addons to add to the where clause
			$this->where_clause = geoAddon::triggerDisplay('Search_classifieds_Search_filterWhereClause', $this->where_clause, geoAddon::FILTER);
			
			$this->count_sql_query = "SELECT count(id) as total_count FROM ".$this->classifieds_table." WHERE (".$this->where_clause.") AND live = 1";
			if($this->debug_search) echo $this->count_sql_query." is the count query<br />";
			$count_result = $db->Execute($this->count_sql_query);
			if($this->debug_search)
			{
				echo $sql."<br />";
				if ($count_result)
					echo $count_result->RecordCount()." is the recordcount from the count_sql_query<br />\n";
			}
			if(!$count_result)
			{
				if($this->debug_search)
				{
					echo $db->ErrorMsg()." is the sql error <br />\n";
					echo $this->count_sql_query."<br />\n";
				}
				//no results
				$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
				return false;
			}
			elseif($count_result->RecordCount() == 1)
			{
				$show_total = $count_result->FetchNextObject();
				$this->total_returned = $show_total->TOTAL_COUNT;
				if($this->debug_search)
				{
					echo "getting total_returned<br />\n";
					echo $show_total->TOTAL_COUNT." is TOTAL_COUNT<br />\n";
				}
			}
			else
			{
				$this->total_returned = 0;
			}

			if ($this->debug_search)
			{
				echo $this->total_returned." is total_returned<br />\n";
			}
			/*if (($this->total_returned == 1) && ($this->search_criteria["whole_word"] == 2))
			{
				if ($this->debug_search)
				{
					echo "REDIRECTING TO ID: ".$this->search_criteria["search_text"]." as an id search<br />\n";
				}
				header("Location: ".$this->configuration_data['classifieds_url']."?a=2&b=".$this->search_criteria["search_text"]);
				exit;
			}
			else*/if ($this->total_returned != 0)
			{
				$sql = "SELECT * FROM ".$this->classifieds_table." WHERE (".$this->where_clause.") AND live = 1 ".$order_by;
				if ($this->search_criteria["page"])
				{
					$sql = $sql." limit ".(($this->search_criteria["page"] - 1) * $this->configuration_data['number_of_ads_to_display']).",".$this->configuration_data['number_of_ads_to_display'];
				}
				else
				{
					$sql = $sql." limit 0,".$this->configuration_data['number_of_ads_to_display'];
				}
				if($this->debug_search) echo $sql.' is the final sql_query<br />';
				$result = $db->Execute($sql);
				if(!$result)
				{
					if ($this->debug_search)
					{
						echo $db->ErrorMsg()." is the error<br />\n";
					}
					//no results
					$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
					return false;
				}
				/*elseif($result->RecordCount() == 1)
				{

					$returned_result = $result->FetchNextObject();

					if ($this->debug_search)
					{
						echo "REDIRECTING TO ID: ".$returned_result->ID." as the only result of a search<br />\n";
					}

					header("Location: ".$this->configuration_data['classifieds_url']."?a=2&b=".$returned_result->ID);
					exit;

				}*/
				elseif($result->RecordCount() > 0)
				{
					 //".$order_by;
					$this->BuildResults($db, $result);
				}
				else
				{
					// No results returned
					$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
					return false;
				}
			}
			else
			{
				//no results
				$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
				return false;
			}
			return true;
		}
		else
		{
			// No search criteria
			//no results
			$this->body .="<table><tr class=\"search_page_instructions\">\n\t<td colspan=\"4\">\n\t".geoString::fromDB($this->messages[592])."\n\t</td>\n</tr></table>\n";
			return false;
		}
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function BuildResults($db, $result = 0)
	{
		$this_copy =& $this;
		$overload = geoAddon::triggerDisplay('overload_Search_classifieds_BuildResults', array ('result'=>$result, 'this' => $this_copy), geoAddon::OVERLOAD);
		if ($overload !== geoAddon::NO_OVERLOAD) {
			return $overload;
		}
		//$this->total_returned = $result->RecordCount();
		if ($this->debug_display_results)
		{
			echo "<br />TOP OF BUILDRESULTS<br />\n";
			echo $this->total_returned." is total_returned<br />\n";
			echo $this->configuration_data['number_of_ads_to_display']." is NUMBER_OF_ADS_TO_DISPLAY<br />\n";
		}
		
		$db = DataAccess::getInstance();
		
		$tpl = new geoTemplate('system', 'search_class');
		$tpl_vars = array();
		//use main browsing display settings for now
		$fields = $this->fields->getDisplayLocationFields('search_results');
			
		$search_link = $this->configuration_data['classifieds_file_name']."?a=19";
		if ($this->site_category) //category
			$search_link .="&amp;c=".$this->site_category;
			
		if(isset($_REQUEST['template_id']) && is_numeric($_REQUEST['template_id']) && $_REQUEST['template_id']) {
			$search_link .= "&amp;template_id=".$_REQUEST['template_id'];
		}
		$tpl_vars['form_target'] = $search_link;

		$b_string = '';
		foreach ($this->search_criteria as $key => $val){
			if (is_array($val)){
				foreach ($val as $sub_key => $sub_val){
					if (strlen(trim($sub_val))>0){
						//Note:  values already html entitied by clean_inputs.php
						$b_string .= '&amp;b['.$key.']['.$sub_key.']='.$sub_val;
					}
				}
			} else if ($key != 'page' && strlen(trim($val))>0){
				if($key == 'by_country') {
					//special case - country needs to always be urlencoded
					$val = geoString::toDB($val);
				}
				//Note:  values already html entitied by clean_inputs.php
				$b_string .= '&amp;b['.$key.']='.$val;
			}
		}
		$search_link .= $b_string;
		$b_variable = $search_link;

		if ($this->browse_type) {
			//order used for next page links
			$search_link .="&amp;order=".$this->browse_type;
		}

		$tpl_vars['search_link'] = $search_link;

		if ($this->configuration_data['number_of_ads_to_display'] < $this->total_returned)
		{
			$tpl_vars['show_pagination_links'] = true;
			
			$totalPages = ceil($this->total_returned / $this->configuration_data['number_of_ads_to_display']);
			$currentPage = ($this->search_criteria["page"]) ? $this->search_criteria["page"] : 1;
			$css = 'search_result_page_links';
			$link = $search_link . "&amp;b[page]=";
			
			$tpl_vars['pagination'] = geoPagination::getHTML($totalPages, $currentPage, $link, $css); 
			$tpl_vars['total_search_results'] = $this->total_returned;

		}

		if ($this->total_returned > 0)
		{
			$tpl_vars['resultsToShow'] = true;
			
			$search_link = $b_variable; //reset search link to version w/o order
			$headers = array();
			$h = 0; //headers index
			if (geoPC::is_class_auctions() && $db->get_site_setting('listing_type_allowed') == 0)
			{
				//display the auction or classified column header
				$headers[$h]['text'] = geoString::fromDB($this->messages[200024]);
				if ($this->browse_type == 65) {
					$headers[$h]['link'] = $search_link.'&amp;order=66';					
				} elseif ($this->browse_type == 66) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=65';
				}
				$h++;
			}
			if ($fields['business_type']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[500245]);
				$h++;
			}

			if ($fields['photo']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[594]);
				$h++;
			}

			if ($fields['title'])
			{
				if ((($fields['description'])&& ($this->configuration_data['display_ad_description_where'])) || (!$fields['description'])) {
					$headers[$h]['style'] = "width: 100%;";
				}
				$headers[$h]['text'] = geoString::fromDB($this->messages[595]);
				if($this->browse_type == 5) {
					$headers[$h]['link'] = $search_link.'&amp;order=6';
				} elseif($this->browse_type == 6) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=5';
				}

				if (($fields['description']) && ($this->configuration_data['display_ad_description_where'])) {
					$headers[$h]['text2'] = $this->messages[596]; 
				}
				$h++;
			}

			if (($fields['description']) && (!$this->configuration_data['display_ad_description_where'])) {
				$headers[$h]['text'] = $this->messages[596];
				$h++;
			}
			
			if ($fields['tags']) {
				$headers[$h]['text'] = $this->messages[500880];
				$h++;
			}
			
			if ( geoPC::is_ent() )
			{
				//Optional Fields
				for($i = 1; $i <= 20; $i++) {
					if ($fields['optional_field_'.$i]) {
						if($i <= 10) {
							//first 10 use a different numbering scheme
							$headers[$h]['text'] = geoString::fromDB($this->messages[1442+$i]);
							if($this->browse_type == (13 + 2*$i)) {
								$order = 14 + 2*$i;
							} elseif ($this->browse_type == (14 + 2*$i)) {
								$order = 0;
							} else {
								$order = 13 + 2*$i;
							}
						} else {
							$headers[$h]['text'] = geoString::fromDB($this->messages[1922+($i-10)]);
							if($this->browse_type == (43 + 2*($i-10))) {
								$order = 44 + 2*($i-10);
							} elseif ($this->browse_type == (44 + 2*($i-10))) {
								$order = 0;
							} else {
								$order = 43 + 2*($i-10);
							}
						}
						$headers[$h]['link'] = $search_link.'&amp;order='.$order;
						$h++;
					}
				}	
			}
			
			if ($fields['address']) {
				$headers[$h]['class'] = 'address_column_header';
				$headers[$h]['text'] = geoString::fromDB($this->messages[500246]);
				$h++;
			}
			
			if ($fields['city']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[1453]);
				if ($this->browse_type == 35) {
					$headers[$h]['link'] = $search_link.'&amp;order=36';					
				} elseif ($this->browse_type == 36) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=35';
				}
				$h++;
			}
			if ($fields['state']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[1454]);
				if ($this->browse_type == 37) {
					$headers[$h]['link'] = $search_link.'&amp;order=38';					
				} elseif ($this->browse_type == 38) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=37';
				}
				$h++;
			}
			if ($fields['country']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[1455]);
				if ($this->browse_type == 39) {
					$headers[$h]['link'] = $search_link.'&amp;order=40';					
				} elseif ($this->browse_type == 40) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=39';
				}
				$h++;
			}
			if ($fields['zip']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[1456]);
				if ($this->browse_type == 41) {
					$headers[$h]['link'] = $search_link.'&amp;order=42';					
				} elseif ($this->browse_type == 42) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=41';
				}
				$h++;
			}
			if (geoPC::is_auctions() && $fields['num_bids']) {
				$headers[$h]['class'] = 'number_bids_header';
				$headers[$h]['text'] = geoString::fromDB($this->messages[500247]);
				$h++;
			}
			if ($fields['price']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[597]);
				if ($this->browse_type == 2) {
					$headers[$h]['link'] = $search_link.'&amp;order=1';					
				} elseif ($this->browse_type == 1) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=2';
				}
				$h++;
			}
			if ($fields['classified_start']) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[598]);
				if ($this->browse_type == 3) {
					$headers[$h]['link'] = $search_link.'&amp;order=4';					
				} elseif ($this->browse_type == 4) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=3';
				}
				$h++;
			}
			if ((geoPC::is_auctions() && $fields['auction_time_left']) || (geoPC::is_classifieds() && $fields['classified_time_left'])) {
				$headers[$h]['text'] = geoString::fromDB($this->messages[500092]);
				if ($this->browse_type == 67) {
					$headers[$h]['link'] = $search_link.'&amp;order=68';					
				} elseif ($this->browse_type == 68) {
					$headers[$h]['link'] = $search_link.'&amp;order=0';
				} else {
					$headers[$h]['link'] = $search_link.'&amp;order=67';
				}
				$h++;
			}

			if (($this->search_criteria["by_zip_code"]) && ($this->search_criteria["by_zip_code_distance"])) {
				//TODO: move to addon file
				$zipSettings = geoAddon::getRegistry('zipsearch');
				if($zipSettings) {
					$zipText = geoAddon::getText('geo_addons','zipsearch');
					$headers[$h]['text'] = ($zipSettings->units == 'M') ? $zipText['tbl_head_distance_mi'] : $zipText['tbl_head_distance_km'];
				} else {
					//somehow searching without the zipsearch addon
					$headers[$h]['text'] = geoString::fromDB($this->messages[1948]);
				}
				$h++;
			}
				
			/**
			 * Addon core event:
			 * name: Search_classifieds_BuildResults_addHeader
			 * vars: array (this => Object) (this is the instance of $this.
			 */
			$tpl_vars['addonHeaders'] = geoAddon::triggerDisplay('Search_classifieds_BuildResults_addHeader', array('this'=>$this, 'search_fields'=>$fields), geoAddon::ARRAY_ARRAY);
				
			if (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) {
				$tpl_vars['show_edit_header'] = true;
			}
			if (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) {
				$tpl_vars['show_delete_header'] = true;
			}
			
			
			$tpl_vars['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
			$tpl_vars['popup_height'] = $this->configuration_data['popup_while_browsing_height'];

			$no_image_url = ($this->messages[500795])? geoTemplate::getURL('',$this->messages[500795]) : '';
			$photo_icon_url = ($this->messages[500796])? geoTemplate::getURL('',$this->messages[500796]) : '';
			
			$this->row_count = 0;
			$listings = array();
			for ($l = 0; $show_classifieds = $result->FetchNextObject(); $l++)
			{
				$listings[$l]['columns'] = array();
				$col = 0; // column index
				
				if (($this->row_count % 2) == 0)
				{
					$css_class_tag = "search_page_results_even_row";
					$css_class_tag_bold = "search_page_results_even_row_bold";
				}
				else
				{
					$css_class_tag = "search_page_results_odd_row";
					$css_class_tag_bold = "search_page_results_odd_row_bold";
				}
				// Bolding
				if ($show_classifieds->BOLDING) {
					$listings[$l]['class'] = $css_class_tag_bold;
				} else {
					$listings[$l]['class'] = $css_class_tag;
				}

				if (geoPC::is_class_auctions() && $db->get_site_setting('listing_type_allowed') == 0)
				{
					if ($show_classifieds->ITEM_TYPE == 1) {
						$listings[$l]['columns'][$col]['text'] = geoString::fromDB($this->messages[200026]);
					} elseif ($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4) {
						$listings[$l]['columns'][$col]['text'] = geoString::fromDB($this->messages[200025]);
					}
					$col++;
				}

				if ($fields['business_type']) {
					if ($show_classifieds->BUSINESS_TYPE == 1) {
						$listings[$l]['columns'][$col]['text'] = geoString::fromDB($this->messages[500400]);
					} elseif ($show_classifieds->BUSINESS_TYPE == 2) {
						$listings[$l]['columns'][$col]['text'] = geoString::fromDB($this->messages[500401]);
					} else {
						$listings[$l]['columns'][$col]['text'] = '';
					}
					$col++;
				}

				if ($fields['photo'])
				{
					if (($this->configuration_data['popup_while_browsing'])	&& ($this->configuration_data['popup_while_browsing_width']) && ($this->configuration_data['popup_while_browsing_height'])) {
						$listings[$l]['columns'][$col]['popup'] = true;
					}
					
					$listings[$l]['columns'][$col]['link'] = $this->configuration_data['classifieds_file_name']."?a=2&amp;b=".$show_classifieds->ID;
					
					if ($this->configuration_data['photo_or_icon'] == 1)
					{
						if ($show_classifieds->IMAGE > 0)
						{
							if ($featured) {
								$listings[$l]['columns'][$col]['thumbnail'] = geoImage::display_thumbnail($show_classifieds->ID,$this->configuration_data['featured_thumbnail_max_width'],$this->configuration_data['featured_thumbnail_max_height'],1);
							} else {
								$listings[$l]['columns'][$col]['thumbnail'] = geoImage::display_thumbnail($show_classifieds->ID,0,0,1);
							}
						}
						elseif ($no_image_url && (!$show_classifieds->IMAGE))
						{
							$listings[$l]['columns'][$col]['style'] = "text-align: center;";
							$listings[$l]['columns'][$col]['text'] = "<img src=\"$no_image_url\" alt=\"\" />";
						}
						else {
							unset($listings[$l]['columns'][$col]['link']);
							$listings[$l]['columns'][$col]['text'] = "";
						}
					}
					else
					{
						if ($show_classifieds->IMAGE > 0) {
							$listings[$l]['columns'][$col]['text'] = "<img src=\"$photo_icon_url\" alt=\"\" />";
						} elseif ($no_image_url && (!$show_classifieds->IMAGE)) {
							$listings[$l]['columns'][$col]['text'] = "<img src=\"$no_image_url\" alt=\"\" />";
						} else {
							unset($listings[$l]['columns'][$col]['link']);
							$listings[$l]['columns'][$col]['text'] = "";
						}
					}
					$col++;
				}
				if ($fields['title']) {
					if ((($fields['description'])&& ($this->configuration_data['display_ad_description_where'])) || (!$fields['description'])) {
						$listings[$l]['columns'][$col]['style'] = "width: 100%;";
					}
					if ($show_classifieds->SOLD_DISPLAYED) {
						$listings[$l]['columns'][$col]['pre_image'] = geoTemplate::getUrl('',$this->messages[500798]);
					}
					$listings[$l]['columns'][$col]['link'] = $this->configuration_data['classifieds_file_name']."?a=2&amp;b=".$show_classifieds->ID;
					$listings[$l]['columns'][$col]['text'] = stripslashes(geoString::fromDB($show_classifieds->TITLE));
					
					if ($show_classifieds->ATTENTION_GETTER) {
						$listings[$l]['columns'][$col]['post_image'] = $show_classifieds->ATTENTION_GETTER_URL;
					}
					if (($fields['description']) && ($this->configuration_data['display_ad_description_where'])) {
						$cleaned_desc = trim(strip_tags(stripslashes(geoString::fromDB($show_classifieds->DESCRIPTION))));
						if (strlen($cleaned_desc) > $this->configuration_data['length_of_description']) {
							$small_string = geoString::substr($cleaned_desc,0,$this->configuration_data['length_of_description']);
							$position = strrpos($small_string," ");
							$smaller_string = geoString::substr($small_string,0,$position);
							$cleaned_desc = $smaller_string."...";
						}
						$listings[$l]['columns'][$col]['text2'] = $cleaned_desc;
					}
					$col++;
				}

				if (($fields['description']) && (!$this->configuration_data['display_ad_description_where'])) {
					if (!$this->configuration_data['display_all_of_description']) {
						$cleaned_desc = trim(strip_tags(stripslashes(geoString::fromDB($show_classifieds->DESCRIPTION))));
						if (strlen($cleaned_desc) > $this->configuration_data['length_of_description']) {
							$small_string = geoString::substr($cleaned_desc,0,$this->configuration_data['length_of_description']);
							$position = strrpos($small_string," ");
							$smaller_string = geoString::substr($small_string,0,$position);
							$cleaned_desc = $smaller_string."...";
						}
						$listings[$l]['columns'][$col]['text'] = $cleaned_desc;
					} else {
						$listings[$l]['columns'][$col]['text'] = stripslashes(geoString::fromDB($show_classifieds->DESCRIPTION));
					}
					$col++;
				}
				
				if ($fields['tags']) {
					$tags = geoListing::getTags($show_classifieds->ID);
					$text = '';
					if (count($tags) > 0) {
						$tplTags = new geoTemplate ('system','browsing');
						$tplTags->listing_tags_array = $tags;
						
						$text = $tplTags->fetch('common/listing_tags.tpl');
						unset($tplTags);
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}
				
				if (geoPC::is_ent()) {
					for($i = 1; $i <= 20; $i++) {
						if ($fields['optional_field_'.$i]) {
							$name = "OPTIONAL_FIELD_".$i;
							$f = strtolower($name);
							$text = trim(geoString::fromDB($show_classifieds->$name));
							
							if($this->fields->$f->field_type == 'cost') {
								$text = geoString::displayPrice($text, $show_classifieds->PRECURRENCY, $show_classifieds->POSTCURRENCY);
							}
							if(!strlen($text)) {
								$text = '-';	
							}
							$listings[$l]['columns'][$col]['text'] = $text;
						}
						$col++;
					}
				}
				
				if ($fields['address']) {
					$text = trim(geoString::fromDB($show_classifieds->LOCATION_ADDRESS));
					if(!strlen($text)) {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}
				
				if ($fields['city']) {
					$text = trim(geoString::fromDB($show_classifieds->LOCATION_CITY));
					if(!strlen($text)) {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}

				if ($fields['state']) {
					$text = trim(geoString::fromDB($show_classifieds->LOCATION_STATE));
					if(!strlen($text)) {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}

				if ($fields['country']) {
					$text = trim(geoString::fromDB($show_classifieds->LOCATION_COUNTRY));
					if(!strlen($text)) {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}

				if ($fields['zip']) {
					$text = trim(geoString::fromDB($show_classifieds->LOCATION_ZIP));
					if(!strlen($text)) {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$col++;
				}
				
				if (geoPC::is_auctions() && $fields['num_bids']) {
					if ($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4) {
						//Note: don't add bids to the end like in past, it's redundant to table header column
						$text = $this->get_number_of_bids($db,$show_classifieds->ID);
					} else {
						$text = '-';
					}
					$listings[$l]['columns'][$col]['text'] = $text;
					$listings[$l]['columns'][$col]['style'] = "white-space:nowrap; text-align:center;";
					$col++;
				}

				if ($fields['price']) {
					$listings[$l]['columns'][$col]['style'] = "white-space:nowrap; text-align:center;";
					if ($show_classifieds->ITEM_TYPE == 2 && $show_classifieds->MINIMUM_BID == 0 && (($show_classifieds->BUY_NOW == 0) && ($show_classifieds->BUY_NOW_ONLY == 0))) {
						$show_classifieds->MINIMUM_BID = 0.01;
					}
					if (($show_classifieds->ITEM_TYPE == 1))
					{
						$listings[$l]['columns'][$col]['text'] = $this->show_money($show_classifieds->PRICE,$show_classifieds->PRECURRENCY,$show_classifieds->POSTCURRENCY,1);
					}
					elseif (($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4) && ($show_classifieds->MINIMUM_BID == 0)
						&& ($show_classifieds->CURRENT_BID == 0) && ($show_classifieds->STARTING_BID == 0) && ($show_classifieds->BUY_NOW != 0))
					{
						//this is a buy now only auction
						$listings[$l]['columns'][$col]['text'] = $this->show_money($show_classifieds->BUY_NOW,$show_classifieds->PRECURRENCY,$show_classifieds->POSTCURRENCY,1);
					}
					elseif (($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4) && ($show_classifieds->MINIMUM_BID != 0))
					{
						if ($show_classifieds->MINIMUM_BID < $show_classifieds->STARTING_BID) {
							$show_classifieds->MINIMUM_BID = $show_classifieds->STARTING_BID;
						}
						$listings[$l]['columns'][$col]['text'] = $this->show_money($show_classifieds->MINIMUM_BID,$show_classifieds->PRECURRENCY,$show_classifieds->POSTCURRENCY,1);
					}
					elseif (($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4) && ($show_classifieds->STARTING_BID != 0))
					{
						$listings[$l]['columns'][$col]['text'] = $this->show_money($show_classifieds->STARTING_BID,$show_classifieds->PRECURRENCY,$show_classifieds->POSTCURRENCY,1);
					}
					$col++;
				}

				if ($fields['classified_start'])
				{
					$listings[$l]['columns'][$col]['text'] = date($this->configuration_data['entry_date_configuration'],$show_classifieds->DATE);
					$col++;
				}

				if( (geoPC::is_auctions() && $fields['auction_time_left'] && ($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4)) ||
					(geoPC::is_classifieds() && $fields['classified_time_left'] && $show_classifieds->ITEM_TYPE == 1) ) 
				{
					$listings[$l]['columns'][$col]['style'] = "text-align:center;";
					$listings[$l]['columns'][$col]['text'] = '';
					$weeks = $this->DateDifference(w,geoUtil::time(),$show_classifieds->ENDS);
					$remaining_weeks = ($weeks * 604800);

					// Find days left
					$days = $this->DateDifference(d,(geoUtil::time()+$remaining_weeks),$show_classifieds->ENDS);
					$remaining_days = ($days * 86400);

					// Find hours left
					$hours = $this->DateDifference(h,(geoUtil::time()+$remaining_days),$show_classifieds->ENDS);
					$remaining_hours = ($hours * 3600);

					// Find minutes left
					$minutes = $this->DateDifference(m,(geoUtil::time()+$remaining_hours),$show_classifieds->ENDS);
					$remaining_minutes = ($minutes * 60);

					// Find seconds left
					$seconds = $this->DateDifference(s,(geoUtil::time()+$remaining_minutes),$show_classifieds->ENDS);
					if(($weeks <= 0) && ($days <= 0) && ($hours <= 0) && ($minutes <= 0) && ($seconds <= 0))
					{
						// If closed we want to display closed text
						$listings[$l]['columns'][$col]['text'] .= geoString::fromDB($this->messages[500093])."</div>";
					}
					if ($weeks > 0)
					{
						$listings[$l]['columns'][$col]['text'] .= $weeks." ".stripslashes(geoString::fromDB($this->messages[500087])).", ".$days." ".stripslashes(geoString::fromDB($this->messages[500088]));
					}
					elseif ($days > 0)
					{
						$listings[$l]['columns'][$col]['text'] .= $days." ".stripslashes(geoString::fromDB($this->messages[500088])).", ".$hours." ".stripslashes(geoString::fromDB($this->messages[500089]));
					}
					elseif ($hours > 0)
					{
						$listings[$l]['columns'][$col]['text'] .= $hours." ".stripslashes(geoString::fromDB($this->messages[500089])).", ".$minutes." ".stripslashes(geoString::fromDB($this->messages[500090]));
					}
					elseif ($minutes > 0)
					{
						$listings[$l]['columns'][$col]['text'] .= $minutes." ".stripslashes(geoString::fromDB($this->messages[500090])).", ".$seconds." ".stripslashes(geoString::fromDB($this->messages[500091]));
					}
					elseif ($seconds > 0)
					{
						$listings[$l]['columns'][$col]['text'] .= $seconds." ".stripslashes(geoString::fromDB($this->messages[500091]));
					}
					$col++;
				}
				else if ( (geoPC::is_auctions() && $fields['auction_time_left'] && !$fields['classified_time_left'] && $show_classifieds->ITEM_TYPE == 1) ||
						  (geoPC::is_classifieds() && $fields['classified_time_left'] && !$fields['auction_time_left'] && ($show_classifieds->ITEM_TYPE == 2 || $show_classifieds->ITEM_TYPE == 4)) )
				{
					//show this when time_left is used but classified_time_left is not
					$listings[$l]['columns'][$col]['text'] = geoString::fromDB($this->messages[500108]);
					$col++;
				}
				
				if (($this->search_criteria["by_zip_code"]) && ($this->search_criteria["by_zip_code_distance"]))
				{
					//get distance away from center of search area
					//TODO: move to zipsearch addon?
					$zipSettings = geoAddon::getRegistry('zipsearch');
					if($zipSettings) {
						$listingZip = $show_classifieds->LOCATION_ZIP;
						$searchZip = $this->search_criteria['by_zip_code'];
						if($zipSettings->search_method == 'hierarchical') {
							$listingZip = trim($listingZip); //since we're searching for a space, trim it for sanity
							$space = strpos($listingZip, ' ');
							$length = ($space === false) ? 3 : $space; //figure out the number of characters to read
							$listingZip = substr($listingZip,0,$length); //set the filter to be just those characters
						}
						$sql = "select latitude,longitude from ".geoTables::postal_code_table."where zipcode = ? limit 1";
						$listingOrigin = $db->GetRow($sql, array($listingZip));
						$searchOrigin = $db->GetRow($sql, array($searchZip));
						$distance = geoNumber::distanceBetweenPoints($listingOrigin['latitude'], $listingOrigin['longitude'],$searchOrigin['latitude'], $searchOrigin['longitude'], $zipSettings->units);
						
						$listings[$l]['columns'][$col]['text'] = sprintf("%01.2f",$distance);
						
					} else {
						//somehow this zipcode search was done without the zipsearch addon in place
						//display the zipcode found, but not the range
						$listings[$l]['columns'][$col]['text'] = $show_classifieds->LOCATION_ZIP;
					}
					$col++;
				}
				
				/**
				 * Addon core event:
				 * name: Search_classifieds_BuildResults_addRow
				 * vars: array (this => Object, listing_id => int (listing id)) (this is the instance of $this.
				 */
				$listings[$l]['addonColumns'] = geoAddon::triggerDisplay('Search_classifieds_BuildResults_addRow', array('this'=>$this,'listing_id' => $show_classifieds->ID, 'search_fields'=>$fields), geoAddon::ARRAY_ARRAY);
				
				if (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) {
					$listings[$l]['edit_link'] = $this->configuration_data['classifieds_file_name']."?a=cart&amp;action=new&amp;main_type=listing_edit&amp;listing_id=".$show_classifieds->ID;
				}
					
				if (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) {
					$listings[$l]['delete_link'] = $this->configuration_data['classifieds_file_name']."?a=99&amp;b=".$show_classifieds->ID."&amp;c=".$category;
				}

				$this->row_count++;
			} //end of while
		}

		$tpl_vars['new_search_link'] = $this->configuration_data['classifieds_file_name'] . "?a=19";
		
		
		$tpl->assign('tpl_vars', $tpl_vars);
		$tpl->assign('headers', $headers);
		$tpl->assign('listings', $listings);
		$this->body = $tpl->fetch('search_results.tpl');

		$this->display_page($db);
	} // end function BuildResults

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function CountOptionalFields()
	{
		$count = 0;
		for($i = 1; $i <= 20; $i++)
		{
			$field='optional_field_'.$i;
			if ($this->fields->$field->is_enabled) {
				$count=$i;
			}
		}
		
		$this->max_optional_fields = $count;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function test_titles_and_descriptions ($term)
	{
		if ($this->debug_search)
		{
			echo $term." is term at the top of test_titles_and_descriptions<br />\n";
			echo $this->where_clause." is the where clause at top of test_titles_and_descriptions<br />\n";
		}

		//$term = urlencode($term);
		if ($this->search_criteria["whole_word"] == 2)
		{
			$this->where_clause .= "(id = ".$term.")";
		}
		else
		{
			if ($this->search_criteria["search_titles"])
			{
				if ($this->search_criteria["whole_word"])
				{
					$this->where_clause .= "((title LIKE \"%+".$term."+%\") or (title LIKE \"%+".$term."\") or (title LIKE \"".$term."+%\")) ";
					if (ereg("^[0-9]{1,10}$", trim($term)))
						$this->where_clause .= "or (id = ".$term.")";
					//$this->where_clause .= ")";
				}
				else
				{
					$this->where_clause .= "(title LIKE \"%".$term."%\")";
					if (ereg("^[0-9]{1,10}$", trim($term)))
						$this->where_clause .= "or (id = ".$term.")";
					//$this->where_clause .= ")";
				}

				$this->started = 1;
				if ($this->search_criteria["search_descriptions"])
				{
					$this->where_clause .= " or ";
					if ($this->search_criteria["whole_word"])
					{
						$this->where_clause .= "((description LIKE \"%+".$term."+%\") or (search_text LIKE \"%+".$term."+%\") or (description LIKE \"%+".$term."\") or (search_text LIKE \"%+".$term."\") or (description LIKE \"".$term."+%\") or (search_text LIKE \"".$term."+%\"))";
					}
					else
						$this->where_clause .= "((description LIKE \"%".$term."%\") or (search_text LIKE \"%".$term."%\"))";
				}

			}
			elseif ($this->search_criteria["search_descriptions"])
			{
				if ($this->search_criteria["whole_word"])
					$this->where_clause .= "((description LIKE \"%+".$term."+%\") or (search_text LIKE \"%+".$term."+%\") or (description LIKE \"%+".$term."\") or (search_text LIKE \"%+".$term."\") or (description LIKE \"".$term."+%\") or (search_text LIKE \"".$term."+%\")) or id = ".$term.")";
				else
					$this->where_clause .= "((description LIKE \"%".$term."%\") or (search_text LIKE \"%".$term."%\")) or id = ".$term.")";
				$this->started = 1;
			}
			else
			{
				$this->where_clause .= "(search_text LIKE \"%".$term."%\")";
			}
		}
		if ($this->debug_search)
		{
			echo $term." is term at the bottom of test_titles_and_descriptions<br />\n";
			echo $this->where_clause." is the where clause at the end of test_titles_and_descriptions<br />\n";
		}
		return true;

	} //end of function test_titles_and_descriptions

//##################################################################################

	function filter_select($db,$filter_id=0)
	{
		//check current temp filter
		//see if there are subfilters
		if ($filter_id)
		{
			$sql = "select ".$this->filters_table.".filter_id, ".$this->filters_table.".filter_level, ".$this->filters_table.".parent_id,".$this->filters_languages_table.".filter_name
				from ".$this->filters_table.",".$this->filters_languages_table."
				where ".$this->filters_table.".filter_id = ".$this->filters_languages_table.".filter_id
				and ".$this->filters_languages_table.".language_id = ".$this->language_id."
				and ".$this->filters_table.".parent_id = ".$filter_id." order by display_order asc,".$this->filters_languages_table.".filter_name";
		}
		else
			$sql = "select ".$this->filters_table.".filter_id, ".$this->filters_table.".filter_level, ".$this->filters_table.".parent_id,".$this->filters_languages_table.".filter_name
				from ".$this->filters_table.",".$this->filters_languages_table."
				where ".$this->filters_table.".filter_id = ".$this->filters_languages_table.".filter_id
				and ".$this->filters_languages_table.".language_id = ".$this->language_id."
				and filter_level = 1 order by display_order asc,".$this->filters_languages_table.".filter_name";
		$sub_filter_result = $db->Execute($sql);
		if ($this->debug_register) echo $sql."<br />\n";
		if (!$sub_filter_result)
		{
			if ($this->debug_register) echo $sql."<br />\n";
			$this->error_message = $this->messages[105501];
			return false;
		}
		elseif ($sub_filter_result->RecordCount() > 0)
		{
			$this->page_id = 10092;
		//	echo "get_text inside filter_select function <br />";
			$this->get_text();
			//display the form top
			$this->body .= "<form action=\"";
			if ($this->configuration_data['use_ssl_in_registration'])
				$this->body .= trim($this->configuration_data['registration_ssl_url']);
			else
				$this->body .=  trim($this->configuration_data['registration_url']);
			$this->body .= "\" method=\"post\">\n";
			$this->body .="<table cellpadding=\"2\" cellspacing=\"1\" align=\"center\" width=\"100%\">\n\t";
			$this->body .="<tr class=\"section_title\">\n\t\t<td>".geoString::fromDB($this->messages[101502])."</td>\n\t</tr>\n\t";
			$this->body .="<tr class=\"page_title\">\n\t\t<td>".geoString::fromDB($this->messages[101503])."</td>\n\t</tr>\n\t";
			$this->body .="<tr class=\"page_description\">\n\t\t<td>".geoString::fromDB($this->messages[101504])."</td>\n\t</tr>\n\t";
			$this->body .="<tr class=\"filter_selection\">\n\t\t<td>";
			//get the parent filters to this one
			$show_level = $sub_filter_result->FetchNextObject();
			if ($show_level->PARENT_ID != 0)
			{
				//show the parent levels
				$filter_tree = $this->get_filter_level($db,$show_level->PARENT_ID);
				reset ($this->filter_level_array);
				if ($filter_tree)
				{
					foreach ($this->filter_level_array as $key => $value)
						$this->body .= $this->filter_level_array[$key]["filter_name"]." > ";
				}
			}
			$sub_filter_result->Move(0);

			//show the form to select filter
			$this->body .= "<select name=\"registration_filter_id\" class=\"filter_dropdown\" onchange=\"if(this.options[this.selectedIndex].value != '') this.form.submit();\" />\n\t\t";
			$this->body .= "<option value=\"\">".geoString::fromDB($this->messages[101505])."</option>\n\t\t";
			while ($show_filter = $sub_filter_result->FetchNextObject())
			{
				$this->body .= "<option value=\"".$show_filter->FILTER_ID."\">".$show_filter->FILTER_NAME."</option>\n\t\t";
			}
			$this->body .= "</select>";
			//display the form bottom
			$this->body .= "</td></tr>";
			$this->body .= "</table></form>";
			$this->display_page($db);
			exit;
		}
		else
		{
			//this is the terminal filter...set it
			$this->update_filter_id($db,$filter_id);
			$this->registration_form_1($db);
		}

	} //end of function filter_select

//########################################################################

	function update_filter_id($db,$filter_id)
	{
		$this->registration_filter_id = $filter_id;
		$sql = "update ".$this->registration_table." set
			filter_id = ".$filter_id."
			where session=\"".$this->session_id."\"";
		$registration_filter_id_result = $db->Execute($sql);
		if ($this->debug_register) echo $sql."<br />\n";
		if (!$registration_filter_id_result)
		{
			if ($this->debug_register) echo $sql."<br />\n";
			return false;
		}
	} // end of update_filter_id

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_filter_value($db,$association=0)
	{
		if ($association)
		{
			//association is the filter level this value is associated with
			$sql = "select count(distinct(filter_level)) as level_count from ".$this->filters_table;
			$level_count_result = $db->Execute($sql);
			if ($this->debug_register) echo $sql."<br />\n";
			if (!$level_count_result)
			{
				if ($this->debug_register) echo $sql."<br />\n";
				$this->error_message = $this->messages[105501];
				return false;
			}
			elseif ($level_count_result->RecordCount() == 1)
			{
				$level_count = $level_count_result->FetchNextObject();
				if ($level_count->LEVEL_COUNT == $association)
				{
					//get current filter id filter name
					$sql = "select ".$this->filters_languages_table.".filter_name
						from ".$this->filters_languages_table."
						where ".$this->filters_languages_table.".language_id = ".$this->language_id."
						and ".$this->filters_languages_table.".filter_id = ".$this->registration_filter_id;
					$filter_result =  $db->Execute($sql);
					if ($this->debug_register) echo $sql."<br />\n";
					if (!$filter_result)
					{
						if ($this->debug_register) echo $sql."<br />\n";
						$this->error_message = $this->messages[103501];
						return false;
					}
					elseif ($filter_result->RecordCount() == 1)
					{
						$show_filter_name = $filter_result->FetchNextObject();
						return $show_filter_name->FILTER_NAME;
					}
					else
						return false;

				}
				else
				{
					$filter_name = $this->get_filter_level($db,$this->registration_filter_id,$association);
					return $filter_name;
				}
			}
			else
			{
				return false;
			}
		}
		else
			return false;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_filter_level($db,$filter=0,$level_result=0)
	{
		if ($filter)
		{
			$i = 0;
			$filter_next = $filter;
			do
			{
				$sql = "select ".$this->filters_table.".filter_id,".$this->filters_table.".parent_id,
					".$this->filters_languages_table.".filter_name, ".$this->filters_table.".filter_level
					from ".$this->filters_table.",".$this->filters_languages_table."
					where ".$this->filters_table.".filter_id = ".$this->filters_languages_table.".filter_id
					and ".$this->filters_languages_table.".language_id = ".$this->language_id."
					and ".$this->filters_table.".filter_id = ".$filter_next;
				$filter_result =  $db->Execute($sql);
				if ($this->debug_register) echo $sql."<br />\n";
				if (!$filter_result)
				{
					if ($this->debug_register) echo $sql."<br />\n";
					$this->error_message = $this->messages[103501];
					return false;
				}
				elseif ($filter_result->RecordCount() == 1)
				{
					$show_filter = $filter_result->FetchNextObject();
					$this->filter_level_array[$i]["parent_id"]  = $show_filter->PARENT_ID;
					$this->filter_level_array[$i]["filter_name"] = $show_filter->FILTER_NAME;
					$this->filter_level_array[$i]["filter_id"]   = $show_filter->FILTER_ID;
					$this->filter_level_array[$i]["filter_level"]   = $show_filter->FILTER_LEVEL;
					if (($level_result) && ($level_result == $show_filter->FILTER_LEVEL))
						return $show_filter->FILTER_NAME;
					$i++;
					$filter_next = $show_filter->PARENT_ID;
				}
				else
				{
					//echo "wrong return<br />\n";
					return false;
				}

			} while ( $show_filter->PARENT_ID != 0 );

			return $i;
		}
		else
			return false;

	} // end of function get_filter_level
	function get_order_by($browse_type=0)
	{
		// Create order by clause

		switch ($browse_type)
		{
			case 0: //nothing
				$order_by = " order by better_placement desc,date desc ";
				break;
			case 1: //price desc
				$order_by = " order by price desc, minimum_bid desc, better_placement desc ";
				break;
			case 2: //price asc
				$order_by = " order by price asc, minimum_bid asc, better_placement desc ";
				break;
			case 3: //date earliest to latest
				$order_by = " order by date asc, better_placement desc ";
				break;
			case 4: //date latest to earliest
				$order_by = " order by date desc, better_placement desc ";
				break;
			case 5: //title asc
				$order_by = " order by title asc, better_placement desc ";
				break;
			case 6: //title desc
				$order_by = " order by title desc, better_placement desc ";
				break;
			case 7: //city asc
				$order_by = " order by location_city asc, better_placement desc ";
				break;
			case 8: //city desc
				$order_by = " order by location_city desc, better_placement desc ";
				break;
			case 9: //state asc
				$order_by = " order by location_state asc, better_placement desc ";
				break;
			case 10: //state desc
				$order_by = " order by location_state desc, better_placement desc ";
				break;
			case 11: //country asc
				$order_by = " order by location_country asc, better_placement desc ";
				break;
			case 12: //country desc
				$order_by = " order by location_country desc, better_placement desc ";
				break;
			case 13: //zip asc
				$order_by = " order by location_zip asc, better_placement desc ";
				break;
			case 14: //zip desc
				$order_by = " order by location_zip desc, better_placement desc ";
				break;
			case 15: //optional field 1 asc
				$sort_txt = (in_array($this->fields->optional_field_1->field_type, array ('number','cost')))? '(`optional_field_1` * 1)': 'optional_field_1';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 16: //optional field 1 desc
				$sort_txt = (in_array($this->fields->optional_field_1->field_type, array ('number','cost')))? '(`optional_field_1` * 1)': 'optional_field_1';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 17: //optional field 2 asc
				$sort_txt = (in_array($this->fields->optional_field_2->field_type, array ('number','cost')))? '(`optional_field_2` * 1)': 'optional_field_2';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 18: //optional field 2 desc
				$sort_txt = (in_array($this->fields->optional_field_2->field_type, array ('number','cost')))? '(`optional_field_2` * 1)': 'optional_field_2';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 19: //optional field 3 asc
				$sort_txt = (in_array($this->fields->optional_field_3->field_type, array ('number','cost')))? '(`optional_field_3` * 1)': 'optional_field_3';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 20: //optional field 3 desc
				$sort_txt = (in_array($this->fields->optional_field_3->field_type, array ('number','cost')))? '(`optional_field_3` * 1)': 'optional_field_3';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 21: //optional field 4 asc
				$sort_txt = (in_array($this->fields->optional_field_4->field_type, array ('number','cost')))? '(`optional_field_4` * 1)': 'optional_field_4';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 22: //optional field 4 desc
				$sort_txt = (in_array($this->fields->optional_field_4->field_type, array ('number','cost')))? '(`optional_field_4` * 1)': 'optional_field_4';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 23: //optional field 5 asc
				$sort_txt = (in_array($this->fields->optional_field_5->field_type, array ('number','cost')))? '(`optional_field_5` * 1)': 'optional_field_5';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 24: //optional field 5 desc
				$sort_txt = (in_array($this->fields->optional_field_5->field_type, array ('number','cost')))? '(`optional_field_5` * 1)': 'optional_field_5';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 25: //optional field 6 asc
				$sort_txt = (in_array($this->fields->optional_field_6->field_type, array ('number','cost')))? '(`optional_field_6` * 1)': 'optional_field_6';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 26: //optional field 6 desc
				$sort_txt = (in_array($this->fields->optional_field_6->field_type, array ('number','cost')))? '(`optional_field_6` * 1)': 'optional_field_6';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 27: //optional field 7 asc
				$sort_txt = (in_array($this->fields->optional_field_7->field_type, array ('number','cost')))? '(`optional_field_7` * 1)': 'optional_field_7';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 28: //optional field 7 desc
				$sort_txt = (in_array($this->fields->optional_field_7->field_type, array ('number','cost')))? '(`optional_field_7` * 1)': 'optional_field_7';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 29: //optional field 8 asc
				$sort_txt = (in_array($this->fields->optional_field_8->field_type, array ('number','cost')))? '(`optional_field_8` * 1)': 'optional_field_8';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 30: //optional field 8 desc
				$sort_txt = (in_array($this->fields->optional_field_8->field_type, array ('number','cost')))? '(`optional_field_8` * 1)': 'optional_field_8';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 31: //optional field 9 asc
				$sort_txt = (in_array($this->fields->optional_field_9->field_type, array ('number','cost')))? '(`optional_field_9` * 1)': 'optional_field_9';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 32: //optional field 9 desc
				$sort_txt = (in_array($this->fields->optional_field_9->field_type, array ('number','cost')))? '(`optional_field_9` * 1)': 'optional_field_9';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 33: //optional field 10 asc
				$sort_txt = (in_array($this->fields->optional_field_10->field_type, array ('number','cost')))? '(`optional_field_10` * 1)': 'optional_field_10';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 34: //optional field 10 desc
				$sort_txt = (in_array($this->fields->optional_field_10->field_type, array ('number','cost')))? '(`optional_field_10` * 1)': 'optional_field_10';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 35: //city asc
				$order_by = " order by location_city asc, better_placement desc ";
				break;
			case 36: //city desc
				$order_by = " order by location_city desc, better_placement desc ";
				break;
			case 37: //state asc
				$order_by = " order by location_state asc, better_placement desc ";
				break;
			case 38: //state desc
				$order_by = " order by location_state desc, better_placement desc ";
				break;
			case 39: //country asc
				$order_by = " order by location_country asc, better_placement desc ";
				break;
			case 40: //country desc
				$order_by = " order by location_country desc, better_placement desc ";
				break;
			case 41: //zip asc
				$order_by = " order by location_zip asc, better_placement desc ";
				break;
			case 42: //zip desc
				$order_by = " order by location_zip desc, better_placement desc ";
				break;
			case 43: //business_type asc
				$order_by = " order by business_type asc, better_placement desc ";
				break;
			case 44: //business_type desc
				$order_by = " order by business_type desc, better_placement desc ";
				break;
			case 45: //optional field 11 asc
				$sort_txt = (in_array($this->fields->optional_field_11->field_type, array ('number','cost')))? '(`optional_field_11` * 1)': 'optional_field_11';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 46: //optional field 11 desc
				$sort_txt = (in_array($this->fields->optional_field_11->field_type, array ('number','cost')))? '(`optional_field_11` * 1)': 'optional_field_11';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 47: //optional field 12 asc
				$sort_txt = (in_array($this->fields->optional_field_12->field_type, array ('number','cost')))? '(`optional_field_12` * 1)': 'optional_field_12';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 48: //optional field 12 desc
				$sort_txt = (in_array($this->fields->optional_field_12->field_type, array ('number','cost')))? '(`optional_field_12` * 1)': 'optional_field_12';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 49: //optional field 13 asc
				$sort_txt = (in_array($this->fields->optional_field_13->field_type, array ('number','cost')))? '(`optional_field_13` * 1)': 'optional_field_13';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 50: //optional field 13 desc
				$sort_txt = (in_array($this->fields->optional_field_13->field_type, array ('number','cost')))? '(`optional_field_13` * 1)': 'optional_field_13';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 51: //optional field 14 asc
				$sort_txt = (in_array($this->fields->optional_field_14->field_type, array ('number','cost')))? '(`optional_field_14` * 1)': 'optional_field_14';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 52: //optional field 14 desc
				$sort_txt = (in_array($this->fields->optional_field_14->field_type, array ('number','cost')))? '(`optional_field_14` * 1)': 'optional_field_14';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 53: //optional field 15 asc
				$sort_txt = (in_array($this->fields->optional_field_15->field_type, array ('number','cost')))? '(`optional_field_15` * 1)': 'optional_field_15';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 54: //optional field 15 desc
				$sort_txt = (in_array($this->fields->optional_field_15->field_type, array ('number','cost')))? '(`optional_field_15` * 1)': 'optional_field_15';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 55: //optional field 16 asc
				$sort_txt = (in_array($this->fields->optional_field_16->field_type, array ('number','cost')))? '(`optional_field_16` * 1)': 'optional_field_16';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 56: //optional field 16 desc
				$sort_txt = (in_array($this->fields->optional_field_16->field_type, array ('number','cost')))? '(`optional_field_16` * 1)': 'optional_field_16';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 57: //optional field 17 asc
				$sort_txt = (in_array($this->fields->optional_field_17->field_type, array ('number','cost')))? '(`optional_field_17` * 1)': 'optional_field_17';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 58: //optional field 17 desc
				$sort_txt = (in_array($this->fields->optional_field_17->field_type, array ('number','cost')))? '(`optional_field_17` * 1)': 'optional_field_17';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 59: //optional field 18 asc
				$sort_txt = (in_array($this->fields->optional_field_18->field_type, array ('number','cost')))? '(`optional_field_18` * 1)': 'optional_field_18';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 60: //optional field 18 desc
				$sort_txt = (in_array($this->fields->optional_field_18->field_type, array ('number','cost')))? '(`optional_field_18` * 1)': 'optional_field_18';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 61: //optional field 19 asc
				$sort_txt = (in_array($this->fields->optional_field_19->field_type, array ('number','cost')))? '(`optional_field_19` * 1)': 'optional_field_19';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 62: //optional field 19 desc
				$sort_txt = (in_array($this->fields->optional_field_19->field_type, array ('number','cost')))? '(`optional_field_19` * 1)': 'optional_field_19';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 63: //optional field 20 asc
				$sort_txt = (in_array($this->fields->optional_field_20->field_type, array ('number','cost')))? '(`optional_field_20` * 1)': 'optional_field_20';
				$order_by = " order by {$sort_txt} asc, better_placement desc ";
				break;
			case 64: //optional field 20 desc
				$sort_txt = (in_array($this->fields->optional_field_20->field_type, array ('number','cost')))? '(`optional_field_20` * 1)': 'optional_field_20';
				$order_by = " order by {$sort_txt} desc, better_placement desc ";
				break;
			case 65: //classifids first
				$order_by = " order by item_type asc, better_placement desc ";
				break;
			case 66: //auctions first
				$order_by = " order by item_type desc, better_placement desc ";
				break;
			case 67: //end time desc
				$order_by = " order by ends desc, better_placement desc ";
				break;
			case 68: //end time asc
				$order_by = " order by ends asc, better_placement desc ";
				break;
			default:
				$order_by = " order by better_placement desc, date desc ";
				break;
		}
		return $order_by;
	}

//##################################################################################

	function like_clause($key,$value,$partial_word_match=1)
	{
		if ($partial_word_match) {
			//Word in middle of phrase
			$like_clause = " (".$key." like '%".urlencode($value)."%')";
		}
		else
		{
			//Word Matches Exactly
			$like_clause = "((".$key." like '".urlencode($value)."')";
			//Word at beginning of phrase
			$like_clause .= " OR (".$key." like '".urlencode($value)."+%')";
			//Word at end of phrase
			$like_clause .= " OR (".$key." like '%+".urlencode($value)."')";

			$like_clause .= ')';
		}
		if ($this->debug_search) echo $like_clause." is \$like_clause in like_clause function<br />\n";
		return $like_clause;
	}

//##################################################################################

} //end of class Search_classifieds

