{* $Rev: 20574 $ *}

{literal}
<script type="text/javascript">
//<![CDATA[
	var images = new Array;
	var galleryAddImage = function (id, url, thumb_url, height, width, alt, is_icon) {
		this.id = id;
		this.src = url;
		this.height = height;
		this.width = width;
		this.alt = alt;
		this.title = alt;
		this.low_src = thumb_url;
		this.img_pos = images.length;
		this.is_icon = is_icon;
		if (height > geoFilmstrip.maxHeight) {
			geoFilmstrip.maxHeight = height;
		}
	};

	var geoFilmstrip = {
		maxHeight : 0,
		innerWidth : 0,

		//Change this to the amount of width buffer each small image will have..
		//defaults : 5 (left padding) + 1 (give little extra room) = 6 
		elementWidthBuffer : 6,
		
		//change this if needed
		filmstripBorder : 3,
		
		rightOffsetMax : 0,
		currentOffset : 0,
		offsetBuffer : 0,
		scrollingEffect : null,
		messages : {
			image: '{/literal}{$messages.500881|escape_js}{literal}',
			of: '{/literal}{$messages.500882|escape_js}{literal}'
		},
		
		init : function () {
			var parentElem = $('filmstrip_strip_container');
			$$('div.filmstrip_entry').each (function (element){
				//add up inner widths
				geoFilmstrip.innerWidth += element.getDimensions().width + geoFilmstrip.elementWidthBuffer;
				//now add a click observer
				element.observe('click', geoFilmstrip.smallClicked);
			});

			//set the height of the main window so it doesn't change
			if (geoFilmstrip.maxHeight) {
				//get the height buffer, account for extra borders and padding and such
				var heightBuffer = $('filmstrip_main').getDimensions().height - images[0].height - $('imageTitle').getDimensions().height;
				$('filmstrip_main').setStyle({height : (geoFilmstrip.maxHeight+$('imageTitle').getDimensions().height+heightBuffer)+'px'});
			}
			var leftWidth = $('filmstripLeftScrollButton').getDimensions().width;
			var rightWidth = $('filmstripRightScrollButton').getDimensions().width;
			var mainWidth = $('filmstrip_main').getDimensions().width;
			
			//adjust size for strip so account for size of buttons
			$('filmstrip_strip_container').setStyle({width : (mainWidth-leftWidth-rightWidth-6) + 'px', height: $('filmstrip_strip_inner').getDimensions().height+'px'});
			$$('div.filmstrip_entry').each (function (element) {
				//vertically align
				geoFilmstrip.vAlign(parentElem, element, 0);
			});
			//if inner width is less than outer width, make inner width as wide as (but not larger than) outer width.
			if (geoFilmstrip.innerWidth < mainWidth) geoFilmstrip.innerWidth = mainWidth-leftWidth-rightWidth-6;
			
			//set inner width so it doesn't newline
			$('filmstrip_strip_inner').setStyle({width : geoFilmstrip.innerWidth+'px'});
			$('filmstrip_container').setStyle({width : (mainWidth)+'px'});
			
			//make buttons vertical aligned with filmstrip thingy
			geoFilmstrip.vAlign('filmstrip_strip_container', 'filmstripLeftScrollButton', 0);
			geoFilmstrip.vAlign('filmstrip_strip_container', 'filmstripRightScrollButton', 0);
			
			//figure out right offset max
			geoFilmstrip.rightOffsetMax = geoFilmstrip.innerWidth - $('filmstrip_strip_container').getDimensions().width;
			//find adjustment for offset
			geoFilmstrip.offsetBuffer = $('filmstrip_strip_container').cumulativeOffset().left - $('filmstrip_strip_inner').cumulativeOffset().left;
			
			$('filmstripLeftScrollButton').observe('mouseover', geoFilmstrip.leftScroll)
				.observe('mouseout', geoFilmstrip.stopScroll);
			$('filmstripRightScrollButton').observe('mouseover', geoFilmstrip.rightScroll)
				.observe('mouseout', geoFilmstrip.stopScroll);
			
			geoFilmstrip.updateScrollButtons();
			
			geoFilmstrip.makeImgActive('0');
			//un-do float left so that it is able to be centered...  we only needed
			//it to be floated to left in IE7 (since inline-block doesn't work properly)
			//so that it's width would reflect contents width
			$('filmstrip_main').setStyle({'float': 'none'});
		},
		updateScrollButtons : function () {
			//left scroll button
			if (geoFilmstrip.currentOffset == 0) {
				//hide it
				$('filmstripLeftScrollButton').setOpacity(0.2)
					.setStyle({cursor: 'default'})
					.addClassName('no_hover');
			} else {
				//show it
				$('filmstripLeftScrollButton').setOpacity(1.0)
					.setStyle({cursor: 'pointer'})
					.removeClassName('no_hover');
			}
			
			//right scroll button
			if (geoFilmstrip.currentOffset >= geoFilmstrip.rightOffsetMax) {
				//hide it
				$('filmstripRightScrollButton').setOpacity(0.2)
					.setStyle({cursor: 'default'})
					.addClassName('no_hover');
			} else {
				//show it
				$('filmstripRightScrollButton').setOpacity(1.0)
					.setStyle({cursor: 'pointer'})
					.removeClassName('no_hover');
			}
			
		},
		getScrollDuration : function (distanceToMove) {
			//make it go 1 filmstrip width per second
			//NOTE:  You can make this go faster or slower, in custom js file just set geoFilmstrip.getScrollDuration
			//to a new function, and do your own calculations in that custom function.
			var width = $('filmstrip_strip_container').getDimensions().width;
			
			//calculate duration, want to go 1 filmstrip width in one second
			return distanceToMove/width;
		},
		stopScroll : function () {
			if (geoFilmstrip.scrollingEffect == null) {
				//not moving currently
				return;
			}
			geoFilmstrip.scrollingEffect.cancel();
			geoFilmstrip.scrollingEffect = null;
			
			//now then figure out where we are
			
			var offset = $('filmstrip_strip_container').cumulativeOffset().left - $('filmstrip_strip_inner').cumulativeOffset().left - geoFilmstrip.offsetBuffer;
			//alert('offset: '+offset+' - max: '+geoFilmstrip.rightOffsetMax);
			
			geoFilmstrip.currentOffset = offset;
			geoFilmstrip.updateScrollButtons();
		},
		rightScroll : function () {
			if (geoFilmstrip.scrollingEffect !== null) {
				//already moving
				return;
			}
			if (geoFilmstrip.currentOffset >= geoFilmstrip.rightOffsetMax) {
				//cannot scroll further
				return;
			}
			
			//calculate full distance to travel for scrolling
			var fullDistance = geoFilmstrip.rightOffsetMax-geoFilmstrip.currentOffset;
			
			geoFilmstrip.scrollingEffect = new Effect.Move($('filmstrip_strip_inner'), { 
				x: (geoFilmstrip.rightOffsetMax * -1),
				y: 0,
				mode: 'absolute',
				duration: geoFilmstrip.getScrollDuration(fullDistance),
				afterFinish : function () {geoFilmstrip.stopScroll();}
			});
			//make it look like it moved one px to right, and update buttons based on that
			geoFilmstrip.currentOffset++;
			geoFilmstrip.updateScrollButtons();
		},
		leftScroll : function () {
			if (geoFilmstrip.scrollingEffect !== null) {
				//already moving
				return;
			}
			if (geoFilmstrip.currentOffset <= 0) {
				//cannot scroll further
				return;
			}
			
			//calculate full distance to travel for scrolling
			var fullDistance = geoFilmstrip.currentOffset;
			
			geoFilmstrip.scrollingEffect = new Effect.Move($('filmstrip_strip_inner'), { 
				x: 0,
				y: 0,
				mode: 'absolute',
				duration: geoFilmstrip.getScrollDuration(fullDistance),
				afterFinish : function () {geoFilmstrip.stopScroll();}
			});
			//make it look like it moved one px to left, and update buttons based on that
			geoFilmstrip.currentOffset--;
			geoFilmstrip.updateScrollButtons();
		},
		smallClicked : function (action) {
			//stop the action
			action.stop();
			
			//figure out position
			var position = this.identify().replace('filmstripEntry_','');
			
			geoFilmstrip.makeImgActive(position);
		},

		makeImgActive : function (position) {
			//build the new big image
			if (images[position].is_icon) {
				var new_a = new Element('a', {
					href : images[position].src
				});
			} else {
				var new_a = new Element('a', {
					href : "get_image.php?id=" + images[position].id,
					'class' : 'lightUpLink'
				});
			}

			var image = new Element ('img', {
				src : (images[position].low_src && images[position].low_src.length > 1) ? images[position].low_src : images[position].src,
				alt : images[position].alt,
				title : images[position].title
			}).setStyle ({
				width: images[position].width+'px',
				height: images[position].height+'px'
			});
			
			//make it centered
			
			if (geoFilmstrip.maxHeight > images[position].height && false) {
				//set manually, not with vAlign method, that method requires outer element
				var topD = Math.floor((geoFilmstrip.maxHeight-images[position].height)/3);
				image.setStyle ({
					marginTop : topD+'px'
				});
			}
			
			new_a.update( image );
			$('filmstrip_main_img').update(new_a);

			if (images[position].is_icon) {
				new_a.observe ('click', function (action) {
					if (!this.href.startsWith('http')) {
						//Stupid work-around for ie7, where this.href doesn't behave.
						return;
					}
					window.open(this.href);
					action.stop();
				});
			} else {
				lightUpBox.addLinkObserver(new_a);
			}
			if ($('imageTitle')) {
				var imageCount = '';
				if (geoFilmstrip.messages.image!=''||geoFilmstrip.messages.of!='') {
					imageCount = '<br />'+geoFilmstrip.messages.image+' '+(1+position*1)+' '
						+geoFilmstrip.messages.of+' '+images.length;
				}
				
				$('imageTitle').update(images[position].title+'&nbsp;'+imageCount);
			}
			
			return false;
		},

		vAlign : function (outer, inner, outerHPad) {
			var outerH = $(outer).getDimensions().height - outerHPad;
			var innerH = $(inner).getDimensions().height;
			if (outerH > innerH) {
				var topD = Math.floor((outerH-innerH)/2);
				$(inner).setStyle ({
					marginTop : topD+'px'
				});
			}
		}
	};

	Event.observe(window, 'load', geoFilmstrip.init);
	
//]]>
</script>
{/literal}
<div class="filmstrip_outer">
	<div id="filmstrip_container">
		<div id="filmstrip_main">
			<div id="filmstrip_main_img">{$bigImage.tag}</div>
			<p id="imageTitle">{$bigImage.title}&nbsp;<br />{$messages.500881} 1 {$messages.500882} {$images|@count}</p>
		</div>
		<div class="clr"><br /></div>
		<div id="filmstripLeftScrollButton"></div>
		<div id="filmstripRightScrollButton"></div>
		<div id="filmstrip_strip_container">
			<div class="filmstrip_strip" id="filmstrip_strip_inner">
				{foreach from=$images item=image}
					<div class="filmstrip_entry" id="filmstripEntry_{$image.count}">
						{$image.tag}
					</div>
				{/foreach}
				<div class="clr"></div>
			</div>
		</div>
		
	</div>
</div>