{* $Rev: 20911 $ *}

{include file="cart_steps.tpl" g_resource="cart"}

<script type="text/javascript">
	//<![CDATA[
	geoListing.inAdmin={if $in_admin}true{else}false{/if};
	//]]>
</script>

<form action="{$form_url}" method="post">
	<div class="content_box">
		<h1 class="title">{$txt1}</h1>
		<h1 class="subtitle">{$title1}</h1>
		<p class="page_instructions">{$desc1}</p>
		
		{if $error_msgs.cart_error}
			<div class="field_error_box">
				{$error_msgs.cart_error}
			</div>
		{/if}
		
		<div class="note_box">
			<strong>
				{$txt2} {$txt3}
				{if is_array($category_tree)}
					{foreach from=$category_tree item="cat" name="cat_tree"}
						&gt; {$cat.category_name}
					{/foreach}
				{elseif $category_tree}
					&gt; {$category_tree}
				{/if}
			</strong>
		</div>
		
		<div class="{cycle values='row_odd,row_even'}">
			{if $sell_type == 1 && $editCheck}
				<label for="classified_length" class="field_label">
					{$messages.125}<br />{$messages.126}
				</label>
				<select class="field" id="classified_length" name="b[classified_length]">
					{$duration_dropdown}
				</select>
			{/if}
		</div>
		{if $fields->title->is_enabled}
			<div class="{if $error_msgs.classified_title}field_error_row {/if}{cycle values='row_odd,row_even'}">
				{if $use_auto_title}
					<input type="hidden" id="classified_title" name="b[classified_title]" value="{$messages.500110}" />
				{else}
					<label for="classified_title" class="field_label">{$messages.123}</label>
					
					{if !$editCheck && !$fields->title->can_edit}
						{$session_variables.classified_title}
					{elseif !$use_textarea_in_title}
						<input type="text" id="classified_title" class="field" name="b[classified_title]"
							value="{$session_variables.classified_title}" size="{if $fields->title->text_length > 50}50{else}{$fields->title->text_length}{/if}"
							maxlength="{$fields->title->text_length}" />
					{else}
						<textarea id="classified_title" class="field" name="b[classified_title]" rows="1"
							cols="{if $fields->title->text_length > 50}50{else}{$fields->title->text_length}{/if}">{$session_variables.classified_title}</textarea>
					{/if}
					
					{if $error_msgs.classified_title}
						<span class="error_message">{$messages.116}</span>
					{/if}
				{/if}
			</div>
		{/if}
		
		{if !$display_description_last_in_form && ($editCheck || $fields->description->can_edit)}
			{include file="shared/details_description_box.tpl"}
		{/if}
		{if $fields->tags->is_enabled}
			<div class="{if $error_msgs.tags}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="classified_title" class="field_label">{$messages.500863}</label>
				
				{if !$editCheck && !$fields->tags->can_edit}
					{$session_variables.tags}
				{else}
					<input type="text" class="field" name="b[tags]" id="listingTags" value="{$session_variables.tags|escape}" size="50" />
					<div id="listingTags_choices" class="autocomplete_choices"></div>
				{/if}
				{$tags_help_link}
				{if $error_msgs.tags}
					<span class="error_message">{$messages.500865}</span>
				{/if}
			</div>
		{/if}
		{if $moreDetails}
			{foreach from=$moreDetails item='details'}
				{if $details.section_head}
					{* Allow adding a section head above the next contents *}
					{* Close the <div class="content_box"> and re-open it *}</div><br />
					<div class="content_box">
						{* TODO: Add way to add main title vs. sub-title! *}
						<h1 class="title">{$details.section_head}</h1>
					{* </div> is at bottom of the section. *}
				{/if}
				{if $details.section_desc}
					{* Allow adding a section description as well *}
					<p class="page_instructions">{$details.section_desc}</p>
				{/if}
				{if $details.full}
					{$details.full}
				{elseif $details.pre || $details.label || $details.value || $details.error}
					<div class="{if $details.error}field_error_row {/if}{cycle values='row_odd,row_even'}">
						<label class="field_label">{if $details.pre}{$details.pre}{/if} {$details.label}</label>
						{$details.value}
						{if $details.error}
							<span class="error_message">{$details.error}</span>
						{/if}
					</div>
				{/if}
			{/foreach}
		{/if}
		
		{if $sell_type == 1 && $fields->price->is_enabled}
			<div class="{if $error_msgs.price}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="price" class="field_label">{$messages.134}</label>
				
				{if $editCheck || $fields->price->can_edit}
					<span class="precurrency">{$session_variables.precurrency}</span>
					<input type="text" id="price" class="field" name="b[price]"
						size="{if $fields->price->text_length > 12}12{else}{$fields->price->text_length}{/if}"
						maxlength="{$fields->price->text_length}"
						value="{$session_variables.price|displayPrice:"":""}" />
					{include file="shared/postcurrency_dropdown.tpl"}
				{else}
					{$session_variables.price|displayPrice:$session_variables.precurrency:$session_variables.postcurrency}
				{/if}
				
				{if $error_msgs.price}
					<span class="error_message">{$messages.642}</span>
				{/if}
			</div>
		{/if}
		
		{if (($sell_type == 2 || $sell_type == 4) && $editAuctionPrices)}
			<div class="{if $error_msgs.auction_type}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="auction_type" class="field_label">{$messages.102689}</label>
			
				{if ($editCheck && $sell_type == 2)}
					{if $field_config.allow_standard && $field_config.allow_dutch && !$pricePlan.buy_now_only}
						<select id="auction_type" onchange='geoListing.check_buy_now_only();' class="field" name="b[auction_type]">
							<option value="1"{if $session_variables.auction_type == 1} selected="selected"{/if}>{$messages.102837}</option>
							<option value="2"{if $session_variables.auction_type == 2} selected="selected"{/if}>{$messages.102838}</option>
						</select>
					{elseif $field_config.allow_standard && ($pricePlan.buy_now_only || !$field_config.allow_dutch)}
						<input id="auction_type" type="hidden" class="field" name="b[auction_type]" value="1" />{$messages.102837}
					{elseif $field_config.allow_dutch}
						<input id="auction_type" type="hidden" class="field" name="b[auction_type]" value="2" />{$messages.102838}
					{else}
						<select id="auction_type" onchange='geoListing.check_buy_now_only();' class="field" name="b[auction_type]">
							<option value="1"{if $session_variables.auction_type == 1} selected="selected"{/if}>{$messages.102837}</option>
							{if $field_config.allow_dutch}
								<option value="2"{if $session_variables.auction_type == 2} selected="selected"{/if}>{$messages.102838}</option>
							{/if}
						</select>
					{/if}
					{$auction_type_help_link}
				{else}
					{if $session_variables.auction_type == 2}
						{$messages.102838}
					{else}
						{$messages.102837}
					{/if}
				{/if}
			
				{if $error_msgs.auction_type}
					<span class="error_message">{$error_msgs.auction_type}</span>
				{/if}
			</div>
			
			<div class="{if $error_msgs.auction_quantity}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="auction_quantity" class="field_label">{$messages.102690}</label>
				
				{if $editCheck || $fields->price->can_edit}
					<input type="text" id="auction_quantity" name="b[auction_quantity]" value="{if $session_variables.auction_quantity <= 0}1{else}{$session_variables.auction_quantity}{/if}" class="field" />
				{else}
					{if $session_variables.auction_quantity <= 0}1{else}{$session_variables.auction_quantity}{/if}
				{/if}
				
				{if $error_msgs.auction_quantity}
					<span class="error_message">{$messages.500217}</span>
				{/if}
			</div>	
			
			{if $field_config.user_set_auction_start_times && $editCheck}
				<div class="{if $error_msgs.start_time}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label class="field_label">{$messages.102816}</label>
					{$date_select_start_time}
					{if $error_msgs.start_time}
						<span class="error_message">{$messages.103356}</span>
					{/if}
				</div>
			{/if}
			
			{if $field_config.user_set_auction_end_times && $pricePlan.charge_per_ad_type != 2 && $editCheck}
				<div class="{if $error_msgs.end_time}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label class="field_label">{$messages.102820}</label>
					<input type="radio" id="endTimeRadio" value="1" name="b[end_mode]"{if $session_variables.end_mode == 1} checked="checked"{/if} onclick="SetEndMode(1);" />
					{$date_select_end_time}
					{if $error_msgs.end_time}
						<span class="error_message">{$messages.103357}</span>
					{/if}
				</div>
			{/if}
			{if $editCheck}
				<div class="{if $error_msgs.duration||$error_msgs.classified_length}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label class="field_label">{$messages.125}<br />{$messages.100126}</label>
					{if $field_config.user_set_auction_end_times && $pricePlan.charge_per_ad_type != 2}
						<input type="radio" id="durationRadio" value="2" name="b[end_mode]"{if $session_variables.end_mode != 1} checked="checked"{/if} onclick="SetEndMode(2);" />
					{/if}
					<select class="field" id="classified_length" name="b[classified_length]">
						{$auction_duration_dropdown}
					</select>
					{if $field_config.user_set_auction_end_times && $pricePlan.charge_per_ad_type != 2}
									
						<script type="text/javascript">
							//TODO: Move this function to a JS file or something, and
							//only leave the SetEndMode call, as that part is dynamic.
							function SetEndMode(mode)
							{ldelim}
								if(mode == 1) {ldelim}
									document.getElementById('classified_length').disabled = true;
									document.getElementById('endtime_month').disabled = false;
									document.getElementById('endtime_day').disabled = false;
									document.getElementById('endtime_year').disabled = false;
									document.getElementById('endtime_hour').disabled = false;
									document.getElementById('endtime_minute').disabled = false;
								} else if (mode == 2) {ldelim}
									document.getElementById('classified_length').disabled = false;
									document.getElementById('endtime_month').disabled = true;
									document.getElementById('endtime_day').disabled = true;
									document.getElementById('endtime_year').disabled = true;
									document.getElementById('endtime_hour').disabled = true;
									document.getElementById('endtime_minute').disabled = true;
								}
							}
							SetEndMode({if $session_variables.end_mode}{$session_variables.end_mode}{else}2{/if});
						</script>
					{/if}
					{if $error_msgs.duration || $error_msgs.classified_length}
							<span class="error_message">{$messages.103358}</span>
					{/if}
				</div>
			{/if}
			
			{if $editCheck || $fields->price->can_edit}
				<div class="{cycle values='row_odd,row_even'}">
					<label class="field_label">{$messages.100134}</label>
					{include file="shared/postcurrency_dropdown.tpl"}
				</div>
			{/if}
		
			{if !$pricePlan.buy_now_only}
				<div class="{if $error_msgs.auction_minimum}field_error_row {/if}{cycle values='row_odd,row_even'}"{if $bno} style="display:none;"{/if} id="min_row">
					<label for="minimum" class="field_label">{$messages.102691}</label>
					<span class="main_text precurrency">{$session_variables.precurrency}</span>
					{if $editCheck || $fields->price->can_edit}
						<input type="text" id="minimum" class="field" name="b[auction_minimum]"
							value='{if !$bno}{$session_variables.auction_minimum|displayPrice:"":""}{/if}'
							{if $fields->price->text_length}maxlength='{$fields->price->text_length}'{/if} />
					{elseif !$bno}
						{$session_variables.auction_minimum|displayPrice:"":""}
					{/if}
					
					{if $error_msgs.auction_minimum}
						<span class="error_message">{$error_msgs.auction_minimum}</span>
					{/if}
				</div>
		
				<div class="{if $error_msgs.auction_reserve}field_error_row {/if}{cycle values='row_odd,row_even'}" id="res_row"{if $bno} style="display:none;"{/if}>
					<label for="reserve" class="field_label">{$messages.102692}</label>
					<span class="main_text precurrency">{$session_variables.precurrency}</span>
					{if $editCheck || $fields->price->can_edit}
						<input type="text" id="reserve" class="field" name="b[auction_reserve]"
							value="{if !$bno}{$session_variables.auction_reserve|displayPrice:'':''}{/if}"
							{if $fields->price->text_length}maxlength="{$fields->price->text_length}"{/if} />
					{elseif !$bno}
						{$session_variables.auction_reserve|displayPrice:"":""}
					{/if}
					{if $error_msgs.auction_reserve}
						<span class="error_message">{$messages.102731}</span>
					{/if}
				</div>
			{/if}
			{if $allow_buy_now}
				<div class="{if $error_msgs.auction_buy_now}field_error_row {/if}{cycle values='row_odd,row_even'}"
					id="buy_now_only_row"{if $is_dutch} style="display:none;"{/if}>
					
					<label for="auction_buy_now" class="field_label">{$messages.102693}</label>
					<span class="main_text precurrency">{$session_variables.precurrency}</span>
					
					{if $editCheck || $fields->price->can_edit}
						<input type="text" class="field" id="auction_buy_now" name="b[auction_buy_now]" value='{$session_variables.auction_buy_now|displayPrice:"":""}' {if $fields->price->text_length}maxlength='{$fields->price->text_length}'{/if} />
						<input type="hidden" name="b[bno_submitted]" value="1" />
					{else}
						{$session_variables.auction_buy_now|displayPrice:"":""}
					{/if}
			
					{if $is_ent && $allow_buy_now_only}
						{if $pricePlan.buy_now_only}
							<input type="hidden" name="b[buy_now_only]" value="1" />
						{elseif !$editCheck && !$fields->price->can_edit}
							<input type="hidden" name="b[buy_now_only]" value="{if $bno || $session_variables.buy_now_only}1{else}0{/if}" />
						{else}
							<label><input id="buy_now_only" type="checkbox" onclick='geoListing.check_buy_now_only();'
							name="b[buy_now_only]" {if $bno || $session_variables.buy_now_only}checked="checked" {/if}/>
							&nbsp;{$messages.500029}</label>
						{/if}
					{/if}
					
					{if $error_msgs.auction_buy_now}
						<span class="error_message">
							{if !$pricePlan.buy_now_only && !$session_variables.buy_now_only}
								{$messages.102732}
							{else}
								{$messages.103373}
							{/if}
						</span>
					{/if}
				</div>
			{/if}
		{/if}
		{if $is_ent && $add_cost_at_top}
			{foreach from=$opt_field_info item='opt_info' key='i'}
				{if $opt_info.field->field_type=='cost'}
					<div class="{if $opt_info.error}field_error_row {/if}{cycle values='row_odd,row_even'}">
						<label class="field_label">{$opt_info.label}</label>
						<span class="precurrency">{$precurrency}</span>
						{if $editCheck || $opt_info.field->can_edit}
							<input type="text" name="b[optional_field_{$i}]" id="optional_field_{$i}"
								size="{if $opt_info.field->text_length>12}12{else}{$opt_info.field->text_length}{/if}"
								maxlength="{$opt_info.field->text_length}" class="field"
								value="{$opt_info.value|displayPrice:'':''}" />
						{else}
							{$opt_info.value|displayPrice:'':''}
						{/if}
						{if $opt_info.error}
							<span class="error_message">{$opt_info.error}</span>
						{/if}
					</div>
				{/if}
			{/foreach}
		{/if}
		{if $on_site_html}
			<div class="{cycle values='row_odd,row_even'} highlight_links">
				<label class="field_label">{$messages.500208}</label>
				{$on_site_html}
			</div>
		{/if}
		
		{if $fields->payment_types->is_enabled}
			<div class="{if $error_msgs.payment_options}field_error_row {/if}{cycle values='row_odd,row_even'}">
				
				<label class="field_label" style="width: 400px;">{$messages.102850}<br /><span class="mini_note">{$messages.102867}</span></label>
				
				<ul class="payment_options_list inline">
					{foreach from=$payment_options item="show_payment" key="key" name="payment_type_loop"}
						<li>
							<label>
								<input type="checkbox" name="b[payment_options_from_form][]" value="{$show_payment.type_name}"
								{if in_array($show_payment.type_name, $session_variables.payment_options)}checked="checked"{/if} />
								{$show_payment.type_name}
							</label>
						</li>
					{foreachelse}
						<li>No Choices to Display</li>
					{/foreach}
				</ul>
				
				{if $error_msgs.payment_options}
					<span class="error_message">{$messages.102851}</span>
				{/if}
			</div>
		{/if}
		
		{if $field_config.use_buy_now}
			<div class="{if $error_msgs.paypal_id}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="paypal_id" class="field_label">{$messages.3279}</label>
				<span class="sub_note">{$messages.3280}</span>
				{if $editCheck || $field_config.editable_buy_now}
					<input type="text" class="field" id="paypal_id" name="b[paypal_id]" value='{$session_variables.paypal_id}' />
				{else}
					{$session_variables.paypal_id}
				{/if}
			
				{if $error_msgs.paypal_id}
					<span class="error_message">{$messages.3281}</span>
				{/if}
			</div>
		{/if}
		
	</div>
	<br />
	
	<div class="content_box">
		<h2 class="title">{$messages.500804}</h2>
		
		{if $fields->email->is_enabled}
			<div class="{if $error_msgs.email_option}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="email_option" class="field_label">{$messages.1339}</label>
		
				{if $fields->email->can_edit || $editCheck}
					<input type="text" id="email_option" name="b[email_option]" value="{if $session_variables.email_option}{$session_variables.email_option}{else}{$user_data.email}{/if}"
						class="field" />
				{else}
					{$session_variables.email_option}
					<input type="hidden" name="b[email_option]" value="{$session_variables.email_option}" />
				{/if}
				{if count($fields->email->display_locations)>0}
					{$messages.1340}
					<label>{$messages.1341} <input type="radio" name="b[expose_email]" value="1"{if $session_variables.expose_email == 1} checked="checked"{/if} /></label>
					<label>{$messages.1342} <input type="radio" name="b[expose_email]" value="0"{if $session_variables.expose_email != 1} checked="checked"{/if} /></label>
				{/if}
				{if $error_msgs.email_option}
					<span class="error_message">{$messages.1343}</span>
				{/if}
			</div>
		{else}
			<input type="hidden" name="b[email_option]" value="{$session_variables.email_option}" />
		{/if}
		
		{if $fields->phone_1->is_enabled}
			<div class="{if $error_msgs.phone_1_option}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="phone_1_option" class="field_label">{$messages.1345}</label>
				{if $editCheck || $fields->phone_1->can_edit}
					<input type="text" id="phone_1_option" name="b[phone_1_option]" value="{$session_variables.phone_1_option}"
						size="{if $fields->phone_1->text_length > 18}18{else}{$fields->phone_1->text_length}{/if}"
						maxlength="{$fields->phone_1->text_length}" class="field" />
				{else}
					{$session_variables.phone_1_option}
					<input type="hidden" name="b[phone_1_option]" value="{$session_variables.phone_1_option}" />
				{/if}
			
				{if $error_msgs.phone_1_option}
					<span class="error_message">{$messages.500097}</span>
				{/if}
			</div>
		{/if}
		
		{if $fields->phone_2->is_enabled}
			<div class="{if $error_msgs.phone_2_option}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="phone_2_option" class="field_label">{$messages.1346}</label>
			
				{if $editCheck || $fields->phone_2->can_edit}
					<input type="text" id="phone_2_option" name="b[phone_2_option]" value="{$session_variables.phone_2_option}"
						size="{if $fields->phone_2->text_length > 18}18{else}{$fields->phone_2->text_length}{/if}"
						maxlength="{$fields->phone_2->text_length}" class="field" />
				{else}
					{$session_variables.phone_2_option}
					<input type="hidden" name="b[phone_2_option]" value="{$session_variables.phone_2_option}" />
				{/if}
			
				{if $error_msgs.phone_2_option}
					<span class="error_message">{$messages.500098}</span>
				{/if}
			</div>
		{/if}
		
		{if $fields->fax->is_enabled}
			<div class="{if $error_msgs.fax_option}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="fax_option" class="field_label">{$messages.1355}</label>
			
				{if $editCheck || $fields->fax->can_edit}
					<input type="text" id="fax_option" name="b[fax_option]" value="{$session_variables.fax_option}"
						size="{if $fields->fax->text_length > 18}18{else}{$fields->fax->text_length}{/if}"
						maxlength="{$fields->fax->text_length}" class="field" />
				{else}
					{$session_variables.fax_option}
					<input type="hidden" name="b[fax_option]" value="{$session_variables.fax_option}" />
				{/if}
			
				{if $error_msgs.fax_option}
					<span class="error_message">{$messages.500099}</span>
				{/if}
			</div>
		{/if}
		
		{if $fields->address->is_enabled && ($editCheck || $fields->address->can_edit)}
			<div class="{if $error_msgs.address}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="address" class="field_label">{$messages.500161}</label>
			
				{if $error_msgs.address}
					<span class="error_message">{$messages.500162}</span>
				{/if}
			
				<input type="text" id="address" name="b[address]" size="{if $fields->address->text_length > 20}20{else}{$fields->address->text_length}{/if}"
					maxlength="{$fields->address->text_length}"
					value="{$session_variables.address}" class="field" />
			</div>
		{/if}
		
		{if $fields->city->is_enabled && ($editCheck || $fields->city->can_edit)}
			<div class="{if $error_msgs.city}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="city" class="field_label">{$messages.1129}</label>
				{if $error_msgs.city}
					<span class="error_message">{$messages.1130}</span>
				{/if}
			
				{if $editCheck || $fields->city->can_edit}
					<input type="text" id="city" name="b[city]" size="{if $fields->city->text_length > 20}20{else}{$fields->city->text_length}{/if}"
						maxlength="{$fields->city->text_length}"
						value="{$session_variables.city}" class="field" />
				{else}
					{$session_variables.city}
				{/if}
			</div>
		{/if}
		
		
		{capture name="country_field" assign="country_field"}
			{if $fields->country->is_enabled && ($editCheck || $fields->country->can_edit)}
				<div class="{if $error_msgs.country}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label for="country" class="field_label">{$messages.115}</label>
					{if $error_msgs.country}
						<span class="error_message">{$messages.128}</span>
					{/if}
					{$country_html}
				</div>
			{/if}
		{/capture}
		
		{if $country_field_isFancy}
			{$country_field}
		{/if}
		
		{if $fields->state->is_enabled && ($editCheck || $fields->state->can_edit)}
			<div class="{if $error_msgs.state}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="state" class="field_label">{$messages.127}</label>
				{if $error_msgs.state}
					<span class="error_message">{$messages.117}</span>
				{/if}
				{$state_html}
			</div>
		{/if}
		
		{if $fields->zip->is_enabled}
			<div class="{if $error_msgs.zip_code}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="zip_code" class="field_label">{$messages.121}</label>
				{if $error_msgs.zip_code}
					<span class="error_message">{$messages.118}</span>
				{/if}
				{if $messages.119}
					{$messages.119}
				{/if}
			
				{if $editCheck || $fields->zip->can_edit}
					<input type="text" id="zip_code" name="b[zip_code]" value="{$session_variables.zip_code}"
						size="{if $fields->zip->text_length > 10}10{else}{$fields->zip->text_length}{/if}"
						maxlength="{$fields->zip->text_length}" class="field" />
				{else}
					{$session_variables.zip_code}
				{/if}
			</div>
		{/if}
		
		{if !$country_field_isFancy}
			{$country_field}
		{/if}
	</div>
	<br />

{* capture this next bit into a smarty variable, so that it can be not shown if there's nothing to show *}
	{capture assign=additionalInfo}
		{if $fields->url_link_1->is_enabled}
			<div class="{if $error_msgs.url_link_1}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="url_link_1" class="field_label">{$messages.2434}</label>
			
				{if $editCheck || $fields->url_link_1->can_edit}
					<input type="text" id="url_link_1" name="b[url_link_1]" 
						size="{if $fields->url_link_1->text_length > 30}30{else}{$fields->url_link_1->text_length}{/if}"
						maxlength="{$fields->url_link_1->text_length}"
						value="{$session_variables.url_link_1}" class="field" />
				{else}
					{$session_variables.url_link_1}
				{/if}
			
				{if $error_msgs.url_link_1}
					<span class="error_message">{$messages.2437}</span>
				{/if}
			</div>
		{/if}
		
		{if $fields->url_link_2->is_enabled}
			<div class="{if $error_msgs.url_link_2}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="url_link_2" class="field_label">{$messages.2435}</label>
			
				{if $editCheck || $fields->url_link_2->can_edit}
					<input type="text" id="url_link_2" name="b[url_link_2]" 
						size="{if $fields->url_link_2->text_length > 30}30{else}{$fields->url_link_2->text_length}{/if}"
						maxlength="{$fields->url_link_2->text_length}"
						value="{$session_variables.url_link_2}" class="field" />
				{else}
					{$session_variables.url_link_2}
				{/if}
			
				{if $error_msgs.url_link_2}
					<span class="error_message">{$messages.2438}</span>
				{/if}
			</div>
		{/if}
		
		{if $fields->url_link_3->is_enabled}
			<div class="{if $error_msgs.url_link_3}field_error_row {/if}{cycle values='row_odd,row_even'}">
				<label for="url_link_3" class="field_label">{$messages.2436}</label>
			
				{if $editCheck || $fields->url_link_3->can_edit}
					<input type="text" id="url_link_3" name="b[url_link_3]" 
						size="{if $fields->url_link_3->text_length > 30}30{else}{$fields->url_link_3->text_length}{/if}"
						maxlength="{$fields->url_link_3->text_length}"
						value="{$session_variables.url_link_3}" class="field" />
				{else}
					{$session_variables.url_link_3}
				{/if}
			
				{if $error_msgs.url_link_3}
					<span class="error_message">{$messages.2439}</span>
				{/if}
			</div>
		{/if}
		
		
		{if $is_ent}
			{foreach from=$opt_field_info item=opt_info key=i}
				{if $opt_info.field->field_type=='cost'}
					{if !$add_cost_at_top}
						{* Adds cost, and does not have set to display cost 
							optional fields at "top" of page (below normal price fields) *}
						<div class="{if $opt_info.error}field_error_row {/if}{cycle values='row_odd,row_even'}">
							<label for="optional_field_{$i}" class="field_label">{$opt_info.label}</label>
								
							<span class="precurrency">{$precurrency}</span>
							{if $editCheck || $opt_info.field->can_edit}
								<input type="text" name="b[optional_field_{$i}]" id="optional_field_{$i}"
									size="{if $opt_info.field->text_length>12}12{else}{$opt_info.field->text_length}{/if}"
									maxlength="{$opt_info.field->text_length}" class="field"
									value="{$opt_info.value|displayPrice:'':''}" />
							{else}
								{$opt_info.value|displayPrice:'':''}
							{/if}
							{if $opt_info.error}
								<span class="error_message">{$opt_info.error}</span>
							{/if}
						</div>
					{/if}
				{elseif $opt_info.field->is_enabled}
					<div class="{if $opt_info.error}field_error_row {/if}{cycle values='row_odd,row_even'}">
						<label for="optional_field_{$i}" class="field_label">{$opt_info.label}</label>
						
						{if $field_config.use_filters && $opt_info.filter_assoc}
							{* Using filters for this field *}
							{$opt_info.value}
						{elseif !$editCheck && !$opt_info.field->can_edit}
							{* Editing, and can edit is off, so just display *}
							{$opt_info.value}
						{elseif $opt_info.field->field_type=='text'||$opt_info.field->field_type=='url'||$opt_info.field->field_type=='number'}
							{* Text input (text, number, or url) *}
							<input type="text" name="b[optional_field_{$i}]" id="optional_field_{$i}"
								size="{if $opt_info.field->text_length > 30}30{else}{$opt_info.field->text_length}{/if}"
								maxlength="{$opt_info.field->text_length}" class="field"
								value="{$opt_info.value}" />
						{elseif $opt_info.field->field_type=='textarea'}
							{* textarea type *}
							<textarea rows="6" cols="30" name="b[optional_field_{$i}]" id="optional_field_{$i}" class="field">{$opt_info.value}</textarea>
						{elseif $opt_info.field->field_type=='dropdown'&&count($optional_types[$i])}
							{* dropdown *}
							<select name="b[optional_field_{$i}]" id="optional_field_{$i}" class="field">
								{assign var="opt_used" value="0"}
								{foreach from=$optional_types.$i item="row"}
									{* "value" parameter intentionally ommitted from this <option>, to support values containing double-quotes *}
									<option{if $opt_info.value == ($row.value|escape)} selected="selected"{assign var="opt_used" value="1"}{/if}>{$row.value}</option>
								{/foreach}
							</select>
							{if $opt_info.other_box}
								{* other box for dropdown *}
								&nbsp;{$opt_info.or}&nbsp;
								<input type="text" name="b[optional_field_{$i}_other]"
									value="{if !$opt_used}{$opt_info.value}{/if}"
									class="field" 
									size="{if $opt_info.field->text_length > 30}30{else}{$opt_info.field->text_length}{/if}"
									maxlength="{$opt_info.field->text_length}" />
							{/if}
						{/if}
				
						{if $opt_info.error}
							<span class="error_message">{$opt_info.error}</span>
						{/if}
					</div>
				{/if}
			{/foreach}
		{/if}
		
		{include file="shared/questions.tpl"}
		
		{if $display_description_last_in_form && ($editCheck || $fields->description->can_edit)}
			{include file="shared/details_description_box.tpl"}
		{/if}
	{/capture}

	{if $additionalInfo|strip:'' != ''}
		<div class="content_box">
			<h1 class="title">{$messages.500805}</h1>
			{$additionalInfo}		
		</div>
	{/if}
{********************************************}
	{if $fields->mapping_address->is_enabled || $fields->mapping_city->is_enabled || 
		$fields->mapping_state->is_enabled || $fields->mapping_country->is_enabled ||
		$fields->mapping_zip->is_enabled}
		<br />
		<div class="content_box">
			<h2 class="title">{$messages.1622}</h2>
			<p class="page_instructions">{$messages.1623}</p>
			
			{if $fields->mapping_address->is_enabled}
				<div class="{if $error_msgs.mapping_address}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label for="mapping_address" class="field_label">{$messages.1617}</label>
					<input type="text" id="mapping_address" name="b[mapping_address]" value="{$session_variables.mapping_address}" class="field" />
					{if $error_msgs.mapping_address}
						<span class="error_message">{$messages.500100}</span>
					{/if}
				</div>
			{/if}
			{if $fields->mapping_city->is_enabled}
				<div class="{if $error_msgs.mapping_city}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label for="mapping_city" class="field_label">{$messages.1618}</label>
					<input type="text" id="mapping_city" name="b[mapping_city]" value="{$session_variables.mapping_city}" class="field" />
					{if $error_msgs.mapping_city}
						<span class="error_message">{$messages.500101}</span>
					{/if}
				</div>
			{/if}
			{capture name="mapping_country_field" assign="mapping_country_field"}
				{if $fields->mapping_country->is_enabled}
					<div class="{if $error_msgs.mapping_country}field_error_row {/if}{cycle values='row_odd,row_even'}">
						<label for="mapping_country" class="field_label">{$messages.1620}</label>
						{$mapping_country_dropdown}
						{if $error_msgs.mapping_country}
							<span class="error_message">{$messages.500103}</span>
						{/if}
					</div>
				{/if}
			{/capture}
			{if $country_field_isFancy}
				{$mapping_country_field}
			{/if}
			
			{if $fields->mapping_state->is_enabled}
				<div class="{if $error_msgs.mapping_state}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label for="mapping_state" class="field_label">{$messages.1619}</label>
					{$mapping_state_dropdown}
					{if $error_msgs.mapping_state}
						<span class="error_message">{$messages.500102}</span>
					{/if}
				</div>
			{/if}
			{if $fields->mapping_zip->is_enabled}
				<div class="{if $error_msgs.mapping_zip}field_error_row {/if}{cycle values='row_odd,row_even'}">
					<label for="mapping_state" class="field_label">{$messages.1621}</label>
					<input type="text" id="mapping_zip" name="b[mapping_zip]" value="{$session_variables.mapping_zip}" class="field" />
					{if $error_msgs.mapping_zip}
						<span class="error_message">{$messages.500104}</span>
					{/if}
				</div>
			{/if}
			{if !$country_field_isFancy}
				{$mapping_country_field}
			{/if}
		</div>
	{/if}
	{if $moreDetailsEnd}
		{*  Allow addons to insert stuff at the very end. *}
		<br />
		<div class="content_box">
			{foreach from=$moreDetailsEnd item='details' name='moreDetailsEndLoop'}
				{if $details.section_head}
					{* Allow adding a section head above the next contents *}
					{if !$smarty.foreach.moreDetailsEndLoop.first}</div><br /><div class="content_box">{/if}
					
					<h1 class="title">{$details.section_head}</h1>
				{/if}
				{if $details.section_desc}
					{* Allow adding a section description as well *}
					<p class="page_instructions">{$details.section_desc}</p>
				{/if}
				{if $details.full}
					{$details.full}
				{elseif $details.pre || $details.label || $details.value || $details.error}
					<div class="{if $details.error}field_error_row {/if}{cycle values='row_odd,row_even'}">
						<label class="field_label">{if $details.pre}{$details.pre}{/if} {$details.label}</label>
						{$details.value}
						{if $details.error}
							<span class="error_message">{$details.error}</span>
						{/if}
					</div>
				{/if}
			{/foreach}
		</div>
	{/if}
	<div class="center">
		<input type="submit" name="submit" value="{$submit_button_txt}" class="button" />
		<br /><br />
		<a href="{$classifieds_file_name}?a=cart&amp;action=cancel" class="cancel">{$cancel_txt}</a>
	</div>
	
</form>

