<?php
//featured_ads.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

//This is a common file, since all featured modules work basically the same.
if (geoPC::is_print() && $this->get_site_setting('disableAllBrowsing')) {
	//browsing disabled, do not show module contents
	return;
}

$seed = rand();

$tpl_vars['cat_id'] = $page->site_category;

if (isset($tpl_vars['is_featured_category']) && $tpl_vars['is_featured_category'] && $show_module['module_category']) {
	$tpl_vars['cat_id'] = $show_module['module_category'];
}
if ($page->configuration_data['display_sub_category_ads']) {
	$page->get_sql_in_statement($db,$tpl_vars['cat_id']);
} else {
	$page->in_statement = " in (".$tpl_vars['cat_id'].") ";
}


//$show_module['module_display_type_listing'] WILL ALWAYS BE ZERO IF NOT CLASSAUCTIONS. THE SWITCH IN ADMIN IS NOT AVAILABLE TO CHOOSE.
if (geoPC::is_class_auctions()) {
	$type_in_statement = '';
	if ($show_module['module_display_type_listing'] == 1){
		//only show classifieds.
		$type_in_statement = " and item_type=1 ";
	} elseif ($show_module['module_display_type_listing'] == 2){
		$type_in_statement = " and item_type=2 ";
	} elseif ($show_module['module_display_type_listing'] == 4){
		$type_in_statement = " and item_type=4 ";
	}
} elseif (geoPC::is_classifieds()){
	$type_in_statement = ' and item_type=1 ';
} elseif (geoPC::is_auctions()){
	$type_in_statement = ' and (item_type=2 or item_type=4)';
}

//required to scope template variables properly
$headers = array();
$listings = array();
if ($col_name) {
	$where_featured = "{$col_name} = 1 AND";
	$order_by = "ORDER BY rand($seed)";
} else {
	$where_featured = '';
	//it is up to each module to set $order_by.
}
$sql = "SELECT * FROM ".geoTables::classifieds_table."$filter_tables WHERE $where_featured live = 1 $type_in_statement";
if ($tpl_vars['cat_id'] && $page->in_statement && !$tpl_vars['ignoreCategory']) {
	//$tpl_vars['ignoreCategory'] is a special case for FEATURED_ADS_2, which is never restricted by current category
	$sql .= " and category ".$page->in_statement;
}

//$sql .= " $filter_sql GROUP BY `id` ";
//id column should be unique, with no need to group by it. trying to do so seems to
//cause the query to grab improper results, especially on sites with lots of listings
//that said, duplicates are sometimes generated without it
$sql .= " $filter_sql ";


$sql .= " $order_by LIMIT ".$show_module['module_number_of_ads_to_display'];
//unset order_by, we are done with it, don't want it accidentally persisting for another module.
unset($order_by);
$featured_result = $this->Execute($sql, $filter_query_data);
//echo $sql."<br />\n";
if (!$featured_result) {
	return false;
} else if ($featured_result->RecordCount() > 0) {
	if ($show_module['module_display_header_row']) {
		$h = 0; //headers index & colspan counter
		
		if(geoPC::is_class_auctions()) {			
			if ($show_module['module_display_listing_column']) {
				$headers[$h]['css'] = 'type';
				$headers[$h]['text'] = $txt_vars['module_display_listing_column'];
				$h++;
			}
		}

		if ($show_module['module_display_photo_icon']) {
			$headers[$h]['css'] = 'photo_td';
			$headers[$h]['text'] = $txt_vars['module_display_photo_icon'];
			$h++;
		}
		// 0 is default condition
		if (!$show_module['module_display_title']) {				
			$headers[$h]['css'] = $tpl_vars['css_alternate_optional_class'] ? 'title_row' : 'title_td';
			$headers[$h]['text'] = $txt_vars['module_display_title'];
			
			if ((($show_module['module_display_ad_description'])&& ($show_module['module_display_ad_description_where'])) || (!$show_module['module_display_ad_description']))
				$headers[$h]['style'] = "width: 100%;";
			if (($show_module['module_display_ad_description']) && ($show_module['module_display_ad_description_where'])) {
				$headers[$h]['text2'] .= $txt_vars['module_display_title_2'];
			}
			$h++;
		}
		if (($show_module['module_display_ad_description']) && (!$show_module['module_display_ad_description_where'])) {
			$headers[$h]['css'] = 'description_td';
			$headers[$h]['text'] = $txt_vars['module_display_ad_description'];
			$h++;
		}
		if ( geoPC::is_ent() ) {
			for ($index = 1; $index <= 20; $index ++) {
				if ($show_module['module_display_optional_field_'.$index]) {
					$headers[$h]['css'] = ($tpl_vars['css_alternate_optional_class']) ? 'optional_'.$index : 'optional_header_'.$index;
					$headers[$h]['text'] = $txt_vars['module_display_optional_field_'.$index];
					$h++;
				}
			}
		}
		if ($show_module['module_display_city']) {
			$headers[$h]['css'] = 'city_header';
			$headers[$h]['text'] = $txt_vars['module_display_city'];
			$h++;
		}
		if ($show_module['module_display_state']) {
			$headers[$h]['css'] = 'state_header';
			$headers[$h]['text'] = $txt_vars['module_display_state'];
			$h++;
		}
		if ($show_module['module_display_country']) {
			$headers[$h]['css'] = 'country_header';
			$headers[$h]['text'] = $txt_vars['module_display_country'];
			$h++;
		}
		if ($show_module['module_display_zip']) {
			$headers[$h]['css'] = 'zip_header';
			$headers[$h]['text'] = $txt_vars['module_display_zip'];
			$h++;
		}

		if (geoPC::is_auctions() && $show_module['module_display_number_bids'])	{
			$headers[$h]['css'] = 'number_bids';
			$headers[$h]['text'] = $txt_vars['module_display_number_bids'];
			$h++;
		}

		if ($show_module['module_display_price']) {
			$headers[$h]['css'] = 'price_td';
			$headers[$h]['text'] = $txt_vars['module_display_price'];
			$h++;
		}
		if ($show_module['module_display_entry_date']) {
			$headers[$h]['css'] = 'entry_td';
			$headers[$h]['text'] = $txt_vars['module_display_entry_date'];
			$h++;
		}
		if (geoPC::is_auctions() && $show_module['module_display_time_left']) {
			$headers[$h]['css'] = 'time_left';
			$headers[$h]['text'] = $txt_vars['module_display_time_left'];
			$h++;
		}

		if ($page->classified_user_id == 1 || geoAddon::triggerDisplay('auth_listing_edit',null, geoAddon::NOT_NULL)) {
			$tpl_vars['header_edit'] = true;
			$h++;
		}
		if ($page->classified_user_id == 1 || geoAddon::triggerDisplay('auth_listing_delete',null, geoAddon::NOT_NULL)) { 
			$tpl_vars['header_delete'] = true;
			$h++;
		}
		$tpl_vars['header_colspan'] = ($h > 0)? $h: 1;
		
	}
	
	$tpl_vars['popup_width'] = $page->configuration_data['popup_while_browsing_width'];
	$tpl_vars['popup_height'] = $page->configuration_data['popup_while_browsing_height'];
	
	
	$tpl_vars['edit_img'] = "images/btn_user_edit.gif";
	$tpl_vars['delete_img'] = "images/btn_user_remove.gif";
	
	$l = 0; //listings index
	

	while ($show_classifieds = $featured_result->FetchRow()) {
		$listings[$l]['is_bold'] = $show_classifieds['bolding'];
		

		//URL used in links to this listing
		$listing_url = $page->configuration_data['classifieds_file_name'] . "?a=2&amp;b=".$show_classifieds['id'];
		
		$listings[$l]['cols'] = array();
		$col = 0; //column index

		if(geoPC::is_class_auctions()) {			
			if ($show_module['module_display_listing_column']) {
				if ($show_classifieds['item_type'] == 1) {
					$listings[$l]['cols'][$col]['text'] = $txt_vars['item_type_1'];
				} else if ($show_classifieds['item_type'] == 2 || $show_classifieds['item_type'] == 4) {
					$listings[$l]['cols'][$col]['text'] = $txt_vars['item_type_2'];
				}
				$col++;
			}
		}

		if ($show_classifieds['image']) {
			$image_sql = "SELECT * FROM geodesic_classifieds_images_urls WHERE classified_id = '".$show_classifieds['id']."'";
			$image_result1 = $this->Execute($image_sql);
			
			$actual_images = ($image_result1)? $image_result1->RecordCount(): 0;  
		}
			
		if ($show_module['module_display_photo_icon']) {
			if($show_module['photo_or_icon'] == 1) {
				$page->configuration_data['photo_or_icon'] = 1;
			}
			if(($show_module['photo_or_icon'] == 2 && $page->configuration_data['photo_or_icon'] == 1) || $show_module['photo_or_icon'] == 1) {
				$listings[$l]['cols'][$col]['style'] = "text-align: center;";				
				if ($page->configuration_data['photo_or_icon'] == 1) {
					if ($show_classifieds['image'] > 0 && $actual_images > 0) {
						if (($show_module['module_thumb_height'] > 0) || ($show_module['module_thumb_width'] > 0)){
							$listings[$l]['cols'][$col]['text'] = geoImage::display_thumbnail($show_classifieds['id'],$show_module['module_thumb_width'],$show_module['module_thumb_height'],1); 
						} else {
							$listings[$l]['cols'][$col]['text'] = geoImage::display_thumbnail($show_classifieds['id'], 0, 0, 1);
						}
					} elseif (($page->messages[500795]) && (!$show_classifieds['image'])) {
						
						$listings[$l]['cols'][$col]['text'] = "<img src=\"".geoTemplate::getUrl('',$page->messages[500795])."\" alt=\"\" style=\"border-style: none;\" />";
							
						if (($page->configuration_data['popup_while_browsing'])
						&& ($page->configuration_data['popup_while_browsing_width'])
						&& ($page->configuration_data['popup_while_browsing_height'])) {
								$listings[$l]['cols'][$col]['poplink'] = $listing_url;
						} else {
							$listings[$l]['cols'][$col]['link'] = $listing_url;
						}
					} else { 
						$listings[$l]['cols'][$col]['text'] = "&nbsp;";
					}
				} else {
					if ($show_classifieds['image'] > 0 && $actual_images > 0) {
						$listings[$l]['cols'][$col]['style'] = "text-align: center;";
						$listings[$l]['cols'][$col]['text'] = "<img src=\"".geoTemplate::getUrl('',$page->messages[500796])."\" alt=\"\" style=\"border-style:none;\" />";
						
						if (($page->configuration_data['popup_while_browsing'])
						&& ($page->configuration_data['popup_while_browsing_width'])
						&& ($page->configuration_data['popup_while_browsing_height'])) {
							$listings[$l]['cols'][$col]['poplink'] = $listing_url;
						} else {
							$listings[$l]['cols'][$col]['link'] = $listing_url;
						}
					} elseif (($page->messages[500795]) && (!$show_classifieds['image'])) {
						$listings[$l]['cols'][$col]['style'] = "text-align: center;";
						$listings[$l]['cols'][$col]['text'] = "<img src=\"".geoTemplate::getUrl('',$page->messages[500795])."\" alt=\"\" style=\"border-style: none;\" />";
						
						if (($page->configuration_data['popup_while_browsing'])
						&& ($page->configuration_data['popup_while_browsing_width'])
						&& ($page->configuration_data['popup_while_browsing_height'])) {
							$listings[$l]['cols'][$col]['poplink'] = $listing_url;
						} else {
							$listings[$l]['cols'][$col]['link'] = $listing_url;
						}
					} else {
						$listings[$l]['cols'][$col]['text'] = "&nbsp;";
					}
						
				}
				$col++;
			} else {
				// Display icon
				if ($show_classifieds['image'] > 0 && $actual_images > 0) {
					$listings[$l]['cols'][$col]['style'] = "text-align: center;";
					$listings[$l]['cols'][$col]['text'] = "<img src=\"".geoTemplate::getUrl('',$page->messages[500796])."\" alt=\"\" style=\"border-style:none;\" />";
					
					if ($page->configuration_data['popup_image_while_browsing']) {
						$listings[$l]['cols'][$col]['poplink'] = $listing_url;
					} else {			
						$listings[$l]['cols'][$col]['link'] = $listing_url;
					}
						
				} else {
					$listings[$l]['cols'][$col]['text'] = "&nbsp;";
				}
				$col++;
			}
		}

		/*
			Flag to hold whether a link has been done yet
			0 means it hasnt been
			1 means it has
		*/
		$link = 0;

		// 0 is default condition
		if (!$show_module['module_display_title']) {
			
			if ((($show_module['module_display_ad_description'])&& ($show_module['module_display_ad_description_where'])) || (!$show_module['module_display_ad_description'])) {
				$listings[$l]['cols'][$col]['style'] = "width: 100%;";
			}
			if ($show_classifieds['sold_displayed'])
				$listings[$l]['cols'][$col]['sold_image'] = geoTemplate::getUrl('',$this->messages[500798]);
			if (($page->configuration_data['popup_while_browsing'])
			&& ($page->configuration_data['popup_while_browsing_width'])
			&& ($page->configuration_data['popup_while_browsing_height'])) {
				$listings[$l]['cols'][$col]['poplink'] = $listing_url;
			} else {
				$listings[$l]['cols'][$col]['link'] = $listing_url;
			}
			$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['title']));
			if ((strlen($page->messages[500799]) >0) && ($show_classifieds['item_type'] == 2) || $show_classifieds['item_type'] == 4) {
				$current_bid = $show_classifieds['current_bid'];
				$number_of_bids = $page->get_number_of_bids($db,$show_classifieds['id']);
				if (($show_classifieds['buy_now']!= 0) && (($show_classifieds['current_bid'] == 0) || ($page->configuration_data['buy_now_reserve'] && $show_classifieds['current_bid'] < $show_classifieds['reserve_price']))) {
					$listings[$l]['cols'][$col]['post_images'][] = geoTemplate::getUrl('',$page->messages[500799]); 
				}
			}								
			if ((strlen($page->messages[500800]) >0) && ($show_classifieds['item_type'] == 2) || $show_classifieds['item_type'] == 4) {
				if ( $show_classifieds['reserve_price'] != 0) {
					$current_bid = $show_classifieds['current_bid'];
					if (($show_classifieds['item_type'] == 2 && $current_bid >= $show_classifieds['reserve_price']) && ($show_classifieds['item_type'] == 4 && $current_bid <= $show_classifieds['reserve_price'])) {
						$listings[$l]['cols'][$col]['post_images'][] = geoTemplate::getUrl('',$page->messages[500800]); 
					}
				}
			}				
			if ((strlen($page->messages[500802]) >0) && ($show_classifieds['item_type'] == 2) || $show_classifieds['item_type'] == 4) {
					if ($show_classifieds['reserve_price'] == 0.00 && !$show_classifieds['buy_now_only']) {
						$listings[$l]['cols'][$col]['post_images'][] = geoTemplate::getUrl('',$page->messages[500802]);
					}
			}				
			if (($show_classifieds['attention_getter']) && ($show_module['module_display_attention_getter'])) {
				$listings[$l]['cols'][$col]['post_images'][] = $show_classifieds['attention_getter_url']; 
			}
			if (($show_module['module_display_ad_description']) && ($show_module['module_display_ad_description_where'])) {
				$cleaned_desc = geoFilter::listingDescription($show_classifieds['description']);
				if (strlen($cleaned_desc) > $show_module['length_of_description']) {
					$cleaned_desc = geoFilter::listingShortenDescription($cleaned_desc, $show_module['length_of_description']);
				}
				$listings[$l]['cols'][$col]['text2'] = $cleaned_desc;
			}
			$col++;

			$link = 1;
		}

		if (($show_module['module_display_ad_description']) && (!$show_module['module_display_ad_description_where'])) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			$descToShow = "";
			if (!$show_module['display_all_of_description']) {
				$cleaned_desc = trim(strip_tags(stripslashes(urldecode($show_classifieds['description']))));
				if (strlen($cleaned_desc) > $show_module['length_of_description']) {
					$small_string = geoString::substr($cleaned_desc,0,$show_module['length_of_description']);
					$position = strrpos($small_string," ");
					$smaller_string = geoString::substr($small_string,0,$position);
					$descToShow = $smaller_string."...";
				} else {
					$descToShow .= $cleaned_desc;
				}
			} else {
				$descToShow = stripslashes(urldecode($show_classifieds['description']));
			}
			
			$listings[$l]['cols'][$col]['text'] = $descToShow;

			$col++;
		}
		if ( geoPC::is_ent() ) {
			for ($index = 1; $index <= 20; $index++){
				if ($show_module['module_display_optional_field_'.$index]) {
					if(!$link) {
						if (($page->configuration_data['popup_while_browsing'])
						&& ($page->configuration_data['popup_while_browsing_width'])
						&& ($page->configuration_data['popup_while_browsing_height'])) {
							$listings[$l]['cols'][$col]['poplink'] = $listing_url;
						} else {
							$listings[$l]['cols'][$col]['link'] = $listing_url;
						}
						$link = 1;
					}
	
					if (strlen(trim(urldecode($show_classifieds['optional_field_'.$index]))) > 0) {
						$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['optional_field_'.$index])); 
					} else {
						$listings[$l]['cols'][$col]['text'] = "-";
					}
				}
				$col++;
			}
		}

		if ($show_module['module_display_city']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			if (strlen(trim(urldecode($show_classifieds['location_city']))) > 0) {
				$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['location_city']));
			} else {
				$listings[$l]['cols'][$col]['text'] = "-";
			}
			$col++;
		}

		if ($show_module['module_display_state']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			if (strlen(trim(urldecode($show_classifieds['location_state']))) > 0) {
				$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['location_state']));
			} else {
				$listings[$l]['cols'][$col]['text'] = "-";
			}
			$col++;
		}

		if ($show_module['module_display_country']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			if (strlen(trim(urldecode($show_classifieds['location_country']))) > 0) {
				$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['location_country']));
			} else {
				$listings[$l]['cols'][$col]['text'] = "-";
			}
			$col++;
		}

		if ($show_module['module_display_zip']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			if (strlen(trim(urldecode($show_classifieds['location_zip']))) > 0) {
				$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($show_classifieds['location_zip']));
			} else {
				$listings[$l]['cols'][$col]['text'] = "-";
			}
			$col++;
		}

		if (geoPC::is_auctions() && $show_module['module_display_number_bids']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}
			
			if ($show_classifieds['item_type'] == 2 || $show_classifieds['item_type'] == 4) {
				$listings[$l]['cols'][$col]['text'] = stripslashes(urldecode($page->get_number_of_bids($db,$show_classifieds['id'])));
			} else {
				$listings[$l]['cols'][$col]['text'] = "-";
			}
			$col++;
		}

		if ($show_module['module_display_price']) {
			
			//price column should be nowrap
			$listings[$l]['cols'][$col]['style'] = 'white-space: nowrap;';
			
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			if (($show_classifieds['item_type'] == 1) && $show_module['module_display_price']) {
				
				$listings[$l]['cols'][$col]['text'] = $page->show_money($show_classifieds[$page->item_price($show_classifieds['item_type'])],$show_classifieds['precurrency'],$show_classifieds['postcurrency']);
			} elseif (($show_classifieds['item_type'] == 2 || $show_classifieds['item_type'] == 4) && $show_classifieds['buy_now_only']) {
				//this is a buy now only auction
				$listings[$l]['cols'][$col]['text'] = $page->show_money($show_classifieds['buy_now'],$show_classifieds['precurrency'],$show_classifieds['postcurrency']);
			} elseif (($show_classifieds['item_type'] == 2 || $show_classifieds['item_type'] == 4) && ($show_classifieds['minimum_bid'] != 0) && $show_module['module_display_price']) {
				if ($show_classifieds['item_type'] == 2 && $show_classifieds['minimum_bid'] < $show_classifieds['starting_bid']) {
					$show_classifieds['minimum_bid'] = $show_classifieds['starting_bid'];
				}				
				$listings[$l]['cols'][$col]['text'] = $page->show_money($show_classifieds['minimum_bid'],$show_classifieds['precurrency'],$show_classifieds['postcurrency']);
			} elseif (($show_classifieds['item_type'] == 2 || $show_classifieds['item_type'] == 4) && ($show_classifieds['starting_bid'] != 0) && $show_module['module_display_price']) {
				$listings[$l]['cols'][$col]['text'] = $page->show_money($show_classifieds['starting_bid'],$show_classifieds['precurrency'],$show_classifieds['postcurrency']);
			}						
			$col++;
		}

		if ($show_module['module_display_entry_date']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			$listings[$l]['cols'][$col]['text'] = date(trim($page->configuration_data['entry_date_configuration']),$show_classifieds['date']);
			$col++;
		}

		if (geoPC::is_auctions() && $show_module['module_display_time_left']) {
			if(!$link) {
				if (($page->configuration_data['popup_while_browsing'])
				&& ($page->configuration_data['popup_while_browsing_width'])
				&& ($page->configuration_data['popup_while_browsing_height'])) {
					$listings[$l]['cols'][$col]['poplink'] = $listing_url;
				} else {
					$listings[$l]['cols'][$col]['link'] = $listing_url;
				}
				$link = 1;
			}

			$weeks = $page->DateDifference(w,geoUtil::time(),$show_classifieds["ends"]);
			$remaining_weeks = ($weeks * 604800);

			// Find days left
			$days = $page->DateDifference(d,(geoUtil::time()+$remaining_weeks),$show_classifieds["ends"]);
			$remaining_days = ($days * 86400);

			// Find hours left
			$hours = $page->DateDifference(h,(geoUtil::time()+$remaining_days),$show_classifieds["ends"]);
			$remaining_hours = ($hours * 3600);

			// Find minutes left
			$minutes = $page->DateDifference(m,(geoUtil::time()+$remaining_hours),$show_classifieds["ends"]);
			$remaining_minutes = ($minutes * 60);

			// Find seconds left
			$seconds = $page->DateDifference(s,(geoUtil::time()+$remaining_minutes),$show_classifieds["ends"]);
			if(($weeks <= 0) && ($days <= 0) && ($hours <= 0) && ($minutes <= 0) && ($seconds <= 0)) {
				// If closed we want to display closed text
				$listings[$l]['cols'][$col]['text'] = "-";
			} 
			if ($weeks > 0) {
				$listings[$l]['cols'][$col]['text'] = "$weeks {$txt_vars['weeks']}, $days {$txt_vars['days']}";
			} elseif ($days > 0) {
				$listings[$l]['cols'][$col]['text'] = "$days {$txt_vars['days']}, $hours {$txt_vars['hours']}";
			} elseif ($hours > 0) {
				$listings[$l]['cols'][$col]['text'] = "$hours {$txt_vars['hours']}, $minutes {$txt_vars['minutes']}";
			} elseif ($minutes > 0) {
				$listings[$l]['cols'][$col]['text'] = "$minutes {$txt_vars['minutes']}, $seconds {$txt_vars['seconds']}";
			} elseif ($seconds > 0) {
				$listings[$l]['cols'][$col]['text'] = "$seconds {$txt_vars['seconds']}";
			}
			$col++;
		}

		if ($page->classified_user_id == 1 || geoAddon::triggerDisplay('auth_listing_edit',null, geoAddon::NOT_NULL)) {
			$listings[$l]['edit'] = $page->configuration_data['classifieds_file_name']."?a=cart&amp;action=new&amp;main_type=listing_edit&amp;listing_id=".$show_classifieds['id'];
		}
		if ($page->classified_user_id == 1 || geoAddon::triggerDisplay('auth_listing_delete',null, geoAddon::NOT_NULL)) {
			$listings[$l]['delete'] = $page->configuration_data['classifieds_file_name']."?a=99&amp;b=".$show_classifieds['id']."&amp;c=".$category;
		}

		$l++; //step to next listing
	} //end of while
} else {
	//no classifieds in this category
	$tpl_vars['empty_category'] = $txt_vars['empty_category'];
}


$tpl_vars['module'] = $show_module;
$tpl_vars['headers'] = $headers;
$tpl_vars['listings'] = $listings;

$view->setModuleTpl($show_module['module_replace_tag'],'index')
	->setModuleVar($show_module['module_replace_tag'],$tpl_vars);
	
