<?php
//featured_pic.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

//All featured ad pic modules use this for the bulk of the work
if (geoPC::is_print() && $this->get_site_setting('disableAllBrowsing')) {
	//browsing disabled, do not show module contents
	return;
}

$seed = rand();

//make sure to clear $listings between modules :)
$listings = array();

if ($page->configuration_data['display_sub_category_ads'])
	$page->get_sql_in_statement($db,$page->site_category);
else{
	$page->in_statement = " in (".$page->site_category.") ";
}
//$show_module['module_display_type_listing'] WILL ALWAYS BE ZERO IF NOT CLASSAUCTIONS. THE SWITCH IN ADMIN IS NOT AVAILABLE TO CHOOSE.
if (geoPC::is_class_auctions()){
	$type_in_statement = '';
	if ($show_module['module_display_type_listing'] == 1){
		//only show classifieds.
		$type_in_statement = " and item_type=1 ";
	} elseif ($show_module['module_display_type_listing'] == 2){
		$type_in_statement = " and item_type=2 ";
	} elseif ($show_module['module_display_type_listing'] == 4){
		$type_in_statement = " and item_type=4 ";
	}
} elseif (geoPC::is_classifieds()){
	$type_in_statement = ' and item_type=1 ';
} elseif (geoPC::is_auctions()){
	$type_in_statement = ' and (item_type=2 or item_type=4)';
}

$featured = (geoPC::is_lite())? '': "$col_name = 1 AND";

$sql = "select * from geodesic_classifieds,".$page->images_urls_table."$filter_tables where
	geodesic_classifieds.id = ".$page->images_urls_table.".classified_id and ".$page->images_urls_table.".display_order = 1 
	and $featured image > 0 and live = 1 ".$type_in_statement.' '.$filter_sql;

if ($page->site_category)
	$sql .= " and category ".$page->in_statement;

$sql .= " GROUP BY id ";
	
//module_number_of_ads_to_display is actually number of rows to display
//multiply by number of columns to find total number of ads to get
$limit = $show_module['module_number_of_ads_to_display'] * $show_module['module_number_of_columns'];

$sql .= " order by rand(".$seed.") limit ".$limit;
$featured_result = $this->Execute($sql, $filter_query_data);
if ($featured_result) {
	if ($featured_result->RecordCount() > 0)
	{
		if ($show_module['module_display_header_row']) {
			$tpl_vars['header_text'] = $header_bar_text;
		}
		
		switch ($show_module['module_number_of_columns']) {
			case 1: $column_width = "100%"; break;
			case 2: $column_width = "50%"; break;
			case 3: $column_width = "33%"; break;
			case 4: $column_width = "25%"; break;
			case 5: $column_width = "20%"; break;
			case 6: $column_width = "16%"; break;
			case 7: $column_width = "14%"; break;
			case 8: $column_width = "12%"; break;
			case 9: $column_width = "11%"; break;
			case 10: $column_width = "10%"; break;
			default: $column_width = 0;
		}
		$tpl_vars['col_width'] = $column_width;
		
		$row = 0;
				
		$numAdsToShow = ($featured_result->RecordCount() > $limit) ? $limit : $featured_result->RecordCount();
		
		$extra_cols = $numAdsToShow % $show_module['module_number_of_columns'];
		if($extra_cols > 0) {
			//table ends in an incomplete row with $extra_cols cells
	
			//since there's no easy way I know of to do a strictly numerical loop in smarty
			//we'll use this dirty hack to fill out the empty spots in the table:
			$blanks = '';
			for($z = $extra_cols; $z < $show_module['module_number_of_columns']; $z++) {
				$blanks .= '<td class="'.$tpl_vars['css_prepend'].'pic_row" style="width: '.$column_width.';"></td>';
			}
			$tpl_vars['blanks'] = $blanks;
		}
		
		for($i=0; ($i < $numAdsToShow && $show = $featured_result->FetchRow()); $i++) {
			//let template have access to all data
			$listings[$i]['raw'] = $show;
			
			$listings[$i]['thumbnail'] = geoImage::display_thumbnail($show['id'],$show_module['module_thumb_width'],$show_module['module_thumb_height'],1);
			if ($show['sold_displayed']) {
				$listings[$i]['sold_image'] = geoTemplate::getUrl('',$this->messages[500798]);
			}
			if (!$show_module['module_display_title']) {
				//this is a "hide" switch -- logic is inverted
				//Note:  stripping tags and truncating is done in template
				$listings[$i]['caption'] = geoString::fromDB($show[$show_module['module_text_type']]); 
			}
			
			if($show_module['module_display_price']) {
				//determine the price to show
				if (($show['item_type'] == 1) && $show_module['module_display_price']) {
					$display_amount = $page->show_money($show[$page->item_price($show['item_type'])],$show['precurrency'],$show['postcurrency'],0,1);
				} elseif (($show['item_type'] == 2 || $show['item_type'] == 4) && $show['buy_now_only']) {
					//this is a buy now only auction
					$display_amount = $page->show_money($show['buy_now'],$show['precurrency'],$show['postcurrency'],0,1);
				} elseif (($show['item_type'] == 2 || $show['item_type'] == 4) && ($show['minimum_bid'] != 0) && $show_module['module_display_price']) {
					if ($show['item_type'] == 2 && $show['minimum_bid'] < $show['starting_bid']) {
						$show['minimum_bid'] = $show['starting_bid'];
					}
					$display_amount = $page->show_money($show['minimum_bid'],$show['precurrency'],$show['postcurrency'],0,1);
				} elseif (($show['item_type'] == 2 || $show['item_type'] == 4) && ($show['starting_bid'] != 0) && $show_module['module_display_price']) {
					$display_amount = $page->show_money($show['starting_bid'],$show['precurrency'],$show['postcurrency'],0,1);
				}
	
				$listings[$i]['price'] = $display_amount;
				
			}
			
			if($show_module['module_display_type_text'] && geoPC::is_class_auctions()) {
				if ($show['item_type'] == 1) {
					//classified
					$listings[$i]['type'] = $classified_text;
				} elseif ($show['item_type'] == 2) {
					//auction
					$listings[$i]['type'] = $auction_text;
				}
			}
		}
	} else {
		$tpl_vars['resultset_empty_message'] = $empty_text;
	}
} else {
	$tpl_vars['resultset_empty_message'] = $empty_text;
}
$tpl_vars['module'] = $show_module;
$tpl_vars['listings'] = $listings;

$view->setModuleTpl($show_module['module_replace_tag'],'index')
	->setModuleVar($show_module['module_replace_tag'],$tpl_vars);
