<?php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

//make sure errors are not shown.
error_reporting(0);

//un-comment to see errors..
ini_set('display_errors','stdout');

//Fix for stupid sites that have magic_quotes_runtime turned on...  Must turn it off!
if (function_exists('set_magic_quotes_runtime') && get_magic_quotes_runtime()) {
	//must check for function first, since function will be removed from PHP in
	//future, along with ability to turn this stupid setting on.  Hooray!
	set_magic_quotes_runtime(false);
}

//make sure we have enough memory to load the upgrade script, since it takes
//more than normal.
require_once('../ini_tools.php');
//make sure it is at least 128 megs (more needed on 64bit servers)
geoRaiseMemoryLimit('128M');

require_once('../config.default.php');

require_once(CLASSES_DIR.'smarty/Smarty.class.php');

##  Do a few checks:
if (!is_writable(GEO_BASE_DIR . 'templates_c/')) {
	die ('Upgrade error: you need to make the directory <strong>'.GEO_BASE_DIR.'templates_c/</strong> writable (CHMOD 777).');
}

/**
 * Convert an associative array to a string using it's keys AND values
 *
 * @param array $array Source array
 * @param string $element_glue Delimiter to use between key/value pairs
 * @param string $key_value_glue Delimiter to use between keys and values
 * @return string Imploded array as a string
 */
function implode_with_keys($array, $element_glue, $key_value_glue) {
	$half_imploded = array();
	foreach($array as $key => $value) {
		array_push($half_imploded, $key.$key_value_glue.$value);
	}
	return implode($element_glue, $half_imploded);
}

/**
 * Checks the min requirements, needs to work with PHP4 and not be encoded,
 * so that it can properly display requirement check page even when requirements
 * are not met.
 * 
 * @package Update
 */
class geoReq
{
	/**
	 * Replaces the template body with the requirement check.
	 * Uses repuirement_check.php and requirement_check.html.
	 */
	function reqCheck(){
		$this->step_text = 'Requirement Check';
		
		$failed = '<span class="failed"><img src="images/no.gif" alt="no" title="no"></span>';
		$passed = '<span class="passed"><img src="images/yes.gif" alt="yes" title="yes"></span>';
		$not_needed = '---';
		$overall_fail = '';
		$overall_pass = '<p class="passed">All minimum requirements met.</p>';
		//license agreement
		if (file_exists('../docs/license.txt')){
			$overall_pass .= '<p><label><input type="checkbox" name="license" id="license" /> Yes, I have read and agree to the <a href="../docs/license.txt" class="login_link">License Agreement</a></label></p>';
			if (defined('IAMDEVELOPER')){
				$overall_fail .= '<p><label><input type="checkbox" name="license" id="license" /> Yes, I have read and agree to the <a href="../docs/license.txt" class="login_link">License Agreement</a></label></p>';
			}
		} else {
			if (defined('IAMDEVELOPER')){
				$overall_fail .= '<p><label><input type="checkbox" name="license" id="license" /> Yes, I have read and agree to the Software License Agreement, which is available in the client area of the Geodesic cart system.</label></p>';
			}
			$overall_pass .= '<p><label><input type="checkbox" name="license" id="license" /> Yes, I have read and agree to the Software License Agreement, which is available in the client area of the Geodesic cart system.</label></p>';
		}
		//back up agreement
		$overall_pass .= '<p><label><input type="checkbox" name="backup_agree" id="backup_agree" /> Yes, I have <strong>backed up</strong> the entire database and all files.</label></p>';
		if (defined('IAMDEVELOPER')){
			$overall_fail .= '<p><label><input type="checkbox" name="backup_agree" id="backup_agree" /> Yes, I have <strong>backed up</strong> the entire database and all files.</label></p>';
		}
		$overall_fail .= '<p class="body_txt1"><div style="text-align: left; background-color: #FFF; padding: 5px; border: 1px solid #EA1D25;"><span class="failed">IMPORTANT: As shown above, one or more of your server\'s minimum requirements have not been met.  These requirements must be met in order to continue with this installation.
	<br><br>NOTE: Zend Optimizer and IonCube are FREELY available for your host to download and install on your server. There is NO COST to your host, since the version that needs to be installed is the
	"decryption" version.
	<br><br>Hosting Trouble? Find our recommended hosting solutions by <a href="http://geodesicsolutions.com/resources.html" class="login_link" target="_blank">CLICKING HERE</a>.</span></div></p>
	<p>Please refer to the <a href="http://geodesicsolutions.com/support/wiki/update/start" class="login_link" target="_blank">Geodesic Solutions User Manual</a>.</p>';
		
		$continue_pass = '<input type="submit" name="continue" value="Continue >>" />';
		$continue_fail = '';
		if (defined('IAMDEVELOPER')){
			//allow to keep going even if req fail, if developer..
			$continue_fail = $continue_pass;
		}
		//req text
		$php_version_req = 'PHP Version 5.2.0+';
		$mysql_req = 'MySQL Version 3.2.3+';
		$ioncube_ini_req = 'ionCube Loader';
		$zend_req = 'Zend Optimizer';
		
		//start out with passed message, then replace if one of the requirements fail.
		$overall = $overall_pass;
		//start out with the continue as pass, then replace if one of the requirements fail.
		$continue = $continue_pass;
		
		
		////PHP VERSION CHECK
		$version_num = phpversion();
		$php = version_compare($version_num, '5.2.0', '>=');
		$php_text = 'PHP '.$version_num;
		
		if (!$php) {
			$overall = $overall_fail;
			$continue = $continue_fail;
		}
		
		//replace php version text
		$this->tplVars['php_version_text'] = $php_text;
		//replace php version check result
		$this->tplVars['php_version_result'] = ($php)? $passed: $failed;
		//replace php version req text
		$this->tplVars['php_version_req'] = $php_version_req;
		
		//safe mode text
		$safe_mode = !ini_get('safe_mode');
		$this->tplVars['safe_mode_text'] = ($safe_mode)? 'safe_mode is OFF' : 'safe_mode is ON!';
		//replace safe mode check result
		$this->tplVars['safe_mode_result'] = ($safe_mode)? $passed : $failed;
		//replace safe mode req text
		$this->tplVars['safe_mode_req'] = 'PHP safe_mode OFF';
		
		if (!$safe_mode) {
			$overall = $overall_fail;
			$continue = $continue_fail;
		}
		
		
		
		$this->tplVars['body_tpl'] = 'requirement_check.tpl';
		
		////MYSQL CHECK
		$mysql = $this->mysqlCheck($text, $php);
		//replace mysql text
		$this->tplVars['mysql_text'] = $text;
		//replace mysql check result
		$this->tplVars['mysql_result'] = ($mysql)? $passed : $failed;
		//replace php version req text
		$this->tplVars['mysql_req'] = $mysql_req;
		if (!$mysql) {
			$overall = $overall_fail;
			$continue = $continue_fail;
		}
		////IONCUBE INI CHECK
		$ioncube_ini = $this->ioncubeCheck($ioncube_ini_text);
		//replace ioncube ini req text
		$this->tplVars['ioncube_ini_req'] = $ioncube_ini_req;
		
		
		////ZEND CHECK
		$zend = $this->zendCheck($zend_text);
		//replace zend req text
		$this->tplVars['zend_req'] = $zend_req;
		
		////See which loader will be used
		if ($ioncube_ini){
			//ioncube ini will be used.
			$reason = 'since ionCube Loader is installed.';
			
			$version_num = phpversion();
			if ($zend){
				$zend_text = 'Installed, but not used '.$reason;
			} else {
				$zend_text = 'Not Installed, but not needed '.$reason;
			}
			//change failed message to the not needed message, since one of the requirements was met.
			$failed = $not_needed;
		} else if ($zend){
			//zend will be used.
			$reason = 'since Zend Optimizer is installed';
			
			$ioncube_ini_text .= 'Not Loaded, but not needed '.$reason;
			
			//change failed message to the not needed message, since one of the requirements was met.
			$failed = $not_needed;
		} else {
			//use all the default returned text values.
			//keep the failed message as failed, since all 3 requirements failed.
			$overall = $overall_fail;
			$continue = $continue_fail;
		}
		
		
		//replace runtime result
		$this->tplVars['ioncube_runtime_result'] = ($ioncube_runtime)? $passed : $failed;
		//replace ini result
		$this->tplVars['ioncube_ini_result'] = ($ioncube_ini)? $passed : $failed;
		//replace zend result
		$this->tplVars['zend_result'] = ($zend)? $passed : $failed;
		
		//replace runtime text
		$this->tplVars['ioncube_runtime_text'] = $ioncube_runtime_text;
		//replace runtime text
		$this->tplVars['ioncube_ini_text'] = $ioncube_ini_text;
		//replace runtime text
		$this->tplVars['zend_text'] = $zend_text;
		
		//replace overall text
		$this->tplVars['overall_result'] = $overall;
		//replace continue button yo.
		$this->tplVars['continue'] = $continue;
		
		//developer force version form
		if(defined('IAMDEVELOPER')) {
			$developer = '<p>DEVELOPER FEATURE: Force upgrade to version: <input type="text" name="force_version" value="5.1.3" /><br /><input type="submit" value="Force Version >>" /></p>';
		} else {
			$developer = '';
		}
		$this->tplVars['developer_force_version'] = $developer;
	}
	/**
	 * Takes the template, does tag substitution, and echos it.
	 */
	function display_page() {
		//replace the upgrade step with the text.
		$this->tplVars['upgrade_step'] = $this->step_text;
		//replace the header text
		$this->tplVars['header'] = $this->header_text;
				
		$tpl = new Smarty();
		$tpl->compile_dir = GEO_BASE_DIR.'templates_c';
		$tpl->template_dir = GEO_BASE_DIR . 'upgrade/templates';
		$tpl->assign($this->tplVars);
		
		$tpl->display('index.tpl');
	}
	function mysqlCheck (& $text, $php_check){
		if (!function_exists('mysql_connect')){
			//mysql not even installed.
			$text .= 'MySQL not installed, or not configured to work properly with PHP.';
			return false;
		}
		@include('../config.default.php');
		if ($php_check && isset($db_host) && $db_host != 'your_database_hostname' && strlen($db_host)){
			//if config.php is already set up, attempt to get server version.
			//adodb should be included by now.
			include_once(CLASSES_DIR.'adodb/adodb.inc.php');
			@$db =& ADONewConnection($db_type);
			
			@$db->Connect($db_host, $db_username, $db_password, $database);
			$info = $db->ServerInfo();
			if (is_array($info)){
				$mysql_version = $info['version'];
				if (strlen($mysql_version)){
					$version_comp = version_compare($mysql_version, '3.2.3');
					
					$text .= 'MySQL '.$mysql_version;
					
					if ($version_comp == -1){
						//mysql is a less version.
						return false;
					} else {
						return true;
					}
				}
			}
		}
		$reason = '(database connection settings not configured in config.php) - Version will be checked at the db connection step.';
		if (!$php_check) {
			//not checked, since if before PHP 5, the mysql check will cause a fatal
			//syntax error.
			$reason = '(Not checked since PHP requirement failed)';
		}
		$text = 'MySQL - Version not known '.$reason;
		//version not known, but mysql is at least installed, so proceed.
		return true;
	}
	
	function ioncubeCheck (& $text){
		$loaded = extension_loaded('ionCube Loader');
		if ($loaded){
			$text .= 'Loaded.  This will be the used loader method';
			return true;
		} 
		$url = "http://www.ioncube.com/loader_installation.php";
		if (file_exists('../ioncube/ioncube-loader-helper.php')){
			$url = "../ioncube/ioncube-loader-helper.php?page=install-assistant";
		}
		$text .= '<span style="font-weight: bold; color:#EA1D25;">Not Loaded.</span>  If you wish to use this loader method, <a href="'.$url.'" class="login_link">you can find instructions here.</a>';
		
		return false;
	}
	function zendCheck (& $text){
		$version_num = phpversion();
		
		if (function_exists('zend_loader_enabled') && zend_loader_enabled()){
			$text .= 'Installed.  This will be the used loader method';
			return true;
		} 
		$text .= '<span style="font-weight: bold; color:#EA1D25;">Not Installed.</span>  If you wish to use this loader method, you must have your host or system administrator
	install Zend Optimizer.  More info can be found at the <a href="http://www.zend.com/products/zend_optimizer" class="login_link">Official Zend Website.</a>';
	
		return false;
	}
}
if (isset($_GET['resetProgress']) && $_GET['resetProgress']) {
	//reset the update progress, can be used when a previous update was not "finished"
	//resulting in error.
	require_once 'updateFactory.php';
	
	$upgrade = new geoUpdateFactory();
	$upgrade->removeUpgradeTables();
	//send them back to main page
	header('Location: index.php');
	exit;
}

if($_GET['run'] == 'show_upgrades' && !isset($_POST['license'])){
	die('You must agree to the License Agreement to proceed with the upgrade. Please <a href="index.php">go back</a>, read the License Agreement, and click the appropriate checkbox before continuing.');
} elseif ($_GET['run'] == 'show_upgrades' && !isset($_POST['backup_agree'])){
	die('You must create a site backup to proceed with the upgrade. Once you have created a backup, please <a href="index.php">go back</a>, and click the appropriate checkbox before continuing.');
} else if (isset($_GET['force_version']) && defined('IAMDEVELOPER'))
{
	require_once 'updateFactory.php';

	$upgrade = new geoUpdateFactory();
	if($upgrade->updateCurrentVersion($_GET['force_version']))
		echo "updated version to ".$_GET['force_version']."<br><a href=\"index.php\">Back to Upgrade Page</a>";
} elseif(!isset($_GET['run'])) { 
	// Do prereq check - note that this class works in PHP4 and without Ioncube or Zend...
	
	$checks = new geoReq();
	$checks->reqCheck();
	$checks->display_page();
} elseif ($_GET['run'] == 'show_log'){
	//output the log, don't do any processing to avoid
	//the log database being changed...
	require_once 'updateFactory.php';

	$upgrade = new geoUpdateFactory();
	
	$upgrade->unSerialize();
	$upgrade->showLog();
	$upgrade->display_page();
} else {
	// Run the upgrade(s)
	require_once 'updateFactory.php';

	$upgrade = new geoUpdateFactory();
	
	$result = $upgrade->factory();
	//var_dump($result);
	
	//show the results page
	$upgrade->show_results();
	$upgrade->display_page();
	exit;
}