﻿
import bubblemonkey.utility.DrawShapes;

class bubblemonkey.form.CreateButton {
	
	/** empty contructor
	*/
	public function CreateButton() {
		trace ("CreateButton is a static class and should not be instantiated");
	}
	
	/** creates a button and returns a reference to itself
	*	input parameter(s):
	*		parent_mc:MovieClip - container movieclip inside which the button will be created
	*		label:String - button label
	*		x:Number, y:Number - cartesian coordinates of the button
	*		w:Number - width of the button
	*		h:Number - height of the button
	*		up_color:Number - color of the button during normal state
	*		alt_color:Number - color of the button during mouse rollover
	*		copy_tf:TextFormat - text format of the button copy
	*/
	public static function create(parent_mc:MovieClip, label:String, x:Number, y:Number, w:Number, h:Number, up_color:Number, alt_color:Number, copy_tf:TextFormat):MovieClip {
		// create movieclip
		var button_container_mc:MovieClip = parent_mc.createEmptyMovieClip("button_" + label + "_mc", parent_mc.getNextHighestDepth());
		// draw box
		button_container_mc._x = x;
		button_container_mc._y = y;
		// create up and over states
		button_container_mc.createEmptyMovieClip("over_mc", button_container_mc.getNextHighestDepth());
		button_container_mc.createEmptyMovieClip("up_mc", button_container_mc.getNextHighestDepth());
		// draw rectangle
		DrawShapes.draw_rectangle(button_container_mc.up_mc, w, h, up_color, 100);
		DrawShapes.draw_rectangle(button_container_mc.over_mc, w, h, alt_color, 100);
		// create textfield and apply label
		var label_txt:TextField = button_container_mc.createTextField("label_txt", button_container_mc.getNextHighestDepth(), 0, 0, 0, 0);
		label_txt.multiline = false;
		label_txt.selectable = false;
		label_txt.autoSize = true;
		label_txt.html = true;
		label_txt.htmlText = label;
		label_txt.setTextFormat(copy_tf);
		// position label_txt
		label_txt._x = (button_container_mc._width - label_txt._width) / 2;
		label_txt._y = (button_container_mc._height - label_txt._height) / 2;
		return button_container_mc;
	}
}