﻿
import flash.filters.GlowFilter;

/**	contains static variables of textformat objects for use in the form
*	to change color, font, size etc regarding font in the contact form, change the values located in the constructor
*/
class bubblemonkey.form.FormSettings {
	
	public var column_label_tf:TextFormat;
	public var input_label_tf:TextFormat;
	public var columns_x_offset:Number;
	public var input_label_padding:Number;
	public var input_bg_color:Number;
	public var column_label_y_offset:Number;
	public var form_bg_color:Number;
	public var form_bg_alpha:Number;
	public var form_width:Number;
	public var form_height:Number;
	public var required_input_feedback:String;
	public var button_tf:TextFormat;
	public var button_bg_color:Number;
	public var isFormCentered_h:Boolean;
	public var isFormCentered_v:Boolean;
	public var button_offset:Number;
	public var button_alt_tf:TextFormat;
	public var button_alt_bg_color:Number;
	public var input_innerGlow:GlowFilter;
	public var input_errorGlow:GlowFilter;
	public var php_file:String;
	public var check_option_label_tf:TextFormat;
	public var check_option_tf:TextFormat;
	public var check_option_size:Number;
	public var list_label_tf:TextFormat;
	public var list_box_color:Number;
	public var list_box_color_alpha:Number;
	public var list_item_tf:TextFormat;
	public var box_highlight_color:Number;
	public var triangle_side:Number;
	public var list_item_alt_tf:TextFormat;
	public var clearAfterSend:Boolean;
	public var delay:Number;
	public var ms_bg_color:Number;
	public var ms_tf:TextFormat;
	public var ms_width:Number;
	public var ms_from:String;
	public var ms_isMasked:Boolean;
	public var copy_tf:TextFormat;
	
	/**	constructor
	*/
	public function FormSettings(settings_xmlNode:XMLNode) {
		var temp_str:String;
		// global settings
		form_width = Number(settings_xmlNode.childNodes[0].attributes.width);
		form_height = Number(settings_xmlNode.childNodes[0].attributes.height);
		isFormCentered_h = settings_xmlNode.childNodes[0].attributes.center_h == "y" ? true : false;
		isFormCentered_v = settings_xmlNode.childNodes[0].attributes.center_v == "y" ? true : false;
		temp_str = String(settings_xmlNode.childNodes[0].childNodes[0].childNodes[0].nodeValue);
		form_bg_color = temp_str != "" ? Number(settings_xmlNode.childNodes[0].childNodes[0].childNodes[0].nodeValue) : 0;
		form_bg_alpha = Number(settings_xmlNode.childNodes[0].childNodes[0].attributes.alpha);
		column_label_y_offset = Number(settings_xmlNode.childNodes[0].childNodes[1].childNodes[0].nodeValue);
		columns_x_offset = Number(settings_xmlNode.childNodes[0].childNodes[2].childNodes[0].nodeValue);
		input_label_padding = Number(settings_xmlNode.childNodes[0].childNodes[3].childNodes[0].nodeValue);
		input_bg_color = Number(settings_xmlNode.childNodes[0].childNodes[4].childNodes[0].nodeValue);
		required_input_feedback = String(settings_xmlNode.childNodes[0].childNodes[5].childNodes[0].nodeValue);
		php_file = String(settings_xmlNode.childNodes[0].childNodes[6].childNodes[0].nodeValue);
		// column label text format
		column_label_tf = new TextFormat();
		column_label_tf.font = String(settings_xmlNode.childNodes[1].childNodes[0].childNodes[0].nodeValue);
		column_label_tf.color = Number(settings_xmlNode.childNodes[1].childNodes[1].childNodes[0].nodeValue);
		column_label_tf.size = Number(settings_xmlNode.childNodes[1].childNodes[2].childNodes[0].nodeValue);
		// input label text format
		input_label_tf = new TextFormat();
		input_label_tf.font = String(settings_xmlNode.childNodes[2].childNodes[0].childNodes[0].nodeValue);
		input_label_tf.color = Number(settings_xmlNode.childNodes[2].childNodes[1].childNodes[0].nodeValue);
		input_label_tf.size = Number(settings_xmlNode.childNodes[2].childNodes[2].childNodes[0].nodeValue);
		if (String(settings_xmlNode.childNodes[2].childNodes[3].childNodes[0].nodeValue) != "") {
			// inner glow is set
			var color:Number = Number(settings_xmlNode.childNodes[2].childNodes[3].childNodes[0].nodeValue);
			input_innerGlow = new GlowFilter(color, 50, 5, 5, 10, 3, false, false);
		}
		if (String(settings_xmlNode.childNodes[2].childNodes[4].childNodes[0].nodeValue) != "") {
			// inner glow is set
			var color:Number = Number(settings_xmlNode.childNodes[2].childNodes[4].childNodes[0].nodeValue);
			input_errorGlow = new GlowFilter(color, 50, 5, 5, 10, 3, false, false);
		}
		// check and option box label text format
		check_option_label_tf = new TextFormat();
		check_option_label_tf.font = String(settings_xmlNode.childNodes[3].childNodes[0].childNodes[0].nodeValue);
		check_option_label_tf.color = Number(settings_xmlNode.childNodes[3].childNodes[1].childNodes[0].nodeValue);
		check_option_label_tf.size = Number(settings_xmlNode.childNodes[3].childNodes[2].childNodes[0].nodeValue);
		check_option_tf = new TextFormat();
		check_option_tf.font = String(settings_xmlNode.childNodes[3].childNodes[3].childNodes[0].nodeValue);
		check_option_tf.color = Number(settings_xmlNode.childNodes[3].childNodes[4].childNodes[0].nodeValue);
		check_option_tf.size = Number(settings_xmlNode.childNodes[3].childNodes[5].childNodes[0].nodeValue);
		check_option_size = Number(settings_xmlNode.childNodes[3].childNodes[6].childNodes[0].nodeValue);
		// drop down list settings
		list_label_tf = new TextFormat();
		list_label_tf.font = String(settings_xmlNode.childNodes[4].childNodes[0].childNodes[0].nodeValue);
		list_label_tf.color = Number(settings_xmlNode.childNodes[4].childNodes[1].childNodes[0].nodeValue);
		list_label_tf.size = Number(settings_xmlNode.childNodes[4].childNodes[2].childNodes[0].nodeValue);
		list_box_color = Number(settings_xmlNode.childNodes[4].childNodes[3].childNodes[0].nodeValue);
		list_box_color_alpha = Number(settings_xmlNode.childNodes[4].childNodes[3].attributes.alpha);
		list_item_tf = new TextFormat();
		list_item_tf.font = String(settings_xmlNode.childNodes[4].childNodes[4].childNodes[0].nodeValue);
		list_item_tf.color = Number(settings_xmlNode.childNodes[4].childNodes[5].childNodes[0].nodeValue);
		list_item_tf.size = Number(settings_xmlNode.childNodes[4].childNodes[6].childNodes[0].nodeValue);
		triangle_side = Number(settings_xmlNode.childNodes[4].childNodes[7].childNodes[0].nodeValue);
		list_item_alt_tf = new TextFormat(list_item_tf.font, list_item_tf.size, Number(settings_xmlNode.childNodes[4].childNodes[8].childNodes[0].nodeValue));
		box_highlight_color = Number(settings_xmlNode.childNodes[4].childNodes[9].childNodes[0].nodeValue);
		// read only text settings
		copy_tf = new TextFormat();
		copy_tf.font = String(settings_xmlNode.childNodes[5].childNodes[0].childNodes[0].nodeValue);
		copy_tf.color = Number(settings_xmlNode.childNodes[5].childNodes[1].childNodes[0].nodeValue);
		copy_tf.size = Number(settings_xmlNode.childNodes[5].childNodes[2].childNodes[0].nodeValue);
		// button settings
		button_tf = new TextFormat();
		button_tf.font = String(settings_xmlNode.childNodes[6].childNodes[0].childNodes[0].nodeValue);
		button_tf.color = Number(settings_xmlNode.childNodes[6].childNodes[1].childNodes[0].nodeValue);
		button_tf.size = Number(settings_xmlNode.childNodes[6].childNodes[2].childNodes[0].nodeValue);
		button_bg_color = Number(settings_xmlNode.childNodes[6].childNodes[3].childNodes[0].nodeValue);
		button_offset = Number(settings_xmlNode.childNodes[6].childNodes[4].childNodes[0].nodeValue);
		button_alt_tf = new TextFormat();
		button_alt_tf.font = button_tf.font;
		temp_str = String(settings_xmlNode.childNodes[6].childNodes[5].childNodes[0].nodeValue);
		button_alt_tf.color = temp_str != "" ? Number(settings_xmlNode.childNodes[6].childNodes[5].childNodes[0].nodeValue) : button_tf.color;
		button_alt_tf.size = button_tf.size;
		temp_str = String(settings_xmlNode.childNodes[6].childNodes[6].childNodes[0].nodeValue);
		button_alt_bg_color = temp_str != "" ? Number(settings_xmlNode.childNodes[6].childNodes[6].childNodes[0].nodeValue) : button_bg_color;
		// message sent settings
		clearAfterSend = settings_xmlNode.childNodes[7].attributes.clearAfterSend == "y" ? true : false;
		delay = Number(settings_xmlNode.childNodes[7].attributes.delay);
		ms_width = Number(settings_xmlNode.childNodes[7].attributes.width);
		ms_isMasked = settings_xmlNode.childNodes[7].attributes.isMasked == "y" ? true : false;
		switch (settings_xmlNode.childNodes[7].attributes.from) {
			// north
			case "n":
			ms_from = "n";
			break;
			// east
			case "e":
			ms_from = "e";
			break;
			// south
			case "s":
			ms_from = "s";
			break;
			// west
			case "w":
			ms_from = "w";
			break;
			// default case
			default:
			ms_from = "n";
			break;
		}
		ms_bg_color = Number(settings_xmlNode.childNodes[7].childNodes[0].childNodes[0].nodeValue);
		ms_tf = new TextFormat();
		ms_tf.font = String(settings_xmlNode.childNodes[7].childNodes[1].childNodes[0].nodeValue);
		ms_tf.color = Number(settings_xmlNode.childNodes[7].childNodes[2].childNodes[0].nodeValue);
		ms_tf.size = Number(settings_xmlNode.childNodes[7].childNodes[3].childNodes[0].nodeValue);
	}
}