﻿
import mx.transitions.*;
import mx.transitions.easing.*;
import bubblemonkey.utility.DrawShapes;
import bubblemonkey.utility.CreateMask;

class bubblemonkey.form.SpeechBox {
	
	private var parent_mc:MovieClip;
	private var msg:String;
	private var w:Number;
	private var x_offset:Number = 10;
	private var y_offset:Number = 10;
	private var intervalID:Number;
	private var copy_tf:TextFormat;
	private var bg_color:Number;
	private var msg_mc:MovieClip;
	private var final_x:Number;
	private var final_y:Number;
	private var tween:Tween;
	private var tween_speed:Number = 1;
	private var delay:Number;
	private var from:String;
	private var isMasked:Boolean;
	
	/**	class constructor
	*	input parameters:
	*	1. msg:String - the message to be displayed in the speechbox
	*	2. _w:Number - width of the speechbox
	*/
	public function SpeechBox(_parent_mc:MovieClip, _msg:String, _w:Number, _from:String, _isMasked:Boolean, _bg_color:Number, _copy_tf:TextFormat, _delay:Number) {
		// assignment
		parent_mc = _parent_mc;
		msg = _msg;
		w = _w;
		bg_color = _bg_color;
		copy_tf = _copy_tf;
		delay = _delay;
		from = _from;
		isMasked = _isMasked;
	}
	
	/**	builds speechbox, then hides it from view
	*	the height of the speechbox will be variable depending on msg height
	*	input parameters:
	* 	parent_mc:MovieClip - container movieclip inside which the speechbox will be built
	*	structure:
	*	parent_mc	- msg_mc	- copy_txt
	*/
	private function build_speechBox(parent_mc:MovieClip) {
		// create movieclip to contain message and okay button
		msg_mc = parent_mc.createEmptyMovieClip("msg_mc", parent_mc.getNextHighestDepth());
		// create text field to contain message
		var copy_txt:TextField = msg_mc.createTextField("copy_txt", msg_mc.getNextHighestDepth(), x_offset, y_offset, w - (x_offset * 2), 0);
		copy_txt.multiline = true;
		copy_txt.wordWrap = true;
		copy_txt.autoSize = true;
		copy_txt.html = true;
		copy_txt.setNewTextFormat(copy_tf);
		copy_txt.htmlText = msg;
		trace (msg_mc._height + ", workaround for a bug - please ignore");
		// create bg
		DrawShapes.draw_rectangle(msg_mc, w, msg_mc._height + (y_offset * 2), bg_color, 100);
		// set final cartesian coordinates for msg_mc
		final_x = (parent_mc._width - msg_mc._width) / 2;
		final_y = (parent_mc._height - msg_mc._height) / 2;
		// create mask
		if (isMasked) {
			var m:CreateMask = new CreateMask(msg_mc, "mask_speechbox_mc", true, parent_mc._width, parent_mc._height);
		}
		parent_mc.mask_speechbox_mc._x = parent_mc._x;
		parent_mc.mask_speechbox_mc._y = parent_mc._y;
		// hide from view
		switch (from) {
			// north
			case "n":
			msg_mc._x = final_x;
			msg_mc._y = parent_mc._y - msg_mc._height - y_offset;
			break;
			// east
			case "e":
			msg_mc._y = final_y;
			msg_mc._x = parent_mc._x + parent_mc._width + y_offset;
			break;
			// south
			case "s":
			msg_mc._x = final_x;
			msg_mc._y = parent_mc._y + parent_mc._height + y_offset;
			break;
			// west
			case "w":
			msg_mc._y = final_y;
			msg_mc._x = parent_mc._x - msg_mc._width - y_offset;
			break;
			// default case
			default:
			trace ("point of origin for sent message box unknown");
			break;
		}
	}
	
	/** show success
	*/
	public function show_speechBox() {
		// reference to this class
		var thisobj:SpeechBox = this;
		// build speechbox
		build_speechBox(parent_mc);
		// animate speechbox
		switch (from) {
			// north
			case "n":
			tween = new Tween(msg_mc, "_y", Regular.easeOut, msg_mc._y, final_y, tween_speed, true);
			break;
			// east
			case "e":
			tween = new Tween(msg_mc, "_x", Regular.easeOut, msg_mc._x, final_x, tween_speed, true);
			break;
			// south
			case "s":
			tween = new Tween(msg_mc, "_y", Regular.easeOut, msg_mc._y, final_y, tween_speed, true);
			break;
			// west
			case "w":
			tween = new Tween(msg_mc, "_x", Regular.easeOut, msg_mc._x, final_x, tween_speed, true);
			break;
			// default case
			default:
			trace ("point of origin for sent message box unknown");
			break;
		}
		tween.onMotionFinished = function() {
			thisobj.intervalID = setInterval(thisobj, "hide_speechBox", thisobj.delay*1000);
		}
	}
	
	/**	tween msg_mc out of view and then destroy it
	*/
	private function hide_speechBox() {
		// reference to this class
		var thisobj:SpeechBox = this;
		clearInterval(intervalID);
		// animate speechbox
		switch (from) {
			// north
			case "n":
			tween = new Tween(msg_mc, "_y", Regular.easeIn, msg_mc._y, parent_mc._y - msg_mc._height - y_offset, tween_speed, true);
			break;
			// east
			case "e":
			tween = new Tween(msg_mc, "_x", Regular.easeIn, msg_mc._x, parent_mc._x + parent_mc._width + y_offset, tween_speed, true);
			break;
			// south
			case "s":
			tween = new Tween(msg_mc, "_y", Regular.easeIn, msg_mc._y, parent_mc._y + parent_mc._height + y_offset, tween_speed, true);
			break;
			// west
			case "w":
			tween = new Tween(msg_mc, "_x", Regular.easeIn, msg_mc._x, parent_mc._x - msg_mc._width - y_offset, tween_speed, true);
			break;
			// default case
			default:
			trace ("point of origin for sent message box unknown");
			break;
		}
		tween.onMotionFinished = function() {
			thisobj.msg_mc.removeMovieClip();
		}
	}
}