﻿
import mx.transitions.*;
import mx.transitions.easing.*;
import flash.filters.GlowFilter;
import bubblemonkey.form.FormSettings;
import bubblemonkey.utility.DrawShapes;
import bubblemonkey.utility.AddTextField;
import bubblemonkey.array.FormElements;
import bubblemonkey.form.Validation;
import bubblemonkey.form.Checkbox;
import bubblemonkey.form.Optionbox;
import bubblemonkey.form.SpeechBox;
import bubblemonkey.form.CreateButton;
import bubblemonkey.utility.HitArea;

/**	applies a form based on xml input specified in xml_path (input parameter to the class constructor)
*/
class bubblemonkey.form.TwoDimensionalForm {
	
	private var parent_mc:MovieClip;
	private var form_container_mc:MovieClip;
	private var formSettings:FormSettings;
	private var this_column_mc:MovieClip;
	private var y_padding:Number;
	private var parent_height:Number;
	private var custom_tabIndex:Number = 0;
	private var elements_arr:Array;
	private var check_option_height:Number;
	private var formElements:FormElements;
	private var offset_bw_text_firstCheckOption:Number = 3;
	private var check_option_offset:Number = 4;
	private var label_offset:Number = 3;
	private var messageSent:SpeechBox;
	private var optionsValidated:Array;
	private var checksValidated:Array;

	/**	constructor
	*/
	public function TwoDimensionalForm(_parent_mc:MovieClip, xml_path:String, settings_xml_path:String) {
		// reference to this class
		var thisobj:TwoDimensionalForm = this;
		// declare stage properties
		Stage.align = "TL";
		Stage.scaleMode = "noScale";
		// assignment
		parent_mc = _parent_mc;
		parent_height = parent_mc._height;
		// initialize elements array
		elements_arr = new Array();
		optionsValidated = new Array();
		checksValidated = new Array();
		// create form container movieclip
		parent_mc.createEmptyMovieClip("form_container_mc", parent_mc.getNextHighestDepth());
		form_container_mc = parent_mc.form_container_mc;
		form_container_mc._x = 0;
		form_container_mc._y = 0;
		// handle form xml
		var form_xml:XML = new XML();
		form_xml.ignoreWhite = true;
		form_xml.onLoad = function(success:Boolean) {
			if (success) {
				// build form
				thisobj.build_form(form_xml.firstChild.childNodes[0]);
				thisobj.build_messageSent(form_xml.firstChild.childNodes[1]);
			}
			else {
				trace (xml_path + " failed to load");
			}
		}
		// handle settings xml
		var settings_xml:XML = new XML();
		settings_xml.ignoreWhite = true;
		settings_xml.onLoad = function(success:Boolean) {
			if (success) {
				// define form settings
				thisobj.formSettings = new FormSettings(settings_xml.firstChild);
				// load form xml
				form_xml.load(xml_path);
			}
			else {
				trace (settings_xml_path + " failed to load");
			}
		}
		settings_xml.load(settings_xml_path);
	}
	
	/**	build form
	*/
	private function build_form(form_xmlNode:XMLNode) {
		// draw background
		DrawShapes.draw_rectangle(parent_mc, formSettings.form_width, formSettings.form_height, formSettings.form_bg_color, formSettings.form_bg_alpha);
		// initialize column's x value
		var xPos:Number = 0;
		// loop through columns, building each one
		for (var i:Number = 0; i < form_xmlNode.childNodes.length; i++) {
			// create this column's container movieclip
			form_container_mc.createEmptyMovieClip("column_" + i + "_mc", form_container_mc.getNextHighestDepth());
			// set xPos
			if (i > 0) {
				xPos = form_container_mc["column_" + (i - 1) + "_mc"]._x + form_container_mc["column_" + (i - 1) + "_mc"]._width + formSettings.columns_x_offset;
			}
			// build this column
			build_column(form_container_mc["column_" + i + "_mc"], form_xmlNode.childNodes[i], xPos);
		}
		if (formSettings.isFormCentered_h) {
			// center the form horizontally
			form_container_mc._x = (parent_mc._width - form_container_mc._width) / 2;
		}
		if (formSettings.isFormCentered_v) {
			// center the form vertically
			form_container_mc._y = (parent_mc._height - form_container_mc._height) / 2;
		}
	}
	
	/**	build a column based on input xmlnode
	*/
	private function build_column(_this_column_mc:MovieClip, column_xmlNode:XMLNode, xPos:Number) {
		// assignment
		this_column_mc = _this_column_mc;
		this_column_mc._x = xPos;
		var column_width:Number = Number(column_xmlNode.attributes.width);
		var label_str:String = String(column_xmlNode.attributes.label);
		var y_offset:Number = Number(column_xmlNode.attributes.y_offset);
		// initialize this column's content y value
		var xPos:Number = 0;
		var yPos:Number = 0;
		if (label_str != "") {
			this_column_mc.createTextField("label_txt", this_column_mc.getNextHighestDepth(), 0, 0, 0, 0);
			this_column_mc.label_txt.autoSize = true;
			this_column_mc.label_txt.multiline = false;
			this_column_mc.label_txt.text = label_str;
			this_column_mc.label_txt.selectable = false;
			this_column_mc.label_txt.setTextFormat(formSettings.column_label_tf);
			yPos = this_column_mc.label_txt._height + formSettings.column_label_y_offset;
		}
		// loop through this column's children and build its content
		for (var i:Number = 0; i < column_xmlNode.childNodes.length; i++) {
			if (i > 0) {
				if (column_xmlNode.childNodes[i - 1].attributes.type == "button" && column_xmlNode.childNodes[i].attributes.type == "button") {
					xPos += Number(column_xmlNode.childNodes[i - 1].attributes.width) + formSettings.button_offset;
				}
				else if (column_xmlNode.childNodes[i - 1].attributes.type == "check" || column_xmlNode.childNodes[i - 1].attributes.type == "option") {
					xPos = 0;
					yPos += check_option_height + y_offset;
				}
				else if (column_xmlNode.childNodes[i - 1].attributes.type == "list") {
					xPos = 0;
					yPos += check_option_height + y_offset;
				}
				else if (column_xmlNode.childNodes[i - 1].attributes.type == "copy") {
					xPos = 0;
					yPos += check_option_height + y_offset;
				}
				else {
					// reset xPos, update yPos
					xPos = 0;
					yPos += Number(column_xmlNode.childNodes[i - 1].attributes.height) + y_offset;
				}
			}
			build_input(column_xmlNode.childNodes[i], xPos, yPos, column_width);
		}
	}
	
	/**	build input type
	*/
	private function build_input(input_xmlNode:XMLNode, x:Number, y:Number, w:Number) {
		// is this input required
		var isRequired:Boolean = false;
		if (String(input_xmlNode.attributes.required) == "y") {
			isRequired = true;
		}
		var h:Number = Number(input_xmlNode.attributes.height);
		// build input based on type
		switch (input_xmlNode.attributes.type) {
			// single-line text
			case "text":
			build_input_text(isRequired, input_xmlNode.childNodes[0].nodeValue, y, w, h);
			break;
			// email
			case "email":
			build_input_email(isRequired, input_xmlNode.childNodes[0].nodeValue, y, w, h);
			break;
			// multi-line text
			case "multi":
			build_input_multi(isRequired, input_xmlNode.childNodes[0].nodeValue, y, w, h);
			break;
			// checkbox
			case "check":
			build_input_check(input_xmlNode, y, w, h);
			break;
			// optionbox
			case "option":
			build_input_option(input_xmlNode, y, w, h);
			break;
			// dropdownlist
			case "list":
			build_input_list(input_xmlNode, y, w, h);
			break;
			// read only copy
			case "copy":
			build_copy(input_xmlNode.childNodes[0].nodeValue, y, w, h);
			break;
			// button
			case "button":
			w = Number(input_xmlNode.attributes.width);
			h = Number(input_xmlNode.attributes.height);
			build_input_button(input_xmlNode.attributes.action, x, y, w, h, input_xmlNode.childNodes[0].nodeValue);
			break;
		}
	}
	
	/**	build text type input
	*/
	private function build_input_text(isRequired:Boolean, label:String, y:Number, w:Number, h:Number) {
		// create input background
		var temp_mc:MovieClip = this_column_mc.createEmptyMovieClip("input_" + label + "_mc", this_column_mc.getNextHighestDepth());
		temp_mc._x = 0;
		temp_mc._y = y;
		// draw rectangle
		DrawShapes.draw_rectangle(temp_mc, w, h, formSettings.input_bg_color, 100);
		// set input label
		var temp_txt:TextField = temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		temp_txt.setNewTextFormat(formSettings.input_label_tf);
		temp_txt.type = "input";
		apply_tabIndex(temp_txt);
		temp_txt.multiline = false;
		temp_txt.autoSize = true;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;
		// add this element to array
		formElements = new FormElements();
		formElements.type = "text";
		formElements.txtField = temp_txt;
		formElements.label = label;
		formElements.isRequired = isRequired;
		elements_arr.push(formElements);
		// position label in the middle vertically and set its x value to be the same as y
		temp_txt._x = formSettings.input_label_padding;
		temp_txt._y = (temp_mc._height - temp_txt._height) / 2;
		y_padding = temp_txt._y;
		temp_txt.autoSize = false;
		temp_txt._width = temp_mc._width - (temp_txt._x * 2);
		// handle onSetFocus and onKillFocus events
		handle_input_focus(temp_txt, label);
	}
	
	/** build email type input
	*/
	private function build_input_email(isRequired:Boolean, label:String, y:Number, w:Number, h:Number) {
		// create input background
		this_column_mc.createEmptyMovieClip("input_" + label + "_mc", this_column_mc.getNextHighestDepth());
		// draw input background
		var temp_mc:MovieClip = this_column_mc["input_" + label + "_mc"];
		temp_mc._x = 0;
		temp_mc._y = y;
		temp_mc.clear();
		// draw rectangle
		DrawShapes.draw_rectangle(temp_mc, w, h, formSettings.input_bg_color, 100);
		// set input label
		temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		var temp_txt:TextField = temp_mc.label_txt;
		temp_txt.setNewTextFormat(formSettings.input_label_tf);
		temp_txt.type = "input";
		apply_tabIndex(temp_txt);
		temp_txt.multiline = false;
		temp_txt.autoSize = true;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;
		// add this element to array
		formElements = new FormElements();
		formElements.type = "email";
		formElements.txtField = temp_txt;
		formElements.label = label;
		formElements.isRequired = isRequired;
		elements_arr.push(formElements);
		// position label in the middle vertically and set its x value to be the same as y
		temp_txt._x = formSettings.input_label_padding;
		temp_txt._y = (temp_mc._height - temp_txt._height) / 2;
		y_padding = temp_txt._y;
		temp_txt.autoSize = false;
		temp_txt._width = temp_mc._width - (temp_txt._x * 2);
		// handle onSetFocus and onKillFocus events
		handle_input_focus(temp_txt, label);
	}
	
	/** build multi-line text input
	*/
	private function build_input_multi(isRequired:Boolean, label:String, y:Number, w:Number, h:Number) {
		// create input background
		this_column_mc.createEmptyMovieClip("input_" + label + "_mc", this_column_mc.getNextHighestDepth());
		// draw input background
		var temp_mc:MovieClip = this_column_mc["input_" + label + "_mc"];
		temp_mc._x = 0;
		temp_mc._y = y;
		// draw rectangle
		DrawShapes.draw_rectangle(temp_mc, w, h, formSettings.input_bg_color, 100);
		// set input label
		temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		var temp_txt:TextField = temp_mc.label_txt;
		temp_txt.setNewTextFormat(formSettings.input_label_tf);
		temp_txt.type = "input";
		apply_tabIndex(temp_txt);
		temp_txt.multiline = true;
		temp_txt.wordWrap = true;
		temp_txt.autoSize = true;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;
		// add this element to array
		formElements = new FormElements();
		formElements.type = "text";
		formElements.txtField = temp_txt;
		formElements.label = label;
		formElements.isRequired = isRequired;
		elements_arr.push(formElements);
		// position label in the middle vertically and set its x value to be the same as y
		temp_txt._x = formSettings.input_label_padding;
		temp_txt._y = y_padding != "" ? y_padding : formSettings.input_label_padding;
		temp_txt.autoSize = false;
		temp_txt._width = temp_mc._width - (temp_txt._x * 2);
		temp_txt._height = temp_mc._height - (temp_txt._y * 2);
		// handle onSetFocus and onKillFocus events
		handle_input_focus(temp_txt, label);
	}
	
	/** build checkbox input
	*/
	private function build_input_check(check_xmlNode:XMLNode, y:Number, w:Number, h:Number):Void {
		// assignment
		var label:String = check_xmlNode.childNodes[0].childNodes[0].nodeValue;
		var isRequired:Boolean = check_xmlNode.attributes.required == "y" ? true : false;
		// create movieclip
		var temp_mc = this_column_mc.createEmptyMovieClip("checkbox_" + label + "_mc", this_column_mc.getNextHighestDepth());
		// draw input background
		temp_mc._x = 0;
		temp_mc._y = y;
		// create checkbox label
		temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		var temp_txt:TextField = temp_mc.label_txt;
		temp_txt.setNewTextFormat(formSettings.check_option_label_tf);
		temp_txt._width = w;
		temp_txt.multiline = true;
		temp_txt.wordWrap = true;
		temp_txt.autoSize = true;
		temp_txt.selectable = false;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;
		trace (temp_txt._height + " - this is a workaround for a bug - please ignore");
		// loop through the xmlnode, adding each item to an array
		var check_item_arr:Array = new Array();
		var items_xmlNode:XMLNode = new XMLNode();
		items_xmlNode = check_xmlNode.childNodes[1];
		// create movieclip
		temp_mc.createEmptyMovieClip("checkboxes_" + label + "_mc", temp_mc.getNextHighestDepth());
		var checkboxes_mc:MovieClip = temp_mc["checkboxes_" + label + "_mc"];
		checkboxes_mc._y = temp_txt._height + offset_bw_text_firstCheckOption;
		var yPos:Number = 0;
		for (var i:Number = 0; i < items_xmlNode.childNodes.length; i++) {
			// increment yPos for when i is greater than 0
			if (i > 0) {
				yPos = checkboxes_mc["box_container_" + (i - 1) + "_mc"]._y + checkboxes_mc["box_container_" + (i - 1) + "_mc"]._height + check_option_offset;
			}
			// create movieclip for each checkbox
			var box_container_mc:MovieClip = checkboxes_mc.createEmptyMovieClip("box_container_" + i + "_mc", checkboxes_mc.getNextHighestDepth());
			box_container_mc._y = yPos;
			// create large rectangle
			var largebox_mc:MovieClip = box_container_mc.createEmptyMovieClip("largebox_mc", box_container_mc.getNextHighestDepth());
			DrawShapes.draw_square(largebox_mc, formSettings.check_option_size, formSettings.input_bg_color, 100);
			// create middle (smaller) rectangle
			var middlebox_mc:MovieClip = box_container_mc.createEmptyMovieClip("middlebox_mc", box_container_mc.getNextHighestDepth());
			DrawShapes.draw_square(middlebox_mc, formSettings.check_option_size / 2, formSettings.input_label_tf.color, 100);
			middlebox_mc._x = (largebox_mc._width - middlebox_mc._width) / 2;
			middlebox_mc._y = (largebox_mc._height - middlebox_mc._height) / 2;
			var max_label_width:Number = w - (largebox_mc._x + largebox_mc._width + label_offset);
			box_container_mc.createTextField("label_txt", box_container_mc.getNextHighestDepth(), largebox_mc._x + largebox_mc._width + label_offset, 0, max_label_width, 0);
			box_container_mc.label_txt.setNewTextFormat(formSettings.check_option_tf);
			box_container_mc.label_txt.multiline = false;
			box_container_mc.label_txt.wordWrap = true;
			box_container_mc.label_txt.autoSize = true;
			box_container_mc.label_txt.selectable = false;
			box_container_mc.label_txt.text = items_xmlNode.childNodes[i].childNodes[0].nodeValue;
			box_container_mc.label_txt._y = (largebox_mc._height - box_container_mc.label_txt._height) / 2;
			// instantiate checkbox
			var checkbox:Checkbox = new Checkbox(box_container_mc);
			// add this element to elements array
			formElements = new FormElements();
			formElements.type = "check";
			// group label
			formElements.txtField = temp_txt;
			// current checkbox label
			formElements.label = box_container_mc.label_txt.text;
			formElements.isRequired = isRequired;
			formElements.mc = middlebox_mc;
			elements_arr.push(formElements);			
		}
		// store this check group height
		check_option_height = temp_mc._height;
	}
	
	/** build optionbox input
	*/
	private function build_input_option(option_xmlNode:XMLNode, y:Number, w:Number, h:Number) {
		// assignment
		var label:String = option_xmlNode.childNodes[0].childNodes[0].nodeValue;
		var isRequired:Boolean = option_xmlNode.attributes.required == "y" ? true : false;
		// create movieclip
		var temp_mc:MovieClip = this_column_mc.createEmptyMovieClip("optionbox" + label + "_mc", this_column_mc.getNextHighestDepth());
		// draw input background
		temp_mc._x = 0;
		temp_mc._y = y;
		// create checkbox label
		temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		var temp_txt:TextField = temp_mc.label_txt;
		temp_txt.setNewTextFormat(formSettings.check_option_label_tf);
		temp_txt._width = w;
		temp_txt.multiline = true;
		temp_txt.wordWrap = true;
		temp_txt.autoSize = true;
		temp_txt.selectable = false;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;	
		trace (temp_txt._height + " - this is a workaround for a bug - please ignore");
		// loop through the xmlnode, adding each item to an array
		var option_item_arr:Array = new Array();
		var items_xmlNode:XMLNode = new XMLNode();
		items_xmlNode = option_xmlNode.childNodes[1];
		// create movieclip
		var optionboxes_mc:MovieClip = temp_mc.createEmptyMovieClip("optionboxes" + label + "_mc", temp_mc.getNextHighestDepth());
		// instantiate optionbox class
		var optionbox:Optionbox = new Optionbox();
		// place optionbox container
		optionboxes_mc._y = temp_txt._height + offset_bw_text_firstCheckOption;
		var yPos:Number = 0;
		for (var i:Number = 0; i < items_xmlNode.childNodes.length; i++) {
			// increment yPos for when i is greater than 0
			if (i > 0) {
				yPos = optionboxes_mc["option_container_" + (i - 1) + "_mc"]._y + optionboxes_mc["option_container_" + (i - 1) + "_mc"]._height + check_option_offset;
			}
			// create movieclip for each checkbox
			var option_container_mc:MovieClip = optionboxes_mc.createEmptyMovieClip("option_container_" + i + "_mc", optionboxes_mc.getNextHighestDepth());
			option_container_mc._y = yPos;
			// create large rectangle
			var largecircle_mc:MovieClip = option_container_mc.createEmptyMovieClip("largecircle_mc", option_container_mc.getNextHighestDepth());
			var radius:Number = formSettings.check_option_size / 2;
			DrawShapes.draw_circle(largecircle_mc, radius, radius, radius, formSettings.input_bg_color);
			// create middle (smaller) rectangle
			var middlecircle_mc:MovieClip = option_container_mc.createEmptyMovieClip("middlecircle_mc", option_container_mc.getNextHighestDepth());
			DrawShapes.draw_circle(middlecircle_mc, radius / 2, radius / 2, radius / 2, formSettings.input_label_tf.color);
			middlecircle_mc._x = (largecircle_mc._width - middlecircle_mc._width) / 2;
			middlecircle_mc._y = (largecircle_mc._height - middlecircle_mc._height) / 2;
			var max_label_width:Number = w - (largecircle_mc._x + largecircle_mc._width + label_offset);
			option_container_mc.createTextField("label_txt", option_container_mc.getNextHighestDepth(), largecircle_mc._x + largecircle_mc._width + label_offset, 0, max_label_width, 0);
			option_container_mc.label_txt.setNewTextFormat(formSettings.check_option_tf);
			option_container_mc.label_txt.multiline = false;
			option_container_mc.label_txt.wordWrap = true;
			option_container_mc.label_txt.autoSize = true;
			option_container_mc.label_txt.selectable = false;
			option_container_mc.label_txt.text = items_xmlNode.childNodes[i].childNodes[0].nodeValue;
			// position label in the middle of largecircle_mc
			option_container_mc.label_txt._y = (largecircle_mc._height - option_container_mc.label_txt._height) / 2;
			// add this optionbox to the optionbox class
			optionbox.add_option(option_container_mc);
			// add this element to elements array
			formElements = new FormElements();
			formElements.type = "option";
			// group label
			formElements.txtField = temp_txt;
			// current checkbox label
			formElements.label = option_container_mc.label_txt.text;
			formElements.isRequired = isRequired;
			formElements.mc = middlecircle_mc;
			elements_arr.push(formElements);
		}
		// store this option group height
		check_option_height = temp_mc._height;
	}
	
	/** builds drop down list input
	*/
	private function build_input_list(list_xmlNode:XMLNode, y:Number, w:Number, h:Number) {
		// reference to this class
		var thisobj:TwoDimensionalForm = this;
		// assignment
		var label:String = list_xmlNode.childNodes[0].childNodes[0].nodeValue;
		var isRequired:Boolean = list_xmlNode.attributes.required == "y" ? true : false;
		var items_xmlNode:XMLNode = list_xmlNode.childNodes[1];
		// create movieclip and position it
		var temp_mc:MovieClip = this_column_mc.createEmptyMovieClip("list_" + label + "_mc", this_column_mc.getNextHighestDepth());
		temp_mc._x = 0;
		temp_mc._y = y;
		// create label
		var temp_txt:TextField = temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		temp_txt.setNewTextFormat(formSettings.list_label_tf);
		temp_txt._width = w;
		temp_txt.multiline = true;
		temp_txt.wordWrap = true;
		temp_txt.autoSize = true;
		temp_txt.selectable = false;
		temp_txt.html = true;
		if (isRequired) {
			label += formSettings.required_input_feedback;
		}
		temp_txt.htmlText = label;	
		trace (temp_txt._height + " - this is a workaround for a bug - please ignore");
		// movieclip that will contain currently selected item
		var selected_item_mc:MovieClip = temp_mc.createEmptyMovieClip("selected_item_" + label + "_mc", temp_mc.getNextHighestDepth());
		selected_item_mc._y = temp_txt._height + offset_bw_text_firstCheckOption;
		// draw background for selected item movieclip
		DrawShapes.draw_rectangle(selected_item_mc, w, h, formSettings.list_box_color, 100);
		// create text that will contain currently selected item, assign its value and position it in the middle of selected item movieclip's box
		var selected_item_txt:TextField = selected_item_mc.createTextField("copy_txt", selected_item_mc.getNextHighestDepth(), 0, 0, 0, 0);
		selected_item_txt.html = true;
		selected_item_txt.multiline = false;
		selected_item_txt.autoSize = true;
		selected_item_txt.selectable = false;
		selected_item_txt.setNewTextFormat(formSettings.list_item_tf);
		selected_item_txt.htmlText = items_xmlNode.childNodes[0].childNodes[0].nodeValue;
		selected_item_txt._x = formSettings.input_label_padding;
		selected_item_txt._y = (selected_item_mc._height - selected_item_txt._height) / 2;
		// create inverted triangle to activate drop down list
		var triangle_mc:MovieClip = selected_item_mc.createEmptyMovieClip("triangle_mc", selected_item_mc.getNextHighestDepth());
		DrawShapes.draw_inverted_isosceles_triangle(triangle_mc, formSettings.triangle_side, formSettings.list_item_tf.color, 100);
		triangle_mc._x = selected_item_mc._width - triangle_mc._width - selected_item_txt._x;
		triangle_mc._y = (selected_item_mc._height - triangle_mc._height) / 2;
		// create items container
		var items_container_mc:MovieClip = temp_mc.createEmptyMovieClip("items_container_mc", temp_mc.getNextHighestDepth());
		items_container_mc._y = selected_item_mc._y + selected_item_mc._height;
		// reset y for use in the items building
		y = 0;
		// movieclip to contain one list item
		var list_item_mc:MovieClip;
		// selected item feedback rectangle
		var selected_rectangle_mc:MovieClip = items_container_mc.createEmptyMovieClip("selected_rectangle_mc", items_container_mc.getNextHighestDepth());
		DrawShapes.draw_rectangle(selected_rectangle_mc, w, selected_item_txt._height, formSettings.box_highlight_color, 100);
		selected_rectangle_mc._alpha = 0;
		// clear selected item
		selected_item_txt.text = "";
		// add this element to array
		formElements = new FormElements();
		formElements.type = "list";
		formElements.txtField = selected_item_txt;
		formElements.label = label;
		formElements.isRequired = isRequired;
		formElements.mc = items_container_mc;
		elements_arr.push(formElements);
		// copy textfield
		var copy_txt:TextField;
		// generate drop down list from the xmlnode input
		for (var i:Number = 0; i < items_xmlNode.childNodes.length; i++) {
			// create a list item
			list_item_mc = items_container_mc.createEmptyMovieClip("list_item_" + i + "_mc", items_container_mc.getNextHighestDepth());
			list_item_mc._y = y;
			copy_txt = list_item_mc.createTextField("copy_txt", list_item_mc.getNextHighestDepth(), formSettings.input_label_padding, 0, 0, 0);
			copy_txt.html = true;
			copy_txt.autoSize = true;
			copy_txt.selectable = false;
			copy_txt.htmlText = items_xmlNode.childNodes[i].childNodes[0].nodeValue;
			copy_txt.setTextFormat(formSettings.list_item_tf);
			// create hit area
			HitArea.create_hitArea(list_item_mc, "hit_list_item_" + i + "_mc", true, w, list_item_mc._height);
			// handle tactile
			handle_list_tactile(list_item_mc, selected_rectangle_mc, items_container_mc, selected_item_txt);
			// update yPos
			y += list_item_mc._height;
		}
		// initialize items container's visibility
		items_container_mc._visible = false;
		// draw box
		DrawShapes.draw_rectangle(items_container_mc, w, items_container_mc._height, formSettings.list_box_color, formSettings.list_box_color_alpha);
		// handle triangle onRelease events
		selected_item_mc.onRelease = function() {
			if (items_container_mc._visible == false) {
				items_container_mc._visible = true;
				temp_mc.swapDepths(temp_mc._parent.getNextHighestDepth() - 1);
				items_container_mc.filters = [thisobj.formSettings.input_innerGlow];
			}
			else {
				items_container_mc._visible = false;
				items_container_mc.filters = [];
			}
		}
		selected_item_mc.onKillFocus = function() {
			items_container_mc._visible = false;
			items_container_mc.filters = [];
		}
		// store this option group height
		check_option_height = temp_txt._height + offset_bw_text_firstCheckOption + selected_item_mc._height;
	}
	
	/** builds read only text
	*/
	private function build_copy(label:String, y:Number, w:Number, h:Number) {
		// create movieclip and position it
		var temp_mc:MovieClip = this_column_mc.createEmptyMovieClip("copy" + label + "_mc", this_column_mc.getNextHighestDepth());
		temp_mc._x = 0;
		temp_mc._y = y;
		// create label
		var temp_txt:TextField = temp_mc.createTextField("label_txt", temp_mc.getNextHighestDepth(), 0, 0, 0, 0);
		temp_txt._width = w;
		temp_txt.setNewTextFormat(formSettings.copy_tf);
		temp_txt.multiline = true;
		temp_txt.wordWrap = true;
		temp_txt.autoSize = true;
		temp_txt.selectable = true;
		temp_txt.html = true;
		temp_txt.htmlText = label;
		trace (temp_txt._height + " - this is a workaround for a bug - please ignore");
		// store this option group height
		check_option_height = temp_mc._height;
	}
		
	/** build button
	*/
	private function build_input_button(action:String, x:Number, y:Number, w:Number, h:Number, label:String):Void {
		// create button
		var button_mc:MovieClip = CreateButton.create(this_column_mc, label, x, y, w, h, formSettings.button_bg_color, formSettings.button_alt_bg_color, formSettings.button_tf);
		// handle button feedback
		handle_tactile(button_mc);
		switch (action) {
			// clear
			case "clear":
			handle_clear(button_mc);
			break;
			// submit
			case "submit":
			handle_submit(button_mc);
			break;
		}
	}
	
	/** handles list item feedback
	*/
	private function handle_list_tactile(mc:MovieClip, selected_rectangle_mc:MovieClip, items_container_mc:MovieClip, selected_item_txt:TextField):Void {
		// reference to this class
		var thisobj:TwoDimensionalForm = this;
		// handle on rollover event
		mc.onRollOver = function() {
			selected_rectangle_mc._y = this._y;
			selected_rectangle_mc._alpha = 100;
			this.copy_txt.setTextFormat(thisobj.formSettings.list_item_alt_tf);
		}
		mc.onRollOut = function() {
			selected_rectangle_mc._alpha = 0;
			this.copy_txt.setTextFormat(thisobj.formSettings.list_item_tf);
		}
		mc.onRelease = function() {
			items_container_mc._visible = false;
			selected_item_txt.text = this.copy_txt.text;
			items_container_mc.filters = [];
		}
	}
	
	/** handle button feedback to onrollover and onrollout events
	*/
	private function handle_tactile(mc:MovieClip):Void {
		// reference to this class
		var thisobj:TwoDimensionalForm = this;
		// onrollover event
		mc.onRollOver = function() {
			// set alternate text format
			this.label_txt.setTextFormat(thisobj.formSettings.button_alt_tf);
			this.up_mc._alpha = 0;
		}
		// onrollout event
		mc.onRollOut = function() {
			// reset text format
			this.label_txt.setTextFormat(thisobj.formSettings.button_tf);
			this.up_mc._alpha = 100;
		}
	}
	
	/**	handle clear onrelease event
	*/
	private function handle_clear(mc:MovieClip) {
		var thisobj:TwoDimensionalForm = this;
		mc.onRelease = function() {
			thisobj.clear_form();
		}
	}
	
	/** handle submit onrelease event
	*/
	private function handle_submit(mc:MovieClip) {
		var thisobj:TwoDimensionalForm = this;
		mc.onRelease = function() {
			thisobj.send_form();
		}
	}
	
	/** clear the form
	*/
	private function clear_form() {
		// reference to the textfield's parent movieclip
		var mc:MovieClip;
		// remove focus
		Selection.setFocus(null);
		// go through the form, clearing the text-type inputs
		for (var i:Number = 0; i < elements_arr.length; i++) {
			if (elements_arr[i].type == "text" || elements_arr[i].type == "email") {
				elements_arr[i].txtField.text = elements_arr[i].label;
				elements_arr[i].txtField._parent.filters = [];
				mc = elements_arr[i].txtField._parent;
			}
			else if (elements_arr[i].type == "check" || elements_arr[i].type == "option") {
				elements_arr[i].mc._alpha = 0;
				elements_arr[i].txtField.filters = [];
			}
			else if (elements_arr[i].type == "list") {
				elements_arr[i].txtField.text = "";
				elements_arr[i].txtField._parent.filters = [];
				elements_arr[i].mc._visible = false;
			}
		}
	}
	
	/** send the form after validation
	*/
	private function send_form() {
		clear_filter();
		// create loadvars object
		var send_lv:LoadVars = new LoadVars();
		// if form is valid, loop through the elements array and store its values in our loadvars object, then send
		// remove focus
		Selection.setFocus(null);
		if (isFormValid()) {
			// loop through the elements array
			for (var i:Number = 0; i < elements_arr.length; i++) {
				if (elements_arr[i].type == "check" || elements_arr[i].type == "option") {
					send_lv["type_" + i] = elements_arr[i].type;
					send_lv["label_" + i] = elements_arr[i].label;
					send_lv["value_" + i] = elements_arr[i].get_state() == true ? "true" : "false";
					send_lv["group_label_" + i] = elements_arr[i].txtField.text;
				}
				else {
					send_lv["type_" + i] = elements_arr[i].type;
					send_lv["label_" + i] = elements_arr[i].label;
					send_lv["value_" + i] = elements_arr[i].txtField.text;
				}
			}
			send_lv.total = elements_arr.length;
			send_lv.sendAndLoad(formSettings.php_file, send_lv, "POST");
			// show success feedback
			messageSent.show_speechBox();
			// clear after send
			if (formSettings.clearAfterSend) {
				clear_form();
			}
		}
		else {
			// show error feedback
		}
	}
	
	private function clear_filter() {
		for (var i:Number = 0; i < elements_arr.length; i++) {
			if (elements_arr[i].type == "text" || elements_arr[i].type == "email") {
				elements_arr[i].txtField._parent.filters = [];
			}
			else if (elements_arr[i].type == "check" || elements_arr[i].type == "option") {
				elements_arr[i].txtField.filters = [];
			}
			else if (elements_arr[i].type == "list") {
				elements_arr[i].txtField._parent.filters = [];
			}
		}
	}
	
	private function isFormValid():Boolean {
		// instrument of validity checking
		var isFormValid:Boolean = true;
		// loop through elements array, validating each input
		for (var i:Number = 0; i < elements_arr.length; i++) {
			if (elements_arr[i].isRequired == true) {
				if (elements_arr[i].type == "email" && Validation.check_email(elements_arr[i].txtField.text) == false) {
					isFormValid = false;
					elements_arr[i].txtField._parent.filters = [formSettings.input_errorGlow];
				}
				else if (elements_arr[i].type == "text" && elements_arr[i].txtField.text == "") {
					isFormValid = false;
					elements_arr[i].txtField._parent.filters = [formSettings.input_errorGlow];
				}
				else if (elements_arr[i].type == "text" && elements_arr[i].txtField.text == elements_arr[i].label) {
					isFormValid = false;
					elements_arr[i].txtField._parent.filters = [formSettings.input_errorGlow];
				}
				else if (elements_arr[i].type == "list" && elements_arr[i].txtField.text == "") {
					isFormValid = false;
					elements_arr[i].txtField._parent.filters = [formSettings.input_errorGlow];
				}
				else if (elements_arr[i].type == "option" && isOptionSelected(elements_arr[i].txtField.text) == false) {
					isFormValid = false;
					elements_arr[i].txtField.filters = [formSettings.input_errorGlow];
				}
				else if (elements_arr[i].type == "check" && isCheckSelected(elements_arr[i].txtField.text) == false) {
					isFormValid = false;
					elements_arr[i].txtField.filters = [formSettings.input_errorGlow];
				}
			}
		}
		return isFormValid;
	}

	/**
	 * Returns true if at least one radio button is selected
	 */
	public function isOptionSelected(txtField:String):Boolean {
		var isSelected:Boolean = false;
		// go through the form, looking for the label specified.
		for (var i:Number = 0; i < elements_arr.length; i++) {
			if (elements_arr[i].type == "option" && elements_arr[i].txtField.text == txtField) {
				// if one is true then return, means the element group is valid.
				if (elements_arr[i].get_state() == true) {
					optionsValidated[txtField] = true;
					return true;
				}
			}
		}
		return isSelected;
	}

	/**
	 * Returns true if at least one check box is selected
	 */
	public function isCheckSelected(txtField:String):Boolean {
		var isSelected:Boolean = false;
		// go through the form, looking for the label specified.
		for (var i:Number = 0; i < elements_arr.length; i++) {
			if (elements_arr[i].type == "check" && elements_arr[i].txtField.text == txtField) {
				// if one is true then return, means the element group is valid.
				if (elements_arr[i].get_state() == true) {
					checksValidated[txtField] = true;
					return true;
				}
			}
		}
		return isSelected;
	}
	
	/**	build message sent information
	*/
	private function build_messageSent(ms_xmlNode:XMLNode) {
		var ms_sent:String = ms_xmlNode.firstChild.nodeValue;
		// create message sent object
		messageSent = new SpeechBox(form_container_mc, ms_sent, formSettings.ms_width, formSettings.ms_from, formSettings.ms_isMasked, formSettings.ms_bg_color, formSettings.ms_tf, formSettings.delay);
	}
	
	/** handle input focus
	*/
	private function handle_input_focus(txt:TextField, original_label:String) {
		// reference to the movieclip
		var mc:MovieClip = txt._parent;
		// reference to this class
		var thisobj:TwoDimensionalForm = this;
		// handle onSetFocus
		txt.onSetFocus = function() {
			mc.filters = [thisobj.formSettings.input_innerGlow];
			if (this.text == original_label) {
				this.text = "";
			}
		}
		// handle onKillFocus
		txt.onKillFocus = function() {
			mc.filters = [];
			if (this.text == "") {
				this.text = original_label;
			}
		}
	}
	
	/** apply tab index to textfield and increments it by one
	*/
	private function apply_tabIndex(txt:TextField) {
		txt.tabIndex = custom_tabIndex;
		custom_tabIndex++;
	}
}