﻿
class bubblemonkey.form.Validation {
	
	/** empty contructor
	*/
	public function Validation() {
		trace ("Validation is a static class and should not be instantiated");
	}
	
	/** validates email addresses
	*	input parameter(s):
	*	1. email_str:String - email address
	*	conditions for validity:
	*	1. email string does not contain spaces
	*	2. email string contains exactly one '@' symbol
	*	3. email string contains a '.' character after the '@' symbol
	*	4. there it at least two characters after '.'
	*/
	public static function check_email(email_str:String):Boolean {
		var return_value:Boolean = true;
		// check for spaces
		if (email_str.indexOf(" ") > 0) {
			return_value = false;
		}
		// place the content of the email address into an array
		var emailArray:Array = email_str.split("@");
		// make sure there's exactly one @ symbol and there's at least one character before and after the @
		if (emailArray.length != 2 || emailArray[0].length == 0 || emailArray[1].length == 0) {
			return_value = false;
		}
		// check for a . character after the @
		var postArray:Array = emailArray[1].split(".");
		if (postArray.length < 2) {
			return_value = false;
		}
		for (var i:Number = 0; i < postArray.length; i++) {
			if (postArray[i].length < 1) {
				return_value = false;
			}
		}
		// country level domain needs to have at least one character
		var suffix = postArray[postArray.length - 1];
		if (suffix.length < 1) {
			return_value = false;
		}
		return return_value;
	}
}