﻿
class bubblemonkey.utility.Masking {
	
	/** empty constructor
	*/
	public function Masking() {
		trace ("Masking is a static class and should not be instantiated");
	}
	
	/** creates a mask in the exact location of the target movieclip
	*	returns a reference to said mask
	*/
	public static function create_mask(mc:MovieClip, mask_name:String, useFixedWidth:Boolean, w:Number, h:Number):MovieClip {
		var parent_mc :MovieClip= mc._parent;
		parent_mc.createEmptyMovieClip(mask_name, parent_mc.getNextHighestDepth());
		var mask_mc:MovieClip = parent_mc[mask_name];
		// decide whether to use fixed width and height or the mc's dimensions
		w = useFixedWidth ? w : mc._width;
		h = useFixedWidth ? h : mc._height;
		// use the flash drawing API to draw the mask
		mask_mc.clear();
		mask_mc.beginFill(0x000000, 0);
		mask_mc.moveTo(0, 0);
		mask_mc.lineTo(w, 0);
		mask_mc.lineTo(w, h);
		mask_mc.lineTo(0, h);
		mask_mc.endFill();
		mask_mc._x = mc._x;
		mask_mc._y = mc._y;
		mc.setMask(mask_mc);
		return mask_mc;
	}
}