<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Geodesic Solutions Support Tools</title>
	
	<style type="text/css">
		p.note {
				text-align: left; 
				border: 1px solid #DDD; 
				background-color: #F5F5F5; 
				margin: 5px 0 10px 0; 
				padding: 3px;
				font-family: Arial,Helvetica, sans-serif;
				font-size:8pt;
				font-style: normal;
				line-height: normal;
				font-weight: normal;
				color: #3c3c3c;
		}
	</style>
	
</head>
<body>
<div class="actionResults">
<?php
//This script is for use by Geodesic Support Team.


//Change this to true, and this file can be uploaded to base software location
//and only the test portion of the script will be run
$testOnly = false;

if (!function_exists('scandir')) {
	//So it will work on PHP 4 older installs...
	function scandir ($dir) {
		$dh  = opendir($dir);
		while (false !== ($filename = readdir($dh))) {
		    $files[] = $filename;
		}

		sort($files);
		return $files;
	}
}

/**
 * Check to see if current folder is writable, if not show a message.
 */
function requireWrite () {
	if (!is_writable('.')){
		msg ('You forgot to chmod 777 on the folder, may not be able to perform this action.');
		return false;
	}
	return true;
}

/**
 * Basically just wraps a string in a p to give each message it's own paragraph.
 * @param $msg
 */
function msg ($msg, $isNote = false)
{
	$style = ($isNote)? ' class="note"':'';
	echo "<p{$style}>$msg</p>\n\n";
}

/**
 * Remove file(s) and directories recursively.
 *
 * @param array|string $filename Either the filename (or foldername) to remove,
 *   or an array of filenames/folders to remove
 */
function rm ($filename)
{
	if (!$filename) {
		//umm, nothing being requested to be removed, I guess we could say we
		//removed nothing successfully!
		return true;
	}
	if (is_array($filename)) {
		//go through array and remove each one, don't stop on failures
		$return = true;
		foreach ($filename as $file) {
			$result = rm($file);
			if (!$result) {
				//at least one failed, so return false
				$return = false;
			}
		}
		return $return;
	}
	if (is_dir($filename)) {
		$dirlist = array_diff(scandir($filename), array('.', '..'));
		$filename = rtrim($filename, '/');
		foreach ($dirlist as $entry) {
			rm ("$filename/$entry");
		}
		//remove the directory
		return rmdir ($filename);
	}
	//just a normal file, attempt to delete it
		
	return unlink ($filename);
}

function chmod_folders ($filename, $chmod)
{
	if ($chmod <= 0) {
		//set to not chmod anything!
		return true;
	}
	if (is_array($filename)) {
		//go through array and chmod each one, don't stop on failures
		foreach ($filename as $file) {
			chmod_folders ($file, $chmod);
		}
		return true;
	}
	if (is_dir($filename)) {
		$dirlist = array_diff(scandir($filename), array('.', '..'));
		$filename = rtrim($filename, '/');
		foreach ($dirlist as $entry) {
			chmod_folders ("$filename/$entry", $chmod);
		}
		//chmod the directory
		if ($chmod == '777') {
			return chmod ($filename, 0777);
		} else if ($chmod == '755') {
			return chmod ($filename, 0755);
		}
	}
	//just a normal file, we only chmod folders here...
	
	return true;
}

/**
 * Attempts to make the user an admin user.
 */
function makeMeAdmin () {
	if (!isset($_COOKIE['admin_classified_session'])) {
		$admin = (defined('ADMIN_LOCAL_DIR'))? ADMIN_LOCAL_DIR : 'admin/';
		msg ('You need to have an admin cookie first!  Go view the <a href="../'.$admin.'index.php" onclick="window.open(this.href); return false;">admin login</a> then come back here.');
		return false;
	}
	$link = dbLink();
	if (!$link) {
		msg ("could not connect: ".mysql_error());
		return false;
	}
	
	$userId = (isset($_REQUEST['userId']))? (int)$_REQUEST['userId'] : 1;
	$sql = "UPDATE `geodesic_sessions` SET `user_id`=$userId WHERE `classified_session`='{$_COOKIE['admin_classified_session']}'";
	$result = mysql_query("UPDATE `geodesic_sessions` SET `user_id`=$userId WHERE `classified_session`='{$_COOKIE['admin_classified_session']}'");
	if (!$result) {
		msg ("db error: sql: $sql error: ".mysql_error());
	} else {
		msg ("<strong>You should be admin!</strong>  Go to the admin panel, you should be admin now.");
	}
	mysql_close($link);
	return true;
}

function dbLink ()
{
	require "../config.php";
	$link = mysql_connect($db_host, $db_username, $db_password);
	if (!$link) {
		return false;
	}
	
	if (!mysql_select_db($database, $link)) {
		msg ("can't use database $database : ".mysql_error());
		
		return false;
	}
	return $link;
}

/**
 * Attempts to dump the DB
 */
function dumpDB ()
{
	if (!requireWrite()) {
		msg ("Cannot dump the DB to file, need write permission!");
		return false;
	}
	msg("OK attempting to dump the database using shell script (requires linux):");
	require '../config.php';
	$end = (isset($_GET['nozip']))? "> dbdump.sql" : "| gzip > dbdump.sql.gz";
	//Note:  removed --compatible=mysql323 as it doesn't work well with charsets
	exec("mysqldump --skip-opt --compact --add-drop-table --create-options -h '$db_host' -u '$db_username' --password='$db_password' $database $end");
	$url = (isset($_GET['nozip']))? "dbdump.sql" : "dbdump.sql.gz";
	msg ("DB Dumped File: <a href='$url'>$url</a>");
	//attempt to chmod 777 the file
	chmod($url, 0766);
}

/**
 * Attempts to run the specified query.
 * @param string $sql
 */
function runQuery ($sql)
{
	msg ("OK attempting to manually run SQL query specified using shell script (requires linux):");
	msg ("<strong>SQL Query:</strong> $sql");
	
	//after this we are displaying differently, not using msg..
	echo "<pre>";
	require '../config.php';
	$sql = escapeshellarg($sql);
	$command = "mysql --connect_timeout=500 --sigint-ignore -v -H -h '$db_host' -u '$db_username' --password='$db_password' $database -e $sql";
	echo "shell\$ $command\n\n";
	$startTime = microtime(true);
	if (!system ($command." 2> last_sql_error.txt")) {
		echo file_get_contents('last_sql_error.txt');
		//delete the file
		unlink('last_sql_error.txt');
	}
	echo "</pre>";
	//go back to using msg now
	$time = microtime(true) - $startTime;
	$prettyTime = prettyTime($time);
	
	msg ("<strong>Query Time:</strong> <span title='{$prettyTime}'>{$time} Seconds</span>");
}

/**
 * returns a pretty version of the given timestamp.
 * 
 * @param int $time
 * @return string
 */
function prettyTime ($time)
{
	if (!$time) {
		return '';
	}
	$days = floor($time / (60*60*24));
	$time -= $days * (60*60*24);
	$hours = floor($time / (60*60));
	$time -= $hours * (60*60);
	$min = floor($time / (60));
	$time -= $min * (60);
	return "$days days, $hours hours, $min minutes, $time seconds";
}
/**
 * Checks to see if mysql is good or not.
 * Enter description here ...
 */
function mysqlCheck ($testOnly) {
	$continue = (function_exists('mysql_connect'));
	
	$check = ($continue)? CHECK_PASS : CHECK_FAIL;
	msg ('MySQL installed/usable in PHP'.$check);
	
	if (!$continue) {
		//don't do rest of checks
		return false;
	}
	$configLocation = (($testOnly)? '':'../').'config.default.php';
	include ($configLocation);
	$version = 'unknown';
	$check = CHECK_NA;
	if (isset($db_host) && $db_host != 'your_database_hostname' && strlen($db_host)) {
		$version .= ' '.__line__;
		//if config.php is already set up, attempt to get server version.
		require_once(CLASSES_DIR.'adodb/adodb.inc.php');
		$db =& ADONewConnection($db_type);
		
		$db->Connect($db_host, $db_username, $db_password, $database);
		$info = $db->ServerInfo();
		if (is_array($info)){
			$version .= ' '.__line__;
			$mysql_version = $info['version'];
			if (strlen($mysql_version)){
				$version .= ' '.__line__;
				$version = $mysql_version;
				$check = (version_compare($mysql_version, '3.2.3','>='))? CHECK_PASS : CHECK_FAIL;
			}
		}
	}
	
	msg ("MySQL Ver. >= 3.2.3 (Ver. is $version)$check");
}

function ioncubeCheck ()
{
	$version = 'unkown';
	if (function_exists('ioncube_loader_iversion')) {
        $liv = ioncube_loader_iversion();
        $version = sprintf("%d.%d.%d", $liv / 10000, ($liv / 100) % 100, $liv % 100);
	}
	msg ("Ioncube Loader (Ver. is $version)".((extension_loaded('ionCube Loader'))? CHECK_PASS : CHECK_FAIL));
}

function zendCheck ()
{
	msg ("Zend Optimizer".((function_exists('zend_loader_enabled') && zend_loader_enabled())? CHECK_PASS : CHECK_FAIL));
}

function checkFsock ()
{
	$sock = fsockopen ('geodesicsolutions.com', 80, $errno, $errstr);
	msg ("Socket Connection to geodesicsolutions.com".(($sock)? CHECK_PASS : CHECK_FAIL));
	if (!$sock) {
		msg ("&nbsp; &nbsp; <strong>Socket Error ($errno)</strong>: $errstr");
	} else {
		//see if we can connect to license checker thingy
		$header="POST /geo_store/license_server/validate_internal.php HTTP/1.0\r\n";
		$header.="Host: geodesicsolutions.com\r\n";
		$header.="Content-type: application/x-www-form-urlencoded\r\n";
		$header.="User-Agent: PHPAudit v2 (http://www.phpaudit.com)\r\n";
		$header.="Content-length: 0\r\n";
		$header.="Connection: close\r\n\r\n";
		$header.="test=test";
		
		$data=false;
		if (function_exists('stream_set_timeout')) { stream_set_timeout($sock, 20); }
		fputs($sock, $header);

		if (function_exists('socket_get_status')) { $status=socket_get_status($sock); } 
		else { $status=true; }

		while (!feof($sock)&&$status) {
			$data.=fgets($sock, 1024);

			if (function_exists('socket_get_status')) {
				$status=socket_get_status($sock);
			} else {
			    if (feof($sock)==true) {
			    	$status=false;
			    } else {
			    	$status=true;
			    }
			}
		}

		fclose ($sock);

		#echo "Data returned: <textarea rows='100' cols='100'>".$data."</textarea>"; die;
		$errmsg = "";
		if (!$data || !strlen(trim($data))) {
			$errmsg .= "No data returned!  (Not even headers!?)<br />\n";
		}
		if ($data && !strpos($data, '200')) {
			//NOT 200 error?
			$errmsg .= "Status Code NOT 200 (OK)!<br />\n";
		} else if ($data) {
			$parts=explode("\r\n\r\n", $data, 2);
			
			if ($parts[1]!=="invalid") {
				$errmsg .= "Returned value not what we expected.";
			}
		}
		msg ("Socket Connection to geodesicsolutions.com - returned data check".((!strlen($errmsg))? CHECK_PASS : CHECK_FAIL));
		if ($errmsg && $parts) {
			msg ("&nbsp; &nbsp; <strong>Headers Received:</strong><br /><textarea rows='10' cols='100'>".$parts[0]."</textarea>");
			msg ("&nbsp; &nbsp; <strong>Content Received:</strong><br /><textarea rows='10' cols='100'>".$parts[1]."</textarea>");
		} else if ($errmsg && $data) {
			msg ("&nbsp; &nbsp; <strong>Headers & Content Received:</strong><br /><textarea rows='10' cols='100'>$data</textarea>");
		}
	}
}

function checkCurl ()
{
	if (!function_exists('curl_init')) {
		msg("CURL Connection to geodesicsolutions.com".CHECK_FAIL);
		msg(" &nbsp; &nbsp; Function curl_init() does not exist (or is disabled).");
		return;
	}
	if (!function_exists('curl_exec')) {
		msg("CURL Connection to geodesicsolutions.com".CHECK_FAIL);
		msg(" &nbsp; &nbsp; Function curl_init() is good, but for some reason <strong>curl_exec()</strong> is disabled.");
		msg(" &nbsp; &nbsp; This will <strong>cause errors</strong>, either disable curl_init as well, or remove curl_exec from the disabled functions.");
		return;
	}
	if (!function_exists('curl_setopt')) {
		msg("CURL Connection to geodesicsolutions.com".CHECK_FAIL);
		msg(" &nbsp; &nbsp; Function curl_init() is good, but for some reason <strong>curl_setopt()</strong> is disabled.");
		msg(" &nbsp; &nbsp; This will <strong>cause errors</strong>, either disable curl_init as well, or remove curl_setopt from the disabled functions.");
		return;
	}
	if (!function_exists('curl_close')) {
		msg("CURL Connection to geodesicsolutions.com".CHECK_FAIL);
		msg(" &nbsp; &nbsp; Function curl_init() is good, but for some reason <strong>curl_close()</strong> is disabled.");
		msg(" &nbsp; &nbsp; This will <strong>cause errors</strong>, either disable curl_init as well, or remove curl_close from the disabled functions.");
		return;
	}
	
	$link=curl_init();
	
	if (!$link) {
		msg("CURL Connection to geodesicsolutions.com".CHECK_FAIL);
		msg(" &nbsp; &nbsp; Call to curl_init() failed!");
		return;
	}
	//not trying to do a real license validation.. just making sure response is good
	$request = array ('debug' => 'debug');
	
	curl_setopt($link, CURLOPT_URL, 'http://geodesicsolutions.com/geo_store/api/index.php');
	curl_setopt($link, CURLOPT_POSTFIELDS, $request);
	curl_setopt($link, CURLOPT_VERBOSE, 0);
	curl_setopt($link, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($link, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($link, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($link, CURLOPT_MAXREDIRS, 6);
	curl_setopt($link, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($link, CURLOPT_TIMEOUT, 15); // 60
	$results=curl_exec($link);
	
	msg ("CURL Connection to geodesicsolutions.com".(($results===false)? CHECK_FAIL : CHECK_PASS));
	
	if ($results === false) {
		msg ("&nbsp; &nbsp; Error when calling curl_exec(), error message: ".curl_error($link));
	}
	
	msg ("CURL Connection to geodesicsolutions.com - returned data check".(($results==='invalid')? CHECK_PASS : CHECK_FAIL));
	
	if ($results !== false && $results !== 'invalid') {
		//returned value is expected to be "invalid", if not something is wrong...
		msg(" &nbsp; &nbsp; Unexpected response from server!  <strong>Content Received:</strong><br /><textarea rows='10' cols='100'>".htmlspecialchars($results)."</textarea>");
	}
	curl_close($link);
}

function checkDns ()
{
	if (!function_exists('dns_get_record')) {
		//can't do anything
		msg("DNS Check for geodesicsolutions.com".CHECK_NA);
		msg("&nbsp; &nbsp; Function dns_get_record() does not exist (or is disabled).");
		return;
	}
	$dns = dns_get_record('geodesicsolutions.com');
	$pass = ($dns[0]['ip'] === GEO_IP);
	msg("DNS Check for geodesicsolutions.com".(($pass)? CHECK_PASS : CHECK_FAIL));
	if (!$pass) {
		msg("&nbsp; &nbsp; <strong>DNS IP Reported:</strong> {$dns[0]['ip']} (should be ".GEO_IP.")<br />
			&nbsp; &nbsp; <strong>DNS host:</strong> {$dns[0]['host']} (should be geodesicsolutions.com) <br />
			&nbsp; &nbsp; <strong>DNS type:</strong> {$dns[0]['type']} <br /> 
			&nbsp; &nbsp; <strong>DNS class:</strong> {$dns[0]['class']}");
	}
}

function zip ($sources, $destination, $isLocal = false)
{
	if (extension_loaded('zip')) {
		//do it the PHP5 way
		require_once('php5zip.lib.php');
		return zip5($sources, $destination);
	}
	
	//do it the "it just works" way using older pclzip, that is compatible with PHP 5
	
	//this could easily error, especially where there is a lot to do and a crappy server to do it on 
	ini_set('display_errors','stdout');
	//no limits!!!
	set_time_limit(0);
	if (!is_array($sources)) {
		$sources = array($sources);
	}
	
	$startingSourceFolder = ($isLocal)? dirname(__FILE__) : dirname(dirname(__FILE__));
	$startingSourceFolder = rtrim($startingSourceFolder,'/').'/';
	
	if (!$sources) {
		$sources = array_diff(scandir($startingSourceFolder), array ('.','..','geo_support_tools','user_images'));
		msg("Found the following to zip up:<pre>".print_r($sources,1)."</pre>");
	}
	
	//use PCL Zip
	require_once 'pclzip.lib.php';
	
	$list = array();
	foreach ($sources as $source) {
		$file = $startingSourceFolder.$source;
		if (file_exists($file)) {
			$list[] = $file;
		}
	}
	
	$archive = new PclZip($destination);
	$result = $archive->create($list, PCLZIP_OPT_REMOVE_PATH, rtrim($startingSourceFolder,'/'));
	
	if ($result==0) {
		msg ("error: ".$archive->errorInfo(true), true);
	}
	
	return !($result==0);
}

function checkGeoConnect ()
{
	//make sure DNS is pointing correctly
	checkDns();
	
	//see if we can connect through curl to Geo site
	checkCurl();
	
	//see if we can connect to Geo site
	checkFsock();
	
	
	//todo:  do more checks like curl and such
}

function sizeOfFile ($filename)
{
	$size = filesize($filename);
	
	$kb = 1024;
	$mb = 1048576;
	$gb = 1073741824;
	$tb = 1099511627776;
	if ($size > $tb) {
		//wow that's big...
		return round(($size/$tb), 2).' TB';
	}
	if ($size > $gb) {
		return round(($size/$gb), 2).' GB';
	}
	if ($size > $mb) {
		return round(($size/$mb), 2).' MB';
	}
	if ($size > $kb) {
		return round(($size/$kb), 2).' KB';
	}
	return $size.' Bytes';
}

function copyGoodImages ()
{
	$link = dbLink();
	
	if (!$link) {
		msg("Could not connect to DB!");
		return false;
	}
	
	$result = mysql_query("SELECT image_upload_path FROM geodesic_classifieds_ad_configuration", $link);
	if (!$result) {
		msg("DB Error when getting config, DB error message: ".mysql_error($link));
		mysql_close($link);
		return false;
	}
	
	$folder = mysql_fetch_array($result);
	$folder = $folder['image_upload_path'];
	if (!$folder) {
		msg("Could not figure out what folder to look in from configuration options.");
		return false;
	}
	
	//pull array of filenames from images_urls table
	$sql = "SELECT full_filename, thumb_filename FROM `geodesic_classifieds_images_urls`";
	$result = mysql_query($sql, $link);
	if ($result === false) {
		msg("DB Error when trying to remove images!  Error Reported: ".mysql_error($link));
		mysql_close($link);
		return false;
	}
	mkdir('verified_user_images', 0777);
	$count = $total = 0;
	while ($row = mysql_fetch_array($result)) {
		$total++;
		if ($row['full_filename'] && file_exists($folder.$row['full_filename'])) {
			copy ($folder.$row['full_filename'], 'verified_user_images/'.$row['full_filename']);
			chmod("verified_user_images/{$row['full_filename']}", 0777);
			$count++;
		}
		if ($row['full_filename'] != $row['thumb_filename'] && $row['thumb_filename'] && file_exists($folder.$row['thumb_filename'])) {
			copy ($folder.$row['thumb_filename'], 'verified_user_images/'.$row['thumb_filename']);
			chmod("verified_user_images/{$row['thumb_filename']}", 0777);
			$count++;
		}
	}
	
	if ($count) {
		msg ("Copied $count images to verified_user_images folder.");
	} else {
		msg("No images found to copy, although there were $total entries in the DB.");
	}
	mysql_close($link);
	return true;
}

function utf8Convert ($utf8, $utf8tables)
{
	//Text to convert, need to populate this on per-install basis, to fix things
	//like ? in columns that were not encoded..  Should be UTF-8 and "decoded", and CaSe Sensitive
	$textConvert = array(
		//'bad t?xt as unencoded' => 'bad text as unencoded',
		//below are a few more examples
		//'Otro pa?s' => 'Otro país',
		//'Espa?a' => 'España',
		//'?VILA' => 'ÁVILA',
	);
	
	if ($textConvert) {
		$search = $replace = array();
		//make sure it is utf-8 already
		foreach ($textConvert as $key => $val) {
			$key = (isUtf8($key))? $key : utf8_encode($key);
			$val = (isUtf8($val))? $val : utf8_encode($val);
			$search[] = $key;
			$replace[] = $val;
		}
	}
	
	$link = dbLink();
	if (!$link) {
		msg("Error connecting to DB: ".mysql_error());
		return $utf8;
	}
	if (!is_array($utf8['unique'])) {
		$utf8['unique'] = array ($utf8['unique']);
	}
	$result = mysql_query("SELECT * FROM `{$utf8['table']}` ORDER BY ".implode(', ',$utf8['unique'])." LIMIT {$utf8['start']}, {$utf8['count']}", $link);
	if (!$result) {
		msg("DB error getting data, error message: ".mysql_error($link));
		mysql_close($link);
		return $utf8;
	}
	$total_count = mysql_num_rows($result);
	
	$row_count = $errors = 0;
	while ($row = mysql_fetch_assoc($result)) {
		$changes = array ();
		foreach ($row as $key => $value) {
			if (in_array($key, $utf8['unique']) || !strlen($value) || is_numeric($value)) {
				//unique shouldn't be worried about, it should be number...
				continue;
			}
			//msg("processing column $key...  value is ".htmlspecialchars($value));
			$url = urldecode($value);
			if ($url !== $value && urlencode($url) === $value) {
				//this row is processed via urlencode/decode...
				//msg('This row is different url decoded...');
				$isUtf8 = isUtf8($url);
				if ($isUtf8 && !$textConvert) {
					//it is already UTF-8, nothing to do
					continue;
				}
				
				if (!$isUtf8) {
					$url = utf8_encode($url);
				}
				if ($textConvert) {
					//do any string replacements
					$url = str_replace($search, $replace, $url);
				}
				$changed = urlencode($url);
			} else {
				$isUtf8 = isUtf8($value);
				if ($isUtf8 && !$textConvert) {
					//it is already utf-8, skip
					continue;
				}
				$changed = $value;
				if (!$isUtf8) {
					$changed = utf8_encode($changed);
				}
				if ($textConvert) {
					$changed = str_replace($search, $replace, $changed);
				}
				$url = '';
			}
			if ($value !== $changed) {
				//changed value is different, so update it
				
				if ($utf8['debug']) {
					msg("[Debug] before/after/decoded:<br />".htmlspecialchars($value)."<br />------------<br />".htmlspecialchars($changed)."<br />------------<br />".htmlspecialchars($url),true);
				}
				$changes[] = "`$key` = '".mysql_real_escape_string($changed, $link)."'";
			}
		}
		if (count($changes)) {
			$whereParts = array();
			foreach ($utf8['unique'] as $column) {
				$whereParts[] = "`{$column}`='".mysql_real_escape_string($row[$column],$link)."'";
			}
			$sql = "UPDATE {$utf8['table']} SET ".implode(', ',$changes)." WHERE ".implode(' AND ',$whereParts)." LIMIT 1";
			if (!$utf8['dryrun']) {
				$update = mysql_query($sql, $link);
			} else {
				msg("[Dry Run] Update SQL Query:<br />".htmlspecialchars($sql),true);
				$update = true;
			}
			
			if (!$update) {
				msg("DB error updating data, sql:".htmlspecialchars($sql)."<br />error message: ".mysql_error($link));
				$errors++;
			}
			$row_count++;
		}
	}
	msg("Finished processing, starting at record {$utf8['start']}, found $row_count rows to update out of $total_count");
	if (!$errors && !$utf8['dryrun']) {
		if ($total_count < $utf8['count']) {
			//go to next table!
			$tables = array_keys($utf8tables);
			$current = array_search($utf8['table'], $tables);
			$current++;
			$utf8['table'] = (isset($tables[$current]))? $tables[$current] : '';
			$utf8['start'] = 0;
		} else {
			$utf8['start'] += $utf8['count'];
		}
	}
	
	mysql_close($link);
	return $utf8;
}

function isUtf8 ($string)
{
	if (function_exists('mb_check_encoding')) {
		//use check encoding
		return mb_check_encoding($string, 'UTF-8');
	}
	//regex modified from http://www.w3.org/International/questions/qa-forms-utf-8.en.php
	return preg_match('%^(?:
		  [\x09\x0A\x0D\x20-\x7E]			# ASCII
		| [\xC2-\xDF][\x80-\xBF]			# non-overlong 2-byte
		|  \xE0[\xA0-\xBF][\x80-\xBF]		# excluding overlongs
		| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}	# straight 3-byte
		|  \xED[\x80-\x9F][\x80-\xBF]		# excluding surrogates
		|  \xF0[\x90-\xBF][\x80-\xBF]{2}	# planes 1-3
		| [\xF1-\xF3][\x80-\xBF]{3}			# planes 4-15
		|  \xF4[\x80-\x8F][\x80-\xBF]{2}	# plane 16
	)*$%xs', $string); 
}


$phpMyAdminUrl = 'phpMyAdmin/index.php?geo_security='.urlencode(sha1('We like security here at geodesic solutions!!!'));

/**
 * ----  ACTIONS  ----
 * This section figures out if it should be doing something...
 * 
 */

//List of files/folders that are added by the tools, add to this list as needed
$fullF = array (
	'phpMyAdmin',
	'last_sql_error.txt',
	'user_images.zip',
	'backup.zip',
	'dbdump.sql',
	'dbdump.sql.gz',
	'error_log',
	'error_log.txt',
	'verified_user_images',
	'verified_user_images.zip',
);
//remove any that don't exist
$files = array_intersect($fullF, scandir('.'));


if (!$testOnly) {
	if (isset($_GET['remove_files'])){
		//remove any files we've added
		
		rm ($files);
		msg ('Finished removing files.');
	}
	
	if (isset($_POST['runQuery'])) {
		$sql = (get_magic_quotes_gpc() == 1)? stripslashes($_POST['runQuery']) : $_POST['runQuery'];
		runQuery($sql);
	}
	
	if (isset($_GET['makeMeAdmin'])) {
		makeMeAdmin();
	}
	
	if (isset($_GET['dumpDB'])) {
		dumpDB();
	}
	
	if (isset($_GET['extract_phpmyadmin'])) {
		if (requireWrite()) {
			//first remove so it can be re-extracted just in case...
			rm ('phpMyAdmin');
			
			include_once('pclzip.lib.php');
			
			$ziper = new PclZip ('contents.zip');
			$ziper->extract();
			
			//chmod the folders so can be removed from space.
			//   I mean from ftp.
			chmod_folders ('phpMyAdmin', $_POST['chmod']);
			
			msg ("PhpMyAdmin extracted, you should be able to access <a href='$phpMyAdminUrl' onclick='window.open(this.href); return false;'>here</a>.");
		} else {
			//could not write.. show message
			msg ('Need write permission to extract PHPMyAdmin, CHMOD the geo_support_tools to 777.');
		}
	}
}
if (isset($_GET['verify_images']) && requireWrite()) {
	msg("Copying images that are verified in DB...");
	copyGoodImages();
}
if (isset($_GET['backup_images']) && requireWrite()) {
	msg("Zipping user_images folder now...");
	if ($_GET['good_only']) {
		$imgLink = "verified_user_images.zip";
		zip('verified_user_images','verified_user_images.zip',true);
	} else {
		zip ('user_images','user_images.zip');
		$imgLink = "user_images.zip";
	}
	msg("Finished!  If it worked, it should be accessible in <a href='$imgLink'>$imgLink</a>.");
}
if (isset($_GET['backup_everything']) && requireWrite()) {
	msg("Zipping all files (excluding geo_support_tools.php)...");
	zip ('', 'backup.zip');
	msg("Finished!  If it worked, download from <a href='backup.zip'>backup.zip</a>.");
}
if (isset($_GET['run_tests']) || $testOnly) {
	//we are running server tests...
	
	if (!$testOnly) {
		//let us know it can be used stand-alone as a reminder...
		msg ("<strong>Support Tip:</strong> If you need to show these test results to someone, do the following:<br />
		- Upload <strong>test2.php</strong> to the base folder of an installation.<br />
		- Edit the file, and near the top of the file, change:<br /><br />
\$testOnly&nbsp;= false;<br /><br />
		Change to:<br /><br />
\$testOnly&nbsp;= true;<br /><br />
		- Upload the changed file.
		<br /><br />
		<strong>Another tip:</strong>  You can easily add more tests as needed, just look for '//Add more checks here...' in the test2.php code.  Remember to let other support know when changes to this file have been committed.",true);
	}
	
	ini_set('display_errors','stdout');
	ini_set('html_errors','On');
	error_reporting(7);
	
	echo "<h1>Server Test Results:</h1>\n";
	
	define('CHECK_PASS', " ...... [<strong style='color: darkgreen;'>PASS</strong>]");
	define ('CHECK_FAIL', " ...... [<strong style='color: red;'>FAIL</strong>]");
	define ('CHECK_NA', " ...... [<strong style='color: #DAA520;'>N/A</strong>]");
	
	//Geo's IP
	define('GEO_IP', '76.74.255.194');
	
	//PHP (check is so simple, no need for function...
	$phpversion = phpversion();
	$check = (version_compare($phpversion, '5.2.0', '>='))? CHECK_PASS : CHECK_FAIL;
	msg ("PHP Ver. >= 5.2.0  (Ver. is $phpversion) $check");
	
	//MySQL exists and is good and all that
	mysqlCheck($testOnly);
	
	//Ioncube
	ioncubeCheck();
	
	//Zend
	zendCheck();
	
	//Connect to geo site
	checkGeoConnect();
	
	//Add more checks here...
	
}

/**
 * Syntax for tables to convert:  table_name => unique_index_key
 * 
 * If table is special and has more than one column for unique key (like geodesic_tags),
 * need to special code for it in utf8Convert.
 * 
 * !!Important!!  If adding a new table, turn on debug and dry run, and confirm
 * that the changes being made are correct!  Especially if doing on a live site..
 * 
 */
$utf8tables = array (
	'geodesic_classifieds'=>'id',
	'geodesic_countries' => 'country_id',
	'geodesic_states' => 'state_id',
	'geodesic_classifieds_ads_extra' => array('classified_id','question_id'),
	'geodesic_classifieds_sell_questions' => 'question_id',
	'geodesic_classifieds_sell_questions_languages' => array ('question_id','language_id'),
	//See above for instructions on adding more tables to add to the conversion script
);

//set defaults
$utf8 = array (
	'table' => 'geodesic_classifieds',
	'start' => '0',
	'count' => '10',
	'debug' => false,
	'dryrun' => false,
	'posted' => false,
);

if (isset($_GET['utf8']) && isset($_POST['table'])) {
	//Convert stuff to UTF-8
	$utf8['errors'] = false;
	if (!isset($utf8tables[$_POST['table']])) {
		msg('No table selected!  Are you done processing all the tables?  (Table is de-selected automatically once the script has gone through converting all the tables)');
		$utf8['errors'] ++;
	} else {
		$utf8['table'] = $_POST['table'];
	}
	
	$utf8['unique'] = $utf8tables[$utf8['table']];
	
	$utf8['start'] = (int)$_POST['start'];
	$utf8['count'] = (int)$_POST['count'];
	$utf8['debug'] = (isset($_POST['debug']) && $_POST['debug'])? true : false;
	$utf8['dryrun'] = (isset($_POST['dryrun']) && $_POST['dryrun'])? true : false;
	$utf8['posted'] = true;
	if (!$utf8['errors']) {
		$utf8 = utf8Convert($utf8, $utf8tables);
	}
	msg('If conversion went smoothly, proceed to next set of things by clicking continue on the form.');
}

//re-do files so we know which ones are here after actions are done
$files = array_intersect($fullF, scandir('.'));
$sql = (isset($sql))? $sql : '';
?>
</div>
<?php if (!$testOnly) { ?>

<h2>Software Utilities</h2>
<ul>
	<li><a href="test2.php?makeMeAdmin=1">Make me Admin!</a></li>
	<li><a href="test2.php?run_tests=1">Run server tests</a></li>
</ul>

<h2>File Utilities</h2>
<ul>
	<li>Zip Up:  <a href="test2.php?backup_images=1">user_images/</a> | <a href="test2.php?backup_images=1&amp;good_only=1">DB-verified user_images/</a> | <a href="test2.php?backup_everything=1">All the rest (not user_images)</a></li>
	<li>
		Files/Folders Created by this tool:
		<ul>
			<?php if (!$files) { ?>
				<li>N/A</li>
			<?php } else {?>
				<?php foreach ($files as $file) { ?>
					<li><a href="<?php echo $file; ?>"><?php echo $file; ?></a> (<?php echo sizeOfFile($file);?>)</li>
				<?php } ?>
			<?php } ?>
		</ul>
	</li>
	<li><a href="test2.php?remove_files=sure">Remove files</a></li>
</ul>

<h2>MySQL</h2>
<ul>
	<li>
		<form method="post" action="test2.php?extract_phpmyadmin=1" style="display: inline;">
			<input type="submit" value="Extract PhpMyAdmin" /><br />
			<strong>CHMOD Folders:</strong>
			<label><input type="radio" checked="checked" name="chmod" value="777" />777</label>
			<label><input type="radio" name="chmod" value="755" />755</label>
			<label><input type="radio" name="chmod" value="0" />Don't CHMOD</label>
		</form>
	</li>
	<?php if (file_exists('phpMyAdmin')) { ?>
		<li><a href="phpMyAdmin/index.php?geo_security=<?php echo urlencode(sha1('We like security here at geodesic solutions!!!')); ?>" onclick="window.open(this.href); return false;">PhpMyAdmin</a> (pops to new window)</li>
	<?php } ?>
	<li><a href="test2.php?verify_images=1">Copy user_images verified in DB</a></li>
	<li>Dump the DB: [<a href="test2.php?dumpDB">zipped</a> | <a href="test2.php?dumpDB&amp;nozip=1">plain</a>] (requires linux)</li>
	<li>Run SQL on command line: (requires linux)<br />
		<form method="post" action="test2.php">
			<textarea cols="100" rows="5" name="runQuery"><?php echo htmlspecialchars($sql); ?></textarea>
			<br /><input type="submit" value="Run Query" />
		</form>
	</li>
</ul>

<h2>UTF-8 Convert [EXPerimental!!]</h2>
<p class="note">Make sure you <strong>back up the database</strong> before starting!<br />Also change the charsets to UTF-8 in settings <strong>before</strong> starting the conversion, or someone may place a listing after the conversion is done.</p>

<form action="test2.php?utf8" method="post">
	Process table:<br />
	<ul>
		<?php 
		$tables = array_keys($utf8tables);
		foreach ($tables as $table) { 
		?>
			<li><label><input type="radio" name="table" value="<?php echo $table; ?>"<?php if ($utf8['table']==$table) {?> checked="checked"<?php } ?> /> <?php echo $table;?></label></li>
		<?php } ?>
	</ul>
	<label>From Record: <input type="text" name="start" value="<?php echo $utf8['start'];?>" size="4" /></label>
	<label>Records at once: <input type="text" name="count" value="<?php echo $utf8['count'];?>" size="4" /></label><br />
	<label>From charset: <input type="text" value="ISO-8859-1" readonly="readonly" /> (only works on iso-8859-1 currently)</label><br />
	<label><input type="checkbox" name="debug" value="1" <?php if ($utf8['debug']) { ?>checked="checked"<?php } ?>/> Debug?</label><br />
	<label><input type="checkbox" name="dryrun" value="1" <?php if ($utf8['dryrun']) { ?>checked="checked"<?php } ?>/> Dry-run only (don't process changes, just disply update queries)?</label><br />
	<input type="submit" value="<?php if ($utf8['posted']) { ?>Continue<?php } else { ?>Start<?php } ?> Convert" />
	
</form>

<div style="clear: both;"></div>
<strong>When you are done, come back to this file to delete everything.</strong><br /><br />
<a href="test2.php?remove_files=sure"><strong>Remove all extracted files</strong></a><br /><br />
<p><strong>Info: </strong><br />
Upload this folder to the same directory as the config.php in any of our software.  The phpmyadmin will also work if this folder is uploaded to the
base folder of a vbulitin install, but if it is the same directory as our software, our software's config file will take precedence.</p>
<?php } ?>
</body>
</html>