<?PHP if (!defined('SAFE')) { die('invalid'); }

if ($_POST['choose_department'])
	{
	// get department details
	$request=api_customer_area::choose_department(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'department_options', 
			false, // set to true for debug 
			$session['session_id'],
			$_POST['department_id'],
			(isset($_POST['package_id'])?$_POST['package_id']:0),
			($_POST['renewal_options']?1:0)
			); 

	die($request['response']);
	}

$errors=array();

if ($_GET['close_ticket'])
	{
	$request=api_customer_area::helpdesk_close_ticket(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'helpdesk', 
			false, // set to true for debug 
			$session['session_id'],
			$_GET['close_ticket']
			);
	$errors=$request['errors'];
	}

// query the API
$request=api_customer_area::helpdesk(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'helpdesk', 
		false, // set to true for debug 
		$session['session_id']
		);

$conf['localization']=$request['localization'];
$transport=$request['transport'];
$conf['site']=$request['conf'];
$conf['rows']=(x('max_rows'))?x('max_rows'):$conf['rows'];
$tickets=$request['tickets'];
$customer_id=$request['customer_id']; //  pr($customer_id);
$departments=$request['departments'];
$department_select=array();
foreach ((array)$departments as $department) 
	{ 
	$department_select[$department['id']]=$department['name'];
	}

$packages=$request['packages'];
$package_select=array();
foreach ((array)$packages as $package) 
	{ 
	$package_select[$package['id']]=$package['name'];
	}
unset($request);


// sort pagination open tickets
$pagination_open_tickets='';
$open_tickets=$tickets['Open'];
$pagination=paging::compile($tickets['Open'], $conf['pages'], $conf['rows'], 'open_tickets'); // pr($pagination);
if ($pagination)
	{
	$open_tickets=$pagination['data'];
	$pagination_open_tickets=$pagination['pagination'];
	}

// sort pagination closed tickets
$pagination_closed_tickets='';
$closed_tickets=$tickets['Closed'];
$pagination=paging::compile($tickets['Closed'], $conf['pages'], $conf['rows'], 'closed_tickets'); // pr($pagination);
if ($pagination)
	{
	$closed_tickets=$pagination['data'];
	$pagination_closed_tickets=$pagination['pagination'];
	}

if ($_POST['new_ticket'])
	{
	if (!$_POST['subject']) { $errors[]=_e('error_subject_empty'); }
	if (!$_POST['reply']) { $errors[]=_e('error_reply_empty'); }

	if (empty($errors))
		{
		if (defined('USE_LOCAL_API')&&USE_LOCAL_API)
			{
			// create the ticket
			$ticket_id=helpdesk::create_ticket($_POST['subject'], $customer_id, $session['id'], 0, $_POST['department_id'], 'Open');

			// add the reply
			$reply_id=helpdesk::log_reply($ticket_id, 0, $customer_id, $session['id'], '', $_POST['reply']);

			// Upload the files
			$attachments=array();
			for ($i=1; $i<=count($_FILES); $i++)
				{
				$index="attachment1{$i}";
				if (strlen(trim($_FILES[$index]['name']))<=0) { continue; }

				$slash=((substr(php_uname(), 0, 7)=='Windows')?'\\':'/');
				$upload_path="{$conf['media_upload_path']}{$slash}helpdesk_attachments{$slash}{$ticket_id}{$slash}{$reply_id}";
				if (!file_exists($upload_path))
					{
					if (!mkdir($upload_path, 0777, true)) 
						{
						$errors[]=_e('error_saving_attachments');
						}
					}

				if (@move_uploaded_file($_FILES[$index]['tmp_name'], "{$upload_path}{$slash}{$_FILES[$index]['name']}"))
					{
					$attachments[]=array(
									'filename' => $_FILES[$index]['name'], 
									'attachment' => "{$upload_path}{$slash}{$_FILES[$index]['name']}"
									);
					}
				}

			// add the attachment
			helpdesk::save_attachments($ticket_id, $reply_id, $attachments, false);

			// notify the staff
			$department=helpdesk::get_department($_POST['department_id']);
			helpdesk::notify_staff($department, $ticket_id, $reply_id);

			die(header("Location: ".href('view_ticket', array('id'=>$ticket_id, 'tab' => 'reply'))));
			}
		else
			{
			$attachments=array();
			foreach ($_FILES as $attachment)
				{
				$attachments[]=array(
								'path' => $attachment['tmp_name'],
								'filename' => $attachment['name'],
								);
				}

			$custom_headers=array();
			$custom_headers[]="customer_area_id:{$conf['site']['id']}";
			if ($_POST['package_id']) { $custom_headers[]="package_id:{$_POST['package_id']}"; }

			$mailed=email::send(
						$transport, 
						array(), 
						array(), 
						$departments[$_POST['department_id']]['name'], 
						$departments[$_POST['department_id']]['email'], 
						"{$session['first_name']} {$session['last_name']}",
						$session['email'], 
						$_POST['subject'], 
						$_POST['reply'],  
						'view_ticket_send_from_customer_area',
						$transport['id'],
						array(), 
						array(), 
						3, 
						'', 
						$attachments, 	// attachment
						false,  // attachment name
						'text',
						false,
						$custom_headers
						);

			if ($mailed->error_count) 
				{
				$errors=array();
				$errors[]=_e('ticket_not_mailed_successfully')." {$mailed->ErrorInfo}"; 
				}
			else 
				{ 
				die(header("Location: ".href('view_ticket', array('id'=>$ticket_id, 'tab' => 'reply'))));
				}
			}
		}
	}


/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_tickets($data, $departments)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['id']=$data['id'];
	$buffer['last_reply']=$data['last_reply'];
	$buffer['ticket_id']='#'.$data['ticket_id'];
	$buffer['subject']=strip_tags($data['subject']);
	$buffer['department']=$departments[$data['department_id']]['name'];
	// $buffer['created']=(is_numeric($data['created']))?date(config('date_format'), $data['created']):'-';
	$buffer['created']=(is_numeric($data['created']))?date(config('date_format').' '.config('time_format'), $data['created']):'-';

	$href=array('close_ticket' => $data['id']);
	$link=href('helpdesk', $href);
	$buffer['close_ticket']="<a href='{$link}'>"._e('close_ticket').'</a>';

	$href=array('id' => $data['id'], 'tab' => 'reply');
	$link=href('view_ticket', $href);
	$buffer['view_ticket']="<a href='{$link}'>"._e('view_ticket').'</a>';

	return $buffer;
	}

$breadcrumb=' &raquo; '._e('menu_helpdesk');
?>