<?PHP if (!defined('SAFE')) { die('invalid'); }

if (!x('id')) { die(header('Location: '.href('helpdesk'))); }

if ($_GET['download_ticket_attachment'])
	{
	$download="{$conf['api_handler']}?"
			.'mod=customer_areas&task=download_ticket_attachment'
			."&session_id={$session['session_id']}"
			."&file_id={$_GET['file_id']}";

	die(header("Location: {$download}"));
	}

$errors=array();

// query the API
$request=api_customer_area::view_ticket(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'view_ticket', 
		false, // set to true for debug 
		$session['session_id'],
		x('id')
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$conf['rows']=(x('max_rows'))?x('max_rows'):$conf['rows'];
$transport=$request['transport'];
$department=$request['department'];
$ticket=$request['ticket'];
$ticket['subject']=strip_tags($ticket['subject']);
if (is_array($request['replies'])) { $replies=array_reverse($request['replies']); }
unset($request);

if ($_POST['submit_reply'])
	{
	if (!$_POST['reply']) { $errors[]=_e('error_reply_empty'); }

	if (empty($errors))
		{
		if (defined('USE_LOCAL_API')&&USE_LOCAL_API)
			{
			// add the reply
			$reply_id=helpdesk::log_reply($_POST['id'], 0, $ticket['customer_id'], $session['id'], '', $_POST['reply']);

			// Upload the files
			$attachments=array();
			for ($i=1; $i<=count($_FILES); $i++)
				{ 
				$index="attachment1{$i}";
				if (strlen(trim($_FILES[$index]['name']))<=0) { continue; }

				$slash=((substr(php_uname(), 0, 7)=='Windows')?'\\':'/');
				$upload_path="{$conf['media_upload_path']}{$slash}helpdesk_attachments{$slash}{$_POST['id']}{$slash}{$reply_id}";
				if (!file_exists($upload_path))
					{
					if (!mkdir($upload_path, 0777, true)) 
						{
						$errors[]=_e('error_saving_attachments');
						}
					}

				if (move_uploaded_file($_FILES[$index]['tmp_name'], "{$upload_path}{$slash}{$_FILES[$index]['name']}"))
					{
					$attachments[]=array(
									'filename' => $_FILES[$index]['name'], 
									'attachment' => "{$upload_path}{$slash}{$_FILES[$index]['name']}"
									);
					}
				}

			// add the attachment
			helpdesk::save_attachments($_POST['id'], $reply_id, $attachments, false);

			// notify the staff
			helpdesk::notify_staff($department, $_POST['id'], $reply_id);

			// reopen the ticket
			helpdesk::reopen_ticket($_POST['id']);

			die(header("Location: ".href('view_ticket', array('id'=>$_POST['id'], 'tab' => 'reply'))));
			}
		else
			{
			$attachments=array();
			foreach ($_FILES as $attachment)
				{
				$attachments[]=array(
								'path' => $attachment['tmp_name'],
								'filename' => $attachment['name'],
								);
				}

			$custom_headers=array();
			$custom_headers[]="customer_area_id:{$conf['site']['id']}";

			$mailed=email::send(
						$transport, 
						array(), 
						array(), 
						$department['name'], 
						$department['email'], 
						"{$session['first_name']} {$session['last_name']}",
						$session['email'], 
						"[#{$ticket['ticket_id']}] {$ticket['subject']}", 
						$_POST['reply'], 
						'view_ticket_send_from_customer_area',
						$transport['id'],
						array(), 
						array(), 
						3, 
						'', 
						$attachments, 
						false, 
						'text',
						false,
						$custom_headers
						);

			if ($mailed->error_count) 
				{
				$errors=array();
				$errors[]=_e('reply_not_mailed_successfully')." {$mailed->ErrorInfo}"; 
				}
			else { die(header("Location: ".href('view_ticket', array('id'=>$_POST['id'], 'tab' => 'reply')))); }
			}
		}
	}

// sort pagination open tickets
$pagination_open_tickets='';
$open_tickets=$tickets['Open'];
$pagination=paging::compile($tickets['Open'], $conf['pages'], $conf['rows'], 'open_tickets'); // pr($pagination);
if ($pagination)
	{
	$open_tickets=$pagination['data'];
	$pagination_open_tickets=$pagination['pagination'];
	}

// sort pagination closed tickets
$pagination_closed_tickets='';
$closed_tickets=$tickets['Closed'];
$pagination=paging::compile($tickets['Closed'], $conf['pages'], $conf['rows'], 'closed_tickets'); // pr($pagination);
if ($pagination)
	{
	$closed_tickets=$pagination['data'];
	$pagination_closed_tickets=$pagination['pagination'];
	}

function prepare_reply($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?" alt":'';

	$buffer['body']=$data['body'];
	$buffer['posted_by']=$data['posted_by'];
	$buffer['created']=date(config('date_format').' '.config('time_format'), $data['created']);

	$buffer['attachments']='';
	if ($data['attachments'])
		{
		foreach ((array)$data['attachments'] as $attachment)
			{
			if (!$buffer['attachments'])
				{
				$buffer['attachments'].="<img src='templates/".config('template')."/images/icons/attach.gif' class='icon reply_icon' /> ";
				$buffer['attachments'].=_e('reply_attachments')." ";
				}

			$link=href('view_ticket', array('download_ticket_attachment'=>'y', 'file_id'=>$attachment['alias'], 'id' => $data['id']));
			$buffer['attachments'].="<a href='{$link}' class='attachment'>{$attachment['filename']}</a>";
			}
		}

	return $buffer;
	}

$breadcrumb=" &raquo; <a href='".href('helpdesk')."'>"._e('menu_helpdesk')."</a> &raquo; {$ticket['subject']}";
?>