<?PHP
/**
* Remote API handler
*/
class api
	{
	/**
	* Fetch data from the API
	*
	* @param array $request
	* @param boolean $debug
	* @param boolean $clean_response
	* @return string 
	*/
	function fetch($request, $debug=false, $clean_response=false)
		{
		if (defined('USE_LOCAL_API')&&USE_LOCAL_API)
			{
			include API_PATH.'configuration.php';

			// load the localization
			$conf['localization']=localization::get_group((x('language')?x('language'):'en-us'), 'api', 'api');

			// validate the module
			if (!$request['mod']) { return 'invalid'; } 
			if (!in_array($request['mod'], $valid_mods)) { return 'invalid'; }

			// load the module dependencies
			mod::dependencies($request['mod'], false, ADMIN_PATH);

			// validate the task
			if (!$request['task']) { die('invalid'); }
			if (!in_array($request['task'], $valid_tasks)) { return _e('task_not_found'); }

			// validate the API key
			if (!$request['api_key']&&!in_array($request['task'], $no_api_key_required)) { return 'invalid'; }

			// Route the request
			$bypass_api_record_state=$_POST;
			$_POST=$request;
			if (file_exists($m3=API_PATH."modules/{$request['mod']}/{$request['task']}.php")) 
				{
				$errors=$buffer=array();
				include $m3;

				$_POST=$bypass_api_record_state;

				// deliver the data
				return api::wrap_package($buffer, count($errors));
				}

			$_POST=$bypass_api_record_state;
			}

		if (!function_exists('curl_init'))
			{
			return api::fetch_fsockopen($request, $debug, $clean_response);
			}

		$api_handler=$request['api_handler'];
		unset($request['api_handler']);
		$request=api::commands_to_string($request);

		$link=curl_init();
		curl_setopt($link, CURLOPT_URL, $api_handler);
		curl_setopt($link, CURLOPT_POSTFIELDS, $request);
		curl_setopt($link, CURLOPT_VERBOSE, 0);
		curl_setopt($link, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($link, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($link, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($link, CURLOPT_MAXREDIRS, 6);
		curl_setopt($link, CURLOPT_CONNECTTIMEOUT, 30);
		curl_setopt($link, CURLOPT_TIMEOUT, 15); // 60
		$results=curl_exec($link);

		if ($results=='invalid'&&strlen($results)==7) { die('Invalid Access'); }
	
		if ($debug)
			{
			curl_close($link);
			api::pr($results);
			}
	
		if ($clean_response)
			{
			curl_close($link);
			return $results;
			}

		if (curl_errno($link)>0)
			{
			curl_close($link);
			return false;
			}
		curl_close($link);
		
		return $results;
		}

	/**
	* Fetch data from the API
	*
	* @param array $request
	* @param boolean $debug
	* @param boolean $clean_response
	* @return string 
	*/
	function fetch_fsockopen($request, $debug=false, $clean_response=false)
		{
		$parts=parse_url($request['api_handler']);

		$fp=@fsockopen($parts['host'], 80, $errno, $errstr, 10); // was 5
		if (!$fp) { return ''; }
	
		$request=api::commands_to_string($request);

		$header="POST {$parts['path']} HTTP/1.0\r\n";
		$header.="Host: {$parts['host']}\r\n";
		$header.="Content-type: application/x-www-form-urlencoded\r\n";
		$header.="User-Agent: SPBAS (http://www.spbas.com)\r\n";
		$header.="Content-length: ".@strlen($request)."\r\n";
		$header.="Connection: close\r\n\r\n";
		$header.=$request;

		$results='';
		@fputs($fp, $header);
		while (!@feof($fp)) { $results.=@fgets($fp, 1024); }
		@fclose ($fp);

		$results=explode("\r\n\r\n", $results);
		
		return $results[1];
		}

	/**
	* Debug helper - prints a formatted array
	* 
	* @param array $stack The array to display
	* @param boolean $stop_execution
	* @return string 
	*/
	function pr($stack, $stop_execution=true)
		{
		$formatted='<pre>'.var_export((array)$stack, 1).'</pre>';

		if ($stop_execution) { die($formatted); }

		return $formatted;
		}

	/**
	* Grab the IP address of the end user
	*
	* @param array $_SERVER
	* @return mixed
	*/
	function capture_remote()
		{
		if ($_SERVER["HTTP_X_FORWARDED_FOR"]) { return $_SERVER["HTTP_X_FORWARDED_FOR"]; }

		if ($_SERVER["HTTP_CLIENT_IP"]) {  return $_SERVER["HTTP_CLIENT_IP"]; }

		return $_SERVER["REMOTE_ADDR"];
		}

	/**
	* Turn an array into a string suitable for fetching data.
	*
	* @param array $commands
	* @return string 
	*/
	function commands_to_string($commands)
		{
		if (!is_array($commands)) { return false; }

		$string='';
		foreach ($commands as $key => $value)
			{
			if ($string) { $string.='&'; }
			$value=urlencode($value); // added v1.9.1

			$string.="{$key}={$value}";
			}
	
		return $string;
		}

	/**
	* Parse XML using eval() to compile the resulting array
	*
	* @param string XML to parse
	* @return array parsed XML
	*/
	function parse_xml_by_eval($xml)
		{
		$parser=@xml_parser_create('');
		@xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		@xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		@xml_parse_into_struct($parser, $xml, $values, $tags);
		@xml_parser_free($parser);

		$hash_stack=array();

		foreach($values as $key => $val)
			{
			switch ($val['type'])
				{
				case "open":
				array_push($hash_stack, $val['tag']);
				break;

				case "close":
				array_pop($hash_stack);
				break;

				case "complete":
				array_push($hash_stack, $val['tag']);

				# uncomment to see what this function is doing
				# echo("\$ret[" . implode($hash_stack, "][") . "] = '{$val[value]}';\n");

				eval("\$ret[".implode($hash_stack, "][")."]='{$val[value]}';");
				array_pop($hash_stack);
				break;
				}
			}

		return $ret;
		}

	/**
	* Base64 decode the data and unserialize it back to an array.
	* 
	* @param array $package
	* @return array
	*/
	function unwrap_package($xml)
		{
		$xml=@api::parse_xml_by_eval($xml);
		// if ($xml['response']['error_count']>0) { return array(); }

		return unserialize(base64_decode($xml['response']['data']));
		}

	/**
	* Serialize an array, wrap it in base64 and XML for delivery.
	* 
	* @param array $message
	* @param integer $error_count
	* @return string XML
	*/
	function wrap_package($array, $error_count)
		{
		$package=base64_encode(serialize($array));

		return "<response><error_count>{$error_count}</error_count>\n<data>{$package}</data></response>\n";
		}

	/**
	* Ensure the template is not ran out of scope
	* 
	* @return boolean|string boolean on success; string on failure
	*/
	function ran_directly()
		{
		return (!class_exists('template'))?die('This file cannot be ran directly'):true; 
		}

	/**
	* Issue a command via the API
	* 
	* @param string $api_home
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param array $extras
	* @param boolean $debug
	* @return array
	*/
	function query($api_home, $api_key, $mod, $task, $extras=array(), $debug=false)
		{
		$request=array();
		$request['api_handler']=$api_home;
		$request['api_key']=$api_key;
		$request['mod']=$mod;
		$request['task']=$task;
		if ($_COOKIE['change_language']) { $request['language']=$_COOKIE['change_language']; }
		$request=array_merge($request, (array)$extras);

		$xml=api::fetch($request, $debug);
		return api::unwrap_package($xml); // pr($request);
		}
	}
?>