<?PHP
/**
 * SPBAS E-mail Handling & Wrappers
 *
 * @package    Framework
 * @author     Andy Rockwell <support@solidphp.com>
 */
class email
	{
	/**
	* Get the transport configuration ID.
	* 
	* @param integer $possible
	* @return array|integer array on success; integer 1 as the default
	*/
	function conf($possible)
		{
		return ($possible)?$possible:1;
		}

	/**
	* Get e-mail configuration for $config_id
	* 
	* @param integer $id The configuration to use
	* @return array|boolean array on success; boolean on failure
	*/
	function get_configuration($id)
		{
		return sql_fetch_assoc(sql_query("select * from m3_email_config where id='".intval($id)."'"));
		}

	/**
	* Parse BCC recipients
	* 
	* @param string $b_cc
	* @return array
	*/
	function parse_b_cc($b_cc)
		{
		$temp=array();
		$b_cc=explode(',', $b_cc);
		foreach ($b_cc as $string)
			{
			$string=explode('<', $string);

			$to=$email=trim($string[0]);
			if (strpos($string[1], '@'))
				{
				$email=trim(str_replace('>', '', $string[1]));
				}

			$temp[]=array($to, $email);
			}

		return $temp;
		}

	/**
	* Compiles and sends the e-mail.
	* 
	* @param array $transport The e-mail transport details
	* @param array $valid_tags ex. first_name
	* @param array $tag_values ex$subject. $tag_values['first_name']='andy';
	* @param string $to_name Andy Rockwell
	* @param string $to_email support@solidphp.com
	* @param string $from_name Casey Rockwell
	* @param string $from_email casey@solidphp.com
	* @param string $subject
	* @param string $message
	* @param string $event_alias
	* @param string $email_configuration_id
	* @param array $cc An array of array(array('Andy', 'my@email.com'), array('Casey', 'my@email2.com'))
	* @param array $bcc An array of array(array('Andy', 'my@email.com'), array('Casey', 'my@email2.com'))
	* @param string $priority 1 = High, 3 = Normal, 5 = low
	* @param string $altbody
	* @param string $attachment The path to the attachment
	* @param string $attachment_name Attachment file name
	* @param boolean $is_html
	* @param array $custom_header
	* @return boolean|array boolean on success; array on failure
	*/
	function send(
				$transport, 
				$valid_tags, 
				$tag_values, 
				$to_name, 
				$to_email, 
				$from_name, 
				$from_email, 
				$subject, 
				$message,  
				$event_alias,
				$email_configuration_id,
				$cc=false, 
				$bcc=false, 
				$priority=3, 
				$altbody=false, 
				$attachment=false, 
				$attachment_name=false, 
				$type='text', 
				$no_log=false, 
				$custom_header=array()
				)
		{
		$mail=new PHPMailer();

		// parse tags into the message
		if (!is_array($valid_tags)) { $valid_tags=explode(',', $valid_tags); } 
		foreach ($valid_tags as $tag)
			{
			$tag=trim($tag);
			$tag=preg_replace("/[^A-Za-z0-9_-]/", '', $tag);
			$subject=str_replace("{{$tag}}", $tag_values[$tag], $subject);
			$message=str_replace("{{$tag}}", $tag_values[$tag], $message);
			}

		// if configured for smtp, we need to add these
		if ($transport['email_transport']=='smtp')
			{
			$mail->IsSMTP();
			$mail->SMTPAuth=true;
			$mail->Host="{$transport['smtp_primary_host']}; {$transport['smtp_secondary_host']}";
			$mail->Port=$transport['smtp_port'];
			$mail->Username=$transport['smtp_username'];
			$mail->Password=$transport['smtp_password'];
			}

		// setup the to and from details
		$mail->From = $from_email;
		$mail->FromName = $from_name;
		$mail->AddReplyTo($from_email, $from_name);
		$mail->AddAddress($to_email, $to_name);

		// if we have attachments, add them in here
		if (is_array($attachment)&&!empty($attachment))
			{
			foreach ($attachment as $unique)
				{
				$mail->AddStringAttachment(@file_get_contents($unique['path']), $unique['filename']); 
				}
			}
		else if ($attachment&&$attachment_name) 
			{ 
			$mail->AddStringAttachment($attachment, $attachment_name); 
			}

		$mail->IsHTML(($type=='text')?false:true);

		// general settings
		$mail->WordWrap=80;
		$mail->Priority=80;
		
		if ($altbody) { $mail->Altbody=$altbody; }

		$base_cc='';
		if ($cc) 
			{
			$base_cc=$cc;
			// parse from string
			$cc=email_local::parse_b_cc($cc);
			foreach ((array)$cc as $person)
				{ // pr($person);
				// $person[1] == E-mail
				// $person[0] == Name
				$mail->AddCC($person[1], $person[0]); 
				}
			}

		$base_bcc='';
		if ($bcc) 
			{
			$base_bcc=$bcc;

			// parse from string
			$bcc=email_local::parse_b_cc($bcc);
			foreach ((array)$bcc as $person)
				{
				// $person[1] == E-mail
				// $person[0] == Name
				$mail->AddBCC($person[1], $person[0]); 
				}
			}

		// add custom headers!
		if (!empty($custom_header)&&is_array($custom_header))
			{
			foreach ($custom_header as $header)
				{
				$mail->AddCustomHeader($header);
				}
			}

		// make sure we don't send html in text mode
		$message=($type=='text')?html_entity_decode(strip_tags($message)):$message;

		// set the subject and message	
		$subject=$mail->Subject=$subject;
		$message=$mail->Body=$message;

		// send the mail!
		 $mail->Send();

		return $mail;
		}
	}
?>