<?PHP
/**
 * SPBAS Storefront General Use Functions
 *
 * @package    General_Use_Functions_Storefront
 * @author     Andy Rockwell <support@solidphp.com>
 */

/**
* Make a unique ID
* 
* @param string $prefix
* @param integer $chars
* @return string 
*/
function uid($prefix, $chars=8)
	{
	return $prefix.substr(md5(microtime()), 0, $chars);
	}


/**
* Prep data for the database
*
* @param string $var
* @return string
*/
function sql_escape($var) 
	{
	if (is_array($link=config('spdb')))
		{
		return $var;
		}

	if (is_array($var)) { return $var; }

	$var=mysqli_real_escape_string($link, $var); 

	return $var;
	}

/**
* Alias for mysqli_query()
* 
* @param string $query
* @return boolean
*/
function sql_query($query)
	{
	if (is_array($link=config('spdb')))
		{
		return false;
		}

	return mysqli_query($link, $query);
	}

/**
* Alias for mysqli_fetch_assoc()
* 
* @param string $resource
* @return boolean
*/
function sql_fetch_assoc($resource)
	{
	if (!$resource) { return false; }
	return mysqli_fetch_assoc($resource);
	}

/**
* Alias for mysqli_fetch_row()
* 
* @param string $resource
* @return boolean
*/
function sql_fetch_row($resource)
	{
	if (!$resource) { return false; }
	return mysqli_fetch_row($resource);
	}

/**
* Alias for mysqli_fetch_array()
* 
* @param string $resource
* @return boolean
*/
function sql_fetch_array($resource)
	{
	if (!$resource) { return false; }
	return mysqli_fetch_array($resource);
	}

/**
* Alias for mysqli_error()
* 
* @return boolean
*/
function sql_error()
	{
	if (is_array($link=config('spdb')))
		{
		return false;
		}

	return mysqli_error($link);
	}

/**
* Alias for mysqli_insert_id()
* 
* @return integer
*/
function sql_insert_id()
	{
	if (is_array($link=config('spdb')))
		{
		return 0;
		}

	return mysqli_insert_id($link);
	}

/**
* Sanatizes a string
* 
* @param string $string
* @param array $filter_in
* @param string $filter_out
* @param boolean $skip_clean
* @param boolean $debug
* @return string
*/
function sanatize($string, $filter_in=array('Striptags'), $filter_out='none', $skip_clean=false, $debug=false)
	{
	if ($debug)
		{
		pr($filter_in);
		}

	$string=sx($string);
	if (!$skip_clean) { $string=lx_externalinput_clean::basic($string, $filter_in, $filter_out, $debug); }
	//$string=htmlspecialchars($string, ENT_NOQUOTES, 'UTF-8');

	return $string;
	}

/**
* Generate a random hex color
* 
* @return string
*/
function detect_browser_language()
	{
	foreach (explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']) as $lang) 
		{
		$pattern='/^(?P<primarytag>[a-zA-Z]{2,8})(?:-(?P<subtag>[a-zA-Z]{2,8}))?(?:(?:;q=)(?P<quantifier>\d\.\d))?$/';
		$splits=array();

		if (preg_match($pattern, $lang, $splits)) 
			{
			return strtolower($splits[0]);
			}
		}

	return 'en-us';
	}



/**
* Generate a random hex color
* 
* @return string
*/
function get_random_color()
	{
	for ($i = 0; $i<6; $i++)
		{
		$c.= dechex(rand(0,15));
		}

	return $c;
	} 


/**
* Is the $number odd or even?
* 
* @param integer $number	
* @return boolean
*/
function ooe($number) { return ($number%2)==0; } 

/**
* Use https or not
* 
* @param array $url
* @return string
*/
function url($url)
	{
	$url=explode('//', $url);
	return (($_SERVER['HTTPS'])?'https://':'http://').$url[1];
	} 

/**
* Create a breadcrumb menu
* 
* @param array $trail
* @return string
*/
function breadcrumb($trail=array())
	{
	$link=href(''); $text=_e('home');
	$breadcrumb="<a href='{$link}'>{$text}</a>";
	foreach ($trail as $key => $value)
		{
		$text=$value;

		if ($key=='#') { return $breadcrumb.=" &raquo; {$text}"; }

		$link=href('listings', array('category_id' => $key)); 
		$breadcrumb.=" &raquo; <a href='{$link}'>{$text}</a>";
		}

	return $breadcrumb;
	}

/**
* Grab the IP address of the end user
*
* @return mixed
*/
function capture_remote()
	{
	if ($_SERVER["HTTP_X_FORWARDED_FOR"]) { return $_SERVER["HTTP_X_FORWARDED_FOR"]; }

	if ($_SERVER["HTTP_CLIENT_IP"]) {  return $_SERVER["HTTP_CLIENT_IP"]; }

	return $_SERVER["REMOTE_ADDR"];
	}

/**
* Apply nl2br article content if enable
* 
* @param string $enabled
* @param string $content
* @return boolean
*/
function do_nl2br($enabled, $content) 
	{ 
	if ($enabled!='Yes') { return $content; }

	// don't include pre tags
	$pre_buffer=array();
	$buffer='';
	$parts=explode('{skip_nl2br}', $content);
	foreach ($parts as $part)
		{
		if (strpos($part, '{/skip_nl2br}')===false) 
			{
			$buffer.=$part;
			continue;
			}

		$pre=explode('{/skip_nl2br}', $part);
		$pre_buffer[$i+=1]=$pre[0];
		$buffer.="{pre_replace_{$i}}{$pre[1]}";
		}

	unset($i);
	$buffer=nl2br($buffer);
	foreach ($pre_buffer as $pre)
		{
		$i+=1;
		$pre=str_replace('<?', '&lt;?', $pre);
		$buffer=str_replace("{pre_replace_{$i}}", $pre, $buffer);
		}

	return $buffer; 
	} 

/**
* Post XML using cURL
* 
* @param integer $url
* @param integer $xml
* @return boolean
*/
function post_xml($url, $xml) 
	{
	$ch=curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt ($ch, CURLOPT_HTTPHEADER, Array("Content-Type: text/xml"));
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	$result=curl_exec($ch);
	curl_close($ch);

	return $result;
	}

/**
* Recursively search for the configuration file!
* 
* @return string 
*/
function start_m3()
	{
	$try=''; 
	while (strlen($try)<=3)
		{
		$conf="{$try}m3_configuration.php";
		if (file_exists($conf)) {  return $conf; }
		$try.='../';
		}

	return false;
	}

/**
* Verify the url entered is valid.
* 
* @param string $url
* @param string $mime_type
* @return boolean
*/
function test_url($url, $mime_type='image/x-icon')
	{
	return true;

	$curl=curl_init("{$url}/favicon.ico");
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_exec($curl);

	if (curl_errno($curl))
		{
		return false;
		}
	$i=curl_getinfo($curl);
	curl_close($curl);

	return ($i['http_code']==200)?true:false;
	// return ($i['http_code']==200&&$i['content_type']==$mime_type)?true:false;
	}

/**
* Convert a Comma Separated Value list into an array
* 
* @param string $sql
* @return array
*/
function parse_sql($sql)
	{
	$buffer='';
	$results=array();
	foreach ($sql as $sql)
		{
		$sql=trim($sql);
		if (substr($sql, 0, 1)==" ") { continue; }
		if (substr($sql, 0, 2)=="--") { continue; }
		if (!$sql) { continue; }

		if (substr($sql, -1)==";")
			{
			$buffer.=$sql;
			$buffer=substr($buffer, 0, strlen($buffer)-1);
			# $buffer=str_replace("`", "", $buffer);

			$results[]=$buffer;
			$buffer='';
			}
		else
			{
			$buffer.=$sql;
			}
		}

	return $results;
	}

/**
* Fetch an RSS feed
* 
* @param string $url	
* @return boolean
*/
function fetch_rss($url)
	{
	$curl = curl_init();
	
	// Setup headers - I used the same headers from Firefox version 2.0.0.6
	// below was split up because php.net said the line was too long. :/
	$header[0] = "Accept: text/xml,application/xml,application/xhtml+xml,";
	$header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
	$header[] = "Cache-Control: max-age=0";
	$header[] = "Connection: keep-alive";
	$header[] = "Keep-Alive: 300";
	$header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
	$header[] = "Accept-Language: en-us,en;q=0.5";
	$header[] = "Pragma: "; // browsers keep this blank.
	
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)');
	curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
	curl_setopt($curl, CURLOPT_REFERER, 'http://www.google.com');
	curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
	curl_setopt($curl, CURLOPT_AUTOREFERER, true);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_TIMEOUT, 10);
	
	$html = curl_exec($curl); // print_R($html); die; // execute the curl command
	curl_close($curl); // close the connection
	
	return $html; // and finally, return $html
	}

/**
* Convert date to unix timestamp
*
* @param integer $month
* @param integer $day
* @param integer $year
* @return integer
*/
function to_unixtime($month, $day, $year)
	{
	return mktime(0, 0, 0, $month, $day, $year);
	}


/**
* Shuffle an array
*
* @param array $array
* @param integer $total
* @return integer
*/
function fisherYatesShuffle(&$array, $total)
	{
	for ($i=0; $i<$total; $i++)
		{
		$j=@mt_rand(0, $i);
		$temp=$array[$i];
		$array[$i]=$array[$j];
		$array[$j]=$temp;
		}
	
	return $array;
	}


/**
* Returns $config from the global scope
*
* @param mixed $which The key to return or boolean false.
* @param boolean $echo	
* @return mixed
*/
function config($which=false, $echo=false) 
	{ 
	if ($which&&$GLOBALS['conf']['site'][$which]) 
		{ 
		if ($echo) 
			{ 
			echo $GLOBALS['conf']['site'][$which];
			return '';
			}

		return $GLOBALS['conf']['site'][$which];
		}

	if ($which&&$GLOBALS['conf'][$which]) 
		{ 
		if ($echo) 
			{ 
			echo $GLOBALS['conf'][$which];
			return '';
			}

		return $GLOBALS['conf'][$which];
		}

	if ($echo) 
		{ 
		echo $GLOBALS['conf'];
		return '';
		}

	return $GLOBALS['conf']; 
	}

/**
* Enforce the use of www. or no www. 
* 
* @param string $host
* @param string $rules
* @return string
*/
function enforce_www($host, $rules)
	{
	if ($rules=='disable') { return false; }

	$isset_www=strpos($host, 'www.');
	if ($isset_www===0&&$rules=='no_www')
		{
		header('HTTP/1.1 301 Moved Permanently');
		die(header('Location: http://'.substr($host, 4)));
		}

	if ($isset_www===false&&$rules=='www')
		{
		header('HTTP/1.1 301 Moved Permanently');
		die(header("Location: http://www.{$host}"));
		}

	return false;
	}

/**
* Format a href links 
* 
* @param string $task
* @param array $extras For use later when SEF comes into play
* @param string $controller
* @return array
*/
function href($task, $extras=array(), $controller='index')
	{
	$rewrite=config('mod_rewrite');

	if ($rewrite&&$rewrite=='Enable'&&$extras['seo_page_name'])
		{
		return $extras['seo_page_name'];
		}
	else { unset($extras['seo_page_name']); }

	$querystring='';
	foreach ($extras as $key => $value)
		{
		if ($key=='task'&&$task) { continue; }

		$querystring.="&{$key}={$value}";
		}

	$q=($task||$querystring)?'?':'';
	$task=($task)?"task={$task}":'';

	return "{$controller}.php{$q}{$task}{$querystring}"; 
	}


/**
* Set the focus class
*
* @param string $target
* @param string $current
* @return string
*/
function on($target, $current)
	{
	if (is_array($target))
		{
		unset($target[array_search('announcements', $target)]);
		if (in_array($current, $target))
			{
			return "class='on'";
			}

		return '';
		}

	if ($target==$current) { return "class='on'"; }

	return '';
	}

function _e($mask)
	{
	return w($mask);
	}

/**
* Localization wrapper function based on $GLOBALS['conf']['localization']
*
* @param string $mask
* @param boolean $echo
* @return string
*/
function w($mask)
	{
	$translation=$GLOBALS['conf']['localization'][$mask];
	// $translation=($translation)?$translation:$GLOBALS['conf']['localization']['no_translation_found'];
	$translation=($translation)?$translation:$mask; // more useful to know the tag, added for v1.9

	return $translation;
	}

/**
* All possible months.
* 
* @return array
*/
function months()
	{
	return array(
			'01' => 'January',
			'02' => 'February',
			'03' => 'March',
			'04' => 'April',
			'05' => 'May',
			'06' => 'June',
			'07' => 'July',
			'08' => 'August',
			'09' => 'September',
			'10' => 'October',
			'11' => 'November',
			'12' => 'December'
			);
	}

/**
* All possible days (integer).
* 
* @return array
*/
function years()
	{
	$start=date('Y');
	$end=date('Y')+5;

	$buffer=array();
	for($i=$start; $i<=$end; $i++)
		{
		$buffer[$i]=sprintf('%04.0f', $i);
		}

	return $buffer;
	}


/**
* Debug helper - prints a formatted array
* 
* @param array $stack The array to display
* @param boolean $stop_execution
* @return string 
*/
function pr($stack, $stop_execution=true)
	{
	$formatted='<pre>'.var_export((array)$stack, 1).'</pre>';

	if ($stop_execution) { die($formatted); }

	return $formatted;
	}

/**
* Clear cache for a session
*/
function clear_cache()
	{
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Cache-Control: post-check=0, pre-check=0", false);
	// header('Content-type: text/html; charset=utf-8');
	header("Pragma: no-cache");
	}

/**
* Display errors in a nice wrapper.
*
* @param array $errors
* @param boolean $echo	
* @param boolean $width	
* @return string
*/
function display_errors($errors, $echo=true, $width=false) 
	{ 
	if (!is_array($errors)) { return false; }
	if (empty($errors)) { return false; }

	$class='error';
	if ($errors['success'])
		{
		$class='success';
		unset($errors['success']);
		}

	if ($width) { $width="style='width: {$width}'"; }
	
	$errors=implode("<br />\r\n", $errors);
	$errors="<div class='{$class}'{$width}>{$errors}</div><br />"; 

	if ($echo) { echo $errors; }

	return $errors;
	}

/**
* Get the cookie domain
*
* @return string
*/
function cookie_domain()
	{
	if (defined('use_cookie_domain')) { return use_cookie_domain; }

	$host=($_SERVER['HTTP_X_FORWARDED_HOST'])?$_SERVER['HTTP_X_FORWARDED_HOST']:$_SERVER['HTTP_HOST'];

	// if it's an IP address just return the IP
	if (eregi('^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}(/[0-9]{1,2}){0,1}$', $host))
		{
		return $host;
		}

	if (strpos($host, '.')===false) { return ''; }

	if (in_array($snip=substr($host, 0, 4), array('WWW.', 'www.')))
		{
		$host=str_replace($snip, '', $host);
		}

	return ".{$host}";
	}

/**
* UTF8 Helper
*
* @access private
*/
function charset_decode_utf_8 ($string) {
      /* Only do the slow convert if there are 8-bit characters */
    /* avoid using 0xA0 (\240) in ereg ranges. RH73 does not like that */
    if (! ereg("[\200-\237]", $string) and ! ereg("[\241-\377]", $string))
        return $string;

    // decode three byte unicode characters
    $string = preg_replace("/([\340-\357])([\200-\277])([\200-\277])/e",       
    "'&#'.((ord('\\1')-224)*4096 + (ord('\\2')-128)*64 + (ord('\\3')-128)).';'",   
    $string);

    // decode two byte unicode characters
    $string = preg_replace("/([\300-\337])([\200-\277])/e",
    "'&#'.((ord('\\1')-192)*64+(ord('\\2')-128)).';'",
    $string);

    return $string;
} 

/**
* Wrapper to handle cookies
*
* @param string $name
* @param mixed $data
* @param integer $expires
* @return string
*/
function set_cookie($name, $data, $expires=0)
	{
	return @setcookie($name, $data, $expires, '/', cookie_domain());
	}

/**
* Processes cookies and sessions returned by 3rd party loginshare modules
*
* @param array $third_party
* @return boolean 
*/
function process_loginshare($third_party)
	{
	foreach ((array)$third_party as $key => $run)
		{
		if ($run['session'])
			{
			if (isset($_SESSION)) { session_start(); }
			$_SESSION=unserialize(base64_decode($run['session']));
			}

		if ($run['cookie'])
			{
			$cookies=unserialize(base64_decode($run['cookie']));				
			foreach ((array)$cookies as $cookie_key => $cookie_value)
				{
				set_cookie($cookie_key, $cookie_value);
				}
			}
		}

	return true;
	}

/**
* Determine if we are using windows
* 
* @param string $path
* @return boolean
*/
function is_windows($path='')
	{
	if (@strpos($path, '\\')===true) { return true; }
	if (substr(@php_uname(), 0, 7)=='Windows') { return true; }
	return false; 
	}


/**
* Prep data for the database
*
* @param string $var
* @return string
*/
function a($var) { return addslashes(trim(@htmlentities($var, ENT_QUOTES))); }



/**
* Convert data back to state before a()
*
* @param string $var
* @return string Leave both double and single quotes unconverted.
*/
function s($var) 
	{
	$var=htmlspecialchars($var);
	return stripslashes(trim(html_entity_decode($var, ENT_NOQUOTES)));
	}


/**
* Convert data back to state before a()
*
* @param string $var
* @return string Convert both double and single quotes..
*/
function sx($var) 
	{
	$var=htmlspecialchars($var);
	if (is_windows($var)) { return stripslashes($var); } // commenting this out for v1.9. Why was it added???
	return stripslashes(trim(html_entity_decode($var, ENT_QUOTES))); 
	}

/**
* Allows you to find a value in $_GET, $_POST and then $_COOKIE.
*
* @param string $target The array key.
* @param boolean $all Return the entire array
* @return mixed Returns false on nothing found, returns the value on something found
*/
function x($target, $all=false, $priority='pgc')
	{
	while (strlen($priority)) 
		{
		$p = substr($priority,0,1);
		if ($p=='g' && isset($_GET[$target])) { return ($all)?$_GET:$_GET[$target]; }
		if ($p=='p' && isset($_POST[$target])) { return ($all)?$_POST:$_POST[$target]; }
		if ($p=='c' && isset($_COOKIE[$target])) { return ($all)?$_COOKIE:$_COOKIE[$target]; }
		$priority=substr($priority,1);
		}

	return false;
	}

/**
* Parse XML using eval() to compile the resulting array
*
* @param string $xml
* @return array parsed XML
*/
function parse_xml_by_eval($xml)
	{
	$parser=@xml_parser_create('');
	@xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	@xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	@xml_parse_into_struct($parser, $xml, $values, $tags);
	@xml_parser_free($parser);

	$hash_stack=array();

	foreach($values as $key => $val)
		{
		switch ($val['type'])
			{
			case "open":
			array_push($hash_stack, $val['tag']);
			break;

			case "close":
			array_pop($hash_stack);
			break;

			case "complete":
			array_push($hash_stack, $val['tag']);

			# uncomment to see what this function is doing
			# echo("\$ret[" . implode($hash_stack, "][") . "] = '{$val[value]}';\n");

			eval("\$ret[".implode($hash_stack, "][")."]='{$val[value]}';");
			array_pop($hash_stack);
			break;
			}
		}

	return $ret;
	}
?>