<?PHP if (!defined('SAFE')) { die('invalid'); } ?>

<div id='register'>
	<h1><?PHP echo _e('register_a_new_account'); ?></h1>
	<span class='login_notice'><?PHP echo _e('use_the_form_below_to_to_register_a'); ?> <a href='<?PHP echo href('login'); ?>'><?PHP echo _e('click_here'); ?></a> <?PHP echo _e('use_the_form_below_to_to_register_b'); ?></span>

	<?PHP display_errors($errors); ?>
	<?PHP echo forms::action(); ?>
	<?PHP echo forms::hidden('task', 0, 'register'); ?>
	<table>
		<?PHP if ($create_customer_account): ?>
			<tr>
				<td class='label'><?PHP echo _e('business_name:'); ?></td>
				<td class='text'><?PHP echo forms::text('business_name', 0, forms::value('business_name')); ?></td>
			</tr>
		<?PHP endif; ?>
		<tr>
			<td class='label'><?PHP echo _e('first_name:'); ?></td>
			<td class='text'><?PHP echo forms::text('first_name', 0, forms::value('first_name')); ?></td>
		</tr>
		<tr>
			<td class='label'><?PHP echo _e('last_name:'); ?></td>
			<td class='text'><?PHP echo forms::text('last_name', 0, forms::value('last_name')); ?></td>
		</tr>
		<tr>
			<td class='label'><?PHP echo _e('email:'); ?></td>
			<td class='text'><?PHP echo forms::text('email', 0, forms::value('email')); ?></td>
		</tr>
		<tr>
			<td class='label'><?PHP echo _e('username:'); ?></td>
			<td class='text'><?PHP echo forms::text('username', 0, forms::value('username'), ' maxlength="15"', 'medium')?> <?PHP echo _e('15_chars_max'); ?></td>
		</tr>
		<tr>
			<td class='label'><?PHP echo _e('password:'); ?></td>
			<td class='text'><?PHP echo forms::password('password', 0, forms::value('password'), '', 'medium')?></td>
		</tr>
		<tr>
			<td class='label'><?PHP echo _e('verify_password:'); ?></td>
			<td class='text'><?PHP echo forms::password('verify_password', 0, forms::value('verify_password'), '', 'medium')?></td>
		</tr>
		<?PHP if (!empty($recaptcha)): ?>
			<tr>
				<td class='label_top'><?PHP echo _e('are_you_human:'); ?></td>
				<td class='text'><?PHP echo recaptcha_get_html($publickey, '', true); ?></td>
			</tr>
		<?PHP endif; ?>
		<tr>
			<td class='label_submit'>&nbsp;</td>
			<td class='text'><?PHP echo forms::submit('', 0, _e('create_account')); ?></td>
		</tr>
	</table>
	</form>
</div>