<?php if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_customer_area::announcements(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'announcements', 
		false, // set to true for debug 
		$session['session_id']
		);

$conf['localization']=$request['localization'];
$conf['site']=$request['conf']; // pr($conf['site']);
$announcements=$request['announcements'];
unset($request);

$pagination=paging::compile($announcements, $conf['pages'], $conf['rows']); // pr($pagination);
if ($pagination)
	{
	$announcements=$pagination['data'];
	$pagination=$pagination['pagination'];
	}


$breadcrumb=' &raquo; '._w('announcements');

if (x('id'))
	{
	foreach((array)$announcements as $announcement)
		{
		if ($announcement['id']==x('id'))
			{
			$max=75;
			$title=strip_tags($announcement['title']);
			if (strlen($title)>$max) { $title=substr($title, 0, $max).' ...'; }

			$go_back=href('announcements');
			$breadcrumb=" &raquo; <a href='{$go_back}'>"._w('announcements')."</a> &raquo; {$title}";
			break;
			}
		}
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare($data)
	{ 
	$buffer=array();

	// add the uid
	$buffer['id']=$data['id'];

	$title=$data['title'];
	$buffer['title_standalone']=$title;
	$link=href('announcements', array('id' => $buffer['id']));
	$title="<a href='{$link}'>{$title}</a>";
	$buffer['title']=$title;

	$max=140;
	$announcement=strip_tags($data['announcement']);
	if (strlen($announcement)>$max)
		{
		$announcement=substr($announcement, 0, $max).' ...';
		}
	$buffer['announcement']=$announcement;
	$buffer['announcement_full']=$data['announcement'];

	$buffer['status']=$data['status'];
	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}