<?PHP if (!defined('SAFE')) { die('invalid'); }

if (!x('article_id')) { die(header("Location: ".href('index'))); }

// query the API
$data=array();
$data['article_id']=x('article_id');

$data['helpful']=$did_vote=false;
if ($_GET['helpful']&&!$_COOKIE['helpful_'.x('article_id')]) 
	{
	$data['helpful']=$_GET['helpful']; 
	$did_vote=true;
	}

$request=api_kb::article(
		$conf['api_handler'], 
		$conf['api_key'], 
		'kb', 
		'article', 
		false, // set to true for debug 
		x('article_id'),
		(x('category_id')?x('category_id'):0),
		$data['helpful']
		);

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];

if ($conf['site']['status']=='Down for Maintenance')
	{
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}

$categories=($request['categories'])?array_chunk($request['categories'], 3):array();

$breadcrumb=breadcrumb($request['breadcrumb']);
$article=$request['article'];
$article['icon']="templates/".config('template')."/images/icons/{$article['icon']}";
// $article['content']=($conf['site']['enable_nl2br']=='Yes')?nl2br($article['content']):$article['content'];
$article['content']=do_nl2br($conf['site']['enable_nl2br'], $article['content']);
$attachments=$request['attachments'];
$articles=$request['related'];
$disqus_website_shortname=$request['disqus'];
unset($request);


/** Disqus Comments ********************************************************************************************/

$disqus=array();
if ($disqus_website_shortname)
	{
	include_once 'includes/classes/3rd_party/Disqus/Disqus.php';
	$disqus['comment_block']=disqus::comment($disqus_website_shortname, md5("kb-{$disqus_website_shortname}-{$article['id']}-"));
	$disqus['comment_count']=disqus::comment_count($disqus_website_shortname);
	}

/** Bookmarks **************************************************************************************************/

// manage the favorites link
if ($_GET['bookmarks'])
	{
	$clean_bookmarks='';
	if ($_COOKIE['bookmarks'])
		{
		$bookmarks=explode(',', $_COOKIE['bookmarks']);
		foreach ($bookmarks as $bookmark)
			{
			if (!$bookmark) { continue; }
			if ($_GET['bookmarks']=='remove'&&$bookmark==$_GET['article_id'])
				{
				continue;
				}

			$clean_bookmarks.="{$bookmark},";
			}
		}

	$bookmarks=$clean_bookmarks;
	if ($_GET['bookmarks']=='add')
		{
		$bookmarks=implode(',', array_flip(array_flip(explode(',', "{$clean_bookmarks}{$_GET['article_id']}"))));
		}

	set_cookie('bookmarks', '', (time()-(365*86400)));
	set_cookie('bookmarks', $bookmarks, (time()+(365*86400)));
	}

$data=array('article_id'=>x('article_id'), 'bookmarks' => 'add');
if (x('category_id')) { $data['category_id']=x('category_id'); }
$link=href('article', $data);
$bookmarks="<a href='{$link}'>"._e('add_to_bookmarks')."</a>";
if ($_COOKIE['bookmarks']||$_GET['bookmarks']=='add')
	{
	if (in_array(x('article_id'), explode(',', $_COOKIE['bookmarks']))&&$_GET['bookmarks']!='remove'
		||$_GET['bookmarks']=='add')
		{
		$data=array('article_id'=>x('article_id'), 'bookmarks' => 'remove');
		if (x('category_id')) { $data['category_id']=x('category_id'); }
		$link=href('article', $data);
		$bookmarks="<a href='{$link}'>"._e('remove_from_bookmarks')."</a>";
		}
	}


/** Helpful **************************************************************************************************/

// posted helpful
if ($_GET['helpful']&&!$_COOKIE['helpful_'.x('article_id')])
	{
	set_cookie('helpful_'.x('article_id'), $_GET['helpful'], (time()+(365*86400)));
	}

// set display for helpful
$link=href('article', array('article_id' => x('article_id'), 'helpful' => 'yes'));
$helpful="<a href='{$link}'>"._e('helpful')."</a>";

$link=href('article', array('article_id' => x('article_id'), 'helpful' => 'no'));
$not_helpful="<a href='{$link}'>"._e('not_helpful')."</a>";

if ($_COOKIE['helpful_'.x('article_id')]||$did_vote)
	{
	$total_votes=$article['helpful']+$article['not_helpful'];
	$percent_helpful=($article['helpful']>0)?(round($article['helpful']/$total_votes, 2)*100):0;
	$percent_not_helpful=($article['not_helpful']>0)?(round($article['not_helpful']/$total_votes, 2)*100):0;


	$helpful='<b>'._e('yes').'</b>';
	$helpful.="&nbsp;";
	$helpful.="<img class='icon' src='templates/".config('template')."/images/helpful_a.gif' />";
	$helpful.="<img class='icon' src='templates/".config('template')."/images/helpful.gif' style='width: {$percent_helpful}px; height: 9px;' title='{$percent_helpful}%' />";
	$helpful.="<img class='icon' src='templates/".config('template')."/images/helpful_b.gif' />";


	$not_helpful='<b>'._e('no').'</b>';
	$not_helpful.="&nbsp;&nbsp;";
	$not_helpful.="<img class='icon' src='templates/".config('template')."/images/not_helpful_a.gif' />";
	$not_helpful.="<img class='icon' src='templates/".config('template')."/images/not_helpful.gif' style='width: {$percent_not_helpful}px; height: 9px;' title='{$percent_not_helpful}%' />";
	$not_helpful.="<img class='icon' src='templates/".config('template')."/images/not_helpful_b.gif' />";
	}

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare($data)
	{
	$buffer=array();

	for ($i=0; $i<=2; $i++)
		{
		if (!$data[$i]) { continue; }

		// the category icon
		$buffer[$i]['icon']='';
		if ($data[$i]['icon'])
			{
			$buffer[$i]['icon']="templates/".config('template')."/images/icons/{$data[$i]['icon']}";
			}

		$buffer[$i]['link_out']=href('listings', array('category_id' => $data[$i]['id']));
		$buffer[$i]['name']=$data[$i]['name'];
		$buffer[$i]['article_count']=$data[$i]['article_count'];

		// the category description
		$buffer[$i]['description']='';
		if ($data[$i]['description'])
			{
			$buffer[$i]['description']="<div>{$data[$i]['description']}</div>";
			}
		}

	return $buffer;
	}

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_blocks($data)
	{
	$buffer=array();

	// the article icon
	$icon='';
	if ($data['icon'])
		{
		$buffer['icon']="templates/".config('template')."/images/icons/{$data['icon']}";
		}

	$buffer['link_out']=href('article', array('article_id' => $data['id']));

	$buffer['title']=$data['title'];

	return $buffer;
	}
?>