<?PHP if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_kb::bookmarks(
		$conf['api_handler'], 
		$conf['api_key'], 
		'kb', 
		'bookmarks', 
		false, // set to true for debug 
		$_COOKIE['bookmarks']
		);

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];

if ($conf['site']['status']=='Down for Maintenance')
	{
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}

$breadcrumb=breadcrumb($request['breadcrumb']);
$articles=$request['articles'];
foreach ($articles as $key => $article)
	{
	$article[$key]['icon']="templates/".config('template')."/images/icons/{$article['icon']}";
	}
unset($request);

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_blocks($data)
	{
	$buffer=array();

	// the article icon
	$icon='';
	if ($data['icon'])
		{
		$buffer['icon']="templates/".config('template')."/images/icons/{$data['icon']}";
		}

	$buffer['link_out']=href('article', array('article_id' => $data['id']));

	$buffer['title']=$data['title'];

	return $buffer;
	}
?>